"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceType = exports.ManagedRuleIdentifiers = exports.CustomRule = exports.ManagedRule = exports.MaximumExecutionFrequency = exports.RuleScope = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("@aws-cdk/aws-events");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const config_generated_1 = require("./config.generated");
/**
 * A new or imported rule.
 */
class RuleBase extends core_1.Resource {
    /**
     * Defines an EventBridge event rule which triggers for rule events. Use
     * `rule.addEventPattern(pattern)` to specify a filter.
     */
    onEvent(id, options = {}) {
        const rule = new events.Rule(this, id, options);
        rule.addEventPattern({
            source: ['aws.config'],
            detail: {
                configRuleName: [this.configRuleName],
            },
        });
        rule.addTarget(options.target);
        return rule;
    }
    /**
     * Defines an EventBridge event rule which triggers for rule compliance events.
     */
    onComplianceChange(id, options = {}) {
        const rule = this.onEvent(id, options);
        rule.addEventPattern({
            detailType: ['Config Rules Compliance Change'],
        });
        return rule;
    }
    /**
     * Defines an EventBridge event rule which triggers for rule re-evaluation status events.
     */
    onReEvaluationStatus(id, options = {}) {
        const rule = this.onEvent(id, options);
        rule.addEventPattern({
            detailType: ['Config Rules Re-evaluation Status'],
        });
        return rule;
    }
}
/**
 * A new managed or custom rule.
 */
class RuleNew extends RuleBase {
    /**
     * Imports an existing rule.
     *
     * @param configRuleName the name of the rule
     */
    static fromConfigRuleName(scope, id, configRuleName) {
        class Import extends RuleBase {
            constructor() {
                super(...arguments);
                this.configRuleName = configRuleName;
            }
        }
        return new Import(scope, id);
    }
}
/**
 * Determines which resources trigger an evaluation of an AWS Config rule.
 */
class RuleScope {
    constructor(resourceId, resourceTypes, tagKey, tagValue) {
        this.resourceTypes = resourceTypes;
        this.resourceId = resourceId;
        this.key = tagKey;
        this.value = tagValue;
    }
    /** restricts scope of changes to a specific resource type or resource identifier */
    static fromResource(resourceType, resourceId) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_config_ResourceType(resourceType);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromResource);
            }
            throw error;
        }
        return new RuleScope(resourceId, [resourceType]);
    }
    /** restricts scope of changes to specific resource types */
    static fromResources(resourceTypes) {
        return new RuleScope(undefined, resourceTypes);
    }
    /** restricts scope of changes to a specific tag */
    static fromTag(key, value) {
        return new RuleScope(undefined, undefined, key, value);
    }
}
exports.RuleScope = RuleScope;
_a = JSII_RTTI_SYMBOL_1;
RuleScope[_a] = { fqn: "@aws-cdk/aws-config.RuleScope", version: "1.163.2" };
/**
 * The maximum frequency at which the AWS Config rule runs evaluations.
 */
var MaximumExecutionFrequency;
(function (MaximumExecutionFrequency) {
    /**
     * 1 hour.
     */
    MaximumExecutionFrequency["ONE_HOUR"] = "One_Hour";
    /**
     * 3 hours.
     */
    MaximumExecutionFrequency["THREE_HOURS"] = "Three_Hours";
    /**
     * 6 hours.
     */
    MaximumExecutionFrequency["SIX_HOURS"] = "Six_Hours";
    /**
     * 12 hours.
     */
    MaximumExecutionFrequency["TWELVE_HOURS"] = "Twelve_Hours";
    /**
     * 24 hours.
     */
    MaximumExecutionFrequency["TWENTY_FOUR_HOURS"] = "TwentyFour_Hours";
})(MaximumExecutionFrequency = exports.MaximumExecutionFrequency || (exports.MaximumExecutionFrequency = {}));
/**
 * A new managed rule.
 *
 * @resource AWS::Config::ConfigRule
 */
class ManagedRule extends RuleNew {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.configRuleName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_config_ManagedRuleProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ManagedRule);
            }
            throw error;
        }
        this.ruleScope = props.ruleScope;
        const rule = new config_generated_1.CfnConfigRule(this, 'Resource', {
            configRuleName: this.physicalName,
            description: props.description,
            inputParameters: props.inputParameters,
            maximumExecutionFrequency: props.maximumExecutionFrequency,
            scope: core_1.Lazy.any({ produce: () => renderScope(this.ruleScope) }),
            source: {
                owner: 'AWS',
                sourceIdentifier: props.identifier,
            },
        });
        this.configRuleName = rule.ref;
        this.configRuleArn = rule.attrArn;
        this.configRuleId = rule.attrConfigRuleId;
        this.configRuleComplianceType = rule.attrComplianceType;
        this.isManaged = true;
    }
}
exports.ManagedRule = ManagedRule;
_b = JSII_RTTI_SYMBOL_1;
ManagedRule[_b] = { fqn: "@aws-cdk/aws-config.ManagedRule", version: "1.163.2" };
/**
 * A new custom rule.
 *
 * @resource AWS::Config::ConfigRule
 */
class CustomRule extends RuleNew {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.configRuleName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_config_CustomRuleProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CustomRule);
            }
            throw error;
        }
        if (!props.configurationChanges && !props.periodic) {
            throw new Error('At least one of `configurationChanges` or `periodic` must be set to true.');
        }
        const sourceDetails = [];
        this.ruleScope = props.ruleScope;
        if (props.configurationChanges) {
            sourceDetails.push({
                eventSource: 'aws.config',
                messageType: 'ConfigurationItemChangeNotification',
            });
            sourceDetails.push({
                eventSource: 'aws.config',
                messageType: 'OversizedConfigurationItemChangeNotification',
            });
        }
        if (props.periodic) {
            sourceDetails.push({
                eventSource: 'aws.config',
                maximumExecutionFrequency: props.maximumExecutionFrequency,
                messageType: 'ScheduledNotification',
            });
        }
        props.lambdaFunction.addPermission('Permission', {
            principal: new iam.ServicePrincipal('config.amazonaws.com'),
            sourceAccount: this.env.account,
        });
        if (props.lambdaFunction.role) {
            props.lambdaFunction.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSConfigRulesExecutionRole'));
        }
        // The lambda permission must be created before the rule
        this.node.addDependency(props.lambdaFunction);
        const rule = new config_generated_1.CfnConfigRule(this, 'Resource', {
            configRuleName: this.physicalName,
            description: props.description,
            inputParameters: props.inputParameters,
            maximumExecutionFrequency: props.maximumExecutionFrequency,
            scope: core_1.Lazy.any({ produce: () => renderScope(this.ruleScope) }),
            source: {
                owner: 'CUSTOM_LAMBDA',
                sourceDetails,
                sourceIdentifier: props.lambdaFunction.functionArn,
            },
        });
        this.configRuleName = rule.ref;
        this.configRuleArn = rule.attrArn;
        this.configRuleId = rule.attrConfigRuleId;
        this.configRuleComplianceType = rule.attrComplianceType;
        if (props.configurationChanges) {
            this.isCustomWithChanges = true;
        }
    }
}
exports.CustomRule = CustomRule;
_c = JSII_RTTI_SYMBOL_1;
CustomRule[_c] = { fqn: "@aws-cdk/aws-config.CustomRule", version: "1.163.2" };
/**
 * Managed rules that are supported by AWS Config.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html
 */
class ManagedRuleIdentifiers {
    // utility class
    constructor() { }
}
exports.ManagedRuleIdentifiers = ManagedRuleIdentifiers;
_d = JSII_RTTI_SYMBOL_1;
ManagedRuleIdentifiers[_d] = { fqn: "@aws-cdk/aws-config.ManagedRuleIdentifiers", version: "1.163.2" };
/**
 * Checks that the inline policies attached to your AWS Identity and Access Management users,
 * roles, and groups do not allow blocked actions on all AWS Key Management Service keys.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-inline-policy-blocked-kms-actions.html
 */
ManagedRuleIdentifiers.IAM_INLINE_POLICY_BLOCKED_KMS_ACTIONS = 'IAM_INLINE_POLICY_BLOCKED_KMS_ACTIONS';
/**
 * Checks that the managed AWS Identity and Access Management policies that you create do not
 * allow blocked actions on all AWS AWS KMS keys.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-customer-policy-blocked-kms-actions.html
 */
ManagedRuleIdentifiers.IAM_CUSTOMER_POLICY_BLOCKED_KMS_ACTIONS = 'IAM_CUSTOMER_POLICY_BLOCKED_KMS_ACTIONS';
/**
 * Checks whether the active access keys are rotated within the number of days specified in maxAccessKeyAge.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/access-keys-rotated.html
 */
ManagedRuleIdentifiers.ACCESS_KEYS_ROTATED = 'ACCESS_KEYS_ROTATED';
/**
 * Checks whether AWS account is part of AWS Organizations.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/account-part-of-organizations.html
 */
ManagedRuleIdentifiers.ACCOUNT_PART_OF_ORGANIZATIONS = 'ACCOUNT_PART_OF_ORGANIZATIONS';
/**
 * Checks whether ACM Certificates in your account are marked for expiration within the specified number of days.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/acm-certificate-expiration-check.html
 */
ManagedRuleIdentifiers.ACM_CERTIFICATE_EXPIRATION_CHECK = 'ACM_CERTIFICATE_EXPIRATION_CHECK';
/**
 * Checks if rule evaluates Application Load Balancers (ALBs) to ensure they are configured to drop http headers.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/alb-http-drop-invalid-header-enabled.html
 */
ManagedRuleIdentifiers.ALB_HTTP_DROP_INVALID_HEADER_ENABLED = 'ALB_HTTP_DROP_INVALID_HEADER_ENABLED';
/**
 * Checks whether HTTP to HTTPS redirection is configured on all HTTP listeners of Application Load Balancer.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/alb-http-to-https-redirection-check.html
 */
ManagedRuleIdentifiers.ALB_HTTP_TO_HTTPS_REDIRECTION_CHECK = 'ALB_HTTP_TO_HTTPS_REDIRECTION_CHECK';
/**
 * Checks if Web Application Firewall (WAF) is enabled on Application Load Balancers (ALBs).
 * @see https://docs.aws.amazon.com/config/latest/developerguide/alb-waf-enabled.html
 */
ManagedRuleIdentifiers.ALB_WAF_ENABLED = 'ALB_WAF_ENABLED';
/**
 * Checks that all methods in Amazon API Gateway stages have caching enabled and encrypted.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/api-gw-cache-enabled-and-encrypted.html
 */
ManagedRuleIdentifiers.API_GW_CACHE_ENABLED_AND_ENCRYPTED = 'API_GW_CACHE_ENABLED_AND_ENCRYPTED';
/**
 * Checks that Amazon API Gateway APIs are of the type specified in the rule parameter endpointConfigurationType.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/api-gw-endpoint-type-check.html
 */
ManagedRuleIdentifiers.API_GW_ENDPOINT_TYPE_CHECK = 'API_GW_ENDPOINT_TYPE_CHECK';
/**
 * Checks that all methods in Amazon API Gateway stage has logging enabled.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/api-gw-execution-logging-enabled.html
 */
ManagedRuleIdentifiers.API_GW_EXECUTION_LOGGING_ENABLED = 'API_GW_EXECUTION_LOGGING_ENABLED';
/**
 * Checks whether running instances are using specified AMIs.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/approved-amis-by-id.html
 */
ManagedRuleIdentifiers.APPROVED_AMIS_BY_ID = 'APPROVED_AMIS_BY_ID';
/**
 * Checks whether running instances are using specified AMIs.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/approved-amis-by-tag.html
 */
ManagedRuleIdentifiers.APPROVED_AMIS_BY_TAG = 'APPROVED_AMIS_BY_TAG';
/**
 * Checks whether your Auto Scaling groups that are associated with a load balancer are using
 * Elastic Load Balancing health checks.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/autoscaling-group-elb-healthcheck-required.html
 */
ManagedRuleIdentifiers.AUTOSCALING_GROUP_ELB_HEALTHCHECK_REQUIRED = 'AUTOSCALING_GROUP_ELB_HEALTHCHECK_REQUIRED';
/**
 * Checks whether an AWS CloudFormation stack's actual configuration differs, or has drifted,
 * from it's expected configuration.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-drift-detection-check.html
 */
ManagedRuleIdentifiers.CLOUDFORMATION_STACK_DRIFT_DETECTION_CHECK = 'CLOUDFORMATION_STACK_DRIFT_DETECTION_CHECK';
/**
 * Checks whether your CloudFormation stacks are sending event notifications to an SNS topic.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudformation-stack-notification-check.html
 */
ManagedRuleIdentifiers.CLOUDFORMATION_STACK_NOTIFICATION_CHECK = 'CLOUDFORMATION_STACK_NOTIFICATION_CHECK';
/**
 * Checks if an Amazon CloudFront distribution is configured to return a specific object that is the default root object.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-default-root-object-configured.html
 */
ManagedRuleIdentifiers.CLOUDFRONT_DEFAULT_ROOT_OBJECT_CONFIGURED = 'CLOUDFRONT_DEFAULT_ROOT_OBJECT_CONFIGURED';
/**
 * Checks that Amazon CloudFront distribution with Amazon S3 Origin type has Origin Access Identity (OAI) configured.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-origin-access-identity-enabled.html
 */
ManagedRuleIdentifiers.CLOUDFRONT_ORIGIN_ACCESS_IDENTITY_ENABLED = 'CLOUDFRONT_ORIGIN_ACCESS_IDENTITY_ENABLED';
/** Checks whether an origin group is configured for the distribution of at least 2 origins in the
 * origin group for Amazon CloudFront.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-origin-failover-enabled.html
 */
ManagedRuleIdentifiers.CLOUDFRONT_ORIGIN_FAILOVER_ENABLED = 'CLOUDFRONT_ORIGIN_FAILOVER_ENABLED';
/**
 * Checks if Amazon CloudFront distributions are using a custom SSL certificate and are configured
 * to use SNI to serve HTTPS requests.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-sni-enabled.html
 */
ManagedRuleIdentifiers.CLOUDFRONT_SNI_ENABLED = 'CLOUDFRONT_SNI_ENABLED';
/** Checks whether your Amazon CloudFront distributions use HTTPS (directly or via a redirection).
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudfront-viewer-policy-https.html
 */
ManagedRuleIdentifiers.CLOUDFRONT_VIEWER_POLICY_HTTPS = 'CLOUDFRONT_VIEWER_POLICY_HTTPS';
/**
 * Checks whether AWS CloudTrail trails are configured to send logs to Amazon CloudWatch Logs.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-cloud-watch-logs-enabled.html
 */
ManagedRuleIdentifiers.CLOUD_TRAIL_CLOUD_WATCH_LOGS_ENABLED = 'CLOUD_TRAIL_CLOUD_WATCH_LOGS_ENABLED';
/**
 * Checks whether AWS CloudTrail is enabled in your AWS account.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-enabled.html
 */
ManagedRuleIdentifiers.CLOUD_TRAIL_ENABLED = 'CLOUD_TRAIL_ENABLED';
/**
 * Checks whether AWS CloudTrail is configured to use the server side encryption (SSE)
 * AWS Key Management Service (AWS KMS) customer master key (CMK) encryption.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-encryption-enabled.html
 */
ManagedRuleIdentifiers.CLOUD_TRAIL_ENCRYPTION_ENABLED = 'CLOUD_TRAIL_ENCRYPTION_ENABLED';
/**
 * Checks whether AWS CloudTrail creates a signed digest file with logs.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloud-trail-log-file-validation-enabled.html
 */
ManagedRuleIdentifiers.CLOUD_TRAIL_LOG_FILE_VALIDATION_ENABLED = 'CLOUD_TRAIL_LOG_FILE_VALIDATION_ENABLED';
/**
 * Checks whether at least one AWS CloudTrail trail is logging Amazon S3 data events for all S3 buckets.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-s3-dataevents-enabled.html
 */
ManagedRuleIdentifiers.CLOUDTRAIL_S3_DATAEVENTS_ENABLED = 'CLOUDTRAIL_S3_DATAEVENTS_ENABLED';
/**
 * Checks that there is at least one AWS CloudTrail trail defined with security best practices.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudtrail-security-trail-enabled.html
 */
ManagedRuleIdentifiers.CLOUDTRAIL_SECURITY_TRAIL_ENABLED = 'CLOUDTRAIL_SECURITY_TRAIL_ENABLED';
/**
 * Checks whether CloudWatch alarms have at least one alarm action, one INSUFFICIENT_DATA action,
 * or one OK action enabled.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-action-check.html
 */
ManagedRuleIdentifiers.CLOUDWATCH_ALARM_ACTION_CHECK = 'CLOUDWATCH_ALARM_ACTION_CHECK';
/**
 * Checks whether the specified resource type has a CloudWatch alarm for the specified metric.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-resource-check.html
 */
ManagedRuleIdentifiers.CLOUDWATCH_ALARM_RESOURCE_CHECK = 'CLOUDWATCH_ALARM_RESOURCE_CHECK';
/**
 * Checks whether CloudWatch alarms with the given metric name have the specified settings.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-alarm-settings-check.html
 */
ManagedRuleIdentifiers.CLOUDWATCH_ALARM_SETTINGS_CHECK = 'CLOUDWATCH_ALARM_SETTINGS_CHECK';
/**
 * Checks whether a log group in Amazon CloudWatch Logs is encrypted with
 * a AWS Key Management Service (KMS) managed Customer Master Keys (CMK).
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cloudwatch-log-group-encrypted.html
 */
ManagedRuleIdentifiers.CLOUDWATCH_LOG_GROUP_ENCRYPTED = 'CLOUDWATCH_LOG_GROUP_ENCRYPTED';
/**
 * Checks that key rotation is enabled for each key and matches to the key ID of the
 * customer created customer master key (CMK).
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cmk-backing-key-rotation-enabled.html
 */
ManagedRuleIdentifiers.CMK_BACKING_KEY_ROTATION_ENABLED = 'CMK_BACKING_KEY_ROTATION_ENABLED';
/**
 * Checks whether the project contains environment variables AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-envvar-awscred-check.html
 */
ManagedRuleIdentifiers.CODEBUILD_PROJECT_ENVVAR_AWSCRED_CHECK = 'CODEBUILD_PROJECT_ENVVAR_AWSCRED_CHECK';
/**
 * Checks whether the GitHub or Bitbucket source repository URL contains either personal access tokens
 * or user name and password.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/codebuild-project-source-repo-url-check.html
 */
ManagedRuleIdentifiers.CODEBUILD_PROJECT_SOURCE_REPO_URL_CHECK = 'CODEBUILD_PROJECT_SOURCE_REPO_URL_CHECK';
/**
 * Checks whether the first deployment stage of the AWS CodePipeline performs more than one deployment.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/codepipeline-deployment-count-check.html
 */
ManagedRuleIdentifiers.CODEPIPELINE_DEPLOYMENT_COUNT_CHECK = 'CODEPIPELINE_DEPLOYMENT_COUNT_CHECK';
/**
 * Checks whether each stage in the AWS CodePipeline deploys to more than N times the number of
 * the regions the AWS CodePipeline has deployed in all the previous combined stages,
 * where N is the region fanout number.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/codepipeline-region-fanout-check.html
 */
ManagedRuleIdentifiers.CODEPIPELINE_REGION_FANOUT_CHECK = 'CODEPIPELINE_REGION_FANOUT_CHECK';
/**
 * Checks whether Amazon CloudWatch LogGroup retention period is set to specific number of days.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/cw-loggroup-retention-period-check.html
 */
ManagedRuleIdentifiers.CW_LOGGROUP_RETENTION_PERIOD_CHECK = 'CW_LOGGROUP_RETENTION_PERIOD_CHECK';
/**
 * Checks that DynamoDB Accelerator (DAX) clusters are encrypted.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dax-encryption-enabled.html
 */
ManagedRuleIdentifiers.DAX_ENCRYPTION_ENABLED = 'DAX_ENCRYPTION_ENABLED';
/**
 * Checks whether RDS DB instances have backups enabled.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/db-instance-backup-enabled.html
 */
ManagedRuleIdentifiers.RDS_DB_INSTANCE_BACKUP_ENABLED = 'DB_INSTANCE_BACKUP_ENABLED';
/**
 * Checks instances for specified tenancy.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/desired-instance-tenancy.html
 */
ManagedRuleIdentifiers.EC2_DESIRED_INSTANCE_TENANCY = 'DESIRED_INSTANCE_TENANCY';
/**
 * Checks whether your EC2 instances are of the specified instance types.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/desired-instance-type.html
 */
ManagedRuleIdentifiers.EC2_DESIRED_INSTANCE_TYPE = 'DESIRED_INSTANCE_TYPE';
/**
 * Checks whether AWS Database Migration Service replication instances are public.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dms-replication-not-public.html
 */
ManagedRuleIdentifiers.DMS_REPLICATION_NOT_PUBLIC = 'DMS_REPLICATION_NOT_PUBLIC';
/**
 * Checks whether Auto Scaling or On-Demand is enabled on your DynamoDB tables and/or global secondary indexes.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-autoscaling-enabled.html
 */
ManagedRuleIdentifiers.DYNAMODB_AUTOSCALING_ENABLED = 'DYNAMODB_AUTOSCALING_ENABLED';
/**
 * Checks whether Amazon DynamoDB table is present in AWS Backup plans.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-in-backup-plan.html
 */
ManagedRuleIdentifiers.DYNAMODB_IN_BACKUP_PLAN = 'DYNAMODB_IN_BACKUP_PLAN';
/**
 * Checks that point in time recovery (PITR) is enabled for Amazon DynamoDB tables.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-pitr-enabled.html
 */
ManagedRuleIdentifiers.DYNAMODB_PITR_ENABLED = 'DYNAMODB_PITR_ENABLED';
/**
 * Checks whether Amazon DynamoDB table is encrypted with AWS Key Management Service (KMS).
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-table-encrypted-kms.html
 */
ManagedRuleIdentifiers.DYNAMODB_TABLE_ENCRYPTED_KMS = 'DYNAMODB_TABLE_ENCRYPTED_KMS';
/**
 * Checks whether the Amazon DynamoDB tables are encrypted and checks their status.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-table-encryption-enabled.html
 */
ManagedRuleIdentifiers.DYNAMODB_TABLE_ENCRYPTION_ENABLED = 'DYNAMODB_TABLE_ENCRYPTION_ENABLED';
/**
 * Checks whether provisioned DynamoDB throughput is approaching the maximum limit for your account.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/dynamodb-throughput-limit-check.html
 */
ManagedRuleIdentifiers.DYNAMODB_THROUGHPUT_LIMIT_CHECK = 'DYNAMODB_THROUGHPUT_LIMIT_CHECK';
/**
 * Checks if Amazon Elastic Block Store (Amazon EBS) volumes are added in backup plans of AWS Backup.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ebs-in-backup-plan.html
 */
ManagedRuleIdentifiers.EBS_IN_BACKUP_PLAN = 'EBS_IN_BACKUP_PLAN';
/**
 * Checks whether Amazon Elastic File System (Amazon EFS) file systems are added
 * in the backup plans of AWS Backup.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/efs-in-backup-plan.html
 */
ManagedRuleIdentifiers.EFS_IN_BACKUP_PLAN = 'EFS_IN_BACKUP_PLAN';
/**
 * Check that Amazon Elastic Block Store (EBS) encryption is enabled by default.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-ebs-encryption-by-default.html
 */
ManagedRuleIdentifiers.EC2_EBS_ENCRYPTION_BY_DEFAULT = 'EC2_EBS_ENCRYPTION_BY_DEFAULT';
/**
 * Checks whether EBS optimization is enabled for your EC2 instances that can be EBS-optimized.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ebs-optimized-instance.html
 */
ManagedRuleIdentifiers.EBS_OPTIMIZED_INSTANCE = 'EBS_OPTIMIZED_INSTANCE';
/**
 * Checks whether Amazon Elastic Block Store snapshots are not publicly restorable.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ebs-snapshot-public-restorable-check.html
 */
ManagedRuleIdentifiers.EBS_SNAPSHOT_PUBLIC_RESTORABLE_CHECK = 'EBS_SNAPSHOT_PUBLIC_RESTORABLE_CHECK';
/**
 * Checks whether detailed monitoring is enabled for EC2 instances.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-detailed-monitoring-enabled.html
 */
ManagedRuleIdentifiers.EC2_INSTANCE_DETAILED_MONITORING_ENABLED = 'EC2_INSTANCE_DETAILED_MONITORING_ENABLED';
/**
 * Checks whether the Amazon EC2 instances in your account are managed by AWS Systems Manager.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-managed-by-systems-manager.html
 */
ManagedRuleIdentifiers.EC2_INSTANCE_MANAGED_BY_SSM = 'EC2_INSTANCE_MANAGED_BY_SSM';
/**
 * Checks if an Amazon Elastic Compute Cloud (Amazon EC2) instance has an Identity and Access
 * Management (IAM) profile attached to it. This rule is NON_COMPLIANT if no IAM profile is
 * attached to the Amazon EC2 instance.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-profile-attached.html
 */
ManagedRuleIdentifiers.EC2_INSTANCE_PROFILE_ATTACHED = 'EC2_INSTANCE_PROFILE_ATTACHED';
/**
 * Checks whether Amazon Elastic Compute Cloud (Amazon EC2) instances have a public IP association.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-instance-no-public-ip.html
 */
ManagedRuleIdentifiers.EC2_INSTANCE_NO_PUBLIC_IP = 'EC2_INSTANCE_NO_PUBLIC_IP';
/**
 * Checks whether your EC2 instances belong to a virtual private cloud (VPC).
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-instances-in-vpc.html
 */
ManagedRuleIdentifiers.EC2_INSTANCES_IN_VPC = 'INSTANCES_IN_VPC';
/**
 * Checks that none of the specified applications are installed on the instance.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-applications-blacklisted.html
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_APPLICATIONS_BLOCKED = 'EC2_MANAGEDINSTANCE_APPLICATIONS_BLACKLISTED';
/**
 * Checks whether all of the specified applications are installed on the instance.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-applications-required.html
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_APPLICATIONS_REQUIRED = 'EC2_MANAGEDINSTANCE_APPLICATIONS_REQUIRED';
/**
 * Checks whether the compliance status of AWS Systems Manager association compliance is COMPLIANT
 * or NON_COMPLIANT after the association execution on the instance.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-association-compliance-status-check.html
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_ASSOCIATION_COMPLIANCE_STATUS_CHECK = 'EC2_MANAGEDINSTANCE_ASSOCIATION_COMPLIANCE_STATUS_CHECK';
/**
 * Checks whether instances managed by AWS Systems Manager are configured to collect blocked inventory types.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-inventory-blacklisted.html
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_INVENTORY_BLOCKED = 'EC2_MANAGEDINSTANCE_INVENTORY_BLACKLISTED';
/**
 * Checks whether the compliance status of the Amazon EC2 Systems Manager patch compliance is
 * COMPLIANT or NON_COMPLIANT after the patch installation on the instance.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-patch-compliance-status-check.html
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_PATCH_COMPLIANCE_STATUS_CHECK = 'EC2_MANAGEDINSTANCE_PATCH_COMPLIANCE_STATUS_CHECK';
/**
 * Checks whether EC2 managed instances have the desired configurations.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-managedinstance-platform-check.html
 */
ManagedRuleIdentifiers.EC2_MANAGED_INSTANCE_PLATFORM_CHECK = 'EC2_MANAGEDINSTANCE_PLATFORM_CHECK';
/**
 * Checks that security groups are attached to Amazon Elastic Compute Cloud (Amazon EC2) instances
 * or to an elastic network interface.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-security-group-attached-to-eni.html
 */
ManagedRuleIdentifiers.EC2_SECURITY_GROUP_ATTACHED_TO_ENI = 'EC2_SECURITY_GROUP_ATTACHED_TO_ENI';
/**
 * Checks whether there are instances stopped for more than the allowed number of days.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-stopped-instance.html
 */
ManagedRuleIdentifiers.EC2_STOPPED_INSTANCE = 'EC2_STOPPED_INSTANCE';
/**
 * Checks whether EBS volumes are attached to EC2 instances.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-volume-inuse-check.html
 */
ManagedRuleIdentifiers.EC2_VOLUME_INUSE_CHECK = 'EC2_VOLUME_INUSE_CHECK';
/**
 * hecks whether Amazon Elastic File System (Amazon EFS) is configured to encrypt the file data
 * using AWS Key Management Service (AWS KMS).
 * @see https://docs.aws.amazon.com/config/latest/developerguide/efs-encrypted-check.html
 */
ManagedRuleIdentifiers.EFS_ENCRYPTED_CHECK = 'EFS_ENCRYPTED_CHECK';
/**
 * Checks whether all Elastic IP addresses that are allocated to a VPC are attached to
 * EC2 instances or in-use elastic network interfaces (ENIs).
 * @see https://docs.aws.amazon.com/config/latest/developerguide/eip-attached.html
 */
ManagedRuleIdentifiers.EIP_ATTACHED = 'EIP_ATTACHED';
/**
 * Checks whether Amazon Elasticsearch Service (Amazon ES) domains have encryption
 * at rest configuration enabled.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-encrypted-at-rest.html
 */
ManagedRuleIdentifiers.ELASTICSEARCH_ENCRYPTED_AT_REST = 'ELASTICSEARCH_ENCRYPTED_AT_REST';
/**
 * Checks whether Amazon Elasticsearch Service (Amazon ES) domains are in
 * Amazon Virtual Private Cloud (Amazon VPC).
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-in-vpc-only.html
 */
ManagedRuleIdentifiers.ELASTICSEARCH_IN_VPC_ONLY = 'ELASTICSEARCH_IN_VPC_ONLY';
/**
 * Check if the Amazon ElastiCache Redis clusters have automatic backup turned on.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elasticache-redis-cluster-automatic-backup-check.html
 */
ManagedRuleIdentifiers.ELASTICACHE_REDIS_CLUSTER_AUTOMATIC_BACKUP_CHECK = 'ELASTICACHE_REDIS_CLUSTER_AUTOMATIC_BACKUP_CHECK';
/**
 * Checks whether your Amazon Elastic Compute Cloud (Amazon EC2) instance metadata version
 * is configured with Instance Metadata Service Version 2 (IMDSv2).
 * @see https://docs.aws.amazon.com/config/latest/developerguide/ec2-imdsv2-check.html
 */
ManagedRuleIdentifiers.EC2_IMDSV2_CHECK = 'EC2_IMDSV2_CHECK';
/**
 * Checks whether Amazon Elastic Kubernetes Service (Amazon EKS) endpoint is not publicly accessible.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/eks-endpoint-no-public-access.html
 */
ManagedRuleIdentifiers.EKS_ENDPOINT_NO_PUBLIC_ACCESS = 'EKS_ENDPOINT_NO_PUBLIC_ACCESS';
/**
 * Checks whether Amazon Elastic Kubernetes Service clusters are configured to have Kubernetes
 * secrets encrypted using AWS Key Management Service (KMS) keys.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/eks-secrets-encrypted.html
 */
ManagedRuleIdentifiers.EKS_SECRETS_ENCRYPTED = 'EKS_SECRETS_ENCRYPTED';
/**
 * Check that Amazon ElasticSearch Service nodes are encrypted end to end.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elasticsearch-node-to-node-encryption-check.html
 */
ManagedRuleIdentifiers.ELASTICSEARCH_NODE_TO_NODE_ENCRYPTION_CHECK = 'ELASTICSEARCH_NODE_TO_NODE_ENCRYPTION_CHECK';
/**
 * Checks if cross-zone load balancing is enabled for the Classic Load Balancers (CLBs).
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-cross-zone-load-balancing-enabled.html
 */
ManagedRuleIdentifiers.ELB_CROSS_ZONE_LOAD_BALANCING_ENABLED = 'ELB_CROSS_ZONE_LOAD_BALANCING_ENABLED';
/**
 * Checks whether your Classic Load Balancer is configured with SSL or HTTPS listeners.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-tls-https-listeners-only.html
 */
ManagedRuleIdentifiers.ELB_TLS_HTTPS_LISTENERS_ONLY = 'ELB_TLS_HTTPS_LISTENERS_ONLY';
/**
 * Checks whether the Classic Load Balancers use SSL certificates provided by AWS Certificate Manager.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-acm-certificate-required.html
 */
ManagedRuleIdentifiers.ELB_ACM_CERTIFICATE_REQUIRED = 'ELB_ACM_CERTIFICATE_REQUIRED';
/**
 * Checks whether your Classic Load Balancer SSL listeners are using a custom policy.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-custom-security-policy-ssl-check.html
 */
ManagedRuleIdentifiers.ELB_CUSTOM_SECURITY_POLICY_SSL_CHECK = 'ELB_CUSTOM_SECURITY_POLICY_SSL_CHECK';
/**
 * Checks whether Elastic Load Balancing has deletion protection enabled.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-deletion-protection-enabled.html
 */
ManagedRuleIdentifiers.ELB_DELETION_PROTECTION_ENABLED = 'ELB_DELETION_PROTECTION_ENABLED';
/**
 * Checks whether the Application Load Balancer and the Classic Load Balancer have logging enabled.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-logging-enabled.html
 */
ManagedRuleIdentifiers.ELB_LOGGING_ENABLED = 'ELB_LOGGING_ENABLED';
/**
 * Checks whether your Classic Load Balancer SSL listeners are using a predefined policy.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/elb-predefined-security-policy-ssl-check.html
 */
ManagedRuleIdentifiers.ELB_PREDEFINED_SECURITY_POLICY_SSL_CHECK = 'ELB_PREDEFINED_SECURITY_POLICY_SSL_CHECK';
/**
 * Checks that Amazon EMR clusters have Kerberos enabled.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/emr-kerberos-enabled.html
 */
ManagedRuleIdentifiers.EMR_KERBEROS_ENABLED = 'EMR_KERBEROS_ENABLED';
/**
 * Checks whether Amazon Elastic MapReduce (EMR) clusters' master nodes have public IPs.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/emr-master-no-public-ip.html
 */
ManagedRuleIdentifiers.EMR_MASTER_NO_PUBLIC_IP = 'EMR_MASTER_NO_PUBLIC_IP';
/**
 * Checks whether the EBS volumes that are in an attached state are encrypted.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/encrypted-volumes.html
 */
ManagedRuleIdentifiers.EBS_ENCRYPTED_VOLUMES = 'ENCRYPTED_VOLUMES';
/**
 * Checks whether the security groups associated inScope resources are compliant with the
 * master security groups at each rule level based on allowSecurityGroup and denySecurityGroup flag.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-audit-policy-check.html
 */
ManagedRuleIdentifiers.FMS_SECURITY_GROUP_AUDIT_POLICY_CHECK = 'FMS_SECURITY_GROUP_AUDIT_POLICY_CHECK';
/**
 * Checks whether AWS Firewall Manager created security groups content is the same as the master security groups.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-content-check.html
 */
ManagedRuleIdentifiers.FMS_SECURITY_GROUP_CONTENT_CHECK = 'FMS_SECURITY_GROUP_CONTENT_CHECK';
/**
 * Checks whether Amazon EC2 or an elastic network interface is associated with AWS Firewall Manager security groups.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-security-group-resource-association-check.html
 */
ManagedRuleIdentifiers.FMS_SECURITY_GROUP_RESOURCE_ASSOCIATION_CHECK = 'FMS_SECURITY_GROUP_RESOURCE_ASSOCIATION_CHECK';
/**
 * Checks whether an Application Load Balancer, Amazon CloudFront distributions,
 * Elastic Load Balancer or Elastic IP has AWS Shield protection.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-shield-resource-policy-check.html
 */
ManagedRuleIdentifiers.FMS_SHIELD_RESOURCE_POLICY_CHECK = 'FMS_SHIELD_RESOURCE_POLICY_CHECK';
/**
 * Checks whether the web ACL is associated with an Application Load Balancer, API Gateway stage,
 * or Amazon CloudFront distributions.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-webacl-resource-policy-check.html
 */
ManagedRuleIdentifiers.FMS_WEBACL_RESOURCE_POLICY_CHECK = 'FMS_WEBACL_RESOURCE_POLICY_CHECK';
/**
 * Checks that the rule groups associate with the web ACL at the correct priority.
 * The correct priority is decided by the rank of the rule groups in the ruleGroups parameter.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/fms-webacl-rulegroup-association-check.html
 */
ManagedRuleIdentifiers.FMS_WEBACL_RULEGROUP_ASSOCIATION_CHECK = 'FMS_WEBACL_RULEGROUP_ASSOCIATION_CHECK';
/**
 * Checks whether Amazon GuardDuty is enabled in your AWS account and region. If you provide an AWS account for centralization,
 * the rule evaluates the Amazon GuardDuty results in the centralized account.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/guardduty-enabled-centralized.html
 */
ManagedRuleIdentifiers.GUARDDUTY_ENABLED_CENTRALIZED = 'GUARDDUTY_ENABLED_CENTRALIZED';
/**
 * Checks whether the Amazon GuardDuty has findings that are non archived.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/guardduty-non-archived-findings.html
 */
ManagedRuleIdentifiers.GUARDDUTY_NON_ARCHIVED_FINDINGS = 'GUARDDUTY_NON_ARCHIVED_FINDINGS';
/**
 * Checks that inline policy feature is not in use.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-no-inline-policy-check.html
 */
ManagedRuleIdentifiers.IAM_NO_INLINE_POLICY_CHECK = 'IAM_NO_INLINE_POLICY_CHECK';
/**
 * Checks whether IAM groups have at least one IAM user.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-group-has-users-check.html
 */
ManagedRuleIdentifiers.IAM_GROUP_HAS_USERS_CHECK = 'IAM_GROUP_HAS_USERS_CHECK';
/**
 * Checks whether the account password policy for IAM users meets the specified requirements
 * indicated in the parameters.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-password-policy.html
 */
ManagedRuleIdentifiers.IAM_PASSWORD_POLICY = 'IAM_PASSWORD_POLICY';
/**
 * Checks whether for each IAM resource, a policy ARN in the input parameter is attached to the IAM resource.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-blacklisted-check.html
 */
ManagedRuleIdentifiers.IAM_POLICY_BLOCKED_CHECK = 'IAM_POLICY_BLACKLISTED_CHECK';
/**
 * Checks whether the IAM policy ARN is attached to an IAM user, or an IAM group with one or more IAM users,
 * or an IAM role with one or more trusted entity.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-in-use.html
 */
ManagedRuleIdentifiers.IAM_POLICY_IN_USE = 'IAM_POLICY_IN_USE';
/**
 * Checks the IAM policies that you create for Allow statements that grant permissions to all actions on all resources.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-policy-no-statements-with-admin-access.html
 */
ManagedRuleIdentifiers.IAM_POLICY_NO_STATEMENTS_WITH_ADMIN_ACCESS = 'IAM_POLICY_NO_STATEMENTS_WITH_ADMIN_ACCESS';
/**
 * Checks that AWS Identity and Access Management (IAM) policies in a list of policies are attached to all AWS roles.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-role-managed-policy-check.html
 */
ManagedRuleIdentifiers.IAM_ROLE_MANAGED_POLICY_CHECK = 'IAM_ROLE_MANAGED_POLICY_CHECK';
/**
 * Checks whether the root user access key is available.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-root-access-key-check.html
 */
ManagedRuleIdentifiers.IAM_ROOT_ACCESS_KEY_CHECK = 'IAM_ROOT_ACCESS_KEY_CHECK';
/**
 * Checks whether IAM users are members of at least one IAM group.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-user-group-membership-check.html
 */
ManagedRuleIdentifiers.IAM_USER_GROUP_MEMBERSHIP_CHECK = 'IAM_USER_GROUP_MEMBERSHIP_CHECK';
/**
 * Checks whether the AWS Identity and Access Management users have multi-factor authentication (MFA) enabled.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-user-mfa-enabled.html
 */
ManagedRuleIdentifiers.IAM_USER_MFA_ENABLED = 'IAM_USER_MFA_ENABLED';
/**
 * Checks that none of your IAM users have policies attached. IAM users must inherit permissions from IAM groups or roles.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-user-no-policies-check.html
 */
ManagedRuleIdentifiers.IAM_USER_NO_POLICIES_CHECK = 'IAM_USER_NO_POLICIES_CHECK';
/**
 * Checks whether your AWS Identity and Access Management (IAM) users have passwords or
 * active access keys that have not been used within the specified number of days you provided.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/iam-user-unused-credentials-check.html
 */
ManagedRuleIdentifiers.IAM_USER_UNUSED_CREDENTIALS_CHECK = 'IAM_USER_UNUSED_CREDENTIALS_CHECK';
/**
 * Checks that Internet gateways (IGWs) are only attached to an authorized Amazon Virtual Private Cloud (VPCs).
 * @see https://docs.aws.amazon.com/config/latest/developerguide/internet-gateway-authorized-vpc-only.html
 */
ManagedRuleIdentifiers.INTERNET_GATEWAY_AUTHORIZED_VPC_ONLY = 'INTERNET_GATEWAY_AUTHORIZED_VPC_ONLY';
/**
 * Checks whether customer master keys (CMKs) are not scheduled for deletion in AWS Key Management Service (KMS).
 * @see https://docs.aws.amazon.com/config/latest/developerguide/kms-cmk-not-scheduled-for-deletion.html
 */
ManagedRuleIdentifiers.KMS_CMK_NOT_SCHEDULED_FOR_DELETION = 'KMS_CMK_NOT_SCHEDULED_FOR_DELETION';
/**
 * Checks whether the AWS Lambda function is configured with function-level concurrent execution limit.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/lambda-concurrency-check.html
 */
ManagedRuleIdentifiers.LAMBDA_CONCURRENCY_CHECK = 'LAMBDA_CONCURRENCY_CHECK';
/**
 * Checks whether an AWS Lambda function is configured with a dead-letter queue.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/lambda-dlq-check.html
 */
ManagedRuleIdentifiers.LAMBDA_DLQ_CHECK = 'LAMBDA_DLQ_CHECK';
/**
 * Checks whether the AWS Lambda function policy attached to the Lambda resource prohibits public access.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/lambda-function-public-access-prohibited.html
 */
ManagedRuleIdentifiers.LAMBDA_FUNCTION_PUBLIC_ACCESS_PROHIBITED = 'LAMBDA_FUNCTION_PUBLIC_ACCESS_PROHIBITED';
/**
 * Checks that the lambda function settings for runtime, role, timeout, and memory size match the expected values.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/lambda-function-settings-check.html
 */
ManagedRuleIdentifiers.LAMBDA_FUNCTION_SETTINGS_CHECK = 'LAMBDA_FUNCTION_SETTINGS_CHECK';
/**
 * Checks whether an AWS Lambda function is in an Amazon Virtual Private Cloud.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/lambda-inside-vpc.html
 */
ManagedRuleIdentifiers.LAMBDA_INSIDE_VPC = 'LAMBDA_INSIDE_VPC';
/**
 * Checks whether AWS Multi-Factor Authentication (MFA) is enabled for all IAM users that use a console password.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/mfa-enabled-for-iam-console-access.html
 */
ManagedRuleIdentifiers.MFA_ENABLED_FOR_IAM_CONSOLE_ACCESS = 'MFA_ENABLED_FOR_IAM_CONSOLE_ACCESS';
/**
 * Checks that there is at least one multi-region AWS CloudTrail.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/multi-region-cloudtrail-enabled.html
 */
ManagedRuleIdentifiers.CLOUDTRAIL_MULTI_REGION_ENABLED = 'MULTI_REGION_CLOUD_TRAIL_ENABLED';
/**
 * Checks if an Amazon Relational Database Service (Amazon RDS) cluster has deletion protection enabled.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-cluster-deletion-protection-enabled.html
 */
ManagedRuleIdentifiers.RDS_CLUSTER_DELETION_PROTECTION_ENABLED = 'RDS_CLUSTER_DELETION_PROTECTION_ENABLED';
/**
 * Checks if an Amazon Relational Database Service (Amazon RDS) instance has deletion protection enabled.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-deletion-protection-enabled.html
 */
ManagedRuleIdentifiers.RDS_INSTANCE_DELETION_PROTECTION_ENABLED = 'RDS_INSTANCE_DELETION_PROTECTION_ENABLED';
/**
 * Checks if an Amazon RDS instance has AWS Identity and Access Management (IAM) authentication enabled.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-iam-authentication-enabled.html
 */
ManagedRuleIdentifiers.RDS_INSTANCE_IAM_AUTHENTICATION_ENABLED = 'RDS_INSTANCE_IAM_AUTHENTICATION_ENABLED';
/**
 * Checks that respective logs of Amazon Relational Database Service (Amazon RDS) are enabled.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-logging-enabled.html
 */
ManagedRuleIdentifiers.RDS_LOGGING_ENABLED = 'RDS_LOGGING_ENABLED';
/**
 * Checks that Amazon Redshift automated snapshots are enabled for clusters.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/redshift-backup-enabled.html
 */
ManagedRuleIdentifiers.REDSHIFT_BACKUP_ENABLED = 'REDSHIFT_BACKUP_ENABLED';
/**
 * Checks whether enhanced monitoring is enabled for Amazon Relational Database Service (Amazon RDS) instances.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-enhanced-monitoring-enabled.html
 */
ManagedRuleIdentifiers.RDS_ENHANCED_MONITORING_ENABLED = 'RDS_ENHANCED_MONITORING_ENABLED';
/**
 * Checks whether Amazon Relational Database Service (Amazon RDS) DB snapshots are encrypted.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-snapshot-encrypted.html
 */
ManagedRuleIdentifiers.RDS_SNAPSHOT_ENCRYPTED = 'RDS_SNAPSHOT_ENCRYPTED';
/**
 * Checks whether Amazon Redshift clusters require TLS/SSL encryption to connect to SQL clients.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/redshift-require-tls-ssl.html
 */
ManagedRuleIdentifiers.REDSHIFT_REQUIRE_TLS_SSL = 'REDSHIFT_REQUIRE_TLS_SSL';
/**
 * Checks whether Amazon RDS database is present in back plans of AWS Backup.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-in-backup-plan.html
 */
ManagedRuleIdentifiers.RDS_IN_BACKUP_PLAN = 'RDS_IN_BACKUP_PLAN';
/**
 * Check whether the Amazon Relational Database Service instances are not publicly accessible.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-instance-public-access-check.html
 */
ManagedRuleIdentifiers.RDS_INSTANCE_PUBLIC_ACCESS_CHECK = 'RDS_INSTANCE_PUBLIC_ACCESS_CHECK';
/**
 * Checks whether high availability is enabled for your RDS DB instances.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-multi-az-support.html
 */
ManagedRuleIdentifiers.RDS_MULTI_AZ_SUPPORT = 'RDS_MULTI_AZ_SUPPORT';
/**
 * Checks if Amazon Relational Database Service (Amazon RDS) snapshots are public.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-snapshots-public-prohibited.html
 */
ManagedRuleIdentifiers.RDS_SNAPSHOTS_PUBLIC_PROHIBITED = 'RDS_SNAPSHOTS_PUBLIC_PROHIBITED';
/**
 * Checks whether storage encryption is enabled for your RDS DB instances.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/rds-storage-encrypted.html
 */
ManagedRuleIdentifiers.RDS_STORAGE_ENCRYPTED = 'RDS_STORAGE_ENCRYPTED';
/**
 * Checks whether Amazon Redshift clusters have the specified settings.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-configuration-check.html
 */
ManagedRuleIdentifiers.REDSHIFT_CLUSTER_CONFIGURATION_CHECK = 'REDSHIFT_CLUSTER_CONFIGURATION_CHECK';
/**
 * Checks whether Amazon Redshift clusters have the specified maintenance settings.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-maintenancesettings-check.html
 */
ManagedRuleIdentifiers.REDSHIFT_CLUSTER_MAINTENANCE_SETTINGS_CHECK = 'REDSHIFT_CLUSTER_MAINTENANCESETTINGS_CHECK';
/**
 * Checks whether Amazon Redshift clusters are not publicly accessible.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/redshift-cluster-public-access-check.html
 */
ManagedRuleIdentifiers.REDSHIFT_CLUSTER_PUBLIC_ACCESS_CHECK = 'REDSHIFT_CLUSTER_PUBLIC_ACCESS_CHECK';
/**
 * Checks whether your resources have the tags that you specify.
 * For example, you can check whether your Amazon EC2 instances have the CostCenter tag.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/required-tags.html
 */
ManagedRuleIdentifiers.REQUIRED_TAGS = 'REQUIRED_TAGS';
/**
 * Checks whether the security groups in use do not allow unrestricted incoming TCP traffic to the specified ports.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/restricted-common-ports.html
 */
ManagedRuleIdentifiers.EC2_SECURITY_GROUPS_RESTRICTED_INCOMING_TRAFFIC = 'RESTRICTED_INCOMING_TRAFFIC';
/**
 * Checks whether the incoming SSH traffic for the security groups is accessible.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/restricted-ssh.html
 */
ManagedRuleIdentifiers.EC2_SECURITY_GROUPS_INCOMING_SSH_DISABLED = 'INCOMING_SSH_DISABLED';
/**
 * Checks whether your AWS account is enabled to use multi-factor authentication (MFA) hardware
 * device to sign in with root credentials.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/root-account-hardware-mfa-enabled.html
 */
ManagedRuleIdentifiers.ROOT_ACCOUNT_HARDWARE_MFA_ENABLED = 'ROOT_ACCOUNT_HARDWARE_MFA_ENABLED';
/**
 * Checks whether users of your AWS account require a multi-factor authentication (MFA) device
 * to sign in with root credentials.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/root-account-mfa-enabled.html
 */
ManagedRuleIdentifiers.ROOT_ACCOUNT_MFA_ENABLED = 'ROOT_ACCOUNT_MFA_ENABLED';
/**
 * Checks whether Amazon Simple Storage Service (Amazon S3) bucket has lock enabled, by default.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-default-lock-enabled.html
 */
ManagedRuleIdentifiers.S3_BUCKET_DEFAULT_LOCK_ENABLED = 'S3_BUCKET_DEFAULT_LOCK_ENABLED';
/**
 * Checks whether the Amazon Simple Storage Service (Amazon S3) buckets are encrypted
 * with AWS Key Management Service (AWS KMS).
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-default-encryption-kms.html
 */
ManagedRuleIdentifiers.S3_DEFAULT_ENCRYPTION_KMS = 'S3_DEFAULT_ENCRYPTION_KMS';
/**
 * Checks that AWS Security Hub is enabled for an AWS account.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/securityhub-enabled.html
 */
ManagedRuleIdentifiers.SECURITYHUB_ENABLED = 'SECURITYHUB_ENABLED';
/**
 * Checks whether Amazon SNS topic is encrypted with AWS Key Management Service (AWS KMS).
 * @see https://docs.aws.amazon.com/config/latest/developerguide/sns-encrypted-kms.html
 */
ManagedRuleIdentifiers.SNS_ENCRYPTED_KMS = 'SNS_ENCRYPTED_KMS';
/**
 * Checks whether the required public access block settings are configured from account level.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-account-level-public-access-blocks.html
 */
ManagedRuleIdentifiers.S3_ACCOUNT_LEVEL_PUBLIC_ACCESS_BLOCKS = 'S3_ACCOUNT_LEVEL_PUBLIC_ACCESS_BLOCKS';
/**
 * Checks if Amazon Simple Storage Service (Amazon S3) buckets are publicly accessible. This rule is
 * NON_COMPLIANT if an Amazon S3 bucket is not listed in the excludedPublicBuckets parameter and bucket level
 * settings are public.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-level-public-access-prohibited.html
 */
ManagedRuleIdentifiers.S3_BUCKET_LEVEL_PUBLIC_ACCESS_PROHIBITED = 'S3_BUCKET_LEVEL_PUBLIC_ACCESS_PROHIBITED';
/**
 * Checks that the Amazon Simple Storage Service bucket policy does not allow
 * blocked bucket-level and object-level actions on resources in the bucket
 * for principals from other AWS accounts.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-blacklisted-actions-prohibited.html
 */
ManagedRuleIdentifiers.S3_BUCKET_BLOCKED_ACTIONS_PROHIBITED = 'S3_BUCKET_BLACKLISTED_ACTIONS_PROHIBITED';
/**
 * Verifies that your Amazon Simple Storage Service bucket policies do not allow
 * other inter-account permissions than the control Amazon S3 bucket policy provided.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy-not-more-permissive.html
 */
ManagedRuleIdentifiers.S3_BUCKET_POLICY_NOT_MORE_PERMISSIVE = 'S3_BUCKET_POLICY_NOT_MORE_PERMISSIVE';
/**
 * Checks whether logging is enabled for your S3 buckets.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-logging-enabled.html
 */
ManagedRuleIdentifiers.S3_BUCKET_LOGGING_ENABLED = 'S3_BUCKET_LOGGING_ENABLED';
/**
 * Checks that the access granted by the Amazon S3 bucket is restricted by any of the AWS principals,
 * federated users, service principals, IP addresses, or VPCs that you provide.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy-grantee-check.html
 */
ManagedRuleIdentifiers.S3_BUCKET_POLICY_GRANTEE_CHECK = 'S3_BUCKET_POLICY_GRANTEE_CHECK';
/**
 * Checks that your Amazon S3 buckets do not allow public read access.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-public-read-prohibited.html
 */
ManagedRuleIdentifiers.S3_BUCKET_PUBLIC_READ_PROHIBITED = 'S3_BUCKET_PUBLIC_READ_PROHIBITED';
/**
 * Checks that your Amazon S3 buckets do not allow public write access.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-public-write-prohibited.html
 */
ManagedRuleIdentifiers.S3_BUCKET_PUBLIC_WRITE_PROHIBITED = 'S3_BUCKET_PUBLIC_WRITE_PROHIBITED';
/**
 * Checks whether S3 buckets have cross-region replication enabled.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-replication-enabled.html
 */
ManagedRuleIdentifiers.S3_BUCKET_REPLICATION_ENABLED = 'S3_BUCKET_REPLICATION_ENABLED';
/**
 * Checks that your Amazon S3 bucket either has Amazon S3 default encryption enabled or that the
 * S3 bucket policy explicitly denies put-object requests without server side encryption that
 * uses AES-256 or AWS Key Management Service.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-server-side-encryption-enabled.html
 */
ManagedRuleIdentifiers.S3_BUCKET_SERVER_SIDE_ENCRYPTION_ENABLED = 'S3_BUCKET_SERVER_SIDE_ENCRYPTION_ENABLED';
/**
 * Checks whether S3 buckets have policies that require requests to use Secure Socket Layer (SSL).
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-ssl-requests-only.html
 */
ManagedRuleIdentifiers.S3_BUCKET_SSL_REQUESTS_ONLY = 'S3_BUCKET_SSL_REQUESTS_ONLY';
/**
 * Checks whether versioning is enabled for your S3 buckets.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-versioning-enabled.html
 */
ManagedRuleIdentifiers.S3_BUCKET_VERSIONING_ENABLED = 'S3_BUCKET_VERSIONING_ENABLED';
/**
 * Checks whether AWS Key Management Service (KMS) key is configured for an Amazon SageMaker endpoint configuration.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-endpoint-configuration-kms-key-configured.html
 */
ManagedRuleIdentifiers.SAGEMAKER_ENDPOINT_CONFIGURATION_KMS_KEY_CONFIGURED = 'SAGEMAKER_ENDPOINT_CONFIGURATION_KMS_KEY_CONFIGURED';
/**
 * Check whether an AWS Key Management Service (KMS) key is configured for SageMaker notebook instance.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-notebook-instance-kms-key-configured.html
 */
ManagedRuleIdentifiers.SAGEMAKER_NOTEBOOK_INSTANCE_KMS_KEY_CONFIGURED = 'SAGEMAKER_NOTEBOOK_INSTANCE_KMS_KEY_CONFIGURED';
/**
 * Checks whether direct internet access is disabled for an Amazon SageMaker notebook instance.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/sagemaker-notebook-no-direct-internet-access.html
 */
ManagedRuleIdentifiers.SAGEMAKER_NOTEBOOK_NO_DIRECT_INTERNET_ACCESS = 'SAGEMAKER_NOTEBOOK_NO_DIRECT_INTERNET_ACCESS';
/**
 * Checks whether AWS Secrets Manager secret has rotation enabled.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-rotation-enabled-check.html
 */
ManagedRuleIdentifiers.SECRETSMANAGER_ROTATION_ENABLED_CHECK = 'SECRETSMANAGER_ROTATION_ENABLED_CHECK';
/**
 * Checks whether AWS Secrets Manager secret rotation has rotated successfully as per the rotation schedule.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/secretsmanager-scheduled-rotation-success-check.html
 */
ManagedRuleIdentifiers.SECRETSMANAGER_SCHEDULED_ROTATION_SUCCESS_CHECK = 'SECRETSMANAGER_SCHEDULED_ROTATION_SUCCESS_CHECK';
/**
 * Checks whether Service Endpoint for the service provided in rule parameter is created for each Amazon VPC.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/service-vpc-endpoint-enabled.html
 */
ManagedRuleIdentifiers.SERVICE_VPC_ENDPOINT_ENABLED = 'SERVICE_VPC_ENDPOINT_ENABLED';
/**
 * Checks whether EBS volumes are attached to EC2 instances.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/shield-advanced-enabled-autorenew.html
 */
ManagedRuleIdentifiers.SHIELD_ADVANCED_ENABLED_AUTO_RENEW = 'SHIELD_ADVANCED_ENABLED_AUTORENEW';
/**
 * Verify that DDoS response team (DRT) can access AWS account.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/shield-drt-access.html
 */
ManagedRuleIdentifiers.SHIELD_DRT_ACCESS = 'SHIELD_DRT_ACCESS';
/**
 * Checks that the default security group of any Amazon Virtual Private Cloud (VPC) does not
 * allow inbound or outbound traffic. The rule returns NOT_APPLICABLE if the security group
 * is not default.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/vpc-default-security-group-closed.html
 */
ManagedRuleIdentifiers.VPC_DEFAULT_SECURITY_GROUP_CLOSED = 'VPC_DEFAULT_SECURITY_GROUP_CLOSED';
/**
 * Checks whether Amazon Virtual Private Cloud flow logs are found and enabled for Amazon VPC.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/vpc-flow-logs-enabled.html
 */
ManagedRuleIdentifiers.VPC_FLOW_LOGS_ENABLED = 'VPC_FLOW_LOGS_ENABLED';
/**
 * Checks whether the security group with 0.0.0.0/0 of any Amazon Virtual Private Cloud (Amazon VPC)
 * allows only specific inbound TCP or UDP traffic.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/vpc-sg-open-only-to-authorized-ports.html
 */
ManagedRuleIdentifiers.VPC_SG_OPEN_ONLY_TO_AUTHORIZED_PORTS = 'VPC_SG_OPEN_ONLY_TO_AUTHORIZED_PORTS';
/**
 * Checks that both AWS Virtual Private Network tunnels provided by AWS Site-to-Site VPN are in
 * UP status.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/vpc-vpn-2-tunnels-up.html
 */
ManagedRuleIdentifiers.VPC_VPN_2_TUNNELS_UP = 'VPC_VPN_2_TUNNELS_UP';
/**
 * Checks if logging is enabled on AWS Web Application Firewall (WAF) classic global web ACLs.
 * @see https://docs.aws.amazon.com/config/latest/developerguide/waf-classic-logging-enabled.html
 */
ManagedRuleIdentifiers.WAF_CLASSIC_LOGGING_ENABLED = 'WAF_CLASSIC_LOGGING_ENABLED';
/**
 * Checks whether logging is enabled on AWS Web Application Firewall (WAFV2) regional and global
 * web access control list (ACLs).
 * @see https://docs.aws.amazon.com/config/latest/developerguide/wafv2-logging-enabled.html
 */
ManagedRuleIdentifiers.WAFV2_LOGGING_ENABLED = 'WAFV2_LOGGING_ENABLED';
/**
 * Resources types that are supported by AWS Config
 * @see https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html
 */
class ResourceType {
    constructor(type) {
        this.complianceResourceType = type;
    }
    /** A custom resource type to support future cases. */
    static of(type) {
        return new ResourceType(type);
    }
}
exports.ResourceType = ResourceType;
_e = JSII_RTTI_SYMBOL_1;
ResourceType[_e] = { fqn: "@aws-cdk/aws-config.ResourceType", version: "1.163.2" };
/** API Gateway Stage */
ResourceType.APIGATEWAY_STAGE = new ResourceType('AWS::ApiGateway::Stage');
/** API Gatewayv2 Stage */
ResourceType.APIGATEWAYV2_STAGE = new ResourceType('AWS::ApiGatewayV2::Stage');
/** API Gateway REST API */
ResourceType.APIGATEWAY_REST_API = new ResourceType('AWS::ApiGateway::RestApi');
/** API Gatewayv2 API */
ResourceType.APIGATEWAYV2_API = new ResourceType('AWS::ApiGatewayV2::Api');
/** Amazon CloudFront Distribution */
ResourceType.CLOUDFRONT_DISTRIBUTION = new ResourceType('AWS::CloudFront::Distribution');
/** Amazon CloudFront streaming distribution */
ResourceType.CLOUDFRONT_STREAMING_DISTRIBUTION = new ResourceType('AWS::CloudFront::StreamingDistribution');
/** Amazon CloudWatch Alarm */
ResourceType.CLOUDWATCH_ALARM = new ResourceType('AWS::CloudWatch::Alarm');
/** Amazon DynamoDB Table */
ResourceType.DYNAMODB_TABLE = new ResourceType('AWS::DynamoDB::Table');
/** Elastic Block Store (EBS) volume */
ResourceType.EBS_VOLUME = new ResourceType('AWS::EC2::Volume');
/** EC2 host */
ResourceType.EC2_HOST = new ResourceType('AWS::EC2::Host');
/** EC2 Elastic IP */
ResourceType.EC2_EIP = new ResourceType('AWS::EC2::EIP');
/** EC2 instance */
ResourceType.EC2_INSTANCE = new ResourceType('AWS::EC2::Instance');
/** EC2 security group */
ResourceType.EC2_SECURITY_GROUP = new ResourceType('AWS::EC2::SecurityGroup');
/** EC2 NAT gateway */
ResourceType.EC2_NAT_GATEWAY = new ResourceType('AWS::EC2::NatGateway');
/** EC2 Egress only internet gateway */
ResourceType.EC2_EGRESS_ONLY_INTERNET_GATEWAY = new ResourceType('AWS::EC2::EgressOnlyInternetGateway');
/** EC2 flow log */
ResourceType.EC2_FLOW_LOG = new ResourceType('AWS::EC2::FlowLog');
/** EC2 VPC endpoint */
ResourceType.EC2_VPC_ENDPOINT = new ResourceType('AWS::EC2::VPCEndpoint');
/** EC2 VPC endpoint service */
ResourceType.EC2_VPC_ENDPOINT_SERVICE = new ResourceType('AWS::EC2::VPCEndpointService');
/** EC2 VPC peering connection */
ResourceType.EC2_VPC_PEERING_CONNECTION = new ResourceType('AWS::EC2::VPCPeeringConnection');
/** Amazon ElasticSearch domain */
ResourceType.ELASTICSEARCH_DOMAIN = new ResourceType('AWS::Elasticsearch::Domain');
/** Amazon QLDB ledger */
ResourceType.QLDB_LEDGER = new ResourceType('AWS::QLDB::Ledger');
/** Amazon Redshift cluster */
ResourceType.REDSHIFT_CLUSTER = new ResourceType('AWS::Redshift::Cluster');
/** Amazon Redshift cluster parameter group */
ResourceType.REDSHIFT_CLUSTER_PARAMETER_GROUP = new ResourceType('AWS::Redshift::ClusterParameterGroup');
/** Amazon Redshift cluster security group */
ResourceType.REDSHIFT_CLUSTER_SECURITY_GROUP = new ResourceType('AWS::Redshift::ClusterSecurityGroup');
/** Amazon Redshift cluster snapshot */
ResourceType.REDSHIFT_CLUSTER_SNAPSHOT = new ResourceType('AWS::Redshift::ClusterSnapshot');
/** Amazon Redshift cluster subnet group */
ResourceType.REDSHIFT_CLUSTER_SUBNET_GROUP = new ResourceType('AWS::Redshift::ClusterSubnetGroup');
/** Amazon Redshift event subscription */
ResourceType.REDSHIFT_EVENT_SUBSCRIPTION = new ResourceType('AWS::Redshift::EventSubscription');
/** Amazon RDS database instance */
ResourceType.RDS_DB_INSTANCE = new ResourceType('AWS::RDS::DBInstance');
/** Amazon RDS database security group */
ResourceType.RDS_DB_SECURITY_GROUP = new ResourceType('AWS::RDS::DBSecurityGroup');
/** Amazon RDS database snapshot */
ResourceType.RDS_DB_SNAPSHOT = new ResourceType('AWS::RDS::DBSnapshot');
/** Amazon RDS database subnet group */
ResourceType.RDS_DB_SUBNET_GROUP = new ResourceType('AWS::RDS::DBSubnetGroup');
/** Amazon RDS event subscription */
ResourceType.RDS_EVENT_SUBSCRIPTION = new ResourceType('AWS::RDS::EventSubscription');
/** Amazon RDS database cluster */
ResourceType.RDS_DB_CLUSTER = new ResourceType('AWS::RDS::DBCluster');
/** Amazon RDS database cluster snapshot */
ResourceType.RDS_DB_CLUSTER_SNAPSHOT = new ResourceType('AWS::RDS::DBClusterSnapshot');
/** Amazon SQS queue */
ResourceType.SQS_QUEUE = new ResourceType('AWS::SQS::Queue');
/** Amazon SNS topic */
ResourceType.SNS_TOPIC = new ResourceType('AWS::SNS::Topic');
/** Amazon S3 bucket */
ResourceType.S3_BUCKET = new ResourceType('AWS::S3::Bucket');
/** Amazon S3 account public access block */
ResourceType.S3_ACCOUNT_PUBLIC_ACCESS_BLOCK = new ResourceType('AWS::S3::AccountPublicAccessBlock');
/** Amazon EC2 customer gateway */
ResourceType.EC2_CUSTOMER_GATEWAY = new ResourceType('AWS::EC2::CustomerGateway');
/** Amazon EC2 internet gateway */
ResourceType.EC2_INTERNET_GATEWAY = new ResourceType('AWS::EC2::InternetGateway');
/** Amazon EC2 network ACL */
ResourceType.EC2_NETWORK_ACL = new ResourceType('AWS::EC2::NetworkAcl');
/** Amazon EC2 route table */
ResourceType.EC2_ROUTE_TABLE = new ResourceType('AWS::EC2::RouteTable');
/** Amazon EC2 subnet table */
ResourceType.EC2_SUBNET = new ResourceType('AWS::EC2::Subnet');
/** Amazon EC2 VPC */
ResourceType.EC2_VPC = new ResourceType('AWS::EC2::VPC');
/** Amazon EC2 VPN connection */
ResourceType.EC2_VPN_CONNECTION = new ResourceType('AWS::EC2::VPNConnection');
/** Amazon EC2 VPN gateway */
ResourceType.EC2_VPN_GATEWAY = new ResourceType('AWS::EC2::VPNGateway');
/** AWS Auto Scaling group */
ResourceType.AUTO_SCALING_GROUP = new ResourceType('AWS::AutoScaling::AutoScalingGroup');
/** AWS Auto Scaling launch configuration */
ResourceType.AUTO_SCALING_LAUNCH_CONFIGURATION = new ResourceType('AWS::AutoScaling::LaunchConfiguration');
/** AWS Auto Scaling policy */
ResourceType.AUTO_SCALING_POLICY = new ResourceType('AWS::AutoScaling::ScalingPolicy');
/** AWS Auto Scaling scheduled action */
ResourceType.AUTO_SCALING_SCHEDULED_ACTION = new ResourceType('AWS::AutoScaling::ScheduledAction');
/** AWS Certificate manager certificate */
ResourceType.ACM_CERTIFICATE = new ResourceType('AWS::ACM::Certificate');
/** AWS CloudFormation stack */
ResourceType.CLOUDFORMATION_STACK = new ResourceType('AWS::CloudFormation::Stack');
/** AWS CloudTrail trail */
ResourceType.CLOUDTRAIL_TRAIL = new ResourceType('AWS::CloudTrail::Trail');
/** AWS CodeBuild project */
ResourceType.CODEBUILD_PROJECT = new ResourceType('AWS::CodeBuild::Project');
/** AWS CodePipeline pipeline */
ResourceType.CODEPIPELINE_PIPELINE = new ResourceType('AWS::CodePipeline::Pipeline');
/** AWS Elastic Beanstalk (EB) application */
ResourceType.ELASTIC_BEANSTALK_APPLICATION = new ResourceType('AWS::ElasticBeanstalk::Application');
/** AWS Elastic Beanstalk (EB) application version */
ResourceType.ELASTIC_BEANSTALK_APPLICATION_VERSION = new ResourceType('AWS::ElasticBeanstalk::ApplicationVersion');
/** AWS Elastic Beanstalk (EB) environment */
ResourceType.ELASTIC_BEANSTALK_ENVIRONMENT = new ResourceType('AWS::ElasticBeanstalk::Environment');
/** AWS IAM user */
ResourceType.IAM_USER = new ResourceType('AWS::IAM::User');
/** AWS IAM group */
ResourceType.IAM_GROUP = new ResourceType('AWS::IAM::Group');
/** AWS IAM role */
ResourceType.IAM_ROLE = new ResourceType('AWS::IAM::Role');
/** AWS IAM policy */
ResourceType.IAM_POLICY = new ResourceType('AWS::IAM::Policy');
/** AWS KMS Key */
ResourceType.KMS_KEY = new ResourceType('AWS::KMS::Key');
/** AWS Lambda function */
ResourceType.LAMBDA_FUNCTION = new ResourceType('AWS::Lambda::Function');
/**AWS Secrets Manager secret */
ResourceType.SECRETS_MANAGER_SECRET = new ResourceType('AWS::SecretsManager::Secret');
/** AWS Service Catalog CloudFormation product */
ResourceType.SERVICE_CATALOG_CLOUDFORMATION_PRODUCT = new ResourceType('AWS::ServiceCatalog::CloudFormationProduct');
/** AWS Service Catalog CloudFormation provisioned product */
ResourceType.SERVICE_CATALOG_CLOUDFORMATION_PROVISIONED_PRODUCT = new ResourceType('AWS::ServiceCatalog::CloudFormationProvisionedProduct');
/** AWS Service Catalog portfolio */
ResourceType.SERVICE_CATALOG_PORTFOLIO = new ResourceType('AWS::ServiceCatalog::Portfolio');
/** AWS Shield protection */
ResourceType.SHIELD_PROTECTION = new ResourceType('AWS::Shield::Protection');
/** AWS Shield regional protection */
ResourceType.SHIELD_REGIONAL_PROTECTION = new ResourceType('AWS::ShieldRegional::Protection');
/** AWS Systems Manager managed instance inventory */
ResourceType.SYSTEMS_MANAGER_MANAGED_INSTANCE_INVENTORY = new ResourceType('AWS::SSM::ManagedInstanceInventory');
/** AWS Systems Manager patch compliance */
ResourceType.SYSTEMS_MANAGER_PATCH_COMPLIANCE = new ResourceType('AWS::SSM::PatchCompliance');
/** AWS Systems Manager association compliance */
ResourceType.SYSTEMS_MANAGER_ASSOCIATION_COMPLIANCE = new ResourceType('AWS::SSM::AssociationCompliance');
/** AWS Systems Manager file data */
ResourceType.SYSTEMS_MANAGER_FILE_DATA = new ResourceType('AWS::SSM::FileData');
/** AWS WAF rate based rule */
ResourceType.WAF_RATE_BASED_RULE = new ResourceType('AWS::WAF::RateBasedRule');
/** AWS WAF rule */
ResourceType.WAF_RULE = new ResourceType('AWS::WAF::Rule');
/** AWS WAF web ACL */
ResourceType.WAF_WEB_ACL = new ResourceType('AWS::WAF::WebACL');
/** AWS WAF rule group */
ResourceType.WAF_RULE_GROUP = new ResourceType('AWS::WAF::RuleGroup');
/** AWS WAF regional rate based rule */
ResourceType.WAF_REGIONAL_RATE_BASED_RULE = new ResourceType('AWS::WAFRegional::RateBasedRule');
/** AWS WAF regional rule */
ResourceType.WAF_REGIONAL_RULE = new ResourceType('AWS::WAFRegional::Rule');
/** AWS WAF web ACL */
ResourceType.WAF_REGIONAL_WEB_ACL = new ResourceType('AWS::WAFRegional::WebACL');
/** AWS WAF regional rule group */
ResourceType.WAF_REGIONAL_RULE_GROUP = new ResourceType('AWS::WAFRegional::RuleGroup');
/** AWS WAFv2 web ACL */
ResourceType.WAFV2_WEB_ACL = new ResourceType('AWS::WAFv2::WebACL');
/** AWS WAFv2 rule group */
ResourceType.WAFV2_RULE_GROUP = new ResourceType('AWS::WAFv2::RuleGroup');
/** AWS WAFv2 managed rule set */
ResourceType.WAFV2_MANAGED_RULE_SET = new ResourceType('AWS::WAFv2::ManagedRuleSet');
/** AWS X-Ray encryption configuration */
ResourceType.XRAY_ENCRYPTION_CONFIGURATION = new ResourceType('AWS::XRay::EncryptionConfig');
/** AWS ELB classic load balancer */
ResourceType.ELB_LOAD_BALANCER = new ResourceType('AWS::ElasticLoadBalancing::LoadBalancer');
/** AWS ELBv2 network load balancer or AWS ELBv2 application load balancer */
ResourceType.ELBV2_LOAD_BALANCER = new ResourceType('AWS::ElasticLoadBalancingV2::LoadBalancer');
function renderScope(ruleScope) {
    return ruleScope ? {
        complianceResourceId: ruleScope.resourceId,
        complianceResourceTypes: ruleScope.resourceTypes?.map(resource => resource.complianceResourceType),
        tagKey: ruleScope.key,
        tagValue: ruleScope.value,
    } : undefined;
}
//# sourceMappingURL=data:application/json;base64,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