# DO NOT EDIT! This file is automatically generated

import datetime
import typing

from commercetools.types._abstract import _BaseType
from commercetools.types._common import (
    BaseResource,
    Reference,
    ReferenceTypeId,
    ResourceIdentifier,
)

if typing.TYPE_CHECKING:
    from ._common import CreatedBy, LastModifiedBy, LocalizedString
    from ._customer import CustomerReference, CustomerResourceIdentifier
    from ._product import ProductVariant
    from ._product_type import ProductTypeReference
    from ._type import (
        CustomFields,
        CustomFieldsDraft,
        FieldContainer,
        TypeResourceIdentifier,
    )
__all__ = [
    "MyShoppingList",
    "ShoppingList",
    "ShoppingListAddLineItemAction",
    "ShoppingListAddTextLineItemAction",
    "ShoppingListChangeLineItemQuantityAction",
    "ShoppingListChangeLineItemsOrderAction",
    "ShoppingListChangeNameAction",
    "ShoppingListChangeTextLineItemNameAction",
    "ShoppingListChangeTextLineItemQuantityAction",
    "ShoppingListChangeTextLineItemsOrderAction",
    "ShoppingListDraft",
    "ShoppingListLineItem",
    "ShoppingListLineItemDraft",
    "ShoppingListPagedQueryResponse",
    "ShoppingListReference",
    "ShoppingListRemoveLineItemAction",
    "ShoppingListRemoveTextLineItemAction",
    "ShoppingListResourceIdentifier",
    "ShoppingListSetAnonymousIdAction",
    "ShoppingListSetCustomFieldAction",
    "ShoppingListSetCustomTypeAction",
    "ShoppingListSetCustomerAction",
    "ShoppingListSetDeleteDaysAfterLastModificationAction",
    "ShoppingListSetDescriptionAction",
    "ShoppingListSetKeyAction",
    "ShoppingListSetLineItemCustomFieldAction",
    "ShoppingListSetLineItemCustomTypeAction",
    "ShoppingListSetSlugAction",
    "ShoppingListSetTextLineItemCustomFieldAction",
    "ShoppingListSetTextLineItemCustomTypeAction",
    "ShoppingListSetTextLineItemDescriptionAction",
    "ShoppingListUpdate",
    "ShoppingListUpdateAction",
    "TextLineItem",
    "TextLineItemDraft",
]


class MyShoppingList(BaseResource):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.MyShoppingListSchema`."
    #: :class:`str`
    id: typing.Optional[str]
    #: :class:`int`
    version: typing.Optional[int]
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: typing.Optional[datetime.datetime]
    #: :class:`datetime.datetime` `(Named` ``lastModifiedAt`` `in Commercetools)`
    last_modified_at: typing.Optional[datetime.datetime]
    #: Optional :class:`commercetools.types.LastModifiedBy` `(Named` ``lastModifiedBy`` `in Commercetools)`
    last_modified_by: typing.Optional["LastModifiedBy"]
    #: Optional :class:`commercetools.types.CreatedBy` `(Named` ``createdBy`` `in Commercetools)`
    created_by: typing.Optional["CreatedBy"]
    #: Optional :class:`commercetools.types.CustomFields`
    custom: typing.Optional["CustomFields"]
    #: Optional :class:`commercetools.types.CustomerReference`
    customer: typing.Optional["CustomerReference"]
    #: Optional :class:`int` `(Named` ``deleteDaysAfterLastModification`` `in Commercetools)`
    delete_days_after_last_modification: typing.Optional[int]
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: Optional list of :class:`commercetools.types.ShoppingListLineItem` `(Named` ``lineItems`` `in Commercetools)`
    line_items: typing.Optional[typing.List["ShoppingListLineItem"]]
    #: :class:`commercetools.types.LocalizedString`
    name: typing.Optional["LocalizedString"]
    #: Optional :class:`commercetools.types.LocalizedString`
    slug: typing.Optional["LocalizedString"]
    #: Optional list of :class:`commercetools.types.TextLineItem` `(Named` ``textLineItems`` `in Commercetools)`
    text_line_items: typing.Optional[typing.List["TextLineItem"]]
    #: Optional :class:`str` `(Named` ``anonymousId`` `in Commercetools)`
    anonymous_id: typing.Optional[str]

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        version: typing.Optional[int] = None,
        created_at: typing.Optional[datetime.datetime] = None,
        last_modified_at: typing.Optional[datetime.datetime] = None,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        custom: typing.Optional["CustomFields"] = None,
        customer: typing.Optional["CustomerReference"] = None,
        delete_days_after_last_modification: typing.Optional[int] = None,
        description: typing.Optional["LocalizedString"] = None,
        key: typing.Optional[str] = None,
        line_items: typing.Optional[typing.List["ShoppingListLineItem"]] = None,
        name: typing.Optional["LocalizedString"] = None,
        slug: typing.Optional["LocalizedString"] = None,
        text_line_items: typing.Optional[typing.List["TextLineItem"]] = None,
        anonymous_id: typing.Optional[str] = None
    ) -> None:
        self.id = id
        self.version = version
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        self.last_modified_by = last_modified_by
        self.created_by = created_by
        self.custom = custom
        self.customer = customer
        self.delete_days_after_last_modification = delete_days_after_last_modification
        self.description = description
        self.key = key
        self.line_items = line_items
        self.name = name
        self.slug = slug
        self.text_line_items = text_line_items
        self.anonymous_id = anonymous_id
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
        )

    def __repr__(self) -> str:
        return (
            "MyShoppingList(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, custom=%r, customer=%r, delete_days_after_last_modification=%r, description=%r, key=%r, line_items=%r, name=%r, slug=%r, text_line_items=%r, anonymous_id=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.custom,
                self.customer,
                self.delete_days_after_last_modification,
                self.description,
                self.key,
                self.line_items,
                self.name,
                self.slug,
                self.text_line_items,
                self.anonymous_id,
            )
        )


class ShoppingList(BaseResource):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListSchema`."
    #: :class:`str`
    id: typing.Optional[str]
    #: :class:`int`
    version: typing.Optional[int]
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: typing.Optional[datetime.datetime]
    #: :class:`datetime.datetime` `(Named` ``lastModifiedAt`` `in Commercetools)`
    last_modified_at: typing.Optional[datetime.datetime]
    #: Optional :class:`commercetools.types.LastModifiedBy` `(Named` ``lastModifiedBy`` `in Commercetools)`
    last_modified_by: typing.Optional["LastModifiedBy"]
    #: Optional :class:`commercetools.types.CreatedBy` `(Named` ``createdBy`` `in Commercetools)`
    created_by: typing.Optional["CreatedBy"]
    #: Optional :class:`commercetools.types.CustomFields`
    custom: typing.Optional["CustomFields"]
    #: Optional :class:`commercetools.types.CustomerReference`
    customer: typing.Optional["CustomerReference"]
    #: Optional :class:`int` `(Named` ``deleteDaysAfterLastModification`` `in Commercetools)`
    delete_days_after_last_modification: typing.Optional[int]
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: Optional list of :class:`commercetools.types.ShoppingListLineItem` `(Named` ``lineItems`` `in Commercetools)`
    line_items: typing.Optional[typing.List["ShoppingListLineItem"]]
    #: :class:`commercetools.types.LocalizedString`
    name: typing.Optional["LocalizedString"]
    #: Optional :class:`commercetools.types.LocalizedString`
    slug: typing.Optional["LocalizedString"]
    #: Optional list of :class:`commercetools.types.TextLineItem` `(Named` ``textLineItems`` `in Commercetools)`
    text_line_items: typing.Optional[typing.List["TextLineItem"]]
    #: Optional :class:`str` `(Named` ``anonymousId`` `in Commercetools)`
    anonymous_id: typing.Optional[str]

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        version: typing.Optional[int] = None,
        created_at: typing.Optional[datetime.datetime] = None,
        last_modified_at: typing.Optional[datetime.datetime] = None,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        custom: typing.Optional["CustomFields"] = None,
        customer: typing.Optional["CustomerReference"] = None,
        delete_days_after_last_modification: typing.Optional[int] = None,
        description: typing.Optional["LocalizedString"] = None,
        key: typing.Optional[str] = None,
        line_items: typing.Optional[typing.List["ShoppingListLineItem"]] = None,
        name: typing.Optional["LocalizedString"] = None,
        slug: typing.Optional["LocalizedString"] = None,
        text_line_items: typing.Optional[typing.List["TextLineItem"]] = None,
        anonymous_id: typing.Optional[str] = None
    ) -> None:
        self.id = id
        self.version = version
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        self.last_modified_by = last_modified_by
        self.created_by = created_by
        self.custom = custom
        self.customer = customer
        self.delete_days_after_last_modification = delete_days_after_last_modification
        self.description = description
        self.key = key
        self.line_items = line_items
        self.name = name
        self.slug = slug
        self.text_line_items = text_line_items
        self.anonymous_id = anonymous_id
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
        )

    def __repr__(self) -> str:
        return (
            "ShoppingList(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, custom=%r, customer=%r, delete_days_after_last_modification=%r, description=%r, key=%r, line_items=%r, name=%r, slug=%r, text_line_items=%r, anonymous_id=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.custom,
                self.customer,
                self.delete_days_after_last_modification,
                self.description,
                self.key,
                self.line_items,
                self.name,
                self.slug,
                self.text_line_items,
                self.anonymous_id,
            )
        )


class ShoppingListDraft(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListDraftSchema`."
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]
    #: Optional :class:`commercetools.types.CustomerResourceIdentifier`
    customer: typing.Optional["CustomerResourceIdentifier"]
    #: Optional :class:`int` `(Named` ``deleteDaysAfterLastModification`` `in Commercetools)`
    delete_days_after_last_modification: typing.Optional[int]
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: Optional list of :class:`commercetools.types.ShoppingListLineItemDraft` `(Named` ``lineItems`` `in Commercetools)`
    line_items: typing.Optional[typing.List["ShoppingListLineItemDraft"]]
    #: :class:`commercetools.types.LocalizedString`
    name: typing.Optional["LocalizedString"]
    #: Optional :class:`commercetools.types.LocalizedString`
    slug: typing.Optional["LocalizedString"]
    #: Optional list of :class:`commercetools.types.TextLineItemDraft` `(Named` ``textLineItems`` `in Commercetools)`
    text_line_items: typing.Optional[typing.List["TextLineItemDraft"]]
    #: Optional :class:`str` `(Named` ``anonymousId`` `in Commercetools)`
    anonymous_id: typing.Optional[str]

    def __init__(
        self,
        *,
        custom: typing.Optional["CustomFieldsDraft"] = None,
        customer: typing.Optional["CustomerResourceIdentifier"] = None,
        delete_days_after_last_modification: typing.Optional[int] = None,
        description: typing.Optional["LocalizedString"] = None,
        key: typing.Optional[str] = None,
        line_items: typing.Optional[typing.List["ShoppingListLineItemDraft"]] = None,
        name: typing.Optional["LocalizedString"] = None,
        slug: typing.Optional["LocalizedString"] = None,
        text_line_items: typing.Optional[typing.List["TextLineItemDraft"]] = None,
        anonymous_id: typing.Optional[str] = None
    ) -> None:
        self.custom = custom
        self.customer = customer
        self.delete_days_after_last_modification = delete_days_after_last_modification
        self.description = description
        self.key = key
        self.line_items = line_items
        self.name = name
        self.slug = slug
        self.text_line_items = text_line_items
        self.anonymous_id = anonymous_id
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ShoppingListDraft(custom=%r, customer=%r, delete_days_after_last_modification=%r, description=%r, key=%r, line_items=%r, name=%r, slug=%r, text_line_items=%r, anonymous_id=%r)"
            % (
                self.custom,
                self.customer,
                self.delete_days_after_last_modification,
                self.description,
                self.key,
                self.line_items,
                self.name,
                self.slug,
                self.text_line_items,
                self.anonymous_id,
            )
        )


class ShoppingListLineItem(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListLineItemSchema`."
    #: :class:`datetime.datetime` `(Named` ``addedAt`` `in Commercetools)`
    added_at: typing.Optional[datetime.datetime]
    #: Optional :class:`commercetools.types.CustomFields`
    custom: typing.Optional["CustomFields"]
    #: Optional :class:`datetime.datetime` `(Named` ``deactivatedAt`` `in Commercetools)`
    deactivated_at: typing.Optional[datetime.datetime]
    #: :class:`str`
    id: typing.Optional[str]
    #: :class:`commercetools.types.LocalizedString`
    name: typing.Optional["LocalizedString"]
    #: :class:`str` `(Named` ``productId`` `in Commercetools)`
    product_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.LocalizedString` `(Named` ``productSlug`` `in Commercetools)`
    product_slug: typing.Optional["LocalizedString"]
    #: :class:`commercetools.types.ProductTypeReference` `(Named` ``productType`` `in Commercetools)`
    product_type: typing.Optional["ProductTypeReference"]
    #: :class:`int`
    quantity: typing.Optional[int]
    #: Optional :class:`commercetools.types.ProductVariant`
    variant: typing.Optional["ProductVariant"]
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]

    def __init__(
        self,
        *,
        added_at: typing.Optional[datetime.datetime] = None,
        custom: typing.Optional["CustomFields"] = None,
        deactivated_at: typing.Optional[datetime.datetime] = None,
        id: typing.Optional[str] = None,
        name: typing.Optional["LocalizedString"] = None,
        product_id: typing.Optional[str] = None,
        product_slug: typing.Optional["LocalizedString"] = None,
        product_type: typing.Optional["ProductTypeReference"] = None,
        quantity: typing.Optional[int] = None,
        variant: typing.Optional["ProductVariant"] = None,
        variant_id: typing.Optional[int] = None
    ) -> None:
        self.added_at = added_at
        self.custom = custom
        self.deactivated_at = deactivated_at
        self.id = id
        self.name = name
        self.product_id = product_id
        self.product_slug = product_slug
        self.product_type = product_type
        self.quantity = quantity
        self.variant = variant
        self.variant_id = variant_id
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ShoppingListLineItem(added_at=%r, custom=%r, deactivated_at=%r, id=%r, name=%r, product_id=%r, product_slug=%r, product_type=%r, quantity=%r, variant=%r, variant_id=%r)"
            % (
                self.added_at,
                self.custom,
                self.deactivated_at,
                self.id,
                self.name,
                self.product_id,
                self.product_slug,
                self.product_type,
                self.quantity,
                self.variant,
                self.variant_id,
            )
        )


class ShoppingListLineItemDraft(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListLineItemDraftSchema`."
    #: Optional :class:`datetime.datetime` `(Named` ``addedAt`` `in Commercetools)`
    added_at: typing.Optional[datetime.datetime]
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``productId`` `in Commercetools)`
    product_id: typing.Optional[str]
    #: Optional :class:`int`
    quantity: typing.Optional[int]
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]

    def __init__(
        self,
        *,
        added_at: typing.Optional[datetime.datetime] = None,
        custom: typing.Optional["CustomFieldsDraft"] = None,
        sku: typing.Optional[str] = None,
        product_id: typing.Optional[str] = None,
        quantity: typing.Optional[int] = None,
        variant_id: typing.Optional[int] = None
    ) -> None:
        self.added_at = added_at
        self.custom = custom
        self.sku = sku
        self.product_id = product_id
        self.quantity = quantity
        self.variant_id = variant_id
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ShoppingListLineItemDraft(added_at=%r, custom=%r, sku=%r, product_id=%r, quantity=%r, variant_id=%r)"
            % (
                self.added_at,
                self.custom,
                self.sku,
                self.product_id,
                self.quantity,
                self.variant_id,
            )
        )


class ShoppingListPagedQueryResponse(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListPagedQueryResponseSchema`."
    #: :class:`int`
    limit: typing.Optional[int]
    #: :class:`int`
    count: typing.Optional[int]
    #: Optional :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    offset: typing.Optional[int]
    #: List of :class:`commercetools.types.ShoppingList`
    results: typing.Optional[typing.Sequence["ShoppingList"]]

    def __init__(
        self,
        *,
        limit: typing.Optional[int] = None,
        count: typing.Optional[int] = None,
        total: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        results: typing.Optional[typing.Sequence["ShoppingList"]] = None
    ) -> None:
        self.limit = limit
        self.count = count
        self.total = total
        self.offset = offset
        self.results = results
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ShoppingListPagedQueryResponse(limit=%r, count=%r, total=%r, offset=%r, results=%r)"
            % (self.limit, self.count, self.total, self.offset, self.results)
        )


class ShoppingListReference(Reference):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListReferenceSchema`."
    #: Optional :class:`commercetools.types.ShoppingList`
    obj: typing.Optional["ShoppingList"]

    def __init__(
        self,
        *,
        type_id: typing.Optional["ReferenceTypeId"] = None,
        id: typing.Optional[str] = None,
        obj: typing.Optional["ShoppingList"] = None
    ) -> None:
        self.obj = obj
        super().__init__(type_id=ReferenceTypeId.SHOPPING_LIST, id=id)

    def __repr__(self) -> str:
        return "ShoppingListReference(type_id=%r, id=%r, obj=%r)" % (
            self.type_id,
            self.id,
            self.obj,
        )


class ShoppingListResourceIdentifier(ResourceIdentifier):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListResourceIdentifierSchema`."

    def __init__(
        self,
        *,
        type_id: typing.Optional["ReferenceTypeId"] = None,
        id: typing.Optional[str] = None,
        key: typing.Optional[str] = None
    ) -> None:
        super().__init__(type_id=ReferenceTypeId.SHOPPING_LIST, id=id, key=key)

    def __repr__(self) -> str:
        return "ShoppingListResourceIdentifier(type_id=%r, id=%r, key=%r)" % (
            self.type_id,
            self.id,
            self.key,
        )


class ShoppingListUpdate(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListUpdateSchema`."
    #: :class:`int`
    version: typing.Optional[int]
    #: :class:`list`
    actions: typing.Optional[list]

    def __init__(
        self,
        *,
        version: typing.Optional[int] = None,
        actions: typing.Optional[list] = None
    ) -> None:
        self.version = version
        self.actions = actions
        super().__init__()

    def __repr__(self) -> str:
        return "ShoppingListUpdate(version=%r, actions=%r)" % (
            self.version,
            self.actions,
        )


class ShoppingListUpdateAction(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListUpdateActionSchema`."
    #: :class:`str`
    action: typing.Optional[str]

    def __init__(self, *, action: typing.Optional[str] = None) -> None:
        self.action = action
        super().__init__()

    def __repr__(self) -> str:
        return "ShoppingListUpdateAction(action=%r)" % (self.action,)


class TextLineItem(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.TextLineItemSchema`."
    #: :class:`datetime.datetime` `(Named` ``addedAt`` `in Commercetools)`
    added_at: typing.Optional[datetime.datetime]
    #: Optional :class:`commercetools.types.CustomFields`
    custom: typing.Optional["CustomFields"]
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]
    #: :class:`str`
    id: typing.Optional[str]
    #: :class:`commercetools.types.LocalizedString`
    name: typing.Optional["LocalizedString"]
    #: :class:`int`
    quantity: typing.Optional[int]

    def __init__(
        self,
        *,
        added_at: typing.Optional[datetime.datetime] = None,
        custom: typing.Optional["CustomFields"] = None,
        description: typing.Optional["LocalizedString"] = None,
        id: typing.Optional[str] = None,
        name: typing.Optional["LocalizedString"] = None,
        quantity: typing.Optional[int] = None
    ) -> None:
        self.added_at = added_at
        self.custom = custom
        self.description = description
        self.id = id
        self.name = name
        self.quantity = quantity
        super().__init__()

    def __repr__(self) -> str:
        return (
            "TextLineItem(added_at=%r, custom=%r, description=%r, id=%r, name=%r, quantity=%r)"
            % (
                self.added_at,
                self.custom,
                self.description,
                self.id,
                self.name,
                self.quantity,
            )
        )


class TextLineItemDraft(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.TextLineItemDraftSchema`."
    #: Optional :class:`datetime.datetime` `(Named` ``addedAt`` `in Commercetools)`
    added_at: typing.Optional[datetime.datetime]
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]
    #: :class:`commercetools.types.LocalizedString`
    name: typing.Optional["LocalizedString"]
    #: Optional :class:`int`
    quantity: typing.Optional[int]

    def __init__(
        self,
        *,
        added_at: typing.Optional[datetime.datetime] = None,
        custom: typing.Optional["CustomFieldsDraft"] = None,
        description: typing.Optional["LocalizedString"] = None,
        name: typing.Optional["LocalizedString"] = None,
        quantity: typing.Optional[int] = None
    ) -> None:
        self.added_at = added_at
        self.custom = custom
        self.description = description
        self.name = name
        self.quantity = quantity
        super().__init__()

    def __repr__(self) -> str:
        return (
            "TextLineItemDraft(added_at=%r, custom=%r, description=%r, name=%r, quantity=%r)"
            % (self.added_at, self.custom, self.description, self.name, self.quantity)
        )


class ShoppingListAddLineItemAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListAddLineItemActionSchema`."
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``productId`` `in Commercetools)`
    product_id: typing.Optional[str]
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`int`
    quantity: typing.Optional[int]
    #: Optional :class:`datetime.datetime` `(Named` ``addedAt`` `in Commercetools)`
    added_at: typing.Optional[datetime.datetime]
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        sku: typing.Optional[str] = None,
        product_id: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        quantity: typing.Optional[int] = None,
        added_at: typing.Optional[datetime.datetime] = None,
        custom: typing.Optional["CustomFieldsDraft"] = None
    ) -> None:
        self.sku = sku
        self.product_id = product_id
        self.variant_id = variant_id
        self.quantity = quantity
        self.added_at = added_at
        self.custom = custom
        super().__init__(action="addLineItem")

    def __repr__(self) -> str:
        return (
            "ShoppingListAddLineItemAction(action=%r, sku=%r, product_id=%r, variant_id=%r, quantity=%r, added_at=%r, custom=%r)"
            % (
                self.action,
                self.sku,
                self.product_id,
                self.variant_id,
                self.quantity,
                self.added_at,
                self.custom,
            )
        )


class ShoppingListAddTextLineItemAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListAddTextLineItemActionSchema`."
    #: :class:`commercetools.types.LocalizedString`
    name: typing.Optional["LocalizedString"]
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]
    #: Optional :class:`int`
    quantity: typing.Optional[int]
    #: Optional :class:`datetime.datetime` `(Named` ``addedAt`` `in Commercetools)`
    added_at: typing.Optional[datetime.datetime]
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        name: typing.Optional["LocalizedString"] = None,
        description: typing.Optional["LocalizedString"] = None,
        quantity: typing.Optional[int] = None,
        added_at: typing.Optional[datetime.datetime] = None,
        custom: typing.Optional["CustomFieldsDraft"] = None
    ) -> None:
        self.name = name
        self.description = description
        self.quantity = quantity
        self.added_at = added_at
        self.custom = custom
        super().__init__(action="addTextLineItem")

    def __repr__(self) -> str:
        return (
            "ShoppingListAddTextLineItemAction(action=%r, name=%r, description=%r, quantity=%r, added_at=%r, custom=%r)"
            % (
                self.action,
                self.name,
                self.description,
                self.quantity,
                self.added_at,
                self.custom,
            )
        )


class ShoppingListChangeLineItemQuantityAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListChangeLineItemQuantityActionSchema`."
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: typing.Optional[str]
    #: :class:`int`
    quantity: typing.Optional[int]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        line_item_id: typing.Optional[str] = None,
        quantity: typing.Optional[int] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.quantity = quantity
        super().__init__(action="changeLineItemQuantity")

    def __repr__(self) -> str:
        return (
            "ShoppingListChangeLineItemQuantityAction(action=%r, line_item_id=%r, quantity=%r)"
            % (self.action, self.line_item_id, self.quantity)
        )


class ShoppingListChangeLineItemsOrderAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListChangeLineItemsOrderActionSchema`."
    #: List of :class:`str` `(Named` ``lineItemOrder`` `in Commercetools)`
    line_item_order: typing.Optional[typing.List[str]]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        line_item_order: typing.Optional[typing.List[str]] = None
    ) -> None:
        self.line_item_order = line_item_order
        super().__init__(action="changeLineItemsOrder")

    def __repr__(self) -> str:
        return (
            "ShoppingListChangeLineItemsOrderAction(action=%r, line_item_order=%r)"
            % (self.action, self.line_item_order)
        )


class ShoppingListChangeNameAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListChangeNameActionSchema`."
    #: :class:`commercetools.types.LocalizedString`
    name: typing.Optional["LocalizedString"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        name: typing.Optional["LocalizedString"] = None
    ) -> None:
        self.name = name
        super().__init__(action="changeName")

    def __repr__(self) -> str:
        return "ShoppingListChangeNameAction(action=%r, name=%r)" % (
            self.action,
            self.name,
        )


class ShoppingListChangeTextLineItemNameAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListChangeTextLineItemNameActionSchema`."
    #: :class:`str` `(Named` ``textLineItemId`` `in Commercetools)`
    text_line_item_id: typing.Optional[str]
    #: :class:`commercetools.types.LocalizedString`
    name: typing.Optional["LocalizedString"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        text_line_item_id: typing.Optional[str] = None,
        name: typing.Optional["LocalizedString"] = None
    ) -> None:
        self.text_line_item_id = text_line_item_id
        self.name = name
        super().__init__(action="changeTextLineItemName")

    def __repr__(self) -> str:
        return (
            "ShoppingListChangeTextLineItemNameAction(action=%r, text_line_item_id=%r, name=%r)"
            % (self.action, self.text_line_item_id, self.name)
        )


class ShoppingListChangeTextLineItemQuantityAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListChangeTextLineItemQuantityActionSchema`."
    #: :class:`str` `(Named` ``textLineItemId`` `in Commercetools)`
    text_line_item_id: typing.Optional[str]
    #: :class:`int`
    quantity: typing.Optional[int]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        text_line_item_id: typing.Optional[str] = None,
        quantity: typing.Optional[int] = None
    ) -> None:
        self.text_line_item_id = text_line_item_id
        self.quantity = quantity
        super().__init__(action="changeTextLineItemQuantity")

    def __repr__(self) -> str:
        return (
            "ShoppingListChangeTextLineItemQuantityAction(action=%r, text_line_item_id=%r, quantity=%r)"
            % (self.action, self.text_line_item_id, self.quantity)
        )


class ShoppingListChangeTextLineItemsOrderAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListChangeTextLineItemsOrderActionSchema`."
    #: List of :class:`str` `(Named` ``textLineItemOrder`` `in Commercetools)`
    text_line_item_order: typing.Optional[typing.List[str]]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        text_line_item_order: typing.Optional[typing.List[str]] = None
    ) -> None:
        self.text_line_item_order = text_line_item_order
        super().__init__(action="changeTextLineItemsOrder")

    def __repr__(self) -> str:
        return (
            "ShoppingListChangeTextLineItemsOrderAction(action=%r, text_line_item_order=%r)"
            % (self.action, self.text_line_item_order)
        )


class ShoppingListRemoveLineItemAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListRemoveLineItemActionSchema`."
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: typing.Optional[str]
    #: Optional :class:`int`
    quantity: typing.Optional[int]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        line_item_id: typing.Optional[str] = None,
        quantity: typing.Optional[int] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.quantity = quantity
        super().__init__(action="removeLineItem")

    def __repr__(self) -> str:
        return (
            "ShoppingListRemoveLineItemAction(action=%r, line_item_id=%r, quantity=%r)"
            % (self.action, self.line_item_id, self.quantity)
        )


class ShoppingListRemoveTextLineItemAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListRemoveTextLineItemActionSchema`."
    #: :class:`str` `(Named` ``textLineItemId`` `in Commercetools)`
    text_line_item_id: typing.Optional[str]
    #: Optional :class:`int`
    quantity: typing.Optional[int]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        text_line_item_id: typing.Optional[str] = None,
        quantity: typing.Optional[int] = None
    ) -> None:
        self.text_line_item_id = text_line_item_id
        self.quantity = quantity
        super().__init__(action="removeTextLineItem")

    def __repr__(self) -> str:
        return (
            "ShoppingListRemoveTextLineItemAction(action=%r, text_line_item_id=%r, quantity=%r)"
            % (self.action, self.text_line_item_id, self.quantity)
        )


class ShoppingListSetAnonymousIdAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListSetAnonymousIdActionSchema`."
    #: Optional :class:`str` `(Named` ``anonymousId`` `in Commercetools)`
    anonymous_id: typing.Optional[str]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        anonymous_id: typing.Optional[str] = None
    ) -> None:
        self.anonymous_id = anonymous_id
        super().__init__(action="setAnonymousId")

    def __repr__(self) -> str:
        return "ShoppingListSetAnonymousIdAction(action=%r, anonymous_id=%r)" % (
            self.action,
            self.anonymous_id,
        )


class ShoppingListSetCustomFieldAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListSetCustomFieldActionSchema`."
    #: :class:`str`
    name: typing.Optional[str]
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        value: typing.Optional[typing.Any] = None
    ) -> None:
        self.name = name
        self.value = value
        super().__init__(action="setCustomField")

    def __repr__(self) -> str:
        return "ShoppingListSetCustomFieldAction(action=%r, name=%r, value=%r)" % (
            self.action,
            self.name,
            self.value,
        )


class ShoppingListSetCustomTypeAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListSetCustomTypeActionSchema`."
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.type = type
        self.fields = fields
        super().__init__(action="setCustomType")

    def __repr__(self) -> str:
        return "ShoppingListSetCustomTypeAction(action=%r, type=%r, fields=%r)" % (
            self.action,
            self.type,
            self.fields,
        )


class ShoppingListSetCustomerAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListSetCustomerActionSchema`."
    #: Optional :class:`commercetools.types.CustomerResourceIdentifier`
    customer: typing.Optional["CustomerResourceIdentifier"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        customer: typing.Optional["CustomerResourceIdentifier"] = None
    ) -> None:
        self.customer = customer
        super().__init__(action="setCustomer")

    def __repr__(self) -> str:
        return "ShoppingListSetCustomerAction(action=%r, customer=%r)" % (
            self.action,
            self.customer,
        )


class ShoppingListSetDeleteDaysAfterLastModificationAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListSetDeleteDaysAfterLastModificationActionSchema`."
    #: Optional :class:`int` `(Named` ``deleteDaysAfterLastModification`` `in Commercetools)`
    delete_days_after_last_modification: typing.Optional[int]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        delete_days_after_last_modification: typing.Optional[int] = None
    ) -> None:
        self.delete_days_after_last_modification = delete_days_after_last_modification
        super().__init__(action="setDeleteDaysAfterLastModification")

    def __repr__(self) -> str:
        return (
            "ShoppingListSetDeleteDaysAfterLastModificationAction(action=%r, delete_days_after_last_modification=%r)"
            % (self.action, self.delete_days_after_last_modification)
        )


class ShoppingListSetDescriptionAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListSetDescriptionActionSchema`."
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        description: typing.Optional["LocalizedString"] = None
    ) -> None:
        self.description = description
        super().__init__(action="setDescription")

    def __repr__(self) -> str:
        return "ShoppingListSetDescriptionAction(action=%r, description=%r)" % (
            self.action,
            self.description,
        )


class ShoppingListSetKeyAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListSetKeyActionSchema`."
    #: Optional :class:`str`
    key: typing.Optional[str]

    def __init__(
        self, *, action: typing.Optional[str] = None, key: typing.Optional[str] = None
    ) -> None:
        self.key = key
        super().__init__(action="setKey")

    def __repr__(self) -> str:
        return "ShoppingListSetKeyAction(action=%r, key=%r)" % (self.action, self.key)


class ShoppingListSetLineItemCustomFieldAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListSetLineItemCustomFieldActionSchema`."
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: typing.Optional[str]
    #: :class:`str`
    name: typing.Optional[str]
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        line_item_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        value: typing.Optional[typing.Any] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.name = name
        self.value = value
        super().__init__(action="setLineItemCustomField")

    def __repr__(self) -> str:
        return (
            "ShoppingListSetLineItemCustomFieldAction(action=%r, line_item_id=%r, name=%r, value=%r)"
            % (self.action, self.line_item_id, self.name, self.value)
        )


class ShoppingListSetLineItemCustomTypeAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListSetLineItemCustomTypeActionSchema`."
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        line_item_id: typing.Optional[str] = None,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.type = type
        self.fields = fields
        super().__init__(action="setLineItemCustomType")

    def __repr__(self) -> str:
        return (
            "ShoppingListSetLineItemCustomTypeAction(action=%r, line_item_id=%r, type=%r, fields=%r)"
            % (self.action, self.line_item_id, self.type, self.fields)
        )


class ShoppingListSetSlugAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListSetSlugActionSchema`."
    #: Optional :class:`commercetools.types.LocalizedString`
    slug: typing.Optional["LocalizedString"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        slug: typing.Optional["LocalizedString"] = None
    ) -> None:
        self.slug = slug
        super().__init__(action="setSlug")

    def __repr__(self) -> str:
        return "ShoppingListSetSlugAction(action=%r, slug=%r)" % (
            self.action,
            self.slug,
        )


class ShoppingListSetTextLineItemCustomFieldAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListSetTextLineItemCustomFieldActionSchema`."
    #: :class:`str` `(Named` ``textLineItemId`` `in Commercetools)`
    text_line_item_id: typing.Optional[str]
    #: :class:`str`
    name: typing.Optional[str]
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        text_line_item_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        value: typing.Optional[typing.Any] = None
    ) -> None:
        self.text_line_item_id = text_line_item_id
        self.name = name
        self.value = value
        super().__init__(action="setTextLineItemCustomField")

    def __repr__(self) -> str:
        return (
            "ShoppingListSetTextLineItemCustomFieldAction(action=%r, text_line_item_id=%r, name=%r, value=%r)"
            % (self.action, self.text_line_item_id, self.name, self.value)
        )


class ShoppingListSetTextLineItemCustomTypeAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListSetTextLineItemCustomTypeActionSchema`."
    #: :class:`str` `(Named` ``textLineItemId`` `in Commercetools)`
    text_line_item_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        text_line_item_id: typing.Optional[str] = None,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.text_line_item_id = text_line_item_id
        self.type = type
        self.fields = fields
        super().__init__(action="setTextLineItemCustomType")

    def __repr__(self) -> str:
        return (
            "ShoppingListSetTextLineItemCustomTypeAction(action=%r, text_line_item_id=%r, type=%r, fields=%r)"
            % (self.action, self.text_line_item_id, self.type, self.fields)
        )


class ShoppingListSetTextLineItemDescriptionAction(ShoppingListUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ShoppingListSetTextLineItemDescriptionActionSchema`."
    #: :class:`str` `(Named` ``textLineItemId`` `in Commercetools)`
    text_line_item_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        text_line_item_id: typing.Optional[str] = None,
        description: typing.Optional["LocalizedString"] = None
    ) -> None:
        self.text_line_item_id = text_line_item_id
        self.description = description
        super().__init__(action="setTextLineItemDescription")

    def __repr__(self) -> str:
        return (
            "ShoppingListSetTextLineItemDescriptionAction(action=%r, text_line_item_id=%r, description=%r)"
            % (self.action, self.text_line_item_id, self.description)
        )
