# DO NOT EDIT! This file is automatically generated

import datetime
import enum
import typing

from commercetools.types._abstract import _BaseType
from commercetools.types._common import (
    BaseResource,
    Reference,
    ReferenceTypeId,
    ResourceIdentifier,
)

if typing.TYPE_CHECKING:
    from ._cart import ProductPublishScope
    from ._category import CategoryReference, CategoryResourceIdentifier
    from ._common import (
        Asset,
        AssetDraft,
        AssetSource,
        CreatedBy,
        DiscountedPrice,
        Image,
        LastModifiedBy,
        LocalizedString,
        Price,
        PriceDraft,
        ScopedPrice,
    )
    from ._product_type import ProductTypeReference, ProductTypeResourceIdentifier
    from ._review import ReviewRatingStatistics
    from ._state import StateReference, StateResourceIdentifier
    from ._tax_category import TaxCategoryReference, TaxCategoryResourceIdentifier
    from ._type import FieldContainer, TypeResourceIdentifier
__all__ = [
    "Attribute",
    "AttributeValue",
    "CategoryOrderHints",
    "CustomTokenizer",
    "FacetResult",
    "FacetResultRange",
    "FacetResultTerm",
    "FacetResults",
    "FacetTypes",
    "FilteredFacetResult",
    "Product",
    "ProductAddAssetAction",
    "ProductAddExternalImageAction",
    "ProductAddPriceAction",
    "ProductAddToCategoryAction",
    "ProductAddVariantAction",
    "ProductCatalogData",
    "ProductChangeAssetNameAction",
    "ProductChangeAssetOrderAction",
    "ProductChangeMasterVariantAction",
    "ProductChangeNameAction",
    "ProductChangePriceAction",
    "ProductChangeSlugAction",
    "ProductData",
    "ProductDraft",
    "ProductLegacySetSkuAction",
    "ProductMoveImageToPositionAction",
    "ProductPagedQueryResponse",
    "ProductProjection",
    "ProductProjectionPagedQueryResponse",
    "ProductProjectionPagedSearchResponse",
    "ProductPublishAction",
    "ProductReference",
    "ProductRemoveAssetAction",
    "ProductRemoveFromCategoryAction",
    "ProductRemoveImageAction",
    "ProductRemovePriceAction",
    "ProductRemoveVariantAction",
    "ProductResourceIdentifier",
    "ProductRevertStagedChangesAction",
    "ProductRevertStagedVariantChangesAction",
    "ProductSetAssetCustomFieldAction",
    "ProductSetAssetCustomTypeAction",
    "ProductSetAssetDescriptionAction",
    "ProductSetAssetKeyAction",
    "ProductSetAssetSourcesAction",
    "ProductSetAssetTagsAction",
    "ProductSetAttributeAction",
    "ProductSetAttributeInAllVariantsAction",
    "ProductSetCategoryOrderHintAction",
    "ProductSetDescriptionAction",
    "ProductSetDiscountedPriceAction",
    "ProductSetImageLabelAction",
    "ProductSetKeyAction",
    "ProductSetMetaDescriptionAction",
    "ProductSetMetaKeywordsAction",
    "ProductSetMetaTitleAction",
    "ProductSetPricesAction",
    "ProductSetProductPriceCustomFieldAction",
    "ProductSetProductPriceCustomTypeAction",
    "ProductSetProductVariantKeyAction",
    "ProductSetSearchKeywordsAction",
    "ProductSetSkuAction",
    "ProductSetTaxCategoryAction",
    "ProductTransitionStateAction",
    "ProductUnpublishAction",
    "ProductUpdate",
    "ProductUpdateAction",
    "ProductVariant",
    "ProductVariantAvailability",
    "ProductVariantChannelAvailability",
    "ProductVariantChannelAvailabilityMap",
    "ProductVariantDraft",
    "RangeFacetResult",
    "SearchKeyword",
    "SearchKeywords",
    "SuggestTokenizer",
    "Suggestion",
    "SuggestionResult",
    "TermFacetResult",
    "TermFacetResultType",
    "WhitespaceTokenizer",
]


class Attribute(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.AttributeSchema`."
    #: :class:`str`
    name: typing.Optional[str]
    #: :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(
        self,
        *,
        name: typing.Optional[str] = None,
        value: typing.Optional[typing.Any] = None,
    ) -> None:
        self.name = name
        self.value = value
        super().__init__()

    def __repr__(self) -> str:
        return "Attribute(name=%r, value=%r)" % (self.name, self.value)


class AttributeValue(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.AttributeValueSchema`."

    def __init__(self) -> None:
        super().__init__()

    def __repr__(self) -> str:
        return "AttributeValue()" % ()


class CategoryOrderHints(typing.Dict[(str, str)]):
    def __repr__(self) -> str:
        return "CategoryOrderHints(%s)" % (
            ", ".join(f"{k}={v!r}" for k, v in self.items())
        )


class FacetResult(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.FacetResultSchema`."
    #: :class:`commercetools.types.FacetTypes`
    type: typing.Optional["FacetTypes"]

    def __init__(self, *, type: typing.Optional["FacetTypes"] = None) -> None:
        self.type = type
        super().__init__()

    def __repr__(self) -> str:
        return "FacetResult(type=%r)" % (self.type,)


class FacetResultRange(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.FacetResultRangeSchema`."
    #: :class:`int` `(Named` ``from`` `in Commercetools)`
    from_: typing.Optional[int]
    #: :class:`str` `(Named` ``fromStr`` `in Commercetools)`
    from_str: typing.Optional[str]
    #: :class:`int`
    to: typing.Optional[int]
    #: :class:`str` `(Named` ``toStr`` `in Commercetools)`
    to_str: typing.Optional[str]
    #: :class:`int`
    count: typing.Optional[int]
    #: Optional :class:`int` `(Named` ``productCount`` `in Commercetools)`
    product_count: typing.Optional[int]
    #: :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    min: typing.Optional[int]
    #: :class:`int`
    max: typing.Optional[int]
    #: :class:`int`
    mean: typing.Optional[int]

    def __init__(
        self,
        *,
        from_: typing.Optional[int] = None,
        from_str: typing.Optional[str] = None,
        to: typing.Optional[int] = None,
        to_str: typing.Optional[str] = None,
        count: typing.Optional[int] = None,
        product_count: typing.Optional[int] = None,
        total: typing.Optional[int] = None,
        min: typing.Optional[int] = None,
        max: typing.Optional[int] = None,
        mean: typing.Optional[int] = None,
    ) -> None:
        self.from_ = from_
        self.from_str = from_str
        self.to = to
        self.to_str = to_str
        self.count = count
        self.product_count = product_count
        self.total = total
        self.min = min
        self.max = max
        self.mean = mean
        super().__init__()

    def __repr__(self) -> str:
        return (
            "FacetResultRange(from_=%r, from_str=%r, to=%r, to_str=%r, count=%r, product_count=%r, total=%r, min=%r, max=%r, mean=%r)"
            % (
                self.from_,
                self.from_str,
                self.to,
                self.to_str,
                self.count,
                self.product_count,
                self.total,
                self.min,
                self.max,
                self.mean,
            )
        )


class FacetResultTerm(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.FacetResultTermSchema`."
    #: :class:`typing.Any`
    term: typing.Optional[typing.Any]
    #: :class:`int`
    count: typing.Optional[int]
    #: Optional :class:`int` `(Named` ``productCount`` `in Commercetools)`
    product_count: typing.Optional[int]

    def __init__(
        self,
        *,
        term: typing.Optional[typing.Any] = None,
        count: typing.Optional[int] = None,
        product_count: typing.Optional[int] = None,
    ) -> None:
        self.term = term
        self.count = count
        self.product_count = product_count
        super().__init__()

    def __repr__(self) -> str:
        return "FacetResultTerm(term=%r, count=%r, product_count=%r)" % (
            self.term,
            self.count,
            self.product_count,
        )


class FacetResults(typing.Dict[(str, "FacetResult")]):
    def __repr__(self) -> str:
        return "FacetResults(%s)" % (", ".join(f"{k}={v!r}" for k, v in self.items()))


class FacetTypes(enum.Enum):
    TERMS = "terms"
    RANGE = "range"
    FILTER = "filter"


class Product(BaseResource):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSchema`."
    #: :class:`str`
    id: typing.Optional[str]
    #: :class:`int`
    version: typing.Optional[int]
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: typing.Optional[datetime.datetime]
    #: :class:`datetime.datetime` `(Named` ``lastModifiedAt`` `in Commercetools)`
    last_modified_at: typing.Optional[datetime.datetime]
    #: Optional :class:`commercetools.types.LastModifiedBy` `(Named` ``lastModifiedBy`` `in Commercetools)`
    last_modified_by: typing.Optional["LastModifiedBy"]
    #: Optional :class:`commercetools.types.CreatedBy` `(Named` ``createdBy`` `in Commercetools)`
    created_by: typing.Optional["CreatedBy"]
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: :class:`commercetools.types.ProductTypeReference` `(Named` ``productType`` `in Commercetools)`
    product_type: typing.Optional["ProductTypeReference"]
    #: :class:`commercetools.types.ProductCatalogData` `(Named` ``masterData`` `in Commercetools)`
    master_data: typing.Optional["ProductCatalogData"]
    #: Optional :class:`commercetools.types.TaxCategoryReference` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: typing.Optional["TaxCategoryReference"]
    #: Optional :class:`commercetools.types.StateReference`
    state: typing.Optional["StateReference"]
    #: Optional :class:`commercetools.types.ReviewRatingStatistics` `(Named` ``reviewRatingStatistics`` `in Commercetools)`
    review_rating_statistics: typing.Optional["ReviewRatingStatistics"]

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        version: typing.Optional[int] = None,
        created_at: typing.Optional[datetime.datetime] = None,
        last_modified_at: typing.Optional[datetime.datetime] = None,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        key: typing.Optional[str] = None,
        product_type: typing.Optional["ProductTypeReference"] = None,
        master_data: typing.Optional["ProductCatalogData"] = None,
        tax_category: typing.Optional["TaxCategoryReference"] = None,
        state: typing.Optional["StateReference"] = None,
        review_rating_statistics: typing.Optional["ReviewRatingStatistics"] = None,
    ) -> None:
        self.id = id
        self.version = version
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        self.last_modified_by = last_modified_by
        self.created_by = created_by
        self.key = key
        self.product_type = product_type
        self.master_data = master_data
        self.tax_category = tax_category
        self.state = state
        self.review_rating_statistics = review_rating_statistics
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
        )

    def __repr__(self) -> str:
        return (
            "Product(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, key=%r, product_type=%r, master_data=%r, tax_category=%r, state=%r, review_rating_statistics=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.key,
                self.product_type,
                self.master_data,
                self.tax_category,
                self.state,
                self.review_rating_statistics,
            )
        )


class ProductCatalogData(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductCatalogDataSchema`."
    #: :class:`bool`
    published: typing.Optional[bool]
    #: :class:`commercetools.types.ProductData`
    current: typing.Optional["ProductData"]
    #: :class:`commercetools.types.ProductData`
    staged: typing.Optional["ProductData"]
    #: :class:`bool` `(Named` ``hasStagedChanges`` `in Commercetools)`
    has_staged_changes: typing.Optional[bool]

    def __init__(
        self,
        *,
        published: typing.Optional[bool] = None,
        current: typing.Optional["ProductData"] = None,
        staged: typing.Optional["ProductData"] = None,
        has_staged_changes: typing.Optional[bool] = None,
    ) -> None:
        self.published = published
        self.current = current
        self.staged = staged
        self.has_staged_changes = has_staged_changes
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ProductCatalogData(published=%r, current=%r, staged=%r, has_staged_changes=%r)"
            % (self.published, self.current, self.staged, self.has_staged_changes)
        )


class ProductData(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductDataSchema`."
    #: :class:`commercetools.types.LocalizedString`
    name: typing.Optional["LocalizedString"]
    #: List of :class:`commercetools.types.CategoryReference`
    categories: typing.Optional[typing.List["CategoryReference"]]
    #: Optional :class:`commercetools.types.CategoryOrderHints` `(Named` ``categoryOrderHints`` `in Commercetools)`
    category_order_hints: typing.Optional["CategoryOrderHints"]
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]
    #: :class:`commercetools.types.LocalizedString`
    slug: typing.Optional["LocalizedString"]
    #: Optional :class:`commercetools.types.LocalizedString` `(Named` ``metaTitle`` `in Commercetools)`
    meta_title: typing.Optional["LocalizedString"]
    #: Optional :class:`commercetools.types.LocalizedString` `(Named` ``metaDescription`` `in Commercetools)`
    meta_description: typing.Optional["LocalizedString"]
    #: Optional :class:`commercetools.types.LocalizedString` `(Named` ``metaKeywords`` `in Commercetools)`
    meta_keywords: typing.Optional["LocalizedString"]
    #: :class:`commercetools.types.ProductVariant` `(Named` ``masterVariant`` `in Commercetools)`
    master_variant: typing.Optional["ProductVariant"]
    #: List of :class:`commercetools.types.ProductVariant`
    variants: typing.Optional[typing.List["ProductVariant"]]
    #: :class:`commercetools.types.SearchKeywords` `(Named` ``searchKeywords`` `in Commercetools)`
    search_keywords: typing.Optional["SearchKeywords"]

    def __init__(
        self,
        *,
        name: typing.Optional["LocalizedString"] = None,
        categories: typing.Optional[typing.List["CategoryReference"]] = None,
        category_order_hints: typing.Optional["CategoryOrderHints"] = None,
        description: typing.Optional["LocalizedString"] = None,
        slug: typing.Optional["LocalizedString"] = None,
        meta_title: typing.Optional["LocalizedString"] = None,
        meta_description: typing.Optional["LocalizedString"] = None,
        meta_keywords: typing.Optional["LocalizedString"] = None,
        master_variant: typing.Optional["ProductVariant"] = None,
        variants: typing.Optional[typing.List["ProductVariant"]] = None,
        search_keywords: typing.Optional["SearchKeywords"] = None,
    ) -> None:
        self.name = name
        self.categories = categories
        self.category_order_hints = category_order_hints
        self.description = description
        self.slug = slug
        self.meta_title = meta_title
        self.meta_description = meta_description
        self.meta_keywords = meta_keywords
        self.master_variant = master_variant
        self.variants = variants
        self.search_keywords = search_keywords
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ProductData(name=%r, categories=%r, category_order_hints=%r, description=%r, slug=%r, meta_title=%r, meta_description=%r, meta_keywords=%r, master_variant=%r, variants=%r, search_keywords=%r)"
            % (
                self.name,
                self.categories,
                self.category_order_hints,
                self.description,
                self.slug,
                self.meta_title,
                self.meta_description,
                self.meta_keywords,
                self.master_variant,
                self.variants,
                self.search_keywords,
            )
        )


class ProductDraft(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductDraftSchema`."
    #: :class:`commercetools.types.ProductTypeResourceIdentifier` `(Named` ``productType`` `in Commercetools)`
    product_type: typing.Optional["ProductTypeResourceIdentifier"]
    #: :class:`commercetools.types.LocalizedString`
    name: typing.Optional["LocalizedString"]
    #: :class:`commercetools.types.LocalizedString`
    slug: typing.Optional["LocalizedString"]
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]
    #: Optional list of :class:`commercetools.types.CategoryResourceIdentifier`
    categories: typing.Optional[typing.List["CategoryResourceIdentifier"]]
    #: Optional :class:`commercetools.types.CategoryOrderHints` `(Named` ``categoryOrderHints`` `in Commercetools)`
    category_order_hints: typing.Optional["CategoryOrderHints"]
    #: Optional :class:`commercetools.types.LocalizedString` `(Named` ``metaTitle`` `in Commercetools)`
    meta_title: typing.Optional["LocalizedString"]
    #: Optional :class:`commercetools.types.LocalizedString` `(Named` ``metaDescription`` `in Commercetools)`
    meta_description: typing.Optional["LocalizedString"]
    #: Optional :class:`commercetools.types.LocalizedString` `(Named` ``metaKeywords`` `in Commercetools)`
    meta_keywords: typing.Optional["LocalizedString"]
    #: Optional :class:`commercetools.types.ProductVariantDraft` `(Named` ``masterVariant`` `in Commercetools)`
    master_variant: typing.Optional["ProductVariantDraft"]
    #: Optional list of :class:`commercetools.types.ProductVariantDraft`
    variants: typing.Optional[typing.List["ProductVariantDraft"]]
    #: Optional :class:`commercetools.types.TaxCategoryResourceIdentifier` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: typing.Optional["TaxCategoryResourceIdentifier"]
    #: Optional :class:`commercetools.types.SearchKeywords` `(Named` ``searchKeywords`` `in Commercetools)`
    search_keywords: typing.Optional["SearchKeywords"]
    #: Optional :class:`commercetools.types.StateResourceIdentifier`
    state: typing.Optional["StateResourceIdentifier"]
    #: Optional :class:`bool`
    publish: typing.Optional[bool]

    def __init__(
        self,
        *,
        product_type: typing.Optional["ProductTypeResourceIdentifier"] = None,
        name: typing.Optional["LocalizedString"] = None,
        slug: typing.Optional["LocalizedString"] = None,
        key: typing.Optional[str] = None,
        description: typing.Optional["LocalizedString"] = None,
        categories: typing.Optional[typing.List["CategoryResourceIdentifier"]] = None,
        category_order_hints: typing.Optional["CategoryOrderHints"] = None,
        meta_title: typing.Optional["LocalizedString"] = None,
        meta_description: typing.Optional["LocalizedString"] = None,
        meta_keywords: typing.Optional["LocalizedString"] = None,
        master_variant: typing.Optional["ProductVariantDraft"] = None,
        variants: typing.Optional[typing.List["ProductVariantDraft"]] = None,
        tax_category: typing.Optional["TaxCategoryResourceIdentifier"] = None,
        search_keywords: typing.Optional["SearchKeywords"] = None,
        state: typing.Optional["StateResourceIdentifier"] = None,
        publish: typing.Optional[bool] = None,
    ) -> None:
        self.product_type = product_type
        self.name = name
        self.slug = slug
        self.key = key
        self.description = description
        self.categories = categories
        self.category_order_hints = category_order_hints
        self.meta_title = meta_title
        self.meta_description = meta_description
        self.meta_keywords = meta_keywords
        self.master_variant = master_variant
        self.variants = variants
        self.tax_category = tax_category
        self.search_keywords = search_keywords
        self.state = state
        self.publish = publish
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ProductDraft(product_type=%r, name=%r, slug=%r, key=%r, description=%r, categories=%r, category_order_hints=%r, meta_title=%r, meta_description=%r, meta_keywords=%r, master_variant=%r, variants=%r, tax_category=%r, search_keywords=%r, state=%r, publish=%r)"
            % (
                self.product_type,
                self.name,
                self.slug,
                self.key,
                self.description,
                self.categories,
                self.category_order_hints,
                self.meta_title,
                self.meta_description,
                self.meta_keywords,
                self.master_variant,
                self.variants,
                self.tax_category,
                self.search_keywords,
                self.state,
                self.publish,
            )
        )


class ProductPagedQueryResponse(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductPagedQueryResponseSchema`."
    #: :class:`int`
    limit: typing.Optional[int]
    #: :class:`int`
    count: typing.Optional[int]
    #: Optional :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    offset: typing.Optional[int]
    #: List of :class:`commercetools.types.Product`
    results: typing.Optional[typing.Sequence["Product"]]

    def __init__(
        self,
        *,
        limit: typing.Optional[int] = None,
        count: typing.Optional[int] = None,
        total: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        results: typing.Optional[typing.Sequence["Product"]] = None,
    ) -> None:
        self.limit = limit
        self.count = count
        self.total = total
        self.offset = offset
        self.results = results
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ProductPagedQueryResponse(limit=%r, count=%r, total=%r, offset=%r, results=%r)"
            % (self.limit, self.count, self.total, self.offset, self.results)
        )


class ProductProjection(BaseResource):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductProjectionSchema`."
    #: :class:`str`
    id: typing.Optional[str]
    #: :class:`int`
    version: typing.Optional[int]
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: :class:`commercetools.types.ProductTypeReference` `(Named` ``productType`` `in Commercetools)`
    product_type: typing.Optional["ProductTypeReference"]
    #: :class:`commercetools.types.LocalizedString`
    name: typing.Optional["LocalizedString"]
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]
    #: :class:`commercetools.types.LocalizedString`
    slug: typing.Optional["LocalizedString"]
    #: List of :class:`commercetools.types.CategoryReference`
    categories: typing.Optional[typing.List["CategoryReference"]]
    #: Optional :class:`commercetools.types.CategoryOrderHints` `(Named` ``categoryOrderHints`` `in Commercetools)`
    category_order_hints: typing.Optional["CategoryOrderHints"]
    #: Optional :class:`commercetools.types.LocalizedString` `(Named` ``metaTitle`` `in Commercetools)`
    meta_title: typing.Optional["LocalizedString"]
    #: Optional :class:`commercetools.types.LocalizedString` `(Named` ``metaDescription`` `in Commercetools)`
    meta_description: typing.Optional["LocalizedString"]
    #: Optional :class:`commercetools.types.LocalizedString` `(Named` ``metaKeywords`` `in Commercetools)`
    meta_keywords: typing.Optional["LocalizedString"]
    #: Optional :class:`commercetools.types.SearchKeywords` `(Named` ``searchKeywords`` `in Commercetools)`
    search_keywords: typing.Optional["SearchKeywords"]
    #: Optional :class:`bool` `(Named` ``hasStagedChanges`` `in Commercetools)`
    has_staged_changes: typing.Optional[bool]
    #: Optional :class:`bool`
    published: typing.Optional[bool]
    #: :class:`commercetools.types.ProductVariant` `(Named` ``masterVariant`` `in Commercetools)`
    master_variant: typing.Optional["ProductVariant"]
    #: List of :class:`commercetools.types.ProductVariant`
    variants: typing.Optional[typing.List["ProductVariant"]]
    #: Optional :class:`commercetools.types.TaxCategoryReference` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: typing.Optional["TaxCategoryReference"]
    #: Optional :class:`commercetools.types.StateReference`
    state: typing.Optional["StateReference"]
    #: Optional :class:`commercetools.types.ReviewRatingStatistics` `(Named` ``reviewRatingStatistics`` `in Commercetools)`
    review_rating_statistics: typing.Optional["ReviewRatingStatistics"]

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        version: typing.Optional[int] = None,
        created_at: typing.Optional[datetime.datetime] = None,
        last_modified_at: typing.Optional[datetime.datetime] = None,
        key: typing.Optional[str] = None,
        product_type: typing.Optional["ProductTypeReference"] = None,
        name: typing.Optional["LocalizedString"] = None,
        description: typing.Optional["LocalizedString"] = None,
        slug: typing.Optional["LocalizedString"] = None,
        categories: typing.Optional[typing.List["CategoryReference"]] = None,
        category_order_hints: typing.Optional["CategoryOrderHints"] = None,
        meta_title: typing.Optional["LocalizedString"] = None,
        meta_description: typing.Optional["LocalizedString"] = None,
        meta_keywords: typing.Optional["LocalizedString"] = None,
        search_keywords: typing.Optional["SearchKeywords"] = None,
        has_staged_changes: typing.Optional[bool] = None,
        published: typing.Optional[bool] = None,
        master_variant: typing.Optional["ProductVariant"] = None,
        variants: typing.Optional[typing.List["ProductVariant"]] = None,
        tax_category: typing.Optional["TaxCategoryReference"] = None,
        state: typing.Optional["StateReference"] = None,
        review_rating_statistics: typing.Optional["ReviewRatingStatistics"] = None,
    ) -> None:
        self.id = id
        self.version = version
        self.key = key
        self.product_type = product_type
        self.name = name
        self.description = description
        self.slug = slug
        self.categories = categories
        self.category_order_hints = category_order_hints
        self.meta_title = meta_title
        self.meta_description = meta_description
        self.meta_keywords = meta_keywords
        self.search_keywords = search_keywords
        self.has_staged_changes = has_staged_changes
        self.published = published
        self.master_variant = master_variant
        self.variants = variants
        self.tax_category = tax_category
        self.state = state
        self.review_rating_statistics = review_rating_statistics
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
        )

    def __repr__(self) -> str:
        return (
            "ProductProjection(id=%r, version=%r, created_at=%r, last_modified_at=%r, key=%r, product_type=%r, name=%r, description=%r, slug=%r, categories=%r, category_order_hints=%r, meta_title=%r, meta_description=%r, meta_keywords=%r, search_keywords=%r, has_staged_changes=%r, published=%r, master_variant=%r, variants=%r, tax_category=%r, state=%r, review_rating_statistics=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.key,
                self.product_type,
                self.name,
                self.description,
                self.slug,
                self.categories,
                self.category_order_hints,
                self.meta_title,
                self.meta_description,
                self.meta_keywords,
                self.search_keywords,
                self.has_staged_changes,
                self.published,
                self.master_variant,
                self.variants,
                self.tax_category,
                self.state,
                self.review_rating_statistics,
            )
        )


class ProductProjectionPagedQueryResponse(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductProjectionPagedQueryResponseSchema`."
    #: :class:`int`
    limit: typing.Optional[int]
    #: :class:`int`
    count: typing.Optional[int]
    #: Optional :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    offset: typing.Optional[int]
    #: List of :class:`commercetools.types.ProductProjection`
    results: typing.Optional[typing.Sequence["ProductProjection"]]

    def __init__(
        self,
        *,
        limit: typing.Optional[int] = None,
        count: typing.Optional[int] = None,
        total: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        results: typing.Optional[typing.Sequence["ProductProjection"]] = None,
    ) -> None:
        self.limit = limit
        self.count = count
        self.total = total
        self.offset = offset
        self.results = results
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ProductProjectionPagedQueryResponse(limit=%r, count=%r, total=%r, offset=%r, results=%r)"
            % (self.limit, self.count, self.total, self.offset, self.results)
        )


class ProductProjectionPagedSearchResponse(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductProjectionPagedSearchResponseSchema`."
    #: :class:`int`
    count: typing.Optional[int]
    #: Optional :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    offset: typing.Optional[int]
    #: List of :class:`commercetools.types.ProductProjection`
    results: typing.Optional[typing.List["ProductProjection"]]
    #: :class:`commercetools.types.FacetResults`
    facets: typing.Optional["FacetResults"]

    def __init__(
        self,
        *,
        count: typing.Optional[int] = None,
        total: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        results: typing.Optional[typing.List["ProductProjection"]] = None,
        facets: typing.Optional["FacetResults"] = None,
    ) -> None:
        self.count = count
        self.total = total
        self.offset = offset
        self.results = results
        self.facets = facets
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ProductProjectionPagedSearchResponse(count=%r, total=%r, offset=%r, results=%r, facets=%r)"
            % (self.count, self.total, self.offset, self.results, self.facets)
        )


class ProductReference(Reference):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductReferenceSchema`."
    #: Optional :class:`commercetools.types.Product`
    obj: typing.Optional["Product"]

    def __init__(
        self,
        *,
        type_id: typing.Optional["ReferenceTypeId"] = None,
        id: typing.Optional[str] = None,
        obj: typing.Optional["Product"] = None,
    ) -> None:
        self.obj = obj
        super().__init__(type_id=ReferenceTypeId.PRODUCT, id=id)

    def __repr__(self) -> str:
        return "ProductReference(type_id=%r, id=%r, obj=%r)" % (
            self.type_id,
            self.id,
            self.obj,
        )


class ProductResourceIdentifier(ResourceIdentifier):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductResourceIdentifierSchema`."

    def __init__(
        self,
        *,
        type_id: typing.Optional["ReferenceTypeId"] = None,
        id: typing.Optional[str] = None,
        key: typing.Optional[str] = None,
    ) -> None:
        super().__init__(type_id=ReferenceTypeId.PRODUCT, id=id, key=key)

    def __repr__(self) -> str:
        return "ProductResourceIdentifier(type_id=%r, id=%r, key=%r)" % (
            self.type_id,
            self.id,
            self.key,
        )


class ProductUpdate(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductUpdateSchema`."
    #: :class:`int`
    version: typing.Optional[int]
    #: :class:`list`
    actions: typing.Optional[list]

    def __init__(
        self,
        *,
        version: typing.Optional[int] = None,
        actions: typing.Optional[list] = None,
    ) -> None:
        self.version = version
        self.actions = actions
        super().__init__()

    def __repr__(self) -> str:
        return "ProductUpdate(version=%r, actions=%r)" % (self.version, self.actions)


class ProductUpdateAction(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductUpdateActionSchema`."
    #: :class:`str`
    action: typing.Optional[str]

    def __init__(self, *, action: typing.Optional[str] = None) -> None:
        self.action = action
        super().__init__()

    def __repr__(self) -> str:
        return "ProductUpdateAction(action=%r)" % (self.action,)


class ProductVariant(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductVariantSchema`."
    #: :class:`int`
    id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: Optional list of :class:`commercetools.types.Price`
    prices: typing.Optional[typing.List["Price"]]
    #: Optional list of :class:`commercetools.types.Attribute`
    attributes: typing.Optional[typing.List["Attribute"]]
    #: Optional :class:`commercetools.types.Price`
    price: typing.Optional["Price"]
    #: Optional list of :class:`commercetools.types.Image`
    images: typing.Optional[typing.List["Image"]]
    #: Optional list of :class:`commercetools.types.Asset`
    assets: typing.Optional[typing.List["Asset"]]
    #: Optional :class:`commercetools.types.ProductVariantAvailability`
    availability: typing.Optional["ProductVariantAvailability"]
    #: Optional :class:`bool` `(Named` ``isMatchingVariant`` `in Commercetools)`
    is_matching_variant: typing.Optional[bool]
    #: Optional :class:`commercetools.types.ScopedPrice` `(Named` ``scopedPrice`` `in Commercetools)`
    scoped_price: typing.Optional["ScopedPrice"]
    #: Optional :class:`bool` `(Named` ``scopedPriceDiscounted`` `in Commercetools)`
    scoped_price_discounted: typing.Optional[bool]

    def __init__(
        self,
        *,
        id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        key: typing.Optional[str] = None,
        prices: typing.Optional[typing.List["Price"]] = None,
        attributes: typing.Optional[typing.List["Attribute"]] = None,
        price: typing.Optional["Price"] = None,
        images: typing.Optional[typing.List["Image"]] = None,
        assets: typing.Optional[typing.List["Asset"]] = None,
        availability: typing.Optional["ProductVariantAvailability"] = None,
        is_matching_variant: typing.Optional[bool] = None,
        scoped_price: typing.Optional["ScopedPrice"] = None,
        scoped_price_discounted: typing.Optional[bool] = None,
    ) -> None:
        self.id = id
        self.sku = sku
        self.key = key
        self.prices = prices
        self.attributes = attributes
        self.price = price
        self.images = images
        self.assets = assets
        self.availability = availability
        self.is_matching_variant = is_matching_variant
        self.scoped_price = scoped_price
        self.scoped_price_discounted = scoped_price_discounted
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ProductVariant(id=%r, sku=%r, key=%r, prices=%r, attributes=%r, price=%r, images=%r, assets=%r, availability=%r, is_matching_variant=%r, scoped_price=%r, scoped_price_discounted=%r)"
            % (
                self.id,
                self.sku,
                self.key,
                self.prices,
                self.attributes,
                self.price,
                self.images,
                self.assets,
                self.availability,
                self.is_matching_variant,
                self.scoped_price,
                self.scoped_price_discounted,
            )
        )


class ProductVariantAvailability(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductVariantAvailabilitySchema`."
    #: Optional :class:`bool` `(Named` ``isOnStock`` `in Commercetools)`
    is_on_stock: typing.Optional[bool]
    #: Optional :class:`int` `(Named` ``restockableInDays`` `in Commercetools)`
    restockable_in_days: typing.Optional[int]
    #: Optional :class:`int` `(Named` ``availableQuantity`` `in Commercetools)`
    available_quantity: typing.Optional[int]
    #: Optional :class:`commercetools.types.ProductVariantChannelAvailabilityMap`
    channels: typing.Optional["ProductVariantChannelAvailabilityMap"]

    def __init__(
        self,
        *,
        is_on_stock: typing.Optional[bool] = None,
        restockable_in_days: typing.Optional[int] = None,
        available_quantity: typing.Optional[int] = None,
        channels: typing.Optional["ProductVariantChannelAvailabilityMap"] = None,
    ) -> None:
        self.is_on_stock = is_on_stock
        self.restockable_in_days = restockable_in_days
        self.available_quantity = available_quantity
        self.channels = channels
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ProductVariantAvailability(is_on_stock=%r, restockable_in_days=%r, available_quantity=%r, channels=%r)"
            % (
                self.is_on_stock,
                self.restockable_in_days,
                self.available_quantity,
                self.channels,
            )
        )


class ProductVariantChannelAvailability(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductVariantChannelAvailabilitySchema`."
    #: Optional :class:`bool` `(Named` ``isOnStock`` `in Commercetools)`
    is_on_stock: typing.Optional[bool]
    #: Optional :class:`int` `(Named` ``restockableInDays`` `in Commercetools)`
    restockable_in_days: typing.Optional[int]
    #: Optional :class:`int` `(Named` ``availableQuantity`` `in Commercetools)`
    available_quantity: typing.Optional[int]

    def __init__(
        self,
        *,
        is_on_stock: typing.Optional[bool] = None,
        restockable_in_days: typing.Optional[int] = None,
        available_quantity: typing.Optional[int] = None,
    ) -> None:
        self.is_on_stock = is_on_stock
        self.restockable_in_days = restockable_in_days
        self.available_quantity = available_quantity
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ProductVariantChannelAvailability(is_on_stock=%r, restockable_in_days=%r, available_quantity=%r)"
            % (self.is_on_stock, self.restockable_in_days, self.available_quantity)
        )


class ProductVariantChannelAvailabilityMap(
    typing.Dict[(str, "ProductVariantChannelAvailability")]
):
    def __repr__(self) -> str:
        return "ProductVariantChannelAvailabilityMap(%s)" % (
            ", ".join(f"{k}={v!r}" for k, v in self.items())
        )


class ProductVariantDraft(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductVariantDraftSchema`."
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: Optional list of :class:`commercetools.types.PriceDraft`
    prices: typing.Optional[typing.List["PriceDraft"]]
    #: Optional list of :class:`commercetools.types.Attribute`
    attributes: typing.Optional[typing.List["Attribute"]]
    #: Optional list of :class:`commercetools.types.Image`
    images: typing.Optional[typing.List["Image"]]
    #: Optional list of :class:`commercetools.types.AssetDraft`
    assets: typing.Optional[typing.List["AssetDraft"]]

    def __init__(
        self,
        *,
        sku: typing.Optional[str] = None,
        key: typing.Optional[str] = None,
        prices: typing.Optional[typing.List["PriceDraft"]] = None,
        attributes: typing.Optional[typing.List["Attribute"]] = None,
        images: typing.Optional[typing.List["Image"]] = None,
        assets: typing.Optional[typing.List["AssetDraft"]] = None,
    ) -> None:
        self.sku = sku
        self.key = key
        self.prices = prices
        self.attributes = attributes
        self.images = images
        self.assets = assets
        super().__init__()

    def __repr__(self) -> str:
        return (
            "ProductVariantDraft(sku=%r, key=%r, prices=%r, attributes=%r, images=%r, assets=%r)"
            % (
                self.sku,
                self.key,
                self.prices,
                self.attributes,
                self.images,
                self.assets,
            )
        )


class SearchKeyword(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.SearchKeywordSchema`."
    #: :class:`str`
    text: typing.Optional[str]
    #: Optional :class:`commercetools.types.SuggestTokenizer` `(Named` ``suggestTokenizer`` `in Commercetools)`
    suggest_tokenizer: typing.Optional["SuggestTokenizer"]

    def __init__(
        self,
        *,
        text: typing.Optional[str] = None,
        suggest_tokenizer: typing.Optional["SuggestTokenizer"] = None,
    ) -> None:
        self.text = text
        self.suggest_tokenizer = suggest_tokenizer
        super().__init__()

    def __repr__(self) -> str:
        return "SearchKeyword(text=%r, suggest_tokenizer=%r)" % (
            self.text,
            self.suggest_tokenizer,
        )


class SearchKeywords(typing.Dict[(str, "SearchKeyword")]):
    def __repr__(self) -> str:
        return "SearchKeywords(%s)" % (", ".join(f"{k}={v!r}" for k, v in self.items()))


class SuggestTokenizer(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.SuggestTokenizerSchema`."
    #: :class:`str`
    type: typing.Optional[str]

    def __init__(self, *, type: typing.Optional[str] = None) -> None:
        self.type = type
        super().__init__()

    def __repr__(self) -> str:
        return "SuggestTokenizer(type=%r)" % (self.type,)


class Suggestion(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.SuggestionSchema`."
    #: :class:`str`
    text: typing.Optional[str]

    def __init__(self, *, text: typing.Optional[str] = None) -> None:
        self.text = text
        super().__init__()

    def __repr__(self) -> str:
        return "Suggestion(text=%r)" % (self.text,)


class SuggestionResult(typing.Dict[(str, list)]):
    def __repr__(self) -> str:
        return "SuggestionResult(%s)" % (
            ", ".join(f"{k}={v!r}" for k, v in self.items())
        )


class TermFacetResultType(enum.Enum):
    TEXT = "text"
    DATE = "date"
    TIME = "time"
    DATETIME = "datetime"
    BOOLEAN = "boolean"
    NUMBER = "number"


class CustomTokenizer(SuggestTokenizer):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.CustomTokenizerSchema`."
    #: List of :class:`str`
    inputs: typing.Optional[typing.List[str]]

    def __init__(
        self,
        *,
        type: typing.Optional[str] = None,
        inputs: typing.Optional[typing.List[str]] = None,
    ) -> None:
        self.inputs = inputs
        super().__init__(type="custom")

    def __repr__(self) -> str:
        return "CustomTokenizer(type=%r, inputs=%r)" % (self.type, self.inputs)


class FilteredFacetResult(FacetResult):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.FilteredFacetResultSchema`."
    #: :class:`int`
    count: typing.Optional[int]
    #: Optional :class:`int` `(Named` ``productCount`` `in Commercetools)`
    product_count: typing.Optional[int]

    def __init__(
        self,
        *,
        type: typing.Optional["FacetTypes"] = None,
        count: typing.Optional[int] = None,
        product_count: typing.Optional[int] = None,
    ) -> None:
        self.count = count
        self.product_count = product_count
        super().__init__(type=FacetTypes.FILTER)

    def __repr__(self) -> str:
        return "FilteredFacetResult(type=%r, count=%r, product_count=%r)" % (
            self.type,
            self.count,
            self.product_count,
        )


class ProductAddAssetAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductAddAssetActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]
    #: :class:`commercetools.types.AssetDraft`
    asset: typing.Optional["AssetDraft"]
    #: Optional :class:`int`
    position: typing.Optional[int]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
        asset: typing.Optional["AssetDraft"] = None,
        position: typing.Optional[int] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.staged = staged
        self.asset = asset
        self.position = position
        super().__init__(action="addAsset")

    def __repr__(self) -> str:
        return (
            "ProductAddAssetAction(action=%r, variant_id=%r, sku=%r, staged=%r, asset=%r, position=%r)"
            % (
                self.action,
                self.variant_id,
                self.sku,
                self.staged,
                self.asset,
                self.position,
            )
        )


class ProductAddExternalImageAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductAddExternalImageActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: :class:`commercetools.types.Image`
    image: typing.Optional["Image"]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        image: typing.Optional["Image"] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.image = image
        self.staged = staged
        super().__init__(action="addExternalImage")

    def __repr__(self) -> str:
        return (
            "ProductAddExternalImageAction(action=%r, variant_id=%r, sku=%r, image=%r, staged=%r)"
            % (self.action, self.variant_id, self.sku, self.image, self.staged)
        )


class ProductAddPriceAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductAddPriceActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: :class:`commercetools.types.PriceDraft`
    price: typing.Optional["PriceDraft"]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        price: typing.Optional["PriceDraft"] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.price = price
        self.staged = staged
        super().__init__(action="addPrice")

    def __repr__(self) -> str:
        return (
            "ProductAddPriceAction(action=%r, variant_id=%r, sku=%r, price=%r, staged=%r)"
            % (self.action, self.variant_id, self.sku, self.price, self.staged)
        )


class ProductAddToCategoryAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductAddToCategoryActionSchema`."
    #: :class:`commercetools.types.CategoryResourceIdentifier`
    category: typing.Optional["CategoryResourceIdentifier"]
    #: Optional :class:`str` `(Named` ``orderHint`` `in Commercetools)`
    order_hint: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        category: typing.Optional["CategoryResourceIdentifier"] = None,
        order_hint: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.category = category
        self.order_hint = order_hint
        self.staged = staged
        super().__init__(action="addToCategory")

    def __repr__(self) -> str:
        return (
            "ProductAddToCategoryAction(action=%r, category=%r, order_hint=%r, staged=%r)"
            % (self.action, self.category, self.order_hint, self.staged)
        )


class ProductAddVariantAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductAddVariantActionSchema`."
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: Optional list of :class:`commercetools.types.PriceDraft`
    prices: typing.Optional[typing.List["PriceDraft"]]
    #: Optional list of :class:`commercetools.types.Image`
    images: typing.Optional[typing.List["Image"]]
    #: Optional list of :class:`commercetools.types.Attribute`
    attributes: typing.Optional[typing.List["Attribute"]]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]
    #: Optional list of :class:`commercetools.types.Asset`
    assets: typing.Optional[typing.List["Asset"]]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        sku: typing.Optional[str] = None,
        key: typing.Optional[str] = None,
        prices: typing.Optional[typing.List["PriceDraft"]] = None,
        images: typing.Optional[typing.List["Image"]] = None,
        attributes: typing.Optional[typing.List["Attribute"]] = None,
        staged: typing.Optional[bool] = None,
        assets: typing.Optional[typing.List["Asset"]] = None,
    ) -> None:
        self.sku = sku
        self.key = key
        self.prices = prices
        self.images = images
        self.attributes = attributes
        self.staged = staged
        self.assets = assets
        super().__init__(action="addVariant")

    def __repr__(self) -> str:
        return (
            "ProductAddVariantAction(action=%r, sku=%r, key=%r, prices=%r, images=%r, attributes=%r, staged=%r, assets=%r)"
            % (
                self.action,
                self.sku,
                self.key,
                self.prices,
                self.images,
                self.attributes,
                self.staged,
                self.assets,
            )
        )


class ProductChangeAssetNameAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductChangeAssetNameActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]
    #: Optional :class:`str` `(Named` ``assetId`` `in Commercetools)`
    asset_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``assetKey`` `in Commercetools)`
    asset_key: typing.Optional[str]
    #: :class:`commercetools.types.LocalizedString`
    name: typing.Optional["LocalizedString"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
        asset_id: typing.Optional[str] = None,
        asset_key: typing.Optional[str] = None,
        name: typing.Optional["LocalizedString"] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.staged = staged
        self.asset_id = asset_id
        self.asset_key = asset_key
        self.name = name
        super().__init__(action="changeAssetName")

    def __repr__(self) -> str:
        return (
            "ProductChangeAssetNameAction(action=%r, variant_id=%r, sku=%r, staged=%r, asset_id=%r, asset_key=%r, name=%r)"
            % (
                self.action,
                self.variant_id,
                self.sku,
                self.staged,
                self.asset_id,
                self.asset_key,
                self.name,
            )
        )


class ProductChangeAssetOrderAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductChangeAssetOrderActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]
    #: List of :class:`str` `(Named` ``assetOrder`` `in Commercetools)`
    asset_order: typing.Optional[typing.List[str]]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
        asset_order: typing.Optional[typing.List[str]] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.staged = staged
        self.asset_order = asset_order
        super().__init__(action="changeAssetOrder")

    def __repr__(self) -> str:
        return (
            "ProductChangeAssetOrderAction(action=%r, variant_id=%r, sku=%r, staged=%r, asset_order=%r)"
            % (self.action, self.variant_id, self.sku, self.staged, self.asset_order)
        )


class ProductChangeMasterVariantAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductChangeMasterVariantActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.staged = staged
        super().__init__(action="changeMasterVariant")

    def __repr__(self) -> str:
        return (
            "ProductChangeMasterVariantAction(action=%r, variant_id=%r, sku=%r, staged=%r)"
            % (self.action, self.variant_id, self.sku, self.staged)
        )


class ProductChangeNameAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductChangeNameActionSchema`."
    #: :class:`commercetools.types.LocalizedString`
    name: typing.Optional["LocalizedString"]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        name: typing.Optional["LocalizedString"] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.name = name
        self.staged = staged
        super().__init__(action="changeName")

    def __repr__(self) -> str:
        return "ProductChangeNameAction(action=%r, name=%r, staged=%r)" % (
            self.action,
            self.name,
            self.staged,
        )


class ProductChangePriceAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductChangePriceActionSchema`."
    #: :class:`str` `(Named` ``priceId`` `in Commercetools)`
    price_id: typing.Optional[str]
    #: :class:`commercetools.types.PriceDraft`
    price: typing.Optional["PriceDraft"]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        price_id: typing.Optional[str] = None,
        price: typing.Optional["PriceDraft"] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.price_id = price_id
        self.price = price
        self.staged = staged
        super().__init__(action="changePrice")

    def __repr__(self) -> str:
        return (
            "ProductChangePriceAction(action=%r, price_id=%r, price=%r, staged=%r)"
            % (self.action, self.price_id, self.price, self.staged)
        )


class ProductChangeSlugAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductChangeSlugActionSchema`."
    #: :class:`commercetools.types.LocalizedString`
    slug: typing.Optional["LocalizedString"]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        slug: typing.Optional["LocalizedString"] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.slug = slug
        self.staged = staged
        super().__init__(action="changeSlug")

    def __repr__(self) -> str:
        return "ProductChangeSlugAction(action=%r, slug=%r, staged=%r)" % (
            self.action,
            self.slug,
            self.staged,
        )


class ProductLegacySetSkuAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductLegacySetSkuActionSchema`."
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        sku: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
    ) -> None:
        self.sku = sku
        self.variant_id = variant_id
        super().__init__(action="legacySetSku")

    def __repr__(self) -> str:
        return "ProductLegacySetSkuAction(action=%r, sku=%r, variant_id=%r)" % (
            self.action,
            self.sku,
            self.variant_id,
        )


class ProductMoveImageToPositionAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductMoveImageToPositionActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: :class:`str` `(Named` ``imageUrl`` `in Commercetools)`
    image_url: typing.Optional[str]
    #: :class:`int`
    position: typing.Optional[int]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        image_url: typing.Optional[str] = None,
        position: typing.Optional[int] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.image_url = image_url
        self.position = position
        self.staged = staged
        super().__init__(action="moveImageToPosition")

    def __repr__(self) -> str:
        return (
            "ProductMoveImageToPositionAction(action=%r, variant_id=%r, sku=%r, image_url=%r, position=%r, staged=%r)"
            % (
                self.action,
                self.variant_id,
                self.sku,
                self.image_url,
                self.position,
                self.staged,
            )
        )


class ProductPublishAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductPublishActionSchema`."
    #: Optional :class:`commercetools.types.ProductPublishScope`
    scope: typing.Optional["ProductPublishScope"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        scope: typing.Optional["ProductPublishScope"] = None,
    ) -> None:
        self.scope = scope
        super().__init__(action="publish")

    def __repr__(self) -> str:
        return "ProductPublishAction(action=%r, scope=%r)" % (self.action, self.scope)


class ProductRemoveAssetAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductRemoveAssetActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]
    #: Optional :class:`str` `(Named` ``assetId`` `in Commercetools)`
    asset_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``assetKey`` `in Commercetools)`
    asset_key: typing.Optional[str]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
        asset_id: typing.Optional[str] = None,
        asset_key: typing.Optional[str] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.staged = staged
        self.asset_id = asset_id
        self.asset_key = asset_key
        super().__init__(action="removeAsset")

    def __repr__(self) -> str:
        return (
            "ProductRemoveAssetAction(action=%r, variant_id=%r, sku=%r, staged=%r, asset_id=%r, asset_key=%r)"
            % (
                self.action,
                self.variant_id,
                self.sku,
                self.staged,
                self.asset_id,
                self.asset_key,
            )
        )


class ProductRemoveFromCategoryAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductRemoveFromCategoryActionSchema`."
    #: :class:`commercetools.types.CategoryResourceIdentifier`
    category: typing.Optional["CategoryResourceIdentifier"]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        category: typing.Optional["CategoryResourceIdentifier"] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.category = category
        self.staged = staged
        super().__init__(action="removeFromCategory")

    def __repr__(self) -> str:
        return "ProductRemoveFromCategoryAction(action=%r, category=%r, staged=%r)" % (
            self.action,
            self.category,
            self.staged,
        )


class ProductRemoveImageAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductRemoveImageActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: :class:`str` `(Named` ``imageUrl`` `in Commercetools)`
    image_url: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        image_url: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.image_url = image_url
        self.staged = staged
        super().__init__(action="removeImage")

    def __repr__(self) -> str:
        return (
            "ProductRemoveImageAction(action=%r, variant_id=%r, sku=%r, image_url=%r, staged=%r)"
            % (self.action, self.variant_id, self.sku, self.image_url, self.staged)
        )


class ProductRemovePriceAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductRemovePriceActionSchema`."
    #: :class:`str` `(Named` ``priceId`` `in Commercetools)`
    price_id: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        price_id: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.price_id = price_id
        self.staged = staged
        super().__init__(action="removePrice")

    def __repr__(self) -> str:
        return "ProductRemovePriceAction(action=%r, price_id=%r, staged=%r)" % (
            self.action,
            self.price_id,
            self.staged,
        )


class ProductRemoveVariantAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductRemoveVariantActionSchema`."
    #: Optional :class:`int`
    id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.id = id
        self.sku = sku
        self.staged = staged
        super().__init__(action="removeVariant")

    def __repr__(self) -> str:
        return "ProductRemoveVariantAction(action=%r, id=%r, sku=%r, staged=%r)" % (
            self.action,
            self.id,
            self.sku,
            self.staged,
        )


class ProductRevertStagedChangesAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductRevertStagedChangesActionSchema`."

    def __init__(self, *, action: typing.Optional[str] = None) -> None:
        super().__init__(action="revertStagedChanges")

    def __repr__(self) -> str:
        return "ProductRevertStagedChangesAction(action=%r)" % (self.action,)


class ProductRevertStagedVariantChangesAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductRevertStagedVariantChangesActionSchema`."
    #: :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
    ) -> None:
        self.variant_id = variant_id
        super().__init__(action="revertStagedVariantChanges")

    def __repr__(self) -> str:
        return "ProductRevertStagedVariantChangesAction(action=%r, variant_id=%r)" % (
            self.action,
            self.variant_id,
        )


class ProductSetAssetCustomFieldAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetAssetCustomFieldActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]
    #: Optional :class:`str` `(Named` ``assetId`` `in Commercetools)`
    asset_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``assetKey`` `in Commercetools)`
    asset_key: typing.Optional[str]
    #: :class:`str`
    name: typing.Optional[str]
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
        asset_id: typing.Optional[str] = None,
        asset_key: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        value: typing.Optional[typing.Any] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.staged = staged
        self.asset_id = asset_id
        self.asset_key = asset_key
        self.name = name
        self.value = value
        super().__init__(action="setAssetCustomField")

    def __repr__(self) -> str:
        return (
            "ProductSetAssetCustomFieldAction(action=%r, variant_id=%r, sku=%r, staged=%r, asset_id=%r, asset_key=%r, name=%r, value=%r)"
            % (
                self.action,
                self.variant_id,
                self.sku,
                self.staged,
                self.asset_id,
                self.asset_key,
                self.name,
                self.value,
            )
        )


class ProductSetAssetCustomTypeAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetAssetCustomTypeActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]
    #: Optional :class:`str` `(Named` ``assetId`` `in Commercetools)`
    asset_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``assetKey`` `in Commercetools)`
    asset_key: typing.Optional[str]
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`object`
    fields: typing.Optional[object]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
        asset_id: typing.Optional[str] = None,
        asset_key: typing.Optional[str] = None,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional[object] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.staged = staged
        self.asset_id = asset_id
        self.asset_key = asset_key
        self.type = type
        self.fields = fields
        super().__init__(action="setAssetCustomType")

    def __repr__(self) -> str:
        return (
            "ProductSetAssetCustomTypeAction(action=%r, variant_id=%r, sku=%r, staged=%r, asset_id=%r, asset_key=%r, type=%r, fields=%r)"
            % (
                self.action,
                self.variant_id,
                self.sku,
                self.staged,
                self.asset_id,
                self.asset_key,
                self.type,
                self.fields,
            )
        )


class ProductSetAssetDescriptionAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetAssetDescriptionActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]
    #: Optional :class:`str` `(Named` ``assetId`` `in Commercetools)`
    asset_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``assetKey`` `in Commercetools)`
    asset_key: typing.Optional[str]
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
        asset_id: typing.Optional[str] = None,
        asset_key: typing.Optional[str] = None,
        description: typing.Optional["LocalizedString"] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.staged = staged
        self.asset_id = asset_id
        self.asset_key = asset_key
        self.description = description
        super().__init__(action="setAssetDescription")

    def __repr__(self) -> str:
        return (
            "ProductSetAssetDescriptionAction(action=%r, variant_id=%r, sku=%r, staged=%r, asset_id=%r, asset_key=%r, description=%r)"
            % (
                self.action,
                self.variant_id,
                self.sku,
                self.staged,
                self.asset_id,
                self.asset_key,
                self.description,
            )
        )


class ProductSetAssetKeyAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetAssetKeyActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]
    #: :class:`str` `(Named` ``assetId`` `in Commercetools)`
    asset_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``assetKey`` `in Commercetools)`
    asset_key: typing.Optional[str]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
        asset_id: typing.Optional[str] = None,
        asset_key: typing.Optional[str] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.staged = staged
        self.asset_id = asset_id
        self.asset_key = asset_key
        super().__init__(action="setAssetKey")

    def __repr__(self) -> str:
        return (
            "ProductSetAssetKeyAction(action=%r, variant_id=%r, sku=%r, staged=%r, asset_id=%r, asset_key=%r)"
            % (
                self.action,
                self.variant_id,
                self.sku,
                self.staged,
                self.asset_id,
                self.asset_key,
            )
        )


class ProductSetAssetSourcesAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetAssetSourcesActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]
    #: Optional :class:`str` `(Named` ``assetId`` `in Commercetools)`
    asset_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``assetKey`` `in Commercetools)`
    asset_key: typing.Optional[str]
    #: List of :class:`commercetools.types.AssetSource`
    sources: typing.Optional[typing.List["AssetSource"]]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
        asset_id: typing.Optional[str] = None,
        asset_key: typing.Optional[str] = None,
        sources: typing.Optional[typing.List["AssetSource"]] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.staged = staged
        self.asset_id = asset_id
        self.asset_key = asset_key
        self.sources = sources
        super().__init__(action="setAssetSources")

    def __repr__(self) -> str:
        return (
            "ProductSetAssetSourcesAction(action=%r, variant_id=%r, sku=%r, staged=%r, asset_id=%r, asset_key=%r, sources=%r)"
            % (
                self.action,
                self.variant_id,
                self.sku,
                self.staged,
                self.asset_id,
                self.asset_key,
                self.sources,
            )
        )


class ProductSetAssetTagsAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetAssetTagsActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]
    #: Optional :class:`str` `(Named` ``assetId`` `in Commercetools)`
    asset_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``assetKey`` `in Commercetools)`
    asset_key: typing.Optional[str]
    #: Optional list of :class:`str`
    tags: typing.Optional[typing.List[str]]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
        asset_id: typing.Optional[str] = None,
        asset_key: typing.Optional[str] = None,
        tags: typing.Optional[typing.List[str]] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.staged = staged
        self.asset_id = asset_id
        self.asset_key = asset_key
        self.tags = tags
        super().__init__(action="setAssetTags")

    def __repr__(self) -> str:
        return (
            "ProductSetAssetTagsAction(action=%r, variant_id=%r, sku=%r, staged=%r, asset_id=%r, asset_key=%r, tags=%r)"
            % (
                self.action,
                self.variant_id,
                self.sku,
                self.staged,
                self.asset_id,
                self.asset_key,
                self.tags,
            )
        )


class ProductSetAttributeAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetAttributeActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: :class:`str`
    name: typing.Optional[str]
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        value: typing.Optional[typing.Any] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.name = name
        self.value = value
        self.staged = staged
        super().__init__(action="setAttribute")

    def __repr__(self) -> str:
        return (
            "ProductSetAttributeAction(action=%r, variant_id=%r, sku=%r, name=%r, value=%r, staged=%r)"
            % (
                self.action,
                self.variant_id,
                self.sku,
                self.name,
                self.value,
                self.staged,
            )
        )


class ProductSetAttributeInAllVariantsAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetAttributeInAllVariantsActionSchema`."
    #: :class:`str`
    name: typing.Optional[str]
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        value: typing.Optional[typing.Any] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.name = name
        self.value = value
        self.staged = staged
        super().__init__(action="setAttributeInAllVariants")

    def __repr__(self) -> str:
        return (
            "ProductSetAttributeInAllVariantsAction(action=%r, name=%r, value=%r, staged=%r)"
            % (self.action, self.name, self.value, self.staged)
        )


class ProductSetCategoryOrderHintAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetCategoryOrderHintActionSchema`."
    #: :class:`str` `(Named` ``categoryId`` `in Commercetools)`
    category_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``orderHint`` `in Commercetools)`
    order_hint: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        category_id: typing.Optional[str] = None,
        order_hint: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.category_id = category_id
        self.order_hint = order_hint
        self.staged = staged
        super().__init__(action="setCategoryOrderHint")

    def __repr__(self) -> str:
        return (
            "ProductSetCategoryOrderHintAction(action=%r, category_id=%r, order_hint=%r, staged=%r)"
            % (self.action, self.category_id, self.order_hint, self.staged)
        )


class ProductSetDescriptionAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetDescriptionActionSchema`."
    #: Optional :class:`commercetools.types.LocalizedString`
    description: typing.Optional["LocalizedString"]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        description: typing.Optional["LocalizedString"] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.description = description
        self.staged = staged
        super().__init__(action="setDescription")

    def __repr__(self) -> str:
        return "ProductSetDescriptionAction(action=%r, description=%r, staged=%r)" % (
            self.action,
            self.description,
            self.staged,
        )


class ProductSetDiscountedPriceAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetDiscountedPriceActionSchema`."
    #: :class:`str` `(Named` ``priceId`` `in Commercetools)`
    price_id: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]
    #: Optional :class:`commercetools.types.DiscountedPrice`
    discounted: typing.Optional["DiscountedPrice"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        price_id: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
        discounted: typing.Optional["DiscountedPrice"] = None,
    ) -> None:
        self.price_id = price_id
        self.staged = staged
        self.discounted = discounted
        super().__init__(action="setDiscountedPrice")

    def __repr__(self) -> str:
        return (
            "ProductSetDiscountedPriceAction(action=%r, price_id=%r, staged=%r, discounted=%r)"
            % (self.action, self.price_id, self.staged, self.discounted)
        )


class ProductSetImageLabelAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetImageLabelActionSchema`."
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: :class:`str` `(Named` ``imageUrl`` `in Commercetools)`
    image_url: typing.Optional[str]
    #: Optional :class:`str`
    label: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        sku: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        image_url: typing.Optional[str] = None,
        label: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.sku = sku
        self.variant_id = variant_id
        self.image_url = image_url
        self.label = label
        self.staged = staged
        super().__init__(action="setImageLabel")

    def __repr__(self) -> str:
        return (
            "ProductSetImageLabelAction(action=%r, sku=%r, variant_id=%r, image_url=%r, label=%r, staged=%r)"
            % (
                self.action,
                self.sku,
                self.variant_id,
                self.image_url,
                self.label,
                self.staged,
            )
        )


class ProductSetKeyAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetKeyActionSchema`."
    #: Optional :class:`str`
    key: typing.Optional[str]

    def __init__(
        self, *, action: typing.Optional[str] = None, key: typing.Optional[str] = None
    ) -> None:
        self.key = key
        super().__init__(action="setKey")

    def __repr__(self) -> str:
        return "ProductSetKeyAction(action=%r, key=%r)" % (self.action, self.key)


class ProductSetMetaDescriptionAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetMetaDescriptionActionSchema`."
    #: Optional :class:`commercetools.types.LocalizedString` `(Named` ``metaDescription`` `in Commercetools)`
    meta_description: typing.Optional["LocalizedString"]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        meta_description: typing.Optional["LocalizedString"] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.meta_description = meta_description
        self.staged = staged
        super().__init__(action="setMetaDescription")

    def __repr__(self) -> str:
        return (
            "ProductSetMetaDescriptionAction(action=%r, meta_description=%r, staged=%r)"
            % (self.action, self.meta_description, self.staged)
        )


class ProductSetMetaKeywordsAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetMetaKeywordsActionSchema`."
    #: Optional :class:`commercetools.types.LocalizedString` `(Named` ``metaKeywords`` `in Commercetools)`
    meta_keywords: typing.Optional["LocalizedString"]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        meta_keywords: typing.Optional["LocalizedString"] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.meta_keywords = meta_keywords
        self.staged = staged
        super().__init__(action="setMetaKeywords")

    def __repr__(self) -> str:
        return (
            "ProductSetMetaKeywordsAction(action=%r, meta_keywords=%r, staged=%r)"
            % (self.action, self.meta_keywords, self.staged)
        )


class ProductSetMetaTitleAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetMetaTitleActionSchema`."
    #: Optional :class:`commercetools.types.LocalizedString` `(Named` ``metaTitle`` `in Commercetools)`
    meta_title: typing.Optional["LocalizedString"]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        meta_title: typing.Optional["LocalizedString"] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.meta_title = meta_title
        self.staged = staged
        super().__init__(action="setMetaTitle")

    def __repr__(self) -> str:
        return "ProductSetMetaTitleAction(action=%r, meta_title=%r, staged=%r)" % (
            self.action,
            self.meta_title,
            self.staged,
        )


class ProductSetPricesAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetPricesActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: List of :class:`commercetools.types.PriceDraft`
    prices: typing.Optional[typing.List["PriceDraft"]]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        prices: typing.Optional[typing.List["PriceDraft"]] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.prices = prices
        self.staged = staged
        super().__init__(action="setPrices")

    def __repr__(self) -> str:
        return (
            "ProductSetPricesAction(action=%r, variant_id=%r, sku=%r, prices=%r, staged=%r)"
            % (self.action, self.variant_id, self.sku, self.prices, self.staged)
        )


class ProductSetProductPriceCustomFieldAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetProductPriceCustomFieldActionSchema`."
    #: :class:`str` `(Named` ``priceId`` `in Commercetools)`
    price_id: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]
    #: :class:`str`
    name: typing.Optional[str]
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        price_id: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
        name: typing.Optional[str] = None,
        value: typing.Optional[typing.Any] = None,
    ) -> None:
        self.price_id = price_id
        self.staged = staged
        self.name = name
        self.value = value
        super().__init__(action="setProductPriceCustomField")

    def __repr__(self) -> str:
        return (
            "ProductSetProductPriceCustomFieldAction(action=%r, price_id=%r, staged=%r, name=%r, value=%r)"
            % (self.action, self.price_id, self.staged, self.name, self.value)
        )


class ProductSetProductPriceCustomTypeAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetProductPriceCustomTypeActionSchema`."
    #: :class:`str` `(Named` ``priceId`` `in Commercetools)`
    price_id: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        price_id: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None,
    ) -> None:
        self.price_id = price_id
        self.staged = staged
        self.type = type
        self.fields = fields
        super().__init__(action="setProductPriceCustomType")

    def __repr__(self) -> str:
        return (
            "ProductSetProductPriceCustomTypeAction(action=%r, price_id=%r, staged=%r, type=%r, fields=%r)"
            % (self.action, self.price_id, self.staged, self.type, self.fields)
        )


class ProductSetProductVariantKeyAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetProductVariantKeyActionSchema`."
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        key: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.key = key
        self.staged = staged
        super().__init__(action="setProductVariantKey")

    def __repr__(self) -> str:
        return (
            "ProductSetProductVariantKeyAction(action=%r, variant_id=%r, sku=%r, key=%r, staged=%r)"
            % (self.action, self.variant_id, self.sku, self.key, self.staged)
        )


class ProductSetSearchKeywordsAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetSearchKeywordsActionSchema`."
    #: :class:`commercetools.types.SearchKeywords` `(Named` ``searchKeywords`` `in Commercetools)`
    search_keywords: typing.Optional["SearchKeywords"]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        search_keywords: typing.Optional["SearchKeywords"] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.search_keywords = search_keywords
        self.staged = staged
        super().__init__(action="setSearchKeywords")

    def __repr__(self) -> str:
        return (
            "ProductSetSearchKeywordsAction(action=%r, search_keywords=%r, staged=%r)"
            % (self.action, self.search_keywords, self.staged)
        )


class ProductSetSkuAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetSkuActionSchema`."
    #: :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`bool`
    staged: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        staged: typing.Optional[bool] = None,
    ) -> None:
        self.variant_id = variant_id
        self.sku = sku
        self.staged = staged
        super().__init__(action="setSku")

    def __repr__(self) -> str:
        return "ProductSetSkuAction(action=%r, variant_id=%r, sku=%r, staged=%r)" % (
            self.action,
            self.variant_id,
            self.sku,
            self.staged,
        )


class ProductSetTaxCategoryAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductSetTaxCategoryActionSchema`."
    #: Optional :class:`commercetools.types.TaxCategoryResourceIdentifier` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: typing.Optional["TaxCategoryResourceIdentifier"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        tax_category: typing.Optional["TaxCategoryResourceIdentifier"] = None,
    ) -> None:
        self.tax_category = tax_category
        super().__init__(action="setTaxCategory")

    def __repr__(self) -> str:
        return "ProductSetTaxCategoryAction(action=%r, tax_category=%r)" % (
            self.action,
            self.tax_category,
        )


class ProductTransitionStateAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductTransitionStateActionSchema`."
    #: Optional :class:`commercetools.types.StateResourceIdentifier`
    state: typing.Optional["StateResourceIdentifier"]
    #: Optional :class:`bool`
    force: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        state: typing.Optional["StateResourceIdentifier"] = None,
        force: typing.Optional[bool] = None,
    ) -> None:
        self.state = state
        self.force = force
        super().__init__(action="transitionState")

    def __repr__(self) -> str:
        return "ProductTransitionStateAction(action=%r, state=%r, force=%r)" % (
            self.action,
            self.state,
            self.force,
        )


class ProductUnpublishAction(ProductUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.ProductUnpublishActionSchema`."

    def __init__(self, *, action: typing.Optional[str] = None) -> None:
        super().__init__(action="unpublish")

    def __repr__(self) -> str:
        return "ProductUnpublishAction(action=%r)" % (self.action,)


class RangeFacetResult(FacetResult):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.RangeFacetResultSchema`."
    #: List of :class:`commercetools.types.FacetResultRange`
    ranges: typing.Optional[typing.List["FacetResultRange"]]

    def __init__(
        self,
        *,
        type: typing.Optional["FacetTypes"] = None,
        ranges: typing.Optional[typing.List["FacetResultRange"]] = None,
    ) -> None:
        self.ranges = ranges
        super().__init__(type=FacetTypes.RANGE)

    def __repr__(self) -> str:
        return "RangeFacetResult(type=%r, ranges=%r)" % (self.type, self.ranges)


class TermFacetResult(FacetResult):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.TermFacetResultSchema`."
    #: :class:`commercetools.types.TermFacetResultType` `(Named` ``dataType`` `in Commercetools)`
    data_type: typing.Optional["TermFacetResultType"]
    #: :class:`int`
    missing: typing.Optional[int]
    #: :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    other: typing.Optional[int]
    #: List of :class:`commercetools.types.FacetResultTerm`
    terms: typing.Optional[typing.List["FacetResultTerm"]]

    def __init__(
        self,
        *,
        type: typing.Optional["FacetTypes"] = None,
        data_type: typing.Optional["TermFacetResultType"] = None,
        missing: typing.Optional[int] = None,
        total: typing.Optional[int] = None,
        other: typing.Optional[int] = None,
        terms: typing.Optional[typing.List["FacetResultTerm"]] = None,
    ) -> None:
        self.data_type = data_type
        self.missing = missing
        self.total = total
        self.other = other
        self.terms = terms
        super().__init__(type=FacetTypes.TERMS)

    def __repr__(self) -> str:
        return (
            "TermFacetResult(type=%r, data_type=%r, missing=%r, total=%r, other=%r, terms=%r)"
            % (
                self.type,
                self.data_type,
                self.missing,
                self.total,
                self.other,
                self.terms,
            )
        )


class WhitespaceTokenizer(SuggestTokenizer):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.WhitespaceTokenizerSchema`."

    def __init__(self, *, type: typing.Optional[str] = None) -> None:
        super().__init__(type="whitespace")

    def __repr__(self) -> str:
        return "WhitespaceTokenizer(type=%r)" % (self.type,)
