# DO NOT EDIT! This file is automatically generated

import datetime
import typing

from commercetools.types._abstract import _BaseType
from commercetools.types._common import (
    BaseResource,
    Reference,
    ReferenceTypeId,
    ResourceIdentifier,
)
from commercetools.types._order import Order, StagedOrderUpdateAction

if typing.TYPE_CHECKING:
    from ._cart import (
        CartOrigin,
        CartReference,
        CustomLineItem,
        DiscountCodeInfo,
        ExternalLineItemTotalPrice,
        ExternalTaxAmountDraft,
        ExternalTaxRateDraft,
        InventoryMode,
        ItemShippingDetailsDraft,
        LineItem,
        RoundingMode,
        ShippingInfo,
        ShippingRateInput,
        ShippingRateInputDraft,
        TaxCalculationMode,
        TaxMode,
        TaxPortionDraft,
        TaxedPrice,
    )
    from ._cart_discount import CartDiscountReference
    from ._channel import ChannelResourceIdentifier
    from ._common import (
        Address,
        CreatedBy,
        LastModifiedBy,
        LocalizedString,
        Money,
        TypedMoney,
    )
    from ._customer_group import CustomerGroupReference, CustomerGroupResourceIdentifier
    from ._discount_code import DiscountCodeReference
    from ._error import ErrorObject
    from ._message import MessagePayload
    from ._order import (
        DeliveryItem,
        ItemState,
        OrderReference,
        OrderState,
        ParcelDraft,
        ParcelMeasurements,
        PaymentInfo,
        PaymentState,
        ReturnInfo,
        ReturnItemDraft,
        ReturnPaymentState,
        ReturnShipmentState,
        ShipmentState,
        SyncInfo,
        TrackingData,
    )
    from ._payment import PaymentResourceIdentifier
    from ._shipping_method import ShippingMethodResourceIdentifier, ShippingRateDraft
    from ._shopping_list import ShoppingListResourceIdentifier
    from ._state import StateReference, StateResourceIdentifier
    from ._store import StoreKeyReference
    from ._tax_category import TaxCategoryResourceIdentifier
    from ._type import (
        CustomFields,
        CustomFieldsDraft,
        FieldContainer,
        TypeResourceIdentifier,
    )
__all__ = [
    "OrderEdit",
    "OrderEditAddStagedActionAction",
    "OrderEditApplied",
    "OrderEditApply",
    "OrderEditDraft",
    "OrderEditNotProcessed",
    "OrderEditPagedQueryResponse",
    "OrderEditPreviewFailure",
    "OrderEditPreviewSuccess",
    "OrderEditReference",
    "OrderEditResourceIdentifier",
    "OrderEditResult",
    "OrderEditSetCommentAction",
    "OrderEditSetCustomFieldAction",
    "OrderEditSetCustomTypeAction",
    "OrderEditSetKeyAction",
    "OrderEditSetStagedActionsAction",
    "OrderEditUpdate",
    "OrderEditUpdateAction",
    "OrderExcerpt",
    "StagedOrder",
    "StagedOrderAddCustomLineItemAction",
    "StagedOrderAddDeliveryAction",
    "StagedOrderAddDiscountCodeAction",
    "StagedOrderAddItemShippingAddressAction",
    "StagedOrderAddLineItemAction",
    "StagedOrderAddParcelToDeliveryAction",
    "StagedOrderAddPaymentAction",
    "StagedOrderAddReturnInfoAction",
    "StagedOrderAddShoppingListAction",
    "StagedOrderChangeCustomLineItemMoneyAction",
    "StagedOrderChangeCustomLineItemQuantityAction",
    "StagedOrderChangeLineItemQuantityAction",
    "StagedOrderChangeOrderStateAction",
    "StagedOrderChangePaymentStateAction",
    "StagedOrderChangeShipmentStateAction",
    "StagedOrderChangeTaxCalculationModeAction",
    "StagedOrderChangeTaxModeAction",
    "StagedOrderChangeTaxRoundingModeAction",
    "StagedOrderImportCustomLineItemStateAction",
    "StagedOrderImportLineItemStateAction",
    "StagedOrderRemoveCustomLineItemAction",
    "StagedOrderRemoveDeliveryAction",
    "StagedOrderRemoveDiscountCodeAction",
    "StagedOrderRemoveItemShippingAddressAction",
    "StagedOrderRemoveLineItemAction",
    "StagedOrderRemoveParcelFromDeliveryAction",
    "StagedOrderRemovePaymentAction",
    "StagedOrderSetBillingAddressAction",
    "StagedOrderSetCountryAction",
    "StagedOrderSetCustomFieldAction",
    "StagedOrderSetCustomLineItemCustomFieldAction",
    "StagedOrderSetCustomLineItemCustomTypeAction",
    "StagedOrderSetCustomLineItemShippingDetailsAction",
    "StagedOrderSetCustomLineItemTaxAmountAction",
    "StagedOrderSetCustomLineItemTaxRateAction",
    "StagedOrderSetCustomShippingMethodAction",
    "StagedOrderSetCustomTypeAction",
    "StagedOrderSetCustomerEmailAction",
    "StagedOrderSetCustomerGroupAction",
    "StagedOrderSetCustomerIdAction",
    "StagedOrderSetDeliveryAddressAction",
    "StagedOrderSetDeliveryItemsAction",
    "StagedOrderSetLineItemCustomFieldAction",
    "StagedOrderSetLineItemCustomTypeAction",
    "StagedOrderSetLineItemPriceAction",
    "StagedOrderSetLineItemShippingDetailsAction",
    "StagedOrderSetLineItemTaxAmountAction",
    "StagedOrderSetLineItemTaxRateAction",
    "StagedOrderSetLineItemTotalPriceAction",
    "StagedOrderSetLocaleAction",
    "StagedOrderSetOrderNumberAction",
    "StagedOrderSetOrderTotalTaxAction",
    "StagedOrderSetParcelItemsAction",
    "StagedOrderSetParcelMeasurementsAction",
    "StagedOrderSetParcelTrackingDataAction",
    "StagedOrderSetReturnPaymentStateAction",
    "StagedOrderSetReturnShipmentStateAction",
    "StagedOrderSetShippingAddressAction",
    "StagedOrderSetShippingAddressAndCustomShippingMethodAction",
    "StagedOrderSetShippingAddressAndShippingMethodAction",
    "StagedOrderSetShippingMethodAction",
    "StagedOrderSetShippingMethodTaxAmountAction",
    "StagedOrderSetShippingMethodTaxRateAction",
    "StagedOrderSetShippingRateInputAction",
    "StagedOrderTransitionCustomLineItemStateAction",
    "StagedOrderTransitionLineItemStateAction",
    "StagedOrderTransitionStateAction",
    "StagedOrderUpdateItemShippingAddressAction",
    "StagedOrderUpdateSyncInfoAction",
]


class OrderEdit(BaseResource):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditSchema`."
    #: :class:`str`
    id: typing.Optional[str]
    #: :class:`int`
    version: typing.Optional[int]
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: typing.Optional[datetime.datetime]
    #: :class:`datetime.datetime` `(Named` ``lastModifiedAt`` `in Commercetools)`
    last_modified_at: typing.Optional[datetime.datetime]
    #: Optional :class:`commercetools.types.LastModifiedBy` `(Named` ``lastModifiedBy`` `in Commercetools)`
    last_modified_by: typing.Optional["LastModifiedBy"]
    #: Optional :class:`commercetools.types.CreatedBy` `(Named` ``createdBy`` `in Commercetools)`
    created_by: typing.Optional["CreatedBy"]
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: :class:`commercetools.types.OrderReference`
    resource: typing.Optional["OrderReference"]
    #: List of :class:`commercetools.types.StagedOrderUpdateAction` `(Named` ``stagedActions`` `in Commercetools)`
    staged_actions: typing.Optional[typing.List["StagedOrderUpdateAction"]]
    #: Optional :class:`commercetools.types.CustomFields`
    custom: typing.Optional["CustomFields"]
    #: :class:`commercetools.types.OrderEditResult`
    result: typing.Optional["OrderEditResult"]
    #: Optional :class:`str`
    comment: typing.Optional[str]

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        version: typing.Optional[int] = None,
        created_at: typing.Optional[datetime.datetime] = None,
        last_modified_at: typing.Optional[datetime.datetime] = None,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        key: typing.Optional[str] = None,
        resource: typing.Optional["OrderReference"] = None,
        staged_actions: typing.Optional[typing.List["StagedOrderUpdateAction"]] = None,
        custom: typing.Optional["CustomFields"] = None,
        result: typing.Optional["OrderEditResult"] = None,
        comment: typing.Optional[str] = None
    ) -> None:
        self.id = id
        self.version = version
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        self.last_modified_by = last_modified_by
        self.created_by = created_by
        self.key = key
        self.resource = resource
        self.staged_actions = staged_actions
        self.custom = custom
        self.result = result
        self.comment = comment
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
        )

    def __repr__(self) -> str:
        return (
            "OrderEdit(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, key=%r, resource=%r, staged_actions=%r, custom=%r, result=%r, comment=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.key,
                self.resource,
                self.staged_actions,
                self.custom,
                self.result,
                self.comment,
            )
        )


class OrderEditApply(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditApplySchema`."
    #: :class:`int` `(Named` ``editVersion`` `in Commercetools)`
    edit_version: typing.Optional[int]
    #: :class:`int` `(Named` ``resourceVersion`` `in Commercetools)`
    resource_version: typing.Optional[int]

    def __init__(
        self,
        *,
        edit_version: typing.Optional[int] = None,
        resource_version: typing.Optional[int] = None
    ) -> None:
        self.edit_version = edit_version
        self.resource_version = resource_version
        super().__init__()

    def __repr__(self) -> str:
        return "OrderEditApply(edit_version=%r, resource_version=%r)" % (
            self.edit_version,
            self.resource_version,
        )


class OrderEditDraft(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditDraftSchema`."
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: :class:`commercetools.types.OrderReference`
    resource: typing.Optional["OrderReference"]
    #: Optional list of :class:`commercetools.types.StagedOrderUpdateAction` `(Named` ``stagedActions`` `in Commercetools)`
    staged_actions: typing.Optional[typing.List["StagedOrderUpdateAction"]]
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]
    #: Optional :class:`str`
    comment: typing.Optional[str]
    #: Optional :class:`bool` `(Named` ``dryRun`` `in Commercetools)`
    dry_run: typing.Optional[bool]

    def __init__(
        self,
        *,
        key: typing.Optional[str] = None,
        resource: typing.Optional["OrderReference"] = None,
        staged_actions: typing.Optional[typing.List["StagedOrderUpdateAction"]] = None,
        custom: typing.Optional["CustomFieldsDraft"] = None,
        comment: typing.Optional[str] = None,
        dry_run: typing.Optional[bool] = None
    ) -> None:
        self.key = key
        self.resource = resource
        self.staged_actions = staged_actions
        self.custom = custom
        self.comment = comment
        self.dry_run = dry_run
        super().__init__()

    def __repr__(self) -> str:
        return (
            "OrderEditDraft(key=%r, resource=%r, staged_actions=%r, custom=%r, comment=%r, dry_run=%r)"
            % (
                self.key,
                self.resource,
                self.staged_actions,
                self.custom,
                self.comment,
                self.dry_run,
            )
        )


class OrderEditPagedQueryResponse(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditPagedQueryResponseSchema`."
    #: :class:`int`
    limit: typing.Optional[int]
    #: :class:`int`
    count: typing.Optional[int]
    #: Optional :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    offset: typing.Optional[int]
    #: List of :class:`commercetools.types.OrderEdit`
    results: typing.Optional[typing.Sequence["OrderEdit"]]

    def __init__(
        self,
        *,
        limit: typing.Optional[int] = None,
        count: typing.Optional[int] = None,
        total: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        results: typing.Optional[typing.Sequence["OrderEdit"]] = None
    ) -> None:
        self.limit = limit
        self.count = count
        self.total = total
        self.offset = offset
        self.results = results
        super().__init__()

    def __repr__(self) -> str:
        return (
            "OrderEditPagedQueryResponse(limit=%r, count=%r, total=%r, offset=%r, results=%r)"
            % (self.limit, self.count, self.total, self.offset, self.results)
        )


class OrderEditReference(Reference):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditReferenceSchema`."
    #: Optional :class:`commercetools.types.OrderEdit`
    obj: typing.Optional["OrderEdit"]

    def __init__(
        self,
        *,
        type_id: typing.Optional["ReferenceTypeId"] = None,
        id: typing.Optional[str] = None,
        obj: typing.Optional["OrderEdit"] = None
    ) -> None:
        self.obj = obj
        super().__init__(type_id=ReferenceTypeId.ORDER_EDIT, id=id)

    def __repr__(self) -> str:
        return "OrderEditReference(type_id=%r, id=%r, obj=%r)" % (
            self.type_id,
            self.id,
            self.obj,
        )


class OrderEditResourceIdentifier(ResourceIdentifier):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditResourceIdentifierSchema`."

    def __init__(
        self,
        *,
        type_id: typing.Optional["ReferenceTypeId"] = None,
        id: typing.Optional[str] = None,
        key: typing.Optional[str] = None
    ) -> None:
        super().__init__(type_id=ReferenceTypeId.ORDER_EDIT, id=id, key=key)

    def __repr__(self) -> str:
        return "OrderEditResourceIdentifier(type_id=%r, id=%r, key=%r)" % (
            self.type_id,
            self.id,
            self.key,
        )


class OrderEditResult(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditResultSchema`."
    #: :class:`str`
    type: typing.Optional[str]

    def __init__(self, *, type: typing.Optional[str] = None) -> None:
        self.type = type
        super().__init__()

    def __repr__(self) -> str:
        return "OrderEditResult(type=%r)" % (self.type,)


class OrderEditUpdate(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditUpdateSchema`."
    #: :class:`int`
    version: typing.Optional[int]
    #: List of :class:`commercetools.types.OrderEditUpdateAction`
    actions: typing.Optional[typing.List["OrderEditUpdateAction"]]
    #: Optional :class:`bool` `(Named` ``dryRun`` `in Commercetools)`
    dry_run: typing.Optional[bool]

    def __init__(
        self,
        *,
        version: typing.Optional[int] = None,
        actions: typing.Optional[typing.List["OrderEditUpdateAction"]] = None,
        dry_run: typing.Optional[bool] = None
    ) -> None:
        self.version = version
        self.actions = actions
        self.dry_run = dry_run
        super().__init__()

    def __repr__(self) -> str:
        return "OrderEditUpdate(version=%r, actions=%r, dry_run=%r)" % (
            self.version,
            self.actions,
            self.dry_run,
        )


class OrderEditUpdateAction(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditUpdateActionSchema`."
    #: :class:`str`
    action: typing.Optional[str]

    def __init__(self, *, action: typing.Optional[str] = None) -> None:
        self.action = action
        super().__init__()

    def __repr__(self) -> str:
        return "OrderEditUpdateAction(action=%r)" % (self.action,)


class OrderExcerpt(_BaseType):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderExcerptSchema`."
    #: :class:`commercetools.types.TypedMoney` `(Named` ``totalPrice`` `in Commercetools)`
    total_price: typing.Optional["TypedMoney"]
    #: Optional :class:`commercetools.types.TaxedPrice` `(Named` ``taxedPrice`` `in Commercetools)`
    taxed_price: typing.Optional["TaxedPrice"]
    #: :class:`int`
    version: typing.Optional[int]

    def __init__(
        self,
        *,
        total_price: typing.Optional["TypedMoney"] = None,
        taxed_price: typing.Optional["TaxedPrice"] = None,
        version: typing.Optional[int] = None
    ) -> None:
        self.total_price = total_price
        self.taxed_price = taxed_price
        self.version = version
        super().__init__()

    def __repr__(self) -> str:
        return "OrderExcerpt(total_price=%r, taxed_price=%r, version=%r)" % (
            self.total_price,
            self.taxed_price,
            self.version,
        )


class StagedOrder(Order):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSchema`."

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        version: typing.Optional[int] = None,
        created_at: typing.Optional[datetime.datetime] = None,
        last_modified_at: typing.Optional[datetime.datetime] = None,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        completed_at: typing.Optional[datetime.datetime] = None,
        order_number: typing.Optional[str] = None,
        customer_id: typing.Optional[str] = None,
        customer_email: typing.Optional[str] = None,
        anonymous_id: typing.Optional[str] = None,
        store: typing.Optional["StoreKeyReference"] = None,
        line_items: typing.Optional[typing.List["LineItem"]] = None,
        custom_line_items: typing.Optional[typing.List["CustomLineItem"]] = None,
        total_price: typing.Optional["TypedMoney"] = None,
        taxed_price: typing.Optional["TaxedPrice"] = None,
        shipping_address: typing.Optional["Address"] = None,
        billing_address: typing.Optional["Address"] = None,
        tax_mode: typing.Optional["TaxMode"] = None,
        tax_rounding_mode: typing.Optional["RoundingMode"] = None,
        customer_group: typing.Optional["CustomerGroupReference"] = None,
        country: typing.Optional[str] = None,
        order_state: typing.Optional["OrderState"] = None,
        state: typing.Optional["StateReference"] = None,
        shipment_state: typing.Optional["ShipmentState"] = None,
        payment_state: typing.Optional["PaymentState"] = None,
        shipping_info: typing.Optional["ShippingInfo"] = None,
        sync_info: typing.Optional[typing.List["SyncInfo"]] = None,
        return_info: typing.Optional[typing.List["ReturnInfo"]] = None,
        discount_codes: typing.Optional[typing.List["DiscountCodeInfo"]] = None,
        last_message_sequence_number: typing.Optional[int] = None,
        cart: typing.Optional["CartReference"] = None,
        custom: typing.Optional["CustomFields"] = None,
        payment_info: typing.Optional["PaymentInfo"] = None,
        locale: typing.Optional[str] = None,
        inventory_mode: typing.Optional["InventoryMode"] = None,
        origin: typing.Optional["CartOrigin"] = None,
        tax_calculation_mode: typing.Optional["TaxCalculationMode"] = None,
        shipping_rate_input: typing.Optional["ShippingRateInput"] = None,
        item_shipping_addresses: typing.Optional[typing.List["Address"]] = None,
        refused_gifts: typing.Optional[typing.List["CartDiscountReference"]] = None
    ) -> None:
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
            last_modified_by=last_modified_by,
            created_by=created_by,
            completed_at=completed_at,
            order_number=order_number,
            customer_id=customer_id,
            customer_email=customer_email,
            anonymous_id=anonymous_id,
            store=store,
            line_items=line_items,
            custom_line_items=custom_line_items,
            total_price=total_price,
            taxed_price=taxed_price,
            shipping_address=shipping_address,
            billing_address=billing_address,
            tax_mode=tax_mode,
            tax_rounding_mode=tax_rounding_mode,
            customer_group=customer_group,
            country=country,
            order_state=order_state,
            state=state,
            shipment_state=shipment_state,
            payment_state=payment_state,
            shipping_info=shipping_info,
            sync_info=sync_info,
            return_info=return_info,
            discount_codes=discount_codes,
            last_message_sequence_number=last_message_sequence_number,
            cart=cart,
            custom=custom,
            payment_info=payment_info,
            locale=locale,
            inventory_mode=inventory_mode,
            origin=origin,
            tax_calculation_mode=tax_calculation_mode,
            shipping_rate_input=shipping_rate_input,
            item_shipping_addresses=item_shipping_addresses,
            refused_gifts=refused_gifts,
        )

    def __repr__(self) -> str:
        return (
            "StagedOrder(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, completed_at=%r, order_number=%r, customer_id=%r, customer_email=%r, anonymous_id=%r, store=%r, line_items=%r, custom_line_items=%r, total_price=%r, taxed_price=%r, shipping_address=%r, billing_address=%r, tax_mode=%r, tax_rounding_mode=%r, customer_group=%r, country=%r, order_state=%r, state=%r, shipment_state=%r, payment_state=%r, shipping_info=%r, sync_info=%r, return_info=%r, discount_codes=%r, last_message_sequence_number=%r, cart=%r, custom=%r, payment_info=%r, locale=%r, inventory_mode=%r, origin=%r, tax_calculation_mode=%r, shipping_rate_input=%r, item_shipping_addresses=%r, refused_gifts=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.completed_at,
                self.order_number,
                self.customer_id,
                self.customer_email,
                self.anonymous_id,
                self.store,
                self.line_items,
                self.custom_line_items,
                self.total_price,
                self.taxed_price,
                self.shipping_address,
                self.billing_address,
                self.tax_mode,
                self.tax_rounding_mode,
                self.customer_group,
                self.country,
                self.order_state,
                self.state,
                self.shipment_state,
                self.payment_state,
                self.shipping_info,
                self.sync_info,
                self.return_info,
                self.discount_codes,
                self.last_message_sequence_number,
                self.cart,
                self.custom,
                self.payment_info,
                self.locale,
                self.inventory_mode,
                self.origin,
                self.tax_calculation_mode,
                self.shipping_rate_input,
                self.item_shipping_addresses,
                self.refused_gifts,
            )
        )


class StagedOrderAddCustomLineItemAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderAddCustomLineItemActionSchema`."
    #: :class:`commercetools.types.Money`
    money: typing.Optional["Money"]
    #: :class:`commercetools.types.LocalizedString`
    name: typing.Optional["LocalizedString"]
    #: Optional :class:`int`
    quantity: typing.Optional[int]
    #: :class:`str`
    slug: typing.Optional[str]
    #: Optional :class:`commercetools.types.TaxCategoryResourceIdentifier` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: typing.Optional["TaxCategoryResourceIdentifier"]
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        money: typing.Optional["Money"] = None,
        name: typing.Optional["LocalizedString"] = None,
        quantity: typing.Optional[int] = None,
        slug: typing.Optional[str] = None,
        tax_category: typing.Optional["TaxCategoryResourceIdentifier"] = None,
        custom: typing.Optional["CustomFieldsDraft"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.money = money
        self.name = name
        self.quantity = quantity
        self.slug = slug
        self.tax_category = tax_category
        self.custom = custom
        self.external_tax_rate = external_tax_rate
        super().__init__(action="addCustomLineItem")

    def __repr__(self) -> str:
        return (
            "StagedOrderAddCustomLineItemAction(action=%r, money=%r, name=%r, quantity=%r, slug=%r, tax_category=%r, custom=%r, external_tax_rate=%r)"
            % (
                self.action,
                self.money,
                self.name,
                self.quantity,
                self.slug,
                self.tax_category,
                self.custom,
                self.external_tax_rate,
            )
        )


class StagedOrderAddDeliveryAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderAddDeliveryActionSchema`."
    #: Optional list of :class:`commercetools.types.DeliveryItem`
    items: typing.Optional[typing.List["DeliveryItem"]]
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]
    #: Optional list of :class:`commercetools.types.ParcelDraft`
    parcels: typing.Optional[typing.List["ParcelDraft"]]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        items: typing.Optional[typing.List["DeliveryItem"]] = None,
        address: typing.Optional["Address"] = None,
        parcels: typing.Optional[typing.List["ParcelDraft"]] = None
    ) -> None:
        self.items = items
        self.address = address
        self.parcels = parcels
        super().__init__(action="addDelivery")

    def __repr__(self) -> str:
        return (
            "StagedOrderAddDeliveryAction(action=%r, items=%r, address=%r, parcels=%r)"
            % (self.action, self.items, self.address, self.parcels)
        )


class StagedOrderAddDiscountCodeAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderAddDiscountCodeActionSchema`."
    #: :class:`str`
    code: typing.Optional[str]

    def __init__(
        self, *, action: typing.Optional[str] = None, code: typing.Optional[str] = None
    ) -> None:
        self.code = code
        super().__init__(action="addDiscountCode")

    def __repr__(self) -> str:
        return "StagedOrderAddDiscountCodeAction(action=%r, code=%r)" % (
            self.action,
            self.code,
        )


class StagedOrderAddItemShippingAddressAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderAddItemShippingAddressActionSchema`."
    #: :class:`commercetools.types.Address`
    address: typing.Optional["Address"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        address: typing.Optional["Address"] = None
    ) -> None:
        self.address = address
        super().__init__(action="addItemShippingAddress")

    def __repr__(self) -> str:
        return "StagedOrderAddItemShippingAddressAction(action=%r, address=%r)" % (
            self.action,
            self.address,
        )


class StagedOrderAddLineItemAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderAddLineItemActionSchema`."
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``distributionChannel`` `in Commercetools)`
    distribution_channel: typing.Optional["ChannelResourceIdentifier"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]
    #: Optional :class:`str` `(Named` ``productId`` `in Commercetools)`
    product_id: typing.Optional[str]
    #: Optional :class:`int` `(Named` ``variantId`` `in Commercetools)`
    variant_id: typing.Optional[int]
    #: Optional :class:`str`
    sku: typing.Optional[str]
    #: Optional :class:`int`
    quantity: typing.Optional[int]
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``supplyChannel`` `in Commercetools)`
    supply_channel: typing.Optional["ChannelResourceIdentifier"]
    #: Optional :class:`commercetools.types.Money` `(Named` ``externalPrice`` `in Commercetools)`
    external_price: typing.Optional["Money"]
    #: Optional :class:`commercetools.types.ExternalLineItemTotalPrice` `(Named` ``externalTotalPrice`` `in Commercetools)`
    external_total_price: typing.Optional["ExternalLineItemTotalPrice"]
    #: Optional :class:`commercetools.types.ItemShippingDetailsDraft` `(Named` ``shippingDetails`` `in Commercetools)`
    shipping_details: typing.Optional["ItemShippingDetailsDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        custom: typing.Optional["CustomFieldsDraft"] = None,
        distribution_channel: typing.Optional["ChannelResourceIdentifier"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None,
        product_id: typing.Optional[str] = None,
        variant_id: typing.Optional[int] = None,
        sku: typing.Optional[str] = None,
        quantity: typing.Optional[int] = None,
        supply_channel: typing.Optional["ChannelResourceIdentifier"] = None,
        external_price: typing.Optional["Money"] = None,
        external_total_price: typing.Optional["ExternalLineItemTotalPrice"] = None,
        shipping_details: typing.Optional["ItemShippingDetailsDraft"] = None
    ) -> None:
        self.custom = custom
        self.distribution_channel = distribution_channel
        self.external_tax_rate = external_tax_rate
        self.product_id = product_id
        self.variant_id = variant_id
        self.sku = sku
        self.quantity = quantity
        self.supply_channel = supply_channel
        self.external_price = external_price
        self.external_total_price = external_total_price
        self.shipping_details = shipping_details
        super().__init__(action="addLineItem")

    def __repr__(self) -> str:
        return (
            "StagedOrderAddLineItemAction(action=%r, custom=%r, distribution_channel=%r, external_tax_rate=%r, product_id=%r, variant_id=%r, sku=%r, quantity=%r, supply_channel=%r, external_price=%r, external_total_price=%r, shipping_details=%r)"
            % (
                self.action,
                self.custom,
                self.distribution_channel,
                self.external_tax_rate,
                self.product_id,
                self.variant_id,
                self.sku,
                self.quantity,
                self.supply_channel,
                self.external_price,
                self.external_total_price,
                self.shipping_details,
            )
        )


class StagedOrderAddParcelToDeliveryAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderAddParcelToDeliveryActionSchema`."
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.ParcelMeasurements`
    measurements: typing.Optional["ParcelMeasurements"]
    #: Optional :class:`commercetools.types.TrackingData` `(Named` ``trackingData`` `in Commercetools)`
    tracking_data: typing.Optional["TrackingData"]
    #: Optional list of :class:`commercetools.types.DeliveryItem`
    items: typing.Optional[typing.List["DeliveryItem"]]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        delivery_id: typing.Optional[str] = None,
        measurements: typing.Optional["ParcelMeasurements"] = None,
        tracking_data: typing.Optional["TrackingData"] = None,
        items: typing.Optional[typing.List["DeliveryItem"]] = None
    ) -> None:
        self.delivery_id = delivery_id
        self.measurements = measurements
        self.tracking_data = tracking_data
        self.items = items
        super().__init__(action="addParcelToDelivery")

    def __repr__(self) -> str:
        return (
            "StagedOrderAddParcelToDeliveryAction(action=%r, delivery_id=%r, measurements=%r, tracking_data=%r, items=%r)"
            % (
                self.action,
                self.delivery_id,
                self.measurements,
                self.tracking_data,
                self.items,
            )
        )


class StagedOrderAddPaymentAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderAddPaymentActionSchema`."
    #: :class:`commercetools.types.PaymentResourceIdentifier`
    payment: typing.Optional["PaymentResourceIdentifier"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        payment: typing.Optional["PaymentResourceIdentifier"] = None
    ) -> None:
        self.payment = payment
        super().__init__(action="addPayment")

    def __repr__(self) -> str:
        return "StagedOrderAddPaymentAction(action=%r, payment=%r)" % (
            self.action,
            self.payment,
        )


class StagedOrderAddReturnInfoAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderAddReturnInfoActionSchema`."
    #: Optional :class:`str` `(Named` ``returnTrackingId`` `in Commercetools)`
    return_tracking_id: typing.Optional[str]
    #: List of :class:`commercetools.types.ReturnItemDraft`
    items: typing.Optional[typing.List["ReturnItemDraft"]]
    #: Optional :class:`datetime.datetime` `(Named` ``returnDate`` `in Commercetools)`
    return_date: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        return_tracking_id: typing.Optional[str] = None,
        items: typing.Optional[typing.List["ReturnItemDraft"]] = None,
        return_date: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.return_tracking_id = return_tracking_id
        self.items = items
        self.return_date = return_date
        super().__init__(action="addReturnInfo")

    def __repr__(self) -> str:
        return (
            "StagedOrderAddReturnInfoAction(action=%r, return_tracking_id=%r, items=%r, return_date=%r)"
            % (self.action, self.return_tracking_id, self.items, self.return_date)
        )


class StagedOrderAddShoppingListAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderAddShoppingListActionSchema`."
    #: :class:`commercetools.types.ShoppingListResourceIdentifier` `(Named` ``shoppingList`` `in Commercetools)`
    shopping_list: typing.Optional["ShoppingListResourceIdentifier"]
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``supplyChannel`` `in Commercetools)`
    supply_channel: typing.Optional["ChannelResourceIdentifier"]
    #: Optional :class:`commercetools.types.ChannelResourceIdentifier` `(Named` ``distributionChannel`` `in Commercetools)`
    distribution_channel: typing.Optional["ChannelResourceIdentifier"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        shopping_list: typing.Optional["ShoppingListResourceIdentifier"] = None,
        supply_channel: typing.Optional["ChannelResourceIdentifier"] = None,
        distribution_channel: typing.Optional["ChannelResourceIdentifier"] = None
    ) -> None:
        self.shopping_list = shopping_list
        self.supply_channel = supply_channel
        self.distribution_channel = distribution_channel
        super().__init__(action="addShoppingList")

    def __repr__(self) -> str:
        return (
            "StagedOrderAddShoppingListAction(action=%r, shopping_list=%r, supply_channel=%r, distribution_channel=%r)"
            % (
                self.action,
                self.shopping_list,
                self.supply_channel,
                self.distribution_channel,
            )
        )


class StagedOrderChangeCustomLineItemMoneyAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderChangeCustomLineItemMoneyActionSchema`."
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: typing.Optional[str]
    #: :class:`commercetools.types.Money`
    money: typing.Optional["Money"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        custom_line_item_id: typing.Optional[str] = None,
        money: typing.Optional["Money"] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.money = money
        super().__init__(action="changeCustomLineItemMoney")

    def __repr__(self) -> str:
        return (
            "StagedOrderChangeCustomLineItemMoneyAction(action=%r, custom_line_item_id=%r, money=%r)"
            % (self.action, self.custom_line_item_id, self.money)
        )


class StagedOrderChangeCustomLineItemQuantityAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderChangeCustomLineItemQuantityActionSchema`."
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: typing.Optional[str]
    #: :class:`int`
    quantity: typing.Optional[int]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        custom_line_item_id: typing.Optional[str] = None,
        quantity: typing.Optional[int] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.quantity = quantity
        super().__init__(action="changeCustomLineItemQuantity")

    def __repr__(self) -> str:
        return (
            "StagedOrderChangeCustomLineItemQuantityAction(action=%r, custom_line_item_id=%r, quantity=%r)"
            % (self.action, self.custom_line_item_id, self.quantity)
        )


class StagedOrderChangeLineItemQuantityAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderChangeLineItemQuantityActionSchema`."
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: typing.Optional[str]
    #: :class:`int`
    quantity: typing.Optional[int]
    #: Optional :class:`commercetools.types.Money` `(Named` ``externalPrice`` `in Commercetools)`
    external_price: typing.Optional["Money"]
    #: Optional :class:`commercetools.types.ExternalLineItemTotalPrice` `(Named` ``externalTotalPrice`` `in Commercetools)`
    external_total_price: typing.Optional["ExternalLineItemTotalPrice"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        line_item_id: typing.Optional[str] = None,
        quantity: typing.Optional[int] = None,
        external_price: typing.Optional["Money"] = None,
        external_total_price: typing.Optional["ExternalLineItemTotalPrice"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.quantity = quantity
        self.external_price = external_price
        self.external_total_price = external_total_price
        super().__init__(action="changeLineItemQuantity")

    def __repr__(self) -> str:
        return (
            "StagedOrderChangeLineItemQuantityAction(action=%r, line_item_id=%r, quantity=%r, external_price=%r, external_total_price=%r)"
            % (
                self.action,
                self.line_item_id,
                self.quantity,
                self.external_price,
                self.external_total_price,
            )
        )


class StagedOrderChangeOrderStateAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderChangeOrderStateActionSchema`."
    #: :class:`commercetools.types.OrderState` `(Named` ``orderState`` `in Commercetools)`
    order_state: typing.Optional["OrderState"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        order_state: typing.Optional["OrderState"] = None
    ) -> None:
        self.order_state = order_state
        super().__init__(action="changeOrderState")

    def __repr__(self) -> str:
        return "StagedOrderChangeOrderStateAction(action=%r, order_state=%r)" % (
            self.action,
            self.order_state,
        )


class StagedOrderChangePaymentStateAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderChangePaymentStateActionSchema`."
    #: Optional :class:`commercetools.types.PaymentState` `(Named` ``paymentState`` `in Commercetools)`
    payment_state: typing.Optional["PaymentState"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        payment_state: typing.Optional["PaymentState"] = None
    ) -> None:
        self.payment_state = payment_state
        super().__init__(action="changePaymentState")

    def __repr__(self) -> str:
        return "StagedOrderChangePaymentStateAction(action=%r, payment_state=%r)" % (
            self.action,
            self.payment_state,
        )


class StagedOrderChangeShipmentStateAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderChangeShipmentStateActionSchema`."
    #: Optional :class:`commercetools.types.ShipmentState` `(Named` ``shipmentState`` `in Commercetools)`
    shipment_state: typing.Optional["ShipmentState"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        shipment_state: typing.Optional["ShipmentState"] = None
    ) -> None:
        self.shipment_state = shipment_state
        super().__init__(action="changeShipmentState")

    def __repr__(self) -> str:
        return "StagedOrderChangeShipmentStateAction(action=%r, shipment_state=%r)" % (
            self.action,
            self.shipment_state,
        )


class StagedOrderChangeTaxCalculationModeAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderChangeTaxCalculationModeActionSchema`."
    #: :class:`commercetools.types.TaxCalculationMode` `(Named` ``taxCalculationMode`` `in Commercetools)`
    tax_calculation_mode: typing.Optional["TaxCalculationMode"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        tax_calculation_mode: typing.Optional["TaxCalculationMode"] = None
    ) -> None:
        self.tax_calculation_mode = tax_calculation_mode
        super().__init__(action="changeTaxCalculationMode")

    def __repr__(self) -> str:
        return (
            "StagedOrderChangeTaxCalculationModeAction(action=%r, tax_calculation_mode=%r)"
            % (self.action, self.tax_calculation_mode)
        )


class StagedOrderChangeTaxModeAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderChangeTaxModeActionSchema`."
    #: :class:`commercetools.types.TaxMode` `(Named` ``taxMode`` `in Commercetools)`
    tax_mode: typing.Optional["TaxMode"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        tax_mode: typing.Optional["TaxMode"] = None
    ) -> None:
        self.tax_mode = tax_mode
        super().__init__(action="changeTaxMode")

    def __repr__(self) -> str:
        return "StagedOrderChangeTaxModeAction(action=%r, tax_mode=%r)" % (
            self.action,
            self.tax_mode,
        )


class StagedOrderChangeTaxRoundingModeAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderChangeTaxRoundingModeActionSchema`."
    #: :class:`commercetools.types.RoundingMode` `(Named` ``taxRoundingMode`` `in Commercetools)`
    tax_rounding_mode: typing.Optional["RoundingMode"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        tax_rounding_mode: typing.Optional["RoundingMode"] = None
    ) -> None:
        self.tax_rounding_mode = tax_rounding_mode
        super().__init__(action="changeTaxRoundingMode")

    def __repr__(self) -> str:
        return (
            "StagedOrderChangeTaxRoundingModeAction(action=%r, tax_rounding_mode=%r)"
            % (self.action, self.tax_rounding_mode)
        )


class StagedOrderImportCustomLineItemStateAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderImportCustomLineItemStateActionSchema`."
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: typing.Optional[str]
    #: List of :class:`commercetools.types.ItemState`
    state: typing.Optional[typing.List["ItemState"]]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        custom_line_item_id: typing.Optional[str] = None,
        state: typing.Optional[typing.List["ItemState"]] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.state = state
        super().__init__(action="importCustomLineItemState")

    def __repr__(self) -> str:
        return (
            "StagedOrderImportCustomLineItemStateAction(action=%r, custom_line_item_id=%r, state=%r)"
            % (self.action, self.custom_line_item_id, self.state)
        )


class StagedOrderImportLineItemStateAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderImportLineItemStateActionSchema`."
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: typing.Optional[str]
    #: List of :class:`commercetools.types.ItemState`
    state: typing.Optional[typing.List["ItemState"]]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        line_item_id: typing.Optional[str] = None,
        state: typing.Optional[typing.List["ItemState"]] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.state = state
        super().__init__(action="importLineItemState")

    def __repr__(self) -> str:
        return (
            "StagedOrderImportLineItemStateAction(action=%r, line_item_id=%r, state=%r)"
            % (self.action, self.line_item_id, self.state)
        )


class StagedOrderRemoveCustomLineItemAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderRemoveCustomLineItemActionSchema`."
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: typing.Optional[str]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        custom_line_item_id: typing.Optional[str] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        super().__init__(action="removeCustomLineItem")

    def __repr__(self) -> str:
        return (
            "StagedOrderRemoveCustomLineItemAction(action=%r, custom_line_item_id=%r)"
            % (self.action, self.custom_line_item_id)
        )


class StagedOrderRemoveDeliveryAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderRemoveDeliveryActionSchema`."
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: typing.Optional[str]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        delivery_id: typing.Optional[str] = None
    ) -> None:
        self.delivery_id = delivery_id
        super().__init__(action="removeDelivery")

    def __repr__(self) -> str:
        return "StagedOrderRemoveDeliveryAction(action=%r, delivery_id=%r)" % (
            self.action,
            self.delivery_id,
        )


class StagedOrderRemoveDiscountCodeAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderRemoveDiscountCodeActionSchema`."
    #: :class:`commercetools.types.DiscountCodeReference` `(Named` ``discountCode`` `in Commercetools)`
    discount_code: typing.Optional["DiscountCodeReference"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        discount_code: typing.Optional["DiscountCodeReference"] = None
    ) -> None:
        self.discount_code = discount_code
        super().__init__(action="removeDiscountCode")

    def __repr__(self) -> str:
        return "StagedOrderRemoveDiscountCodeAction(action=%r, discount_code=%r)" % (
            self.action,
            self.discount_code,
        )


class StagedOrderRemoveItemShippingAddressAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderRemoveItemShippingAddressActionSchema`."
    #: :class:`str` `(Named` ``addressKey`` `in Commercetools)`
    address_key: typing.Optional[str]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        address_key: typing.Optional[str] = None
    ) -> None:
        self.address_key = address_key
        super().__init__(action="removeItemShippingAddress")

    def __repr__(self) -> str:
        return (
            "StagedOrderRemoveItemShippingAddressAction(action=%r, address_key=%r)"
            % (self.action, self.address_key)
        )


class StagedOrderRemoveLineItemAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderRemoveLineItemActionSchema`."
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: typing.Optional[str]
    #: Optional :class:`int`
    quantity: typing.Optional[int]
    #: Optional :class:`commercetools.types.Money` `(Named` ``externalPrice`` `in Commercetools)`
    external_price: typing.Optional["Money"]
    #: Optional :class:`commercetools.types.ExternalLineItemTotalPrice` `(Named` ``externalTotalPrice`` `in Commercetools)`
    external_total_price: typing.Optional["ExternalLineItemTotalPrice"]
    #: Optional :class:`commercetools.types.ItemShippingDetailsDraft` `(Named` ``shippingDetailsToRemove`` `in Commercetools)`
    shipping_details_to_remove: typing.Optional["ItemShippingDetailsDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        line_item_id: typing.Optional[str] = None,
        quantity: typing.Optional[int] = None,
        external_price: typing.Optional["Money"] = None,
        external_total_price: typing.Optional["ExternalLineItemTotalPrice"] = None,
        shipping_details_to_remove: typing.Optional["ItemShippingDetailsDraft"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.quantity = quantity
        self.external_price = external_price
        self.external_total_price = external_total_price
        self.shipping_details_to_remove = shipping_details_to_remove
        super().__init__(action="removeLineItem")

    def __repr__(self) -> str:
        return (
            "StagedOrderRemoveLineItemAction(action=%r, line_item_id=%r, quantity=%r, external_price=%r, external_total_price=%r, shipping_details_to_remove=%r)"
            % (
                self.action,
                self.line_item_id,
                self.quantity,
                self.external_price,
                self.external_total_price,
                self.shipping_details_to_remove,
            )
        )


class StagedOrderRemoveParcelFromDeliveryAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderRemoveParcelFromDeliveryActionSchema`."
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: typing.Optional[str]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        parcel_id: typing.Optional[str] = None
    ) -> None:
        self.parcel_id = parcel_id
        super().__init__(action="removeParcelFromDelivery")

    def __repr__(self) -> str:
        return "StagedOrderRemoveParcelFromDeliveryAction(action=%r, parcel_id=%r)" % (
            self.action,
            self.parcel_id,
        )


class StagedOrderRemovePaymentAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderRemovePaymentActionSchema`."
    #: :class:`commercetools.types.PaymentResourceIdentifier`
    payment: typing.Optional["PaymentResourceIdentifier"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        payment: typing.Optional["PaymentResourceIdentifier"] = None
    ) -> None:
        self.payment = payment
        super().__init__(action="removePayment")

    def __repr__(self) -> str:
        return "StagedOrderRemovePaymentAction(action=%r, payment=%r)" % (
            self.action,
            self.payment,
        )


class StagedOrderSetBillingAddressAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetBillingAddressActionSchema`."
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        address: typing.Optional["Address"] = None
    ) -> None:
        self.address = address
        super().__init__(action="setBillingAddress")

    def __repr__(self) -> str:
        return "StagedOrderSetBillingAddressAction(action=%r, address=%r)" % (
            self.action,
            self.address,
        )


class StagedOrderSetCountryAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetCountryActionSchema`."
    #: Optional :class:`str`
    country: typing.Optional[str]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        country: typing.Optional[str] = None
    ) -> None:
        self.country = country
        super().__init__(action="setCountry")

    def __repr__(self) -> str:
        return "StagedOrderSetCountryAction(action=%r, country=%r)" % (
            self.action,
            self.country,
        )


class StagedOrderSetCustomFieldAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetCustomFieldActionSchema`."
    #: :class:`str`
    name: typing.Optional[str]
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        value: typing.Optional[typing.Any] = None
    ) -> None:
        self.name = name
        self.value = value
        super().__init__(action="setCustomField")

    def __repr__(self) -> str:
        return "StagedOrderSetCustomFieldAction(action=%r, name=%r, value=%r)" % (
            self.action,
            self.name,
            self.value,
        )


class StagedOrderSetCustomLineItemCustomFieldAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetCustomLineItemCustomFieldActionSchema`."
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: typing.Optional[str]
    #: :class:`str`
    name: typing.Optional[str]
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        custom_line_item_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        value: typing.Optional[typing.Any] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.name = name
        self.value = value
        super().__init__(action="setCustomLineItemCustomField")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetCustomLineItemCustomFieldAction(action=%r, custom_line_item_id=%r, name=%r, value=%r)"
            % (self.action, self.custom_line_item_id, self.name, self.value)
        )


class StagedOrderSetCustomLineItemCustomTypeAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetCustomLineItemCustomTypeActionSchema`."
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        custom_line_item_id: typing.Optional[str] = None,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.type = type
        self.fields = fields
        super().__init__(action="setCustomLineItemCustomType")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetCustomLineItemCustomTypeAction(action=%r, custom_line_item_id=%r, type=%r, fields=%r)"
            % (self.action, self.custom_line_item_id, self.type, self.fields)
        )


class StagedOrderSetCustomLineItemShippingDetailsAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetCustomLineItemShippingDetailsActionSchema`."
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.ItemShippingDetailsDraft` `(Named` ``shippingDetails`` `in Commercetools)`
    shipping_details: typing.Optional["ItemShippingDetailsDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        custom_line_item_id: typing.Optional[str] = None,
        shipping_details: typing.Optional["ItemShippingDetailsDraft"] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.shipping_details = shipping_details
        super().__init__(action="setCustomLineItemShippingDetails")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetCustomLineItemShippingDetailsAction(action=%r, custom_line_item_id=%r, shipping_details=%r)"
            % (self.action, self.custom_line_item_id, self.shipping_details)
        )


class StagedOrderSetCustomLineItemTaxAmountAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetCustomLineItemTaxAmountActionSchema`."
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.ExternalTaxAmountDraft` `(Named` ``externalTaxAmount`` `in Commercetools)`
    external_tax_amount: typing.Optional["ExternalTaxAmountDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        custom_line_item_id: typing.Optional[str] = None,
        external_tax_amount: typing.Optional["ExternalTaxAmountDraft"] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.external_tax_amount = external_tax_amount
        super().__init__(action="setCustomLineItemTaxAmount")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetCustomLineItemTaxAmountAction(action=%r, custom_line_item_id=%r, external_tax_amount=%r)"
            % (self.action, self.custom_line_item_id, self.external_tax_amount)
        )


class StagedOrderSetCustomLineItemTaxRateAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetCustomLineItemTaxRateActionSchema`."
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        custom_line_item_id: typing.Optional[str] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setCustomLineItemTaxRate")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetCustomLineItemTaxRateAction(action=%r, custom_line_item_id=%r, external_tax_rate=%r)"
            % (self.action, self.custom_line_item_id, self.external_tax_rate)
        )


class StagedOrderSetCustomShippingMethodAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetCustomShippingMethodActionSchema`."
    #: :class:`str` `(Named` ``shippingMethodName`` `in Commercetools)`
    shipping_method_name: typing.Optional[str]
    #: :class:`commercetools.types.ShippingRateDraft` `(Named` ``shippingRate`` `in Commercetools)`
    shipping_rate: typing.Optional["ShippingRateDraft"]
    #: Optional :class:`commercetools.types.TaxCategoryResourceIdentifier` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: typing.Optional["TaxCategoryResourceIdentifier"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        shipping_method_name: typing.Optional[str] = None,
        shipping_rate: typing.Optional["ShippingRateDraft"] = None,
        tax_category: typing.Optional["TaxCategoryResourceIdentifier"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.shipping_method_name = shipping_method_name
        self.shipping_rate = shipping_rate
        self.tax_category = tax_category
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setCustomShippingMethod")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetCustomShippingMethodAction(action=%r, shipping_method_name=%r, shipping_rate=%r, tax_category=%r, external_tax_rate=%r)"
            % (
                self.action,
                self.shipping_method_name,
                self.shipping_rate,
                self.tax_category,
                self.external_tax_rate,
            )
        )


class StagedOrderSetCustomTypeAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetCustomTypeActionSchema`."
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.type = type
        self.fields = fields
        super().__init__(action="setCustomType")

    def __repr__(self) -> str:
        return "StagedOrderSetCustomTypeAction(action=%r, type=%r, fields=%r)" % (
            self.action,
            self.type,
            self.fields,
        )


class StagedOrderSetCustomerEmailAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetCustomerEmailActionSchema`."
    #: Optional :class:`str`
    email: typing.Optional[str]

    def __init__(
        self, *, action: typing.Optional[str] = None, email: typing.Optional[str] = None
    ) -> None:
        self.email = email
        super().__init__(action="setCustomerEmail")

    def __repr__(self) -> str:
        return "StagedOrderSetCustomerEmailAction(action=%r, email=%r)" % (
            self.action,
            self.email,
        )


class StagedOrderSetCustomerGroupAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetCustomerGroupActionSchema`."
    #: Optional :class:`commercetools.types.CustomerGroupResourceIdentifier` `(Named` ``customerGroup`` `in Commercetools)`
    customer_group: typing.Optional["CustomerGroupResourceIdentifier"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        customer_group: typing.Optional["CustomerGroupResourceIdentifier"] = None
    ) -> None:
        self.customer_group = customer_group
        super().__init__(action="setCustomerGroup")

    def __repr__(self) -> str:
        return "StagedOrderSetCustomerGroupAction(action=%r, customer_group=%r)" % (
            self.action,
            self.customer_group,
        )


class StagedOrderSetCustomerIdAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetCustomerIdActionSchema`."
    #: Optional :class:`str` `(Named` ``customerId`` `in Commercetools)`
    customer_id: typing.Optional[str]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        customer_id: typing.Optional[str] = None
    ) -> None:
        self.customer_id = customer_id
        super().__init__(action="setCustomerId")

    def __repr__(self) -> str:
        return "StagedOrderSetCustomerIdAction(action=%r, customer_id=%r)" % (
            self.action,
            self.customer_id,
        )


class StagedOrderSetDeliveryAddressAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetDeliveryAddressActionSchema`."
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        delivery_id: typing.Optional[str] = None,
        address: typing.Optional["Address"] = None
    ) -> None:
        self.delivery_id = delivery_id
        self.address = address
        super().__init__(action="setDeliveryAddress")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetDeliveryAddressAction(action=%r, delivery_id=%r, address=%r)"
            % (self.action, self.delivery_id, self.address)
        )


class StagedOrderSetDeliveryItemsAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetDeliveryItemsActionSchema`."
    #: :class:`str` `(Named` ``deliveryId`` `in Commercetools)`
    delivery_id: typing.Optional[str]
    #: List of :class:`commercetools.types.DeliveryItem`
    items: typing.Optional[typing.List["DeliveryItem"]]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        delivery_id: typing.Optional[str] = None,
        items: typing.Optional[typing.List["DeliveryItem"]] = None
    ) -> None:
        self.delivery_id = delivery_id
        self.items = items
        super().__init__(action="setDeliveryItems")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetDeliveryItemsAction(action=%r, delivery_id=%r, items=%r)"
            % (self.action, self.delivery_id, self.items)
        )


class StagedOrderSetLineItemCustomFieldAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetLineItemCustomFieldActionSchema`."
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: typing.Optional[str]
    #: :class:`str`
    name: typing.Optional[str]
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        line_item_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        value: typing.Optional[typing.Any] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.name = name
        self.value = value
        super().__init__(action="setLineItemCustomField")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetLineItemCustomFieldAction(action=%r, line_item_id=%r, name=%r, value=%r)"
            % (self.action, self.line_item_id, self.name, self.value)
        )


class StagedOrderSetLineItemCustomTypeAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetLineItemCustomTypeActionSchema`."
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        line_item_id: typing.Optional[str] = None,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.type = type
        self.fields = fields
        super().__init__(action="setLineItemCustomType")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetLineItemCustomTypeAction(action=%r, line_item_id=%r, type=%r, fields=%r)"
            % (self.action, self.line_item_id, self.type, self.fields)
        )


class StagedOrderSetLineItemPriceAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetLineItemPriceActionSchema`."
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.Money` `(Named` ``externalPrice`` `in Commercetools)`
    external_price: typing.Optional["Money"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        line_item_id: typing.Optional[str] = None,
        external_price: typing.Optional["Money"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.external_price = external_price
        super().__init__(action="setLineItemPrice")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetLineItemPriceAction(action=%r, line_item_id=%r, external_price=%r)"
            % (self.action, self.line_item_id, self.external_price)
        )


class StagedOrderSetLineItemShippingDetailsAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetLineItemShippingDetailsActionSchema`."
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.ItemShippingDetailsDraft` `(Named` ``shippingDetails`` `in Commercetools)`
    shipping_details: typing.Optional["ItemShippingDetailsDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        line_item_id: typing.Optional[str] = None,
        shipping_details: typing.Optional["ItemShippingDetailsDraft"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.shipping_details = shipping_details
        super().__init__(action="setLineItemShippingDetails")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetLineItemShippingDetailsAction(action=%r, line_item_id=%r, shipping_details=%r)"
            % (self.action, self.line_item_id, self.shipping_details)
        )


class StagedOrderSetLineItemTaxAmountAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetLineItemTaxAmountActionSchema`."
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.ExternalTaxAmountDraft` `(Named` ``externalTaxAmount`` `in Commercetools)`
    external_tax_amount: typing.Optional["ExternalTaxAmountDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        line_item_id: typing.Optional[str] = None,
        external_tax_amount: typing.Optional["ExternalTaxAmountDraft"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.external_tax_amount = external_tax_amount
        super().__init__(action="setLineItemTaxAmount")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetLineItemTaxAmountAction(action=%r, line_item_id=%r, external_tax_amount=%r)"
            % (self.action, self.line_item_id, self.external_tax_amount)
        )


class StagedOrderSetLineItemTaxRateAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetLineItemTaxRateActionSchema`."
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        line_item_id: typing.Optional[str] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setLineItemTaxRate")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetLineItemTaxRateAction(action=%r, line_item_id=%r, external_tax_rate=%r)"
            % (self.action, self.line_item_id, self.external_tax_rate)
        )


class StagedOrderSetLineItemTotalPriceAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetLineItemTotalPriceActionSchema`."
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.ExternalLineItemTotalPrice` `(Named` ``externalTotalPrice`` `in Commercetools)`
    external_total_price: typing.Optional["ExternalLineItemTotalPrice"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        line_item_id: typing.Optional[str] = None,
        external_total_price: typing.Optional["ExternalLineItemTotalPrice"] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.external_total_price = external_total_price
        super().__init__(action="setLineItemTotalPrice")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetLineItemTotalPriceAction(action=%r, line_item_id=%r, external_total_price=%r)"
            % (self.action, self.line_item_id, self.external_total_price)
        )


class StagedOrderSetLocaleAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetLocaleActionSchema`."
    #: Optional :class:`str`
    locale: typing.Optional[str]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        locale: typing.Optional[str] = None
    ) -> None:
        self.locale = locale
        super().__init__(action="setLocale")

    def __repr__(self) -> str:
        return "StagedOrderSetLocaleAction(action=%r, locale=%r)" % (
            self.action,
            self.locale,
        )


class StagedOrderSetOrderNumberAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetOrderNumberActionSchema`."
    #: Optional :class:`str` `(Named` ``orderNumber`` `in Commercetools)`
    order_number: typing.Optional[str]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        order_number: typing.Optional[str] = None
    ) -> None:
        self.order_number = order_number
        super().__init__(action="setOrderNumber")

    def __repr__(self) -> str:
        return "StagedOrderSetOrderNumberAction(action=%r, order_number=%r)" % (
            self.action,
            self.order_number,
        )


class StagedOrderSetOrderTotalTaxAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetOrderTotalTaxActionSchema`."
    #: :class:`commercetools.types.Money` `(Named` ``externalTotalGross`` `in Commercetools)`
    external_total_gross: typing.Optional["Money"]
    #: Optional list of :class:`commercetools.types.TaxPortionDraft` `(Named` ``externalTaxPortions`` `in Commercetools)`
    external_tax_portions: typing.Optional[typing.List["TaxPortionDraft"]]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        external_total_gross: typing.Optional["Money"] = None,
        external_tax_portions: typing.Optional[typing.List["TaxPortionDraft"]] = None
    ) -> None:
        self.external_total_gross = external_total_gross
        self.external_tax_portions = external_tax_portions
        super().__init__(action="setOrderTotalTax")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetOrderTotalTaxAction(action=%r, external_total_gross=%r, external_tax_portions=%r)"
            % (self.action, self.external_total_gross, self.external_tax_portions)
        )


class StagedOrderSetParcelItemsAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetParcelItemsActionSchema`."
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: typing.Optional[str]
    #: List of :class:`commercetools.types.DeliveryItem`
    items: typing.Optional[typing.List["DeliveryItem"]]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        parcel_id: typing.Optional[str] = None,
        items: typing.Optional[typing.List["DeliveryItem"]] = None
    ) -> None:
        self.parcel_id = parcel_id
        self.items = items
        super().__init__(action="setParcelItems")

    def __repr__(self) -> str:
        return "StagedOrderSetParcelItemsAction(action=%r, parcel_id=%r, items=%r)" % (
            self.action,
            self.parcel_id,
            self.items,
        )


class StagedOrderSetParcelMeasurementsAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetParcelMeasurementsActionSchema`."
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.ParcelMeasurements`
    measurements: typing.Optional["ParcelMeasurements"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        parcel_id: typing.Optional[str] = None,
        measurements: typing.Optional["ParcelMeasurements"] = None
    ) -> None:
        self.parcel_id = parcel_id
        self.measurements = measurements
        super().__init__(action="setParcelMeasurements")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetParcelMeasurementsAction(action=%r, parcel_id=%r, measurements=%r)"
            % (self.action, self.parcel_id, self.measurements)
        )


class StagedOrderSetParcelTrackingDataAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetParcelTrackingDataActionSchema`."
    #: :class:`str` `(Named` ``parcelId`` `in Commercetools)`
    parcel_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.TrackingData` `(Named` ``trackingData`` `in Commercetools)`
    tracking_data: typing.Optional["TrackingData"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        parcel_id: typing.Optional[str] = None,
        tracking_data: typing.Optional["TrackingData"] = None
    ) -> None:
        self.parcel_id = parcel_id
        self.tracking_data = tracking_data
        super().__init__(action="setParcelTrackingData")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetParcelTrackingDataAction(action=%r, parcel_id=%r, tracking_data=%r)"
            % (self.action, self.parcel_id, self.tracking_data)
        )


class StagedOrderSetReturnPaymentStateAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetReturnPaymentStateActionSchema`."
    #: :class:`str` `(Named` ``returnItemId`` `in Commercetools)`
    return_item_id: typing.Optional[str]
    #: :class:`commercetools.types.ReturnPaymentState` `(Named` ``paymentState`` `in Commercetools)`
    payment_state: typing.Optional["ReturnPaymentState"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        return_item_id: typing.Optional[str] = None,
        payment_state: typing.Optional["ReturnPaymentState"] = None
    ) -> None:
        self.return_item_id = return_item_id
        self.payment_state = payment_state
        super().__init__(action="setReturnPaymentState")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetReturnPaymentStateAction(action=%r, return_item_id=%r, payment_state=%r)"
            % (self.action, self.return_item_id, self.payment_state)
        )


class StagedOrderSetReturnShipmentStateAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetReturnShipmentStateActionSchema`."
    #: :class:`str` `(Named` ``returnItemId`` `in Commercetools)`
    return_item_id: typing.Optional[str]
    #: :class:`commercetools.types.ReturnShipmentState` `(Named` ``shipmentState`` `in Commercetools)`
    shipment_state: typing.Optional["ReturnShipmentState"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        return_item_id: typing.Optional[str] = None,
        shipment_state: typing.Optional["ReturnShipmentState"] = None
    ) -> None:
        self.return_item_id = return_item_id
        self.shipment_state = shipment_state
        super().__init__(action="setReturnShipmentState")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetReturnShipmentStateAction(action=%r, return_item_id=%r, shipment_state=%r)"
            % (self.action, self.return_item_id, self.shipment_state)
        )


class StagedOrderSetShippingAddressAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetShippingAddressActionSchema`."
    #: Optional :class:`commercetools.types.Address`
    address: typing.Optional["Address"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        address: typing.Optional["Address"] = None
    ) -> None:
        self.address = address
        super().__init__(action="setShippingAddress")

    def __repr__(self) -> str:
        return "StagedOrderSetShippingAddressAction(action=%r, address=%r)" % (
            self.action,
            self.address,
        )


class StagedOrderSetShippingAddressAndCustomShippingMethodAction(
    StagedOrderUpdateAction
):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetShippingAddressAndCustomShippingMethodActionSchema`."
    #: :class:`commercetools.types.Address`
    address: typing.Optional["Address"]
    #: :class:`str` `(Named` ``shippingMethodName`` `in Commercetools)`
    shipping_method_name: typing.Optional[str]
    #: :class:`commercetools.types.ShippingRateDraft` `(Named` ``shippingRate`` `in Commercetools)`
    shipping_rate: typing.Optional["ShippingRateDraft"]
    #: Optional :class:`commercetools.types.TaxCategoryResourceIdentifier` `(Named` ``taxCategory`` `in Commercetools)`
    tax_category: typing.Optional["TaxCategoryResourceIdentifier"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        address: typing.Optional["Address"] = None,
        shipping_method_name: typing.Optional[str] = None,
        shipping_rate: typing.Optional["ShippingRateDraft"] = None,
        tax_category: typing.Optional["TaxCategoryResourceIdentifier"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.address = address
        self.shipping_method_name = shipping_method_name
        self.shipping_rate = shipping_rate
        self.tax_category = tax_category
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setShippingAddressAndCustomShippingMethod")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetShippingAddressAndCustomShippingMethodAction(action=%r, address=%r, shipping_method_name=%r, shipping_rate=%r, tax_category=%r, external_tax_rate=%r)"
            % (
                self.action,
                self.address,
                self.shipping_method_name,
                self.shipping_rate,
                self.tax_category,
                self.external_tax_rate,
            )
        )


class StagedOrderSetShippingAddressAndShippingMethodAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetShippingAddressAndShippingMethodActionSchema`."
    #: :class:`commercetools.types.Address`
    address: typing.Optional["Address"]
    #: Optional :class:`commercetools.types.ShippingMethodResourceIdentifier` `(Named` ``shippingMethod`` `in Commercetools)`
    shipping_method: typing.Optional["ShippingMethodResourceIdentifier"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        address: typing.Optional["Address"] = None,
        shipping_method: typing.Optional["ShippingMethodResourceIdentifier"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.address = address
        self.shipping_method = shipping_method
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setShippingAddressAndShippingMethod")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetShippingAddressAndShippingMethodAction(action=%r, address=%r, shipping_method=%r, external_tax_rate=%r)"
            % (self.action, self.address, self.shipping_method, self.external_tax_rate)
        )


class StagedOrderSetShippingMethodAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetShippingMethodActionSchema`."
    #: Optional :class:`commercetools.types.ShippingMethodResourceIdentifier` `(Named` ``shippingMethod`` `in Commercetools)`
    shipping_method: typing.Optional["ShippingMethodResourceIdentifier"]
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        shipping_method: typing.Optional["ShippingMethodResourceIdentifier"] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.shipping_method = shipping_method
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setShippingMethod")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetShippingMethodAction(action=%r, shipping_method=%r, external_tax_rate=%r)"
            % (self.action, self.shipping_method, self.external_tax_rate)
        )


class StagedOrderSetShippingMethodTaxAmountAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetShippingMethodTaxAmountActionSchema`."
    #: Optional :class:`commercetools.types.ExternalTaxAmountDraft` `(Named` ``externalTaxAmount`` `in Commercetools)`
    external_tax_amount: typing.Optional["ExternalTaxAmountDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        external_tax_amount: typing.Optional["ExternalTaxAmountDraft"] = None
    ) -> None:
        self.external_tax_amount = external_tax_amount
        super().__init__(action="setShippingMethodTaxAmount")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetShippingMethodTaxAmountAction(action=%r, external_tax_amount=%r)"
            % (self.action, self.external_tax_amount)
        )


class StagedOrderSetShippingMethodTaxRateAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetShippingMethodTaxRateActionSchema`."
    #: Optional :class:`commercetools.types.ExternalTaxRateDraft` `(Named` ``externalTaxRate`` `in Commercetools)`
    external_tax_rate: typing.Optional["ExternalTaxRateDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        external_tax_rate: typing.Optional["ExternalTaxRateDraft"] = None
    ) -> None:
        self.external_tax_rate = external_tax_rate
        super().__init__(action="setShippingMethodTaxRate")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetShippingMethodTaxRateAction(action=%r, external_tax_rate=%r)"
            % (self.action, self.external_tax_rate)
        )


class StagedOrderSetShippingRateInputAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderSetShippingRateInputActionSchema`."
    #: Optional :class:`commercetools.types.ShippingRateInputDraft` `(Named` ``shippingRateInput`` `in Commercetools)`
    shipping_rate_input: typing.Optional["ShippingRateInputDraft"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        shipping_rate_input: typing.Optional["ShippingRateInputDraft"] = None
    ) -> None:
        self.shipping_rate_input = shipping_rate_input
        super().__init__(action="setShippingRateInput")

    def __repr__(self) -> str:
        return (
            "StagedOrderSetShippingRateInputAction(action=%r, shipping_rate_input=%r)"
            % (self.action, self.shipping_rate_input)
        )


class StagedOrderTransitionCustomLineItemStateAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderTransitionCustomLineItemStateActionSchema`."
    #: :class:`str` `(Named` ``customLineItemId`` `in Commercetools)`
    custom_line_item_id: typing.Optional[str]
    #: :class:`int`
    quantity: typing.Optional[int]
    #: :class:`commercetools.types.StateResourceIdentifier` `(Named` ``fromState`` `in Commercetools)`
    from_state: typing.Optional["StateResourceIdentifier"]
    #: :class:`commercetools.types.StateResourceIdentifier` `(Named` ``toState`` `in Commercetools)`
    to_state: typing.Optional["StateResourceIdentifier"]
    #: Optional :class:`datetime.datetime` `(Named` ``actualTransitionDate`` `in Commercetools)`
    actual_transition_date: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        custom_line_item_id: typing.Optional[str] = None,
        quantity: typing.Optional[int] = None,
        from_state: typing.Optional["StateResourceIdentifier"] = None,
        to_state: typing.Optional["StateResourceIdentifier"] = None,
        actual_transition_date: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.custom_line_item_id = custom_line_item_id
        self.quantity = quantity
        self.from_state = from_state
        self.to_state = to_state
        self.actual_transition_date = actual_transition_date
        super().__init__(action="transitionCustomLineItemState")

    def __repr__(self) -> str:
        return (
            "StagedOrderTransitionCustomLineItemStateAction(action=%r, custom_line_item_id=%r, quantity=%r, from_state=%r, to_state=%r, actual_transition_date=%r)"
            % (
                self.action,
                self.custom_line_item_id,
                self.quantity,
                self.from_state,
                self.to_state,
                self.actual_transition_date,
            )
        )


class StagedOrderTransitionLineItemStateAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderTransitionLineItemStateActionSchema`."
    #: :class:`str` `(Named` ``lineItemId`` `in Commercetools)`
    line_item_id: typing.Optional[str]
    #: :class:`int`
    quantity: typing.Optional[int]
    #: :class:`commercetools.types.StateResourceIdentifier` `(Named` ``fromState`` `in Commercetools)`
    from_state: typing.Optional["StateResourceIdentifier"]
    #: :class:`commercetools.types.StateResourceIdentifier` `(Named` ``toState`` `in Commercetools)`
    to_state: typing.Optional["StateResourceIdentifier"]
    #: Optional :class:`datetime.datetime` `(Named` ``actualTransitionDate`` `in Commercetools)`
    actual_transition_date: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        line_item_id: typing.Optional[str] = None,
        quantity: typing.Optional[int] = None,
        from_state: typing.Optional["StateResourceIdentifier"] = None,
        to_state: typing.Optional["StateResourceIdentifier"] = None,
        actual_transition_date: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.line_item_id = line_item_id
        self.quantity = quantity
        self.from_state = from_state
        self.to_state = to_state
        self.actual_transition_date = actual_transition_date
        super().__init__(action="transitionLineItemState")

    def __repr__(self) -> str:
        return (
            "StagedOrderTransitionLineItemStateAction(action=%r, line_item_id=%r, quantity=%r, from_state=%r, to_state=%r, actual_transition_date=%r)"
            % (
                self.action,
                self.line_item_id,
                self.quantity,
                self.from_state,
                self.to_state,
                self.actual_transition_date,
            )
        )


class StagedOrderTransitionStateAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderTransitionStateActionSchema`."
    #: :class:`commercetools.types.StateResourceIdentifier`
    state: typing.Optional["StateResourceIdentifier"]
    #: Optional :class:`bool`
    force: typing.Optional[bool]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        state: typing.Optional["StateResourceIdentifier"] = None,
        force: typing.Optional[bool] = None
    ) -> None:
        self.state = state
        self.force = force
        super().__init__(action="transitionState")

    def __repr__(self) -> str:
        return "StagedOrderTransitionStateAction(action=%r, state=%r, force=%r)" % (
            self.action,
            self.state,
            self.force,
        )


class StagedOrderUpdateItemShippingAddressAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderUpdateItemShippingAddressActionSchema`."
    #: :class:`commercetools.types.Address`
    address: typing.Optional["Address"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        address: typing.Optional["Address"] = None
    ) -> None:
        self.address = address
        super().__init__(action="updateItemShippingAddress")

    def __repr__(self) -> str:
        return "StagedOrderUpdateItemShippingAddressAction(action=%r, address=%r)" % (
            self.action,
            self.address,
        )


class StagedOrderUpdateSyncInfoAction(StagedOrderUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.StagedOrderUpdateSyncInfoActionSchema`."
    #: :class:`commercetools.types.ChannelResourceIdentifier`
    channel: typing.Optional["ChannelResourceIdentifier"]
    #: Optional :class:`str` `(Named` ``externalId`` `in Commercetools)`
    external_id: typing.Optional[str]
    #: Optional :class:`datetime.datetime` `(Named` ``syncedAt`` `in Commercetools)`
    synced_at: typing.Optional[datetime.datetime]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        channel: typing.Optional["ChannelResourceIdentifier"] = None,
        external_id: typing.Optional[str] = None,
        synced_at: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.channel = channel
        self.external_id = external_id
        self.synced_at = synced_at
        super().__init__(action="updateSyncInfo")

    def __repr__(self) -> str:
        return (
            "StagedOrderUpdateSyncInfoAction(action=%r, channel=%r, external_id=%r, synced_at=%r)"
            % (self.action, self.channel, self.external_id, self.synced_at)
        )


class OrderEditAddStagedActionAction(OrderEditUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditAddStagedActionActionSchema`."
    #: :class:`commercetools.types.StagedOrderUpdateAction` `(Named` ``stagedAction`` `in Commercetools)`
    staged_action: typing.Optional["StagedOrderUpdateAction"]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        staged_action: typing.Optional["StagedOrderUpdateAction"] = None
    ) -> None:
        self.staged_action = staged_action
        super().__init__(action="addStagedAction")

    def __repr__(self) -> str:
        return "OrderEditAddStagedActionAction(action=%r, staged_action=%r)" % (
            self.action,
            self.staged_action,
        )


class OrderEditApplied(OrderEditResult):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditAppliedSchema`."
    #: :class:`datetime.datetime` `(Named` ``appliedAt`` `in Commercetools)`
    applied_at: typing.Optional[datetime.datetime]
    #: :class:`commercetools.types.OrderExcerpt` `(Named` ``excerptBeforeEdit`` `in Commercetools)`
    excerpt_before_edit: typing.Optional["OrderExcerpt"]
    #: :class:`commercetools.types.OrderExcerpt` `(Named` ``excerptAfterEdit`` `in Commercetools)`
    excerpt_after_edit: typing.Optional["OrderExcerpt"]

    def __init__(
        self,
        *,
        type: typing.Optional[str] = None,
        applied_at: typing.Optional[datetime.datetime] = None,
        excerpt_before_edit: typing.Optional["OrderExcerpt"] = None,
        excerpt_after_edit: typing.Optional["OrderExcerpt"] = None
    ) -> None:
        self.applied_at = applied_at
        self.excerpt_before_edit = excerpt_before_edit
        self.excerpt_after_edit = excerpt_after_edit
        super().__init__(type="Applied")

    def __repr__(self) -> str:
        return (
            "OrderEditApplied(type=%r, applied_at=%r, excerpt_before_edit=%r, excerpt_after_edit=%r)"
            % (
                self.type,
                self.applied_at,
                self.excerpt_before_edit,
                self.excerpt_after_edit,
            )
        )


class OrderEditNotProcessed(OrderEditResult):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditNotProcessedSchema`."

    def __init__(self, *, type: typing.Optional[str] = None) -> None:
        super().__init__(type="NotProcessed")

    def __repr__(self) -> str:
        return "OrderEditNotProcessed(type=%r)" % (self.type,)


class OrderEditPreviewFailure(OrderEditResult):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditPreviewFailureSchema`."
    #: List of :class:`commercetools.types.ErrorObject`
    errors: typing.Optional[typing.List["ErrorObject"]]

    def __init__(
        self,
        *,
        type: typing.Optional[str] = None,
        errors: typing.Optional[typing.List["ErrorObject"]] = None
    ) -> None:
        self.errors = errors
        super().__init__(type="PreviewFailure")

    def __repr__(self) -> str:
        return "OrderEditPreviewFailure(type=%r, errors=%r)" % (self.type, self.errors)


class OrderEditPreviewSuccess(OrderEditResult):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditPreviewSuccessSchema`."
    #: :class:`commercetools.types.StagedOrder`
    preview: typing.Optional["StagedOrder"]
    #: List of :class:`commercetools.types.MessagePayload` `(Named` ``messagePayloads`` `in Commercetools)`
    message_payloads: typing.Optional[typing.List["MessagePayload"]]

    def __init__(
        self,
        *,
        type: typing.Optional[str] = None,
        preview: typing.Optional["StagedOrder"] = None,
        message_payloads: typing.Optional[typing.List["MessagePayload"]] = None
    ) -> None:
        self.preview = preview
        self.message_payloads = message_payloads
        super().__init__(type="PreviewSuccess")

    def __repr__(self) -> str:
        return "OrderEditPreviewSuccess(type=%r, preview=%r, message_payloads=%r)" % (
            self.type,
            self.preview,
            self.message_payloads,
        )


class OrderEditSetCommentAction(OrderEditUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditSetCommentActionSchema`."
    #: Optional :class:`str`
    comment: typing.Optional[str]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        comment: typing.Optional[str] = None
    ) -> None:
        self.comment = comment
        super().__init__(action="setComment")

    def __repr__(self) -> str:
        return "OrderEditSetCommentAction(action=%r, comment=%r)" % (
            self.action,
            self.comment,
        )


class OrderEditSetCustomFieldAction(OrderEditUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditSetCustomFieldActionSchema`."
    #: :class:`str`
    name: typing.Optional[str]
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        value: typing.Optional[typing.Any] = None
    ) -> None:
        self.name = name
        self.value = value
        super().__init__(action="setCustomField")

    def __repr__(self) -> str:
        return "OrderEditSetCustomFieldAction(action=%r, name=%r, value=%r)" % (
            self.action,
            self.name,
            self.value,
        )


class OrderEditSetCustomTypeAction(OrderEditUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditSetCustomTypeActionSchema`."
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`object`
    fields: typing.Optional[object]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional[object] = None
    ) -> None:
        self.type = type
        self.fields = fields
        super().__init__(action="setCustomType")

    def __repr__(self) -> str:
        return "OrderEditSetCustomTypeAction(action=%r, type=%r, fields=%r)" % (
            self.action,
            self.type,
            self.fields,
        )


class OrderEditSetKeyAction(OrderEditUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditSetKeyActionSchema`."
    #: Optional :class:`str`
    key: typing.Optional[str]

    def __init__(
        self, *, action: typing.Optional[str] = None, key: typing.Optional[str] = None
    ) -> None:
        self.key = key
        super().__init__(action="setKey")

    def __repr__(self) -> str:
        return "OrderEditSetKeyAction(action=%r, key=%r)" % (self.action, self.key)


class OrderEditSetStagedActionsAction(OrderEditUpdateAction):
    "Corresponding marshmallow schema is :class:`commercetools.schemas.OrderEditSetStagedActionsActionSchema`."
    #: List of :class:`commercetools.types.StagedOrderUpdateAction` `(Named` ``stagedActions`` `in Commercetools)`
    staged_actions: typing.Optional[typing.List["StagedOrderUpdateAction"]]

    def __init__(
        self,
        *,
        action: typing.Optional[str] = None,
        staged_actions: typing.Optional[typing.List["StagedOrderUpdateAction"]] = None
    ) -> None:
        self.staged_actions = staged_actions
        super().__init__(action="setStagedActions")

    def __repr__(self) -> str:
        return "OrderEditSetStagedActionsAction(action=%r, staged_actions=%r)" % (
            self.action,
            self.staged_actions,
        )
