# DO NOT EDIT! This file is automatically generated

import marshmallow
import marshmallow_enum

from commercetools import helpers, types
from commercetools.schemas._common import BaseResourceSchema, LocalizedStringField

__all__ = [
    "CategoryCreatedMessagePayloadSchema",
    "CategoryCreatedMessageSchema",
    "CategorySlugChangedMessagePayloadSchema",
    "CategorySlugChangedMessageSchema",
    "CustomLineItemStateTransitionMessagePayloadSchema",
    "CustomLineItemStateTransitionMessageSchema",
    "CustomerAddressAddedMessagePayloadSchema",
    "CustomerAddressAddedMessageSchema",
    "CustomerAddressChangedMessagePayloadSchema",
    "CustomerAddressChangedMessageSchema",
    "CustomerAddressRemovedMessagePayloadSchema",
    "CustomerAddressRemovedMessageSchema",
    "CustomerCompanyNameSetMessagePayloadSchema",
    "CustomerCompanyNameSetMessageSchema",
    "CustomerCreatedMessagePayloadSchema",
    "CustomerCreatedMessageSchema",
    "CustomerDateOfBirthSetMessagePayloadSchema",
    "CustomerDateOfBirthSetMessageSchema",
    "CustomerEmailChangedMessagePayloadSchema",
    "CustomerEmailChangedMessageSchema",
    "CustomerEmailVerifiedMessagePayloadSchema",
    "CustomerEmailVerifiedMessageSchema",
    "CustomerGroupSetMessagePayloadSchema",
    "CustomerGroupSetMessageSchema",
    "DeliveryAddedMessagePayloadSchema",
    "DeliveryAddedMessageSchema",
    "DeliveryAddressSetMessagePayloadSchema",
    "DeliveryAddressSetMessageSchema",
    "DeliveryItemsUpdatedMessagePayloadSchema",
    "DeliveryItemsUpdatedMessageSchema",
    "DeliveryRemovedMessagePayloadSchema",
    "DeliveryRemovedMessageSchema",
    "InventoryEntryDeletedMessagePayloadSchema",
    "InventoryEntryDeletedMessageSchema",
    "LineItemStateTransitionMessagePayloadSchema",
    "LineItemStateTransitionMessageSchema",
    "MessageConfigurationDraftSchema",
    "MessageConfigurationSchema",
    "MessagePagedQueryResponseSchema",
    "MessagePayloadSchema",
    "MessageSchema",
    "OrderBillingAddressSetMessagePayloadSchema",
    "OrderBillingAddressSetMessageSchema",
    "OrderCreatedMessagePayloadSchema",
    "OrderCreatedMessageSchema",
    "OrderCustomLineItemDiscountSetMessagePayloadSchema",
    "OrderCustomLineItemDiscountSetMessageSchema",
    "OrderCustomerEmailSetMessagePayloadSchema",
    "OrderCustomerEmailSetMessageSchema",
    "OrderCustomerGroupSetMessagePayloadSchema",
    "OrderCustomerGroupSetMessageSchema",
    "OrderCustomerSetMessagePayloadSchema",
    "OrderCustomerSetMessageSchema",
    "OrderDeletedMessagePayloadSchema",
    "OrderDeletedMessageSchema",
    "OrderDiscountCodeAddedMessagePayloadSchema",
    "OrderDiscountCodeAddedMessageSchema",
    "OrderDiscountCodeRemovedMessagePayloadSchema",
    "OrderDiscountCodeRemovedMessageSchema",
    "OrderDiscountCodeStateSetMessagePayloadSchema",
    "OrderDiscountCodeStateSetMessageSchema",
    "OrderEditAppliedMessagePayloadSchema",
    "OrderEditAppliedMessageSchema",
    "OrderImportedMessagePayloadSchema",
    "OrderImportedMessageSchema",
    "OrderLineItemAddedMessagePayloadSchema",
    "OrderLineItemAddedMessageSchema",
    "OrderLineItemDiscountSetMessagePayloadSchema",
    "OrderLineItemDiscountSetMessageSchema",
    "OrderPaymentStateChangedMessagePayloadSchema",
    "OrderPaymentStateChangedMessageSchema",
    "OrderReturnInfoAddedMessagePayloadSchema",
    "OrderReturnInfoAddedMessageSchema",
    "OrderReturnShipmentStateChangedMessagePayloadSchema",
    "OrderReturnShipmentStateChangedMessageSchema",
    "OrderShipmentStateChangedMessagePayloadSchema",
    "OrderShipmentStateChangedMessageSchema",
    "OrderShippingAddressSetMessagePayloadSchema",
    "OrderShippingAddressSetMessageSchema",
    "OrderShippingInfoSetMessagePayloadSchema",
    "OrderShippingInfoSetMessageSchema",
    "OrderShippingRateInputSetMessagePayloadSchema",
    "OrderShippingRateInputSetMessageSchema",
    "OrderStateChangedMessagePayloadSchema",
    "OrderStateChangedMessageSchema",
    "OrderStateTransitionMessagePayloadSchema",
    "OrderStateTransitionMessageSchema",
    "OrderStoreSetMessagePayloadSchema",
    "OrderStoreSetMessageSchema",
    "ParcelAddedToDeliveryMessagePayloadSchema",
    "ParcelAddedToDeliveryMessageSchema",
    "ParcelItemsUpdatedMessagePayloadSchema",
    "ParcelItemsUpdatedMessageSchema",
    "ParcelMeasurementsUpdatedMessagePayloadSchema",
    "ParcelMeasurementsUpdatedMessageSchema",
    "ParcelRemovedFromDeliveryMessagePayloadSchema",
    "ParcelRemovedFromDeliveryMessageSchema",
    "ParcelTrackingDataUpdatedMessagePayloadSchema",
    "ParcelTrackingDataUpdatedMessageSchema",
    "PaymentCreatedMessagePayloadSchema",
    "PaymentCreatedMessageSchema",
    "PaymentInteractionAddedMessagePayloadSchema",
    "PaymentInteractionAddedMessageSchema",
    "PaymentStatusInterfaceCodeSetMessagePayloadSchema",
    "PaymentStatusInterfaceCodeSetMessageSchema",
    "PaymentStatusStateTransitionMessagePayloadSchema",
    "PaymentStatusStateTransitionMessageSchema",
    "PaymentTransactionAddedMessagePayloadSchema",
    "PaymentTransactionAddedMessageSchema",
    "PaymentTransactionStateChangedMessagePayloadSchema",
    "PaymentTransactionStateChangedMessageSchema",
    "ProductAddedToCategoryMessagePayloadSchema",
    "ProductAddedToCategoryMessageSchema",
    "ProductCreatedMessagePayloadSchema",
    "ProductCreatedMessageSchema",
    "ProductDeletedMessagePayloadSchema",
    "ProductDeletedMessageSchema",
    "ProductImageAddedMessagePayloadSchema",
    "ProductImageAddedMessageSchema",
    "ProductPriceDiscountsSetMessagePayloadSchema",
    "ProductPriceDiscountsSetMessageSchema",
    "ProductPriceDiscountsSetUpdatedPriceSchema",
    "ProductPriceExternalDiscountSetMessagePayloadSchema",
    "ProductPriceExternalDiscountSetMessageSchema",
    "ProductPublishedMessagePayloadSchema",
    "ProductPublishedMessageSchema",
    "ProductRemovedFromCategoryMessagePayloadSchema",
    "ProductRemovedFromCategoryMessageSchema",
    "ProductRevertedStagedChangesMessagePayloadSchema",
    "ProductRevertedStagedChangesMessageSchema",
    "ProductSlugChangedMessagePayloadSchema",
    "ProductSlugChangedMessageSchema",
    "ProductStateTransitionMessagePayloadSchema",
    "ProductStateTransitionMessageSchema",
    "ProductUnpublishedMessagePayloadSchema",
    "ProductUnpublishedMessageSchema",
    "ProductVariantDeletedMessagePayloadSchema",
    "ProductVariantDeletedMessageSchema",
    "ReviewCreatedMessagePayloadSchema",
    "ReviewCreatedMessageSchema",
    "ReviewRatingSetMessagePayloadSchema",
    "ReviewRatingSetMessageSchema",
    "ReviewStateTransitionMessagePayloadSchema",
    "ReviewStateTransitionMessageSchema",
    "UserProvidedIdentifiersSchema",
]


class MessageConfigurationDraftSchema(marshmallow.Schema):
    "Marshmallow schema for :class:`commercetools.types.MessageConfigurationDraft`."
    enabled = marshmallow.fields.Bool(allow_none=True)
    delete_days_after_creation = marshmallow.fields.Integer(
        allow_none=True, data_key="deleteDaysAfterCreation"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.MessageConfigurationDraft(**data)


class MessageConfigurationSchema(marshmallow.Schema):
    "Marshmallow schema for :class:`commercetools.types.MessageConfiguration`."
    enabled = marshmallow.fields.Bool(allow_none=True)
    delete_days_after_creation = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="deleteDaysAfterCreation"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.MessageConfiguration(**data)


class MessagePagedQueryResponseSchema(marshmallow.Schema):
    "Marshmallow schema for :class:`commercetools.types.MessagePagedQueryResponse`."
    limit = marshmallow.fields.Integer(allow_none=True)
    count = marshmallow.fields.Integer(allow_none=True)
    total = marshmallow.fields.Integer(allow_none=True, missing=None)
    offset = marshmallow.fields.Integer(allow_none=True)
    results = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("type", "type"),
            discriminator_schemas={
                "CategoryCreated": "commercetools.schemas._message.CategoryCreatedMessageSchema",
                "CategorySlugChanged": "commercetools.schemas._message.CategorySlugChangedMessageSchema",
                "CustomLineItemStateTransition": "commercetools.schemas._message.CustomLineItemStateTransitionMessageSchema",
                "CustomerAddressAdded": "commercetools.schemas._message.CustomerAddressAddedMessageSchema",
                "CustomerAddressChanged": "commercetools.schemas._message.CustomerAddressChangedMessageSchema",
                "CustomerAddressRemoved": "commercetools.schemas._message.CustomerAddressRemovedMessageSchema",
                "CustomerCompanyNameSet": "commercetools.schemas._message.CustomerCompanyNameSetMessageSchema",
                "CustomerCreated": "commercetools.schemas._message.CustomerCreatedMessageSchema",
                "CustomerDateOfBirthSet": "commercetools.schemas._message.CustomerDateOfBirthSetMessageSchema",
                "CustomerEmailChanged": "commercetools.schemas._message.CustomerEmailChangedMessageSchema",
                "CustomerEmailVerified": "commercetools.schemas._message.CustomerEmailVerifiedMessageSchema",
                "CustomerGroupSet": "commercetools.schemas._message.CustomerGroupSetMessageSchema",
                "DeliveryAdded": "commercetools.schemas._message.DeliveryAddedMessageSchema",
                "DeliveryAddressSet": "commercetools.schemas._message.DeliveryAddressSetMessageSchema",
                "DeliveryItemsUpdated": "commercetools.schemas._message.DeliveryItemsUpdatedMessageSchema",
                "DeliveryRemoved": "commercetools.schemas._message.DeliveryRemovedMessageSchema",
                "InventoryEntryDeleted": "commercetools.schemas._message.InventoryEntryDeletedMessageSchema",
                "LineItemStateTransition": "commercetools.schemas._message.LineItemStateTransitionMessageSchema",
                "OrderBillingAddressSet": "commercetools.schemas._message.OrderBillingAddressSetMessageSchema",
                "OrderCreated": "commercetools.schemas._message.OrderCreatedMessageSchema",
                "OrderCustomLineItemDiscountSet": "commercetools.schemas._message.OrderCustomLineItemDiscountSetMessageSchema",
                "OrderCustomerEmailSet": "commercetools.schemas._message.OrderCustomerEmailSetMessageSchema",
                "OrderCustomerGroupSet": "commercetools.schemas._message.OrderCustomerGroupSetMessageSchema",
                "OrderCustomerSet": "commercetools.schemas._message.OrderCustomerSetMessageSchema",
                "OrderDeleted": "commercetools.schemas._message.OrderDeletedMessageSchema",
                "OrderDiscountCodeAdded": "commercetools.schemas._message.OrderDiscountCodeAddedMessageSchema",
                "OrderDiscountCodeRemoved": "commercetools.schemas._message.OrderDiscountCodeRemovedMessageSchema",
                "OrderDiscountCodeStateSet": "commercetools.schemas._message.OrderDiscountCodeStateSetMessageSchema",
                "OrderEditApplied": "commercetools.schemas._message.OrderEditAppliedMessageSchema",
                "OrderImported": "commercetools.schemas._message.OrderImportedMessageSchema",
                "OrderLineItemAdded": "commercetools.schemas._message.OrderLineItemAddedMessageSchema",
                "OrderLineItemDiscountSet": "commercetools.schemas._message.OrderLineItemDiscountSetMessageSchema",
                "OrderPaymentStateChanged": "commercetools.schemas._message.OrderPaymentStateChangedMessageSchema",
                "ReturnInfoAdded": "commercetools.schemas._message.OrderReturnInfoAddedMessageSchema",
                "OrderReturnShipmentStateChanged": "commercetools.schemas._message.OrderReturnShipmentStateChangedMessageSchema",
                "OrderShipmentStateChanged": "commercetools.schemas._message.OrderShipmentStateChangedMessageSchema",
                "OrderShippingAddressSet": "commercetools.schemas._message.OrderShippingAddressSetMessageSchema",
                "OrderShippingInfoSet": "commercetools.schemas._message.OrderShippingInfoSetMessageSchema",
                "OrderShippingRateInputSet": "commercetools.schemas._message.OrderShippingRateInputSetMessageSchema",
                "OrderStateChanged": "commercetools.schemas._message.OrderStateChangedMessageSchema",
                "OrderStateTransition": "commercetools.schemas._message.OrderStateTransitionMessageSchema",
                "OrderStoreSet": "commercetools.schemas._message.OrderStoreSetMessageSchema",
                "ParcelAddedToDelivery": "commercetools.schemas._message.ParcelAddedToDeliveryMessageSchema",
                "ParcelItemsUpdated": "commercetools.schemas._message.ParcelItemsUpdatedMessageSchema",
                "ParcelMeasurementsUpdated": "commercetools.schemas._message.ParcelMeasurementsUpdatedMessageSchema",
                "ParcelRemovedFromDelivery": "commercetools.schemas._message.ParcelRemovedFromDeliveryMessageSchema",
                "ParcelTrackingDataUpdated": "commercetools.schemas._message.ParcelTrackingDataUpdatedMessageSchema",
                "PaymentCreated": "commercetools.schemas._message.PaymentCreatedMessageSchema",
                "PaymentInteractionAdded": "commercetools.schemas._message.PaymentInteractionAddedMessageSchema",
                "PaymentStatusInterfaceCodeSet": "commercetools.schemas._message.PaymentStatusInterfaceCodeSetMessageSchema",
                "PaymentStatusStateTransition": "commercetools.schemas._message.PaymentStatusStateTransitionMessageSchema",
                "PaymentTransactionAdded": "commercetools.schemas._message.PaymentTransactionAddedMessageSchema",
                "PaymentTransactionStateChanged": "commercetools.schemas._message.PaymentTransactionStateChangedMessageSchema",
                "ProductAddedToCategory": "commercetools.schemas._message.ProductAddedToCategoryMessageSchema",
                "ProductCreated": "commercetools.schemas._message.ProductCreatedMessageSchema",
                "ProductDeleted": "commercetools.schemas._message.ProductDeletedMessageSchema",
                "ProductImageAdded": "commercetools.schemas._message.ProductImageAddedMessageSchema",
                "ProductPriceDiscountsSet": "commercetools.schemas._message.ProductPriceDiscountsSetMessageSchema",
                "ProductPriceExternalDiscountSet": "commercetools.schemas._message.ProductPriceExternalDiscountSetMessageSchema",
                "ProductPublished": "commercetools.schemas._message.ProductPublishedMessageSchema",
                "ProductRemovedFromCategory": "commercetools.schemas._message.ProductRemovedFromCategoryMessageSchema",
                "ProductRevertedStagedChanges": "commercetools.schemas._message.ProductRevertedStagedChangesMessageSchema",
                "ProductSlugChanged": "commercetools.schemas._message.ProductSlugChangedMessageSchema",
                "ProductStateTransition": "commercetools.schemas._message.ProductStateTransitionMessageSchema",
                "ProductUnpublished": "commercetools.schemas._message.ProductUnpublishedMessageSchema",
                "ProductVariantDeleted": "commercetools.schemas._message.ProductVariantDeletedMessageSchema",
                "ReviewCreated": "commercetools.schemas._message.ReviewCreatedMessageSchema",
                "ReviewRatingSet": "commercetools.schemas._message.ReviewRatingSetMessageSchema",
                "ReviewStateTransition": "commercetools.schemas._message.ReviewStateTransitionMessageSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        )
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.MessagePagedQueryResponse(**data)


class MessagePayloadSchema(marshmallow.Schema):
    "Marshmallow schema for :class:`commercetools.types.MessagePayload`."
    type = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.MessagePayload(**data)


class MessageSchema(BaseResourceSchema):
    "Marshmallow schema for :class:`commercetools.types.Message`."
    id = marshmallow.fields.String(allow_none=True)
    version = marshmallow.fields.Integer(allow_none=True)
    created_at = marshmallow.fields.DateTime(allow_none=True, data_key="createdAt")
    last_modified_at = marshmallow.fields.DateTime(
        allow_none=True, data_key="lastModifiedAt"
    )
    last_modified_by = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.LastModifiedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="lastModifiedBy",
    )
    created_by = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.CreatedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="createdBy",
    )
    sequence_number = marshmallow.fields.Integer(
        allow_none=True, data_key="sequenceNumber"
    )
    resource = helpers.Discriminator(
        discriminator_field=("typeId", "type_id"),
        discriminator_schemas={
            "cart-discount": "commercetools.schemas._cart_discount.CartDiscountReferenceSchema",
            "cart": "commercetools.schemas._cart.CartReferenceSchema",
            "category": "commercetools.schemas._category.CategoryReferenceSchema",
            "channel": "commercetools.schemas._channel.ChannelReferenceSchema",
            "key-value-document": "commercetools.schemas._custom_object.CustomObjectReferenceSchema",
            "customer-group": "commercetools.schemas._customer_group.CustomerGroupReferenceSchema",
            "customer": "commercetools.schemas._customer.CustomerReferenceSchema",
            "discount-code": "commercetools.schemas._discount_code.DiscountCodeReferenceSchema",
            "inventory-entry": "commercetools.schemas._inventory.InventoryEntryReferenceSchema",
            "order-edit": "commercetools.schemas._order_edit.OrderEditReferenceSchema",
            "order": "commercetools.schemas._order.OrderReferenceSchema",
            "payment": "commercetools.schemas._payment.PaymentReferenceSchema",
            "product-discount": "commercetools.schemas._product_discount.ProductDiscountReferenceSchema",
            "product-type": "commercetools.schemas._product_type.ProductTypeReferenceSchema",
            "product": "commercetools.schemas._product.ProductReferenceSchema",
            "review": "commercetools.schemas._review.ReviewReferenceSchema",
            "shipping-method": "commercetools.schemas._shipping_method.ShippingMethodReferenceSchema",
            "shopping-list": "commercetools.schemas._shopping_list.ShoppingListReferenceSchema",
            "state": "commercetools.schemas._state.StateReferenceSchema",
            "store": "commercetools.schemas._store.StoreReferenceSchema",
            "tax-category": "commercetools.schemas._tax_category.TaxCategoryReferenceSchema",
            "type": "commercetools.schemas._type.TypeReferenceSchema",
            "zone": "commercetools.schemas._zone.ZoneReferenceSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    resource_version = marshmallow.fields.Integer(
        allow_none=True, data_key="resourceVersion"
    )
    type = marshmallow.fields.String(allow_none=True)
    resource_user_provided_identifiers = marshmallow.fields.Nested(
        nested="commercetools.schemas._message.UserProvidedIdentifiersSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="resourceUserProvidedIdentifiers",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.Message(**data)


class ProductPriceDiscountsSetUpdatedPriceSchema(marshmallow.Schema):
    "Marshmallow schema for :class:`commercetools.types.ProductPriceDiscountsSetUpdatedPrice`."
    variant_id = marshmallow.fields.Integer(allow_none=True, data_key="variantId")
    variant_key = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="variantKey"
    )
    sku = marshmallow.fields.String(allow_none=True, missing=None)
    price_id = marshmallow.fields.String(allow_none=True, data_key="priceId")
    discounted = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.DiscountedPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    staged = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ProductPriceDiscountsSetUpdatedPrice(**data)


class UserProvidedIdentifiersSchema(marshmallow.Schema):
    "Marshmallow schema for :class:`commercetools.types.UserProvidedIdentifiers`."
    key = marshmallow.fields.String(allow_none=True, missing=None)
    external_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="externalId"
    )
    order_number = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="orderNumber"
    )
    customer_number = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="customerNumber"
    )
    sku = marshmallow.fields.String(allow_none=True, missing=None)
    slug = LocalizedStringField(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.UserProvidedIdentifiers(**data)


class CategoryCreatedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.CategoryCreatedMessagePayload`."
    category = marshmallow.fields.Nested(
        nested="commercetools.schemas._category.CategorySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CategoryCreatedMessagePayload(**data)


class CategoryCreatedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.CategoryCreatedMessage`."
    category = marshmallow.fields.Nested(
        nested="commercetools.schemas._category.CategorySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CategoryCreatedMessage(**data)


class CategorySlugChangedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.CategorySlugChangedMessagePayload`."
    slug = LocalizedStringField(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CategorySlugChangedMessagePayload(**data)


class CategorySlugChangedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.CategorySlugChangedMessage`."
    slug = LocalizedStringField(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CategorySlugChangedMessage(**data)


class CustomLineItemStateTransitionMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomLineItemStateTransitionMessagePayload`."
    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    transition_date = marshmallow.fields.DateTime(
        allow_none=True, data_key="transitionDate"
    )
    quantity = marshmallow.fields.Integer(allow_none=True)
    from_state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="fromState",
    )
    to_state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="toState",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomLineItemStateTransitionMessagePayload(**data)


class CustomLineItemStateTransitionMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomLineItemStateTransitionMessage`."
    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    transition_date = marshmallow.fields.DateTime(
        allow_none=True, data_key="transitionDate"
    )
    quantity = marshmallow.fields.Integer(allow_none=True)
    from_state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="fromState",
    )
    to_state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="toState",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomLineItemStateTransitionMessage(**data)


class CustomerAddressAddedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerAddressAddedMessagePayload`."
    address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerAddressAddedMessagePayload(**data)


class CustomerAddressAddedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerAddressAddedMessage`."
    address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerAddressAddedMessage(**data)


class CustomerAddressChangedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerAddressChangedMessagePayload`."
    address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerAddressChangedMessagePayload(**data)


class CustomerAddressChangedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerAddressChangedMessage`."
    address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerAddressChangedMessage(**data)


class CustomerAddressRemovedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerAddressRemovedMessagePayload`."
    address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerAddressRemovedMessagePayload(**data)


class CustomerAddressRemovedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerAddressRemovedMessage`."
    address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerAddressRemovedMessage(**data)


class CustomerCompanyNameSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerCompanyNameSetMessagePayload`."
    company_name = marshmallow.fields.String(allow_none=True, data_key="companyName")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerCompanyNameSetMessagePayload(**data)


class CustomerCompanyNameSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerCompanyNameSetMessage`."
    company_name = marshmallow.fields.String(allow_none=True, data_key="companyName")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerCompanyNameSetMessage(**data)


class CustomerCreatedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerCreatedMessagePayload`."
    customer = marshmallow.fields.Nested(
        nested="commercetools.schemas._customer.CustomerSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerCreatedMessagePayload(**data)


class CustomerCreatedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerCreatedMessage`."
    customer = marshmallow.fields.Nested(
        nested="commercetools.schemas._customer.CustomerSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerCreatedMessage(**data)


class CustomerDateOfBirthSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerDateOfBirthSetMessagePayload`."
    date_of_birth = marshmallow.fields.Date(allow_none=True, data_key="dateOfBirth")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerDateOfBirthSetMessagePayload(**data)


class CustomerDateOfBirthSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerDateOfBirthSetMessage`."
    date_of_birth = marshmallow.fields.Date(allow_none=True, data_key="dateOfBirth")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerDateOfBirthSetMessage(**data)


class CustomerEmailChangedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerEmailChangedMessagePayload`."
    email = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerEmailChangedMessagePayload(**data)


class CustomerEmailChangedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerEmailChangedMessage`."
    email = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerEmailChangedMessage(**data)


class CustomerEmailVerifiedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerEmailVerifiedMessagePayload`."

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerEmailVerifiedMessagePayload(**data)


class CustomerEmailVerifiedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerEmailVerifiedMessage`."

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerEmailVerifiedMessage(**data)


class CustomerGroupSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerGroupSetMessagePayload`."
    customer_group = marshmallow.fields.Nested(
        nested="commercetools.schemas._customer_group.CustomerGroupReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="customerGroup",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerGroupSetMessagePayload(**data)


class CustomerGroupSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.CustomerGroupSetMessage`."
    customer_group = marshmallow.fields.Nested(
        nested="commercetools.schemas._customer_group.CustomerGroupReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="customerGroup",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.CustomerGroupSetMessage(**data)


class DeliveryAddedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.DeliveryAddedMessagePayload`."
    delivery = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.DeliverySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.DeliveryAddedMessagePayload(**data)


class DeliveryAddedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.DeliveryAddedMessage`."
    delivery = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.DeliverySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.DeliveryAddedMessage(**data)


class DeliveryAddressSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.DeliveryAddressSetMessagePayload`."
    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")
    address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    old_address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="oldAddress",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.DeliveryAddressSetMessagePayload(**data)


class DeliveryAddressSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.DeliveryAddressSetMessage`."
    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")
    address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    old_address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="oldAddress",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.DeliveryAddressSetMessage(**data)


class DeliveryItemsUpdatedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.DeliveryItemsUpdatedMessagePayload`."
    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")
    items = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )
    old_items = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="oldItems",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.DeliveryItemsUpdatedMessagePayload(**data)


class DeliveryItemsUpdatedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.DeliveryItemsUpdatedMessage`."
    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")
    items = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )
    old_items = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="oldItems",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.DeliveryItemsUpdatedMessage(**data)


class DeliveryRemovedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.DeliveryRemovedMessagePayload`."
    delivery = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.DeliverySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.DeliveryRemovedMessagePayload(**data)


class DeliveryRemovedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.DeliveryRemovedMessage`."
    delivery = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.DeliverySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.DeliveryRemovedMessage(**data)


class InventoryEntryDeletedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.InventoryEntryDeletedMessagePayload`."
    sku = marshmallow.fields.String(allow_none=True)
    supply_channel = marshmallow.fields.Nested(
        nested="commercetools.schemas._channel.ChannelReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="supplyChannel",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.InventoryEntryDeletedMessagePayload(**data)


class InventoryEntryDeletedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.InventoryEntryDeletedMessage`."
    sku = marshmallow.fields.String(allow_none=True)
    supply_channel = marshmallow.fields.Nested(
        nested="commercetools.schemas._channel.ChannelReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="supplyChannel",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.InventoryEntryDeletedMessage(**data)


class LineItemStateTransitionMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.LineItemStateTransitionMessagePayload`."
    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    transition_date = marshmallow.fields.DateTime(
        allow_none=True, data_key="transitionDate"
    )
    quantity = marshmallow.fields.Integer(allow_none=True)
    from_state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="fromState",
    )
    to_state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="toState",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.LineItemStateTransitionMessagePayload(**data)


class LineItemStateTransitionMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.LineItemStateTransitionMessage`."
    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    transition_date = marshmallow.fields.DateTime(
        allow_none=True, data_key="transitionDate"
    )
    quantity = marshmallow.fields.Integer(allow_none=True)
    from_state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="fromState",
    )
    to_state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="toState",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.LineItemStateTransitionMessage(**data)


class OrderBillingAddressSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderBillingAddressSetMessagePayload`."
    address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    old_address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="oldAddress",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderBillingAddressSetMessagePayload(**data)


class OrderBillingAddressSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderBillingAddressSetMessage`."
    address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    old_address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="oldAddress",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderBillingAddressSetMessage(**data)


class OrderCreatedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderCreatedMessagePayload`."
    order = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.OrderSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderCreatedMessagePayload(**data)


class OrderCreatedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderCreatedMessage`."
    order = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.OrderSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderCreatedMessage(**data)


class OrderCustomLineItemDiscountSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderCustomLineItemDiscountSetMessagePayload`."
    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    discounted_price_per_quantity = marshmallow.fields.Nested(
        nested="commercetools.schemas._cart.DiscountedLineItemPriceForQuantitySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="discountedPricePerQuantity",
    )
    taxed_price = marshmallow.fields.Nested(
        nested="commercetools.schemas._cart.TaxedItemPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxedPrice",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderCustomLineItemDiscountSetMessagePayload(**data)


class OrderCustomLineItemDiscountSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderCustomLineItemDiscountSetMessage`."
    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    discounted_price_per_quantity = marshmallow.fields.Nested(
        nested="commercetools.schemas._cart.DiscountedLineItemPriceForQuantitySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="discountedPricePerQuantity",
    )
    taxed_price = marshmallow.fields.Nested(
        nested="commercetools.schemas._cart.TaxedItemPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxedPrice",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderCustomLineItemDiscountSetMessage(**data)


class OrderCustomerEmailSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderCustomerEmailSetMessagePayload`."
    email = marshmallow.fields.String(allow_none=True, missing=None)
    old_email = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="oldEmail"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderCustomerEmailSetMessagePayload(**data)


class OrderCustomerEmailSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderCustomerEmailSetMessage`."
    email = marshmallow.fields.String(allow_none=True, missing=None)
    old_email = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="oldEmail"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderCustomerEmailSetMessage(**data)


class OrderCustomerGroupSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderCustomerGroupSetMessagePayload`."
    customer_group = marshmallow.fields.Nested(
        nested="commercetools.schemas._customer_group.CustomerGroupReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="customerGroup",
    )
    old_customer_group = marshmallow.fields.Nested(
        nested="commercetools.schemas._customer_group.CustomerGroupReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="oldCustomerGroup",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderCustomerGroupSetMessagePayload(**data)


class OrderCustomerGroupSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderCustomerGroupSetMessage`."
    customer_group = marshmallow.fields.Nested(
        nested="commercetools.schemas._customer_group.CustomerGroupReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="customerGroup",
    )
    old_customer_group = marshmallow.fields.Nested(
        nested="commercetools.schemas._customer_group.CustomerGroupReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="oldCustomerGroup",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderCustomerGroupSetMessage(**data)


class OrderCustomerSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderCustomerSetMessagePayload`."
    customer = marshmallow.fields.Nested(
        nested="commercetools.schemas._customer.CustomerReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    customer_group = marshmallow.fields.Nested(
        nested="commercetools.schemas._customer_group.CustomerGroupReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="customerGroup",
    )
    old_customer = marshmallow.fields.Nested(
        nested="commercetools.schemas._customer.CustomerReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="oldCustomer",
    )
    old_customer_group = marshmallow.fields.Nested(
        nested="commercetools.schemas._customer_group.CustomerGroupReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="oldCustomerGroup",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderCustomerSetMessagePayload(**data)


class OrderCustomerSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderCustomerSetMessage`."
    customer = marshmallow.fields.Nested(
        nested="commercetools.schemas._customer.CustomerReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    customer_group = marshmallow.fields.Nested(
        nested="commercetools.schemas._customer_group.CustomerGroupReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="customerGroup",
    )
    old_customer = marshmallow.fields.Nested(
        nested="commercetools.schemas._customer.CustomerReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="oldCustomer",
    )
    old_customer_group = marshmallow.fields.Nested(
        nested="commercetools.schemas._customer_group.CustomerGroupReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="oldCustomerGroup",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderCustomerSetMessage(**data)


class OrderDeletedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderDeletedMessagePayload`."
    order = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.OrderSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderDeletedMessagePayload(**data)


class OrderDeletedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderDeletedMessage`."
    order = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.OrderSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderDeletedMessage(**data)


class OrderDiscountCodeAddedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderDiscountCodeAddedMessagePayload`."
    discount_code = marshmallow.fields.Nested(
        nested="commercetools.schemas._discount_code.DiscountCodeReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="discountCode",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderDiscountCodeAddedMessagePayload(**data)


class OrderDiscountCodeAddedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderDiscountCodeAddedMessage`."
    discount_code = marshmallow.fields.Nested(
        nested="commercetools.schemas._discount_code.DiscountCodeReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="discountCode",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderDiscountCodeAddedMessage(**data)


class OrderDiscountCodeRemovedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderDiscountCodeRemovedMessagePayload`."
    discount_code = marshmallow.fields.Nested(
        nested="commercetools.schemas._discount_code.DiscountCodeReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="discountCode",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderDiscountCodeRemovedMessagePayload(**data)


class OrderDiscountCodeRemovedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderDiscountCodeRemovedMessage`."
    discount_code = marshmallow.fields.Nested(
        nested="commercetools.schemas._discount_code.DiscountCodeReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="discountCode",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderDiscountCodeRemovedMessage(**data)


class OrderDiscountCodeStateSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderDiscountCodeStateSetMessagePayload`."
    discount_code = marshmallow.fields.Nested(
        nested="commercetools.schemas._discount_code.DiscountCodeReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="discountCode",
    )
    state = marshmallow_enum.EnumField(types.DiscountCodeState, by_value=True)
    old_state = marshmallow_enum.EnumField(
        types.DiscountCodeState, by_value=True, missing=None, data_key="oldState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderDiscountCodeStateSetMessagePayload(**data)


class OrderDiscountCodeStateSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderDiscountCodeStateSetMessage`."
    discount_code = marshmallow.fields.Nested(
        nested="commercetools.schemas._discount_code.DiscountCodeReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="discountCode",
    )
    state = marshmallow_enum.EnumField(types.DiscountCodeState, by_value=True)
    old_state = marshmallow_enum.EnumField(
        types.DiscountCodeState, by_value=True, missing=None, data_key="oldState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderDiscountCodeStateSetMessage(**data)


class OrderEditAppliedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderEditAppliedMessagePayload`."
    edit = marshmallow.fields.Nested(
        nested="commercetools.schemas._order_edit.OrderEditReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    result = marshmallow.fields.Nested(
        nested="commercetools.schemas._order_edit.OrderEditAppliedSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderEditAppliedMessagePayload(**data)


class OrderEditAppliedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderEditAppliedMessage`."
    edit = marshmallow.fields.Nested(
        nested="commercetools.schemas._order_edit.OrderEditReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    result = marshmallow.fields.Nested(
        nested="commercetools.schemas._order_edit.OrderEditAppliedSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderEditAppliedMessage(**data)


class OrderImportedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderImportedMessagePayload`."
    order = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.OrderSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderImportedMessagePayload(**data)


class OrderImportedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderImportedMessage`."
    order = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.OrderSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderImportedMessage(**data)


class OrderLineItemAddedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderLineItemAddedMessagePayload`."
    line_item = marshmallow.fields.Nested(
        nested="commercetools.schemas._cart.LineItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="lineItem",
    )
    added_quantity = marshmallow.fields.Integer(
        allow_none=True, data_key="addedQuantity"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderLineItemAddedMessagePayload(**data)


class OrderLineItemAddedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderLineItemAddedMessage`."
    line_item = marshmallow.fields.Nested(
        nested="commercetools.schemas._cart.LineItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="lineItem",
    )
    added_quantity = marshmallow.fields.Integer(
        allow_none=True, data_key="addedQuantity"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderLineItemAddedMessage(**data)


class OrderLineItemDiscountSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderLineItemDiscountSetMessagePayload`."
    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    discounted_price_per_quantity = marshmallow.fields.Nested(
        nested="commercetools.schemas._cart.DiscountedLineItemPriceForQuantitySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="discountedPricePerQuantity",
    )
    total_price = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalPrice",
    )
    taxed_price = marshmallow.fields.Nested(
        nested="commercetools.schemas._cart.TaxedItemPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxedPrice",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderLineItemDiscountSetMessagePayload(**data)


class OrderLineItemDiscountSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderLineItemDiscountSetMessage`."
    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    discounted_price_per_quantity = marshmallow.fields.Nested(
        nested="commercetools.schemas._cart.DiscountedLineItemPriceForQuantitySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="discountedPricePerQuantity",
    )
    total_price = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalPrice",
    )
    taxed_price = marshmallow.fields.Nested(
        nested="commercetools.schemas._cart.TaxedItemPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxedPrice",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderLineItemDiscountSetMessage(**data)


class OrderPaymentStateChangedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderPaymentStateChangedMessagePayload`."
    payment_state = marshmallow_enum.EnumField(
        types.PaymentState, by_value=True, data_key="paymentState"
    )
    old_payment_state = marshmallow_enum.EnumField(
        types.PaymentState, by_value=True, missing=None, data_key="oldPaymentState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderPaymentStateChangedMessagePayload(**data)


class OrderPaymentStateChangedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderPaymentStateChangedMessage`."
    payment_state = marshmallow_enum.EnumField(
        types.PaymentState, by_value=True, data_key="paymentState"
    )
    old_payment_state = marshmallow_enum.EnumField(
        types.PaymentState, by_value=True, missing=None, data_key="oldPaymentState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderPaymentStateChangedMessage(**data)


class OrderReturnInfoAddedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderReturnInfoAddedMessagePayload`."
    return_info = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.ReturnInfoSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="returnInfo",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderReturnInfoAddedMessagePayload(**data)


class OrderReturnInfoAddedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderReturnInfoAddedMessage`."
    return_info = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.ReturnInfoSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="returnInfo",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderReturnInfoAddedMessage(**data)


class OrderReturnShipmentStateChangedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderReturnShipmentStateChangedMessagePayload`."
    return_item_id = marshmallow.fields.String(allow_none=True, data_key="returnItemId")
    return_shipment_state = marshmallow_enum.EnumField(
        types.ReturnShipmentState, by_value=True, data_key="returnShipmentState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderReturnShipmentStateChangedMessagePayload(**data)


class OrderReturnShipmentStateChangedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderReturnShipmentStateChangedMessage`."
    return_item_id = marshmallow.fields.String(allow_none=True, data_key="returnItemId")
    return_shipment_state = marshmallow_enum.EnumField(
        types.ReturnShipmentState, by_value=True, data_key="returnShipmentState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderReturnShipmentStateChangedMessage(**data)


class OrderShipmentStateChangedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderShipmentStateChangedMessagePayload`."
    shipment_state = marshmallow_enum.EnumField(
        types.ShipmentState, by_value=True, data_key="shipmentState"
    )
    old_shipment_state = marshmallow_enum.EnumField(
        types.ShipmentState, by_value=True, missing=None, data_key="oldShipmentState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderShipmentStateChangedMessagePayload(**data)


class OrderShipmentStateChangedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderShipmentStateChangedMessage`."
    shipment_state = marshmallow_enum.EnumField(
        types.ShipmentState, by_value=True, data_key="shipmentState"
    )
    old_shipment_state = marshmallow_enum.EnumField(
        types.ShipmentState, by_value=True, missing=None, data_key="oldShipmentState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderShipmentStateChangedMessage(**data)


class OrderShippingAddressSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderShippingAddressSetMessagePayload`."
    address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    old_address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="oldAddress",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderShippingAddressSetMessagePayload(**data)


class OrderShippingAddressSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderShippingAddressSetMessage`."
    address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    old_address = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="oldAddress",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderShippingAddressSetMessage(**data)


class OrderShippingInfoSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderShippingInfoSetMessagePayload`."
    shipping_info = marshmallow.fields.Nested(
        nested="commercetools.schemas._cart.ShippingInfoSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingInfo",
    )
    old_shipping_info = marshmallow.fields.Nested(
        nested="commercetools.schemas._cart.ShippingInfoSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="oldShippingInfo",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderShippingInfoSetMessagePayload(**data)


class OrderShippingInfoSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderShippingInfoSetMessage`."
    shipping_info = marshmallow.fields.Nested(
        nested="commercetools.schemas._cart.ShippingInfoSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingInfo",
    )
    old_shipping_info = marshmallow.fields.Nested(
        nested="commercetools.schemas._cart.ShippingInfoSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="oldShippingInfo",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderShippingInfoSetMessage(**data)


class OrderShippingRateInputSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderShippingRateInputSetMessagePayload`."
    shipping_rate_input = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "Classification": "commercetools.schemas._cart.ClassificationShippingRateInputSchema",
            "Score": "commercetools.schemas._cart.ScoreShippingRateInputSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingRateInput",
    )
    old_shipping_rate_input = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "Classification": "commercetools.schemas._cart.ClassificationShippingRateInputSchema",
            "Score": "commercetools.schemas._cart.ScoreShippingRateInputSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="oldShippingRateInput",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderShippingRateInputSetMessagePayload(**data)


class OrderShippingRateInputSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderShippingRateInputSetMessage`."
    shipping_rate_input = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "Classification": "commercetools.schemas._cart.ClassificationShippingRateInputSchema",
            "Score": "commercetools.schemas._cart.ScoreShippingRateInputSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingRateInput",
    )
    old_shipping_rate_input = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "Classification": "commercetools.schemas._cart.ClassificationShippingRateInputSchema",
            "Score": "commercetools.schemas._cart.ScoreShippingRateInputSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="oldShippingRateInput",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderShippingRateInputSetMessage(**data)


class OrderStateChangedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderStateChangedMessagePayload`."
    order_state = marshmallow_enum.EnumField(
        types.OrderState, by_value=True, data_key="orderState"
    )
    old_order_state = marshmallow_enum.EnumField(
        types.OrderState, by_value=True, data_key="oldOrderState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderStateChangedMessagePayload(**data)


class OrderStateChangedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderStateChangedMessage`."
    order_state = marshmallow_enum.EnumField(
        types.OrderState, by_value=True, data_key="orderState"
    )
    old_order_state = marshmallow_enum.EnumField(
        types.OrderState, by_value=True, data_key="oldOrderState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderStateChangedMessage(**data)


class OrderStateTransitionMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderStateTransitionMessagePayload`."
    state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    force = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderStateTransitionMessagePayload(**data)


class OrderStateTransitionMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderStateTransitionMessage`."
    state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    force = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderStateTransitionMessage(**data)


class OrderStoreSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderStoreSetMessagePayload`."
    store = marshmallow.fields.Nested(
        nested="commercetools.schemas._store.StoreKeyReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderStoreSetMessagePayload(**data)


class OrderStoreSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.OrderStoreSetMessage`."
    store = marshmallow.fields.Nested(
        nested="commercetools.schemas._store.StoreKeyReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.OrderStoreSetMessage(**data)


class ParcelAddedToDeliveryMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ParcelAddedToDeliveryMessagePayload`."
    delivery = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.DeliverySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    parcel = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.ParcelSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ParcelAddedToDeliveryMessagePayload(**data)


class ParcelAddedToDeliveryMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ParcelAddedToDeliveryMessage`."
    delivery = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.DeliverySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    parcel = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.ParcelSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ParcelAddedToDeliveryMessage(**data)


class ParcelItemsUpdatedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ParcelItemsUpdatedMessagePayload`."
    parcel_id = marshmallow.fields.String(allow_none=True, data_key="parcelId")
    delivery_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="deliveryId"
    )
    items = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )
    old_items = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="oldItems",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ParcelItemsUpdatedMessagePayload(**data)


class ParcelItemsUpdatedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ParcelItemsUpdatedMessage`."
    parcel_id = marshmallow.fields.String(allow_none=True, data_key="parcelId")
    delivery_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="deliveryId"
    )
    items = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )
    old_items = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.DeliveryItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="oldItems",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ParcelItemsUpdatedMessage(**data)


class ParcelMeasurementsUpdatedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ParcelMeasurementsUpdatedMessagePayload`."
    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")
    parcel_id = marshmallow.fields.String(allow_none=True, data_key="parcelId")
    measurements = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.ParcelMeasurementsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ParcelMeasurementsUpdatedMessagePayload(**data)


class ParcelMeasurementsUpdatedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ParcelMeasurementsUpdatedMessage`."
    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")
    parcel_id = marshmallow.fields.String(allow_none=True, data_key="parcelId")
    measurements = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.ParcelMeasurementsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ParcelMeasurementsUpdatedMessage(**data)


class ParcelRemovedFromDeliveryMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ParcelRemovedFromDeliveryMessagePayload`."
    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")
    parcel = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.ParcelSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ParcelRemovedFromDeliveryMessagePayload(**data)


class ParcelRemovedFromDeliveryMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ParcelRemovedFromDeliveryMessage`."
    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")
    parcel = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.ParcelSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ParcelRemovedFromDeliveryMessage(**data)


class ParcelTrackingDataUpdatedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ParcelTrackingDataUpdatedMessagePayload`."
    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")
    parcel_id = marshmallow.fields.String(allow_none=True, data_key="parcelId")
    tracking_data = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.TrackingDataSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="trackingData",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ParcelTrackingDataUpdatedMessagePayload(**data)


class ParcelTrackingDataUpdatedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ParcelTrackingDataUpdatedMessage`."
    delivery_id = marshmallow.fields.String(allow_none=True, data_key="deliveryId")
    parcel_id = marshmallow.fields.String(allow_none=True, data_key="parcelId")
    tracking_data = marshmallow.fields.Nested(
        nested="commercetools.schemas._order.TrackingDataSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="trackingData",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ParcelTrackingDataUpdatedMessage(**data)


class PaymentCreatedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.PaymentCreatedMessagePayload`."
    payment = marshmallow.fields.Nested(
        nested="commercetools.schemas._payment.PaymentSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.PaymentCreatedMessagePayload(**data)


class PaymentCreatedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.PaymentCreatedMessage`."
    payment = marshmallow.fields.Nested(
        nested="commercetools.schemas._payment.PaymentSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.PaymentCreatedMessage(**data)


class PaymentInteractionAddedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.PaymentInteractionAddedMessagePayload`."
    interaction = marshmallow.fields.Nested(
        nested="commercetools.schemas._type.CustomFieldsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.PaymentInteractionAddedMessagePayload(**data)


class PaymentInteractionAddedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.PaymentInteractionAddedMessage`."
    interaction = marshmallow.fields.Nested(
        nested="commercetools.schemas._type.CustomFieldsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.PaymentInteractionAddedMessage(**data)


class PaymentStatusInterfaceCodeSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.PaymentStatusInterfaceCodeSetMessagePayload`."
    payment_id = marshmallow.fields.String(allow_none=True, data_key="paymentId")
    interface_code = marshmallow.fields.String(
        allow_none=True, data_key="interfaceCode"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.PaymentStatusInterfaceCodeSetMessagePayload(**data)


class PaymentStatusInterfaceCodeSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.PaymentStatusInterfaceCodeSetMessage`."
    payment_id = marshmallow.fields.String(allow_none=True, data_key="paymentId")
    interface_code = marshmallow.fields.String(
        allow_none=True, data_key="interfaceCode"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.PaymentStatusInterfaceCodeSetMessage(**data)


class PaymentStatusStateTransitionMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.PaymentStatusStateTransitionMessagePayload`."
    state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    force = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.PaymentStatusStateTransitionMessagePayload(**data)


class PaymentStatusStateTransitionMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.PaymentStatusStateTransitionMessage`."
    state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    force = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.PaymentStatusStateTransitionMessage(**data)


class PaymentTransactionAddedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.PaymentTransactionAddedMessagePayload`."
    transaction = marshmallow.fields.Nested(
        nested="commercetools.schemas._payment.TransactionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.PaymentTransactionAddedMessagePayload(**data)


class PaymentTransactionAddedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.PaymentTransactionAddedMessage`."
    transaction = marshmallow.fields.Nested(
        nested="commercetools.schemas._payment.TransactionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.PaymentTransactionAddedMessage(**data)


class PaymentTransactionStateChangedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.PaymentTransactionStateChangedMessagePayload`."
    transaction_id = marshmallow.fields.String(
        allow_none=True, data_key="transactionId"
    )
    state = marshmallow_enum.EnumField(types.TransactionState, by_value=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.PaymentTransactionStateChangedMessagePayload(**data)


class PaymentTransactionStateChangedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.PaymentTransactionStateChangedMessage`."
    transaction_id = marshmallow.fields.String(
        allow_none=True, data_key="transactionId"
    )
    state = marshmallow_enum.EnumField(types.TransactionState, by_value=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.PaymentTransactionStateChangedMessage(**data)


class ProductAddedToCategoryMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductAddedToCategoryMessagePayload`."
    category = marshmallow.fields.Nested(
        nested="commercetools.schemas._category.CategoryReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    staged = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductAddedToCategoryMessagePayload(**data)


class ProductAddedToCategoryMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductAddedToCategoryMessage`."
    category = marshmallow.fields.Nested(
        nested="commercetools.schemas._category.CategoryReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    staged = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductAddedToCategoryMessage(**data)


class ProductCreatedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductCreatedMessagePayload`."
    product_projection = marshmallow.fields.Nested(
        nested="commercetools.schemas._product.ProductProjectionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="productProjection",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductCreatedMessagePayload(**data)


class ProductCreatedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductCreatedMessage`."
    product_projection = marshmallow.fields.Nested(
        nested="commercetools.schemas._product.ProductProjectionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="productProjection",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductCreatedMessage(**data)


class ProductDeletedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductDeletedMessagePayload`."
    removed_image_urls = marshmallow.fields.List(
        marshmallow.fields.Nested(
            nested="commercetools.schemas.None.stringSchema",
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
        data_key="removedImageUrls",
    )
    current_projection = marshmallow.fields.Nested(
        nested="commercetools.schemas._product.ProductProjectionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="currentProjection",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductDeletedMessagePayload(**data)


class ProductDeletedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductDeletedMessage`."
    removed_image_urls = marshmallow.fields.List(
        marshmallow.fields.Nested(
            nested="commercetools.schemas.None.stringSchema",
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
        data_key="removedImageUrls",
    )
    current_projection = marshmallow.fields.Nested(
        nested="commercetools.schemas._product.ProductProjectionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="currentProjection",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductDeletedMessage(**data)


class ProductImageAddedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductImageAddedMessagePayload`."
    variant_id = marshmallow.fields.Integer(allow_none=True, data_key="variantId")
    image = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.ImageSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    staged = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductImageAddedMessagePayload(**data)


class ProductImageAddedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductImageAddedMessage`."
    variant_id = marshmallow.fields.Integer(allow_none=True, data_key="variantId")
    image = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.ImageSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    staged = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductImageAddedMessage(**data)


class ProductPriceDiscountsSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductPriceDiscountsSetMessagePayload`."
    updated_prices = marshmallow.fields.Nested(
        nested="commercetools.schemas._message.ProductPriceDiscountsSetUpdatedPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="updatedPrices",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductPriceDiscountsSetMessagePayload(**data)


class ProductPriceDiscountsSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductPriceDiscountsSetMessage`."
    updated_prices = marshmallow.fields.Nested(
        nested="commercetools.schemas._message.ProductPriceDiscountsSetUpdatedPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="updatedPrices",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductPriceDiscountsSetMessage(**data)


class ProductPriceExternalDiscountSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductPriceExternalDiscountSetMessagePayload`."
    variant_id = marshmallow.fields.Integer(allow_none=True, data_key="variantId")
    variant_key = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="variantKey"
    )
    sku = marshmallow.fields.String(allow_none=True, missing=None)
    price_id = marshmallow.fields.String(allow_none=True, data_key="priceId")
    discounted = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.DiscountedPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    staged = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductPriceExternalDiscountSetMessagePayload(**data)


class ProductPriceExternalDiscountSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductPriceExternalDiscountSetMessage`."
    variant_id = marshmallow.fields.Integer(allow_none=True, data_key="variantId")
    variant_key = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="variantKey"
    )
    sku = marshmallow.fields.String(allow_none=True, missing=None)
    price_id = marshmallow.fields.String(allow_none=True, data_key="priceId")
    discounted = marshmallow.fields.Nested(
        nested="commercetools.schemas._common.DiscountedPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    staged = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductPriceExternalDiscountSetMessage(**data)


class ProductPublishedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductPublishedMessagePayload`."
    removed_image_urls = marshmallow.fields.List(
        marshmallow.fields.Nested(
            nested="commercetools.schemas.None.anySchema",
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
        data_key="removedImageUrls",
    )
    product_projection = marshmallow.fields.Nested(
        nested="commercetools.schemas._product.ProductProjectionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="productProjection",
    )
    scope = marshmallow_enum.EnumField(types.ProductPublishScope, by_value=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductPublishedMessagePayload(**data)


class ProductPublishedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductPublishedMessage`."
    removed_image_urls = marshmallow.fields.List(
        marshmallow.fields.Nested(
            nested="commercetools.schemas.None.anySchema",
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
        data_key="removedImageUrls",
    )
    product_projection = marshmallow.fields.Nested(
        nested="commercetools.schemas._product.ProductProjectionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="productProjection",
    )
    scope = marshmallow_enum.EnumField(types.ProductPublishScope, by_value=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductPublishedMessage(**data)


class ProductRemovedFromCategoryMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductRemovedFromCategoryMessagePayload`."
    category = marshmallow.fields.Nested(
        nested="commercetools.schemas._category.CategoryReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    staged = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductRemovedFromCategoryMessagePayload(**data)


class ProductRemovedFromCategoryMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductRemovedFromCategoryMessage`."
    category = marshmallow.fields.Nested(
        nested="commercetools.schemas._category.CategoryReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    staged = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductRemovedFromCategoryMessage(**data)


class ProductRevertedStagedChangesMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductRevertedStagedChangesMessagePayload`."
    removed_image_urls = marshmallow.fields.List(
        marshmallow.fields.Nested(
            nested="commercetools.schemas.None.stringSchema",
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
        data_key="removedImageUrls",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductRevertedStagedChangesMessagePayload(**data)


class ProductRevertedStagedChangesMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductRevertedStagedChangesMessage`."
    removed_image_urls = marshmallow.fields.List(
        marshmallow.fields.Nested(
            nested="commercetools.schemas.None.stringSchema",
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
        data_key="removedImageUrls",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductRevertedStagedChangesMessage(**data)


class ProductSlugChangedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductSlugChangedMessagePayload`."
    slug = LocalizedStringField(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductSlugChangedMessagePayload(**data)


class ProductSlugChangedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductSlugChangedMessage`."
    slug = LocalizedStringField(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductSlugChangedMessage(**data)


class ProductStateTransitionMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductStateTransitionMessagePayload`."
    state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    force = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductStateTransitionMessagePayload(**data)


class ProductStateTransitionMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductStateTransitionMessage`."
    state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    force = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductStateTransitionMessage(**data)


class ProductUnpublishedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductUnpublishedMessagePayload`."

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductUnpublishedMessagePayload(**data)


class ProductUnpublishedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductUnpublishedMessage`."

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductUnpublishedMessage(**data)


class ProductVariantDeletedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductVariantDeletedMessagePayload`."
    variant = marshmallow.fields.Nested(
        nested="commercetools.schemas._product.ProductVariantSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    removed_image_urls = marshmallow.fields.List(
        marshmallow.fields.Nested(
            nested="commercetools.schemas.None.stringSchema",
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
        data_key="removedImageUrls",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductVariantDeletedMessagePayload(**data)


class ProductVariantDeletedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ProductVariantDeletedMessage`."
    variant = marshmallow.fields.Nested(
        nested="commercetools.schemas._product.ProductVariantSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    removed_image_urls = marshmallow.fields.List(
        marshmallow.fields.Nested(
            nested="commercetools.schemas.None.stringSchema",
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
        data_key="removedImageUrls",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ProductVariantDeletedMessage(**data)


class ReviewCreatedMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ReviewCreatedMessagePayload`."
    review = marshmallow.fields.Nested(
        nested="commercetools.schemas._review.ReviewSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ReviewCreatedMessagePayload(**data)


class ReviewCreatedMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ReviewCreatedMessage`."
    review = marshmallow.fields.Nested(
        nested="commercetools.schemas._review.ReviewSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ReviewCreatedMessage(**data)


class ReviewRatingSetMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ReviewRatingSetMessagePayload`."
    old_rating = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="oldRating"
    )
    new_rating = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="newRating"
    )
    included_in_statistics = marshmallow.fields.Bool(
        allow_none=True, data_key="includedInStatistics"
    )
    target = helpers.Discriminator(
        discriminator_field=("typeId", "type_id"),
        discriminator_schemas={
            "cart-discount": "commercetools.schemas._cart_discount.CartDiscountReferenceSchema",
            "cart": "commercetools.schemas._cart.CartReferenceSchema",
            "category": "commercetools.schemas._category.CategoryReferenceSchema",
            "channel": "commercetools.schemas._channel.ChannelReferenceSchema",
            "key-value-document": "commercetools.schemas._custom_object.CustomObjectReferenceSchema",
            "customer-group": "commercetools.schemas._customer_group.CustomerGroupReferenceSchema",
            "customer": "commercetools.schemas._customer.CustomerReferenceSchema",
            "discount-code": "commercetools.schemas._discount_code.DiscountCodeReferenceSchema",
            "inventory-entry": "commercetools.schemas._inventory.InventoryEntryReferenceSchema",
            "order-edit": "commercetools.schemas._order_edit.OrderEditReferenceSchema",
            "order": "commercetools.schemas._order.OrderReferenceSchema",
            "payment": "commercetools.schemas._payment.PaymentReferenceSchema",
            "product-discount": "commercetools.schemas._product_discount.ProductDiscountReferenceSchema",
            "product-type": "commercetools.schemas._product_type.ProductTypeReferenceSchema",
            "product": "commercetools.schemas._product.ProductReferenceSchema",
            "review": "commercetools.schemas._review.ReviewReferenceSchema",
            "shipping-method": "commercetools.schemas._shipping_method.ShippingMethodReferenceSchema",
            "shopping-list": "commercetools.schemas._shopping_list.ShoppingListReferenceSchema",
            "state": "commercetools.schemas._state.StateReferenceSchema",
            "store": "commercetools.schemas._store.StoreReferenceSchema",
            "tax-category": "commercetools.schemas._tax_category.TaxCategoryReferenceSchema",
            "type": "commercetools.schemas._type.TypeReferenceSchema",
            "zone": "commercetools.schemas._zone.ZoneReferenceSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ReviewRatingSetMessagePayload(**data)


class ReviewRatingSetMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ReviewRatingSetMessage`."
    old_rating = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="oldRating"
    )
    new_rating = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="newRating"
    )
    included_in_statistics = marshmallow.fields.Bool(
        allow_none=True, data_key="includedInStatistics"
    )
    target = helpers.Discriminator(
        discriminator_field=("typeId", "type_id"),
        discriminator_schemas={
            "cart-discount": "commercetools.schemas._cart_discount.CartDiscountReferenceSchema",
            "cart": "commercetools.schemas._cart.CartReferenceSchema",
            "category": "commercetools.schemas._category.CategoryReferenceSchema",
            "channel": "commercetools.schemas._channel.ChannelReferenceSchema",
            "key-value-document": "commercetools.schemas._custom_object.CustomObjectReferenceSchema",
            "customer-group": "commercetools.schemas._customer_group.CustomerGroupReferenceSchema",
            "customer": "commercetools.schemas._customer.CustomerReferenceSchema",
            "discount-code": "commercetools.schemas._discount_code.DiscountCodeReferenceSchema",
            "inventory-entry": "commercetools.schemas._inventory.InventoryEntryReferenceSchema",
            "order-edit": "commercetools.schemas._order_edit.OrderEditReferenceSchema",
            "order": "commercetools.schemas._order.OrderReferenceSchema",
            "payment": "commercetools.schemas._payment.PaymentReferenceSchema",
            "product-discount": "commercetools.schemas._product_discount.ProductDiscountReferenceSchema",
            "product-type": "commercetools.schemas._product_type.ProductTypeReferenceSchema",
            "product": "commercetools.schemas._product.ProductReferenceSchema",
            "review": "commercetools.schemas._review.ReviewReferenceSchema",
            "shipping-method": "commercetools.schemas._shipping_method.ShippingMethodReferenceSchema",
            "shopping-list": "commercetools.schemas._shopping_list.ShoppingListReferenceSchema",
            "state": "commercetools.schemas._state.StateReferenceSchema",
            "store": "commercetools.schemas._store.StoreReferenceSchema",
            "tax-category": "commercetools.schemas._tax_category.TaxCategoryReferenceSchema",
            "type": "commercetools.schemas._type.TypeReferenceSchema",
            "zone": "commercetools.schemas._zone.ZoneReferenceSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ReviewRatingSetMessage(**data)


class ReviewStateTransitionMessagePayloadSchema(MessagePayloadSchema):
    "Marshmallow schema for :class:`commercetools.types.ReviewStateTransitionMessagePayload`."
    old_state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="oldState",
    )
    new_state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="newState",
    )
    old_included_in_statistics = marshmallow.fields.Bool(
        allow_none=True, data_key="oldIncludedInStatistics"
    )
    new_included_in_statistics = marshmallow.fields.Bool(
        allow_none=True, data_key="newIncludedInStatistics"
    )
    target = helpers.Discriminator(
        discriminator_field=("typeId", "type_id"),
        discriminator_schemas={
            "cart-discount": "commercetools.schemas._cart_discount.CartDiscountReferenceSchema",
            "cart": "commercetools.schemas._cart.CartReferenceSchema",
            "category": "commercetools.schemas._category.CategoryReferenceSchema",
            "channel": "commercetools.schemas._channel.ChannelReferenceSchema",
            "key-value-document": "commercetools.schemas._custom_object.CustomObjectReferenceSchema",
            "customer-group": "commercetools.schemas._customer_group.CustomerGroupReferenceSchema",
            "customer": "commercetools.schemas._customer.CustomerReferenceSchema",
            "discount-code": "commercetools.schemas._discount_code.DiscountCodeReferenceSchema",
            "inventory-entry": "commercetools.schemas._inventory.InventoryEntryReferenceSchema",
            "order-edit": "commercetools.schemas._order_edit.OrderEditReferenceSchema",
            "order": "commercetools.schemas._order.OrderReferenceSchema",
            "payment": "commercetools.schemas._payment.PaymentReferenceSchema",
            "product-discount": "commercetools.schemas._product_discount.ProductDiscountReferenceSchema",
            "product-type": "commercetools.schemas._product_type.ProductTypeReferenceSchema",
            "product": "commercetools.schemas._product.ProductReferenceSchema",
            "review": "commercetools.schemas._review.ReviewReferenceSchema",
            "shipping-method": "commercetools.schemas._shipping_method.ShippingMethodReferenceSchema",
            "shopping-list": "commercetools.schemas._shopping_list.ShoppingListReferenceSchema",
            "state": "commercetools.schemas._state.StateReferenceSchema",
            "store": "commercetools.schemas._store.StoreReferenceSchema",
            "tax-category": "commercetools.schemas._tax_category.TaxCategoryReferenceSchema",
            "type": "commercetools.schemas._type.TypeReferenceSchema",
            "zone": "commercetools.schemas._zone.ZoneReferenceSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    force = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ReviewStateTransitionMessagePayload(**data)


class ReviewStateTransitionMessageSchema(MessageSchema):
    "Marshmallow schema for :class:`commercetools.types.ReviewStateTransitionMessage`."
    old_state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="oldState",
    )
    new_state = marshmallow.fields.Nested(
        nested="commercetools.schemas._state.StateReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="newState",
    )
    old_included_in_statistics = marshmallow.fields.Bool(
        allow_none=True, data_key="oldIncludedInStatistics"
    )
    new_included_in_statistics = marshmallow.fields.Bool(
        allow_none=True, data_key="newIncludedInStatistics"
    )
    target = helpers.Discriminator(
        discriminator_field=("typeId", "type_id"),
        discriminator_schemas={
            "cart-discount": "commercetools.schemas._cart_discount.CartDiscountReferenceSchema",
            "cart": "commercetools.schemas._cart.CartReferenceSchema",
            "category": "commercetools.schemas._category.CategoryReferenceSchema",
            "channel": "commercetools.schemas._channel.ChannelReferenceSchema",
            "key-value-document": "commercetools.schemas._custom_object.CustomObjectReferenceSchema",
            "customer-group": "commercetools.schemas._customer_group.CustomerGroupReferenceSchema",
            "customer": "commercetools.schemas._customer.CustomerReferenceSchema",
            "discount-code": "commercetools.schemas._discount_code.DiscountCodeReferenceSchema",
            "inventory-entry": "commercetools.schemas._inventory.InventoryEntryReferenceSchema",
            "order-edit": "commercetools.schemas._order_edit.OrderEditReferenceSchema",
            "order": "commercetools.schemas._order.OrderReferenceSchema",
            "payment": "commercetools.schemas._payment.PaymentReferenceSchema",
            "product-discount": "commercetools.schemas._product_discount.ProductDiscountReferenceSchema",
            "product-type": "commercetools.schemas._product_type.ProductTypeReferenceSchema",
            "product": "commercetools.schemas._product.ProductReferenceSchema",
            "review": "commercetools.schemas._review.ReviewReferenceSchema",
            "shipping-method": "commercetools.schemas._shipping_method.ShippingMethodReferenceSchema",
            "shopping-list": "commercetools.schemas._shopping_list.ShoppingListReferenceSchema",
            "state": "commercetools.schemas._state.StateReferenceSchema",
            "store": "commercetools.schemas._store.StoreReferenceSchema",
            "tax-category": "commercetools.schemas._tax_category.TaxCategoryReferenceSchema",
            "type": "commercetools.schemas._type.TypeReferenceSchema",
            "zone": "commercetools.schemas._zone.ZoneReferenceSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    force = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ReviewStateTransitionMessage(**data)
