# -*- coding: utf-8 -*-
"""
pyYeti
======

pyYeti has tools mostly related to structural dynamics:

    * Solve matrix equations of motion in the time and
      frequency domains
    * Shock response spectrum (SRS)
    * Fatigue damage equivalent power spectral densities (PSD)
    * Hurty-Craig-Bampton model checks
    * Coupled loads analysis tools
    * Statistics tools for computing k-factors (for tolerance
      bounds and intervals) and for order statistics
    * A data-cursor for interacting with 2D x-y plots
    * Eigensystem Realization Algorithm
    * Force limiting analysis tools
    * Read/write Nastran output4 (.op4) files
    * Limited capability to read Nastran output2 (.op2) files
    * Rainflow cycle counting
    * Resample data with the Lanczos method
    * A "vectorized" writing module
    * Eigensolution with the subspace iteration method
    * Tools for working with the "nas2cam" Nastran DMAP
    * Other miscellaneous tools

"""

__version__ = "1.0.5"
