# coding: utf-8

"""
    Neuronpedia - Inference Server

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.1.0
    Contact: johnny@neuronpedia.org
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ActivationAllPostRequest(BaseModel):
    """
    For a given prompt, get the top activating features for a set of SAEs (eg gemmascope-res-65k), or specific SAEs in the set of SAEs (eg 0-gemmascope-res-65k, 5-gemmascope-res-65k). Also has other customization options.
    """ # noqa: E501
    prompt: StrictStr = Field(description="Input text prompt to get activations for")
    model: StrictStr = Field(description="Name of the model to test activations on")
    source_set: StrictStr = Field(description="The source set name of the SAEs (eg gemmascope-res-16k)")
    selected_sources: List[StrictStr] = Field(description="List of specific SAEs to get activations for (eg [\"0-gemmascope-res-65k\", \"5-gemmascope-res-65k\"]). If not specified, will get activations for all SAEs in the source set.")
    sort_by_token_indexes: List[StrictInt] = Field(description="Sort the results by the sum of the activations at the specified token indexes.")
    ignore_bos: StrictBool = Field(description="Whether or not to include features whose highest activation value is the BOS token.")
    feature_filter: Optional[List[StrictInt]] = Field(default=None, description="Optional. If specified, will only return features that match the indexes specified. Can only be used if we're testing just one SAE (\"selected_sources\" length = 1).")
    num_results: Optional[StrictInt] = Field(default=25, description="Optional. The number of top features to return.")
    __properties: ClassVar[List[str]] = ["prompt", "model", "source_set", "selected_sources", "sort_by_token_indexes", "ignore_bos", "feature_filter", "num_results"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ActivationAllPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ActivationAllPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "prompt": obj.get("prompt"),
            "model": obj.get("model"),
            "source_set": obj.get("source_set"),
            "selected_sources": obj.get("selected_sources"),
            "sort_by_token_indexes": obj.get("sort_by_token_indexes"),
            "ignore_bos": obj.get("ignore_bos") if obj.get("ignore_bos") is not None else True,
            "feature_filter": obj.get("feature_filter"),
            "num_results": obj.get("num_results") if obj.get("num_results") is not None else 25
        })
        return _obj


