# neuronpedia-inference-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.1.0
- Package version: 1.7.2
- Generator version: 7.11.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import neuronpedia_inference_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import neuronpedia_inference_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import neuronpedia_inference_client
from neuronpedia_inference_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to /v1
# See configuration.py for a list of all supported configuration parameters.
configuration = neuronpedia_inference_client.Configuration(
    host = "/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: SimpleSecretAuth
configuration.api_key['SimpleSecretAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['SimpleSecretAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with neuronpedia_inference_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = neuronpedia_inference_client.DefaultApi(api_client)
    activation_all_batch_post_request = neuronpedia_inference_client.ActivationAllBatchPostRequest() # ActivationAllBatchPostRequest | 

    try:
        # For a given batch of prompts, get the top activating features for a set of SAEs (eg gemmascope-res-65k), or specific SAEs in the set of SAEs (eg 0-gemmascope-res-65k, 5-gemmascope-res-65k). Also has other customization options.
        api_response = api_instance.activation_all_batch_post(activation_all_batch_post_request)
        print("The response of DefaultApi->activation_all_batch_post:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->activation_all_batch_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to */v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**activation_all_batch_post**](docs/DefaultApi.md#activation_all_batch_post) | **POST** /activation/all-batch | For a given batch of prompts, get the top activating features for a set of SAEs (eg gemmascope-res-65k), or specific SAEs in the set of SAEs (eg 0-gemmascope-res-65k, 5-gemmascope-res-65k). Also has other customization options.
*DefaultApi* | [**activation_all_post**](docs/DefaultApi.md#activation_all_post) | **POST** /activation/all | For a given prompt, get the top activating features for a set of SAEs (eg gemmascope-res-65k), or specific SAEs in the set of SAEs (eg 0-gemmascope-res-65k, 5-gemmascope-res-65k). Also has other customization options.
*DefaultApi* | [**activation_single_batch_post**](docs/DefaultApi.md#activation_single_batch_post) | **POST** /activation/single-batch | Given a batch of text prompts, returns the activation values for a single SAE latent or custom vector+hook.
*DefaultApi* | [**activation_single_post**](docs/DefaultApi.md#activation_single_post) | **POST** /activation/single | Given a text prompt, returns the activation values for a single SAE latent or custom vector+hook.
*DefaultApi* | [**activation_source_post**](docs/DefaultApi.md#activation_source_post) | **POST** /activation/source | For a given prompt, get the top activating features for a source (eg 0-gemmascope-res-65k or 5-gemmascope-res-65k), and return the results as a 3D array of prompt x prompt_token x feature_index.
*DefaultApi* | [**activation_topk_by_token_batch_post**](docs/DefaultApi.md#activation_topk_by_token_batch_post) | **POST** /activation/topk-by-token-batch | For a given batch of prompts, get the top activating features at each token position for a single SAE.
*DefaultApi* | [**activation_topk_by_token_post**](docs/DefaultApi.md#activation_topk_by_token_post) | **POST** /activation/topk-by-token | For a given prompt, get the top activating features at each token position for a single SAE.
*DefaultApi* | [**steer_completion_chat_post**](docs/DefaultApi.md#steer_completion_chat_post) | **POST** /steer/completion-chat | For a given prompt, complete it by steering with the given feature or vector
*DefaultApi* | [**steer_completion_post**](docs/DefaultApi.md#steer_completion_post) | **POST** /steer/completion | For a given prompt, complete it by steering with the given feature or vector
*DefaultApi* | [**tokenize_post**](docs/DefaultApi.md#tokenize_post) | **POST** /tokenize | Tokenize input text for a given model
*DefaultApi* | [**util_sae_topk_by_decoder_cossim_post**](docs/DefaultApi.md#util_sae_topk_by_decoder_cossim_post) | **POST** /util/sae-topk-by-decoder-cossim | Given a specific vector or SAE feature, return the top features by cosine similarity in the same SAE
*DefaultApi* | [**util_sae_vector_post**](docs/DefaultApi.md#util_sae_vector_post) | **POST** /util/sae-vector | Get the raw vector for an SAE feature


## Documentation For Models

 - [ActivationAllBatchPost200Response](docs/ActivationAllBatchPost200Response.md)
 - [ActivationAllBatchPost200ResponseResultsInner](docs/ActivationAllBatchPost200ResponseResultsInner.md)
 - [ActivationAllBatchPostRequest](docs/ActivationAllBatchPostRequest.md)
 - [ActivationAllPost200Response](docs/ActivationAllPost200Response.md)
 - [ActivationAllPost200ResponseActivationsInner](docs/ActivationAllPost200ResponseActivationsInner.md)
 - [ActivationAllPostRequest](docs/ActivationAllPostRequest.md)
 - [ActivationSingleBatchPost200Response](docs/ActivationSingleBatchPost200Response.md)
 - [ActivationSingleBatchPost200ResponseResultsInner](docs/ActivationSingleBatchPost200ResponseResultsInner.md)
 - [ActivationSingleBatchPostRequest](docs/ActivationSingleBatchPostRequest.md)
 - [ActivationSinglePost200Response](docs/ActivationSinglePost200Response.md)
 - [ActivationSinglePost200ResponseActivation](docs/ActivationSinglePost200ResponseActivation.md)
 - [ActivationSinglePostRequest](docs/ActivationSinglePostRequest.md)
 - [ActivationSourcePost200Response](docs/ActivationSourcePost200Response.md)
 - [ActivationSourcePost200ResponseResultsInner](docs/ActivationSourcePost200ResponseResultsInner.md)
 - [ActivationSourcePostRequest](docs/ActivationSourcePostRequest.md)
 - [ActivationTopkByTokenBatchPost200Response](docs/ActivationTopkByTokenBatchPost200Response.md)
 - [ActivationTopkByTokenBatchPost200ResponseResultsInner](docs/ActivationTopkByTokenBatchPost200ResponseResultsInner.md)
 - [ActivationTopkByTokenBatchPostRequest](docs/ActivationTopkByTokenBatchPostRequest.md)
 - [ActivationTopkByTokenPost200Response](docs/ActivationTopkByTokenPost200Response.md)
 - [ActivationTopkByTokenPost200ResponseResultsInner](docs/ActivationTopkByTokenPost200ResponseResultsInner.md)
 - [ActivationTopkByTokenPost200ResponseResultsInnerTopFeaturesInner](docs/ActivationTopkByTokenPost200ResponseResultsInnerTopFeaturesInner.md)
 - [ActivationTopkByTokenPostRequest](docs/ActivationTopkByTokenPostRequest.md)
 - [NPFeature](docs/NPFeature.md)
 - [NPLogprob](docs/NPLogprob.md)
 - [NPLogprobTop](docs/NPLogprobTop.md)
 - [NPSteerChatMessage](docs/NPSteerChatMessage.md)
 - [NPSteerChatResult](docs/NPSteerChatResult.md)
 - [NPSteerCompletionResponseInner](docs/NPSteerCompletionResponseInner.md)
 - [NPSteerFeature](docs/NPSteerFeature.md)
 - [NPSteerMethod](docs/NPSteerMethod.md)
 - [NPSteerType](docs/NPSteerType.md)
 - [NPSteerVector](docs/NPSteerVector.md)
 - [SteerCompletionChatPost200Response](docs/SteerCompletionChatPost200Response.md)
 - [SteerCompletionChatPostRequest](docs/SteerCompletionChatPostRequest.md)
 - [SteerCompletionPost200Response](docs/SteerCompletionPost200Response.md)
 - [SteerCompletionRequest](docs/SteerCompletionRequest.md)
 - [TokenizePost200Response](docs/TokenizePost200Response.md)
 - [TokenizePostRequest](docs/TokenizePostRequest.md)
 - [UtilSaeTopkByDecoderCossimPost200Response](docs/UtilSaeTopkByDecoderCossimPost200Response.md)
 - [UtilSaeTopkByDecoderCossimPost200ResponseTopkDecoderCossimFeaturesInner](docs/UtilSaeTopkByDecoderCossimPost200ResponseTopkDecoderCossimFeaturesInner.md)
 - [UtilSaeTopkByDecoderCossimPostRequest](docs/UtilSaeTopkByDecoderCossimPostRequest.md)
 - [UtilSaeVectorPost200Response](docs/UtilSaeVectorPost200Response.md)
 - [UtilSaeVectorPostRequest](docs/UtilSaeVectorPostRequest.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="SimpleSecretAuth"></a>
### SimpleSecretAuth

- **Type**: API key
- **API key parameter name**: X-SECRET-KEY
- **Location**: HTTP header


## Author

johnny@neuronpedia.org


