# Generated by Django 2.1.8 on 2019-04-23 09:32

import uuid

import django.contrib.postgres.fields
import django.db.models.deletion
from django.db import migrations, models

import vng_api_common.fields
import vng_api_common.models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Applicatie",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "uuid",
                    models.UUIDField(
                        default=uuid.uuid4,
                        help_text="Unique resource identifier (UUID4)",
                        unique=True,
                    ),
                ),
                (
                    "client_ids",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(max_length=50),
                        help_text="Comma-separated list of identifiers used for authentication",
                        size=None,
                    ),
                ),
                (
                    "label",
                    models.CharField(
                        help_text="A human readable representation of the application",
                        max_length=100,
                    ),
                ),
                (
                    "heeft_alle_autorisaties",
                    models.BooleanField(
                        default=False, help_text="Globally allows everything"
                    ),
                ),
            ],
            bases=(vng_api_common.models.APIMixin, models.Model),
        ),
        migrations.CreateModel(
            name="Autorisatie",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "component",
                    models.CharField(
                        help_text="Name of the component to authorize", max_length=50
                    ),
                ),
                (
                    "zaaktype",
                    models.URLField(
                        help_text="Url of the zaaktype that is allowed", max_length=1000
                    ),
                ),
                (
                    "scopes",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(max_length=100),
                        help_text="Comma-separated list of identifiers used for authentication",
                        size=None,
                    ),
                ),
                (
                    "max_vertrouwelijkheidaanduiding",
                    vng_api_common.fields.VertrouwelijkheidsAanduidingField(
                        choices=[
                            ("openbaar", "OPENBAAR"),
                            ("beperkt openbaar", "BEPERKT OPENBAAR"),
                            ("intern", "INTERN"),
                            ("zaakvertrouwelijk", "ZAAKVERTROUWELIJK"),
                            ("vertrouwelijk", "VERTROUWELIJK"),
                            ("confidentieel", "CONFIDENTIEEL"),
                            ("geheim", "GEHEIM"),
                            ("zeer geheim", "ZEER GEHEIM"),
                        ],
                        help_text="Maximum level of confidentiality that is allowed",
                        max_length=20,
                    ),
                ),
                (
                    "applicatie",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="autorisaties",
                        to="authorizations.Applicatie",
                    ),
                ),
            ],
            bases=(vng_api_common.models.APIMixin, models.Model),
        ),
    ]
