'''
Author: Alaina Humiston 
email: athompson9@hawk.iit.edu

Periodic Table of information into the BE and spin-orbit splitting/branching ratios of all the elements, which the user will be able to select.
Goal is to create less user error by having default values for the GA to use as an initial guess

User simply picks the element and the algorithm examines the data and sets the bounds accordingly

Values for PE_lit, width, and rec_width takken from http://dx.doi.org/10.1006/adnd.2000.0848
Values for PE_alt and alt_width taken from http://dx.doi.org/10.1007/978-3-540-28619-6 This list also includes the data from the first, making it a greater culmination of data.
All values take the average of the BE found and the peak width. 


Will want to add in data from XES Oasis 
Need to also add in information about typical background subtraction/peak shape to choose for each element[i]i.e. Double Lorentzian for asymmetric ones and such
'''
#Issue: This is in BE not KE 
#Should we store information about KLL edges and satellites?
class ElementData: #Will need to change these values for KE input
    def __init__(self,element,photoelectronLine, transitionLine):
        self.element = element
        self.photoelectronLine = photoelectronLine
        self.transitionLine = transitionLine
       
        #self.PE_lit, self.is_singlet, self.so_split, self.branching_ratio = self.getParams(self.element,photoelectronLine)
        
        #print(element, photoelectronLine, "GOODBYE")
        #Should Hydrogen be an option? Some XES data can see He so I guess that should stay

    def getParams(self,element,photoelectronLine, transitionLine):

        #turn all these into arrays so they can be extracted per peak
        is_singlet = [True]* 10
        is_coster_kronig = [False]* 10
        so_split = [0.0]* 10
        branching_ratio = [0.0]* 10
        width = [0.05]* 10
        rec_width = [0.0]* 10
        PE_lit = [0.0]* 10
        PE_alt = [0.0]* 10
        alt_width = [0.0]* 10
        width_range = [0.05]* 10
        Default = False
        peakTypes = ['Voigt']* 10
      
     
        #Including different transitions for different peaks would mean needing to include a for loop of some kind
        #All of this is being done in xes_gui.py --> Will need to update number of peaks to correspond with values. Peak selection before/during periodic table selection?
        
       
        for i in range(10):
            if element[i]== 'H': #[0] state assumes all elements are the same
                if photoelectronLine[i] == 'K': #[0] also assuming all are the same edge
                    PE_lit[i] = 13.6
                else: #Else statement will always be the defaulted core energy level
                    PE_lit[i] = 13.6

            elif element[i]== 'He':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 24.6
                else:
                    PE_lit[i] = 24.6


            elif element[i]== 'Li':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 54.7
                    PE_alt[i] = 54.83
                    width[i] = 0.03
                    width_range[i] = 0.03
                else:
                    PE_lit[i] = 54.7


            elif element[i]== 'Be':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 111.5
                    PE_alt[i] = 111.3
                    alt_width[i] = 0.05
                    width_range[i] = 0.025 #GUESS
                else:
                    PE_lit[i] = 111.5


            elif element[i]== 'B':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 188
                    PE_alt[i] = 188
                    alt_width[i] = 0.06
                    width_range[i] = 0.025 #GUESS
                elif photoelectronLine[i] == 'L1':
                    PE_alt[i] = 14.05
                elif photoelectronLine[i] == 'L2':
                    PE_alt[i] = 4.85
                elif photoelectronLine[i] == 'L3':
                    PE_alt[i] = 4.7
                else:
                    PE_lit[i] = 188
            
            #Elements before C only have KL1 tranistion: No need for implementing tranisition line distinction
            elif element[i]== 'C':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 284.2
                    PE_alt[i] = 283.97
                    alt_width[i] = 0.061
                    width[i] = 0.085
                    width_range[i] = 0.025 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 276.9
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 282.02
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 282.03
                elif photoelectronLine[i] == 'L1':
                    PE_alt[i] = 19.39
                elif photoelectronLine[i] == 'L2':
                    PE_alt[i] = 7.47
                elif photoelectronLine[i] == 'L3':
                    PE_alt[i] = 6.4
                else:
                    PE_lit[i] = 284.2


            elif element[i]== 'N':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 409.9
                    PE_alt[i] = 400.19
                    alt_width[i] = 0.092
                    width[i] = 0.132
                    width_range[i] = 0.04 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 392.5
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 393.35
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 393.37

                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 37.3
                    PE_alt[i] = 25.41
                elif photoelectronLine[i] == 'L2':
                    PE_alt[i] = 9.03
                elif photoelectronLine[i] == 'L3':
                    PE_alt[i] = 9.3
                else:
                    PE_lit[i] = 409.9


            elif element[i]== 'O':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 543.1
                    PE_alt[i] = 532.0
                    alt_width[i] = 0.132
                    width[i] = 0.18
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 525.69
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 523.09
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 523.13
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 41.6
                    PE_alt[i] = 23.85
                    alt_width[i] = 0.01 #CHECK
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'L2':
                    PE_alt[i] = 6.97
                elif photoelectronLine[i] == 'L3':
                    PE_alt[i] = 7.17
                else:
                    PE_lit[i] = 543.1


            elif element[i]== 'F':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 696.7 
                    PE_alt[i] = 685.7
                    alt_width[i] = 0.18
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 676.94
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 671.32
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 671.39
                elif photoelectronLine[i] == 'L1':
                    PE_alt[i] = 32.0
                    alt_width[i] = 0.01 #CHECK
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'L2':
                    PE_alt[i] = 8.67
                elif photoelectronLine[i] == 'L3':
                    PE_alt[i] = 10.93
                else:
                    PE_lit[i] = 696.7


            elif element[i]== 'Ne':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 870.2
                    rec_width[i] = 0.24
                    PE_alt[i] = 868.0
                    alt_width[i] = 0.241
                    width[i] = 0.2
                    width_range[i] = 0.03 
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 817.69
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 843.6
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 846.08
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 857.67
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 48.5
                    PE_alt[i] = 46.75
                    alt_width[i] = 0.15 #CHECK
                    width_range[i] = 0.05 #GUESS
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 21.7
                    rec_width[i] = 0.01
                    PE_alt[i] = 19.33
                    alt_width[i] = 0.01
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 21.6
                    rec_width[i] = 0.01
                    PE_alt[i] = 19.33
                    alt_width[i] = 0.01
                    width_range[i] = 0.01 #GUESS
                else:
                    PE_lit[i] = 870.2


            elif element[i]== 'Na':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 1070.8
                    rec_width[i] = 0.28
                    PE_alt[i] = 1072.05
                    alt_width[i] = 0.29
                    width[i] = 0.28
                    width_range[i] = 0.03
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 1004.99
                        alt_width[i] = 0.81
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 1041.77
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 1041.33
                        alt_width[i] = 0.30
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 1070.44
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 63.5
                    rec_width[i] = 0.28
                    PE_alt[i] = 63.15
                    alt_width[i] = 0.332
                    width[i] = 0.28
                    width_range[i] = 0.2 #GUESS
                    if transitionLine[i] == 'L1L2':
                        PE_alt[i] = 32.83
                    elif transitionLine[i] == 'L1L3':
                        PE_alt[i] = 32.7
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 30.65
                    rec_width[i] = 0.02
                    PE_alt[i] = 31.05
                    alt_width[i] = 0.02
                    width_range[i] = 0.01 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 30.88
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 30.81
                    rec_width[i] = 0.02
                    PE_alt[i] = 31.0
                    alt_width[i] = 0.02
                    width[i] = 0.022
                    width_range[i] = 0.01 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 31.09
                elif photoelectronLine[i] == 'M1':
                    PE_alt[i] = 0.85
                else:
                    PE_lit[i] = 1070.8


            elif element[i]== 'Mg':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 1303.0
                    rec_width[i] = 0.33
                    PE_alt[i] = 1305
                    alt_width[i] = 0.341
                    width_range[i] = 0.03
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 1208.29
                        alt_width[i] = 1.453
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 1254.14
                        alt_width[i] = 0.33
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 1253.86
                        alt_width[i] = 0.345
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 1299.6
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 88.7
                    rec_width[i] = 0.46
                    PE_alt[i] = 89.2
                    alt_width[i] = 0.665
                    width[i] = 0.46
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'L1L2':
                        PE_alt[i] = 39.1
                        alt_width[i] = 1.39
                    elif transitionLine[i] == 'L1M1':
                        PE_alt[i] = 92.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 49.78
                    rec_width[i] = 0.03
                    PE_alt[i] = 51.7
                    alt_width[i] = 0.012
                    width_range[i] = 0.01 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 49.45
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 49.50
                    rec_width[i] = 0.03
                    PE_alt[i] = 51.57
                    alt_width[i] = 0.012
                    width[i] = 0.049
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 49.25
                elif photoelectronLine[i] == 'M1':
                    PE_alt[i] = 2.05
                else:
                    PE_lit[i] = 1303.0
            

            elif element[i]== 'Al':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 1559.6
                    width[i] = 0.47
                    rec_width[i] = 0.43
                    PE_alt[i] = 1559.8
                    alt_width[i] = 0.389
                    width_range[i] = 0.03 
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 1434.9
                        alt_width[i] = 1.77
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 1486.27
                        alt_width[i] = 0.435
                        width_range[i] = 0.06 
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 1486.67
                        alt_width[i] = 0.435
                        width_range[i] = 0.06 
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 1555.49
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 1561.28
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 1545.03
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 117.8
                    rec_width[i] = 0.9
                    PE_alt[i] = 117.85
                    alt_width[i] = 0.967
                    width_range[i] = 0.05
                    if transitionLine[i] == 'L1L2':
                        PE_alt[i] = 43.95
                        alt_width[i] = 1.39
                    elif transitionLine[i] == 'L1M1':
                        PE_alt[i] = 117.7
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 118.24
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 114.18
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 72.95
                    rec_width[i] = 0.05
                    PE_alt[i] = 73.43
                    alt_width[i] = 0.023
                    width_range[i] = 0.017 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 70.95
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 74.2
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 76.33
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 72.55
                    rec_width[i] = 0.05
                    PE_alt[i] = 72.85
                    alt_width[i] = 0.017
                    width_range[i] = 0.03 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 69.1
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 73.7
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 75.86
                elif photoelectronLine[i] == 'M1':
                    PE_alt[i] = 0.85
                else:
                    PE_lit[i] = 1559.6


            elif element[i]== 'Si':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 1839.0
                    width[i] = 0.427
                    rec_width[i] = 0.47
                    PE_alt[i] = 1838.95
                    alt_width[i] = 0.445
                    width_range[i] = 0.035 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 1681.75
                        alt_width[i] = 2.11
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 1739.36
                        alt_width[i] = 0.465
                        width_range[i] = 0.025
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 1739.99
                        alt_width[i] = 0.465
                        width_range[i] = 0.025
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 1835.68
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 1841.79
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 1821.98
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 149.7
                    rec_width[i] = 1.1
                    PE_alt[i] = 148.85
                    alt_width[i] = 1.205
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 148.42
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 155.24
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 145.03
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 99.82
                    rec_width[i] = 0.07
                    PE_alt[i] = 99.57
                    alt_width[i] = 0.028
                    width_range[i] = 0.022 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 95.15
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 102.11
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 102.15
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 99.42
                    rec_width[i] = 0.07
                    PE_alt[i] = 98.95
                    alt_width[i] = 0.24
                    width_range[i] = 0.04 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 93.81
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 100.63
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 101.46
                elif photoelectronLine[i] == 'M1':
                    PE_alt[i] = 7.8
                elif photoelectronLine[i] == 'M2':
                    PE_alt[i] = 3.0
                else:
                    PE_lit[i] = 1839.0


            elif element[i]== 'P':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 2145.5
                    rec_width[i] = 0.47
                    PE_alt[i] = 2147.25
                    alt_width[i] = 0.491
                    width_range[i] = 0.04 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 1948.85
                        alt_width[i] = 2.5
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 2012.8
                        alt_width[i] = 0.535
                        width_range[i] = 0.025
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 2013.74
                        alt_width[i] = 0.54
                        width_range[i] = 0.03
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 2137.1
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 2143.79
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 2139.8
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 189
                    rec_width[i] = 1.1
                    PE_alt[i] = 189.15
                    alt_width[i] = 1.463
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'L1L2':
                        PE_alt[i] = 48.01
                        alt_width[i] = 2.07
                    elif transitionLine[i] == 'L1L3':
                        PE_alt[i] = 48.97
                        alt_width[i] = 2.07
                    elif transitionLine[i] == 'L1M1':
                        PE_alt[i] = 181.7
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 189.34
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 186.4
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 136
                    rec_width[i] = 0.07
                    PE_alt[i] = 134.8
                    alt_width[i] = 0.046
                    width_range[i] = 0.024 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 121.2
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 130.65
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 127.7
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 135
                    rec_width[i] = 0.07
                    PE_alt[i] = 135.15
                    alt_width[i] = 0.047
                    width_range[i] = 0.03 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 121.42
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 129.07
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 126.1
                elif photoelectronLine[i] == 'M1':
                    PE_alt[i] = 16.1
                elif photoelectronLine[i] == 'M2':
                    PE_alt[i] = 9.8
                elif photoelectronLine[i] == 'M3':
                    PE_alt[i] = 10.05
                else:
                    PE_lit[i] = 2145.5


            elif element[i]== 'S':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 2472
                    width[i] = 0.613
                    rec_width[i] = 0.52
                    PE_alt[i] = 2472.0
                    alt_width[i] = 0.
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 2236.245
                        alt_width[i] = 2.92
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 2306.78
                        alt_width[i] = 0.615
                        width_range[i] = 0.025
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 2308.14
                        alt_width[i] = 0.62
                        width_range[i] = 0.03
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 2464.37
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 2469.73
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 2465.8
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 230.9
                    rec_width[i] = 1.3
                    PE_alt[i] = 229.1
                    alt_width[i] = 1.728
                    width_range[i] = 0.6 #GUESS
                    if transitionLine[i] == 'L1L2':
                        PE_alt[i] = 53.24
                        alt_width[i] = 2.46
                    elif transitionLine[i] == 'L1L3':
                        PE_alt[i] = 54.57
                        alt_width[i] = 2.46
                    elif transitionLine[i] == 'L1M1':
                        PE_alt[i] = 217.5
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 227.17
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 224.96
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 163.6
                    rec_width[i] = 0.09
                    PE_alt[i] = 165.07
                    alt_width[i] = 0.07
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 150.15
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 162.72
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 160.52
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 162.5
                    rec_width[i] = 0.09
                    PE_alt[i] = 164.1
                    alt_width[i] = 0.07
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 149.55
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 160.93
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 158.73
                elif photoelectronLine[i] == 'M1':
                    PE_alt[i] = 15.9
                elif photoelectronLine[i] == 'M2':
                    PE_alt[i] = 7.9
                elif photoelectronLine[i] == 'M3':
                    PE_alt[i] = 8.1
                else:
                    PE_lit[i] = 2472
                

            elif element[i]== 'Cl':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 2822.4
                    width[i] = 0.7
                    rec_width[i] = 0.57
                    PE_alt[i] = 2822.7
                    alt_width[i] = 0.595
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 2393.905
                        alt_width[i] = 3.38
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 2620.62
                        alt_width[i] = 0.7
                        width_range[i] = 0.02
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 2622.82
                        alt_width[i] = 0.7
                        width_range[i] = 0.02
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 2812.57
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 2819.04
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 2817.58
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 270.0
                    rec_width[i] = 1.5
                    PE_alt[i] = 270.1
                    alt_width[i] = 1.961
                    width_range[i] = 0.8 #GUESS
                    if transitionLine[i] == 'L1L2':
                        PE_alt[i] = 58.57
                        alt_width[i] = 2.91
                    elif transitionLine[i] == 'L1L3':
                        PE_alt[i] = 60.35
                        alt_width[i] = 2.91
                    elif transitionLine[i] == 'L1M1':
                        PE_alt[i] = 256
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 268.08
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 266.62
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 202.0
                    rec_width[i] = 0.11
                    PE_alt[i] = 201.8
                    alt_width[i] = 0.099
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 184.62
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 197.77
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 196.31
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 200.0
                    rec_width[i] = 0.11
                    PE_alt[i] = 200.0
                    alt_width[i] = 0.1
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 182.77
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 195.37
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 193.91
                elif photoelectronLine[i] == 'M1':
                    PE_alt[i] = 17.75
                elif photoelectronLine[i] == 'M2':
                    PE_alt[i] = 6.83
                elif photoelectronLine[i] == 'M3':
                    PE_alt[i] = 6.83
                else:
                    PE_lit[i] = 2822.4


            elif element[i]== 'Ar':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 3205.9
                    rec_width[i] = 0.66
                    PE_alt[i] =  3202.95
                    alt_width[i] = 0.657
                    width_range[i] = 0.03 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 2880.13
                        alt_width[i] = 3.87
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 2955.63
                        alt_width[i] = 0.795
                        width_range[i] = 0.015
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 2957.72
                        alt_width[i] = 0.795
                        width_range[i] = 0.015
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 3177.4
                        alt_width[i] = 0.78
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 3190.9
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 3190.98
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 3203.54
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 3205.0
                    elif transitionLine[i] == 'KP2':
                        PE_alt[i] = 3205.51
                    elif transitionLine[i] == 'KQ2':
                        PE_alt[i] = 3205.77
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 326.3
                    width[i] = 2.25
                    rec_width[i] = 1.8
                    PE_alt[i] = 322.0
                    alt_width[i] = 2.223
                    width_range[i] = 1.0 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 297.3
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 311.18
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 311.35
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 250.6
                    rec_width[i] = 0.13
                    PE_alt[i] = 248.3
                    alt_width[i] = 0.135
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 220.245
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 335.41
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 235.58
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 248.4
                    rec_width[i] = 0.13
                    PE_alt[i] = 246.23
                    alt_width[i] = 0.136
                    width_range[i] = 0.03 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 220.25
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 233.4
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 233.57
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 29.3
                    rec_width[i] = 0.14
                    PE_alt[i] = 25.15
                    alt_width[i] = 0.14
                    width_range[i] = 0.02 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 15.9
                    PE_alt[i] = 13.43
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 15.7
                    PE_alt[i] = 13.99
                else:
                    PE_lit[i] = 3205.9


            elif element[i]== 'K':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 3608.4
                    width[i] = 1.17
                    rec_width[i] = 0.71
                    PE_alt[i] = 3607.7
                    alt_width[i] = 0.713
                    width_range[i] = 0.03 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 3229.98
                        alt_width[i] = 4.36
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 3311.26
                        alt_width[i] = 0.875
                        width_range[i] = 0.015
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 3314.04
                        alt_width[i] = 0.875
                        width_range[i] = 0.015
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 3375.0
                        alt_width[i] = 0.87
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 3590.7
                        alt_width[i] = 0.68
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 3590.56
                        alt_width[i] = 0.68
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 3611.14
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 378.6
                    rec_width[i] = 2.1
                    PE_alt[i] = 377.05
                    alt_width[i] = 2.567
                    width_range[i] = 0.8 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 345.0
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 361.81
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 361.52
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 297.3
                    rec_width[i] = 0.18
                    PE_alt[i] = 296.65
                    alt_width[i] = 0.171
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 262.475
                        alt_width[i] = 0.18
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 279.81
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 279.52
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 299.17
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 294.6
                    rec_width[i] = 0.18
                    PE_alt[i] = 293.8
                    alt_width[i] = 0.172
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 260.0
                        alt_width[i] = 0.18
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 277.18
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 276.9
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 296.54
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 34.8
                    rec_width[i] = 0.7
                    PE_alt[i] = 33.95
                    alt_width[i] = 0.7
                    width_range[i] = 0.04 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 18.3
                    PE_alt[i] = 17.97
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 18.1
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 18.3
                    PE_alt[i] = 17.87
                    rec_width[i] = 1.2 #CHECK
                    width_range[i] = 0.2 #GUESS
                else:
                    PE_lit[i] = 3608.4


            elif element[i]== 'Ca':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 4038.5
                    width[i] = 1.24
                    rec_width[i] = 0.77
                    PE_alt[i] = 4038.05
                    alt_width[i] = 0.773
                    width_range[i] = 0.04 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 3598.89
                        alt_width[i] = 4.36
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 3687.78
                        alt_width[i] = 0.9655
                        width_range[i] = 0.0145
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 3691.34
                        alt_width[i] = 0.977
                        width_range[i] = 0.023
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 3993.8
                        alt_width[i] = 0.95
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 4013.32
                        alt_width[i] = 0.74
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 4013.44
                        alt_width[i] = 0.74
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 4043.2
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 438.4
                    rec_width[i] = 2.5
                    PE_alt[i] = 437.9
                    alt_width[i] = 2.84
                    width_range[i] = 0.9 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 394.9
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 415.43
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 415.8
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 444.32
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 349.7
                    rec_width[i] = 0.21
                    PE_alt[i] = 350.0
                    alt_width[i] = 0.197
                    width_range[i] = 0.03 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 306.415
                        alt_width[i] = 0.21
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 326.76
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 327.12
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 344.94
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 355.64
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 346.2
                    rec_width[i] = 0.21
                    PE_alt[i] = 346.7
                    alt_width[i] = 0.197
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 302.69
                        alt_width[i] = 0.21
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 323.34
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 323.71
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 341.34
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 352.23
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 44.3
                    rec_width[i] = 1.1
                    PE_alt[i] = 43.85
                    alt_width[i] = 0.82
                    width_range[i] = 0.2 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 25.4
                    rec_width[i] = 1.2
                    PE_alt[i] = 25.73
                    alt_width[i] = 0.6
                    width_range[i] = 0.6 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 24.2
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 25.4
                    rec_width[i] = 1.2
                    PE_alt[i] = 25.63
                    alt_width[i] = 0.601
                    width_range[i] = 0.6 #GUESS
                elif photoelectronLine[i] == 'N1':
                    PE_alt[i] = 1.8
                else:
                    PE_lit[i] = 4038.5

            
            elif element[i]== 'Sc':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 4492.0
                    rec_width[i] = 0.83
                    PE_alt[i] = 4492.9
                    alt_width[i] = 0.83
                    width_range[i] = 0.03 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 3991.57
                        alt_width[i] = 5.39
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 4085.73
                        alt_width[i] = 1.045
                        width_range[i] = 0.015
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 4090.46
                        alt_width[i] = 1.04
                        width_range[i] = 0.01
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 4438.8
                        alt_width[i] = 2.28
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 4460.63
                        alt_width[i] = 0.86
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 4461.22
                        alt_width[i] = 0.85
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 4495.16
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 498.0
                    rec_width[i] = 3.3
                    PE_alt[i] = 500.2
                    alt_width[i] = 3.37
                    width_range[i] = 1.2 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 447.3
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 468.75
                        alt_width[i] = 4.64
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 469.63
                        alt_width[i] = 4.64
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 499.22
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 503.6
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 403.6
                    rec_width[i] = 0.36
                    PE_alt[i] = 406.85
                    alt_width[i] = 0.26
                    width_range[i] = 0.1 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 352.91
                        alt_width[i] = 1.71
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 357.7
                        alt_width[i] = 0.29
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 377.5
                        alt_width[i] = 0.28
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 399.75
                        alt_width[i] = 0.23
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 409.73
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 398.7
                    rec_width[i] = 0.23
                    PE_alt[i] = 402.1
                    alt_width[i] = 0.217
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 348.33
                        alt_width[i] = 1.71
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 371.01
                        alt_width[i] = 0.29
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 372.78
                        alt_width[i] = 0.28
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 397.27
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 405.01
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 51.1
                    rec_width[i] = 1.7
                    PE_alt[i] = 53.9
                    alt_width[i] = 1.59
                    width_range[i] = 0.1 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 28.3
                    rec_width[i] = 1.2
                    PE_alt[i] = 32.7
                    alt_width[i] = 0.63
                    width_range[i] = 0.6 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 28.3
                    rec_width[i] = 1.2
                    PE_alt[i] = 31.93
                    alt_width[i] = 0.625
                    width_range[i] = 0.6 #GUESS
                elif photoelectronLine[i] == 'N1':
                    PE_alt[i] = 1.7
                else:
                    PE_lit[i] = 4492.0


            elif element[i]== 'Ti':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 4966.0
                    rec_width[i] = 0.89
                    PE_alt[i] = 4965.7
                    alt_width[i] = 0.897
                    width_range[i] = 0.045 #GUESS ZERO?
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 4404.59
                        alt_width[i] = 6.13
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 4504.86
                        alt_width[i] = 1.47
                        width_range[i] = 0.66
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 4510.85
                        alt_width[i] = 1.24
                        width_range[i] = 0.21
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 4907.1
                        alt_width[i] = 2.98
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 4931.5
                        alt_width[i] = 1.05
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 4932.7
                        alt_width[i] = 1.02
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 4963.7
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 4962.58
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 4971.09
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 560.9
                    rec_width[i] = 3.9
                    PE_alt[i] = 563.85
                    alt_width[i] = 3.837
                    width_range[i] = 1.3 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 502.5
                        alt_width[i] = 7.38
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 526.3
                        alt_width[i] = 5.26
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 529.9
                        alt_width[i] = 5.43
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 561.36
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 566.5
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 460.2
                    rec_width[i] = 0.52
                    PE_alt[i] = 461.25
                    alt_width[i] = 0.337
                    width_range[i] = 0.02 #GUESS ZERO?
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 401.29
                        alt_width[i] = 2.37
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 426.8
                        alt_width[i] = 0.44
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 430.4
                        alt_width[i] = 0.42
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 459.34
                        alt_width[i] = 5.46
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 458.08
                        alt_width[i] = 5.43
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 467.03
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 453.8
                    rec_width[i] = 0.25
                    PE_alt[i] = 455.25
                    alt_width[i] = 0.24
                    width_range[i] = 0.2 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 395.38
                        alt_width[i] = 2.37
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 420.5
                        alt_width[i] = 0.45
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 424.1
                        alt_width[i] = 0.42
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 453.18
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 451.93
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 460.72
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 58.7
                    rec_width[i] = 2.1
                    PE_alt[i] = 59.65
                    alt_width[i] = 2.487
                    width_range[i] = 0.7 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 32.6
                    rec_width[i] = 1.2
                    PE_alt[i] = 34.73
                    alt_width[i] = 0.533
                    width_range[i] = 0.7 #GUESS ZERO?
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 32.6
                    rec_width[i] = 1.2
                    PE_alt[i] = 32.2
                    alt_width[i] = 0.487
                    width_range[i] = 0.8 #GUESS ZERO?
                elif photoelectronLine[i] == 'N1':
                    PE_alt[i] = 1.6
                else:
                    PE_lit[i] = 4966.0


            elif element[i]== 'V':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 5465.0
                    rec_width[i] = 0.96
                    PE_alt[i] = 5465.05
                    alt_width[i] = 0.963
                    width_range[i] = 0.47 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 4838.5
                        alt_width[i] = 6.79
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 4944.6
                        alt_width[i] = 1.24
                        width_range[i] = 0.04
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 4952.15
                        alt_width[i] = 1.23
                        width_range[i] = 0.03
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 5399.3
                        alt_width[i] = 3.56
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 5426.65
                        alt_width[i] = 1.33
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 5428.17
                        alt_width[i] = 1.3
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 5463.73
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 5462.93
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 5471.17
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 626.7
                    rec_width[i] = 4.6
                    PE_alt[i] = 628.1
                    alt_width[i] = 4.31
                    width_range[i] = 1.6 #GUESS 
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 560.5
                        alt_width[i] = 8.55
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 585.5
                        alt_width[i] = 6.32
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 588.3
                        alt_width[i] = 6.3
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 539.93
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 632.67
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 519.8
                    rec_width[i] = 0.78
                    PE_alt[i] = 520.25
                    alt_width[i] = 0.44
                    width_range[i] = 0.34 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 453.64
                        alt_width[i] = 2.92
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 480.8
                        alt_width[i] = 0.69
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 486.4
                        alt_width[i] = 0.66
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 519.0
                        alt_width[i] = 0.28
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 512.1
                    rec_width[i] = 0.28
                    PE_alt[i] = 512.95
                    alt_width[i] = 0.267
                    width_range[i] = 0.5 #GUESS ZERO?
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 446.48
                        alt_width[i] = 2.92
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 472.6
                        alt_width[i] = 0.69
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 478.2
                        alt_width[i] = 0.66
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 511.92
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 511.11
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 519.38
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 66.3
                    rec_width[i] = 2.2
                    PE_alt[i] = 66.25
                    alt_width[i] = 3.007
                    width_range[i] = 1.1 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 37.2
                    rec_width[i] = 1.2
                    PE_alt[i] = 38.8
                    alt_width[i] = 0.713
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 36.35
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 37.2
                    rec_width[i] = 1.2
                    PE_alt[i] = 35
                    alt_width[i] = 0.79
                    width_range[i] = 0.41 #GUESS
                elif photoelectronLine[i] == 'M4':
                    PE_alt[i] = 2.1
                elif photoelectronLine[i] == 'N1':
                    PE_alt[i] = 1.7
                else:
                    PE_lit[i] = 5465.0


            elif element[i]== 'Cr':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 5989.0
                    width[i] = 1.283
                    rec_width[i] = 1.02
                    PE_alt[i] = 5989.1
                    alt_width[i] = 1.03
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 5293.35
                        alt_width[i] = 7.81
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 5405.55
                        alt_width[i] = 1.77
                        width_range[i] = 0.87
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 5414.76
                        alt_width[i] = 1.57
                        width_range[i] = 0.48
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 5917.2
                        alt_width[i] = 4.25
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 5944.68
                        alt_width[i] = 1.91
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 5946.8
                        alt_width[i] = 1.88
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 5986.96
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 5988.3
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 5989.03
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 696.0
                    rec_width[i] = 5.2
                    PE_alt[i] = 694.8
                    alt_width[i] = 4.857
                    width_range[i] = 2.0 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 620.9
                        alt_width[i] = 10.09
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 646.65
                        alt_width[i] = 7.75
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 649.03
                        alt_width[i] = 7.72
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 693.47
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 697.48
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 695.68
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 583.8
                    rec_width[i] = 0.76
                    PE_alt[i] = 583.85
                    alt_width[i] = 0.457
                    width_range[i] = 0.3 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 509.41
                        alt_width[i] = 3.58
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 536.7
                        alt_width[i] = 2.83
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 543.0
                        alt_width[i] = 1.21
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 581.75
                        alt_width[i] = 0.32
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 584.96
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 574.1
                    rec_width[i] = 0.32
                    PE_alt[i] = 574.75
                    alt_width[i] = 0.303
                    width_range[i] = 0.45 #GUESS ZERO?
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 500.16
                        alt_width[i] = 3.58
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 526.9
                        alt_width[i] = 1.25
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 533.2
                        alt_width[i] = 1.21
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 572.4
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 573.74
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 575.15
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 74.1
                    rec_width[i] = 2.3
                    PE_alt[i] = 74.05
                    alt_width[i] = 3.493
                    width_range[i] = 1.2 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 42.2
                    rec_width[i] = 1.2
                    PE_alt[i] = 43.8
                    alt_width[i] = 1.15
                    width_range[i] = 0.22 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 40.13
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 42.2
                    rec_width[i] = 1.2
                    PE_alt[i] = 41.2
                    alt_width[i] = 0.963
                    width_range[i] = 0.25 #GUESS
                elif photoelectronLine[i] == 'M4':
                    PE_alt[i] = 2.4
                elif photoelectronLine[i] == 'M5':
                    PE_alt[i] = 2.2
                elif photoelectronLine[i] == 'N1':
                    PE_alt[i] = 1.0
                else:
                    PE_lit[i] = 5989.0

            elif element[i]== 'Mn':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 6539.0
                    width[i] = 1.731
                    rec_width[i] = 1.11
                    PE_alt[i] = 6539.0
                    alt_width[i] = 1.113
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 5769.18
                        alt_width[i] = 7.79
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 5887.67
                        alt_width[i] = 1.46
                        width_range[i] = 0.04
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 5898.75
                        alt_width[i] = 1.46
                        width_range[i] = 0.02
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 6455.7
                        alt_width[i] = 4.45
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 6485.39
                        alt_width[i] = 2.14
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 6491.03
                        alt_width[i] = 2.1
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 6536.09
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 6538.54
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 6577.46
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 769.1
                    rec_width[i] = 6.2
                    PE_alt[i] = 769.0
                    alt_width[i] = 6.513
                    width_range[i] = 0.3 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 686.5
                        alt_width[i] = 10.11
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 714.23
                        alt_width[i] = 7.8
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 723.5
                        alt_width[i] = 7.76
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 768.34
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 769.36
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 775.27
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 649.9
                    rec_width[i] = 0.97
                    PE_alt[i] = 651.7
                    alt_width[i] = 0.557
                    width_range[i] = 0.42 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 567.81
                        alt_width[i] = 3.74
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 599.2
                        alt_width[i] = 1.44
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 606.5
                        alt_width[i] = 1.39
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 648.4
                        alt_width[i] = 0.36
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 658.26
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 638.7
                    rec_width[i] = 0.36
                    PE_alt[i] = 640.65
                    alt_width[i] = 0.347
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 556.4
                        alt_width[i] = 3.75
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 587.3
                        alt_width[i] = 1.44
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 594.6
                        alt_width[i] = 1.4
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 639.42
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 640.44
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 646.36
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 82.3
                    rec_width[i] = 2.4
                    PE_alt[i] = 83.95
                    alt_width[i] = 3.903
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 47.2
                    rec_width[i] = 1.2
                    PE_alt[i] = 50.23
                    alt_width[i] = 1.267
                    width_range[i] = 0.25 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 45.35
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 47.2
                    rec_width[i] = 1.2
                    PE_alt[i] = 48.0
                    alt_width[i] = 1.12
                    width_range[i] = 0.4 #GUESS
                elif photoelectronLine[i] == 'M4':
                    PE_alt[i] = 3.6
                elif photoelectronLine[i] == 'M5':
                    PE_alt[i] = 3.33
                elif photoelectronLine[i] == 'N1':
                    PE_alt[i] = 1.9
                else:
                    PE_lit[i] = 6539.0


            elif element[i]== 'Fe':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 7112.0
                    width[i] = 1.452
                    rec_width[i] = 1.19
                    PE_alt[i] = 7113.0
                    alt_width[i] = 1.197
                    width_range[i] = 0.53 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 6266.07
                        alt_width[i] = 8.53
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 6390.89
                        alt_width[i] = 2.12
                        width_range[i] = 1.08
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 6403.88
                        alt_width[i] = 1.88
                        width_range[i] = 0.6
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 7020.2
                        alt_width[i] = 4.84
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 7053.2
                        alt_width[i] = 2.66
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 7059.9
                        alt_width[i] = 2.6
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 7110.59
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 7111.5
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 7117.93
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 844.6
                    rec_width[i] = 7.0
                    PE_alt[i] = 846.05
                    alt_width[i] = 5.73
                    width_range[i] = 2.0 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 754.1
                        alt_width[i] = 11.07
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 787.2
                        alt_width[i] = 8.89
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 793.8
                        alt_width[i] = 8.84
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 844.52
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 845.44
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 851.86
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 719.9
                    rec_width[i] = 1.14
                    PE_alt[i] = 722.05
                    alt_width[i] = 0.637
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 627.77
                        alt_width[i] = 4.1
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 663.7
                        alt_width[i] = 1.91
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 670.4
                        alt_width[i] = 1.86
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 718.15
                        alt_width[i] = 0.4
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 728.41
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 706.8
                    rec_width[i] = 0.41
                    PE_alt[i] = 709.05
                    alt_width[i] = 0.393
                    width_range[i] = 0.04 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 615.4
                        alt_width[i] = 4.11
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 650.1
                        alt_width[i] = 1.87
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 656.8
                        alt_width[i] = 1.87
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 704.46
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 708.38
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 714.8
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 91.3
                    rec_width[i] = 2.4
                    PE_alt[i] = 93.95
                    alt_width[i] = 4.333
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 52.7
                    rec_width[i] = 1.23
                    PE_alt[i] = 56.033
                    alt_width[i] = 1.63
                    width_range[i] = 0.52 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 51.05
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 52.7
                    rec_width[i] = 1.23
                    PE_alt[i] = 54.0
                    alt_width[i] = 1.363
                    width_range[i] = 0.4 #GUESS
                elif photoelectronLine[i] == 'M4':
                    PE_alt[i] = 4.95
                elif photoelectronLine[i] == 'M5':
                    PE_alt[i] = 4.23
                elif photoelectronLine[i] == 'N1':
                    PE_alt[i] = 2.1
                else:
                    PE_lit[i] = 7112.0


            elif element[i]== 'Co':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 7709.0
                    width[i] = 1.555
                    rec_width[i] = 1.28
                    PE_alt[i] = 7708.95
                    alt_width[i] = 1.283
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 6784.08
                        alt_width[i] = 9.21
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 6915.4
                        alt_width[i] = 1.73
                        width_range[i] = 0.04
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 6930.25
                        alt_width[i] = 1.73
                        width_range[i] = 0.03
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 7609.0
                        alt_width[i] = 5.21
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 7645.5
                        alt_width[i] = 3.24
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 7651.5
                        alt_width[i] = 3.16
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 7708.35
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 7709.15
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 7716.05
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 925.1
                    rec_width[i] = 7.2
                    PE_alt[i] = 925.8
                    alt_width[i] = 5.987
                    width_range[i] = 2.0 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 824.9
                        alt_width[i] = 11.94
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 861.4
                        alt_width[i] = 9.98
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 867.4
                        alt_width[i] = 9.9
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 924.27
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 925.07
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 931.97
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 793.2
                    rec_width[i] = 1.13
                    PE_alt[i] = 793.8
                    alt_width[i] = 0.673
                    width_range[i] = 0.46 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 692.9
                        alt_width[i] = 4.43
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 731.5
                        alt_width[i] = 2.45
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 737.4
                        alt_width[i] = 2.38
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 791.35
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 795.08
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 801.98
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 778.1
                    rec_width[i] = 0.47
                    PE_alt[i] = 778.8
                    alt_width[i] = 0.457
                    width_range[i] = 0.3 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 677.5
                        alt_width[i] = 4.44
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 715.9
                        alt_width[i] = 2.47
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 721.9
                        alt_width[i] = 2.4
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 778.71
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 779.52
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 786.42
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 101.0
                    rec_width[i] = 2.4
                    PE_alt[i] = 100.85
                    alt_width[i] = 4.55
                    width_range[i] = 2.2 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 58.9
                    rec_width[i] = 1.25
                    PE_alt[i] = 60.9
                    alt_width[i] = 2.033
                    width_range[i] = 0.82 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 57.85
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 59.9
                    rec_width[i] = 1.27
                    PE_alt[i] = 58.85
                    alt_width[i] = 1.6
                    width_range[i] = 0.6 #GUESS
                elif photoelectronLine[i] == 'M4':
                    PE_alt[i] = 2.87
                elif photoelectronLine[i] == 'M5':
                    PE_alt[i] = 3.15
                elif photoelectronLine[i] == 'N1':
                    PE_alt[i] = 1.9
                else:
                    PE_lit[i] = 7709.0


            
            elif element[i]== 'Ni':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 8333.0
                    width[i] = 1.565
                    rec_width[i] = 1.39
                    PE_alt[i] = 8332.9
                    alt_width[i] = 1.387
                    width_range[i] = 0.57 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 7323.29
                        alt_width[i] = 9.85
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 7460.87
                        alt_width[i] = 2.82
                        width_range[i] = 0.96
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 7478.17
                        alt_width[i] = 2.29
                        width_range[i] = 0.78
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 8222.2
                        alt_width[i] = 5.58
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 8262.4
                        alt_width[i] = 3.87
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 8267.6
                        alt_width[i] = 3.87
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 8330.91
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 8331.59
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 8338.94
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 1008.6
                    rec_width[i] = 6.4
                    PE_alt[i] = 1008.05
                    alt_width[i] = 5.933
                    width_range[i] = 2.6 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 898.9
                        alt_width[i] = 12.76
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 939.1
                        alt_width[i] = 11.05
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 944.3
                        alt_width[i] = 10.96
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 1007.62
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 1008.30
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 1015.65
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 870.0
                    rec_width[i] = 0.98
                    PE_alt[i] = 871.95
                    alt_width[i] = 0.677
                    width_range[i] = 0.3 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 761.3
                        alt_width[i] = 4.77
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 802.4
                        alt_width[i] = 3.06
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 807.6
                        alt_width[i] = 2.97
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 868.5
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 871.63
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 878.98
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 852.7
                    rec_width[i] = 0.53
                    PE_alt[i] = 854.85
                    alt_width[i] = 0.513
                    width_range[i] = 0.4 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 741.55
                        alt_width[i] = 4.78
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 784.7
                        alt_width[i] = 3.07
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 789.9
                        alt_width[i] = 2.97
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 853.19
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 853.87
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 861.23
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 110.8
                    rec_width[i] = 2.3
                    PE_alt[i] = 111.9
                    alt_width[i] = 4.823
                    width_range[i] = 3.1 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 68.0
                    rec_width[i] = 1.3
                    PE_alt[i] = 69.1
                    alt_width[i] = 2.547
                    width_range[i] = 1.3 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 66.0
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 66.2
                    rec_width[i] = 1.3
                    PE_alt[i] = 68.85
                    alt_width[i] = 1.875
                    width_range[i] = 0.7 #GUESS
                elif photoelectronLine[i] == 'M4':
                    PE_alt[i] = 3.83
                elif photoelectronLine[i] == 'M5':
                    PE_alt[i] = 3.75
                elif photoelectronLine[i] == 'N1':
                    PE_alt[i] = 2.2
                else:
                    PE_lit[i] = 8333.0

            
            elif element[i]== 'Cu':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 8979.0
                    width[i] = 1.747
                    rec_width[i] = 1.49
                    PE_alt[i] = 8978.95
                    alt_width[i] = 1.495
                    width_range[i] = 0.06 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 7884.83
                        alt_width[i] = 10.57
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 8027.85
                        alt_width[i] = 2.10
                        width_range[i] = 0.07
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 8047.82
                        alt_width[i] = 2.08
                        width_range[i] = 0.03
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 8859.8
                        alt_width[i] = 6.16
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 8902.85
                        alt_width[i] = 5.0
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 8905.2
                        alt_width[i] = 4.89
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 8977.49
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 8977.14
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 8980.22
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 8977.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 1096.7
                    rec_width[i] = 5.5
                    PE_alt[i] = 1096.3
                    alt_width[i] = 6.095
                    width_range[i] = 2.0 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 975.0
                        alt_width[i] = 6.17
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 1019.1
                        alt_width[i] = 12.69
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 1022.0
                        alt_width[i] = 12.59
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 1092.7
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 1093.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 952.3
                    rec_width[i] = 1.04
                    PE_alt[i] = 951.0
                    alt_width[i] = 0.61
                    width_range[i] = 0.01 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 831.25
                        alt_width[i] = 5.32
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 875.6
                        alt_width[i] = 4.16
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 878.5
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 949.77
                        alt_width[i] = 4.60
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 949.44
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 951.84
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 932.7
                    width[i] = 0.653
                    rec_width[i] = 0.61
                    PE_alt[i] = 931.05
                    alt_width[i] = 0.585
                    width_range[i] = 0.04 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 810.85
                        alt_width[i] = 5.34
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 855.8
                        alt_width[i] = 4.17
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 858.8
                        alt_width[i] = 4.07
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 929.71
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 929.71
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 932.11
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 122.5
                    rec_width[i] = 2.2
                    PE_alt[i] = 119.9
                    alt_width[i] = 5.695
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 77.3
                    rec_width[i] = 1.9
                    PE_alt[i] = 74.3
                    alt_width[i] = 4.39
                    width_range[i] = 0.83 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 73.15
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 75.1
                    width[i] = 2.59
                    rec_width[i] = 1.8
                    PE_alt[i] = 73.467
                    alt_width[i] = 3.46
                    width_range[i] = 1.7 #GUESS
                elif photoelectronLine[i] == 'M4':
                    PE_alt[i] = 1.8
                elif photoelectronLine[i] == 'M5':
                    PE_alt[i] = 1.7
                elif photoelectronLine[i] == 'N1':
                    PE_alt[i] = 1.2
                else:
                    PE_lit[i] = 8979.0


            elif element[i]== 'Zn':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 9659.0
                    rec_width[i] = 1.62
                    PE_alt[i] = 9658.8
                    alt_width[i] = 1.617
                    width_range[i] = 0.06 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 8465.23
                        alt_width[i] = 11.06
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 8615.81
                        alt_width[i] = 2.86
                        width_range[i] = 1.10
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 8638.85
                        alt_width[i] = 2.65
                        width_range[i] = 0.75
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 9522.7
                        alt_width[i] = 6.32
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 9570.8
                        alt_width[i] = 5.33
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 9573.6
                        alt_width[i] = 5.18
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 9650.97
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 9651.31
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 9659.54
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 9658.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 1196.2
                    rec_width[i] = 4.8
                    PE_alt[i] = 1193.8
                    alt_width[i] = 6.39
                    width_range[i] = 2.0 #GUESS 
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 1057.5
                        alt_width[i] = 14.26
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 1105.6
                        alt_width[i] = 13.27
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 1108.4
                        alt_width[i] = 13.12
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 1185.7
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 1186.1     
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 1194.31             
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 1044.9
                    rec_width[i] = 1.06
                    PE_alt[i] = 1043.4
                    alt_width[i] = 0.817
                    width_range[i] = 0.24 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 906.0
                        alt_width[i] = 5.43
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 954.6
                        alt_width[i] = 4.44
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 957.4
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 1034.55
                        alt_width[i] = 4.29
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 1035.1
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 1043.33
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 1021.8
                    rec_width[i] = 0.68
                    PE_alt[i] = 1020.35
                    alt_width[i] = 0.67
                    width_range[i] = 0.4 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 889.5
                        alt_width[i] = 5.44
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 931.7
                        alt_width[i] = 4.45
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 934.5
                        alt_width[i] = 4.30
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 1011.87
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 1012.21
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 1020.44
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 139.8
                    rec_width[i] = 2.1
                    PE_alt[i] = 136.45
                    alt_width[i] = 4.253
                    width_range[i] = 2.1 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 91.4
                    rec_width[i] = 2.1
                    PE_alt[i] = 87.8
                    alt_width[i] = 3.523
                    width_range[i] = 1.4 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 79.0
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 88.6
                    rec_width[i] = 2.15
                    PE_alt[i] = 86.3
                    alt_width[i] = 2.623
                    width_range[i] = 1.1 #GUESS
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 10.2
                    PE_alt[i] = 8.33
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 10.1
                    PE_alt[i] = 8.37
                    width_range[i] = 0.5 #GUESS
                elif photoelectronLine[i] == 'N1':
                    PE_alt[i] = 1.3
                else:
                    PE_lit[i] = 9659.0


            elif element[i]== 'Ga':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 10367.0
                    rec_width[i] = 1.76
                    PE_alt[i] = 10367.05
                    alt_width[i] = 1.76
                    width_range[i] = 0.06 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 9067.89
                        alt_width[i] = 10.40
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 9224.83
                        alt_width[i] = 2.66
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 9251.7
                        alt_width[i] = 2.53
                        width_range[i] = 0.07
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 10210.4
                        alt_width[i] = 6.15
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 10260.14
                        alt_width[i] = 5.62
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 10264.1
                        alt_width[i] = 5.41
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 10349.92
                        alt_width[i] = 1.71
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 10350.49
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 10365.69
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 10370.50
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 1299.0
                    rec_width[i] = 4.1
                    PE_alt[i] = 1297.85
                    alt_width[i] = 5.397
                    width_range[i] = 2.5 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 1142.5
                        alt_width[i] = 13.16
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 1193.9
                        alt_width[i] = 12.63
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 1197.9
                        alt_width[i] = 12.42
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 1282.0
                        alt_width[i] = 12.41
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 1282.6   
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 1297.8
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 1302.61
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 1143.2
                    rec_width[i] = 0.77
                    PE_alt[i] = 1142.65
                    alt_width[i] = 0.637
                    width_range[i] = 0.26 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 984.21
                        alt_width[i] = 5.21
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 1036.7
                        alt_width[i] = 4.68
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 1040.7
                        alt_width[i] = 4.46
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 1124.48
                        alt_width[i] = 0.77
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 1125.39
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 1140.59
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 1145.4
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 1116.4
                    rec_width[i] = 0.77
                    PE_alt[i] = 1115.7
                    alt_width[i] = 0.763
                    width_range[i] = 0.42 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 957.3
                        alt_width[i] = 5.22
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 1009.9
                        alt_width[i] = 4.68
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 1013.9
                        alt_width[i] = 4.47
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 1098.03
                        alt_width[i] = 0.77
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 1098.59
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 1113.79
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 1118.61
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 159.5
                    rec_width[i] = 2.0
                    PE_alt[i] = 158.05
                    alt_width[i] = 3.23
                    width_range[i] = 1.2 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 103.5
                    rec_width[i] = 2.25
                    PE_alt[i] = 106.9
                    alt_width[i] = 3.09
                    width_range[i] = 0.84 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 100.0
                    rec_width[i] = 2.3
                    PE_alt[i] = 102.95
                    alt_width[i] = 3.01
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 18.7
                    rec_width[i] = 0.012
                    PE_alt[i] = 18.7
                    alt_width[i] = 0.011
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 18.7
                    PE_alt[i] = 17.033
                elif photoelectronLine[i] == 'N1':
                    PE_alt[i] = 5.6
                elif photoelectronLine[i] == 'N2':
                    PE_alt[i] = 0.9
                else:
                    PE_lit[i] = 10367.0


            elif element[i]== 'Ge':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 11103.0
                    rec_width[i] = 1.92
                    PE_alt[i] = 11103.55
                    alt_width[i] = 1.91
                    width_range[i] = 0.06 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 9692.08
                        alt_width[i] = 10.56
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 9855.3
                        alt_width[i] = 3.26
                        width_range[i] = 0.92
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 9886.4
                        alt_width[i] = 3.07
                        width_range[i] = 0.68
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 10924.0
                        alt_width[i] = 5.98
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 10978.05
                        alt_width[i] = 5.84
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 10982.1
                        alt_width[i] = 5.56
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 11074.59
                        alt_width[i] = 1.89
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 11075.33
                        alt_width[i] = 1.89
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 11098.72
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 11105.84
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 11101.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 1414.6
                    rec_width[i] = 3.8
                    PE_alt[i] = 1413.65
                    alt_width[i] = 5.347
                    width_range[i] = 1.8 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 1231.9
                        alt_width[i] = 12.83
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 1286.11
                        alt_width[i] = 12.70
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 1294.07
                        alt_width[i] = 12.42
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 1382.5
                        alt_width[i] = 8.75
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 1383.2
                        alt_width[i] = 8.74
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 1406.6
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 1413.76
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 1248.1
                    rec_width[i] = 0.86
                    PE_alt[i] = 1248.4
                    alt_width[i] = 0.883
                    width_range[i] = 0.07 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 1067.98
                        alt_width[i] = 4.98
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 1123.7
                        alt_width[i] = 4.83
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 1128.4
                        alt_width[i] = 4.55
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 1218.55
                        alt_width[i] = 0.89
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 1219.65
                        alt_width[i] = 0.88
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 1242.8
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 1250.17
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 1217.0
                    rec_width[i] = 0.86
                    PE_alt[i] = 1216.85
                    alt_width[i] = 0.84
                    width_range[i] = 0.09 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 1037.0
                        alt_width[i] = 4.97
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 1092.7
                        alt_width[i] = 4.83
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 1097.4
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 1187.91
                        alt_width[i] = 0.88
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 1188.66
                        alt_width[i] = 0.84
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 1193.7
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 1219.17
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 180.1
                    rec_width[i] = 2.1
                    PE_alt[i] = 180.5
                    alt_width[i] = 3.607
                    width_range[i] = 1.6 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 124.9
                    rec_width[i] = 2.3
                    PE_alt[i] = 128.45
                    alt_width[i] = 3.837
                    width_range[i] = 1.54 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 120.8
                    rec_width[i] = 2.3
                    PE_alt[i] = 121.4
                    alt_width[i] = 2.67
                    width_range[i] = 0.7 #GUESS
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 29.8
                    rec_width[i] = 0.045
                    PE_alt[i] = 28.97
                    alt_width[i] = 0.048
                    width_range[i] = 0.003 #GUESS
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 29.2
                    rec_width[i] = 0.044
                    PE_alt[i] = 28.73
                    alt_width[i] = 0.045
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'N1':
                    PE_alt[i] = 9.0
                elif photoelectronLine[i] == 'N2':
                    PE_alt[i] = 2.65
                else:
                    PE_lit[i] = 11103.0

            elif element[i]== 'As':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 11867.0
                    rec_width[i] = 2.09
                    PE_alt[i] = 11866.85
                    alt_width[i] = 2.08
                    width_range[i] = 0.07 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 10336.7
                        alt_width[i] = 9.86
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 10508.0
                        alt_width[i] = 3.06
                        width_range[i] = 0.11
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 10543.7
                        alt_width[i] = 3.01
                        width_range[i] = 0.08
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 11663.0
                        alt_width[i] = 5.97
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 1172.0
                        alt_width[i] = 5.96
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 11725.85
                        alt_width[i] = 5.64
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 11825.05
                        alt_width[i] = 2.07
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 11825.89
                        alt_width[i] = 2.07
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 11858.67
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 11867.94
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 11866.38
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 1527.0
                    rec_width[i] = 3.8
                    PE_alt[i] = 1526.75
                    alt_width[i] = 5.147
                    width_range[i] = 2.7 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 1326.3
                        alt_width[i] = 11.80
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 1384.54
                        alt_width[i] = 11.80
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 1390.4
                        alt_width[i] = 11.48
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 1488.3
                        alt_width[i] = 7.90
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 1489.2
                        alt_width[i] = 7.90
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 1522.0
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 1531.2
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 1529.68
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 1359.1
                    rec_width[i] = 0.95
                    PE_alt[i] = 1358.8
                    alt_width[i] = 0.97
                    width_range[i] = 0.06 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 1155.07
                        alt_width[i] = 4.89
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 1213.8
                        alt_width[i] = 4.88
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 1219.3
                        alt_width[i] = 4.56
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 1316.95
                        alt_width[i] = 0.99
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 1318.06
                        alt_width[i] = 0.99
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 1350.84
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 1360.10
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 1358.54
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 1323.6
                    rec_width[i] = 0.94
                    PE_alt[i] = 1323.05
                    alt_width[i] = 0.933
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 1119.9
                        alt_width[i] = 4.88
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 1178.1
                        alt_width[i] = 4.87
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 1183.7
                        alt_width[i] = 4.55
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 1281.56
                        alt_width[i] = 0.98
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 1282.41
                        alt_width[i] = 0.98
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 1315.19
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 1324.46
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 1322.90
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 204.7
                    rec_width[i] = 2.4
                    PE_alt[i] = 203.75
                    alt_width[i] = 3.18
                    width_range[i] = 0.6 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 146.2
                    rec_width[i] = 2.25
                    PE_alt[i] = 146.7
                    alt_width[i] = 3.1
                    width_range[i] = 0.85 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 141.2
                    rec_width[i] = 2.25
                    PE_alt[i] = 140.75
                    alt_width[i] = 2.94
                    width_range[i] = 0.7 #GUESS
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 41.7
                    rec_width[i] = 0.058
                    PE_alt[i] = 41.3
                    alt_width[i] = 0.059
                    width_range[i] = 0.001 #GUESS
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 41.7
                    rec_width[i] = 0.06
                    PE_alt[i] = 40.95
                    alt_width[i] = 0.06
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'N1':
                    PE_alt[i] = 12.5
                elif photoelectronLine[i] == 'N2':
                    PE_alt[i] = 2.75
                elif photoelectronLine[i] == 'N3':
                    PE_alt[i] = 2.75
                else:
                    PE_lit[i] = 11867.0


            elif element[i]== 'Se':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 12658.0
                    rec_width[i] = 2.28
                    PE_alt[i] = 12657.9
                    alt_width[i] = 2.27
                    width_range[i] = 0.07 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 11003.49
                        alt_width[i] = 10.23
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 11182.5
                        alt_width[i] = 3.70
                        width_range[i] = 0.7
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 11222.45
                        alt_width[i] = 3.54
                        width_range[i] = 0.6
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 12427.9
                        alt_width[i] = 6.43
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 12489.9
                        alt_width[i] = 6.06
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 12496.0
                        alt_width[i] = 5.70
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 12601.47
                        alt_width[i] = 2.26
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 12602.42
                        alt_width[i] = 2.26
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 12645.7
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 12656.38
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 12655.11
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 1652.0
                    rec_width[i] = 3.8
                    PE_alt[i] = 1653.95
                    alt_width[i] = 5.26
                    width_range[i] = 2.78 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 1424.4
                        alt_width[i] = 12.27
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 1486.8
                        alt_width[i] = 11.9
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 1493.0
                        alt_width[i] = 11.55
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 1598.0
                        alt_width[i] = 8.10
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 1598.9
                        alt_width[i] = 8.11
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 1642.2
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 1652.9
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 1651.62
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 1474.3
                    rec_width[i] = 1.05
                    PE_alt[i] = 1476.1
                    alt_width[i] = 1.07
                    width_range[i] = 0.06 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 1244.7
                        alt_width[i] = 5.26
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 1308.4
                        alt_width[i] = 4.89
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 1314.7
                        alt_width[i] = 4.54
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 1419.22
                        alt_width[i] = 1.09
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 1420.6
                        alt_width[i] = 1.09
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 1463.9
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 1474.55
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 1473.29
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 1433.9
                    rec_width[i] = 1.02
                    PE_alt[i] = 1435.9
                    alt_width[i] = 1.01
                    width_range[i] = 0.01 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 1204.45
                        alt_width[i] = 5.23
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 1267.7
                        alt_width[i] = 4.87
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 1273.9
                        alt_width[i] = 4.52
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 1378.92
                        alt_width[i] = 1.07
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 1379.88
                        alt_width[i] = 1.07
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 1423.1
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 1433.83
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 1432.57
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 229.6
                    rec_width[i] = 2.8
                    PE_alt[i] = 231.75
                    alt_width[i] = 3.777
                    width_range[i] = 0.9 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 166.5
                    rec_width[i] = 2.2
                    PE_alt[i] = 168.1
                    alt_width[i] = 2.687
                    width_range[i] = 1.17 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 160.7
                    rec_width[i] = 2.2
                    PE_alt[i] = 161.95
                    alt_width[i] = 2.57
                    width_range[i] = 0.6 #GUESS
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 55.5
                    rec_width[i] = 0.065
                    PE_alt[i] = 56.7
                    alt_width[i] = 0.062
                    width_range[i] = 0.003 #GUESS
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 54.6
                    rec_width[i] = 0.066
                    PE_alt[i] = 56.7
                    alt_width[i] = 0.065
                    width_range[i] = 0.005 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 53.80
                elif photoelectronLine[i] == 'N1':
                    PE_alt[i] = 16.2
                elif photoelectronLine[i] == 'N2':
                    PE_alt[i] = 5.8
                elif photoelectronLine[i] == 'N3':
                    PE_alt[i] = 5.73
                else:
                    PE_lit[i] = 12658.0
                    


            elif element[i]== 'Br':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 13474.0
                    rec_width[i] = 2.49
                    PE_alt[i] = 13473.85
                    alt_width[i] = 2.47
                    width_range[i] = 0.07 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 11692.04
                        alt_width[i] = 10.63
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 11877.9
                        alt_width[i] = 3.6
                        width_range[i] = 0.1
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 11924.18
                        alt_width[i] = 3.55
                        width_range[i] = 0.07
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 13218.6
                        alt_width[i] = 6.76
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 13284.85
                        alt_width[i] = 6.14
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 13291.76
                        alt_width[i] = 5.74
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 13403.97
                        alt_width[i] = 2.46
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 13405.04
                        alt_width[i] = 2.47
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 13459.8
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 13471.5
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 13470.84
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 1782.0
                    rec_width[i] = 3.8
                    PE_alt[i] = 1782.0
                    alt_width[i] = 5.383
                    width_range[i] = 2.86 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 1526.5
                        alt_width[i] = 12.59
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 1592.8
                        alt_width[i] = 11.98
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 1600.0
                        alt_width[i] = 11.58
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 1711.9
                        alt_width[i] = 8.3
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 1713.0
                        alt_width[i] = 8.3
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 1767.8
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 1779.5
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 1778.8
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 1596.0
                    rec_width[i] = 1.14
                    PE_alt[i] = 1596.0
                    alt_width[i] = 1.16
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 1339.65
                        alt_width[i] = 5.48
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 1407.2
                        alt_width[i] = 4.87
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 1414.4
                        alt_width[i] = 4.46
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 1525.86
                        alt_width[i] = 1.19
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 1527.35
                        alt_width[i] = 1.19
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 1582.1
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 1593.81
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 1593.15
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 1550.0
                    rec_width[i] = 1.11
                    PE_alt[i] = 1549.95
                    alt_width[i] = 1.09
                    width_range[i] = 0.01 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 1293.6
                        alt_width[i] = 5.44
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 1360.8
                        alt_width[i] = 4.83
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 1368.1
                        alt_width[i] = 4.42
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 1479.95
                        alt_width[i] = 1.15
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 1481.02
                        alt_width[i] = 1.16
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 1535.8
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 1547.49
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 1546.82
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 257.0
                    rec_width[i] = 3.2
                    PE_alt[i] = 256.75
                    alt_width[i] = 3.78
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'M1M2':
                        PE_alt[i] = 73.0
                        alt_width[i] = 8.10
                    elif transitionLine[i] == 'M1M3':
                        PE_alt[i] = 80.0
                        alt_width[i] = 7.70
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 189.0
                    rec_width[i] = 2.1
                    PE_alt[i] = 189.15
                    alt_width[i] = 2.92
                    width_range[i] = 0.82 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 113.3
                        alt_width[i] = 3.81
                    elif transitionLine[i] == 'M2N1':
                        PE_alt[i] = 161.31
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 182.0
                    rec_width[i] = 2.15
                    PE_alt[i] = 181.75
                    alt_width[i] = 2.745
                    width_range[i] = 0.6 #GUESS
                    if transitionLine[i] == 'M3M4':
                        PE_alt[i] = 108.95
                        alt_width[i] = 3.41
                    elif transitionLine[i] == 'M3M5':
                        PE_alt[i] = 108.95
                        alt_width[i] = 3.41
                    elif transitionLine[i] == 'M3N1':
                        PE_alt[i] = 155.45
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 70.0
                    rec_width[i] = 0.068
                    PE_alt[i] = 70.05
                    alt_width[i] = 0.069
                    width_range[i] = 0.001 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 64.89
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 65.85
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 69.0
                    rec_width[i] = 0.07
                    PE_alt[i] = 69.0
                    alt_width[i] = 0.07
                    width_range[i] = 0.005 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 64.37
                elif photoelectronLine[i] == 'N1':
                    PE_alt[i] = 27.15
                elif photoelectronLine[i] == 'N2':
                    PE_alt[i] = 5.1
                elif photoelectronLine[i] == 'N3':
                    PE_alt[i] = 4.8
                else:
                    PE_lit[i] = 13474.0


            elif element[i]== 'Kr':
                if photoelectronLine[i] == 'K':
                    PE_alt[i] = 14325.8
                    alt_width[i] = 2.693
                    width_range[i] = 0.073 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 12402.57
                        alt_width[i] = 9.79
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 12597.0
                        alt_width[i] = 4.17
                        width_range[i] = 0.45
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 12649.0
                        alt_width[i] = 3.98
                        width_range[i] = 0.23
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 14034.9
                        alt_width[i] = 7.79
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 14104.5
                        alt_width[i] = 6.16
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 14112.5
                        alt_width[i] = 5.70
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 14232.63
                        alt_width[i] = 2.69
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 14237.4
                        alt_width[i] = 2.69
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 14301.2
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 14314.1
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 14314.1
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 14328.6
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 14324.57
                    elif transitionLine[i] == 'KP2':
                        PE_alt[i] = 14325.86
                    elif transitionLine[i] == 'KQ2':
                        PE_alt[i] = 14326.45
                    elif transitionLine[i] == 'KR2':
                        PE_alt[i] = 14326.72
                elif photoelectronLine[i] == 'L1':
                    PE_alt[i] = 1921.0
                    alt_width[i] = 5.067
                    width_range[i] = 2.1 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 1632.4
                        alt_width[i] = 12.35
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 1699.0
                        alt_width[i] = 10.71
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 1708.5
                        alt_width[i] = 10.25
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 1830.1
                        alt_width[i] = 7.25
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 1831.3
                        alt_width[i] = 7.25
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 1898.7
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 1910.9
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 1911.5
                elif photoelectronLine[i] == 'L2':
                    PE_alt[i] = 1727.14
                    alt_width[i] = 1.26
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 1439.4
                        alt_width[i] = 6.394
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 1510.1
                        alt_width[i] = 4.76
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 1517.7
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 1637.0
                        alt_width[i] = 1.29
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 1638.3
                        alt_width[i] = 1.29
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 1704.5
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 1717.86
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 1714.0
                elif photoelectronLine[i] == 'L3':
                    PE_alt[i] = 1674.95
                    alt_width[i] = 1.177
                    width_range[i] = 0.013 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 1386.9
                        alt_width[i] = 6.34
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 1457.7
                        alt_width[i] = 4.71
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 1465.3
                        alt_width[i] = 4.25
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 1584.63
                        alt_width[i] = 1.24
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 1585.88
                        alt_width[i] = 1.24
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 1652.5
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 1665.43
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 1666.09
                elif photoelectronLine[i] == 'M1':
                    PE_alt[i] = 290.55
                    alt_width[i] = 4.927
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_alt[i] = 222.6
                    alt_width[i] = 3.093
                    width_range[i] = 1.5 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 195.0
                elif photoelectronLine[i] == 'M3':
                    PE_alt[i] = 214.07
                    alt_width[i] = 2.77
                    width_range[i] = 1.7 #GUESS
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 187.0
                elif photoelectronLine[i] == 'M4':
                    PE_alt[i] = 90.67
                    alt_width[i] = 0.076
                    width_range[i] = 0.013 #GUESS
                elif photoelectronLine[i] == 'M5':
                    PE_alt[i] = 90.17
                    alt_width[i] = 0.077
                    width_range[i] = 0.02 #GUESS
                elif photoelectronLine[i] == 'N1':
                    PE_alt[i] = 25.17
                    alt_width[i] = 0.4
                    width_range[i] = 0.05 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_alt[i] = 12.1
                elif photoelectronLine[i] == 'N3':
                    PE_alt[i] = 10.8
                    alt_width[i] = 0.01 #GUESS
                    width_range[i] = 0.01 #GUESS
                else:
                    PE_lit[i] = 14325.8



            elif element[i]== 'Rb':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 15200.0
                    rec_width[i] = 2.96
                    PE_alt[i] = 15199.85
                    alt_width[i] = 2.937
                    width_range[i] = 0.077 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 13135.18
                        alt_width[i] = 9.05
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 13335.95
                        alt_width[i] = 4.46
                        width_range[i] = 0.26
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 13395.25
                        alt_width[i] = 4.19
                        width_range[i] = 0.8
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 14878.6
                        alt_width[i] = 8.68
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 14951.93
                        alt_width[i] = 6.02
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 14961.7
                        alt_width[i] = 5.67
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 15088.21
                        alt_width[i] = 2.92
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 15089.65
                        alt_width[i] = 2.92
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 15166.8
                        alt_width[i] = 3.1
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 15185.59
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 15186.55
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 15205.5
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 2065.0
                    rec_width[i] = 3.75
                    PE_alt[i] = 2065.05
                    alt_width[i] = 4.8
                    width_range[i] = 1.41 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 1743.4
                        alt_width[i] = 12.04
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 1817.72
                        alt_width[i] = 9.37
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 1826.6
                        alt_width[i] = 9.03
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 1953.0
                        alt_width[i] = 6.28
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 1954.5
                        alt_width[i] = 6.28
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 2031.6
                        alt_width[i] = 6.46
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 2050.4
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 2051.4
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 1864.0
                    rec_width[i] = 1.34
                    PE_alt[i] = 1863.95
                    alt_width[i] = 1.36
                    width_range[i] = 0.07 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 1541.79
                        alt_width[i] = 7.14
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 1617.0
                        alt_width[i] = 4.47
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 1625.9
                        alt_width[i] = 4.13
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 1752.14
                        alt_width[i] = 1.38
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 1753.9
                        alt_width[i] = 1.38
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 1835.31
                        alt_width[i] = 1.56
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 1849.84
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 1850.79
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 1804.0
                    rec_width[i] = 1.27
                    PE_alt[i] = 1804.7
                    alt_width[i] = 1.263
                    width_range[i] = 0.013 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 1482.4
                        alt_width[i] = 7.08
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 1557.7
                        alt_width[i] = 4.41
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 1566.6
                        alt_width[i] = 4.07
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 1692.53
                        alt_width[i] = 1.32
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 1694.12
                        alt_width[i] = 1.32
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 1775.19
                        alt_width[i] = 1.50
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 1790.54
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 1791.50
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 326.7
                    rec_width[i] = 4.0
                    PE_alt[i] = 322.05
                    alt_width[i] = 4.915
                    width_range[i] = 1.8 #GUESS
                    if transitionLine[i] == 'M1M3':
                        PE_alt[i] = 85.9
                        alt_width[i] = 8.65
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 248.7
                    rec_width[i] = 1.9
                    PE_alt[i] = 247.7
                    alt_width[i] = 2.53
                    width_range[i] = 0.63 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 135.5
                    elif transitionLine[i] == 'M2N1':
                        PE_alt[i] = 217.4
                        alt_width[i] = 3.41
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 239.1
                    rec_width[i] = 1.95
                    PE_alt[i] = 238.75
                    #alt_width[i] = 4.77
                    alt_width[i] = 2.385 #CHECK
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'M3M4':
                        PE_alt[i] = 128.2
                        alt_width[i] = 2.88
                    elif transitionLine[i] == 'M3M5':
                        PE_alt[i] = 128.2
                        alt_width[i] = 2.89
                    elif transitionLine[i] == 'M3N1':
                        PE_alt[i] = 208.35
                        alt_width[i] = 3.07
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 113.0
                    rec_width[i] = 0.067
                    PE_alt[i] = 111.9
                    alt_width[i] = 0.069
                    width_range[i] = 0.002 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 97.0
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 97.83
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 112.0
                    rec_width[i] = 0.069
                    PE_alt[i] = 110.65
                    alt_width[i] = 0.07
                    width_range[i] = 0.005 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 95.4
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 30.5
                    rec_width[i] = 1.2
                    PE_alt[i] = 29.65
                    alt_width[i] = 0.625
                    width_range[i] = 0.7 #GUESS ZERO?
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 16.3
                    PE_alt[i] = 14.65
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 15.3
                    PE_alt[i] = 14.0
                    alt_width[i] = 0.01 #GUESS
                    width_range[i] = 0.01 #GUESS
                else:
                    PE_lit[i] = 15200.0


            elif element[i]== 'Sr':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 16105.0
                    rec_width[i] = 3.23
                    PE_alt[i] = 1604.8
                    alt_width[i] = 3.197
                    width_range[i] = 0.087 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 13889.75
                        alt_width[i] = 9.37
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 14098.02
                        alt_width[i] = 4.76
                        width_range[i] = 0.14
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 14165.1
                        alt_width[i] = 4.75
                        width_range[i] = 0.42
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 15748.1
                        alt_width[i] = 9.68
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 15825.1
                        alt_width[i] = 5.93
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 15835.95
                        alt_width[i] = 5.59
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 15971.05
                        alt_width[i] = 3.18
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 15971.9
                        alt_width[i] = 3.18
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 16068.8
                        alt_width[i] = 3.12
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 16086.68
                        alt_width[i] = 3.12
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 16086.84
                        alt_width[i] = 3.12
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 16103.85
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 2216.0
                    rec_width[i] = 3.75
                    PE_alt[i] = 2216.15
                    alt_width[i] = 4.89
                    width_range[i] = 1.36 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 1858.4
                        alt_width[i] = 12.82
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 1936.37
                        alt_width[i] = 9.07
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 1947.15
                        alt_width[i] = 8.72
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 2080.5
                        alt_width[i] = 6.31
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 2082.2
                        alt_width[i] = 6.31
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 2179.0
                        alt_width[i] = 6.9
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 2195.9
                        alt_width[i] = 6.25
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 2197.1
                        alt_width[i] = 6.25
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 2007.0
                    rec_width[i] = 1.43
                    PE_alt[i] = 2006.9
                    alt_width[i] = 1.457
                    width_range[i] = 0.083 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 1649.32
                        alt_width[i] = 7.97
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 1728.1
                        alt_width[i] = 4.22
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 1738.3
                        alt_width[i] = 3.87
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 1871.72
                        alt_width[i] = 1.46
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 1873.88
                        alt_width[i] = 1.46
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 1969.15
                        alt_width[i] = 2.05
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 1987.67
                        alt_width[i] = 1.4
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 1988.82
                        alt_width[i] = 1.4
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 1940.0
                    rec_width[i] = 1.35
                    PE_alt[i] = 1939.8
                    alt_width[i] = 1.357
                    width_range[i] = 0.033 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 1582.19
                        alt_width[i] = 7.9
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 1661.4
                        alt_width[i] = 4.15
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 1671.5
                        alt_width[i] = 3.8
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 1804.73
                        alt_width[i] = 1.39
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 1806.59
                        alt_width[i] = 1.36
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 1901.81
                        alt_width[i] = 1.98
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 1920.88
                        alt_width[i] = 1.33
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 1922.04
                        alt_width[i] = 1.34
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 358.7
                    rec_width[i] = 4.4
                    PE_alt[i] = 357.75
                    alt_width[i] = 5.723
                    width_range[i] = 0.9 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 280.3
                    rec_width[i] = 1.9
                    PE_alt[i] = 279.9
                    alt_width[i] = 2.307
                    width_range[i] = 0.513 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 144.7
                        alt_width[i] = 2.88
                    elif transitionLine[i] == 'M2N1':
                        PE_alt[i] = 241.6
                        alt_width[i] = 3.47
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 270.0
                    rec_width[i] = 1.9
                    PE_alt[i] = 269.05
                    alt_width[i] = 2.19
                    width_range[i] = 0.3 #GUESS
                    if transitionLine[i] == 'M3M4':
                        PE_alt[i] = 135.7
                        alt_width[i] = 2.53
                    elif transitionLine[i] == 'M3M5':
                        PE_alt[i] = 135.7
                        alt_width[i] = 2.54
                    elif transitionLine[i] == 'M3N1':
                        PE_alt[i] = 231.3
                        alt_width[i] = 3.12
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 136.0
                    rec_width[i] = 0.061
                    PE_alt[i] = 135.0
                    alt_width[i] = 0.067
                    width_range[i] = 0.013 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 114.8
                        alt_width[i] = 0.06
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 117.73
                        alt_width[i] = 0.06
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 134.2
                    rec_width[i] = 0.064
                    PE_alt[i] = 133.05
                    alt_width[i] = 0.068
                    width_range[i] = 0.012 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 114.0
                        alt_width[i] = 0.07
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 38.9
                    rec_width[i] = 1.6
                    PE_alt[i] = 37.85
                    alt_width[i] = 1.083
                    width_range[i] = 0.52 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 21.3
                    rec_width[i] = 0.4
                    PE_alt[i] = 20.2
                    alt_width[i] = 0.2
                    width_range[i] = 0.199 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 20.1
                    PE_alt[i] = 19.8
                    alt_width[i] = 0.0001
                    width_range[i] = 0.0001 #GUESS
                else:
                    PE_lit[i] = 16105.0


            elif element[i]== 'Y':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 17038.0
                    rec_width[i] = 3.51
                    PE_alt[i] = 17038.7
                    alt_width[i] = 3.473
                    width_range[i] = 0.083 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 14667.13
                        alt_width[i] = 9.43
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 14884.5
                        alt_width[i] = 5.05
                        width_range[i] = 0.15
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 14959.2
                        alt_width[i] = 4.91
                        width_range[i] = 0.11
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 16644.7
                        alt_width[i] = 10.39
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 16725.95
                        alt_width[i] = 5.91
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 16738.04
                        alt_width[i] = 6.07
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 16879.1
                        alt_width[i] = 3.46
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 16881.39
                        alt_width[i] = 3.46
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 16694.8
                        alt_width[i] = 5.55
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 17012.08
                        alt_width[i] = 3.46
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 17015.3
                        alt_width[i] = 3.45
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 17037.0
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 17037.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 2373.0
                    rec_width[i] = 3.75
                    PE_alt[i] = 2372.75
                    alt_width[i] = 4.833
                    width_range[i] = 1.21 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 1977.5
                        alt_width[i] = 13.13
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 2060.0
                        alt_width[i] = 8.56
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 2072.19
                        alt_width[i] = 8.71
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 2212.1
                        alt_width[i] = 6.10
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 2214.3
                        alt_width[i] = 6.11
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 2327.7
                        alt_width[i] = 8.3
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 2345.0
                        alt_width[i] = 6.10
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 2348.2
                        alt_width[i] = 6.10
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 2156.0
                    rec_width[i] = 1.53
                    PE_alt[i] = 2155.25
                    alt_width[i] = 1.557
                    width_range[i] = 0.093 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 1760.93
                        alt_width[i] = 8.59
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 1843.8
                        alt_width[i] = 4.01
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 1855.4
                        alt_width[i] = 4.17
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 1995.83
                        alt_width[i] = 1.55
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 1998.39
                        alt_width[i] = 1.56
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 2110.2
                        alt_width[i] = 3.75
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 2129.08
                        alt_width[i] = 1.55
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 2132.3
                        alt_width[i] = 1.55
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 2157.9
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 2080.0
                    rec_width[i] = 1.43
                    PE_alt[i] = 2080.0
                    alt_width[i] = 1.447
                    width_range[i] = 0.053 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 1685.4
                        alt_width[i] = 8.51
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 1768.6
                        alt_width[i] = 3.93
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 1780.3
                        alt_width[i] = 4.09
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 1920.49
                        alt_width[i] = 1.47
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 1922.53
                        alt_width[i] = 1.48
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 2034.41
                        alt_width[i] = 3.67
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 2053.95
                        alt_width[i] = 1.48
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 2057.16
                        alt_width[i] = 1.48
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 2082.77
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 392.0
                    rec_width[i] = 4.9
                    PE_alt[i] = 394.3
                    alt_width[i] = 5.995
                    width_range[i] = 1.2 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 310.6
                    rec_width[i] = 1.95
                    PE_alt[i] = 312.7
                    alt_width[i] = 2.235
                    width_range[i] = 0.285 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 152.2
                        alt_width[i] = 2.58
                    elif transitionLine[i] == 'M2N1':
                        PE_alt[i] = 267.0
                        alt_width[i] = 4.78
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 298.8
                    rec_width[i] = 1.95
                    PE_alt[i] = 300.65
                    alt_width[i] = 2.315
                    width_range[i] = 0.4 #GUESS
                    if transitionLine[i] == 'M3M4':
                        PE_alt[i] = 143.4
                        alt_width[i] = 2.74
                    elif transitionLine[i] == 'M3M5':
                        PE_alt[i] = 143.4
                        alt_width[i] = 2.74
                    elif transitionLine[i] == 'M3N1':
                        PE_alt[i] = 256.0
                        alt_width[i] = 4.93
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 294.86
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 294.79
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 157.7
                    rec_width[i] = 0.062
                    PE_alt[i] = 159.8
                    alt_width[i] = 0.061
                    width_range[i] = 0.001 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 132.8
                        alt_width[i] = 0.13
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 132.8
                        alt_width[i] = 0.12
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 155.8
                    rec_width[i] = 0.066
                    PE_alt[i] = 157.7
                    alt_width[i] = 0.068
                    width_range[i] = 0.01 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 134.37
                        alt_width[i] = 0.13
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 43.8
                    rec_width[i] = 2.0
                    PE_alt[i] = 45.7
                    alt_width[i] = 2.13
                    width_range[i] = 0.13 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 24.4
                    rec_width[i] = 0.8
                    PE_alt[i] = 26.57
                    alt_width[i] = 0.43
                    width_range[i] = 0.37 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 23.1
                    rec_width[i] = 0.3
                    PE_alt[i] = 24.8
                    alt_width[i] = 0.18
                    width_range[i] = 0.12 #GUESS
                else:
                    PE_lit[i] = 17038.0


            elif element[i]== 'Zr':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 17998.0
                    rec_width[i] = 3.83
                    PE_alt[i] = 17997.8
                    alt_width[i] = 3.79
                    width_range[i] = 0.09 #GUESS ZERO
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 15467.0
                        alt_width[i] = 9.39
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 15691.3
                        alt_width[i] = 5.38
                        width_range[i] = 0.24
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 15775.0
                        alt_width[i] = 5.43
                        width_range[i] = 0.3
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 17658.0
                        alt_width[i] = 11.29
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 17653.8
                        alt_width[i] = 6.38
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 17667.4
                        alt_width[i] = 6.53
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 17815.21
                        alt_width[i] = 3.77
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 17817.98
                        alt_width[i] = 3.77
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 17948.5
                        alt_width[i] = 8.21
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 17966.67
                        alt_width[i] = 3.96
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 17971.47
                        alt_width[i] = 3.95
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 18000.09
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 17994.1
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 2532.0
                    width[i] = 3.72
                    rec_width[i] = 3.75
                    PE_alt[i] = 2531.8
                    alt_width[i] = 4.74
                    width_range[i] = 0.99 #GUESS ZERO
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 2101.0
                        alt_width[i] = 13.28
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 2187.4
                        alt_width[i] = 6.99
                        width_range[i] = 1.4
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 2201.0
                        alt_width[i] = 7.065
                        width_range[i] = 1.5
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 2348.2
                        alt_width[i] = 5.76
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 2350.9
                        alt_width[i] = 5.76
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 2481.5
                        alt_width[i] = 10.2
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 2499.6
                        alt_width[i] = 5.96
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 2504.4
                        alt_width[i] = 5.94
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 2533.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 2307.0
                    width[i] = 1.75
                    rec_width[i] = 1.63
                    PE_alt[i] = 2306.85
                    alt_width[i] = 1.667
                    width_range[i] = 0.113 #GUESS ZERO
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 1876.1
                        alt_width[i] = 9.17
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 1963.5
                        alt_width[i] = 4.28
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 1976.8
                        alt_width[i] = 4.43
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 2124.4
                        alt_width[i] = 1.71
                        width_range[i] = 0.11
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 2127.36
                        alt_width[i] = 1.66
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 2255.13
                        alt_width[i] = 6.10
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 2276.06
                        alt_width[i] = 1.86
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 2280.86
                        alt_width[i] = 1.85
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 2302.63
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 2223.0
                    width[i] = 1.50
                    rec_width[i] = 1.51
                    PE_alt[i] = 2227.65
                    alt_width[i] = 1.46
                    width_range[i] = 0.09 #GUESS ZERO
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 1792.0
                        alt_width[i] = 9.08
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 1879.2
                        alt_width[i] = 4.19
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 1892.6
                        alt_width[i] = 4.34
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 2039.9
                        alt_width[i] = 1.53
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 2042.33
                        alt_width[i] = 1.62
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 2171.24
                        alt_width[i] = 6.01
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 2191.8
                        alt_width[i] = 1.77
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 2196.6
                        alt_width[i] = 1.76
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 2225.22
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 2219.4
                        alt_width[i] = 5.13
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 430.3
                    rec_width[i] = 5.4
                    PE_alt[i] = 430.65
                    alt_width[i] = 6.487
                    width_range[i] = 1.1 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 343.5
                    rec_width[i] = 2.0
                    PE_alt[i] = 344.6
                    alt_width[i] = 2.373
                    width_range[i] = 0.373 #GUESS ZERO
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 161.7
                        alt_width[i] = 2.76
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 329.8
                    rec_width[i] = 2.0
                    PE_alt[i] = 330.75
                    alt_width[i] = 2.413
                    width_range[i] = 0.413 #GUESS
                    if transitionLine[i] == 'M3M5':
                        PE_alt[i] = 153.3
                        alt_width[i] = 2.91
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 324.21
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 324.36
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 181.1
                    rec_width[i] = 0.07
                    PE_alt[i] = 182.7
                    alt_width[i] = 0.071
                    width_range[i] = 0.003 #GUESS ZERO
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 151.1
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 177.0
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 178.8
                    rec_width[i] = 0.074
                    PE_alt[i] = 180.0
                    alt_width[i] = 0.071
                    width_range[i] = 0.01 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 153.75
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 50.6
                    rec_width[i] = 2.4
                    PE_alt[i] = 56.65
                    alt_width[i] = 3.97
                    width_range[i] = 1.6 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 28.5
                    rec_width[i] = 1.2
                    PE_alt[i] = 29.0
                    alt_width[i] = 0.493
                    width_range[i] = 0.707 #GUESS ZERO
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 27.1
                    rec_width[i] = 0.6
                    PE_alt[i] = 27.8
                    alt_width[i] = 0.287
                    width_range[i] = 0.35 #GUESS ZERO
                else:
                    PE_lit[i] = 17998.0


            elif element[i]== 'Nb':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 18986.0
                    rec_width[i] = 4.16
                    PE_alt[i] = 18985.8
                    alt_width[i] = 4.107
                    width_range[i] = 0.087 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 1629.01
                        alt_width[i] = 9.92
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 16521.14
                        alt_width[i] = 5.85
                        width_range[i] = 0.15
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 16615.08
                        alt_width[i] = 5.7
                        width_range[i] = 0.1
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 18518.9
                        alt_width[i] = 12.0
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 18606.25
                        alt_width[i] = 6.81
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 18622.75
                        alt_width[i] = 6.95
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 18778.45
                        alt_width[i] = 4.11
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 18782.22
                        alt_width[i] = 4.11
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 18930.5
                        alt_width[i] = 11.98
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 18948.34
                        alt_width[i] = 5.05
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 18955.56
                        alt_width[i] = 5.09
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 18985.99
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 18980.00
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 2698.0
                    width[i] = 3.9
                    rec_width[i] = 3.8
                    PE_alt[i] = 2697.85
                    alt_width[i] = 4.547
                    width_range[i] = 1.35 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 2228.7
                        alt_width[i] = 13.88
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 2319.38
                        alt_width[i] = 8.69
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 2334.85
                        alt_width[i] = 8.84
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 2487.6
                        alt_width[i] = 5.99
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 2492.05
                        alt_width[i] = 5.99
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 2640.4
                        alt_width[i] = 13.86
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 2658.2
                        alt_width[i] = 6.93
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 2665.4
                        alt_width[i] = 6.97
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 2695.8
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 2465.0
                    width[i] = 1.76
                    rec_width[i] = 1.73
                    PE_alt[i] = 2464.85
                    alt_width[i] = 1.763
                    width_range[i] = 0.107 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 1996.21
                        alt_width[i] = 4.49
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 2087.5
                        alt_width[i] = 4.49
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 2102.7
                        alt_width[i] = 4.64
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 2257.39
                        alt_width[i] = 1.78
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 2260.88
                        alt_width[i] = 1.8
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 2406.62
                        alt_width[i] = 9.65
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 2426.99
                        alt_width[i] = 2.73
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 2434.21
                        alt_width[i] = 2.77
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 2461.6
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 2371.0
                    width[i] = 1.54
                    rec_width[i] = 1.6
                    PE_alt[i] = 2370.75
                    alt_width[i] = 1.613
                    width_range[i] = 0.047 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 1902.23
                        alt_width[i] = 9.56
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 1993.2
                        alt_width[i] = 4.37
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 2008.4
                        alt_width[i] = 4.52
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 2163.01
                        alt_width[i] = 1.68
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 2165.90
                        alt_width[i] = 1.68
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 2312.6
                        alt_width[i] = 9.55
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 2332.68
                        alt_width[i] = 2.61
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 2339.9
                        alt_width[i] = 2.61
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 2370.34
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 2367.3
                        alt_width[i] = 5.13
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 466.6
                    rec_width[i] = 5.8
                    PE_alt[i] = 468.7
                    alt_width[i] = 6.89
                    width_range[i] = 1.1 #GUESS
                    if transitionLine[i] == 'M1N2':
                        PE_alt[i] = 437.0
                        alt_width[i] = 9.01
                    elif transitionLine[i] == 'M1N3':
                        PE_alt[i] = 437.0
                        alt_width[i] = 9.05
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 376.1
                    rec_width[i] = 2.05
                    PE_alt[i] = 378.7
                    alt_width[i] = 2.42
                    width_range[i] = 0.37 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 171.8
                        alt_width[i] = 2.88
                    elif transitionLine[i] == 'M2N1':
                        PE_alt[i] = 323.0
                        alt_width[i] = 10.75
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 375.0
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 360.6
                    rec_width[i] = 2.05
                    PE_alt[i] = 363.0
                    alt_width[i] = 2.495
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'M3M5':
                        PE_alt[i] = 158.20
                        alt_width[i] = 3.03
                    elif transitionLine[i] == 'M3N1':
                        PE_alt[i] = 305.0
                        alt_width[i] = 10.90
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 356.0
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 356.0
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 205.0
                    rec_width[i] = 0.092
                    PE_alt[i] = 207.7
                    alt_width[i] = 0.091
                    width_range[i] = 0.001 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 174.24
                        alt_width[i] = 1.12
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 176.46
                        alt_width[i] = 1.16
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 200.2
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 202.3
                    rec_width[i] = 0.095
                    PE_alt[i] = 204.8
                    alt_width[i] = 0.098
                    width_range[i] = 0.01 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 173.45
                        alt_width[i] = 1.17
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 56.4
                    rec_width[i] = 2.8
                    PE_alt[i] = 58.05
                    alt_width[i] = 5.38
                    width_range[i] = 2.6 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 32.6
                    rec_width[i] = 1.5
                    PE_alt[i] = 34.5
                    alt_width[i] = 1.265
                    width_range[i] = 0.235 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 30.8
                    rec_width[i] = 1.0
                    PE_alt[i] = 32.5
                    alt_width[i] = 1.035
                    width_range[i] = 0.06 #GUESS
                else:
                    PE_lit[i] = 18986.0


            elif element[i]== 'Mo':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 20000.0
                    rec_width[i] = 4.52
                    PE_alt[i] = 19999.75
                    alt_width[i] = 4.47
                    width_range[i] = 0.1 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 17135.0
                        alt_width[i] = 10.5
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 17374.4
                        alt_width[i] = 6.48
                        width_range[i] = 0.3
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 17479.5
                        alt_width[i] = 6.39
                        width_range[i] = 0.41
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 19495.8
                        alt_width[i] = 12.87
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 19590.4
                        alt_width[i] = 7.31
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 19608.3
                        alt_width[i] = 7.46
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 19771.2
                        alt_width[i] = 4.48
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 19776.2
                        alt_width[i] = 4.49
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 19940.3
                        alt_width[i] = 15.2
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 19961.5
                        alt_width[i] = 6.34
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 19967.16
                        alt_width[i] = 6.43
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 19995.0
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 19998.4
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 2866.0
                    width[i] = 3.8
                    rec_width[i] = 3.8
                    PE_alt[i] = 2865.75
                    alt_width[i] = 4.727
                    width_range[i] = 1.4 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 2360.9
                        alt_width[i] = 14.63
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 2455.64
                        alt_width[i] = 7.42
                        width_range[i] = 1.64
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 2473.03
                        alt_width[i] = 7.56
                        width_range[i] = 1.66
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 2633.7
                        alt_width[i] = 6.24
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 2637.8
                        alt_width[i] = 6.25
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 2805.3
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 2825.1
                        alt_width[i] = 8.10
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 2832.2
                        alt_width[i] = 8.19
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 2865.8
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 2864.87
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 2625.0
                    width[i] = 1.82
                    rec_width[i] = 1.83
                    PE_alt[i] = 2625.05
                    alt_width[i] = 1.863
                    width_range[i] = 0.107 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 2120.28
                        alt_width[i] = 10.29
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 2215.7
                        alt_width[i] = 4.72
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 2232.9
                        alt_width[i] = 4.87
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 2394.82
                        alt_width[i] = 1.96
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 2398.63
                        alt_width[i] = 1.91
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 2563.23
                        alt_width[i] = 12.62
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 2585.9
                        alt_width[i] = 3.76
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 2592.98
                        alt_width[i] = 3.85
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 2623.51
                        alt_width[i] = 3.76
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 2625.66
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 2520.0
                    width[i] = 1.6
                    rec_width[i] = 1.69
                    PE_alt[i] = 2520.1
                    alt_width[i] = 1.713
                    width_range[i] = 0.067 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 2015.71
                        alt_width[i] = 10.17
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 2110.8
                        alt_width[i] = 4.6
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 2128.0
                        alt_width[i] = 4.75
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 2289.89
                        alt_width[i] = 1.79
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 2293.20
                        alt_width[i] = 1.83
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 2455.64
                        alt_width[i] = 12.5
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 2480.9
                        alt_width[i] = 3.64
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 2488.06
                        alt_width[i] = 3.73
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 2521.63
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 2518.5
                        alt_width[i] = 5.3
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 506.3
                    rec_width[i] = 6.3
                    PE_alt[i] = 504.8
                    alt_width[i] = 7.267
                    width_range[i] = 1.0 #GUESS
                    if transitionLine[i] == 'M1N2':
                        PE_alt[i] = 470.0
                        alt_width[i] = 10.47
                    elif transitionLine[i] == 'M1N3':
                        PE_alt[i] = 470.
                        alt_width[i] = 2.06
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 411.6
                    rec_width[i] = 2.1
                    PE_alt[i] = 409.85
                    alt_width[i] = 2.577
                    width_range[i] = 0.477 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 179.8
                        alt_width[i] = 3.05
                    elif transitionLine[i] == 'M2N1':
                        PE_alt[i] = 351.0
                        alt_width[i] = 13.77
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 394.0
                    rec_width[i] = 2.1
                    PE_alt[i] = 392.65
                    alt_width[i] = 2.627
                    width_range[i] = 0.6 #GUESS
                    if transitionLine[i] == 'M3M5':
                        PE_alt[i] = 165.6
                        alt_width[i] = 3.6
                    elif transitionLine[i] == 'M3N1':
                        PE_alt[i] = 331.75
                        alt_width[i] = 13.92
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 384.63
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 384.86
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 231.1
                    rec_width[i] = 0.22
                    PE_alt[i] = 230.15
                    alt_width[i] = 0.143
                    width_range[i] = 0.077 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 195.38
                        alt_width[i] = 2.08
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 197.99
                        alt_width[i] = 2.18
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 226.2
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 227.9
                    rec_width[i] = 0.12
                    PE_alt[i] = 227.0
                    alt_width[i] = 0.113
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 194.54
                        alt_width[i] = 2.18
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 63.2
                    rec_width[i] = 3.2
                    PE_alt[i] = 61.9
                    alt_width[i] = 7.04
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 37.6
                    rec_width[i] = 2.2
                    PE_alt[i] = 34.033
                    alt_width[i] = 1.723
                    width_range[i] = 0.723 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 35.5
                    rec_width[i] = 1.6
                    PE_alt[i] = 34.03
                    alt_width[i] = 1.553
                    width_range[i] = 0.6 #GUESS
                else:
                    PE_lit[i] = 20000.0


            elif element[i]== 'Tc':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 21044.0
                    rec_width[i] = 4.91
                    PE_alt[i] = 21044.0
                    alt_width[i] = 4.857
                    width_range[i] = 0.107 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 18003.8
                        alt_width[i] = 11.13
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 18250.95
                        alt_width[i] = 6.72
                        width_range[i] = 0.16
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 18368.0
                        alt_width[i] = 6.65
                        width_range[i] = 0.15
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 20501.2
                        alt_width[i] = 13.8
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 20607.0
                        alt_width[i] = 7.82
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 20619.0
                        alt_width[i] = 7.98
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 20787.8
                        alt_width[i] = 4.89
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 20792.02
                        alt_width[i] = 4.89
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 20977.3
                        alt_width[i] = 18.39
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 20999.2
                        alt_width[i] = 8.07
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 21006.03
                        alt_width[i] = 8.24
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 21042.72
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 21043.05
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 3043.0
                    rec_width[i] = 3.8
                    PE_alt[i] = 3042.75
                    alt_width[i] = 4.847
                    width_range[i] = 1.53 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 2497.4
                        alt_width[i] = 13.79
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 2595.6
                        alt_width[i] = 7.82
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 2614.9
                        alt_width[i] = 7.97
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 2784.0
                        alt_width[i] = 4.88
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 2788.2
                        alt_width[i] = 4.88
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 2973.4
                        alt_width[i] = 18.38
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 2995.4
                        alt_width[i] = 8.07
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 3002.2
                        alt_width[i] = 8.24
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 3038.9
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 3039.2
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 2793.0
                    rec_width[i] = 1.93
                    PE_alt[i] = 2793.1
                    alt_width[i] = 1.967
                    width_range[i] = 0.113 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 2249.9
                        alt_width[i] = 10.94
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 2348.2
                        alt_width[i] = 4.96
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 2367.5
                        alt_width[i] = 5.12
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 2536.83
                        alt_width[i] = 2.03
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 2540.75
                        alt_width[i] = 2.03
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 2726.0
                        alt_width[i] = 15.53
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 2747.9
                        alt_width[i] = 5.21
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 2754.75
                        alt_width[i] = 5.39
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 2791.44
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 2791.77
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 2677.0
                    rec_width[i] = 1.78
                    PE_alt[i] = 2676.95
                    alt_width[i] = 1.817
                    width_range[i] = 0.093 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 2133.6
                        alt_width[i] = 10.81
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 2231.9
                        alt_width[i] = 4.83
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 2251.2
                        alt_width[i] = 4.99
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 2420.24
                        alt_width[i] = 1.9
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 2423.99
                        alt_width[i] = 1.9
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 2609.7
                        alt_width[i] = 15.4
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 2631.7
                        alt_width[i] = 5.09
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 2638.46
                        alt_width[i] = 5.26
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 2675.15
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 2675.49
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 544.0
                    rec_width[i] = 6.7
                    PE_alt[i] = 544.0
                    alt_width[i] = 7.875
                    width_range[i] = 1.175 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 447.6
                    rec_width[i] = 2.15
                    PE_alt[i] = 444.95
                    alt_width[i] = 2.615
                    width_range[i] = 0.465 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 417.7
                    rec_width[i] = 2.15
                    PE_alt[i] = 425.0
                    alt_width[i] = 2.69
                    width_range[i] = 0.54 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 416.88
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 417.17
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 257.6
                    rec_width[i] = 0.5
                    PE_alt[i] = 256.7
                    alt_width[i] = 0.32
                    width_range[i] = 0.18 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 217.41
                        alt_width[i] = 3.46
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 220.46
                        alt_width[i] = 3.63
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 253.9
                    rec_width[i] = 0.14
                    PE_alt[i] = 252.95
                    alt_width[i] = 0.14
                    width_range[i] = 0.01 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 216.52
                        alt_width[i] = 3.64
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 69.5
                    rec_width[i] = 3.5
                    PE_alt[i] = 68.4
                    alt_width[i] = 8.57
                    width_range[i] = 5.07 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 42.3
                    rec_width[i] = 2.7
                    PE_alt[i] = 40.23
                    alt_width[i] = 3.015
                    width_range[i] = 0.315 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 39.9
                    rec_width[i] = 2.2
                    PE_alt[i] = 37.95
                    alt_width[i] = 2.85
                    width_range[i] = 0.65 #GUESS
                else:
                    PE_lit[i] = 21044.0

            elif element[i]== 'Ru':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 22117.0
                    rec_width[i] = 5.33
                    PE_alt[i] = 22117.1
                    alt_width[i] = 5.27
                    width_range[i] = 0.12 #GUESS 
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 18895.0
                        alt_width[i] = 11.67
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 19151.9
                        alt_width[i] = 7.55
                        width_range[i] = 0.42
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 19279.2
                        alt_width[i] = 7.25
                        width_range[i] = 0.25
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 21533.3
                        alt_width[i] = 14.71
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 21634.8
                        alt_width[i] = 8.36
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 21656.9
                        alt_width[i] = 8.54
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 21828.45
                        alt_width[i] = 5.32
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 21833.3
                        alt_width[i] = 5.33
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 22046.6
                        alt_width[i] = 21.64
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 22071.1
                        alt_width[i] = 10.27
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 22077.45
                        alt_width[i] = 10.58
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 22117.3
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 22117.91   
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 3224.0
                    width[i] = 3.8
                    rec_width[i] = 3.9
                    PE_alt[i] = 3224.0
                    alt_width[i] = 4.997
                    width_range[i] = 1.513 #GUESS   
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 2638.1
                        alt_width[i] = 16.07
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 2741.13
                        alt_width[i] = 7.84
                        width_range[i] = 1.3
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 2763.35
                        alt_width[i] = 8.13
                        width_range[i] = 1.5
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 2938.7
                        alt_width[i] = 6.68
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 2943.6
                        alt_width[i] = 6.68
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 3151.6
                        alt_width[i] = 23.0
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 3176.1
                        alt_width[i] = 11.63
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 3182.91
                        alt_width[i] = 11.93
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 3222.3
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 3222.9 
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 2967.0
                    width[i] = 1.97
                    rec_width[i] = 2.03
                    PE_alt[i] = 2966.95
                    alt_width[i] = 2.083
                    width_range[i] = 0.147 #GUESS   
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 2381.95
                        alt_width[i] = 11.55
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 2485.1
                        alt_width[i] = 5.2
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 2506.8
                        alt_width[i] = 5.37
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 2683.28
                        alt_width[i] = 2.17
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 2687.9
                        alt_width[i] = 2.16
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 2891.83
                        alt_width[i] = 18.48
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 2920.5
                        alt_width[i] = 7.11
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 2926.8
                        alt_width[i] = 7.41
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 2964.51
                        alt_width[i] = 4.15
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 2967.25 
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 2838.0
                    width[i] = 1.58
                    rec_width[i] = 1.87
                    PE_alt[i] = 2837.95
                    alt_width[i] = 1.907
                    width_range[i] = 0.93 #GUESS  
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 2252.75
                        alt_width[i] = 11.4
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 2356.2
                        alt_width[i] = 4.96
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 2377.9
                        alt_width[i] = 5.13
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 2554.35
                        alt_width[i] = 2.0
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 2558.59
                        alt_width[i] = 2.03
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 2763.35
                        alt_width[i] = 18.34
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 2791.6
                        alt_width[i] = 6.87
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 2797.95
                        alt_width[i] = 7.17
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 2837.79
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 2838.4  
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 586.1
                    rec_width[i] = 7.2
                    PE_alt[i] = 585.0
                    alt_width[i] = 8.217
                    width_range[i] = 1.4 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 483.5
                    rec_width[i] = 2.2
                    PE_alt[i] = 482.9
                    alt_width[i] = 2.773
                    width_range[i] = 0.573 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 199.2
                        alt_width[i] = 3.05
                    elif transitionLine[i] == 'M2N1':
                        PE_alt[i] = 384.0
                        alt_width[i] = 19.7 
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 486.1
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 461.4
                    rec_width[i] = 2.2
                    PE_alt[i] = 460.8
                    alt_width[i] = 2.857
                    width_range[i] = 0.7 #GUESS
                    if transitionLine[i] == 'M3M5':
                        PE_alt[i] = 181.4
                        alt_width[i] = 3.56
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 461.8
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 462.0
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 284.2
                    rec_width[i] = 0.59
                    PE_alt[i] = 283.8
                    alt_width[i] = 0.333
                    width_range[i] = 0.257 #GUESS  
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 240.34
                        alt_width[i] = 5.29
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 243.87
                        alt_width[i] = 5.59 
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 276.8  
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 280.0
                    rec_width[i] = 0.17
                    PE_alt[i] = 279.2
                    alt_width[i] = 0.187
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 239.39
                        alt_width[i] = 5.6
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 75.0
                    rec_width[i] = 3.9
                    PE_alt[i] = 74.95
                    alt_width[i] = 9.263
                    width_range[i] = 7.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 46.3
                    rec_width[i] = 3.2
                    PE_alt[i] = 44.37
                    alt_width[i] = 4.04
                    width_range[i] = 1.08 #GUESS     
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 43.2
                    rec_width[i] = 2.8
                    PE_alt[i] = 42.43
                    alt_width[i] = 4.007
                    width_range[i] = 1.9 #GUESS  
                elif photoelectronLine[i] == 'N4':
                    PE_alt[i] = 2.13  
                elif photoelectronLine[i] == 'N5':
                    PE_alt[i] = 1.93         
                else:
                    PE_lit[i] = 22117.0


            elif element[i]== 'Rh':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 23220.0
                    rec_width[i] = 5.77
                    PE_alt[i] = 23219.95
                    alt_width[i] = 5.71
                    width_range[i] = 0.12 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 19809.3
                        alt_width[i] = 12.2
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 20073.85
                        alt_width[i] = 8.33
                        width_range[i] = 0.65
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 20216.06
                        alt_width[i] = 8.31
                        width_range[i] = 0.9
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 22586.0
                        alt_width[i] = 15.45
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 22698.9
                        alt_width[i] = 8.94
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 22723.8
                        alt_width[i] = 9.13
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 22908.8
                        alt_width[i] = 5.8
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 22916.4
                        alt_width[i] = 5.8
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 23142.4
                        alt_width[i] = 24.8
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 23169.2
                        alt_width[i] = 13.0
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 23175.6
                        alt_width[i] = 13.49
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 23212.0
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 23216.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 3412.0
                    width[i] = 4.0
                    rec_width[i] = 4.0
                    PE_alt[i] = 3411.95
                    alt_width[i] = 5.113
                    width_range[i] = 1.497 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 2776.6
                        alt_width[i] = 16.47
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 2890.82
                        alt_width[i] = 9.96
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 2915.66
                        alt_width[i] = 10.15
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 3098.5
                        alt_width[i] = 6.82
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 3103.7
                        alt_width[i] = 6.82
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 3333.0
                        alt_width[i] = 25.82
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 3360.5
                        alt_width[i] = 14.02
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 3366.3
                        alt_width[i] = 14.51
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 3409.4
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 3410.1 
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 3146.0
                    width[i] = 2.04
                    rec_width[i] = 2.13
                    PE_alt[i] = 3146.05
                    alt_width[i] = 2.19
                    width_range[i] = 0.16 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 2519.05
                        alt_width[i] = 11.96
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 2626.3
                        alt_width[i] = 5.45
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 2650.6
                        alt_width[i] = 5.64
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 2834.42
                        alt_width[i] = 2.3
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 2839.56
                        alt_width[i] = 2.31
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 3065.05
                        alt_width[i] = 21.3
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 3096.4
                        alt_width[i] = 9.51
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 3102.1
                        alt_width[i] = 10.0
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 3143.81
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 3145.99
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 3004.0
                    width[i] = 1.88
                    rec_width[i] = 1.96
                    PE_alt[i] = 3003.9
                    alt_width[i] = 2.01
                    width_range[i] = 0.12 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 2376.53
                        alt_width[i] = 11.8
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 2484.1
                        alt_width[i] = 5.44
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 2508.4
                        alt_width[i] = 5.47
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 2692.0
                        alt_width[i] = 2.15
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 2696.74
                        alt_width[i] = 2.15
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 2922.92
                        alt_width[i] = 21.15
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 2954.1
                        alt_width[i] = 9.34
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 2959.86
                        alt_width[i] = 9.83
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 3002.94
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 3003.73 
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 628.1
                    rec_width[i] = 7.6
                    PE_alt[i] = 627.05
                    alt_width[i] = 8.73
                    width_range[i] = 1.2 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 521.3
                    rec_width[i] = 2.25
                    PE_alt[i] = 521.0
                    alt_width[i] = 2.8
                    width_range[i] = 0.55 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 209.0
                        alt_width[i] = 3.56
                    elif transitionLine[i] == 'M2N1':
                        PE_alt[i] = 442.8
                        alt_width[i] = 22.56
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 496.5
                    rec_width[i] = 2.25
                    PE_alt[i] = 496.1
                    alt_width[i] = 2.895
                    width_range[i] = 0.7 #GUESS
                    if transitionLine[i] == 'M3M4':
                        PE_alt[i] = 189.2
                        alt_width[i] = 3.75
                    elif transitionLine[i] == 'M3N1':
                        PE_alt[i] = 416.6
                        alt_width[i] = 22.75
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 495.95
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 495.95
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 311.9
                    rec_width[i] = 0.61
                    PE_alt[i] = 311.85
                    alt_width[i] = 0.41
                    width_range[i] = 0.2 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 260.1
                        alt_width[i] = 7.62
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 260.1
                        alt_width[i] = 8.11
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 303.0
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 307.2
                    rec_width[i] = 0.21
                    PE_alt[i] = 307.0
                    alt_width[i] = 0.21
                    width_range[i] = 0.2 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 260.1
                        alt_width[i] = 8.12
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 81.4
                    rec_width[i] = 4.2
                    PE_alt[i] = 81.0
                    alt_width[i] = 11.705
                    width_range[i] = 7.5 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 50.5
                    rec_width[i] = 4.2
                    PE_alt[i] = 49.27
                    alt_width[i] = 5.671
                    width_range[i] = 1.471 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 47.3
                    rec_width[i] = 3.8
                    PE_alt[i] = 47.4
                    alt_width[i] = 5.85
                    width_range[i] = 2.1 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_alt[i] = 2.77 
                elif photoelectronLine[i] == 'N5':
                    PE_alt[i] = 2.57  
                else:
                    PE_lit[i] = 23220.0


            elif element[i]== 'Pd':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 24350.0
                    rec_width[i] = 6.25
                    PE_alt[i] = 24350.15
                    alt_width[i] = 6.18
                    width_range[i] = 0.13 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 20747.8
                        alt_width[i] = 12.32
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 21020.08
                        alt_width[i] = 8.71
                        width_range[i] = 0.5
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 21177.04
                        alt_width[i] = 8.46
                        width_range[i] = 0.4
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 23681.7
                        alt_width[i] = 16.51
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 23791.4
                        alt_width[i] = 9.53
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 23818.9
                        alt_width[i] = 9.74
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 24011.0
                        alt_width[i] = 6.32
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 24016.22
                        alt_width[i] = 6.32
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 24267.0
                        alt_width[i] = 27.84
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 24297.2
                        alt_width[i] = 17.34
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 24302.2
                        alt_width[i] = 18.05
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 24348.74
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 24349.18
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 3604.0
                    width[i] = 3.9
                    rec_width[i] = 3.9
                    PE_alt[i] = 3604.65
                    alt_width[i] = 5.03
                    width_range[i] = 1.23 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 2934.0
                        alt_width[i] = 8.18
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 3045.45
                        alt_width[i] = 7.96
                        width_range[i] = 1.78
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 3073.4
                        alt_width[i] = 8.38
                        width_range[i] = 1.58
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 3263.71
                        alt_width[i] = 6.52
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 3269.54
                        alt_width[i] = 6.52
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 3519.3
                        alt_width[i] = 28.05
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 3549.4
                        alt_width[i] = 17.55
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 3554.5
                        alt_width[i] = 18.26
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 3601.0
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 3601.4
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 3330.0
                    width[i] = 2.15
                    rec_width[i] = 2.23
                    PE_alt[i] = 3330.65
                    alt_width[i] = 2.287
                    width_range[i] = 0.143 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 2660.29
                        alt_width[i] = 12.67
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 2771.4
                        alt_width[i] = 5.67
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 2798.9
                        alt_width[i] = 5.89
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 2990.23
                        alt_width[i] = 2.41
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 2995.6
                        alt_width[i] = 2.46
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 3243.67
                        alt_width[i] = 23.99
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 3276.5
                        alt_width[i] = 13.49
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 3281.6
                        alt_width[i] = 14.2
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 3328.72
                        alt_width[i] = 4.5
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 3328.56
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 3173.0
                    width[i] = 1.96
                    rec_width[i] = 2.05
                    PE_alt[i] = 3137.15
                    alt_width[i] = 2.11
                    width_range[i] = 0.14 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 2503.41
                        alt_width[i] = 12.5
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 2614.8
                        alt_width[i] = 5.51
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 2642.3
                        alt_width[i] = 5.47
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 2833.31
                        alt_width[i] = 2.23
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 2837.62
                        alt_width[i] = 2.15
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 3087.2
                        alt_width[i] = 23.82
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 3119.9
                        alt_width[i] = 13.33
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 3125.0
                        alt_width[i] = 14.04
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 3171.65
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 3171.87 
                        alt_width[i] = 5.63
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 671.6
                    width[i] = 7.5
                    rec_width[i] = 8.0
                    PE_alt[i] = 669.95
                    alt_width[i] = 9.153
                    width_range[i] = 2.2 #GUESS
                    if transitionLine[i] == 'M1N2':
                        PE_alt[i] = 616.0
                        alt_width[i] = 21.75
                    elif transitionLine[i] == 'M1N3':
                        PE_alt[i] = 617.0
                        alt_width[i] = 22.46
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 559.9
                    rec_width[i] = 2.35
                    PE_alt[i] = 559.05
                    alt_width[i] = 3.173
                    width_range[i] = 0.823 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 219.4
                        alt_width[i] = 3.74
                    elif transitionLine[i] == 'M2N1':
                        PE_alt[i] = 473.5
                        alt_width[i] = 25.26
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 560.5
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 532.3
                    rec_width[i] = 2.35
                    PE_alt[i] = 531.25
                    alt_width[i] = 3.247
                    width_range[i] = 1.0 #GUESS
                    if transitionLine[i] == 'M3M5':
                        PE_alt[i] = 197.0
                        alt_width[i] = 3.95
                    elif transitionLine[i] == 'M3N1':
                        PE_alt[i] = 445.5
                        alt_width[i] = 25.47
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 531.0
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 531.0
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 340.5
                    rec_width[i] = 0.26
                    PE_alt[i] = 340.0
                    alt_width[i] = 0.307
                    width_range[i] = 0.093 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 284.4
                        alt_width[i] = 11.55
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 284.4
                        alt_width[i] = 12.26
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 332.0
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 335.2
                    rec_width[i] = 0.26
                    PE_alt[i] = 334.85
                    alt_width[i] = 0.307
                    width_range[i] = 0.2 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 284.4
                        alt_width[i] = 12.26
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 87.1
                    rec_width[i] = 4.35
                    PE_alt[i] = 86.2
                    alt_width[i] = 11.113
                    width_range[i] = 7.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 55.7
                    rec_width[i] = 6.4
                    PE_alt[i] = 52.17
                    alt_width[i] = 9.23
                    width_range[i] = 2.83 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 50.9
                    rec_width[i] = 5.6
                    PE_alt[i] = 50.7
                    alt_width[i] = 9.2
                    width_range[i] = 3.4 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_alt[i] = 1.4
                elif photoelectronLine[i] == 'N5':
                    PE_alt[i] = 1.27
                else:
                    PE_lit[i] = 24350.0


            elif element[i]== 'Ag':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 25514.0
                    width[i] = 6.45
                    rec_width[i] = 6.76
                    PE_alt[i] = 25514.0
                    alt_width[i] = 6.69
                    width_range[i] = 0.13 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 21709.4
                        alt_width[i] = 12.0
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 21990.6
                        alt_width[i] = 9.83
                        width_range[i] = 1.47
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 22163.0
                        alt_width[i] = 9.65
                        width_range[i] = 1.45
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 24797.4
                        alt_width[i] = 17.67
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 24911.7
                        alt_width[i] = 10.2
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 24942.55
                        alt_width[i] = 10.43
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 25141.5
                        alt_width[i] = 6.86
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 25147.6
                        alt_width[i] = 6.86
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 25421.1
                        alt_width[i] = 30.48
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 25455.6
                        alt_width[i] = 20.31
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 25457.8
                        alt_width[i] = 21.26
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 25500.0
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 25510.83
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 3806.0
                    width[i] = 3.8
                    rec_width[i] = 3.8
                    PE_alt[i] = 3805.9
                    alt_width[i] = 4.693
                    width_range[i] = 0.893 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 3088.0
                        alt_width[i] = 16.52
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 3203.4
                        alt_width[i] = 7.47
                        width_range[i] = 1.57
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 3234.4
                        alt_width[i] = 7.94
                        width_range[i] = 1.34
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 3432.88
                        alt_width[i] = 5.7
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 3439.1
                        alt_width[i] = 5.71
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 3711.7
                        alt_width[i] = 29.33
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 3743.25
                        alt_width[i] = 15.08
                        width_range[i] = 4.08
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 3749.82
                        alt_width[i] = 15.16
                        width_range[i] = 4.96
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 3800.6
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 3801.4
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 3524.0
                    width[i] = 2.24
                    rec_width[i] = 2.32
                    PE_alt[i] = 3523.85
                    alt_width[i] = 2.397
                    width_range[i] = 0.173 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 2806.1
                        alt_width[i] = 13.43
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 2922.1
                        alt_width[i] = 5.95
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 2952.4
                        alt_width[i] = 6.18
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 3151.0
                        alt_width[i] = 2.5
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 3156.9
                        alt_width[i] = 2.62
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 3428.28
                        alt_width[i] = 26.23
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 3465.0
                        alt_width[i] = 16.07
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 3467.1
                        alt_width[i] = 17.02
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 3570.0
                        alt_width[i] = 3.95
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 3520.17
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 3351.0
                    width[i] = 2.05
                    rec_width[i] = 2.15
                    PE_alt[i] = 3351.05
                    alt_width[i] = 2.223
                    width_range[i] = 0.177 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 2633.63
                        alt_width[i] = 13.25
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 2749.8
                        alt_width[i] = 5.76
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 2780.1
                        alt_width[i] = 5.99
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 2978.27
                        alt_width[i] = 2.42
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 2984.32
                        alt_width[i] = 2.7
                        width_range[i] = 0.7
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 3255.95
                        alt_width[i] = 26.05
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 3292.7
                        alt_width[i] = 15.88
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 3294.8
                        alt_width[i] = 16.83
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 3347.4
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 3347.82 
                        alt_width[i] = 3.72
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 719.0
                    width[i] = 8.6
                    rec_width[i] = 8.4
                    PE_alt[i] = 717.25
                    alt_width[i] = 9.713
                    width_range[i] = 1.4 #GUESS
                    if transitionLine[i] == 'M1N2':
                        PE_alt[i] = 658.0
                        alt_width[i] = 24.88
                    elif transitionLine[i] == 'M1N3':
                        PE_alt[i] = 659.5
                        alt_width[i] = 25.83
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 603.8
                    rec_width[i] = 2.45
                    PE_alt[i] = 602.2
                    alt_width[i] = 3.277
                    width_range[i] = 0.827 #GUESS
                    if transitionLine[i] == 'M2M4':
                        PE_alt[i] = 229.5
                        alt_width[i] = 3.95
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 600.2
                        alt_width[i] = 7.5
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 573.0
                    rec_width[i] = 2.55
                    PE_alt[i] = 571.2
                    alt_width[i] = 3.437
                    width_range[i] = 1.0 #GUESS
                    if transitionLine[i] == 'M3M5':
                        PE_alt[i] = 204.8
                        alt_width[i] = 4.18
                    elif transitionLine[i] == 'M3N1':
                        PE_alt[i] = 477.9
                        alt_width[i] = 27.8
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 568.0
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 568.7
                        alt_width[i] = 8.6
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 374.0
                    rec_width[i] = 0.3
                    PE_alt[i] = 372.9
                    alt_width[i] = 0.347
                    width_range[i] = 0.093 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 311.7
                        alt_width[i] = 14.06
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 311.7
                        alt_width[i] = 15.01
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 370.0
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 368.3
                    rec_width[i] = 0.31
                    PE_alt[i] = 366.85
                    alt_width[i] = 0.31
                    width_range[i] = 0.04 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 370.0
                        alt_width[i] = 15.01
                    elif transitionLine[i] == 'M5N1':
                        PE_alt[i] = 509.0
                        alt_width[i] = 24.23
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 97.0
                    rec_width[i] = 4.4
                    PE_alt[i] = 95.1
                    alt_width[i] = 14.165
                    width_range[i] = 10.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 63.7
                    rec_width[i] = 8.4
                    PE_alt[i] = 62.3
                    alt_width[i] = 11.08
                    width_range[i] = 2.68 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 58.3
                    rec_width[i] = 8.0
                    PE_alt[i] = 55.95
                    alt_width[i] = 11.355
                    width_range[i] = 3.355 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_alt[i] = 3.3
                elif photoelectronLine[i] == 'N5':
                    PE_alt[i] = 3.13
                else:
                    PE_lit[i] = 25514.0


            elif element[i]== 'Cd':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 26711.0
                    rec_width[i] = 7.32
                    PE_alt[i] = 26711.1
                    alt_width[i] = 7.23
                    width_range[i] = 0.14 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 22694.5
                        alt_width[i] = 11.37
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 22984.02
                        alt_width[i] = 9.93
                        width_range[i] = 10.47
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 23174.0
                        alt_width[i] = 9.63
                        width_range[i] = 0.33
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 25941.6
                        alt_width[i] = 18.8
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 26061.6
                        alt_width[i] = 10.93
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 26095.8
                        alt_width[i] = 11.17
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 26301.2
                        alt_width[i] = 7.43
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 26307.8
                        alt_width[i] = 7.44
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 26604.9
                        alt_width[i] = 32.43
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 26644.1
                        alt_width[i] = 23.56
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 26643.5
                        alt_width[i] = 24.83
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 26701.15
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 26702.5
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 4018.0
                    width[i] = 3.25
                    rec_width[i] = 3.5
                    PE_alt[i] = 4018.0
                    alt_width[i] = 4.217
                    width_range[i] = 0.717 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 3247.1
                        alt_width[i] = 15.99
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 3367.35
                        alt_width[i] = 7.2
                        width_range[i] = 0.92
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 3401.55
                        alt_width[i] = 7.79
                        width_range[i] = 0.56
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 3607.55
                        alt_width[i] = 4.62
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 3614.4
                        alt_width[i] = 4.63
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 3910.4
                        alt_width[i] = 29.62
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 3951.38
                        alt_width[i] = 20.75
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 3949.0
                        alt_width[i] = 22.01
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 4006.6
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 4008.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 3727.0
                    width[i] = 2.38
                    rec_width[i] = 2.42
                    PE_alt[i] = 3727.0
                    alt_width[i] = 2.48
                    width_range[i] = 0.14 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 2956.8
                        alt_width[i] = 14.12
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 3076.9
                        alt_width[i] = 6.23
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 3110.6
                        alt_width[i] = 6.47
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 3316.63
                        alt_width[i] = 2.65
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 3323.3
                        alt_width[i] = 2.74
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 3619.33
                        alt_width[i] = 27.74
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 3659.6
                        alt_width[i] = 18.87
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 3659.0
                        alt_width[i] = 20.13
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 3716.8
                        alt_width[i] = 4.38
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 3718.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 3538.0
                    width[i] = 2.51
                    rec_width[i] = 2.24
                    PE_alt[i] = 3537.75
                    alt_width[i] = 2.317
                    width_range[i] = 0.183 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 2767.34
                        alt_width[i] = 13.93
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 2887.7
                        alt_width[i] = 6.04
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 2921.4
                        alt_width[i] = 6.28
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 3126.92
                        alt_width[i] = 2.48
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 3133.78
                        alt_width[i] = 2.51
                        width_range[i] = 0.8
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 3430.0
                        alt_width[i] = 27.55
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 3470.4
                        alt_width[i] = 18.68
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 3469.7
                        alt_width[i] = 19.94
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 3527.42
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 3528.1
                        alt_width[i] = 5.82
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 772.0
                    width[i] = 9.2
                    rec_width[i] = 8.8
                    PE_alt[i] = 770.1
                    alt_width[i] = 10.17
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 652.6
                    rec_width[i] = 2.55
                    PE_alt[i] = 650.85
                    alt_width[i] = 3.36
                    width_range[i] = 0.81 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 540.8
                        alt_width[i] = 29.18
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 238.4
                    elif transitionLine[i] == 'M2N5':
                        PE_alt[i] = 639.0
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 618.4
                    rec_width[i] = 2.8
                    PE_alt[i] = 616.75
                    alt_width[i] = 3.523
                    width_range[i] = 0.6 #GUESS
                    if transitionLine[i] == 'M3M5':
                        PE_alt[i] = 211.1
                        alt_width[i] = 4.42
                    elif transitionLine[i] == 'M3N1':
                        PE_alt[i] = 507.25
                        alt_width[i] = 29.42
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 606.0
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 606.0
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 411.9
                    rec_width[i] = 0.34
                    PE_alt[i] = 410.75
                    alt_width[i] = 0.387
                    width_range[i] = 0.093 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 341.84
                        alt_width[i] = 16.81
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 347.87
                        alt_width[i] = 18.08
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 408.5
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 405.2
                    rec_width[i] = 0.35
                    PE_alt[i] = 403.85
                    alt_width[i] = 0.393
                    width_range[i] = 0.08 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 340.67
                        alt_width[i] = 18.08
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 109.8
                    width[i] = 4.2
                    rec_width[i] = 4.4
                    PE_alt[i] = 107.8
                    alt_width[i] = 11.91
                    width_range[i] = 8.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 63.9
                    rec_width[i] = 10.8
                    PE_alt[i] = 66.95
                    alt_width[i] = 13.757
                    width_range[i] = 2.957 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 63.9
                    rec_width[i] = 10.5
                    PE_alt[i] = 66.3
                    alt_width[i] = 14.077
                    width_range[i] = 3.7 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 11.7
                    PE_alt[i] = 9.33
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 10.7
                    PE_alt[i] = 9.1
                    alt_width[i] = 0.01 #GUESS
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_alt[i] = 2.20
                else:
                    PE_lit[i] = 26711.0


            elif element[i]== 'In':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 27940.0
                    rec_width[i] = 7.9
                    PE_alt[i] = 27939.95
                    alt_width[i] = 7.827
                    width_range[i] = 0.157 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 23703.5
                        alt_width[i] = 10.56
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 24002.0
                        alt_width[i] = 10.4
                        width_range[i] = 0.25
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 24209.9
                        alt_width[i] = 10.25
                        width_range[i] = 0.25
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 27114.4
                        alt_width[i] = 19.49
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 2737.75
                        alt_width[i] = 11.69
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 27275.75
                        alt_width[i] = 11.97
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 27491.4
                        alt_width[i] = 8.05
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 27499.05
                        alt_width[i] = 8.06
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 27819.7
                        alt_width[i] = 33.85
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 27860.2
                        alt_width[i] = 26.9
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 27860.9
                        alt_width[i] = 29.13
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 27910.0
                        alt_width[i] = 7.7
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 27926.0
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 27940.0
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 27940.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 4238.0
                    width[i] = 3.25
                    rec_width[i] = 3.0
                    PE_alt[i] = 4237.75
                    alt_width[i] = 3.63
                    width_range[i] = 1.37 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 3410.9
                        alt_width[i] = 14.66
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 3535.3
                        alt_width[i] = 6.92
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 3573.3
                        alt_width[i] = 7.2
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 3786.9
                        alt_width[i] = 3.28
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 3794.4
                        alt_width[i] = 3.28
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 4116.2
                        alt_width[i] = 29.08
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 4157.2
                        alt_width[i] = 22.12
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 4157.4
                        alt_width[i] = 24.35
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 4219.5
                        alt_width[i] = 2.93
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 4220.6
                        alt_width[i] = 2.91
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 3938.0
                    width[i] = 2.59
                    rec_width[i] = 2.53
                    PE_alt[i] = 3730.05
                    alt_width[i] = 2.583
                    width_range[i] = 0.137 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 3112.59
                        alt_width[i] = 14.27
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 3236.3
                        alt_width[i] = 6.53
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 3273.8
                        alt_width[i] = 6.81
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 3487.4
                        alt_width[i] = 2.89
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 3494.8
                        alt_width[i] = 2.9
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 3816.0
                        alt_width[i] = 28.69
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 3858.4
                        alt_width[i] = 21.74
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 3858.6
                        alt_width[i] = 23.97
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 3920.82
                        alt_width[i] = 2.54
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 3921.84
                        alt_width[i] = 2.53
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 3730.0
                    width[i] = 2.43
                    rec_width[i] = 2.34
                    PE_alt[i] = 3730.05
                    alt_width[i] = 2.43
                    width_range[i] = 0.22 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 2904.4
                        alt_width[i] = 14.07
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 3028.9
                        alt_width[i] = 6.29
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 3066.4
                        alt_width[i] = 6.57
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 3279.3
                        alt_width[i] = 2.69
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 3287.0
                        alt_width[i] = 2.7
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 3608.3
                        alt_width[i] = 28.49
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 3651.0
                        alt_width[i] = 21.5
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 3651.1
                        alt_width[i] = 23.73
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 3713.5
                        alt_width[i] = 2.34
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 3714.33
                        alt_width[i] = 2.32
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 3730.0
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 827.2
                    width[i] = 8.8
                    rec_width[i] = 9.2
                    PE_alt[i] = 825.8
                    alt_width[i] = 10.485
                    width_range[i] = 1.3 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 703.2
                    rec_width[i] = 2.7
                    PE_alt[i] = 702.1
                    alt_width[i] = 3.365
                    width_range[i] = 0.665 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 665.3
                    rec_width[i] = 3.05
                    PE_alt[i] = 664.15
                    alt_width[i] = 3.68
                    width_range[i] = 0.7 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 635.18
                        alt_width[i] = 4.34
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 636.09
                        alt_width[i] = 4.32
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 451.4
                    rec_width[i] = 0.38
                    PE_alt[i] = 450.9
                    alt_width[i] = 0.385
                    width_range[i] = 0.005 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 370.27
                        alt_width[i] = 19.62
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 377.17
                        alt_width[i] = 21.85
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 456.13
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 443.9
                    rec_width[i] = 0.39
                    PE_alt[i] = 443.05
                    alt_width[i] = 0.39
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 369.13
                        alt_width[i] = 21.85
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 122.9
                    width[i] = 4.2
                    rec_width[i] = 4.2
                    PE_alt[i] = 121.95
                    alt_width[i] = 15.195
                    width_range[i] = 11.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 73.5
                    rec_width[i] = 13.2
                    PE_alt[i] = 78.77
                    alt_width[i] = 16.215
                    width_range[i] = 3.015 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 73.5
                    rec_width[i] = 14.0
                    PE_alt[i] = 76.5
                    alt_width[i] = 17.73
                    width_range[i] = 4.6 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 17.7
                    PE_alt[i] = 16.93
                    alt_width[i] = 0.04
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 16.9
                    PE_alt[i] = 15.9
                    alt_width[i] = 0.02
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_alt[i] = 4.1
                elif photoelectronLine[i] == 'O2':
                    PE_alt[i] = 0.75
                else:
                    PE_lit[i] = 27940.0


            elif element[i]== 'Sn':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 29200.0
                    rec_width[i] = 8.53
                    PE_alt[i] = 29200.05
                    alt_width[i] = 8.433
                    width_range[i] = 0.153 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 24736.6
                        alt_width[i] = 10.68
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 25044.02
                        alt_width[i] = 11.53
                        width_range[i] = 0.9
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 25271.7
                        alt_width[i] = 11.03
                        width_range[i] = 0.35
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 28316.1
                        alt_width[i] = 20.61
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 28444.6
                        alt_width[i] = 11.75
                        width_range[i] = 0.75
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 28486.55
                        alt_width[i] = 12.3
                        width_range[i] = 0.5
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 28709.5
                        alt_width[i] = 8.71
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 28715.6
                        alt_width[i] = 8.72
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 29064.2
                        alt_width[i] = 33.77
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 29096.05
                        alt_width[i] = 29.94
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 29109.2
                        alt_width[i] = 33.90
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 29175.4
                        alt_width[i] = 8.36
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 29176.3
                        alt_width[i] = 8.36
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 29195.0
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 29195.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 4465.0
                    width[i] = 2.4
                    rec_width[i] = 2.4
                    PE_alt[i] = 4464.85
                    alt_width[i] = 2.797
                    width_range[i] = 0.223 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 3579.5
                        alt_width[i] = 15.35
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 3708.4
                        alt_width[i] = 6.9
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 3750.5
                        alt_width[i] = 7.65
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 3971.55
                        alt_width[i] = 3.45
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 3979.9
                        alt_width[i] = 3.45
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 4327.6
                        alt_width[i] = 28.51
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 4359.5
                        alt_width[i] = 24.68
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 4372.6
                        alt_width[i] = 28.64
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 4438.8
                        alt_width[i] = 3.1
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 4440.1
                        alt_width[i] = 3.1
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 4156.0
                    width[i] = 2.57
                    rec_width[i] = 2.64
                    PE_alt[i] = 4156.05
                    alt_width[i] = 2.697
                    width_range[i] = 0.143 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 3272.33
                        alt_width[i] = 14.94
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 3400.4
                        alt_width[i] = 6.82
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 3442.1
                        alt_width[i] = 7.16
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 3662.75
                        alt_width[i] = 2.9
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 3671.3
                        alt_width[i] = 3.05
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 4019.1
                        alt_width[i] = 28.09
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 4051.76
                        alt_width[i] = 24.27
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 4064.9
                        alt_width[i] = 28.23
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 4131.13
                        alt_width[i] = 3.95
                        width_range[i] = 1.25
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 4132.4
                        alt_width[i] = 2.69
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 3929.0
                    width[i] = 2.42
                    rec_width[i] = 2.43
                    PE_alt[i] = 3928.9
                    alt_width[i] = 2.537
                    width_range[i] = 0.213 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 3045.0
                        alt_width[i] = 14.73
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 3173.4
                        alt_width[i] = 6.61
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 3215.0
                        alt_width[i] = 6.95
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 3436.4
                        alt_width[i] = 2.71
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 3444.0
                        alt_width[i] = 2.71
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 3792.5
                        alt_width[i] = 27.88
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 3824.71
                        alt_width[i] = 24.06
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 3837.9
                        alt_width[i] = 28.02
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 3904.07
                        alt_width[i] = 2.48
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 3905.1
                        alt_width[i] = 3.93
                        width_range[i] = 2.17
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 3928.2
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 884.7
                    width[i] = 9.6
                    rec_width[i] = 9.6
                    PE_alt[i] = 883.9
                    alt_width[i] = 10.93
                    width_range[i] = 1.5 #GUESS
                    if transitionLine[i] == 'M1P3':
                        PE_alt[i] = 616.8
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 756.5
                    rec_width[i] = 2.85
                    PE_alt[i] = 756.7
                    alt_width[i] = 3.583
                    width_range[i] = 0.733 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 618.85
                        alt_width[i] = 29.7
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 733.2
                        alt_width[i] = 4.29
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 714.6
                    rec_width[i] = 3.3
                    PE_alt[i] = 714.7
                    alt_width[i] = 3.97
                    width_range[i] = 0.7 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 962.6
                        alt_width[i] = 4.63
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 228.7
                        alt_width[i] = 4.29
                    elif transitionLine[i] == 'M3N1':
                        PE_alt[i] = 575.65
                        alt_width[i] = 30.04
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 493.2
                    rec_width[i] = 0.43
                    PE_alt[i] = 493.65
                    alt_width[i] = 0.46
                    width_range[i] = 0.06 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 491.0
                        alt_width[i] = 22.09
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 397.0
                        alt_width[i] = 26.05
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 491.4
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 484.9
                    rec_width[i] = 0.44
                    PE_alt[i] = 484.9
                    alt_width[i] = 0.46
                    width_range[i] = 0.04 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 398.82
                        alt_width[i] = 26.06
                    elif transitionLine[i] == 'M5O3':
                        PE_alt[i] = 483.0
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 137.1
                    width[i] = 3.9
                    rec_width[i] = 3.4
                    PE_alt[i] = 136.75
                    alt_width[i] = 10.83
                    width_range[i] = 8.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 83.6
                    rec_width[i] = 17.0
                    PE_alt[i] = 90.5
                    alt_width[i] = 17.553
                    width_range[i] = 4.107 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 83.6
                    rec_width[i] = 17.0
                    PE_alt[i] = 87.5
                    alt_width[i] = 18.873
                    width_range[i] = 4.9 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 24.9
                    rec_width[i] = 0.08
                    PE_alt[i] = 23.77
                    alt_width[i] = 0.1
                    width_range[i] = 0.1 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 23.9
                    rec_width[i] = 0.08
                    PE_alt[i] = 23.77
                    alt_width[i] = 0.1
                    width_range[i] = 0.04 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_alt[i] = 7.0
                elif photoelectronLine[i] == 'O2':
                    PE_alt[i] = 1.25
                else:
                    PE_lit[i] = 29200.0


            elif element[i]== 'Sb':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 30491.0
                    rec_width[i] = 9.2
                    PE_alt[i] = 30491.1
                    alt_width[i] = 9.1
                    width_range[i] = 0.16 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 25793.9
                        alt_width[i] = 12.08
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 26110.5
                        alt_width[i] = 11.95
                        width_range[i] = 0.3
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 26359.0
                        alt_width[i] = 11.7
                        width_range[i] = 0.3
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 29546.8
                        alt_width[i] = 21.8
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 29679.5
                        alt_width[i] = 13.36
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 29725.75
                        alt_width[i] = 13.74
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 29956.05
                        alt_width[i] = 9.41
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 29963.7
                        alt_width[i] = 9.41
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 30340.1
                        alt_width[i] = 31.52
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 30387.1
                        alt_width[i] = 32.56
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 30388.0
                        alt_width[i] = 39.26
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 30438.0
                        alt_width[i] = 9.07
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 30460.5
                        alt_width[i] = 9.08
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 30487.5
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 30488.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 4698.0
                    width[i] = 2.25
                    rec_width[i] = 2.3
                    PE_alt[i] = 4698.65
                    alt_width[i] = 2.86
                    width_range[i] = 0.56 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 3752.9
                        alt_width[i] = 16.02
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 3886.4
                        alt_width[i] = 7.57
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 3932.6
                        alt_width[i] = 7.95
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 4161.62
                        alt_width[i] = 3.62
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 4170.82
                        alt_width[i] = 3.62
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 4546.2
                        alt_width[i] = 25.74
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 4593.1
                        alt_width[i] = 26.77
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 4594.0
                        alt_width[i] = 33.47
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 4664.3
                        alt_width[i] = 3.29
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 4665.8
                        alt_width[i] = 3.29
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 4380.0
                    width[i] = 2.65
                    rec_width[i] = 2.74
                    PE_alt[i] = 4380.7
                    alt_width[i] = 2.817
                    width_range[i] = 0.183 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 3436.62
                        alt_width[i] = 15.58
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 3569.3
                        alt_width[i] = 7.13
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 3615.3
                        alt_width[i] = 7.51
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 3844.0
                        alt_width[i] = 3.18
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 3853.1
                        alt_width[i] = 3.19
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 4228.74
                        alt_width[i] = 25.3
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 4276.3
                        alt_width[i] = 26.33
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 4277.2
                        alt_width[i] = 33.04
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 4347.81
                        alt_width[i] = 2.85
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 4348.99
                        alt_width[i] = 2.85
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 4132.0
                    rec_width[i] = 2.53
                    PE_alt[i] = 4132.1
                    alt_width[i] = 2.63
                    width_range[i] = 0.24 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 3188.6
                        alt_width[i] = 15.36
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 3321.3
                        alt_width[i] = 6.91
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 3367.3
                        alt_width[i] = 7.29
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 3595.3
                        alt_width[i] = 7.59
                        width_range[i] = 4.62
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 3604.77
                        alt_width[i] = 7.49
                        width_range[i] = 4.62
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 3980.0
                        alt_width[i] = 25.08
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 4028.4
                        alt_width[i] = 26.11
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 4029.3
                        alt_width[i] = 32.81
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 4099.59
                        alt_width[i] = 2.63
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 4101.02
                        alt_width[i] = 2.64
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 4125.85
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 946.0
                    width[i] = 9.3
                    rec_width[i] = 10.0
                    PE_alt[i] = 943.85
                    alt_width[i] = 11.435
                    width_range[i] = 1.5 #GUESS
                    if transitionLine[i] == 'M1P3':
                        PE_alt[i] = 659.5
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 812.7
                    rec_width[i] = 3.0
                    PE_alt[i] = 811.95
                    alt_width[i] = 3.71
                    width_range[i] = 0.71 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 658.75
                        alt_width[i] = 27.01
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 777.0
                        alt_width[i] = 4.56
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 766.4
                    rec_width[i] = 3.6
                    PE_alt[i] = 765.8
                    alt_width[i] = 4.2
                    width_range[i] = 0.6 #GUESS
                    if transitionLine[i] == 'M3M5':
                        PE_alt[i] = 237.5
                        alt_width[i] = 5.28
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 733.3
                        alt_width[i] = 4.94
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 732.8
                        alt_width[i] = 4.94
                    elif transitionLine[i] == 'M3N1':
                        PE_alt[i] = 612.75
                        alt_width[i] = 27.39
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 537.5
                    rec_width[i] = 0.47
                    PE_alt[i] = 536.95
                    alt_width[i] = 0.47
                    width_range[i] = 0.01 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 4429.0
                        alt_width[i] = 24.09
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 429.0
                        alt_width[i] = 30.8
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 540.06
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 528.2
                    rec_width[i] = 0.48
                    PE_alt[i] = 527.75
                    alt_width[i] = 0.48
                    width_range[i] = 0.1 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 429.73
                        alt_width[i] = 30.8
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 153.2
                    width[i] = 3.4
                    rec_width[i] = 2.6
                    PE_alt[i] = 152.0
                    alt_width[i] = 12.595
                    width_range[i] = 10.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 95.6
                    PE_alt[i] = 100.57
                    alt_width[i] = 23.62
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 95.6
                    PE_alt[i] = 97.6
                    alt_width[i] = 30.33
                    width_range[i] = 5.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 33.3
                    rec_width[i] = 0.14
                    PE_alt[i] = 31.87
                    alt_width[i] = 0.14
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 32.1
                    rec_width[i] = 0.14
                    PE_alt[i] = 31.4
                    alt_width[i] = 0.14
                    width_range[i] = 0.1 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_alt[i] = 4.1
                elif photoelectronLine[i] == 'O2':
                    PE_alt[i] = 7.78
                elif photoelectronLine[i] == 'O3':
                    PE_alt[i] = 0.75
                else:
                    PE_lit[i] = 30491.0


            elif element[i]== 'Te':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 31814.0
                    rec_width[i] = 9.91
                    PE_alt[i] = 31813.9
                    alt_width[i] = 9.813
                    width_range[i] = 0.173 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 26875.7
                        alt_width[i] = 12.91
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 27202.0
                        alt_width[i] = 13.22
                        width_range[i] = 0.98
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 27472.25
                        alt_width[i] = 12.6
                        width_range[i] = 0.4
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 30806.9
                        alt_width[i] = 22.84
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 30944.8
                        alt_width[i] = 13.3
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 30996.0
                        alt_width[i] = 14.0
                        width_range[i] = 0.7
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 31231.6
                        alt_width[i] = 10.15
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 31241.8
                        alt_width[i] = 10.16
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 31646.5
                        alt_width[i] = 23.08
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 31696.4
                        alt_width[i] = 34.84
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 31698.6
                        alt_width[i] = 45.72
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 31772.4
                        alt_width[i] = 9.81
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 31774.0
                        alt_width[i] = 9.83
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 31811.4
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 31812.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 4939.0
                    rec_width[i] = 2.2
                    PE_alt[i] = 4939.1
                    alt_width[i] = 2.93
                    width_range[i] = 0.39 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 3931.2
                        alt_width[i] = 16.47
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 4069.52
                        alt_width[i] = 6.82
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 4120.44
                        alt_width[i] = 8.27
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 4355.08
                        alt_width[i] = 3.79
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 4367.08
                        alt_width[i] = 3.79
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 4770.8
                        alt_width[i] = 16.71
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 4820.8
                        alt_width[i] = 28.47
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 4822.8
                        alt_width[i] = 39.35
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 4896.6
                        alt_width[i] = 3.44
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 4898.2
                        alt_width[i] = 3.46
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 4612.0
                    rec_width[i] = 2.84
                    PE_alt[i] = 4612.0
                    alt_width[i] = 2.923
                    width_range[i] = 0.197 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 3605.85
                        alt_width[i] = 16.01
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 3743.0
                        alt_width[i] = 7.45
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 3793.7
                        alt_width[i] = 7.86
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 4029.55
                        alt_width[i] = 3.16
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 4040.1
                        alt_width[i] = 3.32
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 4443.65
                        alt_width[i] = 16.25
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 4494.7
                        alt_width[i] = 28.01
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 4496.8
                        alt_width[i] = 38.89
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 4570.85
                        alt_width[i] = 4.3
                        width_range[i] = 1.31
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 4572.25
                        alt_width[i] = 3.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 4341.0
                    rec_width[i] = 2.62
                    PE_alt[i] = 4341.2
                    alt_width[i] = 2.72
                    width_range[i] = 0.23 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 3335.54
                        alt_width[i] = 15.79
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 3472.6
                        alt_width[i] = 7.23
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 3523.4
                        alt_width[i] = 7.64
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 3758.79
                        alt_width[i] = 2.99
                        width_range[i] = 0.11
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 3769.34
                        alt_width[i] = 2.99
                        width_range[i] = 0.11
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 4173.17
                        alt_width[i] = 16.02
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 4224.4
                        alt_width[i] = 27.79
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 4226.5
                        alt_width[i] = 38.67
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 4300.31
                        alt_width[i] = 2.76
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 4301.6
                        alt_width[i] = 6.25
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 4329.9
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 1006.0
                    rec_width[i] = 10.2
                    PE_alt[i] = 1006.05
                    alt_width[i] = 11.467
                    width_range[i] = 1.8 #GUESS
                    if transitionLine[i] == 'M1P3':
                        PE_alt[i] = 704.5
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 870.8
                    rec_width[i] = 3.2
                    PE_alt[i] = 869.85
                    alt_width[i] = 4.08
                    width_range[i] = 0.88 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 702.75
                        alt_width[i] = 18.08
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 820.0
                    rec_width[i] = 3.9
                    PE_alt[i] = 818.85
                    alt_width[i] = 4.453
                    width_range[i] = 0.6 #GUESS
                    if transitionLine[i] == 'M3M5':
                        PE_alt[i] = 246.5
                        alt_width[i] = 5.57
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 778.9
                        alt_width[i] = 5.23
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 778.3
                        alt_width[i] = 5.23
                    elif transitionLine[i] == 'M3N1':
                        PE_alt[i] = 648.6
                        alt_width[i] = 18.49
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 583.4
                    rec_width[i] = 0.52
                    PE_alt[i] = 582.25
                    alt_width[i] = 0.543
                    width_range[i] = 0.57 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 462.77
                        alt_width[i] = 25.72
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 472.82
                        alt_width[i] = 36.59
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 581.0
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 573.0
                    rec_width[i] = 0.52
                    PE_alt[i] = 572.05
                    alt_width[i] = 0.547
                    width_range[i] = 0.7 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 461.82
                        alt_width[i] = 36.6
                    elif transitionLine[i] == 'M5O3':
                        PE_alt[i] = 569.4
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 169.4
                    rec_width[i] = 2.4
                    PE_alt[i] = 168.15
                    alt_width[i] = 6.947
                    width_range[i] = 6.4 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 103.3
                    PE_alt[i] = 112.33
                    alt_width[i] = 16.25
                    width_range[i] = 8.95 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 103.3
                    PE_alt[i] = 103.45
                    alt_width[i] = 21.69
                    width_range[i] = 14.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 41.9
                    rec_width[i] = 0.17
                    PE_alt[i] = 40.2
                    alt_width[i] = 0.147
                    width_range[i] = 0.047 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 40.4
                    rec_width[i] = 0.2
                    PE_alt[i] = 39.67
                    alt_width[i] = 0.167
                    width_range[i] = 0.07 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_alt[i] = 11.8
                elif photoelectronLine[i] == 'O2':
                    PE_alt[i] = 2.3
                elif photoelectronLine[i] == 'O3':
                    PE_alt[i] = 2.0
                else:
                    PE_lit[i] = 31814.0


            elif element[i]== 'I':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 33169.0
                    rec_width[i] = 10.7
                    PE_alt[i] = 33169.7
                    alt_width[i] = 10.56
                    width_range[i] = 0.14 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 27982.3
                        alt_width[i] = 13.78
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 28317.75
                        alt_width[i] = 13.55
                        width_range[i] = 0.25
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 28612.15
                        alt_width[i] = 13.38
                        width_range[i] = 0.32
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 32096.7
                        alt_width[i] = 23.38
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 32239.85
                        alt_width[i] = 15.27
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 32295.0
                        alt_width[i] = 15.69
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 32538.8
                        alt_width[i] = 10.94
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 32550.1
                        alt_width[i] = 10.94
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 32984.4
                        alt_width[i] = 16.75
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 33037.3
                        alt_width[i] = 36.35
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 33041.8
                        alt_width[i] = 54.36
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 33118.2
                        alt_width[i] = 10.49
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 33120.0
                        alt_width[i] = 10.48
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 5188.0
                    rec_width[i] = 2.1
                    PE_alt[i] = 5188.05
                    alt_width[i] = 2.987
                    width_range[i] = 0.887 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 4114.4
                        alt_width[i] = 16.4
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 4257.46
                        alt_width[i] = 8.29
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 4313.44
                        alt_width[i] = 8.71
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 4556.41
                        alt_width[i] = 3.95
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 4569.0
                        alt_width[i] = 3.96
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 5002.1
                        alt_width[i] = 9.77
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 5055.0
                        alt_width[i] = 29.37
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 5059.5
                        alt_width[i] = 47.38
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 5135.9
                        alt_width[i] = 3.51
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 5137.7
                        alt_width[i] = 3.5
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 5184.8
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 5184.8
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 4852.0
                    rec_width[i] = 2.95
                    PE_alt[i] = 4852.05
                    alt_width[i] = 3.037
                    width_range[i] = 0.213 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 3779.95
                        alt_width[i] = 15.92
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 3921.6
                        alt_width[i] = 7.8
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 3977.5
                        alt_width[i] = 8.23
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 4220.73
                        alt_width[i] = 3.47
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 4232.5
                        alt_width[i] = 3.48
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 4666.0
                        alt_width[i] = 9.28
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 4719.6
                        alt_width[i] = 28.89
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 4724.2
                        alt_width[i] = 46.9
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 4800.94
                        alt_width[i] = 3.02
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 4802.33
                        alt_width[i] = 3.03
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 4557.0
                    rec_width[i] = 2.72
                    PE_alt[i] = 4557.05
                    alt_width[i] = 2.827
                    width_range[i] = 0.253 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 3485.03
                        alt_width[i] = 15.67
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 3627.3
                        alt_width[i] = 7.56
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 3683.2
                        alt_width[i] = 7.99
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 3926.05
                        alt_width[i] = 3.24
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 3937.65
                        alt_width[i] = 3.24
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 4370.56
                        alt_width[i] = 9.05
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 4425.3
                        alt_width[i] = 28.65
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 4429.9
                        alt_width[i] = 46.66
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 4507.58
                        alt_width[i] = 2.79
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 4507.58
                        alt_width[i] = 2.8
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 4542.5
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 1072.0
                    rec_width[i] = 10.4
                    PE_alt[i] = 1072.05
                    alt_width[i] = 11.705
                    width_range[i] = 1.4 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 931.0
                    rec_width[i] = 3.35
                    PE_alt[i] = 930.75
                    alt_width[i] = 4.12
                    width_range[i] = 0.77 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 875.0
                    rec_width[i] = 4.3
                    PE_alt[i] = 874.8
                    alt_width[i] = 4.805
                    width_range[i] = 0.6 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 826.6
                        alt_width[i] = 5.42
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 826.6
                        alt_width[i] = 5.43
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 630.8
                    rec_width[i] = 0.56
                    PE_alt[i] = 631.15
                    alt_width[i] = 0.56
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 495.93
                        alt_width[i] = 26.52
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 507.25
                        alt_width[i] = 44.54
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 630.69
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 619.3
                    rec_width[i] = 0.56
                    PE_alt[i] = 619.7
                    alt_width[i] = 0.56
                    width_range[i] = 0.1 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 495.1
                        alt_width[i] = 44.54
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 186.0
                    rec_width[i] = 2.4
                    PE_alt[i] = 186.2
                    alt_width[i] = 4.385
                    width_range[i] = 2.1 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 123.0
                    PE_alt[i] = 125.27
                    alt_width[i] = 25.97
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 123.0
                    PE_alt[i] = 121.57
                    alt_width[i] = 43.98
                    width_range[i] = 5.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 50.6
                    rec_width[i] = 0.11
                    PE_alt[i] = 50.1
                    alt_width[i] = 0.11
                    width_range[i] = 0.02 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 48.9
                    rec_width[i] = 0.12
                    PE_alt[i] = 49.45
                    alt_width[i] = 0.12
                    width_range[i] = 0.1 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_alt[i] = 13.8
                elif photoelectronLine[i] == 'O2':
                    PE_alt[i] = 3.37
                elif photoelectronLine[i] == 'O3':
                    PE_alt[i] = 3.07
                else:
                    PE_lit[i] = 33169.0


            elif element[i]== 'Xe':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 34561.0
                    width[i] = 11.5
                    rec_width[i] = 11.5
                    PE_alt[i] = 34561.2
                    alt_width[i] = 11.337
                    width_range[i] = 0.227 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 29112.6
                        alt_width[i] = 14.45
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 29458.3
                        alt_width[i] = 14.62
                        width_range[i] = 0.66
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 27472.25
                        alt_width[i] = 14.18
                        width_range[i] = 0.45
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 33416.61
                        alt_width[i] = 22.28
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 33563.3
                        alt_width[i] = 14.7
                        width_range[i] = 1.3
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 33624.3
                        alt_width[i] = 16.0
                        width_range[i] = 0.7
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 33875.95
                        alt_width[i] = 11.7
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 33888.78
                        alt_width[i] = 11.7
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 34353.4
                        alt_width[i] = 16.31
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 34408.9
                        alt_width[i] = 36.81
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 34408.0
                        alt_width[i] = 43.08
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 34495.4
                        alt_width[i] = 11.19
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 34497.2
                        alt_width[i] = 11.19
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 5453.0
                    width[i] = 3.7
                    rec_width[i] = 2.0
                    PE_alt[i] = 5452.9
                    alt_width[i] = 2.997
                    width_range[i] = 1.0 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 4303.2
                        alt_width[i] = 14.51
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 4450.35
                        alt_width[i] = 8.33
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 4512.0
                        alt_width[i] = 8.92
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 4763.2
                        alt_width[i] = 8.91
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 4775.8
                        alt_width[i] = 8.92
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 5240.5
                        alt_width[i] = 11.88
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 5296.0
                        alt_width[i] = 29.05
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 5306.7
                        alt_width[i] = 35.32
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 5382.5
                        alt_width[i] = 3.42
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 5384.3
                        alt_width[i] = 3.42
                    elif transitionLine[i] == 'L1P2':
                        PE_alt[i] = 5450.4
                    elif transitionLine[i] == 'L1Q2':
                        PE_alt[i] = 5451.67
                    elif transitionLine[i] == 'L1R2':
                        PE_alt[i] = 5452.18
                    elif transitionLine[i] == 'L1S2':
                        PE_alt[i] = 5452.41
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 5107.0
                    rec_width[i] = 3.05
                    PE_alt[i] = 5103.85
                    alt_width[i] = 3.137
                    width_range[i] = 0.373 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 3958.1
                        alt_width[i] = 14.03
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 4104.6
                        alt_width[i] = 7.83
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 4166.2
                        alt_width[i] = 8.42
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 4417.66
                        alt_width[i] = 3.45
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 4430.2
                        alt_width[i] = 3.46
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 4895.0
                        alt_width[i] = 8.05
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 4950.5
                        alt_width[i] = 28.56
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 4949.2
                        alt_width[i] = 35.04
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 5037.05
                        alt_width[i] = 2.93
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 5038.78
                        alt_width[i] = 2.93
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 5104.88
                    elif transitionLine[i] == 'L2P1':
                        PE_alt[i] = 5103.09
                    elif transitionLine[i] == 'L2P4':
                        PE_alt[i] = 5105.93
                    elif transitionLine[i] == 'L2Q4':
                        PE_alt[i] = 5106.45
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 4786.0
                    rec_width[i] = 2.82
                    PE_alt[i] = 4782.1
                    alt_width[i] = 2.9
                    width_range[i] = 0.35 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 3637.5
                        alt_width[i] = 13.8
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 3784.7
                        alt_width[i] = 7.61
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 3846.3
                        alt_width[i] = 8.2
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 4097.4
                        alt_width[i] = 3.22
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 4110.0
                        alt_width[i] = 3.19
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 4575.1
                        alt_width[i] = 7.83
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 4630.6
                        alt_width[i] = 5.2
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 4629.3
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 4717.08
                        alt_width[i] = 2.71
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 4718.88
                        alt_width[i] = 2.71
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 4784.23
                    elif transitionLine[i] == 'L3P1':
                        PE_alt[i] = 4782.4
                    elif transitionLine[i] == 'L3P4':
                        PE_alt[i] = 4785.26
                    elif transitionLine[i] == 'L3Q4':
                        PE_alt[i] = 4685.7
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 1148.7
                    width[i] = 9.5
                    rec_width[i] = 10.6
                    PE_alt[i] = 1146.7
                    alt_width[i] = 10.65
                    width_range[i] = 0.6 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 1002.1
                    rec_width[i] = 3.5
                    PE_alt[i] = 999.0
                    alt_width[i] = 4.437
                    width_range[i] = 0.937 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 940.6
                    rec_width[i] = 4.7
                    PE_alt[i] = 937.0
                    alt_width[i] = 5.253
                    width_range[i] = 0.4 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 856.72
                        alt_width[i] = 5.66
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 858.78
                        alt_width[i] = 5.66
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 689.0
                    rec_width[i] = 0.6
                    PE_alt[i] = 687.8
                    alt_width[i] = 0.623
                    width_range[i] = 0.057 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 530.22
                        alt_width[i] = 26.3
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 542.93
                        alt_width[i] = 32.57
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 678.56
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 676.4
                    rec_width[i] = 0.6
                    PE_alt[i] = 673.0
                    alt_width[i] = 0.627
                    width_range[i] = 0.2 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 529.54
                        alt_width[i] = 32.57
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 213.2
                    rec_width[i] = 2.6
                    PE_alt[i] = 212.85
                    alt_width[i] = 4.433
                    width_range[i] = 1.9 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 146.7
                    PE_alt[i] = 152.53
                    alt_width[i] = 14.355
                    width_range[i] = 11.355 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 145.5
                    PE_alt[i] = 146.85
                    alt_width[i] = 17.485
                    width_range[i] = 14.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 69.5
                    rec_width[i] = 0.1
                    PE_alt[i] = 66.25
                    alt_width[i] = 0.09
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 67.5
                    rec_width[i] = 0.08
                    PE_alt[i] = 65.3
                    alt_width[i] = 0.083
                    width_range[i] = 0.08 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 23.3
                    PE_alt[i] = 20.7
                    alt_width[i] = 0.05 #GUESS
                    width_range[i] = 0.05 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 13.4
                    PE_alt[i] = 10.2
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 12.1
                    PE_alt[i] = 12.1
                else:
                    PE_lit[i] = 34561.0


            elif element[i]== 'Cs':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 35985.0
                    rec_width[i] = 12.3
                    PE_alt[i] = 3584.8
                    alt_width[i] = 12.183
                    width_range[i] = 0.233 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 30270.5
                        alt_width[i] = 15.42
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 30625.2
                        alt_width[i] = 15.35
                        width_range[i] = 0.45
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 30973.05
                        alt_width[i] = 15.1
                        width_range[i] = 0.5
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 34766.7
                        alt_width[i] = 23.5
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 34919.34
                        alt_width[i] = 16.89
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 34987.15
                        alt_width[i] = 17.79
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 35244.9
                        alt_width[i] = 12.58
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 35258.6
                        alt_width[i] = 12.58
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 35755.7
                        alt_width[i] = 17.71
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 35813.2
                        alt_width[i] = 35.34
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 35823.0
                        alt_width[i] = 49.22
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 35905.3
                        alt_width[i] = 11.27
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 35907.4
                        alt_width[i] = 11.26
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 5714.0
                    rec_width[i] = 2.0
                    PE_alt[i] = 5713.65
                    alt_width[i] = 3.083
                    width_range[i] = 1.083 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 4496.1
                        alt_width[i] = 15.02
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 4949.42
                        alt_width[i] = 8.42
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 4716.93
                        alt_width[i] = 9.32
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 4975.45
                        alt_width[i] = 4.1
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 5002.86
                        alt_width[i] = 4.11
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 5485.2
                        alt_width[i] = 9.23
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 5542.2
                        alt_width[i] = 26.87
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 5552.92
                        alt_width[i] = 40.75
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 5634.8
                        alt_width[i] = 3.55
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 5636.9
                        alt_width[i] = 3.54
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 5702.6
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 5702.7
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 5359.0
                    rec_width[i] = 3.15
                    PE_alt[i] = 5359.7
                    alt_width[i] = 3.117
                    width_range[i] = 0.167 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 4142.3
                        alt_width[i] = 14.5
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 4293.7
                        alt_width[i] = 7.89
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 4360.9
                        alt_width[i] = 8.79
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 4619.9
                        alt_width[i] = 3.58
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 4633.8
                        alt_width[i] = 3.59
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 5128.9
                        alt_width[i] = 8.72
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 5188.3
                        alt_width[i] = 26.35
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 5198.1
                        alt_width[i] = 40.22
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 5280.45
                        alt_width[i] = 3.03
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 5282.54
                        alt_width[i] = 3.02
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 5012.0
                    rec_width[i] = 2.92
                    PE_alt[i] = 5011.95
                    alt_width[i] = 3.05
                    width_range[i] = 0.46 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 3795.05
                        alt_width[i] = 14.27
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 3946.5
                        alt_width[i] = 7.66
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 4013.7
                        alt_width[i] = 8.56
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 4272.45
                        alt_width[i] = 3.35
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 4286.65
                        alt_width[i] = 3.36
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 4781.25
                        alt_width[i] = 8.49
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 4841.1
                        alt_width[i] = 26.12
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 4851.0
                        alt_width[i] = 39.99
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 4933.27
                        alt_width[i] = 2.8
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 4935.9
                        alt_width[i] = 2.8
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 4989.5
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 1211.0
                    rec_width[i] = 10.8
                    PE_alt[i] = 1217.05
                    alt_width[i] = 11.175
                    width_range[i] = 0.5 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 1071.0
                    rec_width[i] = 3.7
                    PE_alt[i] = 1065.0
                    alt_width[i] = 4.32
                    width_range[i] = 0.62 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 836.0
                        alt_width[i] = 10.71
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 987.0
                        alt_width[i] = 5.02
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 1003.0
                    rec_width[i] = 5.0
                    PE_alt[i] = 997.8
                    alt_width[i] = 5.425
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 766.0
                        alt_width[i] = 11.61
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 918.4
                        alt_width[i] = 5.92
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 922.0
                        alt_width[i] = 5.92
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 740.5
                    rec_width[i] = 0.63
                    PE_alt[i] = 739.75
                    alt_width[i] = 0.63
                    width_range[i] = 0.1 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 565.73
                        alt_width[i] = 24.03
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 579.46
                        alt_width[i] = 37.9
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 729.43
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 726.6
                    rec_width[i] = 0.63
                    PE_alt[i] = 725.75
                    alt_width[i] = 0.63
                    width_range[i] = 0.1 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 565.11
                        alt_width[i] = 37.9
                    elif transitionLine[i] == 'M5O3':
                        PE_alt[i] = 714.0
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 232.3
                    rec_width[i] = 2.8
                    PE_alt[i] = 230.9
                    alt_width[i] = 4.28
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 172.4
                    PE_alt[i] = 172.15
                    alt_width[i] = 23.4
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 161.3
                    PE_alt[i] = 161.8
                    alt_width[i] = 37.27
                    width_range[i] = 5.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 79.8
                    rec_width[i] = 0.08
                    PE_alt[i] = 78.9
                    alt_width[i] = 0.08
                    if transitionLine[i] == 'N4O2':
                        PE_alt[i] = 65.74
                    elif transitionLine[i] == 'N4O3':
                        PE_alt[i] = 67.46
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 77.5
                    rec_width[i] = 0.08
                    PE_alt[i] = 76.75
                    alt_width[i] = 0.075
                    width_range[i] = 0.04 #GUESS
                    if transitionLine[i] == 'N5O3':
                        PE_alt[i] = 65.15
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 22.7
                    PE_alt[i] = 22.85
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 14.2
                    PE_alt[i] = 13.05
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 12.1
                    PE_alt[i] = 11.7
                else:
                    PE_lit[i] = 35985.0

            elif element[i]== 'Ba':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 37441.0
                    width[i] = 13.5
                    rec_width[i] = 13.2
                    PE_alt[i] = 37440.8
                    alt_width[i] = 13.077
                    width_range[i] = 0.247 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 31452.5
                        alt_width[i] = 16.44
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 31816.9
                        alt_width[i] = 16.5
                        width_range[i] = 0.61
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 32193.5
                        alt_width[i] = 16.09
                        width_range[i] = 0.43
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 36147.3
                        alt_width[i] = 24.71
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 36304.0
                        alt_width[i] = 17.0
                        width_range[i] = 1.0
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 36377.9
                        alt_width[i] = 18.55
                        width_range[i] = 0.5
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 36643.6
                        alt_width[i] = 13.49
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 36666.0
                        alt_width[i] = 13.5
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 37188.0
                        alt_width[i] = 19.16
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 37249.0
                        alt_width[i] = 30.25
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 37262.9
                        alt_width[i] = 15.32
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 37313.0
                        alt_width[i] = 12.91
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 37349.84
                        alt_width[i] = 12.91
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 37427.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 5989.0
                    rec_width[i] = 2.1
                    PE_alt[i] = 5987.9
                    alt_width[i] = 3.077
                    width_range[i] = 0.977 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 4694.8
                        alt_width[i] = 15.49
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 4852.25
                        alt_width[i] = 8.08
                        width_range[i] = 0.66
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 4927.25
                        alt_width[i] = 9.45
                        width_range[i] = 0.25
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 5194.55
                        alt_width[i] = 4.26
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 5217.4
                        alt_width[i] = 4.27
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 5735.5
                        alt_width[i] = 9.94
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 5797.25
                        alt_width[i] = 21.02
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 5809.45
                        alt_width[i] = 6.09
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 5895.2
                        alt_width[i] = 3.69
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 5897.3
                        alt_width[i] = 3.69
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 5973.3
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 5974.5
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 5624.0
                    rec_width[i] = 3.25
                    PE_alt[i] = 5623.8
                    alt_width[i] = 3.293
                    width_range[i] = 0.277 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 4331.5
                        alt_width[i] = 14.93
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 4487.4
                        alt_width[i] = 8.17
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 4560.9
                        alt_width[i] = 9.13
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 4828.0
                        alt_width[i] = 3.58
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 4842.9
                        alt_width[i] = 3.47
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 5433.0
                        alt_width[i] = 20.46
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 5433.0
                        alt_width[i] = 20.46
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 5446.4
                        alt_width[i] = 5.54
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 5531.4
                        alt_width[i] = 4.75
                        width_range[i] = 1.61
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 5533.28
                        alt_width[i] = 6.35
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 5578.0
                        alt_width[i] = 3.7
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 5247.0
                    rec_width[i] = 3.02
                    PE_alt[i] = 5247.0
                    alt_width[i] = 3.053
                    width_range[i] = 0.267 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 3954.3
                        alt_width[i] = 14.7
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 4111.1
                        alt_width[i] = 7.94
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 4184.6
                        alt_width[i] = 8.9
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 4451.3
                        alt_width[i] = 3.46
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 4466.8
                        alt_width[i] = 3.44
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 4994.2
                        alt_width[i] = 9.15
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 5056.0
                        alt_width[i] = 20.23
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 5070.1
                        alt_width[i] = 5.31
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 5155.5
                        alt_width[i] = 2.9
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 5156.75
                        alt_width[i] = 4.8
                        width_range[i] = 1.9
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 5207.95
                        alt_width[i] = 3.47
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 1293.0
                    rec_width[i] = 11.1
                    PE_alt[i] = 1292.9
                    alt_width[i] = 10.993
                    width_range[i] = 0.9 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 1137.0
                    rec_width[i] = 3.9
                    PE_alt[i] = 1136.85
                    alt_width[i] = 4.81
                    width_range[i] = 0.91 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 884.0
                        alt_width[i] = 18.27
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 1043.0
                        alt_width[i] = 5.21
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 1063.0
                    rec_width[i] = 5.4
                    PE_alt[i] = 1062.6
                    alt_width[i] = 5.63
                    width_range[i] = 0.3 #GUESS
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 807.0
                        alt_width[i] = 12.42
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 973.0
                        alt_width[i] = 6.17
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 974.7
                        alt_width[i] = 6.17
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 795.7
                    rec_width[i] = 0.67
                    PE_alt[i] = 796.05
                    alt_width[i] = 0.693
                    width_range[i] = 0.057 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 602.43
                        alt_width[i] = 18.07
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 617.0
                        alt_width[i] = 3.14
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 799.0
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 779.3
                    elif transitionLine[i] == 'M4O3':
                        PE_alt[i] = 789.0
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 780.5
                    rec_width[i] = 0.67
                    PE_alt[i] = 780.85
                    alt_width[i] = 0.697
                    width_range[i] = 0.15 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 601.0
                        alt_width[i] = 3.16
                    elif transitionLine[i] == 'M5O3':
                        PE_alt[i] = 765.0
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 253.5
                    rec_width[i] = 3.1
                    PE_alt[i] = 253.0
                    alt_width[i] = 5.143
                    width_range[i] = 2.1 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 192.0
                    rec_width[i] = 5.0
                    PE_alt[i] = 191.9
                    alt_width[i] = 8.403
                    width_range[i] = 9.0 #GUESS ZERO?
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 178.6
                    rec_width[i] = 1.3
                    PE_alt[i] = 179.7
                    alt_width[i] = 2.197
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 92.6
                    rec_width[i] = 0.08
                    PE_alt[i] = 92.75
                    alt_width[i] = 0.087
                    width_range[i] = 0.013 #GUESS
                    if transitionLine[i] == 'N4O2':
                        PE_alt[i] = 75.9
                    elif transitionLine[i] == 'N4O3':
                        PE_alt[i] = 77.96
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 89.9
                    rec_width[i] = 0.08
                    PE_alt[i] = 89.95
                    alt_width[i] = 0.083
                    width_range[i] = 0.03 #GUESS
                    if transitionLine[i] == 'N5O3':
                        PE_alt[i] = 75.3
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 30.3
                    PE_alt[i] = 39.55
                    alt_width[i] = 0.05 #GUESS
                    width_range[i] = 0.05 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 17.0
                    PE_alt[i] = 16.8
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 14.8
                    PE_alt[i] = 14.8
                else:
                    PE_lit[i] = 37441.0

            elif element[i]== 'La':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 38925.0
                    rec_width[i] = 14.2
                    PE_alt[i] = 38924.8
                    alt_width[i] = 14.02
                    width_range[i] = 0.25 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 32660.4
                        alt_width[i] = 17.51
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 33034.2
                        alt_width[i] = 16.35
                        width_range[i] = 0.45
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 33442.05
                        alt_width[i] = 17.2
                        width_range[i] = 0.5
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 37559.0
                        alt_width[i] = 25.91
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 37721.0
                        alt_width[i] = 19.06
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 37802.0
                        alt_width[i] = 19.9
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 38074.9
                        alt_width[i] = 14.47
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 38094.75
                        alt_width[i] = 14.48
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 38654.0
                        alt_width[i] = 20.62
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 38710.0
                        alt_width[i] = 19.55
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 38732.05
                        alt_width[i] = 16.56
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 38784.0
                        alt_width[i] = 13.87
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 38827.0
                        alt_width[i] = 13.87
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 38909.0
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 389116.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 6266.0
                    rec_width[i] = 2.2
                    PE_alt[i] = 6266.65
                    alt_width[i] = 3.33
                    width_range[i] = 1.13 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 4898.6
                        alt_width[i] = 15.9
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 5062.3
                        alt_width[i] = 9.02
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 5143.65
                        alt_width[i] = 9.86
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 5416.0
                        alt_width[i] = 4.43
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 5435.0
                        alt_width[i] = 4.44
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 5993.6
                        alt_width[i] = 10.61
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 6060.4
                        alt_width[i] = 9.51
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 6075.2
                        alt_width[i] = 6.53
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 6162.7
                        alt_width[i] = 3.83
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 6164.6
                        alt_width[i] = 3.84
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 6252.0
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 6252.9
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 5891.0
                    rec_width[i] = 3.35
                    PE_alt[i] = 5890.8
                    alt_width[i] = 3.38
                    width_range[i] = 0.25 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 4524.95
                        alt_width[i] = 15.32
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 4686.2
                        alt_width[i] = 8.45
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 4766.7
                        alt_width[i] = 9.29
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 5042.7
                        alt_width[i] = 3.86
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 5057.8
                        alt_width[i] = 3.87
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 5620.8
                        alt_width[i] = 10.03
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 5683.0
                        alt_width[i] = 8.94
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 5699.0
                        alt_width[i] = 5.95
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 5788.7
                        alt_width[i] = 3.26
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 5790.83
                        alt_width[i] = 3.26
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 5887.7
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 5888.0
                        alt_width[i] = 1.93
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 5483.0
                    rec_width[i] = 3.12
                    PE_alt[i] = 5482.85
                    alt_width[i] = 3.15
                    width_range[i] = 0.26 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 4124.25
                        alt_width[i] = 15.08
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 4278.9
                        alt_width[i] = 8.21
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 4359.3
                        alt_width[i] = 9.05
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 4634.35
                        alt_width[i] = 10.71
                        width_range[i] = 7.09
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 4466.8
                        alt_width[i] = 10.62
                        width_range[i] = 6.99
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 5211.75
                        alt_width[i] = 9.79
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 5276.0
                        alt_width[i] = 8.7
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 5291.2
                        alt_width[i] = 5.71
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 5381.4
                        alt_width[i] = 3.01
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 5383.7
                        alt_width[i] = 3.02
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 5450.0
                        alt_width[i] = 3.54
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 5478.0
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 1362.0
                    rec_width[i] = 11.4
                    PE_alt[i] = 1361.65
                    alt_width[i] = 10.953
                    width_range[i] = 1.653 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 1209.0
                    rec_width[i] = 4.1
                    PE_alt[i] = 1204.7
                    alt_width[i] = 5.05
                    width_range[i] = 0.95 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 931.0
                        alt_width[i] = 12.16
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 1101.0
                        alt_width[i] = 12.16
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 1128.0
                    rec_width[i] = 5.8
                    PE_alt[i] = 1123.7
                    alt_width[i] = 5.777
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 1027.8
                        alt_width[i] = 6.22
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 1023.0
                        alt_width[i] = 6.22
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 853.0
                    width[i] = 1.1
                    rec_width[i] = 0.7
                    PE_alt[i] = 848.75
                    alt_width[i] = 0.71
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 640.23
                        alt_width[i] = 6.48
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 654.0
                        alt_width[i] = 3.49
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 855.0
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 836.63
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 836.0
                    width[i] = 1.9
                    rec_width[i] = 0.7
                    PE_alt[i] = 831.85
                    alt_width[i] = 0.7
                    width_range[i] = 0.1 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 638.3
                        alt_width[i] = 9.0
                        width_range[i] = 0.2
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 833.0
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 834.0
                    elif transitionLine[i] == 'M5O3':
                        PE_alt[i] = 811.0
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 274.7
                    rec_width[i] = 3.3
                    PE_alt[i] = 270.7
                    alt_width[i] = 5.085
                    width_range[i] = 1.8 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 205.8
                    rec_width[i] = 5.03
                    PE_alt[i] = 205.9
                    alt_width[i] = 5.405
                    width_range[i] = 0.375 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 196.0
                    rec_width[i] = 1.45
                    PE_alt[i] = 191.7
                    alt_width[i] = 2.12
                    width_range[i] = 0.7 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 105.3
                    rec_width[i] = 0.09
                    PE_alt[i] = 99.53
                    alt_width[i] = 0.09
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'N4O2':
                        PE_alt[i] = 81.2
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 102.5
                    rec_width[i] = 0.1
                    PE_alt[i] = 98.53
                    alt_width[i] = 0.1
                    width_range[i] = 0.1 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 34.3
                    PE_alt[i] = 32.65
                    alt_width[i] = 0.62
                    width_range[i] = 0.2 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 19.3
                    PE_alt[i] = 15.33
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 16.8
                    PE_alt[i] = 14.15
                else:
                    PE_lit[i] = 38925.0
            
            elif element[i]== 'Ce':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 40443.0
                    rec_width[i] = 15.2
                    PE_alt[i] = 40443.5
                    alt_width[i] = 15.013
                    width_range[i] = 0.273 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 33896.2
                        alt_width[i] = 18.58
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 34279.15
                        alt_width[i] = 18.9
                        width_range[i] = 1.0
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 34720.0
                        alt_width[i] = 18.3
                        width_range[i] = 0.6
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 39006.9
                        alt_width[i] = 27.68
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 39170.9
                        alt_width[i] = 19.0
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 39258.0
                        alt_width[i] = 20.95
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 39539.5
                        alt_width[i] = 15.54
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 39557.95
                        alt_width[i] = 15.46
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 40155.1
                        alt_width[i] = 22.4
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 40210.0
                        alt_width[i] = 27.24
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 40235.0
                        alt_width[i] = 18.47
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 40330.4
                        alt_width[i] = 15.35
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 40334.22
                        alt_width[i] = 15.07
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 40427.0
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 40429.2
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 6549.0
                    rec_width[i] = 2.5
                    PE_alt[i] = 6548.9
                    alt_width[i] = 3.517
                    width_range[i] = 1.017 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 5110.7
                        alt_width[i] = 16.77
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 5277.4
                        alt_width[i] = 8.68
                        width_range[i] = 0.86
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 5365.35
                        alt_width[i] = 10.06
                        width_range[i] = 0.36
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 5644.94
                        alt_width[i] = 4.63
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 5664.61
                        alt_width[i] = 4.56
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 6258.9
                        alt_width[i] = 11.49
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 6326.55
                        alt_width[i] = 16.34
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 6342.15
                        alt_width[i] = 7.56
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 6434.2
                        alt_width[i] = 4.45
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 6438.0
                        alt_width[i] = 4.16
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 6512.9
                        alt_width[i] = 4.44
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 6528.0
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 6528.4
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 6164.0
                    rec_width[i] = 3.41
                    PE_alt[i] = 6164.6
                    alt_width[i] = 3.477
                    width_range[i] = 0.323 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 4731.75
                        alt_width[i] = 16.15
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 4893.1
                        alt_width[i] = 8.91
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 4981.4
                        alt_width[i] = 9.79
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 5263.0
                        alt_width[i] = 3.85
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 5281.6
                        alt_width[i] = 3.64
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 5874.9
                        alt_width[i] = 10.87
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 5940.15
                        alt_width[i] = 15.72
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 5959.0
                        alt_width[i] = 6.94
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 6052.17
                        alt_width[i] = 5.29
                        width_range[i] = 1.46
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 6054.66
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 6161.57
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 6126.8
                        alt_width[i] = 3.81
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 5723.0
                    rec_width[i] = 3.19
                    PE_alt[i] = 5723.7
                    alt_width[i] = 3.227
                    width_range[i] = 0.263 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 4287.51
                        alt_width[i] = 15.93
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 4452.6
                        alt_width[i] = 8.69
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 4540.8
                        alt_width[i] = 9.57
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 4823.18
                        alt_width[i] = 3.78
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 4840.03
                        alt_width[i] = 3.71
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 5433.22
                        alt_width[i] = 10.65
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 5499.0
                        alt_width[i] = 15.5
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 5518.8
                        alt_width[i] = 6.72
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 5610.3
                        alt_width[i] = 3.61
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 5613.2
                        alt_width[i] = 3.32
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 5721.1
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 5721.1
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 5713.2
                        alt_width[i] = 3.59
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 1436.0
                    rec_width[i] = 11.6
                    PE_alt[i] = 1434.8
                    alt_width[i] = 11.843
                    width_range[i] = 1.087 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 1274.0
                    width[i] = 4.3
                    rec_width[i] = 4.3
                    PE_alt[i] = 1272.9
                    alt_width[i] = 5.263
                    width_range[i] = 0.963 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 982.0
                        alt_width[i] = 13.34
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 1159.0
                        alt_width[i] = 6.3
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 1187.0
                    width[i] = 6.2
                    rec_width[i] = 6.2
                    PE_alt[i] = 1185.7
                    alt_width[i] = 6.19
                    width_range[i] = 0.4 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 1074.85
                        alt_width[i] = 7.18
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 1074.0
                        alt_width[i] = 6.89
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 902.4
                    width[i] = 1.1
                    rec_width[i] = 0.72
                    PE_alt[i] = 901.65
                    alt_width[i] = 0.777
                    width_range[i] = 0.057 #GUESS
                    if transitionLine[i] == 'M4N3':
                        PE_alt[i] = 693.0
                        alt_width[i] = 4.52
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 902.3
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 883.8
                    width[i] = 1.9
                    rec_width[i] = 0.72
                    PE_alt[i] = 883.65
                    alt_width[i] = 0.88
                    width_range[i] = 0.6 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 638.3
                        alt_width[i] = 9.0
                        width_range[i] = 0.2
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 880.0
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 879.29
                    elif transitionLine[i] == 'M5O3':
                        PE_alt[i] = 862.0
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 291.0
                    rec_width[i] = 3.5
                    PE_alt[i] = 289.8
                    alt_width[i] = 6.417
                    width_range[i] = 3.1 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 223.2
                    rec_width[i] = 5.06
                    PE_alt[i] = 223.65
                    alt_width[i] = 7.353
                    width_range[i] = 5.147 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 206.5
                    rec_width[i] = 1.6
                    PE_alt[i] = 207.6
                    alt_width[i] = 3.273
                    width_range[i] = 1.8 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 109.0
                    rec_width[i] = 0.61
                    PE_alt[i] = 112.3
                    alt_width[i] = 0.52
                    width_range[i] = 0.18 #GUESS
                    if transitionLine[i] == 'N4O2':
                        PE_alt[i] = 85.9
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 109.3
                    alt_width[i] = 0.32
                    width_range[i] = 0.04 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 0.1
                    rec_width[i] = 0.32
                    PE_alt[i] = 0.55
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 0.1
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 37.8
                    PE_alt[i] = 37.9
                    alt_width[i] = 0.59
                    width_range[i] = 0.1 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 19.8
                    PE_alt[i] = 20.53
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 17.0
                    PE_alt[i] = 19.4
                else:
                    PE_lit[i] = 40443.0


            elif element[i]== 'Pr':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 41991.0
                    rec_width[i] = 16.2
                    PE_alt[i] = 41990.8
                    alt_width[i] = 14.06
                    width_range[i] = 3.86 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 35157.3
                        alt_width[i] = 19.74
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 35550.3
                        alt_width[i] = 19.58
                        width_range[i] = 0.52
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 36026.85
                        alt_width[i] = 19.4
                        width_range[i] = 0.5
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 40484.3
                        alt_width[i] = 17.14
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 40653.65
                        alt_width[i] = 21.79
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 40748.85
                        alt_width[i] = 22.73
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 41039.2
                        alt_width[i] = 16.65
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 41060.5
                        alt_width[i] = 16.53
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 41688.1
                        alt_width[i] = 24.03
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 41746.0
                        alt_width[i] = 27.62
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 41774.8
                        alt_width[i] = 20.13
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 41872.4
                        alt_width[i] = 16.56
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 41876.35
                        alt_width[i] = 16.31
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 6835.0
                    rec_width[i] = 2.7
                    PE_alt[i] = 6834.9
                    alt_width[i] = 3.667
                    width_range[i] = 0.967 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 5326.9
                        alt_width[i] = 5.32
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 5498.0
                        alt_width[i] = 9.97
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 5592.7
                        alt_width[i] = 10.91
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 5884.6
                        alt_width[i] = 4.77
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 5903.3
                        alt_width[i] = 4.71
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 6530.7
                        alt_width[i] = 12.21
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 6599.0
                        alt_width[i] = 15.80
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 6617.5
                        alt_width[i] = 8.31
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 6715.1
                        alt_width[i] = 4.74
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 6719.0
                        alt_width[i] = 4.74
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 6811.9
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 6815.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 6440.0
                    rec_width[i] = 3.48
                    PE_alt[i] = 6440.7
                    alt_width[i] = 3.557
                    width_range[i] = 0.333 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 4935.3
                        alt_width[i] = 16.81
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 5104.0
                        alt_width[i] = 9.31
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 5200.4
                        alt_width[i] = 10.25
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 5489.25
                        alt_width[i] = 4.17
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 5510.0
                        alt_width[i] = 4.05
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 6135.95
                        alt_width[i] = 11.55
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 6204.0
                        alt_width[i] = 15.14
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 6223.8
                        alt_width[i] = 7.65
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 6322.8
                        alt_width[i] = 4.08
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 6325.84
                        alt_width[i] = 3.83
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 6433.7
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 6436.7
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 6403.15
                        alt_width[i] = 3.87
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 5964.0
                    rec_width[i] = 3.27
                    PE_alt[i] = 5954.65
                    alt_width[i] = 3.32
                    width_range[i] = 0.28 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 4453.4
                        alt_width[i] = 16.59
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 4628.2
                        alt_width[i] = 9.1
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 4724.6
                        alt_width[i] = 10.04
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 5013.32
                        alt_width[i] = 3.96
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 5033.7
                        alt_width[i] = 3.84
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 5660.0
                        alt_width[i] = 11.33
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 5726.0
                        alt_width[i] = 14.92
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 5748.06
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 5848.5
                        alt_width[i] = 3.87
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 5850.08
                        alt_width[i] = 3.62
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 5955.4
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 5721.1
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 5926.7
                        alt_width[i] = 3.66
                    elif transitionLine[i] == 'L3O2':
                        PE_alt[i] = 5940.8
                    elif transitionLine[i] == 'L3O3':
                        PE_alt[i] = 5940.8
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 1511.0
                    rec_width[i] = 11.8
                    PE_alt[i] = 1511.0
                    alt_width[i] = 12.655
                    width_range[i] = 0.855 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 1337.0
                    width[i] = 5.4
                    rec_width[i] = 4.5
                    PE_alt[i] = 1337.7
                    alt_width[i] = 5.255
                    width_range[i] = 0.755 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 1242.0
                    width[i] = 6.6
                    rec_width[i] = 6.7
                    PE_alt[i] = 1242.6
                    alt_width[i] = 6.825
                    width_range[i] = 0.3 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 1127.5
                        alt_width[i] = 7.73
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 1129.2
                        alt_width[i] = 7.48
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 948.3
                    rec_width[i] = 0.75
                    PE_alt[i] = 951.05
                    alt_width[i] = 0.81
                    width_range[i] = 0.06 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 715.34
                        alt_width[i] = 12.71
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 736.42
                        alt_width[i] = 5.22
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 950.75
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 928.8
                    rec_width[i] = 0.75
                    PE_alt[i] = 931.0
                    alt_width[i] = 0.75
                    width_range[i] = 1.25 #GUESS ZERO
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 715.2
                        alt_width[i] = 5.1
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 930.8
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 929.2
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 304.5
                    rec_width[i] = 3.7
                    PE_alt[i] = 304.75
                    alt_width[i] = 5.975
                    width_range[i] = 2.3 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 236.3
                    rec_width[i] = 5.08
                    PE_alt[i] = 236.65
                    alt_width[i] = 8.46
                    width_range[i] = 3.38 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 217.6
                    rec_width[i] = 1.75
                    PE_alt[i] = 217.8
                    alt_width[i] = 3.05
                    width_range[i] = 1.4 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 115.1
                    rec_width[i] = 0.78
                    PE_alt[i] = 115.03
                    alt_width[i] = 0.78
                    width_range[i] = 0.1 #GUESS
                    if transitionLine[i] == 'N4O2':
                        PE_alt[i] = 80.8
                    elif transitionLine[i] == 'N4N6':
                        PE_alt[i] = 109.5
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 115.1
                    rec_width[i] = 0.53
                    PE_alt[i] = 112.05
                    alt_width[i] = 0.53
                    width_range[i] = 0.1 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 2.0
                    PE_alt[i] = 2.0
                    alt_width[i] = 0.53
                    width_range[i] = 0.28 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 2.0
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 37.4
                    PE_alt[i] = 37.7
                    alt_width[i] = 0.57
                    width_range[i] = 0.1 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 22.3
                    PE_alt[i] = 23.3
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 22.3
                    PE_alt[i] = 22.1
                else:
                    PE_lit[i] = 41991.0


            elif element[i]== 'Nd':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 43569.0
                    width[i] = 17.1
                    rec_width[i] = 17.4
                    PE_alt[i] = 43568.95
                    alt_width[i] = 17.19
                    width_range[i] = 0.32 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 36445.1
                        alt_width[i] = 20.95
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 36847.7
                        alt_width[i] = 21.02
                        width_range[i] = 0.77
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 37361.0
                        alt_width[i] = 20.82
                        width_range[i] = 0.77
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 41993.8
                        alt_width[i] = 30.94
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 42166.5
                        alt_width[i] = 22.2
                        width_range[i] = 1.1
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 42271.0
                        alt_width[i] = 23.7
                        width_range[i] = 0.5
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 42569.0
                        alt_width[i] = 17.84
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 42592.8
                        alt_width[i] = 17.65
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 43254.5
                        alt_width[i] = 28.95
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 43322.0
                        alt_width[i] = 28.95
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 43344.9
                        alt_width[i] = 21.82
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 43449.2
                        alt_width[i] = 17.92
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 43452.3
                        alt_width[i] = 17.67
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 7126.0
                    rec_width[i] = 2.9
                    PE_alt[i] = 7126.0
                    alt_width[i] = 3.833
                    width_range[i] = 0.933 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 5548.7
                        alt_width[i] = 5.5
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 5722.9
                        alt_width[i] = 9.29
                        width_range[i] = 1.14
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 5829.0
                        alt_width[i] = 10.84
                        width_range[i] = 0.54
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 6125.5
                        alt_width[i] = 5.05
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 6148.81
                        alt_width[i] = 4.86
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 6809.4
                        alt_width[i] = 12.9
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 6883.7
                        alt_width[i] = 16.15
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 6900.47
                        alt_width[i] = 9.23
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 7004.1
                        alt_width[i] = 5.13
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 7007.2
                        alt_width[i] = 4.88
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 7122.1
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 7122.1
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 7088.2
                        alt_width[i] = 4.63
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 7106.6
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 7107.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 6722.0
                    rec_width[i] = 3.55
                    PE_alt[i] = 6721.75
                    alt_width[i] = 3.633
                    width_range[i] = 0.337 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 5146.1
                        alt_width[i] = 17.45
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 5320.3
                        alt_width[i] = 9.73
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 5424.4
                        alt_width[i] = 10.67
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 5721.0
                        alt_width[i] = 4.17
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 5744.6
                        alt_width[i] = 4.16
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 6405.8
                        alt_width[i] = 12.19
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 6474.0
                        alt_width[i] = 15.45
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 6496.8
                        alt_width[i] = 8.33
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 6601.0
                        alt_width[i] = 5.8
                        width_range[i] = 1.37
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 6604.15
                        alt_width[i] = 4.18
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 6714.16
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 6719.8
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 6682.0
                        alt_width[i] = 3.93
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 6208.0
                    rec_width[i] = 3.36
                    PE_alt[i] = 6207.95
                    alt_width[i] = 3.397
                    width_range[i] = 0.253 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 4633.0
                        alt_width[i] = 17.25
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 4807.1
                        alt_width[i] = 9.52
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 4912.2
                        alt_width[i] = 10.46
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 5208.3
                        alt_width[i] = 4.11
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 5230.8
                        alt_width[i] = 3.94
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 5893.45
                        alt_width[i] = 11.99
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 5963.1
                        alt_width[i] = 18.42
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 5988.8
                        alt_width[i] = 8.12
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 6087.8
                        alt_width[i] = 4.23
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 6090.96
                        alt_width[i] = 3.97
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 6202.34
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 6204.9
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 6170.3
                        alt_width[i] = 3.73
                    elif transitionLine[i] == 'L3O2':
                        PE_alt[i] = 6184.7
                    elif transitionLine[i] == 'L3O3':
                        PE_alt[i] = 6184.7
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 1575.0
                    rec_width[i] = 12.0
                    PE_alt[i] = 1575.65
                    alt_width[i] = 12.98
                    width_range[i] = 1.09 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 1403.0
                    width[i] = 4.7
                    rec_width[i] = 4.7
                    PE_alt[i] = 1402.9
                    alt_width[i] = 5.91
                    width_range[i] = 1.21 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 1297.0
                    width[i] = 8.0
                    rec_width[i] = 7.3
                    PE_alt[i] = 1297.7
                    alt_width[i] = 7.133
                    width_range[i] = 0.3 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 1158.42
                        alt_width[i] = 8.34
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 1180.2
                        alt_width[i] = 8.08
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 1003.3
                    rec_width[i] = 0.78
                    PE_alt[i] = 999.95
                    alt_width[i] = 1.047
                    width_range[i] = 0.343 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 754.54
                        alt_width[i] = 13.04
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 777.58
                        alt_width[i] = 5.91
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 998.0
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 979.18
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 980.4
                    rec_width[i] = 0.78
                    PE_alt[i] = 977.85
                    alt_width[i] = 0.853
                    width_range[i] = 0.7 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 754.5
                        alt_width[i] = 12.23
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 980.1
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 978.0
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 319.2
                    rec_width[i] = 4.0
                    PE_alt[i] = 315.6
                    alt_width[i] = 7.607
                    width_range[i] = 3.6 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 243.3
                    rec_width[i] = 5.1
                    PE_alt[i] = 243.65
                    alt_width[i] = 7.723
                    width_range[i] = 4.347 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 224.6
                    rec_width[i] = 1.9
                    PE_alt[i] = 224.8
                    alt_width[i] = 4.283
                    width_range[i] = 2.3 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 120.5
                    rec_width[i] = 1.05
                    PE_alt[i] = 119.63
                    alt_width[i] = 0.967
                    width_range[i] = 0.167 #GUESS
                    if transitionLine[i] == 'N4O2':
                        PE_alt[i] = 96.2
                    elif transitionLine[i] == 'N4N6':
                        PE_alt[i] = 116.0
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 120.5
                    rec_width[i] = 0.8
                    PE_alt[i] = 116.33
                    alt_width[i] = 0.8
                    width_range[i] = 0.1 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 1.5
                    PE_alt[i] = 2.0
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 1.5
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 37.5
                    PE_alt[i] = 37.75
                    alt_width[i] = 0.55
                    width_range[i] = 0.1 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 21.1
                    PE_alt[i] = 22.23
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 21.1
                    PE_alt[i] = 20.9
                else:
                    PE_lit[i] = 43569.0

            elif element[i]== 'Pm':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 45184.0
                    rec_width[i] = 18.5
                    PE_alt[i] = 41584.5
                    alt_width[i] = 18.337
                    width_range[i] = 0.327 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 37759.6
                        alt_width[i] = 22.22
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 38198.28
                        alt_width[i] = 22.0
                        width_range[i] = 0.53
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 38745.0
                        alt_width[i] = 21.7
                        width_range[i] = 0.52
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 43535.6
                        alt_width[i] = 32.6
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 43712.7
                        alt_width[i] = 24.69
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 43840.0
                        alt_width[i] = 24.99
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 44131.7
                        alt_width[i] = 19.09
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 44158.1
                        alt_width[i] = 18.83
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 44854.1
                        alt_width[i] = 27.37
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 44923.0
                        alt_width[i] = 30.14
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 44948.9
                        alt_width[i] = 23.53
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 45060.8
                        alt_width[i] = 19.4
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 45061.8
                        alt_width[i] = 19.13
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 7428.0
                    rec_width[i] = 3.1
                    PE_alt[i] = 7427.95
                    alt_width[i] = 3.99
                    width_range[i] = 0.89 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 5776.1
                        alt_width[i] = 5.68
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 5955.2
                        alt_width[i] = 10.89
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 6071.25
                        alt_width[i] = 11.18
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 6372.1
                        alt_width[i] = 5.28
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 6398.5
                        alt_width[i] = 5.02
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 7094.5
                        alt_width[i] = 13.56
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 7163.0
                        alt_width[i] = 16.34
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 7189.3
                        alt_width[i] = 9.73
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 7301.2
                        alt_width[i] = 5.59
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 7302.3
                        alt_width[i] = 5.32
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 7416.9
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 7013.0
                    rec_width[i] = 3.63
                    PE_alt[i] = 7012.9
                    alt_width[i] = 3.71
                    width_range[i] = 0.34 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 5363.0
                        alt_width[i] = 18.03
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 5542.1
                        alt_width[i] = 10.13
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 5656.5
                        alt_width[i] = 10.43
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 5961.5
                        alt_width[i] = 4.53
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 5985.4
                        alt_width[i] = 4.26
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 6681.4
                        alt_width[i] = 12.8
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 6750.0
                        alt_width[i] = 15.58
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 6776.2
                        alt_width[i] = 8.97
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 6892.05
                        alt_width[i] = 4.84
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 6889.17
                        alt_width[i] = 4.56
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 7003.78
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 6459.0
                    rec_width[i] = 3.44
                    PE_alt[i] = 6459.65
                    alt_width[i] = 3.473
                    width_range[i] = 0.277 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 4810.0
                        alt_width[i] = 17.84
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 4989.2
                        alt_width[i] = 9.94
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 5103.6
                        alt_width[i] = 10.24
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 5407.85
                        alt_width[i] = 4.34
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 5432.55
                        alt_width[i] = 4.08
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 6128.5
                        alt_width[i] = 12.61
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 6197.0
                        alt_width[i] = 15.39
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 6223.31
                        alt_width[i] = 8.78
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 6335.2
                        alt_width[i] = 4.64
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 6336.23
                        alt_width[i] = 4.38
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 6450.84
                elif photoelectronLine[i] == 'M1':
                    PE_alt[i] = 1649.3
                    alt_width[i] = 10.33
                    width_range[i] = 6.13 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 1471.0
                    rec_width[i] = 12.2
                    PE_alt[i] = 1471.7
                    alt_width[i] = 5.6
                    width_range[i] = 1.07 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 1357.0
                    rec_width[i] = 5.0
                    PE_alt[i] = 1356.95
                    alt_width[i] = 5.61
                    width_range[i] = 3.56 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 1211.85
                        alt_width[i] = 8.36
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 1276.31
                        alt_width[i] = 8.09
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 1052.0
                    rec_width[i] = 7.8
                    PE_alt[i] = 1051.75
                    alt_width[i] = 1.09
                    width_range[i] = 0.29 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 794.59
                        alt_width[i] = 13.2
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 819.73
                        alt_width[i] = 6.59
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 1050.7
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 1030.64
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 1027.0
                    rec_width[i] = 0.82
                    PE_alt[i] = 1026.95
                    alt_width[i] = 0.917
                    width_range[i] = 0.2 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 794.8
                        alt_width[i] = 9.33
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 1026.25
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 1025.72
                elif photoelectronLine[i] == 'N1':
                    BE_alt = 331.2
                    alt_width[i] = 9.35
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 242.0
                    rec_width[i] = 0.82
                    rec_width[i] = 5.13
                    PE_alt[i] = 250.57
                    alt_width[i] = 12.13
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 242.0
                    rec_width[i] = 2.05
                    PE_alt[i] = 238.4
                    alt_width[i] = 5.52
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 120.0
                    rec_width[i] = 1.38
                    PE_alt[i] = 123.0
                    alt_width[i] = 1.38
                    width_range[i] = 0.2 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 120.0
                    rec_width[i] = 1.11
                    PE_alt[i] = 119.0
                    alt_width[i] = 1.11
                    width_range[i] = 0.3 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_alt[i] = 3.75
                elif photoelectronLine[i] == 'O1':
                    PE_alt[i] = 37.00
                    alt_width[i] = 0.54
                    width_range[i] = 0.1 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_alt[i] = 23.25
                elif photoelectronLine[i] == 'O3':
                    PE_alt[i] = 21.05
                else:
                    PE_lit[i] = 45184.0


            elif element[i]== 'Sm':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 46834.0
                    width[i] = 19.8
                    rec_width[i] = 19.8
                    PE_alt[i] = 46834.6
                    alt_width[i] = 19.577
                    width_range[i] = 0.223 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 39101.2
                        alt_width[i] = 23.55
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 39523.2
                        alt_width[i] = 23.75
                        width_range[i] = 0.99
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 40118.6
                        alt_width[i] = 24.06
                        width_range[i] = 1.48
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 45110.3
                        alt_width[i] = 34.3
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 45288.0
                        alt_width[i] = 25.1
                        width_range[i] = 0.6
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 45413.0
                        alt_width[i] = 26.1
                        width_range[i] = 0.59
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 45728.1
                        alt_width[i] = 20.4
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 45756.9
                        alt_width[i] = 20.08
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 46488.6
                        alt_width[i] = 29.09
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 46530.0
                        alt_width[i] = 31.25
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 46588.2
                        alt_width[i] = 25.29
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 46709.1
                        alt_width[i] = 21.0
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 46706.4
                        alt_width[i] = 20.7
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 46801.0
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 46801.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 7737.0
                    rec_width[i] = 3.3
                    PE_alt[i] = 7736.9
                    alt_width[i] = 4.143
                    width_range[i] = 0.843 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 6009.1
                        alt_width[i] = 19.42
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 6196.15
                        alt_width[i] = 9.98
                        width_range[i] = 1.38
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 6317.6
                        alt_width[i] = 11.25
                        width_range[i] = 0.45
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 6629.3
                        alt_width[i] = 5.49
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 6657.6
                        alt_width[i] = 5.17
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 7387.5
                        alt_width[i] = 14.19
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 7466.85
                        alt_width[i] = 16.35
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 7486.76
                        alt_width[i] = 10.39
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 7608.0
                        alt_width[i] = 6.1
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 7605.2
                        alt_width[i] = 5.8
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 7729.0
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 7713.6
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 7713.7
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 7312.0
                    rec_width[i] = 3.7
                    PE_alt[i] = 7311.9
                    alt_width[i] = 3.793
                    width_range[i] = 0.357 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 5589.0
                        alt_width[i] = 18.61
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 5769.7
                        alt_width[i] = 10.55
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 5891.65
                        alt_width[i] = 10.89
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 6205.0
                        alt_width[i] = 4.5
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 6232.6
                        alt_width[i] = 4.38
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 6967.67
                        alt_width[i] = 13.4
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 7006.0
                        alt_width[i] = 15.55
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 7064.27
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 7178.0
                        alt_width[i] = 6.4
                        width_range[i] = 1.1
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 7182.12
                        alt_width[i] = 5.01
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 7301.27
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 7265.8
                        alt_width[i] = 4.06
                    elif transitionLine[i] == 'L2O2':
                        PE_alt[i] = 7288.0
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 7307.6
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 6716.0
                    rec_width[i] = 3.53
                    PE_alt[i] = 6716.6
                    alt_width[i] = 3.58
                    width_range[i] = 0.28 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 4993.0
                        alt_width[i] = 18.43
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 5174.6
                        alt_width[i] = 10.37
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 5297.0
                        alt_width[i] = 10.72
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 5608.6
                        alt_width[i] = 4.51
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 5636.0
                        alt_width[i] = 4.18
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 6369.66
                        alt_width[i] = 13.22
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 6411.0
                        alt_width[i] = 15.37
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 6469.72
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 1566.5
                        alt_width[i] = 5.13
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 6587.0
                        alt_width[i] = 6.13
                        width_range[i] = 1.3
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 6709
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 6679.05
                        alt_width[i] = 3.88
                    elif transitionLine[i] == 'L3O2':
                        PE_alt[i] = 6694.3
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 6712.55
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 1723.0
                    rec_width[i] = 12.4
                    PE_alt[i] = 1723.4
                    alt_width[i] = 13.83
                    width_range[i] = 1.43 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 1541.0
                    rec_width[i] = 5.2
                    PE_alt[i] = 1541.35
                    alt_width[i] = 6.507
                    width_range[i] = 1.307 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 1420.0
                    width[i] = 7.4
                    rec_width[i] = 8.1
                    PE_alt[i] = 1420.4
                    alt_width[i] = 7.587
                    width_range[i] = 0.513 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 1292.0
                        alt_width[i] = 9.14
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 1291.5
                        alt_width[i] = 8.84
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 1110.9
                    rec_width[i] = 0.86
                    PE_alt[i] = 1106.5
                    alt_width[i] = 1.013
                    width_range[i] = 0.167 #GUESS
                    if transitionLine[i] == 'M4N2':
                        alt_width[i] = 13.19
                    elif transitionLine[i] == 'M4N3':
                        alt_width[i] = 7.23
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 1100.0
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 1083.4
                    rec_width[i] = 0.86
                    PE_alt[i] = 1080.6
                    alt_width[i] = 1.107
                    width_range[i] = 1.1 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 832.0
                        alt_width[i] = 6.92
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 1082.6
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 1081.0
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 347.2
                    rec_width[i] = 4.4
                    PE_alt[i] = 346.35
                    alt_width[i] = 8.423
                    width_range[i] = 4.1 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 265.6
                    rec_width[i] = 5.16
                    PE_alt[i] = 266.3
                    alt_width[i] = 8.127
                    width_range[i] = 3.893 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 247.4
                    rec_width[i] = 2.2
                    PE_alt[i] = 248.2
                    alt_width[i] = 5.153
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 129.0
                    rec_width[i] = 1.78
                    PE_alt[i] = 128.83
                    alt_width[i] = 1.62
                    width_range[i] = 0.32 #GUESS
                    if transitionLine[i] == 'N4O2':
                        PE_alt[i] = 105.6
                    elif transitionLine[i] == 'N4N6':
                        PE_alt[i] = 126.0
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 129.0
                    rec_width[i] = 1.48
                    PE_alt[i] = 127.43
                    alt_width[i] = 1.42
                    width_range[i] = 0.4 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 5.2
                    PE_alt[i] = 6.25
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 5.2
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 37.4
                    PE_alt[i] = 38.2
                    alt_width[i] = 0.52
                    width_range[i] = 0.1 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 21.3
                    PE_alt[i] = 22.3
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 21.3
                    PE_alt[i] = 20.73
                    alt_width[i] = 0.2 #GUESS
                    width_range[i] = 0.1 #GUESS
                else:
                    PE_lit[i] = 46834.0


            elif element[i]== 'Eu':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 48519.0
                    rec_width[i] = 21.1
                    PE_alt[i] = 48159.0
                    alt_width[i] = 20.863
                    width_range[i] = 0.373 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 40470.1
                        alt_width[i] = 24.95
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 40902.16
                        alt_width[i] = 26.15
                        width_range[i] = 2.05
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 41542.31
                        alt_width[i] = 25.94
                        width_range[i] = 2.01
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 46718.4
                        alt_width[i] = 36.06
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 46904.0
                        alt_width[i] = 27.86
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 47038.2
                        alt_width[i] = 28.25
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 47358.3
                        alt_width[i] = 21.78
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 47389.4
                        alt_width[i] = 21.4
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 48157.3
                        alt_width[i] = 30.86
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 48220.0
                        alt_width[i] = 33.06
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 48259.0
                        alt_width[i] = 27.07
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 48382.0
                        alt_width[i] = 22.72
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 48384.3
                        alt_width[i] = 22.38
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 48497.0
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 48497.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 8052.0
                    rec_width[i] = 3.6
                    PE_alt[i] = 8052.0
                    alt_width[i] = 4.293
                    width_range[i] = 0.693 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 6248.4
                        alt_width[i] = 6.03
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 6438.7
                        alt_width[i] = 11.74
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 6371.53
                        alt_width[i] = 12.13
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 6890.3
                        alt_width[i] = 5.66
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 6919.6
                        alt_width[i] = 5.27
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 7687.8
                        alt_width[i] = 14.83
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 7768.0
                        alt_width[i] = 16.94
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 7795.1
                        alt_width[i] = 10.95
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 7911.9
                        alt_width[i] = 6.6
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 7914.2
                        alt_width[i] = 6.26
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 8040.1
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 8042.8  
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 8030.4
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 8030.45
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 7617.0
                    rec_width[i] = 3.77
                    PE_alt[i] = 7617.55
                    alt_width[i] = 3.87
                    width_range[i] = 0.43 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 5816.58
                        alt_width[i] = 19.18
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 6003.0
                        alt_width[i] = 10.98
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 6137.5
                        alt_width[i] = 11.37
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 6456.3
                        alt_width[i] = 4.9
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 6485.9
                        alt_width[i] = 4.52
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 7256.2
                        alt_width[i] = 13.98
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 7331.6
                        alt_width[i] = 16.18
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 7357.6
                        alt_width[i] = 10.19
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 7479.6
                        alt_width[i] = 5.84
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 7480.82
                        alt_width[i] = 5.5
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 7606.73
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 7609.4
                    elif transitionLine[i] == 'L2O2':
                        PE_alt[i] = 7595.7
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 7614.8
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 6977.0
                    rec_width[i] = 3.62
                    PE_alt[i] = 6976.95
                    alt_width[i] = 3.657
                    width_range[i] = 0.253 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 5177.2
                        alt_width[i] = 19.02
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 5363.2
                        alt_width[i] = 10.82
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 5498.0
                        alt_width[i] = 13.33
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 5816.55
                        alt_width[i] = 4.73
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 5846.0
                        alt_width[i] = 4.35
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 6616.0
                        alt_width[i] = 13.81
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 6687.0
                        alt_width[i] = 16.02
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 6717.81
                        alt_width[i] = 10.03
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 6840.0
                        alt_width[i] = 5.68
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 6842.0
                        alt_width[i] = 5.34
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 6966.92
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 6969.59
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 6945.3
                        alt_width[i] = 4.48
                    elif transitionLine[i] == 'L3O2':
                        PE_alt[i] = 6953.4
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 6976.3
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 1800.0
                    rec_width[i] = 12.6
                    PE_alt[i] = 1800.0
                    alt_width[i] = 14.373
                    width_range[i] = 1.773 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 1614.0
                    rec_width[i] = 5.4
                    PE_alt[i] = 1613.95
                    alt_width[i] = 7.047
                    width_range[i] = 1.647 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 1481.0
                    width[i] = 8.6
                    rec_width[i] = 8.2
                    PE_alt[i] = 1480.8
                    alt_width[i] = 7.923
                    width_range[i] = 0.277 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 1347.5
                        alt_width[i] = 9.99
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 1346.0
                        alt_width[i] = 9.65
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 1158.6
                    rec_width[i] = 0.9
                    PE_alt[i] = 1160.8
                    alt_width[i] = 1.35
                    width_range[i] = 0.51 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 877.15
                        alt_width[i] = 13.86
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 906.9
                        alt_width[i] = 7.87
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 1153.5
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 1136.59
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 1127.5
                    rec_width[i] = 0.9
                    PE_alt[i] = 1130.95
                    alt_width[i] = 0.98
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 872.0
                        alt_width[i] = 7.49
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 1131.0
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 1132.0
                    elif transitionLine[i] == 'M5O3':
                        PE_alt[i] = 1107.5
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 360.0
                    rec_width[i] = 4.6
                    PE_alt[i] = 360.1
                    alt_width[i] = 7.485
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 284.0
                    rec_width[i] = 5.2
                    PE_alt[i] = 283.95
                    alt_width[i] = 8.885
                    width_range[i] = 3.685 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 257.0
                    rec_width[i] = 2.35
                    PE_alt[i] = 256.8
                    alt_width[i] = 4.465
                    width_range[i] = 2.2 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 133.0
                    rec_width[i] = 2.2
                    PE_alt[i] = 133.6
                    alt_width[i] = 2.215
                    width_range[i] = 0.015 #GUESS
                    if transitionLine[i] == 'N4O2':
                        PE_alt[i] = 110.7
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 127.7
                    rec_width[i] = 1.9
                    PE_alt[i] = 133.6
                    alt_width[i] = 1.895
                    width_range[i] = 0.2 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 0.0
                    PE_alt[i] = 1.5
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 0.0
                    PE_alt[i] = 0.0
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 32.0
                    PE_alt[i] = 31.9
                    alt_width[i] = 1.03
                    width_range[i] = 0.2 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 22.0
                    PE_alt[i] = 23.07
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 22.0
                    PE_alt[i] = 21.47
                    alt_width[i] = 0.5 #GUESS
                    width_range[i] = 0.1 #GUESS
                else:
                    PE_lit[i] = 48519.0


            elif element[i]== 'Gd':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 50239.0
                    rec_width[i] = 22.4
                    PE_alt[i] = 50239.05
                    alt_width[i] = 22.177
                    width_range[i] = 0.347 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 41865.8
                        alt_width[i] = 26.43
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 42309.15
                        alt_width[i] = 27.25
                        width_range[i] = 1.71
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 42996.85
                        alt_width[i] = 26.6
                        width_range[i] = 1.21
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 48357.9
                        alt_width[i] = 37.64
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 48555.9
                        alt_width[i] = 28.0
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 48698.5
                        alt_width[i] = 29.65
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 49020.8
                        alt_width[i] = 23.16
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 49054.6
                        alt_width[i] = 22.78
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 49860.6
                        alt_width[i] = 32.47
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 49935.3
                        alt_width[i] = 30.63
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 49969.7
                        alt_width[i] = 28.69
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 50090.7
                        alt_width[i] = 23.98
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 50098.6
                        alt_width[i] = 23.92
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 50221.0
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 50221.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 8376.0
                    rec_width[i] = 3.8
                    PE_alt[i] = 8375.8
                    alt_width[i] = 4.483
                    width_range[i] = 0.683 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 6492.2
                        alt_width[i] = 20.4
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 6687.2
                        alt_width[i] = 10.6
                        width_range[i] = 1.7
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 6831.0
                        alt_width[i] = 11.95
                        width_range[i] = 0.75
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 7160.35
                        alt_width[i] = 5.93
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 7191.65
                        alt_width[i] = 5.55
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 7994.8
                        alt_width[i] = 15.23
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 8087.1
                        alt_width[i] = 13.39
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 8105.1
                        alt_width[i] = 11.46
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 8224.9
                        alt_width[i] = 6.74
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 8232.8
                        alt_width[i] = 6.6
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 8365.2
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 8368.5 
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 8355.0
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 8355.0
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 8373.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 7930.0
                    rec_width[i] = 3.87
                    PE_alt[i] = 7930.55
                    alt_width[i] = 3.967
                    width_range[i] = 0.353 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 6049.5
                        alt_width[i] = 19.52
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 6240.9
                        alt_width[i] = 11.38
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 6386.0
                        alt_width[i] = 11.82
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 6713.3
                        alt_width[i] = 4.84
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 6743.35
                        alt_width[i] = 4.66
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 7554.5
                        alt_width[i] = 14.35
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 7642.63
                        alt_width[i] = 12.51
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 7655.5
                        alt_width[i] = 10.57
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 7785.8
                        alt_width[i] = 6.85
                        width_range[i] = 1.02
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 7788.91
                        alt_width[i] = 5.8
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 7921.33
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 7924.64
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 7893.7
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 7924.95
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 7243.0
                    rec_width[i] = 3.72
                    PE_alt[i] = 7242.9
                    alt_width[i] = 3.76
                    width_range[i] = 0.25 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 5362.15
                        alt_width[i] = 19.36
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 5553.7
                        alt_width[i] = 11.21
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 5698.25
                        alt_width[i] = 11.66
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 6025.0
                        alt_width[i] = 4.89
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 6057.33
                        alt_width[i] = 4.48
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 6867.15
                        alt_width[i] = 14.19
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 6938.5
                        alt_width[i] = 12.34
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 6972.94
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 7095.9
                        alt_width[i] = 5.69
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 7102.3
                        alt_width[i] = 6.6
                        width_range[i] = 1.1
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 7234.19
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 7237.5
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 7207.15
                        alt_width[i] = 5.09
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 7237.45
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 1881.0
                    rec_width[i] = 12.8
                    PE_alt[i] = 1880.9
                    alt_width[i] = 14.87
                    width_range[i] = 2.07 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 1688.0
                    width[i] = 6.2
                    rec_width[i] = 5.6
                    PE_alt[i] = 1688.55
                    alt_width[i] = 7.193
                    width_range[i] = 1.593 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 1544.0
                    width[i] = 8.0
                    rec_width[i] = 8.3
                    PE_alt[i] = 1544.0
                    alt_width[i] = 8.237
                    width_range[i] = 0.127 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 1403.05
                        alt_width[i] = 10.26
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 1401.8
                        alt_width[i] = 10.12
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 1221.9
                    width[i] = 1.2
                    rec_width[i] = 0.95
                    PE_alt[i] = 1217.6
                    alt_width[i] = 1.16
                    width_range[i] = 0.74 #GUESS
                    if transitionLine[i] == 'M4N2':
                        alt_width[i] = 10.13
                    elif transitionLine[i] == 'M4N3':
                        alt_width[i] = 8.19
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 1209.9
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 1189.6
                    width[i] = 2.1
                    rec_width[i] = 0.95
                    PE_alt[i] = 1185.6
                    alt_width[i] = 1.267
                    width_range[i] = 0.7 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 914.0
                        alt_width[i] = 7.81
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 1189.5
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 1185.0
                    elif transitionLine[i] == 'M5O3':
                        PE_alt[i] = 1165.0
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 378.6
                    rec_width[i] = 4.9
                    PE_alt[i] = 375.9
                    alt_width[i] = 9.18
                    width_range[i] = 4.2 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 286.0
                    rec_width[i] = 5.23
                    PE_alt[i] = 288.75
                    alt_width[i] = 7.677
                    width_range[i] = 2.447 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 271.0
                    rec_width[i] = 2.5
                    PE_alt[i] = 270.95
                    alt_width[i] = 6.12
                    width_range[i] = 3.7 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 142.6
                    rec_width[i] = 2.45
                    PE_alt[i] = 138.67
                    alt_width[i] = 2.2
                    width_range[i] = 0.3 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 8.6
                    rec_width[i] = 2.2
                    PE_alt[i] = 1.05
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 8.6
                    PE_alt[i] = 0.1
                    #CHECK
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 36.0
                    PE_alt[i] = 36.05
                    alt_width[i] = 1.54
                    width_range[i] = 0.2 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 28.0
                    PE_alt[i] = 21.867
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 21.0
                    PE_alt[i] = 19.65
                    alt_width[i] = 0.5 #GUESS
                    width_range[i] = 0.1 #GUESS
                else:
                    PE_lit[i] = 50239.0


            elif element[i]== 'Tb':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 51996.0
                    rec_width[i] = 23.8
                    PE_alt[i] = 51995.85
                    alt_width[i] = 23.607
                    width_range[i] = 0.387 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 43291.4
                        alt_width[i] = 27.94
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 43744.8
                        alt_width[i] = 27.6
                        width_range[i] = 0.61
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 44482.35
                        alt_width[i] = 27.35
                        width_range[i] = 0.55
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 50035.5
                        alt_width[i] = 39.75
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 50229.9
                        alt_width[i] = 31.7
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 50383.0
                        alt_width[i] = 31.79
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 50722.7
                        alt_width[i] = 24.77
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 50757.8
                        alt_width[i] = 24.23
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 51600.7
                        alt_width[i] = 34.56
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 51678.3
                        alt_width[i] = 37.64
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 51714.0
                        alt_width[i] = 30.77
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 51837.5
                        alt_width[i] = 26.64
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 51846.4
                        alt_width[i] = 26.06
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 51965.0
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 51966.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 8708.0
                    rec_width[i] = 4.0
                    PE_alt[i] = 8708.0
                    alt_width[i] = 4.637
                    width_range[i] = 0.637 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 6744.2
                        alt_width[i] = 21.24
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 6940.4
                        alt_width[i] = 13.2
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 7096.0
                        alt_width[i] = 13.29
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 7436.1
                        alt_width[i] = 6.27
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 7468.0
                        alt_width[i] = 5.72
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 8310.0
                        alt_width[i] = 16.05
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 8397.6
                        alt_width[i] = 19.13
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 8423.8
                        alt_width[i] = 12.26
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 8546.2
                        alt_width[i] = 8.14
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 8555.0
                        alt_width[i] = 7.56
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 8694.9
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 8697.5
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 8669.6
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 8685.0
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 8684.9
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 8713.8
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 8252.0
                    rec_width[i] = 3.93
                    PE_alt[i] = 8251.8
                    alt_width[i] = 4.043
                    width_range[i] = 0.387 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 6284.0
                        alt_width[i] = 20.3
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 6487.4
                        alt_width[i] = 12.25
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 6643.5
                        alt_width[i] = 12.34
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 6976.5
                        alt_width[i] = 5.33
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 7009.4
                        alt_width[i] = 4.78
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 7853.45
                        alt_width[i] = 15.11
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 7936.0
                        alt_width[i] = 18.19
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 7968.0
                        alt_width[i] = 11.32
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 8102.0
                        alt_width[i] = 7.2
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 8100.81
                        alt_width[i] = 6.61
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 8240.74
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 8243.33
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 8212.2
                        alt_width[i] = 6.09
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 8246.15
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 7514.0
                    rec_width[i] = 3.8
                    PE_alt[i] = 7514.5
                    alt_width[i] = 3.85
                    width_range[i] = 0.27 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 5546.81
                        alt_width[i] = 20.16
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 5750.1
                        alt_width[i] = 12.11
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 5906.25
                        alt_width[i] = 12.2
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 6238.05
                        alt_width[i] = 5.18
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 6272.81
                        alt_width[i] = 4.64
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 7116.35
                        alt_width[i] = 14.97
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 7196.0
                        alt_width[i] = 18.05
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 7228.0
                        alt_width[i] = 11.18
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 7359.0
                        alt_width[i] = 7.05
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 7363.5
                        alt_width[i] = 6.47
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 7503.43
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 7506.02
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 7475.3
                        alt_width[i] = 5.94
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 7508.3
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 1968.0
                    rec_width[i] = 13.0
                    PE_alt[i] = 1967.75
                    alt_width[i] = 14.765
                    width_range[i] = 1.765 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 1768.0
                    width[i] = 5.3
                    rec_width[i] = 5.8
                    PE_alt[i] = 1767.85
                    alt_width[i] = 7.14
                    width_range[i] = 1.34 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 1611.0
                    width[i] = 8.0
                    rec_width[i] = 8.2
                    PE_alt[i] = 1611.65
                    alt_width[i] = 8.385
                    width_range[i] = 0.185 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 1462.4
                        alt_width[i] = 11.42
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 1461.1
                        alt_width[i] = 11.4
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 1276.9
                    rec_width[i] = 1.01
                    PE_alt[i] = 1275.5
                    alt_width[i] = 1.28
                    width_range[i] = 0.27 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 963.0
                        alt_width[i] = 16.06
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 997.96
                        alt_width[i] = 9.1
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 1266.1
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 1241.1
                    rec_width[i] = 1.01
                    PE_alt[i] = 1241.6
                    alt_width[i] = 1.01
                    width_range[i] = 0.9 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 955.3
                        alt_width[i] = 8.55
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 1241.15
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 1242.3
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 396.0
                    rec_width[i] = 5.1
                    PE_alt[i] = 397.95
                    alt_width[i] = 8.22
                    width_range[i] = 3.7 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 322.4
                    rec_width[i] = 5.26
                    PE_alt[i] = 310.6
                    alt_width[i] = 9.84
                    width_range[i] = 4.58 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 284.1
                    rec_width[i] = 2.65
                    PE_alt[i] = 285.5
                    alt_width[i] = 5.1
                    width_range[i] = 2.5 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 150.5
                    rec_width[i] = 2.7
                    PE_alt[i] = 149.83
                    alt_width[i] = 3.06
                    width_range[i] = 0.36 #GUESS
                    if transitionLine[i] == 'N4O2':
                        PE_alt[i] = 121.3
                    elif transitionLine[i] == 'N4N6':
                        PE_alt[i] = 144.0
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 150.5
                    rec_width[i] = 2.4
                    PE_alt[i] = 145.67
                    alt_width[i] = 2.62
                    width_range[i] = 0.4 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 7.7
                    PE_alt[i] = 3.2
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 2.4
                    PE_alt[i] = 2.4
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 45.6
                    PE_alt[i] = 39.5
                    alt_width[i] = 2.31
                    width_range[i] = 0.2 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 28.7
                    PE_alt[i] = 25.9
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 22.6
                    PE_alt[i] = 24.23
                    alt_width[i] = 0.8 #GUESS
                    width_range[i] = 0.2 #GUESS
                else:
                    PE_lit[i] = 51996.0


            elif element[i]== 'Dy':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 53789.0
                    rec_width[i] = 25.3
                    PE_alt[i] = 53788.25
                    alt_width[i] = 25.06
                    width_range[i] = 0.37 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 44744.3
                        alt_width[i] = 29.54
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 45208.15
                        alt_width[i] = 30.18
                        width_range[i] = 1.64
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 45999.0
                        alt_width[i] = 30.57
                        width_range[i] = 2.16
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 51745.4
                        alt_width[i] = 41.67
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 51959.0
                        alt_width[i] = 32.77
                        width_range[i] = 0.77
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 52120.0
                        alt_width[i] = 33.1
                        width_range[i] = 0.56
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 52457.4
                        alt_width[i] = 26.38
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 52494.8
                        alt_width[i] = 25.75
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 53372.0
                        alt_width[i] = 36.51
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 53451.7
                        alt_width[i] = 39.53
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 53483.2
                        alt_width[i] = 32.69
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 53619.4
                        alt_width[i] = 28.79
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 53629.4
                        alt_width[i] = 28.07
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 53774.0
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 53775.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 9046.0
                    rec_width[i] = 4.3
                    PE_alt[i] = 9046.4
                    alt_width[i] = 4.8
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 7001.1
                        alt_width[i] = 21.84
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 7203.93
                        alt_width[i] = 11.66
                        width_range[i] = 2.06
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 7370.45
                        alt_width[i] = 12.67
                        width_range[i] = 1.17
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 7711.9
                        alt_width[i] = 6.54
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 7747.9
                        alt_width[i] = 5.92
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 8619.0
                        alt_width[i] = 16.68
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 8714.05
                        alt_width[i] = 19.69
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 8753.27
                        alt_width[i] = 12.85
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 8875.1
                        alt_width[i] = 8.96
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 8887.1
                        alt_width[i] = 8.24
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 9035.2
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 9037.6
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 9019.5
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 9019.5
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 8581.0
                    rec_width[i] = 4.01
                    PE_alt[i] = 8580.8
                    alt_width[i] = 4.14
                    width_range[i] = 0.41 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 6534.21
                        alt_width[i] = 20.84
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 6738.6
                        alt_width[i] = 12.71
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 6905.65
                        alt_width[i] = 12.83
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 7247.75
                        alt_width[i] = 5.25
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 7277.25
                        alt_width[i] = 4.92
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 8166.2
                        alt_width[i] = 15.68
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 8242.6
                        alt_width[i] = 18.7
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 8286.45
                        alt_width[i] = 11.86
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 8418.46
                        alt_width[i] = 8.13
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 8420.27
                        alt_width[i] = 7.62
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 8570.38
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 8572.85
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 8575.3
                        alt_width[i] = 6.94
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 8246.15
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 7790.0
                    rec_width[i] = 3.9
                    PE_alt[i] = 7790.05
                    alt_width[i] = 3.933
                    width_range[i] = 0.237 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 5742.5
                        alt_width[i] = 20.71
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 5948.3
                        alt_width[i] = 12.57
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 6114.75
                        alt_width[i] = 12.7
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 6457.71
                        alt_width[i] = 5.38
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 6495.28
                        alt_width[i] = 4.80
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 7370.53
                        alt_width[i] = 15.55
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 7439.0
                        alt_width[i] = 18.57
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 7494.8
                        alt_width[i] = 11.73
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 7620.0
                        alt_width[i] = 7.82
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 7629.92
                        alt_width[i] = 7.5
                        width_range[i] = 0.4
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 7780.03
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 7782.5
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 7726.8
                        alt_width[i] = 6.81
                    elif transitionLine[i] == 'L3O2':
                        PE_alt[i] = 7764.6
                    elif transitionLine[i] == 'L3O3':
                        PE_alt[i] = 7764.6
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 7805.5
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 2047.0
                    rec_width[i] = 13.2
                    PE_alt[i] = 2046.9
                    alt_width[i] = 15.73
                    width_range[i] = 2.53 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 1842.0
                    width[i] = 6.5
                    rec_width[i] = 6.0
                    PE_alt[i] = 1841.9
                    alt_width[i] = 8.287
                    width_range[i] = 2.287 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 1676.0
                    rec_width[i] = 8.0
                    PE_alt[i] = 1675.8
                    alt_width[i] = 8.99
                    width_range[i] = 1.01 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 1522.0
                        alt_width[i] = 13.07
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 1525.0
                        alt_width[i] = 12.35
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 1333.0
                    rec_width[i] = 1.065
                    PE_alt[i] = 1332.25
                    alt_width[i] = 1.385
                    width_range[i] = 0.32 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1007.22
                        alt_width[i] = 16.53
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 1045.04
                        alt_width[i] = 9.69
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 1325.0
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 1292.6
                    rec_width[i] = 1.065
                    PE_alt[i] = 1294.95
                    alt_width[i] = 1.475
                    width_range[i] = 0.7 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 998.0
                        alt_width[i] = 9.06
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 1293.0
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 1295.6
                    elif transitionLine[i] == 'M5O3':
                        PE_alt[i] = 1272.1
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 414.2
                    rec_width[i] = 5.4
                    PE_alt[i] = 416.15
                    alt_width[i] = 10.407
                    width_range[i] = 5.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 333.5
                    rec_width[i] = 5.3
                    PE_alt[i] = 331.9
                    alt_width[i] = 10.047
                    width_range[i] = 4.793 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 293.2
                    rec_width[i] = 2.8
                    PE_alt[i] = 292.95
                    alt_width[i] = 6.933
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 153.6
                    rec_width[i] = 2.95
                    PE_alt[i] = 156.53
                    alt_width[i] = 3.683
                    width_range[i] = 0.733 #GUESS
                    if transitionLine[i] == 'N4O2':
                        PE_alt[i] = 128.0
                    elif transitionLine[i] == 'N4N6':
                        PE_alt[i] = 149.0
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 153.6
                    rec_width[i] = 2.6
                    PE_alt[i] = 152.53
                    alt_width[i] = 2.99
                    width_range[i] = 0.5 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 8.0
                    PE_alt[i] = 4.57
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 4.3
                    PE_alt[i] = 3.83
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 49.9
                    PE_alt[i] = 62.95
                    alt_width[i] = 3.08
                    width_range[i] = 0.8 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 26.3
                    PE_alt[i] = 26.83
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 26.3
                    PE_alt[i] = 24.45
                    alt_width[i] = 1.0 #GUESS
                    width_range[i] = 0.4 #GUESS
                else:
                    PE_lit[i] = 53789.0


            elif element[i]== 'Ho':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 55618.0
                    rec_width[i] = 26.9
                    PE_alt[i] = 55617.85
                    alt_width[i] = 26.64
                    width_range[i] = 0.42 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 46225.6
                        alt_width[i] = 31.2
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 46699.9
                        alt_width[i] = 30.82
                        width_range[i] = 0.74
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 47547.0
                        alt_width[i] = 30.76
                        width_range[i] = 0.72
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 53489.7
                        alt_width[i] = 43.66
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 53711.5
                        alt_width[i] = 35.44
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 83877.0
                        alt_width[i] = 35.61
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 54227.4
                        alt_width[i] = 28.06
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 54267.1
                        alt_width[i] = 27.34
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 55188.2
                        alt_width[i] = 38.51
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 55271.2
                        alt_width[i] = 42.38
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 55312.1
                        alt_width[i] = 34.65
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 55442.0
                        alt_width[i] = 30.93
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 554543.7
                        alt_width[i] = 30.16
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 55584.0
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 55584.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 9394.0
                    rec_width[i] = 4.5
                    PE_alt[i] = 9394.6
                    alt_width[i] = 4.937
                    width_range[i] = 0.437 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 7264.1
                        alt_width[i] = 22.43
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 7471.1
                        alt_width[i] = 14.21
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 7652.0
                        alt_width[i] = 14.38
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 8006.0
                        alt_width[i] = 6.83
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 8044.61
                        alt_width[i] = 6.1
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 8962.6
                        alt_width[i] = 17.28
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 9051.0
                        alt_width[i] = 21.15
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 9087.6
                        alt_width[i] = 13.41
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 9216.4
                        alt_width[i] = 9.7
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 9228.1
                        alt_width[i] = 8.93
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 9382.7
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 9385.0
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 9345.1
                        alt_width[i] = 8.84
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 9374.0
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 9374.5
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 9387.0
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 9386.9
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 8918.0
                    rec_width[i] = 4.09
                    PE_alt[i] = 8918.4
                    alt_width[i] = 4.23
                    width_range[i] = 0.43 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 6788.35
                        alt_width[i] = 21.39
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 6995.9
                        alt_width[i] = 13.17
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 7176.5
                        alt_width[i] = 13.34
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 7525.5
                        alt_width[i] = 5.79
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 7566.1
                        alt_width[i] = 5.06
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 8481.55
                        alt_width[i] = 16.24
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 8570.2
                        alt_width[i] = 20.1
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 8593.0
                        alt_width[i] = 12.37
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 8747.2
                        alt_width[i] = 8.66
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 8752.71
                        alt_width[i] = 7.89
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 8907.28
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 8909.6
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 8866.95
                        alt_width[i] = 7.8
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 8905.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 8071.0
                    rec_width[i] = 4.0
                    PE_alt[i] = 8071.05
                    alt_width[i] = 4.027
                    width_range[i] = 0.233 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 5943.45
                        alt_width[i] = 21.27
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 6155.0
                        alt_width[i] = 13.05
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 6333.25
                        alt_width[i] = 13.22
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 6679.55
                        alt_width[i] = 5.67
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 6719.85
                        alt_width[i] = 4.95
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 7635.9
                        alt_width[i] = 16.12
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 7727.08
                        alt_width[i] = 19.99
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 7763.25
                        alt_width[i] = 12.25
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 7906.5
                        alt_width[i] = 8.54
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 7911.25
                        alt_width[i] = 7.77
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 8060.83
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 8063.15
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 8062.0
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 8062.3
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 2128.0
                    rec_width[i] = 13.4
                    PE_alt[i] = 2128.15
                    alt_width[i] = 16.383
                    width_range[i] = 2.983 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 1923.0
                    width[i] = 6.3
                    rec_width[i] = 6.3
                    PE_alt[i] = 1922.9
                    alt_width[i] = 8.64
                    width_range[i] = 2.34 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 1741.0
                    width[i] = 6.7
                    rec_width[i] = 7.8
                    PE_alt[i] = 1741.1
                    alt_width[i] = 9.133
                    width_range[i] = 1.333 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 1554.9
                        alt_width[i] = 14.11
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 1562.3
                        alt_width[i] = 13.34
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 1392.0
                    rec_width[i] = 1.13
                    PE_alt[i] = 1391.25
                    alt_width[i] = 1.797
                    width_range[i] = 0.613 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1052.15
                        alt_width[i] = 18.01
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 1093.0
                        alt_width[i] = 10.27
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 1383.0
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 1361.3
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 1351.0
                    rec_width[i] = 1.13
                    PE_alt[i] = 1351.2
                    alt_width[i] = 1.213
                    width_range[i] = 0.3 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 1042.05
                        alt_width[i] = 9.55
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 1345.6
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 1344.5
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 432.4
                    rec_width[i] = 5.6
                    PE_alt[i] = 435.85
                    alt_width[i] = 8.95
                    width_range[i] = 4.5 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 343.5
                    rec_width[i] = 5.33
                    PE_alt[i] = 343.25
                    alt_width[i] = 10.745
                    width_range[i] = 5.415 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 308.2
                    rec_width[i] = 2.95
                    PE_alt[i] = 306.3
                    alt_width[i] = 5.69
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 160.0
                    rec_width[i] = 3.15
                    PE_alt[i] = 161.27
                    alt_width[i] = 3.935
                    width_range[i] = 0.785 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 160.0
                    rec_width[i] = 2.8
                    PE_alt[i] = 158.75
                    alt_width[i] = 3.375
                    width_range[i] = 0.6 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 8.6
                    PE_alt[i] = 4.17
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 5.2
                    PE_alt[i] = 3.5
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 49.3
                    PE_alt[i] = 51.1
                    alt_width[i] = 3.85
                    width_range[i] = 0.4 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 30.8
                    PE_alt[i] = 21.73
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 24.1
                    PE_alt[i] = 19.75
                    alt_width[i] = 1.0 #GUESS
                    width_range[i] = 0.1 #GUESS
                else:
                    PE_lit[i] = 55618.0


            elif element[i]== 'Er':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 57486.0
                    width[i] = 28.6
                    rec_width[i] = 28.5
                    PE_alt[i] = 57485.75
                    alt_width[i] = 28.243
                    width_range[i] = 0.257 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 47736.8
                        alt_width[i] = 32.95
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 48221.5
                        alt_width[i] = 33.49
                        width_range[i] = 1.63
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 49127.5
                        alt_width[i] = 33.95
                        width_range[i] = 3.45
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 55270.1
                        alt_width[i] = 45.71
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 55494.0
                        alt_width[i] = 36.05
                        width_range[i] = 0.36
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 55682.0
                        alt_width[i] = 37.05
                        width_range[i] = 0.75
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 56034.5
                        alt_width[i] = 29.84
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 56076.6
                        alt_width[i] = 29.03
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 57037.5
                        alt_width[i] = 40.61
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 57123.3
                        alt_width[i] = 44.51
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 57167.0
                        alt_width[i] = 36.68
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 57301.1
                        alt_width[i] = 33.45
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 57313.3
                        alt_width[i] = 32.38
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 5745.0
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 57448.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 9751.0
                    rec_width[i] = 4.7
                    PE_alt[i] = 9751.65
                    alt_width[i] = 5.183
                    width_range[i] = 0.483 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 7538.0
                        alt_width[i] = 22.9
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 7744.9
                        alt_width[i] = 12.3
                        width_range[i] = 2.4
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 7939.0
                        alt_width[i] = 13.3
                        width_range[i] = 1.5
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 8300.0
                        alt_width[i] = 7.12
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 8343.0
                        alt_width[i] = 6.31
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 9300.7
                        alt_width[i] = 6.4
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 9385.7
                        alt_width[i] = 21.79
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 9431.15
                        alt_width[i] = 13.97
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 9564.3
                        alt_width[i] = 10.74
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 9576.5
                        alt_width[i] = 9.67
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 9738.6
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 9740.7
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 9690.2
                        alt_width[i] = 9.39
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 9722.0
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 9723.4
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 9752.3
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 9752.3
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 9264.0
                    rec_width[i] = 4.18
                    PE_alt[i] = 9264.65
                    alt_width[i] = 4.313
                    width_range[i] = 0.417 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 7057.5
                        alt_width[i] = 21.9
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 7259.3
                        alt_width[i] = 13.62
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 7427.8
                        alt_width[i] = 13.68
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 7810.9
                        alt_width[i] = 6.04
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 7853.6
                        alt_width[i] = 5.22
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 8813.5
                        alt_width[i] = 16.81
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 8900.3
                        alt_width[i] = 20.71
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 8946.85
                        alt_width[i] = 12.88
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 9086.0
                        alt_width[i] = 9.65
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 9090.26
                        alt_width[i] = 8.58
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 9252.38
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 9254.5
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 9225.0
                        alt_width[i] = 8.31
                    elif transitionLine[i] == 'L2O2':
                        PE_alt[i] = 9234.5
                    elif transitionLine[i] == 'L2O3':
                        PE_alt[i] = 9234.5
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 9255.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 8358.0
                    rec_width[i] = 4.1
                    PE_alt[i] = 8357.95
                    alt_width[i] = 4.123
                    width_range[i] = 0.227 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 6152.5
                        alt_width[i] = 21.8
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 6353.6
                        alt_width[i] = 13.51
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 6447.6
                        alt_width[i] = 13.57
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 6905.0
                        alt_width[i] = 5.83
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 6949.0
                        alt_width[i] = 5.15
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 7909.0
                        alt_width[i] = 16.7
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 7994.6
                        alt_width[i] = 20.6
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 8038.29
                        alt_width[i] = 12.77
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 8180.0
                        alt_width[i] = 9.54
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 8189.4
                        alt_width[i] = 8.47
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 8346.63
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 8348.75
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 7297.0
                        alt_width[i] = 8.2
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 8350.0
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 8350.2
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 2207.0
                    rec_width[i] = 13.6
                    PE_alt[i] = 2206.85
                    alt_width[i] = 16.823
                    width_range[i] = 3.223 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 2006.0
                    width[i] = 3.7
                    rec_width[i] = 6.6
                    PE_alt[i] = 2005.9
                    alt_width[i] = 9.06
                    width_range[i] = 2.46 #GUESS
                    if transitionLine[i] == 'M2N4':
                        PE_alt[i] = 1830.0
                        alt_width[i] = 15.2
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 1812.0
                    width[i] = 7.8
                    rec_width[i] = 7.5
                    PE_alt[i] = 1811.9
                    alt_width[i] = 9.06
                    width_range[i] = 1.94 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 1634.0
                        alt_width[i] = 15.2
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 1645.0
                        alt_width[i] = 14.2
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 1453.0
                    width[i] = 1.2
                    rec_width[i] = 1.2
                    PE_alt[i] = 1453.15
                    alt_width[i] = 1.537
                    width_range[i] = 0.473 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1097.96
                        alt_width[i] = 18.68
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 1142.03
                        alt_width[i] = 10.86
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 1443.2
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 1420.27
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 1409.0
                    width[i] = 2.1
                    rec_width[i] = 1.2
                    PE_alt[i] = 1409.15
                    alt_width[i] = 1.633
                    width_range[i] = 0.867 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 1090.2
                        alt_width[i] = 10.05
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 1402.24
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 1401.06
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 449.8
                    rec_width[i] = 5.8
                    PE_alt[i] = 449.05
                    alt_width[i] = 11.193
                    width_range[i] = 6.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 366.2
                    rec_width[i] = 5.36
                    PE_alt[i] = 366.1
                    alt_width[i] = 11.347
                    width_range[i] = 5.987 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 320.2
                    rec_width[i] = 3.15
                    PE_alt[i] = 320.0
                    alt_width[i] = 8.0
                    width_range[i] = 5.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 167.6
                    rec_width[i] = 3.35
                    PE_alt[i] = 176.85
                    alt_width[i] = 4.923
                    width_range[i] = 1.573 #GUESS
                    if transitionLine[i] == 'N4O2':
                        PE_alt[i] = 171.0
                    elif transitionLine[i] == 'N4N6':
                        PE_alt[i] = 163.0
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 167.6
                    rec_width[i] = 2.95
                    PE_alt[i] = 167.8
                    alt_width[i] = 4.433
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 4.7
                    PE_alt[i] = 3.8
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 50.6
                    PE_alt[i] = 59.9
                    alt_width[i] = 4.28
                    width_range[i] = 0.5 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 31.4
                    PE_alt[i] = 28.77
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 24.7
                    PE_alt[i] = 25.65
                    alt_width[i] = 1.0 #GUESS
                    width_range[i] = 0.1 #GUESS
                else:
                    PE_lit[i] = 57486.0


            elif element[i]== 'Tm':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 59390.0
                    rec_width[i] = 30.2
                    PE_alt[i] = 59389.8
                    alt_width[i] = 29.937
                    width_range[i] = 0.427 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 49275.0
                        alt_width[i] = 35.67
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 49773.0
                        alt_width[i] = 34.15
                        width_range[i] = 0.75
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 50741.8
                        alt_width[i] = 34.1
                        width_range[i] = 0.66
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 57085.6
                        alt_width[i] = 47.77
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 57304.0
                        alt_width[i] = 39.45
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 57517.0
                        alt_width[i] = 39.57
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 57877.6
                        alt_width[i] = 31.68
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 57922.3
                        alt_width[i] = 30.78
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 58923.4
                        alt_width[i] = 42.77
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 59012.3
                        alt_width[i] = 47.5
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 59058.9
                        alt_width[i] = 38.76
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 59197.7
                        alt_width[i] = 35.87
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 59209.8
                        alt_width[i] = 34.69
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 59346.0
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 59346.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 10116.0
                    rec_width[i] = 4.9
                    PE_alt[i] = 10115.85
                    alt_width[i] = 5.51
                    width_range[i] = 0.65 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 7814.0
                        alt_width[i] = 24.42
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 8025.85
                        alt_width[i] = 16.1
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 8230.8
                        alt_width[i] = 16.23
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 86002.0
                        alt_width[i] = 8.33
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 8648.4
                        alt_width[i] = 7.43
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 9645.0
                        alt_width[i] = 19.43
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 9730.1
                        alt_width[i] = 24.15
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 9779.0
                        alt_width[i] = 15.41
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 9921.0
                        alt_width[i] = 12.52
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 9933.1
                        alt_width[i] = 11.35
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 10102.9
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 10104.8
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 10054.2
                        alt_width[i] = 10.86
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 10084.0
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 10084.0
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 10110.0
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 10110.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 9617.0
                    rec_width[i] = 4.26
                    PE_alt[i] = 9617.45
                    alt_width[i] = 4.39
                    width_range[i] = 0.4 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 7309.0
                        alt_width[i] = 22.38
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 7529.0
                        alt_width[i] = 14.06
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 7728.3
                        alt_width[i] = 14.18
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 8101.1
                        alt_width[i] = 6.29
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 8146.0
                        alt_width[i] = 5.39
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 9144.6
                        alt_width[i] = 17.38
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 9225.25
                        alt_width[i] = 22.11
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 9290.0
                        alt_width[i] = 13.37
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 9426.0
                        alt_width[i] = 10.48
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 9436.0
                        alt_width[i] = 9.3
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 9605.83
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 9607.72
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 10052.6
                        alt_width[i] = 8.82
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 9607.45
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 8648.0
                    rec_width[i] = 4.2
                    PE_alt[i] = 8648.0
                    alt_width[i] = 4.237
                    width_range[i] = 0.243 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 6342.0
                        alt_width[i] = 22.28
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 6557.45
                        alt_width[i] = 13.97
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 7178.0
                        alt_width[i] = 5.3
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 7133.2
                        alt_width[i] = 6.2
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 7180.0
                        alt_width[i] = 5.3
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 8177.15
                        alt_width[i] = 17.29
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 8263.1
                        alt_width[i] = 22.02
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 8316.72
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 8455.6
                        alt_width[i] = 10.39
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 8468.0
                        alt_width[i] = 9.21
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 8637.46
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 8639.35
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 8584.9
                        alt_width[i] = 8.72
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 8641.0
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 8640.9
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 2307.0
                    width[i] = 12.6
                    rec_width[i] = 13.8
                    PE_alt[i] = 2306.9
                    alt_width[i] = 16.03
                    width_range[i] = 2.23 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 2090.0
                    width[i] = 5.6
                    rec_width[i] = 6.85
                    PE_alt[i] = 2089.9
                    alt_width[i] = 8.395
                    width_range[i] = 1.545 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 1885.0
                    width[i] = 7.4
                    rec_width[i] = 7.1
                    PE_alt[i] = 1884.75
                    alt_width[i] = 8.58
                    width_range[i] = 1.48 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 1678.15
                        alt_width[i] = 16.43
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 1686.77
                        alt_width[i] = 15.25
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 1515.0
                    width[i] = 1.2
                    rec_width[i] = 1.27
                    PE_alt[i] = 1514.8
                    alt_width[i] = 1.72
                    width_range[i] = 0.45 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1144.6
                        alt_width[i] = 20.16
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 1192.1
                        alt_width[i] = 11.42
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 1503.0
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 1480.4
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 1468.0
                    width[i] = 2.1
                    rec_width[i] = 1.27
                    PE_alt[i] = 1467.85
                    alt_width[i] = 1.27
                    width_range[i] = 0.3 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 1137.5
                        alt_width[i] = 10.52
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 1460.1
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 1458.8
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 470.9
                    rec_width[i] = 6.1
                    PE_alt[i] = 471.85
                    alt_width[i] = 9.68
                    width_range[i] = 3.7 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 385.9
                    rec_width[i] = 5.4
                    PE_alt[i] = 385.95
                    alt_width[i] = 11.695
                    width_range[i] = 6.295 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 332.6
                    rec_width[i] = 3.3
                    PE_alt[i] = 336.8
                    alt_width[i] = 6.275
                    width_range[i] = 3.1 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 175.5
                    rec_width[i] = 3.55
                    PE_alt[i] = 181.7
                    alt_width[i] = 4.955
                    width_range[i] = 1.405 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 175.5
                    rec_width[i] = 3.1
                    PE_alt[i] = 177.85
                    alt_width[i] = 4.125
                    width_range[i] = 1.1 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 4.6
                    PE_alt[i] = 5.0
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 54.7
                    PE_alt[i] = 44.1
                    alt_width[i] = 4.7
                    width_range[i] = 0.8 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 31.8
                    PE_alt[i] = 33.5
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 25.0
                    PE_alt[i] = 31.57
                    alt_width[i] = 1.0 #GUESS
                    width_range[i] = 0.4 #GUESS
                else:
                    PE_lit[i] = 59390.0


            elif element[i]== 'Yb':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 61332.0
                    width[i] = 30.3
                    rec_width[i] = 32.0
                    PE_alt[i] = 61332.15
                    alt_width[i] = 31.72
                    width_range[i] = 0.46 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 50987.0
                        alt_width[i] = 39.31
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 51355.0
                        alt_width[i] = 37.6
                        width_range[i] = 3.0
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 52389.25
                        alt_width[i] = 38.01
                        width_range[i] = 3.99
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 58937.5
                        alt_width[i] = 49.96
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 59152.0
                        alt_width[i] = 41.35
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 59370.0
                        alt_width[i] = 41.58
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 59758.2
                        alt_width[i] = 33.61
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 59805.4
                        alt_width[i] = 32.61
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 60847.3
                        alt_width[i] = 45.01
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 60939.1
                        alt_width[i] = 50.14
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 60988.5
                        alt_width[i] = 40.91
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 91132.8
                        alt_width[i] = 38.52
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 61144.8
                        alt_width[i] = 37.11
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 61298.0
                        alt_width[i] = 31.31
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 61299.0
                        alt_width[i] = 31.27
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 10486.0
                    rec_width[i] = 5.2
                    PE_alt[i] = 10487.2
                    alt_width[i] = 6.257
                    width_range[i] = 1.783 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 8091.0
                        alt_width[i] = 26.74
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 8313.2
                        alt_width[i] = 14.68
                        width_range[i] = 3.68
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 8536.6
                        alt_width[i] = 15.38
                        width_range[i] = 3.18
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 8910.0
                        alt_width[i] = 10.39
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 8959.0
                        alt_width[i] = 9.39
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 10015.0
                        alt_width[i] = 21.79
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 10095.0
                        alt_width[i] = 26.92
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 10143.2
                        alt_width[i] = 17.69
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 10286.3
                        alt_width[i] = 15.3
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 10298.3
                        alt_width[i] = 13.89
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 10475.9
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 10477.7
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 10431.25
                        alt_width[i] = 13.16
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 10469.0
                        alt_width[i] = 8.08
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 10475.0
                        alt_width[i] = 8.05
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 10483.15
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 10483.15
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 9978.0
                    rec_width[i] = 4.36
                    PE_alt[i] = 9978.1
                    alt_width[i] = 4.463
                    width_range[i] = 0.357 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 7580.2
                        alt_width[i] = 22.91
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 7805.5
                        alt_width[i] = 14.54
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 8026.0
                        alt_width[i] = 14.71
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 8401.5
                        alt_width[i] = 6.23
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 8450.8
                        alt_width[i] = 5.56
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 9491.05
                        alt_width[i] = 17.96
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 9584.4
                        alt_width[i] = 23.08
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 9633.0
                        alt_width[i] = 13.86
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 9780.5
                        alt_width[i] = 10.3
                        width_range[i] = 1.2
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 9790.13
                        alt_width[i] = 10.05
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 9972.8
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 9969.53
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 9924.75
                        alt_width[i] = 9.33
                    elif transitionLine[i] == 'L2O2':
                        PE_alt[i] = 9956.1
                        alt_width[i] = 4.25
                    elif transitionLine[i] == 'L2O3':
                        PE_alt[i] = 9956.0
                        alt_width[i] = 4.22
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 9976.6
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 8944.0
                    rec_width[i] = 4.31
                    PE_alt[i] = 8943.3
                    alt_width[i] = 4.347
                    width_range[i] = 0.253 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 6545.5
                        alt_width[i] = 22.83
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 677.61
                        alt_width[i] = 14.46
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 6992.0
                        alt_width[i] = 14.64
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 7367.2
                        alt_width[i] = 6.35
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 7415.2
                        alt_width[i] = 5.44
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 8456.3
                        alt_width[i] = 17.88
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 8550.0
                        alt_width[i] = 23.0
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 8599.45
                        alt_width[i] = 13.78
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 8743.73
                        alt_width[i] = 11.39
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 8757.0
                        alt_width[i] = 9.28
                        width_range[i] = 0.7
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 8933.35
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 8935.09
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 8888.9
                        alt_width[i] = 9.25
                    elif transitionLine[i] == 'L3O2':
                        PE_alt[i] = 8920.9
                        alt_width[i] = 4.17
                    elif transitionLine[i] == 'L3O3':
                        PE_alt[i] = 8921.6
                        alt_width[i] = 4.14
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 8940.0
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 8940.0
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 2398.0
                    rec_width[i] = 13.9
                    PE_alt[i] = 2397.55
                    alt_width[i] = 17.8
                    width_range[i] = 3.9 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 2173.0
                    width[i] = 4.3
                    rec_width[i] = 7.1
                    PE_alt[i] = 2172.5
                    alt_width[i] = 9.74
                    width_range[i] = 2.64 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 1950.0
                    width[i] = 7.5
                    rec_width[i] = 6.7
                    PE_alt[i] = 1949.0
                    alt_width[i] = 9.6
                    width_range[i] = 2.9 #GUESS
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 1465.0
                        alt_width[i] = 24.25
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 1741.47
                        alt_width[i] = 17.76
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 1765.0
                        alt_width[i] = 16.35
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 1576.0
                    width[i] = 1.3
                    rec_width[i] = 1.35
                    PE_alt[i] = 1576.15
                    alt_width[i] = 2.267
                    width_range[i] = 0.917 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1192.06
                        alt_width[i] = 21.22
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 1243.18
                        alt_width[i] = 12.0
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 1567.0
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 1541.66
                        alt_width[i] = 2.39
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 1528.0
                    rec_width[i] = 1.35
                    PE_alt[i] = 1527.4
                    alt_width[i] = 1.42
                    width_range[i] = 0.14 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 1183.0
                        alt_width[i] = 11.0
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 1518.83
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 1517.41
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 480.5
                    rec_width[i] = 6.3
                    PE_alt[i] = 487.1
                    alt_width[i] = 12.017
                    width_range[i] = 6.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 388.7
                    rec_width[i] = 5.5
                    PE_alt[i] = 396.35
                    alt_width[i] = 12.46
                    width_range[i] = 6.96 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 339.7
                    rec_width[i] = 3.5
                    PE_alt[i] = 343.25
                    alt_width[i] = 8.717
                    width_range[i] = 5.3 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 191.2
                    rec_width[i] = 3.7
                    PE_alt[i] = 197.55
                    alt_width[i] = 6.32
                    width_range[i] = 2.62 #GUESS
                    if transitionLine[i] == 'N4N6':
                        PE_alt[i] = 190.0
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 182.4
                    rec_width[i] = 3.2
                    PE_alt[i] = 184.45
                    alt_width[i] = 5.683
                    width_range[i] = 2.6 #GUESS
                    if transitionLine[i] == 'N5N6':
                        PE_alt[i] = 179.0
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 2.5
                    rec_width[i] = 0.03
                    PE_alt[i] = 6.43
                    alt_width[i] = 0.015
                    width_range[i] = 0.0148 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 1.3
                    rec_width[i] = 0.03
                    PE_alt[i] = 6.03
                    alt_width[i] = 0.015
                    width_range[i] = 0.005 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 52.0
                    PE_alt[i] = 53.55
                    alt_width[i] = 5.12
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 30.3
                    PE_alt[i] = 24.6
                    alt_width[i] = 0.04
                    width_range[i] = 0.005 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 24.1
                    PE_alt[i] = 22.6
                    alt_width[i] = 0.01
                    width_range[i] = 0.005 #GUESS
                else:
                    PE_lit[i] = 61332.0


            elif element[i]== 'Lu':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 63314.0
                    rec_width[i] = 33.9
                    PE_alt[i] = 63313.9
                    alt_width[i] = 33.505
                    width_range[i] = 0.395 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 52445.5
                        alt_width[i] = 41.75
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 52966.0
                        alt_width[i] = 38.0
                        width_range[i] = 0.7
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 54070.2
                        alt_width[i] = 37.9
                        width_range[i] = 0.6
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 60823.9
                        alt_width[i] = 51.68
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 61060.0
                        alt_width[i] = 43.76
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 61290.0
                        alt_width[i] = 44.02
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 61674.4
                        alt_width[i] = 35.55
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 61725.3
                        alt_width[i] = 35.54
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 62809.2
                        alt_width[i] = 47.12
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 62903.9
                        alt_width[i] = 49.62
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 62957.6
                        alt_width[i] = 42.94
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 63106.2
                        alt_width[i] = 39.53
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 63119.0
                        alt_width[i] = 39.3
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 63293.0
                        alt_width[i] = 33.67
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 63293.0
                        alt_width[i] = 33.32
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 10870.0
                    rec_width[i] = 5.4
                    PE_alt[i] = 10870.2
                    alt_width[i] = 6.543
                    width_range[i] = 2.097 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 8378.6
                        alt_width[i] = 27.21
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 8606.52
                        alt_width[i] = 19.29
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 8846.8
                        alt_width[i] = 19.54
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 9231.2
                        alt_width[i] = 11.08
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 9281.8
                        alt_width[i] = 10.07
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 10363.3
                        alt_width[i] = 22.65
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 10461.2
                        alt_width[i] = 25.15
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 10511.0
                        alt_width[i] = 18.47
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 10666.0
                        alt_width[i] = 15.06
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 10677.0
                        alt_width[i] = 14.83
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 10858.7
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 10860.6
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 10815.9
                        alt_width[i] = 13.93
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 10842.5
                        alt_width[i] = 9.2
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 10844.0
                        alt_width[i] = 8.85
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 10863.0
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 10863.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 10349.0
                    rec_width[i] = 4.46
                    PE_alt[i] = 10348.8
                    alt_width[i] = 4.567
                    width_range[i] = 0.353 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 7857.6
                        alt_width[i] = 22.9
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 8085.5
                        alt_width[i] = 14.97
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 8323.5
                        alt_width[i] = 15.2
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 8709.15
                        alt_width[i] = 6.77
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 8760.0
                        alt_width[i] = 5.75
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 9842.5
                        alt_width[i] = 18.33
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 9927.0
                        alt_width[i] = 20.83
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 9985.0
                        alt_width[i] = 14.15
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 10143.25
                        alt_width[i] = 10.74
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 10153.73
                        alt_width[i] = 10.52
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 1038.91
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 10340.83
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 10291.75
                        alt_width[i] = 9.61
                    elif transitionLine[i] == 'L2O2':
                        PE_alt[i] = 10320.0
                        alt_width[i] = 4.88
                    elif transitionLine[i] == 'L2O3':
                        PE_alt[i] = 10320.0
                        alt_width[i] = 4.53
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 10343.6
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 9244.0
                    rec_width[i] = 4.43
                    PE_alt[i] = 9244.05
                    alt_width[i] = 4.453
                    width_range[i] = 0.227 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 6752.6
                        alt_width[i] = 22.82
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 6981.0
                        alt_width[i] = 14.9
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 7310.0
                        alt_width[i] = 15.16
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 7605.0
                        alt_width[i] = 6.69
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 7655.5
                        alt_width[i] = 5.68
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 8738.5
                        alt_width[i] = 18.26
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 8834.5
                        alt_width[i] = 20.76
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 8885.0
                        alt_width[i] = 14.08
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 9039.6
                        alt_width[i] = 10.67
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 9049.0
                        alt_width[i] = 10.44
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 9234.72
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 9236.64
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 9187.15
                        alt_width[i] = 9.54
                    elif transitionLine[i] == 'L3O2':
                        PE_alt[i] = 9216.3
                        alt_width[i] = 4.81
                    elif transitionLine[i] == 'L3O3':
                        PE_alt[i] = 9216.4
                        alt_width[i] = 4.46
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 9239.7
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 9239.8
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 2491.0
                    rec_width[i] = 14.1
                    PE_alt[i] = 2491.1
                    alt_width[i] = 16.34
                    width_range[i] = 2.24 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 2264.0
                    width[i] = 6.9
                    rec_width[i] = 7.3
                    PE_alt[i] = 2263.75
                    alt_width[i] = 8.975
                    width_range[i] = 1.675 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 2024.0
                    width[i] = 5.7
                    rec_width[i] = 6.0
                    PE_alt[i] = 2023.8
                    alt_width[i] = 8.455
                    width_range[i] = 2.455 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 1834.0
                        alt_width[i] = 17.33
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 1834.0
                        alt_width[i] = 17.1
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 1639.0
                    rec_width[i] = 1.43
                    PE_alt[i] = 1639.6
                    alt_width[i] = 1.94
                    width_range[i] = 0.51 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1240.61
                        alt_width[i] = 18.96
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 1295.75
                        alt_width[i] = 12.28
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 1631.1
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 1609.28
                        alt_width[i] = 3.01
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 1589.0
                    rec_width[i] = 1.43
                    PE_alt[i] = 1588.75
                    alt_width[i] = 1.43
                    width_range[i] = 0.4 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 1242.75
                        alt_width[i] = 11.26
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 1581.3
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 1581.3
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 506.8
                    rec_width[i] = 6.6
                    PE_alt[i] = 506.1
                    alt_width[i] = 10.305
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 412.4
                    rec_width[i] = 5.5
                    PE_alt[i] = 410.05
                    alt_width[i] = 11.005
                    width_range[i] = 5.505 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 359.2
                    rec_width[i] = 3.65
                    PE_alt[i] = 359.65
                    alt_width[i] = 6.74
                    width_range[i] = 3.2 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 206.1
                    rec_width[i] = 3.8
                    PE_alt[i] = 504.9
                    alt_width[i] = 5.11
                    width_range[i] = 1.31 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 196.3
                    rec_width[i] = 3.3
                    PE_alt[i] = 195.0
                    alt_width[i] = 4.75
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 8.9
                    rec_width[i] = 0.03
                    PE_alt[i] = 7.23
                    alt_width[i] = 0.03
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 7.5
                    rec_width[i] = 0.03
                    PE_alt[i] = 6.6
                    alt_width[i] = 0.03
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 57.3
                    PE_alt[i] = 56.9
                    alt_width[i] = 5.29
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 33.6
                    PE_alt[i] = 29.67
                    alt_width[i] = 0.56
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 26.7
                    PE_alt[i] = 26.75
                    alt_width[i] = 0.21
                    width_range[i] = 0.1 #GUESS
                else:
                    PE_lit[i] = 63314.0


            elif element[i]== 'Hf':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 65351.0
                    rec_width[i] = 35.9
                    PE_alt[i] = 65350.9
                    alt_width[i] = 35.547
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 54077.0
                        alt_width[i] = 44.17
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 54612.5
                        alt_width[i] = 41.49
                        width_range[i] = 2.81
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 55791.0
                        alt_width[i] = 41.74
                        width_range[i] = 3.56
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 62747.2
                        alt_width[i] = 53.22
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 63000.0
                        alt_width[i] = 46.05
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 63234.0
                        alt_width[i] = 46.15
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 63628.8
                        alt_width[i] = 37.56
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 63683.2
                        alt_width[i] = 36.56
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 64810.0
                        alt_width[i] = 49.25
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 64907.3
                        alt_width[i] = 49.32
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 64965.3
                        alt_width[i] = 45.0
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 65119.3
                        alt_width[i] = 41.41
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 65132.6
                        alt_width[i] = 41.5
                    elif transitionLine[i] == 'KO2':
                        alt_width[i] = 36.12
                    elif transitionLine[i] == 'KO3':
                        alt_width[i] = 35.46
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 11271.0
                    rec_width[i] = 5.7
                    PE_alt[i] = 11271.35
                    alt_width[i] = 6.82
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 8668.6
                        alt_width[i] = 27.31
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 8905.5
                        alt_width[i] = 16.45
                        width_range[i] = 3.65
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 9163.5
                        alt_width[i] = 16.42
                        width_range[i] = 4.02
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 9550.4
                        alt_width[i] = 11.65
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 9609.17
                        alt_width[i] = 10.65
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 10735.2
                        alt_width[i] = 23.34
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 10833.6
                        alt_width[i] = 23.41
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 10892.5
                        alt_width[i] = 19.09
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 11045.2
                        alt_width[i] = 15.86
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 11055.4
                        alt_width[i] = 15.59
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 11250.5
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 11252.7
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 11203.5
                        alt_width[i] = 14.6
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 11232.8
                        alt_width[i] = 10.21
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 11240.0
                        alt_width[i] = 9.55
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 11262.0
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 11262.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 10739.0
                    rec_width[i] = 4.57
                    PE_alt[i] = 10739.2
                    alt_width[i] = 4.677
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 8139.3
                        alt_width[i] = 22.62
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 8373.6
                        alt_width[i] = 15.4
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 8631.3
                        alt_width[i] = 15.75
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 9022.8
                        alt_width[i] = 6.66
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 9076.9
                        alt_width[i] = 6.95
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 10201.0
                        alt_width[i] = 18.65
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 10301.0
                        alt_width[i] = 18.72
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 10358.9
                        alt_width[i] = 14.4
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 10516.0
                        alt_width[i] = 10.5
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 10526.0
                        alt_width[i] = 10.89
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 10704.0
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 10721.18
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 10675.5
                        alt_width[i] = 9.9
                    elif transitionLine[i] == 'L2O2':
                        PE_alt[i] = 10700.0
                        alt_width[i] = 5.52
                    elif transitionLine[i] == 'L2O3':
                        PE_alt[i] = 10709.0
                        alt_width[i] = 4.86
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 10732.5
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 9561.0
                    rec_width[i] = 4.55
                    PE_alt[i] = 6560.85
                    alt_width[i] = 4.573
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 6960.0
                        alt_width[i] = 22.55
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 7195.5
                        alt_width[i] = 15.33
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 7453.3
                        alt_width[i] = 15.68
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 7844.7
                        alt_width[i] = 6.79
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 7899.1
                        alt_width[i] = 5.85
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 9022.8
                        alt_width[i] = 18.58
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 9124.0
                        alt_width[i] = 18.65
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 9180.3
                        alt_width[i] = 14.33
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 9337.2
                        alt_width[i] = 11.1
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 9347.4
                        alt_width[i] = 9.9
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 9541.24
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 9543.46
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 9495.9
                        alt_width[i] = 9.84
                    elif transitionLine[i] == 'L3O2':
                        PE_alt[i] = 9522.2
                        alt_width[i] = 5.45
                    elif transitionLine[i] == 'L3O3':
                        PE_alt[i] = 9530.8
                        alt_width[i] = 4.79
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 9554.6
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 9554.7
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 2601.0
                    rec_width[i] = 14.2
                    PE_alt[i] = 2600.95
                    alt_width[i] = 17.46
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 2365.0
                    width[i] = 4.5
                    rec_width[i] = 7.5
                    PE_alt[i] = 2365.2
                    alt_width[i] = 9.82
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 2108.0
                    width[i] = 6.5
                    rec_width[i] = 5.6
                    PE_alt[i] = 2107.8
                    alt_width[i] = 9.637
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 1572.0
                        alt_width[i] = 25.52
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 1873.41
                        alt_width[i] = 18.05
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 1895.0
                        alt_width[i] = 17.77
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 1716.0
                    rec_width[i] = 1.52
                    PE_alt[i] = 1716.2
                    alt_width[i] = 1.88
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1280.0
                        alt_width[i] = 16.8
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 1282.2
                        alt_width[i] = 12.48
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 1697.6
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 1679.16
                        alt_width[i] = 3.6
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 1662.0
                    rec_width[i] = 1.52
                    PE_alt[i] = 1661.85
                    alt_width[i] = 2.08
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 1280.0
                        alt_width[i] = 11.48
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 1644.4
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 1642.9
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 538.0
                    rec_width[i] = 6.8
                    PE_alt[i] = 538.05
                    alt_width[i] = 12.337
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 438.2
                    rec_width[i] = 5.6
                    PE_alt[i] = 437.0
                    alt_width[i] = 10.96
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 380.7
                    rec_width[i] = 3.85
                    PE_alt[i] = 380.2
                    alt_width[i] = 8.937
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 220.0
                    rec_width[i] = 3.9
                    PE_alt[i] = 223.9
                    alt_width[i] = 5.977
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 211.5
                    rec_width[i] = 3.5
                    PE_alt[i] = 213.85
                    alt_width[i] = 5.753
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 15.9
                    rec_width[i] = 0.07
                    PE_alt[i] = 18.1
                    alt_width[i] = 0.045
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 14.2
                    rec_width[i] = 0.03
                    PE_alt[i] = 17.133
                    alt_width[i] = 0.025
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 64.2
                    PE_alt[i] = 64.95
                    alt_width[i] = 5.47
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 38.0
                    PE_alt[i] = 38.1
                    alt_width[i] = 1.08
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 29.9
                    PE_alt[i] = 30.2
                else:
                    PE_lit[i] = 65351.0

            #Hf NEEDS WIDTH RANGE
            elif element[i]== 'Ta':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 67416.0
                    width[i] = 35.1
                    rec_width[i] = 37.9
                    PE_alt[i] = 67419.7
                    alt_width[i] = 37.55
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 55735.0
                        alt_width[i] = 47.28
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 56278.0
                        alt_width[i] = 42.26
                        width_range[i] = 0.65
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 57533.0
                        alt_width[i] = 42.08
                        width_range[i] = 0.53
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 64708.3
                        alt_width[i] = 54.59
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 64950.0
                        alt_width[i] = 48.32
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 65224.0
                        alt_width[i] = 47.24
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 65627.0
                        alt_width[i] = 39.61
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 65684.0
                        alt_width[i] = 38.66
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 66866.7
                        alt_width[i] = 51.42
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 66950.0
                        alt_width[i] = 50.6
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 67014.0
                        alt_width[i] = 47.07
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 67242.1
                        alt_width[i] = 44.06
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 67202.7
                        alt_width[i] = 43.73
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 67370.0
                        alt_width[i] = 38.65
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 67370.9
                        alt_width[i] = 37.68
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 11682.0
                    width[i] = 6.00
                    rec_width[i] = 6.0
                    PE_alt[i] = 11680.75
                    alt_width[i] = 7.267
                    width_range[i] = 2.953 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 8973.2
                        alt_width[i] = 27.75
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 9213.0
                        alt_width[i] = 17.8
                        width_range[i] = 3.7
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 9487.3
                        alt_width[i] = 16.06
                        width_range[i] = 4.36
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 9889.0
                        alt_width[i] = 12.78
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 9946.0
                        alt_width[i] = 11.83
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 11117.4
                        alt_width[i] = 24.59
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 11216.0
                        alt_width[i] = 17.69
                        width_range[i] = 6.09
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 11277.3
                        alt_width[i] = 15.12
                        width_range[i] = 5.12
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 11439.9
                        alt_width[i] = 17.23
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 11458.0
                        alt_width[i] = 16.9
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 11667.8
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 11670.4
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 11612.0
                        alt_width[i] = 15.87
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 11636.0
                        alt_width[i] = 11.83
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 11645.0
                        alt_width[i] = 10.85
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 11675.1
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 11675.1
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 11136.0
                    rec_width[i] = 4.69
                    PE_alt[i] = 11136.05
                    alt_width[i] = 4.8
                    width_range[i] = 0.35 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 8428.0
                        alt_width[i] = 22.09
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 8668.0
                        alt_width[i] = 15.83
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 8971.5
                        alt_width[i] = 14.75
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 9343.0
                        alt_width[i] = 6.85
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 9399.9
                        alt_width[i] = 6.16
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 10571.0
                        alt_width[i] = 18.92
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 10674.0
                        alt_width[i] = 18.1
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 10732.0
                        alt_width[i] = 14.58
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 10895.0
                        alt_width[i] = 10.5
                        width_range[i] = 1.06
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 10906.4
                        alt_width[i] = 11.23
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 11110.0
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 11126.7
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 11065.0
                        alt_width[i] = 10.2
                    elif transitionLine[i] == 'L2O2':
                        PE_alt[i] = 11091.0
                        alt_width[i] = 6.16
                    elif transitionLine[i] == 'L2O3':
                        PE_alt[i] = 11100.0
                        alt_width[i] = 5.18
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 11130.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 9881.0
                    rec_width[i] = 4.68
                    PE_alt[i] = 9881.05
                    alt_width[i] = 4.683
                    width_range[i] = 0.197 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 7173.0
                        alt_width[i] = 22.02
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 7412.1
                        alt_width[i] = 15.76
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 7687.0
                        alt_width[i] = 14.68
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 8088.0
                        alt_width[i] = 7.05
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 8146.2
                        alt_width[i] = 6.1
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 9316.0
                        alt_width[i] = 18.86
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 9416.0
                        alt_width[i] = 18.04
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 9474.4
                        alt_width[i] = 14.51
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 9639.6
                        alt_width[i] = 11.5
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 9651.9
                        alt_width[i] = 10.5
                        width_range[i] = 0.7
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 9860.0
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 9871.52
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 9809.8
                        alt_width[i] = 10.14
                    elif transitionLine[i] == 'L3O2':
                        PE_alt[i] = 9837.7
                        alt_width[i] = 6.1
                    elif transitionLine[i] == 'L3O3':
                        PE_alt[i] = 9845.2
                        alt_width[i] = 5.12
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 9875.0
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 9875.8
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 2708.0
                    rec_width[i] = 14.3
                    PE_alt[i] = 2708.0
                    alt_width[i] = 17.043
                    width_range[i] = 2.743 #GUESS
                    if transitionLine[i] == 'M1N3':
                        PE_alt[i] = 2295.0
                        alt_width[i] = 27.55
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 2469.0
                    width[i] = 7.2
                    rec_width[i] = 7.8
                    PE_alt[i] = 2468.85
                    alt_width[i] = 10.357
                    width_range[i] = 2.557 #GUESS
                    if transitionLine[i] == 'M2N4':
                        PE_alt[i] = 2226.0
                        alt_width[i] = 18.27
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 2194.0
                    width[i] = 5.35
                    rec_width[i] = 5.7
                    PE_alt[i] = 2194.0
                    alt_width[i] = 8.897
                    width_range[i] = 3.197 #GUESS
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 1630.0
                        alt_width[i] = 24.55
                    elif transitionLine[i] == 'M3N3':
                        PE_alt[i] = 2295.0
                        alt_width[i] = 20.21
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 1952.0
                        alt_width[i] = 17.2
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 1964.0
                        alt_width[i] = 16.86
                    elif transitionLine[i] == 'M3O1':
                        PE_alt[i] = 2126.0
                        alt_width[i] = 15.84
                    elif transitionLine[i] == 'M3O4':
                        PE_alt[i] = 2190.0
                    elif transitionLine[i] == 'M3O5':
                        PE_alt[i] = 2190.0
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 1793.0
                    rec_width[i] = 1.61
                    PE_alt[i] = 1793.1
                    alt_width[i] = 2.473
                    width_range[i] = 0.863 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1328.8
                        alt_width[i] = 16.1
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 1395.0
                        alt_width[i] = 12.58
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 1765.5
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 1748.0
                        alt_width[i] = 4.16
                    elif transitionLine[i] == 'M4O3':
                        PE_alt[i] = 1751.2
                        alt_width[i] = 3.18
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 1735.0
                    rec_width[i] = 1.61
                    PE_alt[i] = 1735.05
                    alt_width[i] = 1.673
                    width_range[i] = 0.127 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 1330.8
                        alt_width[i] = 2.23
                    elif transitionLine[i] == 'M5N4':
                        PE_alt[i] = 1708.0
                        alt_width[i] = 8.61
                    if transitionLine[i] == 'M5N5':
                        PE_alt[i] = 1709.6
                        alt_width[i] = 8.28
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 1712.5
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 1709.6
                    elif transitionLine[i] == 'M5O3':
                        PE_alt[i] = 1700.0
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 563.4
                    rec_width[i] = 7.0
                    PE_alt[i] = 565.75
                    alt_width[i] = 10.68
                    width_range[i] = 3.7 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 463.4
                    rec_width[i] = 5.7
                    PE_alt[i] = 464.9
                    alt_width[i] = 9.625
                    width_range[i] = 3.925 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 400.9
                    rec_width[i] = 4.0
                    PE_alt[i] = 404.75
                    alt_width[i] = 7.01
                    width_range[i] = 3.1 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 237.9
                    rec_width[i] = 4.0
                    PE_alt[i] = 241.65
                    alt_width[i] = 5.505
                    width_range[i] = 1.505 #GUESS
                    if transitionLine[i] == 'N4N6':
                        PE_alt[i] = 213.0
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 226.4
                    rec_width[i] = 3.65
                    PE_alt[i] = 229.65
                    alt_width[i] = 5.16
                    width_range[i] = 1.6 #GUESS
                    if transitionLine[i] == 'N5N6':
                        PE_alt[i] = 202.8
                    elif transitionLine[i] == 'N5N7':
                        PE_alt[i] = 202.8
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 23.5
                    rec_width[i] = 0.08
                    PE_alt[i] = 27.25
                    alt_width[i] = 0.08
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 21.6
                    rec_width[i] = 0.04
                    PE_alt[i] = 25.3
                    alt_width[i] = 0.04
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 69.7
                    PE_alt[i] = 71.05
                    alt_width[i] = 5.65
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 42.2
                    PE_alt[i] = 44.53
                    alt_width[i] = 1.6
                    width_range[i] = 0.5 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 32.7
                    PE_alt[i] = 36.03
                    alt_width[i] = 0.63
                    width_range[i] = 0.2 #GUESS
                else:
                    PE_lit[i] = 67416.0


            elif element[i]== 'W':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 69525.0
                    rec_width[i] = 40.1
                    PE_alt[i] = 69525.0
                    alt_width[i] = 39.717
                    width_range[i] = 0.383 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 57420.0
                        alt_width[i] = 50.78
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 57982.0
                        alt_width[i] = 44.6
                        width_range[i] = 0.8
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 59319.0
                        alt_width[i] = 45.48
                        width_range[i] = 2.27
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 66706.9
                        alt_width[i] = 56.54
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 6696.0
                        alt_width[i] = 50.7
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 67244.0
                        alt_width[i] = 50.4
                        width_range[i] = 1.13
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 67652.0
                        alt_width[i] = 41.66
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 67716.0
                        alt_width[i] = 40.85
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 68932.0
                        alt_width[i] = 53.64
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 69035.0
                        alt_width[i] = 52.76
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 69103.0
                        alt_width[i] = 49.16
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 69267.3
                        alt_width[i] = 46.41
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 69281.8
                        alt_width[i] = 46.02
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 69484.0
                        alt_width[i] = 41.28
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 69488.0
                        alt_width[i] = 39.99
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 12100.0
                    width[i] = 6.5
                    rec_width[i] = 6.3
                    PE_alt[i] = 12099.15
                    alt_width[i] = 7.843
                    width_range[i] = 3.777 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 9278.1
                        alt_width[i] = 29.01
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 9524.0
                        alt_width[i] = 17.62
                        width_range[i] = 5.55
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 9818.0
                        alt_width[i] = 15.71
                        width_range[i] = 6.03
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 10227.0
                        alt_width[i] = 14.13
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 10290.3
                        alt_width[i] = 13.32
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 11502.8
                        alt_width[i] = 26.11
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 11610.0
                        alt_width[i] = 18.665
                        width_range[i] = 6.57
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 11680.0
                        alt_width[i] = 16.32
                        width_range[i] = 5.32
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 11845.0
                        alt_width[i] = 18.87
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 11860.0
                        alt_width[i] = 18.48
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 12063.2
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 12065.8
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 12017.0
                        alt_width[i] = 17.44
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 12053.0
                        alt_width[i] = 13.74
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 12063.0
                        alt_width[i] = 12.46
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 12095.0
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 12095.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 11544.0
                    rec_width[i] = 4.82
                    PE_alt[i] = 11543.0
                    alt_width[i] = 4.947
                    width_range[i] = 0.383 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 8724.0
                        alt_width[i] = 22.07
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 8953.0
                        alt_width[i] = 14.8
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 9268.72
                        alt_width[i] = 14.8
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 9672.5
                        alt_width[i] = 6.86
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 9738.0
                        alt_width[i] = 6.38
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 10948.5
                        alt_width[i] = 19.18
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 11048.0
                        alt_width[i] = 18.29
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 11120.0
                        alt_width[i] = 14.7
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 11286.0
                        alt_width[i] = 10.67
                        width_range[i] = 0.87
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 11299.89
                        alt_width[i] = 11.55
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 11507.48
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 11510.08
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 11467.0
                        alt_width[i] = 10.51
                    elif transitionLine[i] == 'L2O3':
                        PE_alt[i] = 11490.0
                        alt_width[i] = 5.52
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 11539.0
                        alt_width[i] = 7.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 10207.0
                    rec_width[i] = 4.81
                    PE_alt[i] = 10205.9
                    alt_width[i] = 4.807
                    width_range[i] = 0.177 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 7387.5
                        alt_width[i] = 22.01
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 7387.7
                        alt_width[i] = 22.01
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 7926.8
                        alt_width[i] = 14.74
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 8335.5
                        alt_width[i] = 7.17
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 8398.0
                        alt_width[i] = 6.4
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 9610.0
                        alt_width[i] = 19.12
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 9712.5
                        alt_width[i] = 18.23
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 9784.0
                        alt_width[i] = 14.64
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 9947.95
                        alt_width[i] = 11.88
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 99963.0
                        alt_width[i] = 10.65
                        width_range[i] = 0.85
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 10170.6
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 10173.18
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 10129.1
                        alt_width[i] = 10.45
                    elif transitionLine[i] == 'L3O2':
                        PE_alt[i] = 10153.0
                        alt_width[i] = 6.75
                    elif transitionLine[i] == 'L3O3':
                        PE_alt[i] = 10154.0
                        alt_width[i] = 5.46
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 10200.0
                        alt_width[i] = 6.5
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 10200.0
                        alt_width[i] = 6.5
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 2820.0
                    rec_width[i] = 14.5
                    PE_alt[i] = 8219.8
                    alt_width[i] = 17.63
                    width_range[i] = 3.37 #GUESS
                    if transitionLine[i] == 'M1N3':
                        PE_alt[i] = 2396.5
                        alt_width[i] = 27.4
                    elif transitionLine[i] == 'M1O2':
                        PE_alt[i] = 2790.0
                        alt_width[i] = 19.51
                    elif transitionLine[i] == 'M1O3':
                        PE_alt[i] = 2799.0
                        alt_width[i] = 18.22
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 2575.0
                    width[i] = 8.13
                    rec_width[i] = 8.1
                    PE_alt[i] = 2574.95
                    alt_width[i] = 9.88
                    width_range[i] = 3.44 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 1972.0
                        alt_width[i] = 26.04
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 2315.0
                        alt_width[i] = 18.7
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 2281.0
                    width[i] = 6.23
                    rec_width[i] = 6.4
                    PE_alt[i] = 2281.0
                    alt_width[i] = 9.84
                    width_range[i] = 3.44 #GUESS
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 1684.0
                        alt_width[i] = 24.61
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 2021.0
                        alt_width[i] = 17.37
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 2035.5
                        alt_width[i] = 11.49
                        width_range[i] = 5.49
                    elif transitionLine[i] == 'M3O1':
                        PE_alt[i] = 2203.0
                        alt_width[i] = 15.94
                    elif transitionLine[i] == 'M3O5':
                        PE_alt[i] = 2275.2
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 1872.0
                    width[i] = 1.8
                    rec_width[i] = 1.7
                    PE_alt[i] = 1871.8
                    alt_width[i] = 2.037
                    width_range[i] = 0.473 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1378.5
                        alt_width[i] = 16.11
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 1445.5
                        alt_width[i] = 12.52
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 1835.0
                        alt_width[i] = 2.14
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 1822.0
                        alt_width[i] = 4.63
                    elif transitionLine[i] == 'M4O3':
                        PE_alt[i] = 1823.0
                        alt_width[i] = 3.34
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 1809.0
                    width[i] = 2.0
                    rec_width[i] = 1.7
                    PE_alt[i] = 1809.6
                    alt_width[i] = 2.3
                    width_range[i] = 1.2 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 1383.5
                        alt_width[i] = 7.01
                        width_range[i] = 4.71
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 1712.5
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 1773.4
                        alt_width[i] = 0.31
                    elif transitionLine[i] == 'M5O3':
                        PE_alt[i] = 1770.0
                        alt_width[i] = 2.53
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 594.1
                    rec_width[i] = 7.3
                    PE_alt[i] = 595.0
                    alt_width[i] = 12.597
                    width_range[i] = 5.3 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 490.4
                    rec_width[i] = 5.8
                    PE_alt[i] = 491.8
                    alt_width[i] = 10.8
                    width_range[i] = 5.0 #GUESS
                    if transitionLine[i] == 'N2N4':
                        PE_alt[i] = 229.5
                        alt_width[i] = 20.86
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 423.6
                    rec_width[i] = 4.2
                    PE_alt[i] = 425.65
                    alt_width[i] = 9.07
                    width_range[i] = 5.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 255.9
                    width[i] = 4.9
                    rec_width[i] = 4.1
                    PE_alt[i] = 258.9
                    alt_width[i] = 6.383
                    width_range[i] = 2.283 #GUESS
                    if transitionLine[i] == 'N4N6':
                        PE_alt[i] = 222.1
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 243.5
                    rec_width[i] = 3.8
                    PE_alt[i] = 245.7
                    alt_width[i] = 6.153
                    width_range[i] = 2.8 #GUESS
                    if transitionLine[i] == 'N5N6':
                        PE_alt[i] = 208.0
                    elif transitionLine[i] == 'N5N7':
                        PE_alt[i] = 212.2
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 33.6
                    rec_width[i] = 0.1
                    PE_alt[i] = 36.97
                    alt_width[i] = 0.085
                    width_range[i] = 0.015 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 31.4
                    rec_width[i] = 0.06
                    PE_alt[i] = 34.23
                    alt_width[i] = 0.065
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 75.6
                    PE_alt[i] = 77.05
                    alt_width[i] = 5.82
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 45.3
                    PE_alt[i] = 55.83
                    alt_width[i] = 2.12
                    width_range[i] = 0.5 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 36.8
                    PE_alt[i] = 36.37
                    alt_width[i] = 0.83
                    width_range[i] = 0.2 #GUESS
                else:
                    PE_lit[i] = 69525.0


            elif element[i]== 'Re':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 71676.0
                    rec_width[i] = 42.2
                    PE_alt[i] = 71676.7
                    alt_width[i] = 41.877
                    width_range[i] = 0.547 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 59150.0
                        alt_width[i] = 54.0
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 59719.0
                        alt_width[i] = 47.6
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 61141.2
                        alt_width[i] = 47.2
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 68745.6
                        alt_width[i] = 59.02
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 68995.5
                        alt_width[i] = 53.13
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 69310.3
                        alt_width[i] = 51.73
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 69719.6
                        alt_width[i] = 43.8
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 69786.3
                        alt_width[i] = 43.12
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 71053.6
                        alt_width[i] = 55.97
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 71150.0
                        alt_width[i] = 54.98
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 71231.0
                        alt_width[i] = 51.28
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 71402.0
                        alt_width[i] = 48.81
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 71417.6
                        alt_width[i] = 48.35
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 71633.0
                        alt_width[i] = 44.79
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 71633.0
                        alt_width[i] = 43.49
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 12527.0
                    width[i] = 7.40
                    rec_width[i] = 6.7
                    PE_alt[i] = 12526.85
                    alt_width[i] = 8.517
                    width_range[i] = 4.153 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 9595.6
                        alt_width[i] = 30.36
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 9846.2
                        alt_width[i] = 16.4
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 10160.0
                        alt_width[i] = 13.6
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 10577.0
                        alt_width[i] = 15.14
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 10643.45
                        alt_width[i] = 14.46
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 11899.0
                        alt_width[i] = 27.31
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 12009.5
                        alt_width[i] = 19.76
                        width_range[i] = 6.56
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 12082.0
                        alt_width[i] = 17.31
                        width_range[i] = 5.31
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 12252.2
                        alt_width[i] = 20.15
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 12266.0
                        alt_width[i] = 19.69
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 12483.0
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 12486.0
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 12442.0
                        alt_width[i] = 20.98
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 12481.3
                        alt_width[i] = 16.13
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 12492.0
                        alt_width[i] = 14.83
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 12524.0
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 12524.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 11959.0
                    rec_width[i] = 4.95
                    PE_alt[i] = 11957.85
                    alt_width[i] = 5.083
                    width_range[i] = 0.397 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 9027.2
                        alt_width[i] = 22.51
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 9276.0
                        alt_width[i] = 16.62
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 9591.0
                        alt_width[i] = 15.23
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 10010.0
                        alt_width[i] = 6.9
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 10075.0
                        alt_width[i] = 6.61
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 11334.1
                        alt_width[i] = 19.46
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 11438.25
                        alt_width[i] = 18.47
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 11515.0
                        alt_width[i] = 14.77
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 11685.25
                        alt_width[i] = 10.9
                        width_range[i] = 1.4
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 11699.29
                        alt_width[i] = 16.66
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 11917.0
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 11917.7
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 11876.0
                        alt_width[i] = 13.13
                    elif transitionLine[i] == 'L2O3':
                        PE_alt[i] = 11925.0
                        alt_width[i] = 6.98
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 11955.5
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 10535.0
                    rec_width[i] = 4.95
                    PE_alt[i] = 10535.15
                    alt_width[i] = 4.917
                    width_range[i] = 0.157 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 7603.5
                        alt_width[i] = 22.45
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 7853.0
                        alt_width[i] = 16.56
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 8168.5
                        alt_width[i] = 15.17
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 8586.3
                        alt_width[i] = 6.44
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 8652.4
                        alt_width[i] = 6.55
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 9910.4
                        alt_width[i] = 19.4
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 10018.4
                        alt_width[i] = 18.41
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 10093.4
                        alt_width[i] = 14.71
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 10262.0
                        alt_width[i] = 9.44
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 10275.2
                        alt_width[i] = 16.6
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 10495.0
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 10494.9
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 10452.9
                        alt_width[i] = 13.07
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 10532.0
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 10531.8
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 2932.0
                    rec_width[i] = 14.6
                    PE_alt[i] = 2931.85
                    alt_width[i] = 16.145
                    width_range[i] = 1.545 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 2682.0
                    width[i] = 9.7
                    rec_width[i] = 8.4
                    PE_alt[i] = 2681.8
                    alt_width[i] = 10.1
                    width_range[i] = 1.7 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 2367.0
                    width[i] = 6.9
                    rec_width[i] = 6.9
                    PE_alt[i] = 2367.15
                    alt_width[i] = 8.65
                    width_range[i] = 1.75 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 2090.0
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 2110.0
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 1949.0
                    rec_width[i] = 1.79
                    PE_alt[i] = 1948.95
                    alt_width[i] = 2.13
                    width_range[i] = 0.34 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1431.0
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 1505.0
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 1902.0
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 1900.83
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 1883.0
                    rec_width[i] = 1.79
                    PE_alt[i] = 1882.95
                    alt_width[i] = 1.79
                    width_range[i] = 0.15 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 1436.8
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 1899.0
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 1842.5
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 625.4
                    rec_width[i] = 7.5
                    PE_alt[i] = 625.0
                    alt_width[i] = 11.07
                    width_range[i] = 3.8 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 518.7
                    rec_width[i] = 5.9
                    PE_alt[i] = 517.95
                    alt_width[i] = 9.775
                    width_range[i] = 3.875 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 446.8
                    rec_width[i] = 4.4
                    PE_alt[i] = 444.7
                    alt_width[i] = 7.175
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 273.9
                    rec_width[i] = 4.1
                    PE_alt[i] = 273.85
                    alt_width[i] = 5.79
                    width_range[i] = 1.69 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 260.5
                    rec_width[i] = 3.9
                    PE_alt[i] = 260.1
                    alt_width[i] = 5.46
                    width_range[i] = 3.2 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 42.9
                    rec_width[i] = 0.15
                    PE_alt[i] = 47.55
                    alt_width[i] = 0.15
                    width_range[i] = 0.05 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 40.5
                    rec_width[i] = 0.11
                    PE_alt[i] = 45.35
                    alt_width[i] = 0.11
                    width_range[i] = 0.05 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 83.0
                    PE_alt[i] = 82.9
                    alt_width[i] = 8.31
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 45.6
                    PE_alt[i] = 46.67
                    alt_width[i] = 3.46
                    width_range[i] = 0.5 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 34.6
                    PE_alt[i] = 35.47
                    alt_width[i] = 2.16
                    width_range[i] = 0.4 #GUESS
                else:
                    PE_lit[i] = 71676.0


            elif element[i]== 'Os':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 73871.0
                    rec_width[i] = 44.6
                    PE_alt[i] = 73870.9
                    alt_width[i] = 44.207
                    width_range[i] = 0.587 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 60905.6
                        alt_width[i] = 56.73
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 61488.0
                        alt_width[i] = 49.7
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 63001.0
                        alt_width[i] = 51.3
                        width_range[i] = 1.7
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 70823.2
                        alt_width[i] = 61.59
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 71077.5
                        alt_width[i] = 55.95
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 71413.0
                        alt_width[i] = 55.9
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 71823.8
                        alt_width[i] = 46.01
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 71894.7
                        alt_width[i] = 45.49
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 73127.2
                        alt_width[i] = 58.46
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 73317.0
                        alt_width[i] = 57.3
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 73403.0
                        alt_width[i] = 53.46
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 73579.9
                        alt_width[i] = 51.29
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 73595.9
                        alt_width[i] = 50.74
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 73808.0
                        alt_width[i] = 48.41
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 73808.0
                        alt_width[i] = 47.09
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 12968.0
                    width[i] = 8.0
                    rec_width[i] = 7.2
                    PE_alt[i] = 12968.0
                    alt_width[i] = 9.187
                    width_range[i] = 3.923 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 9917.6
                        alt_width[i] = 31.1
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 10175.45
                        alt_width[i] = 16.8
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 10511.0
                        alt_width[i] = 14.65
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 10937.36
                        alt_width[i] = 15.52
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 11007.5
                        alt_width[i] = 15.0
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 1211.6
                        alt_width[i] = 27.97
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 12422.48
                        alt_width[i] = 14.0
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 12499.94
                        alt_width[i] = 12.6
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 12687.25
                        alt_width[i] = 20.8
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 12696.3
                        alt_width[i] = 20.25
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 12913.5
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 12916.6
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 12872.15
                        alt_width[i] = 23.91
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 12910.0
                        alt_width[i] = 17.92
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 12923.0
                        alt_width[i] = 16.6
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 12998.0
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 12968.3
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 12385.0
                    rec_width[i] = 5.09
                    PE_alt[i] = 12385.0
                    alt_width[i] = 5.21
                    width_range[i] = 0.38 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 9337.1
                        alt_width[i] = 22.93
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 9586.0
                        alt_width[i] = 17.02
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 9935.0
                        alt_width[i] = 15.67
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 10355.2
                        alt_width[i] = 7.01
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 10421.0
                        alt_width[i] = 6.83
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 11730.0
                        alt_width[i] = 19.8
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 11839.7
                        alt_width[i] = 18.64
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 11924.25
                        alt_width[i] = 14.8
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 12095.25
                        alt_width[i] = 10.02
                        width_range[i] = 0.63
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 12109.35
                        alt_width[i] = 12.08
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 12337.0
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 12335.7
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 12302.0
                        alt_width[i] = 15.74
                    elif transitionLine[i] == 'L2O3':
                        PE_alt[i] = 12340.0
                        alt_width[i] = 8.43
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 12385.0
                        alt_width[i] = 7.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 10871.0
                    rec_width[i] = 5.09
                    PE_alt[i] = 10870.95
                    alt_width[i] = 5.053
                    width_range[i] = 0.143 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 7822.3
                        alt_width[i] = 22.19
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 8079.0
                        alt_width[i] = 16.98
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 8414.0
                        alt_width[i] = 15.63
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 8841.05
                        alt_width[i] = 6.88
                        width_range[i] = 0.32
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 8911.8
                        alt_width[i] = 6.92
                        width_range[i] = 0.13
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 10217.0
                        alt_width[i] = 19.76
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 10325.0
                        alt_width[i] = 18.6
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 10402.0
                        alt_width[i] = 14.76
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 10582.0
                        alt_width[i] = 9.36
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 10598.0
                        alt_width[i] = 9.75
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 10825.0
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 10822.4
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 10787.1
                        alt_width[i] = 15.68
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 10871.0
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 10871.0
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 3049.0
                    rec_width[i] = 14.7
                    PE_alt[i] = 3048.75
                    alt_width[i] = 17.593
                    width_range[i] = 2.893 #GUESS
                    if transitionLine[i] == 'M1N3':
                        PE_alt[i] = 2590.0
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 2792.0
                    width[i] = 9.9
                    rec_width[i] = 8.6
                    PE_alt[i] = 2792.1
                    alt_width[i] = 11.52
                    width_range[i] = 2.92 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 2133.0
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 2502.0
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 2457.0
                    width[i] = 7.5
                    rec_width[i] = 7.5
                    PE_alt[i] = 2457.6
                    alt_width[i] = 9.187
                    width_range[i] = 1.687 #GUESS
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 1798.0
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 2166.0
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 2182.0
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 2031.0
                    rec_width[i] = 1.89
                    PE_alt[i] = 2030.9
                    alt_width[i] = 2.823
                    width_range[i] = 1.357 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1483.2
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 1578.27
                    elif transitionLine[i] == 'M4N4':
                        PE_alt[i] = 1578.27
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 1978.3
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 1978.49
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 1960.0
                    rec_width[i] = 1.89
                    PE_alt[i] = 1960.05
                    alt_width[i] = 2.01
                    width_range[i] = 0.24 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 1492.0
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 1913.3
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 1910.0
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 658.2
                    rec_width[i] = 7.7
                    PE_alt[i] = 654.65
                    alt_width[i] = 12.85
                    width_range[i] = 5.5 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 549.1
                    rec_width[i] = 6.0
                    PE_alt[i] = 546.75
                    alt_width[i] = 10.9
                    width_range[i] = 4.9 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 470.7
                    rec_width[i] = 4.6
                    PE_alt[i] = 468.6
                    alt_width[i] = 9.153
                    width_range[i] = 4.8 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 293.1
                    rec_width[i] = 4.1
                    PE_alt[i] = 289.7
                    alt_width[i] = 6.593
                    width_range[i] = 2.493 #GUESS
                    if transitionLine[i] == 'N4N6':
                        PE_alt[i] = 238.8
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 278.5
                    rec_width[i] = 3.9
                    PE_alt[i] = 272.9
                    alt_width[i] = 6.343
                    width_range[i] = 2.6 #GUESS
                    if transitionLine[i] == 'N5N6':
                        PE_alt[i] = 226.6
                    elif transitionLine[i] == 'N5N7':
                        PE_alt[i] = 226.6
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 53.4
                    rec_width[i] = 0.22
                    PE_alt[i] = 52.9
                    alt_width[i] = 0.17
                    width_range[i] = 0.05 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 50.7
                    rec_width[i] = 0.18
                    PE_alt[i] = 50.5
                    alt_width[i] = 0.15
                    width_range[i] = 0.05 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 84.0
                    PE_alt[i] = 83.85
                    alt_width[i] = 10.79
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 58.0
                    PE_alt[i] = 58.0
                    alt_width[i] = 4.8
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 44.5
                    PE_alt[i] = 45.7
                    alt_width[i] = 3.48
                    width_range[i] = 1.0 #GUESS
                else:
                    PE_lit[i] = 73871.0


            elif element[i]== 'Ir':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 76111.0
                    rec_width[i] = 47.0
                    PE_alt[i] = 76111.0
                    alt_width[i] = 46.593
                    width_range[i] = 0.613 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 62694.2
                        alt_width[i] = 59.12
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 63288.0
                        alt_width[i] = 51.8
                        width_range[i] = 0.72
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 64897.0
                        alt_width[i] = 51.54
                        width_range[i] = 0.56
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 72941.1
                        alt_width[i] = 64.2
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 73203.0
                        alt_width[i] = 58.24
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 73561.8
                        alt_width[i] = 56.97
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 73984.0
                        alt_width[i] = 48.26
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 74076.0
                        alt_width[i] = 47.97
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 75418.4
                        alt_width[i] = 61.03
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 75530.0
                        alt_width[i] = 59.7
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 75620.0
                        alt_width[i] = 55.73
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 75795.7
                        alt_width[i] = 53.93
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 75812.4
                        alt_width[i] = 53.2
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 76053.0
                        alt_width[i] = 52.13
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 76055.0
                        alt_width[i] = 50.79
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 13419.0
                    width[i] = 8.5
                    rec_width[i] = 7.9
                    PE_alt[i] = 13418.75
                    alt_width[i] = 9.78
                    width_range[i] = 3.36 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 10245.0
                        alt_width[i] = 31.35
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 10510.5
                        alt_width[i] = 21.55
                        width_range[i] = 3.85
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 10867.0
                        alt_width[i] = 19.51
                        width_range[i] = 4.61
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 11301.0
                        alt_width[i] = 15.42
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 11377.0
                        alt_width[i] = 15.13
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 1295.0
                        alt_width[i] = 28.18
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 12841.0
                        alt_width[i] = 20.73
                        width_range[i] = 6.13
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 12923.0
                        alt_width[i] = 18.1
                        width_range[i] = 4.8
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 13108.0
                        alt_width[i] = 21.08
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 13126.0
                        alt_width[i] = 20.36
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 13349.0
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 13352.4
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 13271.0
                        alt_width[i] = 26.42
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 13355.0
                        alt_width[i] = 19.28
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 13368.0
                        alt_width[i] = 17.94
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 13413.0
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 13413.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 12824.0
                    rec_width[i] = 5.23
                    PE_alt[i] = 12824.05
                    alt_width[i] = 5.337
                    width_range[i] = 0.343 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 9652.0
                        alt_width[i] = 23.3
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 9910.0
                        alt_width[i] = 17.36
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 10273.0
                        alt_width[i] = 16.08
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 10708.0
                        alt_width[i] = 7.1
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 10792.0
                        alt_width[i] = 7.08
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 12134.0
                        alt_width[i] = 20.14
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 12251.0
                        alt_width[i] = 18.81
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 12332.0
                        alt_width[i] = 14.84
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 12512.0
                        alt_width[i] = 11.32
                        width_range[i] = 1.72
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 12524.3
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 12760.0
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 12758.5
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 12727.45
                        alt_width[i] = 18.38
                    elif transitionLine[i] == 'L2O2':
                        PE_alt[i] = 12783.0
                        alt_width[i] = 11.24
                    elif transitionLine[i] == 'L2O3':
                        PE_alt[i] = 12784.3
                        alt_width[i] = 9.9
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 12820.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 11215.0
                    rec_width[i] = 5.24
                    PE_alt[i] = 11215.1
                    alt_width[i] = 5.183
                    width_range[i] = 0.123 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 8045.5
                        alt_width[i] = 23.26
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 8306.0
                        alt_width[i] = 17.32
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 8659.0
                        alt_width[i] = 16.04
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 9099.4
                        alt_width[i] = 7.34
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 9175.0
                        alt_width[i] = 7.55
                        width_range[i] = 0.55
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 10525.0
                        alt_width[i] = 20.1
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 10639.0
                        alt_width[i] = 18.77
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 10725.0
                        alt_width[i] = 14.81
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 10903.0
                        alt_width[i] = 13.0
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 10920.0
                        alt_width[i] = 10.99
                        width_range[i] = 1.29
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 11146.8
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 11150.1
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 11120.25
                        alt_width[i] = 18.34
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 11211.4
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 11211.0
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 3174.0
                    width[i] = 12.8
                    rec_width[i] = 14.8
                    PE_alt[i] = 3173.85
                    alt_width[i] = 16.505
                    width_range[i] = 1.705 #GUESS
                    if transitionLine[i] == 'M1N3':
                        PE_alt[i] = 2677.0
                        alt_width[i] = 27.95
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 2909.0
                    width[i] = 9.8
                    rec_width[i] = 8.9
                    PE_alt[i] = 2908.85
                    alt_width[i] = 10.58
                    width_range[i] = 1.68 #GUESS
                    if transitionLine[i] == 'M2N4':
                        PE_alt[i] = 2594.0
                        alt_width[i] = 20.2
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 2551.0
                    width[i] = 7.1
                    rec_width[i] = 8.0
                    PE_alt[i] = 2550.85
                    alt_width[i] = 9.49
                    width_range[i] = 1.49 #GUESS
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 1860.0
                        alt_width[i] = 26.02
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 2238.0
                        alt_width[i] = 18.92
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 2254.0
                        alt_width[i] = 13.85
                        width_range[i] = 4.35
                    elif transitionLine[i] == 'M3O4':
                        PE_alt[i] = 2546.0
                    elif transitionLine[i] == 'M3O5':
                        PE_alt[i] = 2552.0
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 2116.0
                    rec_width[i] = 1.99
                    PE_alt[i] = 2116.05
                    alt_width[i] = 2.135
                    width_range[i] = 0.145 #GUESS
                    if transitionLine[i] == 'M4N3':
                        PE_alt[i] = 1622.0
                        alt_width[i] = 12.03
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 2054.0
                        alt_width[i] = 2.2
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 2057.5
                        alt_width[i] = 8.42
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 2040.0
                    rec_width[i] = 1.99
                    PE_alt[i] = 2040.7
                    alt_width[i] = 1.99
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'M5N2':
                        PE_alt[i] = 1537.3
                        alt_width[i] = 15.7
                    elif transitionLine[i] == 'M5N3':
                        PE_alt[i] = 1546.0
                        alt_width[i] = 11.73
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 1980.0
                        alt_width[i] = 2.5
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 1976.0
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 691.1
                    rec_width[i] = 8.0
                    PE_alt[i] = 690.05
                    alt_width[i] = 11.52
                    width_range[i] = 3.6 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 577.8
                    rec_width[i] = 6.1
                    PE_alt[i] = 577.05
                    alt_width[i] = 9.905
                    width_range[i] = 3.805 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 495.8
                    rec_width[i] = 4.75
                    PE_alt[i] = 494.65
                    alt_width[i] = 7.25
                    width_range[i] = 2.6 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 311.9
                    rec_width[i] = 4.1
                    PE_alt[i] = 311.7
                    alt_width[i] = 6.02
                    width_range[i] = 1.92 #GUESS
                    if transitionLine[i] == 'N4N6':
                        PE_alt[i] = 247.0
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 296.3
                    width[i] = 4.37
                    rec_width[i] = 4.0
                    PE_alt[i] = 294.95
                    alt_width[i] = 3.843
                    width_range[i] = 0.7 #GUESS
                    if transitionLine[i] == 'N5N6':
                        PE_alt[i] = 234.8
                    elif transitionLine[i] == 'N5N7':
                        PE_alt[i] = 234.8
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 63.8
                    rec_width[i] = 0.31
                    PE_alt[i] = 63.4
                    alt_width[i] = 0.31
                    width_range[i] = 0.05 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 60.8
                    rec_width[i] = 0.27
                    PE_alt[i] = 60.43
                    alt_width[i] = 0.27
                    width_range[i] = 0.08 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 95.2
                    PE_alt[i] = 95.6
                    alt_width[i] = 13.28
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 63.0
                    PE_alt[i] = 63.0
                    alt_width[i] = 6.14
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 48.0
                    PE_alt[i] = 50.37
                    alt_width[i] = 4.8
                    width_range[i] = 1.0 #GUESS
                else:
                    PE_lit[i] = 76111.0


            elif element[i]== 'Pt':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 78395.0
                    width[i] = 46.7
                    rec_width[i] = 49.5
                    PE_alt[i] = 78394.9
                    alt_width[i] = 49.083
                    width_range[i] = 0.633 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 64515.5
                        alt_width[i] = 61.83
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 65123.3
                        alt_width[i] = 54.0
                        width_range[i] = 0.31
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 66832.0
                        alt_width[i] = 57.0
                        width_range[i] = 3.34
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 75099.4
                        alt_width[i] = 66.91
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 75369.0
                        alt_width[i] = 60.94
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 75750.0
                        alt_width[i] = 59.64
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 76200.0
                        alt_width[i] = 50.64
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 76275.0
                        alt_width[i] = 50.53
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 77672.2
                        alt_width[i] = 63.81
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 77786.0
                        alt_width[i] = 62.1
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 77878.0
                        alt_width[i] = 58.09
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 78064.5
                        alt_width[i] = 56.49
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 78081.9
                        alt_width[i] = 55.71
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 78342.0
                        alt_width[i] = 55.93
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 78346.0
                        alt_width[i] = 54.57
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 13880.0
                    width[i] = 10.7
                    rec_width[i] = 8.8
                    PE_alt[i] = 13880.05
                    alt_width[i] = 10.523
                    width_range[i] = 2.857 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 10565.0
                        alt_width[i] = 31.84
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 10854.4
                        alt_width[i] = 21.94
                        width_range[i] = 3.94
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 11231.0
                        alt_width[i] = 20.34
                        width_range[i] = 4.24
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 11676.0
                        alt_width[i] = 15.57
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 11756.8
                        alt_width[i] = 15.46
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 13111.0
                        alt_width[i] = 28.73
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 13270.5
                        alt_width[i] = 27.03
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 13361.5
                        alt_width[i] = 23.02
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 13549.0
                        alt_width[i] = 21.43
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 13561.0
                        alt_width[i] = 20.64
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 13805.0
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 13808.5
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 13784.0
                        alt_width[i] = 29.15
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 13814.0
                        alt_width[i] = 20.86
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 13828.1
                        alt_width[i] = 19.5
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 13864.0
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 13878.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 13273.0
                    rec_width[i] = 5.38
                    PE_alt[i] = 13272.8
                    alt_width[i] = 5.55
                    width_range[i] = 0.31 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 9975.2
                        alt_width[i] = 23.7
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 10221.0
                        alt_width[i] = 17.74
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 10627.0
                        alt_width[i] = 16.44
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 11071.0
                        alt_width[i] = 7.73
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 11140.5
                        alt_width[i] = 7.33
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 12552.0
                        alt_width[i] = 20.59
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 12661.6
                        alt_width[i] = 18.9
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 12758.0
                        alt_width[i] = 14.88
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 12942.0
                        alt_width[i] = 12.24
                        width_range[i] = 1.04
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 12959.33
                        alt_width[i] = 12.52
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 13199.3
                        alt_width[i] = 5.61
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 13201.5
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 13173.0
                        alt_width[i] = 21.01
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 13271.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 11564.0
                    rec_width[i] = 5.39
                    PE_alt[i] = 11563.85
                    alt_width[i] = 5.303
                    width_range[i] = 0.093 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 8268.2
                        alt_width[i] = 23.67
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 8532.9
                        alt_width[i] = 17.7
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 8922.8
                        alt_width[i] = 16.41
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 9362.0
                        alt_width[i] = 7.4
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 9442.3
                        alt_width[i] = 7.45
                        width_range[i] = 0.15
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 10841.44
                        alt_width[i] = 20.56
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 10962.2
                        alt_width[i] = 18.86
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 11044.2
                        alt_width[i] = 14.85
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 11233.4
                        alt_width[i] = 13.26
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 11250.0
                        alt_width[i] = 11.21
                        width_range[i] = 1.26
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 11489.5
                        alt_width[i] = 5.58
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 11492.9
                        alt_width[i] = 5.52
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 11461.0
                        alt_width[i] = 20.98
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 11561.0
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 11560.0
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 3296.0
                    rec_width[i] = 14.9
                    PE_alt[i] = 3297.6
                    alt_width[i] = 18.787
                    width_range[i] = 4.213 #GUESS
                    if transitionLine[i] == 'M1N3':
                        PE_alt[i] = 2780.0
                        alt_width[i] = 28.1
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 3027.0
                    width[i] = 10.6
                    rec_width[i] = 9.2
                    PE_alt[i] = 3026.73
                    alt_width[i] = 10.23
                    width_range[i] = 2.26 #GUESS
                    if transitionLine[i] == 'M2N4':
                        PE_alt[i] = 2695.0
                        alt_width[i] = 20.53
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 2645.0
                    width[i] = 7.35
                    rec_width[i] = 8.3
                    PE_alt[i] = 2645.7
                    alt_width[i] = 11.497
                    width_range[i] = 3.503 #GUESS
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 1921.0
                        alt_width[i] = 26.55
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 2314.0
                        alt_width[i] = 19.23
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 2331.0
                        alt_width[i] = 18.45
                    elif transitionLine[i] == 'M3O1':
                        PE_alt[i] = 2543.0
                        alt_width[i] = 26.96
                    elif transitionLine[i] == 'M3O4':
                        PE_alt[i] = 2641.0
                    elif transitionLine[i] == 'M3O5':
                        PE_alt[i] = 2647.0
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 2202.0
                    rec_width[i] = 2.08
                    PE_alt[i] = 2201.87
                    alt_width[i] = 2.19
                    width_range[i] = 0.11 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1592.0
                        alt_width[i] = 15.84
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 1682.0
                        alt_width[i] = 11.83
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 2127.0
                        alt_width[i] = 2.55
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 2139.06
                        alt_width[i] = 9.67
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 2122.0
                    rec_width[i] = 2.08
                    PE_alt[i] = 2121.33
                    alt_width[i] = 2.22
                    width_range[i] = 0.28 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 2047.0
                        alt_width[i] = 11.72
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 2050.5
                        alt_width[i] = 2.4
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 2047.0
                        alt_width[i] = 2.45
                    elif transitionLine[i] == 'M5O3':
                        PE_alt[i] = 2071.0
                        alt_width[i] = 8.21
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 725.4
                    rec_width[i] = 8.25
                    PE_alt[i] = 722.93
                    alt_width[i] = 13.533
                    width_range[i] = 5.4 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 609.1
                    rec_width[i] = 6.25
                    PE_alt[i] = 608.47
                    alt_width[i] = 10.967
                    width_range[i] = 4.717 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 519.4
                    rec_width[i] = 4.9
                    PE_alt[i] = 519.0
                    alt_width[i] = 9.18
                    width_range[i] = 5.1 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 331.6
                    rec_width[i] = 4.1
                    PE_alt[i] = 330.83
                    alt_width[i] = 6.813
                    width_range[i] = 1.487 #GUESS
                    if transitionLine[i] == 'N4N6':
                        PE_alt[i] = 258.0
                        alt_width[i] = 8.4
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 314.6
                    width[i] = 4.33
                    rec_width[i] = 3.95
                    PE_alt[i] = 313.57
                    alt_width[i] = 6.503
                    width_range[i] = 3.0 #GUESS
                    if transitionLine[i] == 'N5N6':
                        PE_alt[i] = 243.6
                        alt_width[i] = 7.62
                    elif transitionLine[i] == 'N5N7':
                        PE_alt[i] = 243.6
                        alt_width[i] = 7.57
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 74.5
                    rec_width[i] = 0.35
                    PE_alt[i] = 74.15
                    alt_width[i] = 0.31
                    width_range[i] = 0.09 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 71.2
                    rec_width[i] = 0.31
                    PE_alt[i] = 70.67
                    alt_width[i] = 0.28
                    width_range[i] = 0.08 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 101.7
                    PE_alt[i] = 102.35
                    alt_width[i] = 15.77
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 65.3
                    PE_alt[i] = 65.65
                    alt_width[i] = 7.48
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 51.7
                    PE_alt[i] = 51.43
                    alt_width[i] = 6.12
                    width_range[i] = 1.0 #GUESS
                else:
                    PE_lit[i] = 78395.0


            elif element[i]== 'Au':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 80725.0
                    width[i] = 52.0
                    rec_width[i] = 52.1
                    PE_alt[i] = 80724.95
                    alt_width[i] = 51.707
                    width_range[i] = 0.687 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 66400.0
                        alt_width[i] = 64.58
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 66989.5
                        alt_width[i] = 57.21
                        width_range[i] = 0.79
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 68804.0
                        alt_width[i] = 56.9
                        width_range[i] = 0.5
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 77301.2
                        alt_width[i] = 69.68
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 77580.0
                        alt_width[i] = 63.73
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 77985.0
                        alt_width[i] = 61.89
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 78440.0
                        alt_width[i] = 53.27
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 78530.0
                        alt_width[i] = 53.21
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 79963.3
                        alt_width[i] = 66.63
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 80076.5
                        alt_width[i] = 64.63
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 80186.2
                        alt_width[i] = 60.53
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 80371.0
                        alt_width[i] = 59.14
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 80389.0
                        alt_width[i] = 58.3
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 80667.0
                        alt_width[i] = 59.51
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 80669.0
                        alt_width[i] = 59.33
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 14353.0
                    width[i] = 11.5
                    rec_width[i] = 9.8
                    PE_alt[i] = 14352.9
                    alt_width[i] = 11.3
                    width_range[i] = 2.3 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 10921.0
                        alt_width[i] = 32.33
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 11204.6
                        alt_width[i] = 23.54
                        width_range[i] = 2.84
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 11610.0
                        alt_width[i] = 21.47
                        width_range[i] = 3.07
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 12062.0
                        alt_width[i] = 15.89
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 12147.45
                        alt_width[i] = 15.85
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 13578.2
                        alt_width[i] = 29.26
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 13709.0
                        alt_width[i] = 22.69
                        width_range[i] = 4.59
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 13361.5
                        alt_width[i] = 19.79
                        width_range[i] = 3.39
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 13999.3
                        alt_width[i] = 21.78
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 14019.9
                        alt_width[i] = 20.94
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 14263.1
                        alt_width[i] = 13.99
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 14266.8
                        alt_width[i] = 13.93
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 14238.5
                        alt_width[i] = 31.9
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 14280.0
                        alt_width[i] = 22.15
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 14299.0
                        alt_width[i] = 21.97
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 14350.0
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 14358.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 13734.0
                    rec_width[i] = 5.53
                    PE_alt[i] = 13733.3
                    alt_width[i] = 5.643
                    width_range[i] = 0.357 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 10308.0
                        alt_width[i] = 24.07
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 10589.5
                        alt_width[i] = 18.11
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 10994.54
                        alt_width[i] = 16.27
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 11442.45
                        alt_width[i] = 8.07
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 11526.8
                        alt_width[i] = 7.65
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 12974.2
                        alt_width[i] = 21.0
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 13080.0
                        alt_width[i] = 19.01
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 13186.8
                        alt_width[i] = 14.91
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 13381.0
                        alt_width[i] = 12.51
                        width_range[i] = 1.01
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 13396.01
                        alt_width[i] = 12.69
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 13648.5
                        alt_width[i] = 5.79
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 13646.2
                        alt_width[i] = 5.73
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 13626.0
                        alt_width[i] = 23.83
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 13730.4
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 11919.0
                    rec_width[i] = 5.54
                    PE_alt[i] = 11918.35
                    alt_width[i] = 5.44
                    width_range[i] = 0.1 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 8494.03
                        alt_width[i] = 24.09
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 8770.31
                        alt_width[i] = 18.09
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 9174.6
                        alt_width[i] = 16.25
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 9628.05
                        alt_width[i] = 7.61
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 9713.44
                        alt_width[i] = 8.09
                        width_range[i] = 0.52
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 11160.0
                        alt_width[i] = 20.98
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 11274.4
                        alt_width[i] = 18.99
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 11371.4
                        alt_width[i] = 14.89
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 11566.81
                        alt_width[i] = 13.5
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 11584.0
                        alt_width[i] = 11.93
                        width_range[i] = 0.73
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 11828.7
                        alt_width[i] = 5.77
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 11832.3
                        alt_width[i] = 5.71
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 11810.3
                        alt_width[i] = 23.81
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 11916.15
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 11916.3
                    elif transitionLine[i] == 'L3P1':
                        PE_alt[i] = 11935.0
                    elif transitionLine[i] == 'L3P2':
                        PE_alt[i] = 11935.5
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 3425.0
                    width[i] = 14.3
                    rec_width[i] = 15.0
                    PE_alt[i] = 3424.95
                    alt_width[i] = 18.19
                    width_range[i] = 3.19 #GUESS
                    if transitionLine[i] == 'M1N3':
                        PE_alt[i] = 2883.0
                        alt_width[i] = 28.18
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 3148.0
                    width[i] = 10.9
                    rec_width[i] = 9.5
                    PE_alt[i] = 3147.9
                    alt_width[i] = 10.97
                    width_range[i] = 1.74 #GUESS
                    if transitionLine[i] == 'M2N4':
                        PE_alt[i] = 2797.0
                        alt_width[i] = 20.83
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 2743.0
                    width[i] = 7.65
                    rec_width[i] = 8.5
                    PE_alt[i] = 2743.0
                    alt_width[i] = 10.487
                    width_range[i] = 1.613 #GUESS
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 1971.0
                        alt_width[i] = 18.24
                        width_range[i] = 8.24
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 2391.0
                        alt_width[i] = 18.99
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 2410.0
                        alt_width[i] = 18.15
                    elif transitionLine[i] == 'M3O1':
                        PE_alt[i] = 2636.0
                        alt_width[i] = 29.3
                    elif transitionLine[i] == 'M3O4':
                        PE_alt[i] = 2742.0
                    elif transitionLine[i] == 'M3O5':
                        PE_alt[i] = 2742.0
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 2291.0
                    width[i] = 1.93
                    rec_width[i] = 2.18
                    PE_alt[i] = 2291.05
                    alt_width[i] = 5.74
                    width_range[i] = 7.06 #GUESS ZERO
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1647.0
                        alt_width[i] = 15.84
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 1746.0
                        alt_width[i] = 11.74
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 2204.6
                        alt_width[i] = 5.56
                        width_range[i] = 2.94
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 2222.15
                        alt_width[i] = 10.72
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 2206.0
                    width[i] = 1.99
                    rec_width[i] = 2.18
                    PE_alt[i] = 2205.854
                    alt_width[i] = 5.673
                    width_range[i] = 6.987 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 1660.5
                        alt_width[i] = 11.69
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 2122.9
                        alt_width[i] = 2.5
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 2118.0
                        alt_width[i] = 2.52
                    elif transitionLine[i] == 'M5O3':
                        PE_alt[i] = 2150.0
                        alt_width[i] = 10.49
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 762.1
                    rec_width[i] = 8.5
                    PE_alt[i] = 758.9
                    alt_width[i] = 12.05
                    width_range[i] = 4.5 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 642.7
                    rec_width[i] = 6.4
                    PE_alt[i] = 643.85
                    alt_width[i] = 10.005
                    width_range[i] = 3.605 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 546.3
                    rec_width[i] = 5.05
                    PE_alt[i] = 545.7
                    alt_width[i] = 7.28
                    width_range[i] = 2.5 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 353.2
                    rec_width[i] = 4.1
                    PE_alt[i] = 352.0
                    alt_width[i] = 6.11
                    width_range[i] = 2.01 #GUESS
                    if transitionLine[i] == 'N4N6':
                        PE_alt[i] = 265.0
                        alt_width[i] = 8.51
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 335.1
                    width[i] = 4.58
                    rec_width[i] = 3.9
                    PE_alt[i] = 333.95
                    alt_width[i] = 5.59
                    width_range[i] = 2.2 #GUESS
                    if transitionLine[i] == 'N5N6':
                        PE_alt[i] = 251.0
                        alt_width[i] = 7.63
                    elif transitionLine[i] == 'N5N7':
                        PE_alt[i] = 251.0
                        alt_width[i] = 7.63
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 87.6
                    rec_width[i] = 0.37
                    PE_alt[i] = 86.9
                    alt_width[i] = 0.38
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 84.0
                    rec_width[i] = 0.33
                    PE_alt[i] = 83.17
                    alt_width[i] = 0.33
                    width_range[i] = 0.08 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 107.2
                    PE_alt[i] = 107.9
                    alt_width[i] = 18.43
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 74.2
                    PE_alt[i] = 71.85
                    alt_width[i] = 8.49
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 57.2
                    PE_alt[i] = 54.87
                else:
                    PE_lit[i] = 80725.0


            elif element[i]== 'Hg':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 83102.0
                    rec_width[i] = 54.8
                    PE_alt[i] = 83102.65
                    alt_width[i] = 54.36
                    width_range[i] = 0.68 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 68260.5
                        alt_width[i] = 67.45
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 68895.0
                        alt_width[i] = 62.74
                        width_range[i] = 5.46
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 70819.5
                        alt_width[i] = 61.35
                        width_range[i] = 3.4
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 79541.6
                        alt_width[i] = 72.54
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 79823.3
                        alt_width[i] = 67.78
                        width_range[i] = 1.18
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 80254.2
                        alt_width[i] = 64.77
                        width_range[i] = 1.2
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 80717.1
                        alt_width[i] = 55.98
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 80807.6
                        alt_width[i] = 55.95
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 82302.4
                        alt_width[i] = 68.83
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 82435.0
                        alt_width[i] = 67.34
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 82545.0
                        alt_width[i] = 63.03
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 82726.0
                        alt_width[i] = 61.82
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 82745.3
                        alt_width[i] = 60.94
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 83040.0
                        alt_width[i] = 62.6
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 83040.0
                        alt_width[i] = 63.5
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 14839.0
                    rec_width[i] = 10.5
                    PE_alt[i] = 14839.15
                    alt_width[i] = 11.86
                    width_range[i] = 1.92 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 11272.0
                        alt_width[i] = 32.64
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 11563.0
                        alt_width[i] = 23.2
                        width_range[i] = 3.5
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 11995.4
                        alt_width[i] = 20.64
                        width_range[i] = 3.24
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 12446.0
                        alt_width[i] = 16.07
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 1256.0
                        alt_width[i] = 16.05
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 14045.8
                        alt_width[i] = 28.91
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 14162.3
                        alt_width[i] = 27.43
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 14264.7
                        alt_width[i] = 23.13
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 14465.5
                        alt_width[i] = 21.92
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 14474.3
                        alt_width[i] = 21.04
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 14739.1
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 14743.2
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 14570.0
                        alt_width[i] = 34.53
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 14757.0
                        alt_width[i] = 22.69
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 14778.0
                        alt_width[i] = 23.6
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 14847.0
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 14847.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 14209.0
                    rec_width[i] = 5.69
                    PE_alt[i] = 14208.85
                    alt_width[i] = 5.807
                    width_range[i] = 0.363 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 10651.4
                        alt_width[i] = 24.43
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 10888.0
                        alt_width[i] = 18.49
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 11357.9
                        alt_width[i] = 15.67
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 11822.7
                        alt_width[i] = 8.29
                        width_range[i] = 0.42
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 11913.2
                        alt_width[i] = 7.84
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 13410.0
                        alt_width[i] = 20.7
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 13530.8
                        alt_width[i] = 19.22
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 13640.3
                        alt_width[i] = 14.92
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 13830.2
                        alt_width[i] = 12.76
                        width_range[i] = 0.96
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 13850.97
                        alt_width[i] = 12.83
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 14107.3
                        alt_width[i] = 5.89
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 14109.3
                        alt_width[i] = 5.87
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 14090.0
                        alt_width[i] = 26.32
                    elif transitionLine[i] == 'L2O2':
                        PE_alt[i] = 14114.0
                        alt_width[i] = 14.48
                    elif transitionLine[i] == 'L2O3':
                        PE_alt[i] = 14156.0
                        alt_width[i] = 15.39
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 14199.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 12284.0
                    rec_width[i] = 5.71
                    PE_alt[i] = 12286.95
                    alt_width[i] = 5.583
                    width_range[i] = 0.127 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 8721.32
                        alt_width[i] = 24.41
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 9019.5
                        alt_width[i] = 18.47
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 9455.6
                        alt_width[i] = 15.65
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 9897.68
                        alt_width[i] = 8.32
                        width_range[i] = 0.48
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 9988.9
                        alt_width[i] = 7.96
                        width_range[i] = 0.14
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 11482.5
                        alt_width[i] = 20.68
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 11642.6
                        alt_width[i] = 19.2
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 11713.0
                        alt_width[i] = 14.9
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 11904.1
                        alt_width[i] = 13.68
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 11924.2
                        alt_width[i] = 11.61
                        width_range[i] = 1.21
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 12183.0
                        alt_width[i] = 5.87
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 12194.0
                        alt_width[i] = 5.85
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 12163.0
                        alt_width[i] = 26.3
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 12276.9
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 12277.0
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 3562.0
                    rec_width[i] = 15.1
                    PE_alt[i] = 3561.8
                    alt_width[i] = 18.993
                    width_range[i] = 4.007 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 3279.0
                    rec_width[i] = 9.8
                    PE_alt[i] = 3278.75
                    alt_width[i] = 10.91
                    width_range[i] = 2.02 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 2847.0
                    rec_width[i] = 8.6
                    PE_alt[i] = 2847.05
                    alt_width[i] = 11.237
                    width_range[i] = 3.763 #GUESS
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 2036.0
                        alt_width[i] = 25.26
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 2458.69
                        alt_width[i] = 18.26
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 2487.5
                        alt_width[i] = 17.38
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 2385.0
                    rec_width[i] = 2.28
                    PE_alt[i] = 2384.95
                    alt_width[i] = 2.293
                    width_range[i] = 0.013 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1721.63
                        alt_width[i] = 15.97
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 1805.0
                        alt_width[i] = 11.67
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 2283.0
                        alt_width[i] = 2.64
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 2307.46
                        alt_width[i] = 11.23
                    elif transitionLine[i] == 'M4O3':
                        alt_width[i] = 12.13
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 2295.0
                    rec_width[i] = 2.28
                    PE_alt[i] = 2294.95
                    alt_width[i] = 2.42
                    width_range[i] = 0.28 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 1722.5
                        alt_width[i] = 11.64
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 2195.3
                        alt_width[i] = 2.59
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 2187.3
                        alt_width[i] = 2.61
                    elif transitionLine[i] == 'M5O3':
                        alt_width[i] = 12.11
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 802.2
                    rec_width[i] = 8.8
                    PE_alt[i] = 800.15
                    alt_width[i] = 13.313
                    width_range[i] = 4.8 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 680.2
                    rec_width[i] = 6.55
                    PE_alt[i] = 676.95
                    alt_width[i] = 11.073
                    width_range[i] = 4.523 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 576.6
                    rec_width[i] = 5.3
                    PE_alt[i] = 571.0
                    alt_width[i] = 9.22
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 378.2
                    rec_width[i] = 4.0
                    PE_alt[i] = 378.65
                    alt_width[i] = 6.717
                    width_range[i] = 2.717 #GUESS
                    if transitionLine[i] == 'N4N6':
                        PE_alt[i] = 274.0
                        alt_width[i] = 8.48
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 358.8
                    rec_width[i] = 3.85
                    PE_alt[i] = 359.9
                    alt_width[i] = 6.373
                    width_range[i] = 3.0 #GUESS
                    if transitionLine[i] == 'N5N6':
                        PE_alt[i] = 259.0
                        alt_width[i] = 7.6
                    elif transitionLine[i] == 'N5N7':
                        PE_alt[i] = 259.0
                        alt_width[i] = 7.58
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 104.0
                    rec_width[i] = 0.33
                    PE_alt[i] = 102.83
                    alt_width[i] = 0.287
                    width_range[i] = 0.087 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 99.9
                    rec_width[i] = 0.31
                    PE_alt[i] = 98.9
                    alt_width[i] = 0.273
                    width_range[i] = 0.12 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 127.0
                    PE_alt[i] = 120.15
                    alt_width[i] = 20.76
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 83.1
                    PE_alt[i] = 80.75
                    alt_width[i] = 8.92
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 64.5
                    PE_alt[i] = 59.13
                    alt_width[i] = 9.83
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'O4':
                    PE_lit[i] = 9.6
                    PE_alt[i] = 6.97
                elif photoelectronLine[i] == 'O5':
                    PE_lit[i] = 7.8
                    PE_alt[i] = 6.37
                else:
                    PE_lit[i] = 83102.0


            elif element[i]== 'Tl':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 85530.0
                    rec_width[i] = 57.6
                    PE_alt[i] = 85530.7
                    alt_width[i] = 57.15
                    width_range[i] = 0.7 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 70185.1
                        alt_width[i] = 70.35
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 70832.5
                        alt_width[i] = 62.99
                        width_range[i] = 0.81
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 72872.5
                        alt_width[i] = 62.63
                        width_range[i] = 0.48
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 81827.0
                        alt_width[i] = 75.5
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 782118.4
                        alt_width[i] = 69.58
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 82576.7
                        alt_width[i] = 66.78
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 83045.6
                        alt_width[i] = 58.86
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 83141.7
                        alt_width[i] = 58.83
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 84685.5
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 84948.5
                        alt_width[i] = 70.19
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 84948.5
                        alt_width[i] = 65.68
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 85125.4
                        alt_width[i] = 64.54
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 85145.9
                        alt_width[i] = 63.69
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 85451.0
                        alt_width[i] = 65.62
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 85451.0
                        alt_width[i] = 68.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 15347.0
                    width[i] = 12.4
                    rec_width[i] = 11.1
                    PE_alt[i] = 14346.85
                    alt_width[i] = 12.33
                    width_range[i] = 1.57 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 11648.0
                        alt_width[i] = 32.95
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 11930.78
                        alt_width[i] = 24.32
                        width_range[i] = 2.72
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 11995.4
                        alt_width[i] = 21.97
                        width_range[i] = 2.27
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 12862.7
                        alt_width[i] = 16.31
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 12958.7
                        alt_width[i] = 16.28
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 14502.6
                        alt_width[i] = 29.06
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 14625.2
                        alt_width[i] = 23.48
                        width_range[i] = 4.18
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 14737.0
                        alt_width[i] = 20.47
                        width_range[i] = 2.67
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 14937.4
                        alt_width[i] = 22.0
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 14959.4
                        alt_width[i] = 21.14
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 15222.7
                        alt_width[i] = 14.2
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 15227.1
                        alt_width[i] = 14.18
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 15198.0
                        alt_width[i] = 37.31
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 15248.2
                        alt_width[i] = 23.07
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 15271.6
                        alt_width[i] = 25.45
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 15332.7
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 15332.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 14698.0
                    rec_width[i] = 5.87
                    PE_alt[i] = 14697.95
                    alt_width[i] = 5.973
                    width_range[i] = 0.347 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 10994.36
                        alt_width[i] = 24.77
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 11274.2
                        alt_width[i] = 18.86
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 11739.7
                        alt_width[i] = 16.06
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 12213.44
                        alt_width[i] = 8.57
                        width_range[i] = 0.43
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 12309.36
                        alt_width[i] = 8.11
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 13852.77
                        alt_width[i] = 20.88
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 14057.0
                        alt_width[i] = 19.47
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 14089.5
                        alt_width[i] = 14.96
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 14291.58
                        alt_width[i] = 12.77
                        width_range[i] = 1.07
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 1413.2
                        alt_width[i] = 12.97
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 14575.0
                        alt_width[i] = 6.02
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 14579.4
                        alt_width[i] = 6.0
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 14564.0
                        alt_width[i] = 29.14
                    elif transitionLine[i] == 'L2O2':
                        PE_alt[i] = 14604.0
                        alt_width[i] = 14.9
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 14685.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 12658.0
                    rec_width[i] = 5.89
                    PE_alt[i] = 12657.25
                    alt_width[i] = 5.75
                    width_range[i] = 0.14 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 8953.28
                        alt_width[i] = 24.75
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 9241.79
                        alt_width[i] = 18.84
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 9700.75
                        alt_width[i] = 16.03
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 10172.91
                        alt_width[i] = 8.12
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 10268.62
                        alt_width[i] = 8.75
                        width_range[i] = 0.66
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 11812.0
                        alt_width[i] = 20.86
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 11938.0
                        alt_width[i] = 19.45
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 12053.5
                        alt_width[i] = 14.93
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 12251.1
                        alt_width[i] = 13.8
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 12271.71
                        alt_width[i] = 12.22
                        width_range[i] = 0.72
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 12533.9
                        alt_width[i] = 6.0
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 12538.3
                        alt_width[i] = 5.97
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 12521.2
                        alt_width[i] = 29.12
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 12643.6
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 12643.6
                    elif transitionLine[i] == 'L3P1':
                        PE_alt[i] = 12660.0
                    elif transitionLine[i] == 'L3P2':
                        PE_alt[i] = 12660.7
                    elif transitionLine[i] == 'L3P3':
                        PE_alt[i] = 12660.7
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 3704.0
                    rec_width[i] = 15.1
                    PE_alt[i] = 3704.05
                    alt_width[i] = 17.07
                    width_range[i] = 1.97 #GUESS
                    if transitionLine[i] == 'M1N3':
                        PE_alt[i] = 3089.0
                        alt_width[i] = 28.27
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 3416.0
                    width[i] = 10.5
                    rec_width[i] = 10.1
                    PE_alt[i] = 3415.85
                    alt_width[i] = 11.615
                    width_range[i] = 1.515 #GUESS
                    if transitionLine[i] == 'M2N4':
                        PE_alt[i] = 3013.0
                        alt_width[i] = 21.23
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 2957.0
                    width[i] = 8.6
                    rec_width[i] = 8.7
                    PE_alt[i] = 2956.8
                    alt_width[i] = 9.515
                    width_range[i] = 0.815 #GUESS
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 2107.0
                        alt_width[i] = 25.48
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 2548.0
                        alt_width[i] = 18.42
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 2571.0
                        alt_width[i] = 17.57
                    elif transitionLine[i] == 'M3O4':
                        PE_alt[i] = 2941.0
                    elif transitionLine[i] == 'M3O5':
                        PE_alt[i] = 2947.0
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 2485.0
                    rec_width[i] = 2.38
                    PE_alt[i] = 2485.05
                    alt_width[i] = 2.395
                    width_range[i] = 0.015 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1763.0
                        alt_width[i] = 16.16
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 1893.38
                        alt_width[i] = 11.64
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 2362.0
                        alt_width[i] = 2.7
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 2386.0
                        alt_width[i] = 11.58
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 2389.0
                    rec_width[i] = 2.38
                    PE_alt[i] = 2389.65
                    alt_width[i] = 2.38
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 1778.0
                        alt_width[i] = 11.61
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 2270.6
                        alt_width[i] = 2.65
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 2265.6
                        alt_width[i] = 2.67
                    elif transitionLine[i] == 'M5O3':
                        alt_width[i] = 12.11
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 846.2
                    rec_width[i] = 9.1
                    PE_alt[i] = 845.75
                    alt_width[i] = 12.125
                    width_range[i] = 3.1 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 720.5
                    rec_width[i] = 6.7
                    PE_alt[i] = 721.65
                    alt_width[i] = 10.225
                    width_range[i] = 3.525 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 609.5
                    rec_width[i] = 5.6
                    PE_alt[i] = 609.0
                    alt_width[i] = 7.415
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 405.7
                    rec_width[i] = 3.9
                    PE_alt[i] = 406.8
                    alt_width[i] = 6.0
                    width_range[i] = 2.1 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 385.0
                    rec_width[i] = 3.8
                    PE_alt[i] = 386.1
                    alt_width[i] = 5.52
                    width_range[i] = 1.8 #GUESS
                    if transitionLine[i] == 'N5N6':
                        PE_alt[i] = 267.0
                        alt_width[i] = 7.53
                    elif transitionLine[i] == 'N5N7':
                        alt_width[i] = 7.51
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 122.2
                    rec_width[i] = 0.29
                    PE_alt[i] = 122.6
                    alt_width[i] = 0.29
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'N6O4':
                        PE_alt[i] = 107.5
                    elif transitionLine[i] == 'N6O5':
                        PE_alt[i] = 109.68
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 117.8
                    rec_width[i] = 0.27
                    PE_alt[i] = 118.4
                    alt_width[i] = 0.27
                    width_range[i] = 0.08 #GUESS
                    if transitionLine[i] == 'N7O5':
                        PE_alt[i] = 105.3
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 136.0
                    PE_alt[i] = 136.65
                    alt_width[i] = 23.41
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 94.6
                    PE_alt[i] = 99.8
                    alt_width[i] = 9.17
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 73.5
                    PE_alt[i] = 75.3
                    alt_width[i] = 11.55
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'O4':
                    PE_lit[i] = 14.7
                    PE_alt[i] = 15.65
                elif photoelectronLine[i] == 'O5':
                    PE_lit[i] = 12.5
                    PE_alt[i] = 13.05
                    alt_width[i] = 5.0 #GUESS
                    width_range[i] = 1.0 #GUESS
                else:
                    PE_lit[i] = 85530.0


            elif element[i]== 'Pb':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 88005.0
                    width[i] = 59.45
                    rec_width[i] = 60.6
                    PE_alt[i] = 88004.75
                    alt_width[i] = 60.11
                    width_range[i] = 0.78 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 72145.0
                        alt_width[i] = 73.18
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 72804.2
                        alt_width[i] = 67.01
                        width_range[i] = 1.99
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 74969.4
                        alt_width[i] = 66.57
                        width_range[i] = 1.73
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 84156.2
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 8445.0
                        alt_width[i] = 73.78
                        width_range[i] = 1.13
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 84936.0
                        alt_width[i] = 56.06
                        width_range[i] = 13.86
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 85434.0
                        alt_width[i] = 61.84
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 85535.0
                        alt_width[i] = 74.64
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 87114.5
                        alt_width[i] = 74.64
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 87238.0
                        alt_width[i] = 73.29
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 87366.9
                        alt_width[i] = 68.47
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 87571.0
                        alt_width[i] = 67.16
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 87593.2
                        alt_width[i] = 66.47
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 87922.0
                        alt_width[i] = 67.33
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 87923.0
                        alt_width[i] = 72.7
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 15861.0
                    rec_width[i] = 11.8
                    PE_alt[i] = 15860.9
                    alt_width[i] = 12.617
                    width_range[i] = 1.233 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 12010.3
                        alt_width[i] = 33.06
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 12306.0
                        alt_width[i] = 23.56
                        width_range[i] = 3.62
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 11995.4
                        alt_width[i] = 20.46
                        width_range[i] = 3.98
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 13275.8
                        alt_width[i] = 16.37
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 13377.5
                        alt_width[i] = 16.33
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 14963.0
                        alt_width[i] = 29.16
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 15101.4
                        alt_width[i] = 23.86
                        width_range[i] = 3.96
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 15218.2
                        alt_width[i] = 21.2
                        width_range[i] = 1.8
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 15427.6
                        alt_width[i] = 21.66
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 15452.8
                        alt_width[i] = 21.0
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 15717.7
                        alt_width[i] = 14.11
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 15722.6
                        alt_width[i] = 14.09
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 15699.0
                        alt_width[i] = 40.05
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 15752.0
                        alt_width[i] = 21.86
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 15777.0
                        alt_width[i] = 27.22
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 15843.0
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 15843.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 15200.0
                    rec_width[i] = 5.04
                    PE_alt[i] = 15200.0
                    alt_width[i] = 5.79
                    width_range[i] = 0.75 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 11349.4
                        alt_width[i] = 25.1
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 11648.1
                        alt_width[i] = 19.22
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 12127.8
                        alt_width[i] = 16.49
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 12613.0
                        alt_width[i] = 8.72
                        width_range[i] = 0.64
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 12720.0
                        alt_width[i] = 8.38
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 14307.6
                        alt_width[i] = 21.21
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 14441.7
                        alt_width[i] = 19.86
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 14553.3
                        alt_width[i] = 15.04
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 14764.55
                        alt_width[i] = 12.47
                        width_range[i] = 1.23
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 14791.5
                        alt_width[i] = 13.05
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 15060.0
                        alt_width[i] = 6.16
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 15061.0
                        alt_width[i] = 6.13
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 15052.7
                        alt_width[i] = 32.1
                    elif transitionLine[i] == 'L2O2':
                        PE_alt[i] = 15120.0
                        alt_width[i] = 19.27
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 15178.3
                    elif transitionLine[i] == 'L2P1':
                        PE_alt[i] = 15196.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 13035.0
                    rec_width[i] = 6.07
                    PE_alt[i] = 13035.1
                    alt_width[i] = 5.907
                    width_range[i] = 0.123 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 9184.5
                        alt_width[i] = 25.08
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 9481.16
                        alt_width[i] = 19.2
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 9967.63
                        alt_width[i] = 16.47
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 10449.59
                        alt_width[i] = 8.87
                        width_range[i] = 0.48
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 10551.6
                        alt_width[i] = 8.93
                        width_range[i] = 0.57
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 14143.2
                        alt_width[i] = 21.19
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 12270.6
                        alt_width[i] = 19.84
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 12392.0
                        alt_width[i] = 15.02
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 12601.2
                        alt_width[i] = 13.68
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 12622.8
                        alt_width[i] = 11.86
                        width_range[i] = 1.17
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 12892.6
                        alt_width[i] = 6.14
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 12897.5
                        alt_width[i] = 6.11
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 12888.0
                        alt_width[i] = 32.08
                    elif transitionLine[i] == 'L3O2':
                        PE_alt[i] = 12934.0
                        alt_width[i] = 13.89
                    elif transitionLine[i] == 'L3O3':
                        PE_alt[i] = 12945.0
                        alt_width[i] = 19.25
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 13015.0
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 13016.0
                    elif transitionLine[i] == 'L3P1':
                        PE_alt[i] = 13034.0
                    elif transitionLine[i] == 'L3P2':
                        PE_alt[i] = 13034.4
                    elif transitionLine[i] == 'L3P3':
                        PE_alt[i] = 13034.4
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 3851.0
                    width[i] = 15.5
                    rec_width[i] = 15.2
                    PE_alt[i] = 3850.85
                    alt_width[i] = 19.133
                    width_range[i] = 3.933 #GUESS
                    if transitionLine[i] == 'M1N3':
                        PE_alt[i] = 3202.0
                        alt_width[i] = 28.34
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 3554.0
                    rec_width[i] = 10.4
                    PE_alt[i] = 3554.1
                    alt_width[i] = 11.24
                    width_range[i] = 2.08 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 2664.0
                        alt_width[i] = 28.63
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 3124.0
                        alt_width[i] = 21.23
                    elif transitionLine[i] == 'M2O4':
                        PE_alt[i] = 3017.0
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 3066.0
                    rec_width[i] = 8.7
                    PE_alt[i] = 3066.6
                    alt_width[i] = 11.427
                    width_range[i] = 3.573 #GUESS
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 2174.0
                        alt_width[i] = 25.89
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 2630.0
                        alt_width[i] = 18.39
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 2652.7
                        alt_width[i] = 17.73
                    elif transitionLine[i] == 'M3O1':
                        PE_alt[i] = 2921.0
                        alt_width[i] = 36.78
                    elif transitionLine[i] == 'M3O4':
                        PE_alt[i] = 3053.0
                    elif transitionLine[i] == 'M3O5':
                        PE_alt[i] = 3053.0
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 2586.0
                    rec_width[i] = 2.48
                    PE_alt[i] = 2585.8
                    alt_width[i] = 2.497
                    width_range[i] = 0.017 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1823.0
                        alt_width[i] = 16.47
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 1942.0
                        alt_width[i] = 11.65
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 2442.7
                        alt_width[i] = 2.77
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 2477.0
                        alt_width[i] = 10.52
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 2484.0
                    rec_width[i] = 2.48
                    PE_alt[i] = 2484.0
                    alt_width[i] = 2.587
                    width_range[i] = 0.213 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 1839.5
                        alt_width[i] = 11.62
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 2345.5
                        alt_width[i] = 2.71
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 2339.7
                        alt_width[i] = 2.74
                    elif transitionLine[i] == 'M5O3':
                        PE_alt[i] = 2399.0
                        alt_width[i] = 15.85
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 891.8
                    rec_width[i] = 9.35
                    PE_alt[i] = 893.8
                    alt_width[i] = 13.553
                    width_range[i] = 5.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 761.9
                    rec_width[i] = 6.9
                    PE_alt[i] = 763.95
                    alt_width[i] = 11.287
                    width_range[i] = 4.387 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 643.5
                    rec_width[i] = 5.8
                    PE_alt[i] = 644.75
                    alt_width[i] = 9.313
                    width_range[i] = 4.3 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 434.3
                    rec_width[i] = 3.8
                    PE_alt[i] = 435.1
                    alt_width[i] = 6.467
                    width_range[i] = 2.667 #GUESS
                    if transitionLine[i] == 'N4N6':
                        PE_alt[i] = 293.0
                        alt_width[i] = 8.06
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 412.2
                    rec_width[i] = 3.8
                    PE_alt[i] = 412.95
                    alt_width[i] = 6.247
                    width_range[i] = 3.0 #GUESS
                    if transitionLine[i] == 'N5N6':
                        PE_alt[i] = 275.6
                        alt_width[i] = 7.4
                    elif transitionLine[i] == 'N5N7':
                        PE_alt[i] = 275.6
                        alt_width[i] = 7.38
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 141.7
                    rec_width[i] = 0.26
                    PE_alt[i] = 142.57
                    alt_width[i] = 0.227
                    width_range[i] = 0.067 #GUESS
                    if transitionLine[i] == 'N6O4':
                        PE_alt[i] = 121.1
                    elif transitionLine[i] == 'N6O5':
                        PE_alt[i] = 123.7
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 136.9
                    rec_width[i] = 0.23
                    PE_alt[i] = 137.67
                    alt_width[i] = 0.207
                    width_range[i] = 0.06 #GUESS
                    if transitionLine[i] == 'N7O5':
                        PE_alt[i] = 118.9
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 147.0
                    PE_alt[i] = 147.65
                    alt_width[i] = 26.19
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 106.4
                    PE_alt[i] = 104.9
                    alt_width[i] = 8.00
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 83.3
                    PE_alt[i] = 85.5
                    alt_width[i] = 13.73
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'O4':
                    PE_lit[i] = 20.7
                    PE_alt[i] = 21.9
                elif photoelectronLine[i] == 'O5':
                    PE_lit[i] = 18.1
                    PE_alt[i] = 19.6
                    alt_width[i] = 5.0 #GUESS
                    width_range[i] = 1.0 #GUESS
                else:
                    PE_lit[i] = 88005.0


            elif element[i]== 'Bi':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 90524.0
                    rec_width[i] = 63.6
                    PE_alt[i] = 90525.95
                    alt_width[i] = 63.107
                    width_range[i] = 0.787 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 74141.0
                        alt_width[i] = 76.36
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 77814.8
                        alt_width[i] = 69.255
                        width_range[i] = 0.85
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 77108.0
                        alt_width[i] = 68.9
                        width_range[i] = 0.51
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 86529.6
                        alt_width[i] = 81.68
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 86834.0
                        alt_width[i] = 75.83
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 87343.0
                        alt_width[i] = 73.15
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 87839.7
                        alt_width[i] = 64.94
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 87947.6
                        alt_width[i] = 64.91
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 89590.3
                        alt_width[i] = 77.76
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 89731.7
                        alt_width[i] = 76.47
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 89861.8
                        alt_width[i] = 71.41
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 90064.5
                        alt_width[i] = 70.02
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 90088.0
                        alt_width[i] = 69.33
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 90435.0
                        alt_width[i] = 70.5
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 90435.0
                        alt_width[i] = 77.39
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 16388.0
                    rec_width[i] = 12.3
                    PE_alt[i] = 16387.75
                    alt_width[i] = 12.913
                    width_range[i] = 1.127 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 12392.0
                        alt_width[i] = 33.38
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 12691.0
                        alt_width[i] = 27.54
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 13210.0
                        alt_width[i] = 24.86
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 13700.0
                        alt_width[i] = 16.65
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 13808.0
                        alt_width[i] = 16.62
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 15455.3
                        alt_width[i] = 31.74
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 15582.52
                        alt_width[i] = 28.19
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 15710.5
                        alt_width[i] = 23.12
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 15905.0
                        alt_width[i] = 21.73
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 15950.8
                        alt_width[i] = 21.05
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 16224.1
                        alt_width[i] = 14.26
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 16229.3
                        alt_width[i] = 14.24
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 16180.0
                        alt_width[i] = 42.19
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 16270.9
                        alt_width[i] = 22.21
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 16294.7
                        alt_width[i] = 29.11
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 16358.0
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 16358.0
                    elif transitionLine[i] == 'L1P2':
                        PE_alt[i] = 16380.2
                    elif transitionLine[i] == 'L1P3':
                        PE_alt[i] = 16379.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 15711.0
                    rec_width[i] = 6.22
                    PE_alt[i] = 15710.05
                    alt_width[i] = 6.323
                    width_range[i] = 0.347 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 11712.0
                        alt_width[i] = 25.42
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 11984.0
                        alt_width[i] = 15.58
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 12534.75
                        alt_width[i] = 16.9
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 13023.65
                        alt_width[i] = 9.15
                        width_range[i] = 0.46
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 13131.1
                        alt_width[i] = 8.66
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 14773.3
                        alt_width[i] = 23.78
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 14859.0
                        alt_width[i] = 20.23
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 15031.8
                        alt_width[i] = 15.17
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 15247.5
                        alt_width[i] = 13.14
                        width_range[i] = 0.64
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 15271.2
                        alt_width[i] = 13.09
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 15552.0
                        alt_width[i] = 6.3
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 15553.5
                        alt_width[i] = 6.28
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 15551.0
                        alt_width[i] = 34.24
                    elif transitionLine[i] == 'L2O2':
                        PE_alt[i] = 15617.8
                        alt_width[i] = 21.15
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 15685.3
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 13419.0
                    rec_width[i] = 6.27
                    PE_alt[i] = 13418.3
                    alt_width[i] = 6.103
                    width_range[i] = 0.167 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 9420.43
                        alt_width[i] = 25.4
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 9725.6
                        alt_width[i] = 19.57
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 9725.6
                        alt_width[i] = 19.57
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 10731.0
                        alt_width[i] = 8.67
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 10839.0
                        alt_width[i] = 9.22
                        width_range[i] = 0.58
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 12481.35
                        alt_width[i] = 23.76
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 12615.0
                        alt_width[i] = 20.21
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 12738.0
                        alt_width[i] = 15.15
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 12955.0
                        alt_width[i] = 13.76
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 12980.0
                        alt_width[i] = 12.59
                        width_range[i] = 0.49
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 13256.2
                        alt_width[i] = 6.28
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 13261.5
                        alt_width[i] = 6.26
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 13259.0
                        alt_width[i] = 34.22
                    elif transitionLine[i] == 'L3O2':
                        PE_alt[i] = 13298.0
                        alt_width[i] = 14.24
                    elif transitionLine[i] == 'L3O3':
                        PE_alt[i] = 13395.0
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 13395.0
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 13395.0
                    elif transitionLine[i] == 'L3P2':
                        PE_alt[i] = 13415.9
                    elif transitionLine[i] == 'L3P3':
                        PE_alt[i] = 13415.9
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 3999.0
                    rec_width[i] = 15.2
                    PE_alt[i] = 3999.05
                    alt_width[i] = 18.747
                    width_range[i] = 3.547 #GUESS
                    if transitionLine[i] == 'M1N2':
                        PE_alt[i] = 3185.0
                        alt_width[i] = 33.49
                    elif transitionLine[i] == 'M1N3':
                        PE_alt[i] = 3315.0
                        alt_width[i] = 28.43
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 3696.0
                    rec_width[i] = 10.7
                    PE_alt[i] = 3696.65
                    alt_width[i] = 12.933
                    width_range[i] = 2.233 #GUESS
                    if transitionLine[i] == 'M2N4':
                        PE_alt[i] = 3234.0
                        alt_width[i] = 33.49
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 3177.0
                    rec_width[i] = 8.6
                    PE_alt[i] = 3176.95
                    alt_width[i] = 10.04
                    width_range[i] = 1.44 #GUESS
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 2239.0
                        alt_width[i] = 28.43
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 2712.0
                        alt_width[i] = 18.52
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 2735.0
                        alt_width[i] = 17.83
                    elif transitionLine[i] == 'M3O1':
                        PE_alt[i] = 3021.0
                        alt_width[i] = 38.98
                    elif transitionLine[i] == 'M3O4':
                        PE_alt[i] = 3160.0
                    elif transitionLine[i] == 'M3O5':
                        PE_alt[i] = 3153.0
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 2688.0
                    rec_width[i] = 2.58
                    PE_alt[i] = 2687.8
                    alt_width[i] = 2.69
                    width_range[i] = 0.19 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1883.0
                        alt_width[i] = 16.76
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 2012.0
                        alt_width[i] = 11.7
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 2525.5
                        alt_width[i] = 2.83
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 2571.0
                        alt_width[i] = 10.79
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 2580.0
                    rec_width[i] = 2.58
                    PE_alt[i] = 2579.8
                    alt_width[i] = 2.633
                    width_range[i] = 0.107 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 1901.0
                        alt_width[i] = 11.66
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 2422.6
                        alt_width[i] = 2.78
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 2417.0
                        alt_width[i] = 2.8
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 939.0
                    rec_width[i] = 9.6
                    PE_alt[i] = 938.6
                    alt_width[i] = 12.515
                    width_range[i] = 3.3 #GUESS
                    if transitionLine[i] == 'N1P2':
                        PE_alt[i] = 932.0
                    elif transitionLine[i] == 'N1P3':
                        PE_alt[i] = 932.0
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 805.2
                    rec_width[i] = 7.2
                    PE_alt[i] = 805.65
                    alt_width[i] = 10.675
                    width_range[i] = 3.475 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 678.8
                    rec_width[i] = 5.95
                    PE_alt[i] = 678.95
                    alt_width[i] = 10.49
                    width_range[i] = 5.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 464.0
                    rec_width[i] = 3.8
                    PE_alt[i] = 463.8
                    alt_width[i] = 5.745
                    width_range[i] = 1.945 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 440.1
                    rec_width[i] = 0.22
                    PE_alt[i] = 440.0
                    alt_width[i] = 5.405
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 162.3
                    rec_width[i] = 0.2
                    PE_alt[i] = 162.4
                    alt_width[i] = 0.22
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'N6O4':
                        PE_alt[i] = 135.4
                elif photoelectronLine[i] == 'N7': #Need to add in N7 button to GUI
                    PE_lit[i] = 157.0
                    PE_alt[i] = 157.53
                    alt_width[i] = 0.2
                    width_range[i] = 0.08 #GUESS
                    if transitionLine[i] == 'N7O5':
                        PE_alt[i] = 133.0
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 159.3
                    PE_alt[i] = 159.65
                    alt_width[i] = 28.16
                    width_range[i] = 6.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 119.0
                    PE_alt[i] = 116.9
                    alt_width[i] = 8.17
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 92.6
                    PE_alt[i] = 92.9
                    alt_width[i] = 15.07
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'O4':
                    PE_lit[i] = 26.9
                    PE_alt[i] = 26.75
                elif photoelectronLine[i] == 'O5':
                    PE_lit[i] = 23.8
                    PE_alt[i] = 24.6
                    alt_width[i] = 5.0 #GUESS
                    width_range[i] = 1.5 #GUESS
                else:
                    PE_lit[i] = 90524.0

            elif element[i]== 'Po':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 93105.0
                    rec_width[i] = 66.8
                    PE_alt[i] = 93103.3
                    alt_width[i] = 66.94
                    width_range[i] = 1.66 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 76173.9
                        alt_width[i] = 79.62
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 76864.4
                        alt_width[i] = 73.8
                        width_range[i] = 2.11
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 79293.0
                        alt_width[i] = 72.52
                        width_range[i] = 0.85
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 88948.8
                        alt_width[i] = 84.88
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 89247.0
                        alt_width[i] = 80.69
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 89797.0
                        alt_width[i] = 77.51
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 90307.3
                        alt_width[i] = 68.14
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 90421.5
                        alt_width[i] = 68.11
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 92115.1
                        alt_width[i] = 80.54
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 92262.0
                        alt_width[i] = 79.76
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 92400.0
                        alt_width[i] = 74.51
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 92607.3
                        alt_width[i] = 73.0
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 92632.5
                        alt_width[i] = 72.28
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 16939.0
                    rec_width[i] = 12.7
                    PE_alt[i] = 16935.4
                    alt_width[i] = 13.163
                    width_range[i] = 1.027 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 12774.9
                        alt_width[i] = 33.65
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 13085.2
                        alt_width[i] = 25.3
                        width_range[i] = 2.6
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 13638.0
                        alt_width[i] = 22.54
                        width_range[i] = 2.64
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 14133.3
                        alt_width[i] = 16.91
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 14247.6
                        alt_width[i] = 16.88
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 15941.2
                        alt_width[i] = 29.31
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 16065.0
                        alt_width[i] = 28.53
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 16218.0
                        alt_width[i] = 23.28
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 16433.4
                        alt_width[i] = 21.77
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 16458.6
                        alt_width[i] = 21.05
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 16743.3
                        alt_width[i] = 14.39
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 16749.0
                        alt_width[i] = 14.38
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 16244.0
                    rec_width[i] = 6.41
                    PE_alt[i] = 16242.1
                    alt_width[i] = 6.503
                    width_range[i] = 0.327 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 12084.7
                        alt_width[i] = 26.45
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 12393.8
                        alt_width[i] = 19.97
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 12945.7
                        alt_width[i] = 17.25
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 13447.0
                        alt_width[i] = 9.54
                        width_range[i] = 0.56
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 13557.4
                        alt_width[i] = 8.95
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 15251.0
                        alt_width[i] = 21.38
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 15388.3
                        alt_width[i] = 20.6
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 15522.7
                        alt_width[i] = 15.35
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 15744.2
                        alt_width[i] = 13.45
                        width_range[i] = 0.4
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 15768.4
                        alt_width[i] = 13.12
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 16053.1
                        alt_width[i] = 6.46
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 16058.8
                        alt_width[i] = 6.45
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 16218.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 13814.0
                    rec_width[i] = 6.46
                    PE_alt[i] = 13812.8
                    alt_width[i] = 6.28
                    width_range[i] = 0.18 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 9664.2
                        alt_width[i] = 25.7
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 9966.7
                        alt_width[i] = 19.95
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 10518.6
                        alt_width[i] = 17.23
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 11015.5
                        alt_width[i] = 9.46
                        width_range[i] = 0.49
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 11131.0
                        alt_width[i] = 9.22
                        width_range[i] = 0.29
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 12818.9
                        alt_width[i] = 21.36
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 12961.3
                        alt_width[i] = 20.58
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 13095.6
                        alt_width[i] = 15.33
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 13314.3
                        alt_width[i] = 13.82
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 13340.5
                        alt_width[i] = 13.82
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 13626.0
                        alt_width[i] = 6.44
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 13631.7
                        alt_width[i] = 6.43
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 13782.0
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 13783.0
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 4149.0
                    rec_width[i] = 15.3
                    PE_alt[i] = 4150.63
                    alt_width[i] = 19.25
                    width_range[i] = 3.95 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 3854.0
                    rec_width[i] = 11.1
                    PE_alt[i] = 3850.77
                    alt_width[i] = 11.933
                    width_range[i] = 1.767 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 3302.0
                    rec_width[i] = 8.5
                    PE_alt[i] = 3299.1
                    alt_width[i] = 11.497
                    width_range[i] = 3.503 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 2785.94
                        alt_width[i] = 18.56
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 2824.0
                        alt_width[i] = 17.83
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 2798.0
                    rec_width[i] = 2.68
                    PE_alt[i] = 2796.53
                    alt_width[i] = 2.7
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 1959.2
                        alt_width[i] = 17.05
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 2098.54
                        alt_width[i] = 11.8
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 2605.0
                        alt_width[i] = 2.91
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 2667.77
                        alt_width[i] = 11.25
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 2683.0
                    rec_width[i] = 2.68
                    PE_alt[i] = 2681.73
                    alt_width[i] = 2.787
                    width_range[i] = 0.243 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 1968.0
                        alt_width[i] = 11.77
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 2495.8
                        alt_width[i] = 2.86
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 2489.6
                        alt_width[i] = 2.87
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 995.0
                    rec_width[i] = 9.9
                    PE_alt[i] = 992.6
                    alt_width[i] = 13.337
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 851.0
                    rec_width[i] = 7.35
                    PE_alt[i] = 850.97
                    alt_width[i] = 11.563
                    width_range[i] = 4.213 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 705.0
                    rec_width[i] = 6.2
                    PE_alt[i] = 708.4
                    alt_width[i] = 9.43
                    width_range[i] = 3.6 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 500.0
                    rec_width[i] = 3.9
                    PE_alt[i] = 498.63
                    alt_width[i] = 6.26
                    width_range[i] = 2.36 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 473.0
                    rec_width[i] = 3.8
                    PE_alt[i] = 472.1
                    alt_width[i] = 5.983
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 184.0
                    rec_width[i] = 0.19
                    PE_alt[i] = 184.3
                    alt_width[i] = 0.17
                    width_range[i] = 0.04 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 184.0
                    rec_width[i] = 0.18
                    PE_alt[i] = 178.9
                    alt_width[i] = 0.163
                    width_range[i] = 0.06 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 177.0
                    PE_alt[i] = 177.25
                    alt_width[i] = 29.51
                    width_range[i] = 6.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 132.0
                    PE_alt[i] = 131.9
                    alt_width[i] = 8.53
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 104.0
                    PE_alt[i] = 103.85
                    alt_width[i] = 16.74
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'O4':
                    PE_lit[i] = 31.0
                    PE_alt[i] = 32.07
                elif photoelectronLine[i] == 'O5':
                    PE_lit[i] = 31.0
                    PE_alt[i] = 31.0
                    alt_width[i] = 4.5 #GUESS
                    width_range[i] = 1.5 #GUESS
                else:
                    PE_lit[i] = 93105.0

            elif element[i]== 'At':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 95730.0
                    rec_width[i] = 70.0
                    PE_alt[i] = 95727.97
                    alt_width[i] = 69.48
                    width_range[i] = 0.84 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 78243.8
                        alt_width[i] = 82.99
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 78944.0
                        alt_width[i] = 76.0
                        width_range[i] = 0.85
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 81514.0
                        alt_width[i] = 75.6
                        width_range[i] = 0.51
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 91413.9
                        alt_width[i] = 88.2
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 91723.0
                        alt_width[i] = 82.51
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 92304.0
                        alt_width[i] = 79.76
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 92822.6
                        alt_width[i] = 71.46
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 92943.4
                        alt_width[i] = 71.42
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 94687.9
                        alt_width[i] = 83.61
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 94846.0
                        alt_width[i] = 70.09
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 94991.0
                        alt_width[i] = 77.84
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 95198.7
                        alt_width[i] = 76.03
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 95225.8
                        alt_width[i] = 75.31
                    elif transitionLine[i] == 'KO2':
                        alt_width[i] = 77.4
                    elif transitionLine[i] == 'KO3':
                        alt_width[i] = 86.98
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 17493.0
                    rec_width[i] = 13.0
                    PE_alt[i] = 17489.17
                    alt_width[i] = 11.688
                    width_range[i] = 5.088 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 13170.1
                        alt_width[i] = 33.91
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 13486.1
                        alt_width[i] = 28.21
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 14067.3
                        alt_width[i] = 25.48
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 13876.0
                        alt_width[i] = 9.28
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 14699.7
                        alt_width[i] = 17.13
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 16444.1
                        alt_width[i] = 29.32
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 16585.4
                        alt_width[i] = 28.85
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 16729.1
                        alt_width[i] = 23.55
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 16955.0
                        alt_width[i] = 21.74
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 16982.0
                        alt_width[i] = 21.02
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 17274.3
                        alt_width[i] = 14.52
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 17280.6
                        alt_width[i] = 14.51
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 16785.0
                    rec_width[i] = 6.6
                    PE_alt[i] = 16782.33
                    alt_width[i] = 6.69
                    width_range[i] = 0.32 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 12465.3
                        alt_width[i] = 26.02
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 12781.4
                        alt_width[i] = 20.32
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 13367.3
                        alt_width[i] = 17.58
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 13876.2
                        alt_width[i] = 9.28
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 13994.9
                        alt_width[i] = 9.24
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 15739.4
                        alt_width[i] = 21.43
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 15880.6
                        alt_width[i] = 20.96
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 16024.3
                        alt_width[i] = 15.66
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 16251.7
                        alt_width[i] = 13.86
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 16277.3
                        alt_width[i] = 13.13
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 16569.6
                        alt_width[i] = 6.63
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 16575.9
                        alt_width[i] = 6.62
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 14214.0
                    rec_width[i] = 6.66
                    PE_alt[i] = 14211.83
                    alt_width[i] = 6.463
                    width_range[i] = 0.197 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 9896.4
                        alt_width[i] = 26.0
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 10212.4
                        alt_width[i] = 20.3
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 10798.4
                        alt_width[i] = 17.56
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 11305.0
                        alt_width[i] = 9.26
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 11426.5
                        alt_width[i] = 9.22
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 13170.4
                        alt_width[i] = 21.41
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 13311.7
                        alt_width[i] = 20.94
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 13455.4
                        alt_width[i] = 15.64
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 13681.3
                        alt_width[i] = 13.84
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 13708.4
                        alt_width[i] = 13.12
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 14000.7
                        alt_width[i] = 6.61
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 14007.0
                        alt_width[i] = 6.59
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 4317.0
                    rec_width[i] = 15.3
                    PE_alt[i] = 4315.23
                    alt_width[i] = 17.43
                    width_range[i] = 2.13 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 4008.0
                    rec_width[i] = 11.4
                    PE_alt[i] = 4003.93
                    alt_width[i] = 12.635
                    width_range[i] = 1.235 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 3426.0
                    rec_width[i] = 8.4
                    PE_alt[i] = 3420.83
                    alt_width[i] = 9.76
                    width_range[i] = 1.36 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 2871.42
                        alt_width[i] = 18.52
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 2912.0
                        alt_width[i] = 17.8
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 2909.0
                    rec_width[i] = 2.78
                    PE_alt[i] = 2905.83
                    alt_width[i] = 2.8
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 2020.75
                        alt_width[i] = 4.28
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 2695.0
                        alt_width[i] = 2.99
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 2787.0
                    rec_width[i] = 2.78
                    PE_alt[i] = 2784.8
                    alt_width[i] = 2.78
                    width_range[i] = 0.03 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 2032.0
                        alt_width[i] = 11.98
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 2583.0
                        alt_width[i] = 2.94
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 2583.0
                        alt_width[i] = 2.95
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 1042.0
                    rec_width[i] = 10.1
                    PE_alt[i] = 1040.73
                    alt_width[i] = 14.97
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 886.0
                    rec_width[i] = 7.6
                    PE_alt[i] = 889.9
                    alt_width[i] = 11.055
                    width_range[i] = 3.455 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 740.0
                    rec_width[i] = 6.4
                    PE_alt[i] = 744.57
                    alt_width[i] = 7.8
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 533.0
                    rec_width[i] = 3.9
                    PE_alt[i] = 531.27
                    alt_width[i] = 5.65
                    width_range[i] = 1.75 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 507.0
                    rec_width[i] = 3.85
                    PE_alt[i] = 503.55
                    alt_width[i] = 5.265
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 210.0
                    rec_width[i] = 0.17
                    PE_alt[i] = 208.5
                    alt_width[i] = 0.17
                    width_range[i] = 0.06 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 210.0
                    rec_width[i] = 0.16
                    PE_alt[i] = 200.8
                    alt_width[i] = 0.16
                    width_range[i] = 0.06 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 195.0
                    PE_alt[i] = 194.2
                    alt_width[i] = 26.23
                    width_range[i] = 6.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 148.0
                    PE_alt[i] = 146.8
                    alt_width[i] = 8.76
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 115.0
                    PE_alt[i] = 114.3
                    alt_width[i] = 18.34
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'O4':
                    PE_lit[i] = 40.0
                    PE_alt[i] = 40.45
                elif photoelectronLine[i] == 'O5':
                    PE_lit[i] = 40.0
                    PE_alt[i] = 38.7
                    alt_width[i] = 4.0 #GUESS
                    width_range[i] = 1.5 #GUESS
                else:
                    PE_lit[i] = 95730.0


            elif element[i]== 'Rn':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 98404.0
                    rec_width[i] = 73.4
                    PE_alt[i] = 98401.73
                    alt_width[i] = 72.89
                    width_range[i] = 0.92 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 80351.3
                        alt_width[i] = 86.47
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 81066.0
                        alt_width[i] = 82.9
                        width_range[i] = 6.6
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 83783.0
                        alt_width[i] = 79.44
                        width_range[i] = 0.83
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 93925.8
                        alt_width[i] = 91.64
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 94247.0
                        alt_width[i] = 88.61
                        width_range[i] = 2.59
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 94867.0
                        alt_width[i] = 84.33
                        width_range[i] = 1.18
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 95386.7
                        alt_width[i] = 74.89
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 95514.5
                        alt_width[i] = 74.84
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 97310.5
                        alt_width[i] = 87.04
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 97478.0
                        alt_width[i] = 86.65
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 97639.0
                        alt_width[i] = 81.37
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 97840.1
                        alt_width[i] = 79.17
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 97868.9
                        alt_width[i] = 78.45
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 18049.0
                    rec_width[i] = 13.2
                    PE_alt[i] = 18048.9
                    alt_width[i] = 13.6
                    width_range[i] = 0.9 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 13574.5
                        alt_width[i] = 34.16
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 13897.5
                        alt_width[i] = 28.84
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 14512.7
                        alt_width[i] = 23.34
                        width_range[i] = 2.34
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 15035.4
                        alt_width[i] = 17.41
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 15163.1
                        alt_width[i] = 17.36
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 16959.2
                        alt_width[i] = 29.56
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 17103.8
                        alt_width[i] = 29.17
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 17257.8
                        alt_width[i] = 23.88
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 17488.8
                        alt_width[i] = 21.69
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 17517.5
                        alt_width[i] = 20.97
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 17817.9
                        alt_width[i] = 14.65
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 17824.8
                        alt_width[i] = 14.64
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 17337.0
                    rec_width[i] = 6.81
                    PE_alt[i] = 17334.57
                    alt_width[i] = 6.89
                    width_range[i] = 0.31 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 12855.1
                        alt_width[i] = 26.34
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 13178.1
                        alt_width[i] = 20.72
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 13799.5
                        alt_width[i] = 17.85
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 14316.0
                        alt_width[i] = 10.12
                        width_range[i] = 0.53
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 14443.7
                        alt_width[i] = 9.54
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 16239.8
                        alt_width[i] = 21.74
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 16384.4
                        alt_width[i] = 21.34
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 16538.4
                        alt_width[i] = 16.06
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 16770.7
                        alt_width[i] = 13.71
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 16798.1
                        alt_width[i] = 13.15
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 17098.5
                        alt_width[i] = 6.83
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 17105.4
                        alt_width[i] = 6.82
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 14619.0
                    rec_width[i] = 6.87
                    PE_alt[i] = 14616.6
                    alt_width[i] = 6.64
                    width_range[i] = 0.23 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 10137.2
                        alt_width[i] = 26.31
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 10460.2
                        alt_width[i] = 20.69
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 11081.6
                        alt_width[i] = 17.82
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 11598.1
                        alt_width[i] = 10.03
                        width_range[i] = 0.47
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 11727.09
                        alt_width[i] = 10.03
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 13521.9
                        alt_width[i] = 21.71
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 13666.6
                        alt_width[i] = 21.31
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 13820.6
                        alt_width[i] = 16.03
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 14051.5
                        alt_width[i] = 13.84
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 14080.3
                        alt_width[i] = 13.12
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 14380.7
                        alt_width[i] = 6.8
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 14387.6
                        alt_width[i] = 6.79
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 4482.0
                    rec_width[i] = 15.3
                    PE_alt[i] = 4478.15
                    alt_width[i] = 18.39
                    width_range[i] = 3.09 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 4159.0
                    rec_width[i] = 11.7
                    PE_alt[i] = 4156.5
                    alt_width[i] = 13.27
                    width_range[i] = 1.57 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 3539.0
                    rec_width[i] = 8.3
                    PE_alt[i] = 3535.5
                    alt_width[i] = 10.46
                    width_range[i] = 2.16 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 2958.4
                        alt_width[i] = 18.38
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 3001.0
                        alt_width[i] = 17.66
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 3022.0
                    rec_width[i] = 2.88
                    PE_alt[i] = 3018.6
                    alt_width[i] = 2.947
                    width_range[i] = 0.067 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 2083.09
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 2242.21
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 2780.0
                        alt_width[i] = 3.08
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 2859.31
                        alt_width[i] = 11.79
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 2892.0
                    rec_width[i] = 2.88
                    PE_alt[i] = 2889.53
                    alt_width[i] = 2.857
                    width_range[i] = 0.047 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 2097.0
                        alt_width[i] = 12.27
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 2661.0
                        alt_width[i] = 3.03
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 2661.0
                        alt_width[i] = 3.04
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 1097.0
                    rec_width[i] = 10.4
                    PE_alt[i] = 1093.75
                    alt_width[i] = 13.16
                    width_range[i] = 3.5 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 929.0
                    rec_width[i] = 7.8
                    PE_alt[i] = 934.73
                    alt_width[i] = 12.16
                    width_range[i] = 4.36 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 768.0
                    rec_width[i] = 6.6
                    PE_alt[i] = 775.73
                    alt_width[i] = 10.0
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 567.0
                    rec_width[i] = 4.0
                    PE_alt[i] = 564.67
                    alt_width[i] = 6.037
                    width_range[i] = 2.037 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 541.0
                    rec_width[i] = 3.9
                    PE_alt[i] = 536.05
                    alt_width[i] = 5.76
                    width_range[i] = 1.8 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 238.0
                    rec_width[i] = 0.16
                    PE_alt[i] = 234.05
                    alt_width[i] = 0.13
                    width_range[i] = 0.03 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 238.0
                    rec_width[i] = 0.16
                    PE_alt[i] = 223.6
                    alt_width[i] = 0.137
                    width_range[i] = 0.04 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 214.0
                    PE_alt[i] = 211.8
                    alt_width[i] = 23.93
                    width_range[i] = 6.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 164.0
                    PE_alt[i] = 162.75
                    alt_width[i] = 8.87
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 127.0
                    PE_alt[i] = 125.45
                    alt_width[i] = 19.89
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'O4':
                    PE_lit[i] = 48.0
                    PE_alt[i] = 48.0
                elif photoelectronLine[i] == 'O5':
                    PE_lit[i] = 48.0
                    PE_alt[i] = 46.1
                    alt_width[i] = 4.0 #GUESS
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'P1':
                    PE_lit[i] = 29.0
                    PE_alt[i] = 22.35
                else:
                    PE_lit[i] = 98404.0

            
            elif element[i]== 'Fr':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 101137.0
                    rec_width[i] = 76.9
                    PE_alt[i] = 101134.63
                    alt_width[i] = 76.373
                    width_range[i] = 0.953 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 82498.8
                        alt_width[i] = 90.06
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 83232.0
                        alt_width[i] = 83.25
                        width_range[i] = 0.96
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 86105.0
                        alt_width[i] = 82.83
                        width_range[i] = 0.57
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 96487.3
                        alt_width[i] = 95.15
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 96808.0
                        alt_width[i] = 89.64
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 97478.0
                        alt_width[i] = 86.82
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 98002.4
                        alt_width[i] = 78.43
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 98137.4
                        alt_width[i] = 78.39
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 99984.7
                        alt_width[i] = 90.65
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 100155.0
                        alt_width[i] = 90.1
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 100326.0
                        alt_width[i] = 85.04
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 100535.0
                        alt_width[i] = 82.37
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 100566.1
                        alt_width[i] = 81.71
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 18639.0
                    rec_width[i] = 13.5
                    PE_alt[i] = 18637.37
                    alt_width[i] = 13.813
                    width_range[i] = 0.827 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 13988.5
                        alt_width[i] = 34.38
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 14318.5
                        alt_width[i] = 28.87
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 14975.8
                        alt_width[i] = 26.04
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 15503.6
                        alt_width[i] = 17.66
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 15638.6
                        alt_width[i] = 17.62
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 17485.9
                        alt_width[i] = 29.88
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 17635.2
                        alt_width[i] = 29.31
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 17799.3
                        alt_width[i] = 24.26
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 18036.2
                        alt_width[i] = 21.6
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 18067.3
                        alt_width[i] = 20.94
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 18375.3
                        alt_width[i] = 16.29
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 18382.3
                        alt_width[i] = 16.29
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 17907.0
                    rec_width[i] = 7.02
                    PE_alt[i] = 17904.33
                    alt_width[i] = 7.12
                    width_range[i] = 0.35 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 13254.0
                        alt_width[i] = 26.61
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 13584.0
                        alt_width[i] = 21.1
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 12423.4
                        alt_width[i] = 18.18
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 14770.4
                        alt_width[i] = 9.89
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 14904.1
                        alt_width[i] = 9.85
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 16751.5
                        alt_width[i] = 22.11
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 16900.7
                        alt_width[i] = 21.55
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 17064.8
                        alt_width[i] = 16.49
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 17303.4
                        alt_width[i] = 13.84
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 17332.8
                        alt_width[i] = 13.17
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 17640.8
                        alt_width[i] = 7.02
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 17647.8
                        alt_width[i] = 7.02
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 15031.0
                    rec_width[i] = 7.08
                    PE_alt[i] = 15029.27
                    alt_width[i] = 7.527
                    width_range[i] = 1.123 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 10379.8
                        alt_width[i] = 26.58
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 10709.9
                        alt_width[i] = 21.07
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 11369.3
                        alt_width[i] = 18.15
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 11895.07
                        alt_width[i] = 9.86
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 12032.0
                        alt_width[i] = 9.82
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 13877.3
                        alt_width[i] = 22.08
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 14026.6
                        alt_width[i] = 21.52
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 14190.6
                        alt_width[i] = 16.46
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 14427.5
                        alt_width[i] = 13.81
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 14452.0
                        alt_width[i] = 13.14
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 14766.6
                        alt_width[i] = 6.99
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 14773.6
                        alt_width[i] = 6.99
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 4652.0
                    rec_width[i] = 15.4
                    PE_alt[i] = 4648.85
                    alt_width[i] = 17.57
                    width_range[i] = 2.17 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 4327.0
                    rec_width[i] = 12.1
                    PE_alt[i] = 4323.33
                    alt_width[i] = 13.16
                    width_range[i] = 1.06 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 3663.0
                    rec_width[i] = 8.2
                    PE_alt[i] = 3661.1
                    alt_width[i] = 9.8
                    width_range[i] = 1.6 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 3046.9
                        alt_width[i] = 18.36
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 3092.0
                        alt_width[i] = 17.7
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 3136.0
                    rec_width[i] = 2.98
                    PE_alt[i] = 3133.97
                    alt_width[i] = 3.0
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 2146.21
                        alt_width[i] = 17.7
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 2316.1
                        alt_width[i] = 12.64
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 2877.0
                        alt_width[i] = 3.17
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 2957.9
                        alt_width[i] = 11.98
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 3000.0
                    rec_width[i] = 2.98
                    PE_alt[i] = 2998.27
                    alt_width[i] = 2.98
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 2164.0
                        alt_width[i] = 12.6
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 2743.0
                        alt_width[i] = 3.13
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 2743.0
                        alt_width[i] = 3.13
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 1153.0
                    rec_width[i] = 10.7
                    PE_alt[i] = 1151.0
                    alt_width[i] = 12.97
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 980.0
                    rec_width[i] = 8.1
                    PE_alt[i] = 986.97
                    alt_width[i] = 11.39
                    width_range[i] = 3.29 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 810.0
                    rec_width[i] = 6.8
                    PE_alt[i] = 818.37
                    alt_width[i] = 8.21
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 603.0
                    rec_width[i] = 4.1
                    PE_alt[i] = 601.67
                    alt_width[i] = 5.53
                    width_range[i] = 1.43 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 577.0
                    rec_width[i] = 3.95
                    PE_alt[i] = 573.83
                    alt_width[i] = 5.125
                    width_range[i] = 1.2 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 268.0
                    rec_width[i] = 0.15
                    PE_alt[i] = 263.3
                    alt_width[i] = 0.15
                    width_range[i] = 0.03 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 268.0
                    rec_width[i] = 0.15
                    PE_alt[i] = 259.8
                    alt_width[i] = 0.15
                    width_range[i] = 0.03 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 234.0
                    PE_alt[i] = 232.45
                    alt_width[i] = 23.23
                    width_range[i] = 6.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 182.0
                    PE_alt[i] = 179.35
                    alt_width[i] = 8.96
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 140.0
                    PE_alt[i] = 139.35
                    alt_width[i] = 21.16
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'O4':
                    PE_lit[i] = 58.0
                    PE_alt[i] = 59.0
                elif photoelectronLine[i] == 'O5':
                    PE_lit[i] = 58.0
                    PE_alt[i] = 56.8
                    alt_width[i] = 4.0 #GUESS
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'P1':
                    PE_lit[i] = 34.0
                    PE_alt[i] = 30.15
                elif photoelectronLine[i] == 'P2':
                    PE_lit[i] = 15.0
                    PE_alt[i] = 14.1
                elif photoelectronLine[i] == 'P3':
                    PE_lit[i] = 15.0
                    PE_alt[i] = 11.9
                else:
                    PE_lit[i] = 101137.0


            elif element[i]== 'Ra':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 103922.0
                    rec_width[i] = 80.6
                    PE_alt[i] = 103920.03
                    alt_width[i] = 80.00
                    width_range[i] = 0.99 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 84685.4
                        alt_width[i] = 94.4
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 85430.0
                        alt_width[i] = 88.59
                        width_range[i] = 2.61
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 88470.0
                        alt_width[i] = 86.76
                        width_range[i] = 0.69
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 99097.5
                        alt_width[i] = 97.78
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 99430.0
                        alt_width[i] = 96.17
                        width_range[i] = 2.79
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 100130.0
                        alt_width[i] = 92.43
                        width_range[i] = 1.78
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 100669.1
                        alt_width[i] = 82.11
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 100811.5
                        alt_width[i] = 82.09
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 102710.7
                        alt_width[i] = 92.87
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 100890.0
                        alt_width[i] = 93.85
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 101070.0
                        alt_width[i] = 88.54
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 103282.7
                        alt_width[i] = 85.95
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 103316.0
                        alt_width[i] = 85.44
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 19237.0
                    rec_width[i] = 13.7
                    PE_alt[i] = 19236.85
                    alt_width[i] = 14.163
                    width_range[i] = 1.227 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 14412.1
                        alt_width[i] = 34.13
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 14747.3
                        alt_width[i] = 27.38
                        width_range[i] = 2.38
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 15445.1
                        alt_width[i] = 24.52
                        width_range[i] = 2.52
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 15988.2
                        alt_width[i] = 18.49
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 16131.6
                        alt_width[i] = 18.47
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 18036.4
                        alt_width[i] = 29.25
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 18179.5
                        alt_width[i] = 30.23
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 18357.4
                        alt_width[i] = 24.92
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 18599.2
                        alt_width[i] = 22.06
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 18632.8
                        alt_width[i] = 21.61
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 18945.9
                        alt_width[i] = 15.54
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 18953.1
                        alt_width[i] = 15.55
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 19036.0
                        alt_width[i] = 24.23
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 19084.0
                        alt_width[i] = 35.76
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 19167.0
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 19170.0
                    elif transitionLine[i] == 'L1P2':
                        PE_alt[i] = 19218.0
                    elif transitionLine[i] == 'L1P3':
                        PE_alt[i] = 19218.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 18484.0
                    rec_width[i] = 7.5
                    PE_alt[i] = 18484.15
                    alt_width[i] = 7.547
                    width_range[i] = 0.133 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 13663.2
                        alt_width[i] = 26.23
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 13999.7
                        alt_width[i] = 21.84
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 14693.3
                        alt_width[i] = 19.1
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 15236.0
                        alt_width[i] = 11.08
                        width_range[i] = 0.52
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 15376.4
                        alt_width[i] = 10.55
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 17274.0
                        alt_width[i] = 21.32
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 17429.7
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 17603.0
                        alt_width[i] = 16.99
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 17848.7
                        alt_width[i] = 14.22
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 17885.5
                        alt_width[i] = 13.68
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 1823.0
                        alt_width[i] = 7.61
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 18203.5
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 18230.0
                        alt_width[i] = 29.8
                    elif transitionLine[i] == 'L2O2':
                        PE_alt[i] = 18288.0
                        alt_width[i] = 16.3
                    elif transitionLine[i] == 'L2O3':
                        PE_alt[i] = 18330.0
                        alt_width[i] = 27.83
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 18414.5
                    elif transitionLine[i] == 'L2P1':
                        PE_alt[i] = 18439.5
                    elif transitionLine[i] == 'L2P2':
                        PE_alt[i] = 18466.0
                    elif transitionLine[i] == 'L2P3':
                        PE_alt[i] = 18470.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 15444.0
                    rec_width[i] = 7.29
                    PE_alt[i] = 15444.2
                    alt_width[i] = 7.057
                    width_range[i] = 0.237 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 10622.15
                        alt_width[i] = 25.83
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 110948.0
                        alt_width[i] = 21.43
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 11660.4
                        alt_width[i] = 18.7
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 12196.26
                        alt_width[i] = 10.68
                        width_range[i] = 0.52
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 12340.0
                        alt_width[i] = 10.57
                        width_range[i] = 0.43
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 14236.2
                        alt_width[i] = 20.92
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 14386.7
                        alt_width[i] = 21.9
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 14565.8
                        alt_width[i] = 16.59
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 14808.9
                        alt_width[i] = 13.73
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 14841.8
                        alt_width[i] = 12.74
                        width_range[i] = 0.54
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 15157.7
                        alt_width[i] = 7.21
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 15165.2
                        alt_width[i] = 7.22
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 15190.0
                        alt_width[i] = 29.39
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 15377.0
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 15377.1
                    elif transitionLine[i] == 'L3P1':
                        PE_alt[i] = 15402.0
                    elif transitionLine[i] == 'L3P2':
                        PE_alt[i] = 15425.0
                    elif transitionLine[i] == 'L3P3':
                        PE_alt[i] = 15425.0
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 4822.0
                    rec_width[i] = 15.4
                    PE_alt[i] = 4822.0
                    alt_width[i] = 18.723
                    width_range[i] = 3.323 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 4490.0
                    rec_width[i] = 12.5
                    PE_alt[i] = 4488.17
                    alt_width[i] = 12.957
                    width_range[i] = 1.413 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 3792.0
                    rec_width[i] = 8.2
                    PE_alt[i] = 3790.13
                    alt_width[i] = 11.28
                    width_range[i] = 3.08 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 3136.93
                        alt_width[i] = 18.31
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 3185.0
                        alt_width[i] = 17.85
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 3248.0
                    rec_width[i] = 3.08
                    PE_alt[i] = 3104.95
                    alt_width[i] = 3.12
                    width_range[i] = 0.12 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 2210.1
                        alt_width[i] = 17.93
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 2391.39
                        alt_width[i] = 12.62
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 2966.0
                        alt_width[i] = 3.24
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 3058.38
                        alt_width[i] = 11.93
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 3105.0
                    rec_width[i] = 3.08
                    PE_alt[i] = 3104.95
                    alt_width[i] = 3.12
                    width_range[i] = 0.08 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 2231.0
                        alt_width[i] = 12.6
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 2824.0
                        alt_width[i] = 3.23
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 2824.0
                        alt_width[i] = 3.22
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 1208.0
                    rec_width[i] = 10.95
                    PE_alt[i] = 1208.2
                    alt_width[i] = 12.27
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 1058.0
                    rec_width[i] = 8.3
                    PE_alt[i] = 1057.8
                    alt_width[i] = 11.047
                    width_range[i] = 3.793 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 879.0
                    rec_width[i] = 7.0
                    PE_alt[i] = 879.05
                    alt_width[i] = 8.843
                    width_range[i] = 1.9 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 636.0
                    rec_width[i] = 4.15
                    PE_alt[i] = 635.95
                    alt_width[i] = 5.707
                    width_range[i] = 1.557 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 603.0
                    rec_width[i] = 4.0
                    PE_alt[i] = 602.85
                    alt_width[i] = 5.503
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 299.0
                    rec_width[i] = 0.15
                    PE_alt[i] = 295.27
                    alt_width[i] = 0.143
                    width_range[i] = 0.013 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 299.0
                    rec_width[i] = 0.16
                    PE_alt[i] = 292.77
                    alt_width[i] = 0.15
                    width_range[i] = 0.03 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 254.0
                    PE_alt[i] = 254.2
                    alt_width[i] = 22.33
                    width_range[i] = 6.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 200.0
                    PE_alt[i] = 200.2
                    alt_width[i] = 8.84
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 153.0
                    PE_alt[i] = 152.9
                    alt_width[i] = 20.37
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'O4':
                    PE_lit[i] = 68.0
                    PE_alt[i] = 66.33
                elif photoelectronLine[i] == 'O5':
                    PE_lit[i] = 68.0
                    PE_alt[i] = 66.33
                    alt_width[i] = 4.5 #GUESS
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'P1':
                    PE_lit[i] = 44.0
                    PE_alt[i] = 41.0
                elif photoelectronLine[i] == 'P2':
                    PE_lit[i] = 19.0
                    PE_alt[i] = 41.0
                elif photoelectronLine[i] == 'P3':
                    PE_lit[i] = 19.0
                    PE_alt[i] = 17.17
                else:
                    PE_lit[i] = 103922.0

            elif element[i]== 'Ac':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 106755.0
                    rec_width[i] = 84.4
                    PE_alt[i] = 106755.53
                    alt_width[i] = 83.733
                    width_range[i] = 1.033 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 86913.0
                        alt_width[i] = 98.24
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 87676.0
                        alt_width[i] = 91.2
                        width_range[i] = 0.81
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 90885.0
                        alt_width[i] = 90.54
                        width_range[i] = 0.56
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 101758.9
                        alt_width[i] = 101.57
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 102102.6
                        alt_width[i] = 97.23
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 102847.0
                        alt_width[i] = 94.54
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 103389.0
                        alt_width[i] = 85.9
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 103539.3
                        alt_width[i] = 85.87
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 105491.2
                        alt_width[i] = 96.49
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 10579.0
                        alt_width[i] = 97.71
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 105868.0
                        alt_width[i] = 92.51
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 106083.6
                        alt_width[i] = 89.09
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 106119.2
                        alt_width[i] = 88.99
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 19840.0
                    rec_width[i] = 14.0
                    PE_alt[i] = 19841.97
                    alt_width[i] = 14.38
                    width_range[i] = 1.16 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 14845.8
                        alt_width[i] = 34.41
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 15190.3
                        alt_width[i] = 30.07
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 15931.5
                        alt_width[i] = 15.24
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 16476.0
                        alt_width[i] = 18.74
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 16626.3
                        alt_width[i] = 18.72
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 18578.2
                        alt_width[i] = 29.33
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 18735.6
                        alt_width[i] = 30.55
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 18922.8
                        alt_width[i] = 25.34
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 19170.6
                        alt_width[i] = 21.93
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 19206.2
                        alt_width[i] = 21.83
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 19530.3
                        alt_width[i] = 15.69
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 19537.8
                        alt_width[i] = 15.71
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 19083.0
                    rec_width[i] = 8.0
                    PE_alt[i] = 15871.07
                    alt_width[i] = 7.88
                    width_range[i] = 0.19 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 14080.7
                        alt_width[i] = 27.36
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 14425.2
                        alt_width[i] = 22.22
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 15166.0
                        alt_width[i] = 19.53
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 15713.3
                        alt_width[i] = 10.89
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 15861.1
                        alt_width[i] = 10.87
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 17813.0
                        alt_width[i] = 21.48
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 17970.5
                        alt_width[i] = 21.07
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 18157.6
                        alt_width[i] = 17.49
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 18408.4
                        alt_width[i] = 14.08
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 18441.0
                        alt_width[i] = 13.98
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 18765.1
                        alt_width[i] = 7.84
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 18772.7
                        alt_width[i] = 7.86
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 15871.0
                    rec_width[i] = 7.51
                    PE_alt[i] = 15871.07
                    alt_width[i] = 7.25
                    width_range[i] = 0.27 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 10870.1
                        alt_width[i] = 26.95
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 11214.6
                        alt_width[i] = 21.81
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 11955.4
                        alt_width[i] = 19.11
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 12501.0
                        alt_width[i] = 10.48
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 12652.0
                        alt_width[i] = 10.46
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 14602.4
                        alt_width[i] = 21.07
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 14759.9
                        alt_width[i] = 20.66
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 14947.0
                        alt_width[i] = 17.08
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 15194.9
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 15230.4
                        alt_width[i] = 13.57
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 15554.5
                        alt_width[i] = 7.43
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 15562.1
                        alt_width[i] = 7.45
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 5002.0
                    rec_width[i] = 15.4
                    PE_alt[i] = 5001.3
                    alt_width[i] = 17.135
                    width_range[i] = 1.735 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 4656.0
                    rec_width[i] = 12.9
                    PE_alt[i] = 4656.27
                    alt_width[i] = 13.715
                    width_range[i] = 0.815 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 3909.0
                    rec_width[i] = 8.0
                    PE_alt[i] = 3911.57
                    alt_width[i] = 9.92
                    width_range[i] = 1.92 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 3228.39
                        alt_width[i] = 18.23
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 3279.0
                        alt_width[i] = 18.13
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 3370.0
                    rec_width[i] = 3.18
                    PE_alt[i] = 3370.1
                    alt_width[i] = 3.19
                    width_range[i] = 0.01 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 2274.8
                        alt_width[i] = 18.22
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 2468.16
                        alt_width[i] = 13.01
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 3061.0
                        alt_width[i] = 3.35
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 3160.81
                        alt_width[i] = 11.92
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 3219.0
                    rec_width[i] = 3.18
                    PE_alt[i] = 3219.3
                    alt_width[i] = 3.18
                    width_range[i] = 0.01 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 2299.0
                        alt_width[i] = 12.99
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 2910.0
                        alt_width[i] = 3.34
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 2910.0
                        alt_width[i] = 3.33
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 1269.0
                    rec_width[i] = 11.2
                    PE_alt[i] = 1269.2
                    alt_width[i] = 12.495
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 1080.0
                    rec_width[i] = 8.5
                    PE_alt[i] = 1080.0
                    alt_width[i] = 11.76
                    width_range[i] = 3.26 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 890.0
                    rec_width[i] = 7.25
                    PE_alt[i] = 890.0
                    alt_width[i] = 8.53
                    width_range[i] = 1.3 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 675.0
                    rec_width[i] = 4.2
                    PE_alt[i] = 674.6
                    alt_width[i] = 5.295
                    width_range[i] = 1.095 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 639.0
                    rec_width[i] = 4.05
                    PE_alt[i] = 640.05
                    alt_width[i] = 5.17
                    width_range[i] = 1.2 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 319.0
                    rec_width[i] = 0.15
                    PE_alt[i] = 317.7
                    alt_width[i] = 0.15
                    width_range[i] = 0.01 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 319.0
                    rec_width[i] = 0.17
                    PE_alt[i] = 313.7
                    alt_width[i] = 0.17
                    width_range[i] = 0.03 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 272.0
                    PE_alt[i] = 272.75
                    alt_width[i] = 21.18
                    width_range[i] = 6.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 215.0
                    PE_alt[i] = 215.95
                    alt_width[i] = 8.72
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 167.0
                    PE_alt[i] = 167.4
                    alt_width[i] = 12.63
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'O4':
                    PE_lit[i] = 80.0
                    PE_alt[i] = 81.65
                elif photoelectronLine[i] == 'O5':
                    PE_lit[i] = 80.0
                    PE_alt[i] = 78.85
                    alt_width[i] = 4.5 #GUESS
                    width_range[i] = 1.5 #GUESS
                else:
                    PE_lit[i] = 106755.0
            


            elif element[i]== 'Th':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 109651.0
                    width[i] = 88.2
                    rec_width[i] = 88.2
                    PE_alt[i] = 109650.33
                    alt_width[i] = 87.57
                    width_range[i] = 1.06 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 89176.6
                        alt_width[i] = 102.19
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 89954.0
                        alt_width[i] = 95.87
                        width_range[i] = 1.45
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 93350.0
                        alt_width[i] = 94.64
                        width_range[i] = 0.56
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 104465.6
                        alt_width[i] = 105.31
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 104831.0
                        alt_width[i] = 103.1
                        width_range[i] = 1.91
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 105609.9
                        alt_width[i] = 99.1
                        width_range[i] = 0.61
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 106161.0
                        alt_width[i] = 89.81
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 106318.0
                        alt_width[i] = 89.79
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 108320.0
                        alt_width[i] = 100.3
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 108509.0
                        alt_width[i] = 101.71
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 108718.0
                        alt_width[i] = 95.69
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 109082.0
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 108972.2
                        alt_width[i] = 92.89
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 109500.0
                        alt_width[i] = 95.07
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 109510.0
                        alt_width[i] = 90.7
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 20472.0
                    width[i] = 14.3
                    rec_width[i] = 14.3
                    PE_alt[i] = 20472.05
                    alt_width[i] = 14.56
                    width_range[i] = 1.12 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 15275.7
                        alt_width[i] = 34.49
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 15643.5
                        alt_width[i] = 28.36
                        width_range[i] = 2.01
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 16425.0
                        alt_width[i] = 25.26
                        width_range[i] = 2.41
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 16981.0
                        alt_width[i] = 18.98
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 17139.0
                        alt_width[i] = 18.96
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 19146.4
                        alt_width[i] = 29.49
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 19305.0
                        alt_width[i] = 30.88
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 19507.0
                        alt_width[i] = 24.86
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 19755.0
                        alt_width[i] = 21.88
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 19794.0
                        alt_width[i] = 22.07
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 20138.2
                        alt_width[i] = 15.83
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 20146.2
                        alt_width[i] = 15.86
                    elif transitionLine[i] == 'L1O1':
                        PE_alt[i] = 20174.0
                        alt_width[i] = 34.44
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 20242.0
                        alt_width[i] = 24.24
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 20292.0
                        alt_width[i] = 19.88
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 20383.0
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 20379.99
                    elif transitionLine[i] == 'L1P2':
                        PE_alt[i] = 20424.0
                    elif transitionLine[i] == 'L1P3':
                        PE_alt[i] = 20422.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 19693.0
                    width[i] = 8.5
                    rec_width[i] = 8.5
                    PE_alt[i] = 19693.1
                    alt_width[i] = 8.2
                    width_range[i] = 0.3 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 14510.0
                        alt_width[i] = 26.73
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 14870.0
                        alt_width[i] = 22.6
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 15643.1
                        alt_width[i] = 19.9
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 16202.2
                        alt_width[i] = 11.81
                        width_range[i] = 0.59
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 16359.0
                        alt_width[i] = 11.2
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 18370.0
                        alt_width[i] = 21.72
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 18524.5
                        alt_width[i] = 23.11
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 18729.0
                        alt_width[i] = 17.1
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 18982.0
                        alt_width[i] = 14.56
                        width_range[i] = 0.44
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 19011.5
                        alt_width[i] = 14.3
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 19348.0
                        alt_width[i] = 8.07
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 19366.2
                        alt_width[i] = 8.1
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 19403.0
                        alt_width[i] = 26.68
                    elif transitionLine[i] == 'L2O2':
                        PE_alt[i] = 19466.0
                        alt_width[i] = 16.48
                    elif transitionLine[i] == 'L2O3':
                        PE_alt[i] = 19506.0
                        alt_width[i] = 12.11
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 19599.0
                    elif transitionLine[i] == 'L2P1':
                        PE_alt[i] = 19629.5
                    elif transitionLine[i] == 'L2P2':
                        PE_alt[i] = 19642.0
                    elif transitionLine[i] == 'L2P3':
                        PE_alt[i] = 19642.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 16300.0
                    width[i] = 8.4
                    rec_width[i] = 7.74
                    PE_alt[i] = 16300.15
                    alt_width[i] = 7.46
                    width_range[i] = 0.33 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 11118.6
                        alt_width[i] = 26.32
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 11478.9
                        alt_width[i] = 22.19
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 12261.0
                        alt_width[i] = 19.49
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 12809.5
                        alt_width[i] = 11.31
                        width_range[i] = 0.5
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 12968.0
                        alt_width[i] = 11.35
                        width_range[i] = 0.56
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 14975.0
                        alt_width[i] = 21.31
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 15138.0
                        alt_width[i] = 22.71
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 15341.0
                        alt_width[i] = 18.36
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 15587.5
                        alt_width[i] = 13.71
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 16523.8
                        alt_width[i] = 13.35
                        width_range[i] = 0.55
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 15966.9
                        alt_width[i] = 7.66
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 15974.8
                        alt_width[i] = 7.69
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 16010.0
                        alt_width[i] = 26.26
                    elif transitionLine[i] == 'L3O2':
                        PE_alt[i] = 16074.0
                        alt_width[i] = 16.07
                    elif transitionLine[i] == 'L3O3':
                        PE_alt[i] = 16123.0
                        alt_width[i] = 11.7
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 16213.0
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 16212.0
                    elif transitionLine[i] == 'L3P1':
                        PE_alt[i] = 16241.0
                    elif transitionLine[i] == 'L3P2':
                        PE_alt[i] = 16260.0
                    elif transitionLine[i] == 'L3P3':
                        PE_alt[i] = 16260.0
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 5182.0
                    width[i] = 15.2
                    rec_width[i] = 15.5
                    PE_alt[i] = 5182.15
                    alt_width[i] = 19.003
                    width_range[i] = 3.697 #GUESS
                    if transitionLine[i] == 'M1N2':
                        PE_alt[i] = 3957.0
                        alt_width[i] = 34.01
                    elif transitionLine[i] == 'M1N2':
                        PE_alt[i] = 4230.0
                        alt_width[i] = 27.99
                    elif transitionLine[i] == 'M1O3':
                        PE_alt[i] = 5080.0
                        alt_width[i] = 23.01
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 4830.0
                    width[i] = 11.425
                    rec_width[i] = 13.2
                    PE_alt[i] = 4830.7
                    alt_width[i] = 14.46
                    width_range[i] = 1.26 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 3505.0
                        alt_width[i] = 28.49
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 4117.0
                        alt_width[i] = 20.89
                    elif transitionLine[i] == 'M2O4':
                        PE_alt[i] = 4735.0
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 4046.0
                    width[i] = 7.733
                    rec_width[i] = 8.0
                    PE_alt[i] = 4046.05
                    alt_width[i] = 10.96
                    width_range[i] = 2.96 #GUESS
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 2714.0
                        alt_width[i] = 25.79
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 3335.0
                        alt_width[i] = 18.18
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 3370.0
                        alt_width[i] = 18.37
                    elif transitionLine[i] == 'M3O1':
                        PE_alt[i] = 3780.0
                        alt_width[i] = 30.74
                    elif transitionLine[i] == 'M3O4':
                        PE_alt[i] = 3959.0
                    elif transitionLine[i] == 'M3O5':
                        PE_alt[i] = 3967.0
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 3491.0
                    width[i] = 3.613    
                    rec_width[i] = 3.28 
                    PE_alt[i] = 3490.9
                    alt_width[i] = 3.267
                    width_range[i] = 0.047 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 2322.0
                        alt_width[i] = 18.5
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 2524.0
                        alt_width[i] = 12.48
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 3145.8
                        alt_width[i] = 3.45
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 3256.0
                        alt_width[i] = 11.87
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 3332.0
                    width[i] = 3.447
                    rec_width[i] = 3.28
                    PE_alt[i] = 3332.0
                    alt_width[i] = 3.06
                    width_range[i] = 0.14 #GUESS
                    if transitionLine[i] == 'M5N2':
                        PE_alt[i] = 2322.0
                        alt_width[i] = 18.48
                    elif transitionLine[i] == 'M5N3':
                        PE_alt[i] = 2364.0
                        alt_width[i] = 12.46
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 2987.0
                        alt_width[i] = 3.43
                    elif transitionLine[i] == 'M5P3':
                        PE_alt[i] = 3298.0
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 1330.0
                    width[i] = 10.4
                    rec_width[i] = 11.5
                    PE_alt[i] = 1329.75
                    alt_width[i] = 12.103
                    width_range[i] = 0.8 #GUESS
                    if transitionLine[i] == 'N1P2':
                        PE_alt[i] = 1313.0
                    elif transitionLine[i] == 'N1P3':
                        PE_alt[i] = 1131.9
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 1168.0
                    width[i] = 8.65
                    rec_width[i] = 8.75
                    PE_alt[i] = 1168.1
                    alt_width[i] = 10.65
                    width_range[i] = 4.55 #GUESS
                    if transitionLine[i] == 'N2O4':
                        PE_alt[i] = 1072.0
                    elif transitionLine[i] == 'N2P1':
                        PE_alt[i] = 1120.0
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 966.4
                    width[i] = 7.75
                    rec_width[i] = 7.5
                    PE_alt[i] = 967.5
                    alt_width[i] = 8.227
                    width_range[i] = 1.0 #GUESS
                    if transitionLine[i] == 'N3O5':
                        PE_alt[i] = 897.0
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 712.1
                    width[i] = 5.633
                    rec_width[i] = 4.3
                    PE_alt[i] = 713.933
                    alt_width[i] = 5.267
                    width_range[i] = 0.967 #GUESS
                    if transitionLine[i] == 'N4N6':
                        PE_alt[i] = 369.3
                        alt_width[i] = 6.35
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 675.2
                    width[i] = 4.55
                    rec_width[i] = 4.1
                    PE_alt[i] = 676.67
                    alt_width[i] = 5.263
                    width_range[i] = 1.5 #GUESS
                    if transitionLine[i] == 'N5N6':
                        PE_alt[i] = 341.4
                        alt_width[i] = 6.54
                    elif transitionLine[i] == 'N5N7':
                        PE_alt[i] = 341.4
                        alt_width[i] = 6.57
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 342.4
                    rec_width[i] = 0.15
                    PE_alt[i] = 344.2
                    alt_width[i] = 0.147
                    width_range[i] = 0.007 #GUESS
                    if transitionLine[i] == 'N6O4':
                        PE_alt[i] = 250.5
                    elif transitionLine[i] == 'N6O5':
                        PE_alt[i] = 257.2
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 333.1
                    rec_width[i] = 0.18
                    PE_alt[i] = 335.0
                    alt_width[i] = 0.167
                    width_range[i] = 0.3 #GUESS
                    if transitionLine[i] == 'N7O5':
                        PE_alt[i] = 247.9
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 290.0
                    PE_alt[i] = 290.1
                    alt_width[i] = 18.76
                    width_range[i] = 5.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 229.0
                    PE_alt[i] = 230.133
                    alt_width[i] = 8.56
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 182.0
                    PE_alt[i] = 181.53
                    alt_width[i] = 4.2
                    width_range[i] = 1.0 #GUESS
                    if transitionLine[i] == 'O3P4':
                        PE_alt[i] = 181.7
                elif photoelectronLine[i] == 'O4':
                    PE_lit[i] = 92.5
                    PE_alt[i] = 94.47
                    if transitionLine[i] == 'O4Q2':
                        PE_alt[i] = 68.0
                elif photoelectronLine[i] == 'O5':
                    PE_lit[i] = 85.4
                    PE_alt[i] = 87.73
                elif photoelectronLine[i] == 'P1':
                    PE_lit[i] = 41.4
                    PE_alt[i] = 53.63
                    alt_width[i] = 2.0 #GUESS
                    width_range[i] = 0.5 #GUESS
                elif photoelectronLine[i] == 'P2':
                    PE_lit[i] = 24.5
                    PE_alt[i] = 41.27
                elif photoelectronLine[i] == 'P3':
                    PE_lit[i] = 16.6
                    PE_alt[i] = 34.43
                    alt_width[i] = 1.0 #GUESS
                    width_range[i] = 0.25 #GUESS
                else:
                    PE_lit[i] = 109651.0


            elif element[i]== 'Pa':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 112601.0
                    width[i] = 94.0
                    rec_width[i] = 92.1
                    PE_alt[i] = 112599.5
                    alt_width[i] = 91.473
                    width_range[i] = 1.053 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 91488.0
                        alt_width[i] = 106.24
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 92287.0
                        alt_width[i] = 100.19
                        width_range[i] = 0.52
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 95868.0
                        alt_width[i] = 98.73
                        width_range[i] = 0.58
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 107232.3
                        alt_width[i] = 109.16
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 107600.0
                        alt_width[i] = 105.28
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 108427.0
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 109896.2
                        alt_width[i] = 93.84
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 109153.5
                        alt_width[i] = 93.81
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 111223.1
                        alt_width[i] = 104.31
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 111405.0
                        alt_width[i] = 105.67
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 111625.0
                        alt_width[i] = 99.73
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 111859.4
                        alt_width[i] = 96.63
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 111899.8
                        alt_width[i] = 96.81
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 21105.0
                    rec_width[i] = 14.7
                    PE_alt[i] = 21107.0
                    alt_width[i] = 14.94
                    width_range[i] = 0.88 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 15744.4
                        alt_width[i] = 34.56
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 16104.1
                        alt_width[i] = 30.69
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 16930.5
                        alt_width[i] = 27.39
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 17491.9
                        alt_width[i] = 19.25
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 17666.3
                        alt_width[i] = 19.21
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 19735.1
                        alt_width[i] = 29.71
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 19872.1
                        alt_width[i] = 31.08
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 20097.6
                        alt_width[i] = 25.14
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 20371.5
                        alt_width[i] = 22.03
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 20411.9
                        alt_width[i] = 22.21
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 20751.5
                        alt_width[i] = 16.11
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 20760.4
                        alt_width[i] = 16.07
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 20882.0
                        alt_width[i] = 25.06
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 20879.99
                        alt_width[i] = 22.5
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 20314.0
                    rec_width[i] = 9.1
                    PE_alt[i] = 20313.85
                    alt_width[i] = 9.037
                    width_range[i] = 0.287 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 14946.6
                        alt_width[i] = 28.0
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 15307.6
                        alt_width[i] = 24.12
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 16138.8
                        alt_width[i] = 20.83
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 16702.0
                        alt_width[i] = 12.68
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 16869.9
                        alt_width[i] = 12.65
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 18928.6
                        alt_width[i] = 23.16
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 19104.1
                        alt_width[i] = 24.52
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 19317.0
                        alt_width[i] = 18.57
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 19568.5
                        alt_width[i] = 15.47
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 19616.3
                        alt_width[i] = 15.65
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 19955.9
                        alt_width[i] = 9.55
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 19964.8
                        alt_width[i] = 9.51
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 20216.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 16733.0
                    rec_width[i] = 7.97
                    PE_alt[i] = 16731.73
                    alt_width[i] = 7.677
                    width_range[i] = 0.347 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 11366.2
                        alt_width[i] = 26.48
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 11726.4
                        alt_width[i] = 22.29
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 12557.6
                        alt_width[i] = 19.0
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 13122.3
                        alt_width[i] = 11.16
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 13290.9
                        alt_width[i] = 11.12
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 15346.6
                        alt_width[i] = 21.63
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 15522.8
                        alt_width[i] = 22.69
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 15735.8
                        alt_width[i] = 16.74
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 15994.7
                        alt_width[i] = 13.64
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 16024.75
                        alt_width[i] = 14.13
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 16374.7
                        alt_width[i] = 7.72
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 16383.6
                        alt_width[i] = 7.68
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 16431.0
                        alt_width[i] = 29.52
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 16636.0
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 16636.0
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 5367.0
                    rec_width[i] = 15.5
                    PE_alt[i] = 5361.95
                    alt_width[i] = 17.12
                    width_range[i] = 1.62 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 5001.0
                    rec_width[i] = 13.6
                    PE_alt[i] = 5001.53
                    alt_width[i] = 14.23
                    width_range[i] = 0.63 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 3603.0
                        alt_width[i] = 28.76
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 4260.0
                        alt_width[i] = 21.07
                    elif transitionLine[i] == 'M2O4':
                        PE_alt[i] = 4906.0
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 4174.0
                    rec_width[i] = 7.9
                    PE_alt[i] = 4173.9
                    alt_width[i] = 9.735
                    width_range[i] = 1.835 #GUESS
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 2786.0
                        alt_width[i] = 25.47
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 3430.0
                        alt_width[i] = 17.78
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 3465.7
                        alt_width[i] = 17.96
                    elif transitionLine[i] == 'M3O1':
                        PE_alt[i] = 3820.0
                        alt_width[i] = 33.35
                    elif transitionLine[i] == 'M3O4':
                        PE_alt[i] = 4081.0
                    elif transitionLine[i] == 'M3O5':
                        PE_alt[i] = 4089.0
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 3611.0
                    rec_width[i] = 3.39
                    PE_alt[i] = 3609.53
                    alt_width[i] = 3.41
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 2387.6
                        alt_width[i] = 18.68
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 2625.53
                        alt_width[i] = 12.74
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 3239.7
                        alt_width[i] = 3.72
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 3559.0
                        alt_width[i] = 12.67
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 3442.0
                    rec_width[i] = 3.39
                    PE_alt[i] = 3441.07
                    alt_width[i] = 3.39
                    width_range[i] = 0.02 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 2435.0
                        alt_width[i] = 12.71
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 3072.0
                        alt_width[i] = 3.68
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 3082.3
                        alt_width[i] = 3.64
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 1387.0
                    rec_width[i] = 11.6
                    PE_alt[i] = 1387.05
                    alt_width[i] = 12.75
                    width_range[i] = 1.2 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 1224.0
                    rec_width[i] = 9.2
                    PE_alt[i] = 1224.15
                    alt_width[i] = 12.23
                    width_range[i] = 3.03 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 1007.0
                    rec_width[i] = 7.75
                    PE_alt[i] = 1006.85
                    alt_width[i] = 8.535
                    width_range[i] = 0.9 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 743.0
                    rec_width[i] = 4.4
                    PE_alt[i] = 743.2
                    alt_width[i] = 5.305
                    width_range[i] = 0.905 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 708.0
                    rec_width[i] = 4.2
                    PE_alt[i] = 708.1
                    alt_width[i] = 5.295
                    width_range[i] = 1.2 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 371.0
                    rec_width[i] = 0.29
                    PE_alt[i] = 371.1
                    alt_width[i] = 0.29
                    width_range[i] = 0.03 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 360.0
                    rec_width[i] = 0.25
                    PE_alt[i] = 359.75
                    alt_width[i] = 0.25
                    width_range[i] = 0.1 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 310.0
                    PE_alt[i] = 309.8
                    alt_width[i] = 21.79
                    width_range[i] = 5.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 232.0
                    PE_alt[i] = 230.17
                    alt_width[i] = 9.24
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 232.0
                    PE_alt[i] = 212.07
                    alt_width[i] = 6.68
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'O4':
                    PE_lit[i] = 94.0
                    PE_alt[i] = 95.13
                elif photoelectronLine[i] == 'O5':
                    PE_lit[i] = 94.0
                    PE_alt[i] = 92.43
                else:
                    PE_lit[i] = 112601.0

            elif element[i]== 'U':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 115606.0
                    width[i] = 95.75
                    rec_width[i] = 96.3
                    PE_alt[i] = 115600.3
                    alt_width[i] = 95.62
                    width_range[i] = 1.16 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 93842.0
                        alt_width[i] = 110.35
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 94665.0
                        alt_width[i] = 104.92
                        width_range[i] = 0.95
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 98439.0
                        alt_width[i] = 102.98
                        width_range[i] = 0.54
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 110052.1
                        alt_width[i] = 113.39
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 110406.0
                        alt_width[i] = 112.26
                        width_range[i] = 7.74
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 111300.0
                        alt_width[i] = 108.74
                        width_range[i] = 6.26
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 111868.0
                        alt_width[i] = 98.01
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 112043.0
                        alt_width[i] = 97.97
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 114160.4
                        alt_width[i] = 108.54
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 114407.0
                        alt_width[i] = 109.8
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 114607.0
                        alt_width[i] = 103.97
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 114820.7
                        alt_width[i] = 100.68
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 114863.6
                        alt_width[i] = 101.02
                    elif transitionLine[i] == 'KO2':
                        PE_alt[i] = 115390.0
                        alt_width[i] = 104.06
                    elif transitionLine[i] == 'KO3':
                        PE_alt[i] = 115390.0
                        alt_width[i] = 101.47
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 21757.0
                    width[i] = 16.0
                    rec_width[i] = 16.0
                    PE_alt[i] = 21757.7
                    alt_width[i] = 15.293
                    width_range[i] = 1.293 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 16575.3
                        alt_width[i] = 34.8
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 16575.0
                        alt_width[i] = 30.24
                        width_range[i] = 2.74
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 17455.0
                        alt_width[i] = 23.38
                        width_range[i] = 4.26
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 18031.2
                        alt_width[i] = 19.43
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 18205.5
                        alt_width[i] = 19.38
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 20318.3
                        alt_width[i] = 29.96
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 20484.85
                        alt_width[i] = 35.31
                        width_range[i] = 4.09
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 20712.85
                        alt_width[i] = 28.9
                        width_range[i] = 3.51
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 20979.8
                        alt_width[i] = 22.1
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 21018.45
                        alt_width[i] = 22.43
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 21368.9
                        alt_width[i] = 16.26
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 21378.7
                        alt_width[i] = 16.2
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 21498.4
                        alt_width[i] = 25.48
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 21562.5
                        alt_width[i] = 22.89
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 21657.0
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 21659.99
                    elif transitionLine[i] == 'L1P2':
                        PE_alt[i] = 21729.0
                    elif transitionLine[i] == 'L1P3':
                        PE_alt[i] = 21728.99
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 20948.0
                    width[i] = 10.0
                    rec_width[i] = 10.0
                    PE_alt[i] = 20947.8
                    alt_width[i] = 9.607
                    width_range[i] = 0.393 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 15400.0
                        alt_width[i] = 28.42
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 15765.1
                        alt_width[i] = 24.53
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 16641.5
                        alt_width[i] = 21.26
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 17220.15
                        alt_width[i] = 13.62
                        width_range[i] = 0.68
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 17395.0
                        alt_width[i] = 13.01
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 19507.27
                        alt_width[i] = 23.57
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 19676.1
                        alt_width[i] = 24.85
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 19907.2
                        alt_width[i] = 19.01
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 20167.27
                        alt_width[i] = 15.77
                        width_range[i] = 0.08
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 20210.5
                        alt_width[i] = 16.06
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 20557.5
                        alt_width[i] = 9.87
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 20567.5
                        alt_width[i] = 9.81
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 20621.0
                        alt_width[i] = 32.02
                    elif transitionLine[i] == 'L2O3':
                        PE_alt[i] = 20758.0
                        alt_width[i] = 16.51
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 20842.8
                        alt_width[i] = 16.4
                    elif transitionLine[i] == 'L2P2':
                        PE_alt[i] = 20906.0
                    elif transitionLine[i] == 'L2P3':
                        PE_alt[i] = 20899.99
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 17166.0
                    width[i] = 8.4
                    rec_width[i] = 8.2
                    PE_alt[i] = 17167.15
                    alt_width[i] = 7.867
                    width_range[i] = 0.437 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 11618.2
                        alt_width[i] = 26.89
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 11983.5
                        alt_width[i] = 22.99
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 12865.0
                        alt_width[i] = 19.73
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 13439.0
                        alt_width[i] = 12.77
                        width_range[i] = 2.88
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 13615.0
                        alt_width[i] = 12.32
                        width_range[i] = 0.85
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 15726.21
                        alt_width[i] = 19.4
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 15895.63
                        alt_width[i] = 22.03
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 16123.56
                        alt_width[i] = 17.48
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 16385.86
                        alt_width[i] = 14.19
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 16428.44
                        alt_width[i] = 14.64
                        width_range[i] = 1.46
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 16777.3
                        alt_width[i] = 8.34
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 16787.1
                        alt_width[i] = 8.28
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 16845.0
                        alt_width[i] = 30.48
                    elif transitionLine[i] == 'L3O2':
                        PE_alt[i] = 16907.0
                        alt_width[i] = 17.57
                    elif transitionLine[i] == 'L3O3':
                        PE_alt[i] = 16962.0
                        alt_width[i] = 14.98
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 17070.1
                        alt_width[i] = 11.9
                    elif transitionLine[i] == 'L3P1':
                        PE_alt[i] = 17096.0
                    elif transitionLine[i] == 'L3P2':
                        PE_alt[i] = 17118.0
                    elif transitionLine[i] == 'L3P3':
                        PE_alt[i] = 17119.0
                    elif transitionLine[i] == 'L3P4':
                        PE_alt[i] = 17162.0
                    elif transitionLine[i] == 'L3P5':
                        PE_alt[i] = 17163.0
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 5548.0
                    width[i] = 14.25
                    rec_width[i] = 15.5
                    PE_alt[i] = 5548.0
                    alt_width[i] = 19.14
                    width_range[i] = 3.86 #GUESS
                    if transitionLine[i] == 'M1N2':
                        PE_alt[i] = 4250.0
                        alt_width[i] = 34.25
                    elif transitionLine[i] == 'M1N3':
                        PE_alt[i] = 4500.0
                        alt_width[i] = 28.42
                    elif transitionLine[i] == 'M1O3':
                        PE_alt[i] = 5380.0
                        alt_width[i] = 25.92
                    elif transitionLine[i] == 'M1P3':
                        PE_alt[i] = 5505.0
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 5182.0
                    width[i] = 14.1
                    rec_width[i] = 14.1
                    PE_alt[i] = 5181.6
                    alt_width[i] = 13.707
                    width_range[i] = 1.707 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 3724.0
                        alt_width[i] = 29.09
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 4401.0
                        alt_width[i] = 19.67
                    elif transitionLine[i] == 'M2O1':
                        PE_alt[i] = 4844.0
                        alt_width[i] = 37.54
                    elif transitionLine[i] == 'M2O4':
                        PE_alt[i] = 5075.0
                        alt_width[i] = 18.7
                    elif transitionLine[i] == 'M2P1':
                        PE_alt[i] = 5119.0
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 4303.0
                    width[i] = 7.9
                    rec_width[i] = 7.9
                    PE_alt[i] = 4303.7
                    alt_width[i] = 12.22
                    width_range[i] = 4.78 #GUESS
                    if transitionLine[i] == 'M3N1':
                        PE_alt[i] = 2863.0
                        alt_width[i] = 23.01
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 3522.0
                        alt_width[i] = 15.69
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 3564.0
                        alt_width[i] = 18.31
                    elif transitionLine[i] == 'M3N7':
                        PE_alt[i] = 3920.0
                        alt_width[i] = 12.06
                    elif transitionLine[i] == 'M3O1':
                        PE_alt[i] = 3980.0
                        alt_width[i] = 36.34
                    elif transitionLine[i] == 'M3O4':
                        PE_alt[i] = 4200.0
                        alt_width[i] = 8.1
                    elif transitionLine[i] == 'M3O5':
                        PE_alt[i] = 4205.6
                        alt_width[i] = 8.2
                    elif transitionLine[i] == 'M3P1':
                        PE_alt[i] = 4231.1
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 3728.0
                    width[i] = 3.32
                    rec_width[i] = 3.5
                    PE_alt[i] = 3727.8
                    alt_width[i] = 3.55
                    width_range[i] = 0.05 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 2455.0
                        alt_width[i] = 15.73
                        width_range[i] = 3.15
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 2683.0
                        alt_width[i] = 13.05
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 3336.0
                        alt_width[i] = 3.94
                        width_range[i] = 0.34
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 3468.0
                        alt_width[i] = 13.14
                    elif transitionLine[i] == 'M4O3':
                        PE_alt[i] = 3531.3
                        alt_width[i] = 10.55
                    elif transitionLine[i] == 'M4P2':
                        PE_alt[i] = 3698.0
                    elif transitionLine[i] == 'M4P3':
                        PE_alt[i] = 3698.0
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 3552.0
                    width[i] = 3.37
                    rec_width[i] = 3.5
                    PE_alt[i] = 3551.85
                    alt_width[i] = 3.7
                    width_range[i] = 0.3 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 2507.0
                        alt_width[i] = 13.6
                        width_range[i] = 1.4
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 3161.0
                        alt_width[i] = 3.86
                        width_range[i] = 0.26
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 3171.0
                        alt_width[i] = 3.80
                        width_range[i] = 0.31
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 1439.0
                    width[i] = 12.6
                    rec_width[i] = 12.2
                    PE_alt[i] = 1441.6
                    alt_width[i] = 12.753
                    width_range[i] = 1.307 #GUESS
                    if transitionLine[i] == 'N1O3':
                        PE_alt[i] = 1229.0
                        alt_width[i] = 2.11
                    elif transitionLine[i] == 'N1P2':
                        PE_alt[i] = 1410.0
                    elif transitionLine[i] == 'N1P3':
                        PE_alt[i] = 1420.0
                    elif transitionLine[i] == 'N1P4':
                        PE_alt[i] = 1440.0
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 1271.0
                    width[i] = 9.7
                    rec_width[i] = 9.6
                    PE_alt[i] = 1272.47
                    alt_width[i] = 9.0
                    width_range[i] = 1.2 #GUESS
                    if transitionLine[i] == 'N2P1':
                        PE_alt[i] = 1192.0
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 1043.0
                    width[i] = 8.7
                    rec_width[i] = 8.0
                    PE_alt[i] = 1044.95
                    alt_width[i] = 8.437
                    width_range[i] = 1.1 #GUESS
                    if transitionLine[i] == 'N3O5':
                        PE_alt[i] = 961.0
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 778.3
                    width[i] = 4.7
                    rec_width[i] = 4.5
                    PE_alt[i] = 780.2
                    alt_width[i] = 5.04
                    width_range[i] = 1.18 #GUESS
                    if transitionLine[i] == 'N4N6':
                        PE_alt[i] = 390.0
                        alt_width[i] = 6.59
                    elif transitionLine[i] == 'N4O4':
                        PE_alt[i] = 286.0
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 736.2
                    width[i] = 4.5
                    rec_width[i] = 4.25
                    PE_alt[i] = 737.85
                    alt_width[i] = 5.067
                    width_range[i] = 1.0 #GUESS
                    if transitionLine[i] == 'N5N6':
                        PE_alt[i] = 357.0
                        alt_width[i] = 6.92
                    elif transitionLine[i] == 'N5N7':
                        PE_alt[i] = 357.0
                        alt_width[i] = 6.86
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 388.2
                    rec_width[i] = 0.37
                    PE_alt[i] = 391.33
                    alt_width[i] = 0.31
                    width_range[i] = 0.12 #GUESS
                    if transitionLine[i] == 'N6O5':
                        PE_alt[i] = 295.0
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 377.4
                    rec_width[i] = 0.31
                    PE_alt[i] = 380.6
                    alt_width[i] = 0.27
                    width_range[i] = 0.09 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 321.0
                    PE_alt[i] = 323.67
                    alt_width[i] = 22.51
                    width_range[i] = 6.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 257.0
                    PE_alt[i] = 259.5
                    alt_width[i] = 9.6
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 192.0
                    PE_alt[i] = 195.33
                    alt_width[i] = 7.01
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'O4':
                    PE_lit[i] = 102.8
                    PE_alt[i] = 104.8
                elif photoelectronLine[i] == 'O5':
                    PE_lit[i] = 94.2
                    PE_alt[i] = 95.83
                elif photoelectronLine[i] == 'P1':
                    PE_lit[i] = 43.9
                    PE_alt[i] = 63.73
                elif photoelectronLine[i] == 'P2':
                    PE_lit[i] = 26.8
                    PE_alt[i] = 38.7
                elif photoelectronLine[i] == 'P3':
                    PE_lit[i] = 16.8
                    PE_alt[i] = 32.65
                else:
                    PE_lit[i] = 115606.0

            #Values for Np and byeond were taken from Paufler, P. (2007). Handbook of X-ray data. By G. Zschornack. Pp. IX + 967. Berlin: Springer-Verlag, 2007. Price (hardback) EURâ213.95. ISBN 978-3-540-28618-9. Acta Cryst. A63, 288.
            elif element[i]== 'Np':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 118668.6
                    PE_alt[i] = 118673.3
                    alt_width[i] = 99.315
                    width_range[i] = 0.683 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 96240.6
                        alt_width[i] = 114.66
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 97077.5
                        alt_width[i] = 106.14
                        width_range[i] = 2.24
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 101068.0
                        alt_width[i] = 102.68
                        width_range[i] = 4.18
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 112928.1
                        alt_width[i] = 117.7
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 113311.8
                        alt_width[i] = 113.8
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 114243.3
                        alt_width[i] = 110.53
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 114827.7
                        alt_width[i] = 102.3
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 115012.2
                        alt_width[i] = 102.24
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 117167.4
                        alt_width[i] = 102.24
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 117350.3
                        alt_width[i] = 114.04
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 117591.2
                        alt_width[i] = 108.15
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 117862.1
                        alt_width[i] = 104.81
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 117907.7
                        alt_width[i] = 105.32
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 22426.8
                    PE_alt[i] = 22427.45
                    alt_width[i] = 15.015
                    width_range[i] = 1.015 #GUESS
                    if transitionLine[i] == 'L1L2':
                        PE_alt[i] = 4827.0
                        alt_width[i] = 25.77
                    elif transitionLine[i] == 'L1M1':
                        PE_alt[i] = 16703.6
                        alt_width[i] = 35.1
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 17060.7
                        alt_width[i] = 31.2
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 17989.3
                        alt_width[i] = 27.93
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 18576.5
                        alt_width[i] = 19.7
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 18761.0
                        alt_width[i] = 19.64
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 20926.1
                        alt_width[i] = 30.29
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 21104.0
                        alt_width[i] = 31.44
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 21338.0
                        alt_width[i] = 25.55
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 21611.0
                        alt_width[i] = 22.21
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 21656.5
                        alt_width[i] = 22.72
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 22011.9
                        alt_width[i] = 16.47
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 22022.5
                        alt_width[i] = 16.39
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 22143.8
                        alt_width[i] = 25.98
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 22200.0
                        alt_width[i] = 23.59
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 22318.0
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 22325.5
                    elif transitionLine[i] == 'L1P2':
                        PE_alt[i] = 22399.0
                    elif transitionLine[i] == 'L1P3':
                        PE_alt[i] = 22375.0
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 21600.5
                    PE_alt[i] = 21600.9
                    alt_width[i] = 9.83
                    width_range[i] = 0.08 #GUESS
                    if transitionLine[i] == 'L2L3':
                        PE_alt[i] = 3981.0
                        alt_width[i] = 17.96
                    elif transitionLine[i] == 'L2M1':
                        PE_alt[i] = 15876.0
                        alt_width[i] = 28.81
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 16234.3
                        alt_width[i] = 24.91
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 17165.8
                        alt_width[i] = 21.64
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 17750.3
                        alt_width[i] = 13.41
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 17938.0
                        alt_width[i] = 13.37
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 20107.0
                        alt_width[i] = 24.01
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 20272.8
                        alt_width[i] = 25.16
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 20513.7
                        alt_width[i] = 19.26
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 20785.0
                        alt_width[i] = 15.93
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 20830.0
                        alt_width[i] = 16.43
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 21187.0
                        alt_width[i] = 10.19
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 21195.7
                        alt_width[i] = 9.98
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 21262.0
                        alt_width[i] = 33.16
                    elif transitionLine[i] == 'L2O3':
                        PE_alt[i] = 21394.0
                        alt_width[i] = 17.31
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 21488.0
                    elif transitionLine[i] == 'L2P1':
                        PE_alt[i] = 21551.0
                    elif transitionLine[i] == 'L2P4':
                        PE_alt[i] = 21590.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 17610.0
                    PE_alt[i] = 17610.3
                    alt_width[i] = 7.905
                    width_range[i] = 3.15 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 11888.6
                        alt_width[i] = 27.28
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 12243.8
                        alt_width[i] = 23.39
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 13175.3
                        alt_width[i] = 20.11
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 13759.84
                        alt_width[i] = 11.88
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 13944.0
                        alt_width[i] = 11.83
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 16113.0
                        alt_width[i] = 22.48
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 16282.3
                        alt_width[i] = 23.63
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 16523.2
                        alt_width[i] = 17.73
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 16794.8
                        alt_width[i] = 14.4
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 16840.1
                        alt_width[i] = 14.9
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 17195.0
                        alt_width[i] = 8.66
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 17205.6
                        alt_width[i] = 8.58
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 17271.0
                        alt_width[i] = 31.61
                    elif transitionLine[i] == 'L3O2':
                        PE_alt[i] = 17326.6
                    elif transitionLine[i] == 'L3O3':
                        PE_alt[i] = 17403.9
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 17501.0
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 17508.6
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 5739.6
                    PE_alt[i] = 5731.4
                    alt_width[i] = 19.07
                    width_range[i] = 5.0 #GUESS
                    if transitionLine[i] == 'M1M3':
                        PE_alt[i] = 1306.0
                        alt_width[i] = 30.97
                    elif transitionLine[i] == 'M1N2':
                        PE_alt[i] = 4412.0
                        alt_width[i] = 34.48
                    elif transitionLine[i] == 'M1N3':
                        PE_alt[i] = 4654.0
                        alt_width[i] = 28.59
                    elif transitionLine[i] == 'M1O2':
                        PE_alt[i] = 5456.0
                        alt_width[i] = 29.02
                    elif transitionLine[i] == 'M1O3':
                        PE_alt[i] = 5533.0
                        alt_width[i] = 26.63
                    elif transitionLine[i] == 'M1P2':
                        PE_alt[i] = 5710.0
                    elif transitionLine[i] == 'M1P3':
                        PE_alt[i] = 5722.0
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 5366.2
                    PE_alt[i] = 5366.45
                    alt_width[i] = 15.17
                    width_range[i] = 4.0 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 3867.0
                        alt_width[i] = 29.43
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 4551.0
                        alt_width[i] = 21.35
                    elif transitionLine[i] == 'M2O1':
                        PE_alt[i] = 5027.0
                        alt_width[i] = 38.59
                    elif transitionLine[i] == 'M2O4':
                        PE_alt[i] = 5257.0
                    elif transitionLine[i] == 'M2P1':
                        PE_alt[i] = 5317.0
                    elif transitionLine[i] == 'M2Q1':
                        PE_alt[i] = 5360.0
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 4434.7
                    PE_alt[i] = 4434.05
                    alt_width[i] = 11.9
                    width_range[i] = 3.0 #GUESS
                    if transitionLine[i] == 'M3M4':
                        PE_alt[i] = 583.0
                        alt_width[i] = 15.57
                    elif transitionLine[i] == 'M3M5':
                        PE_alt[i] = 768.0
                        alt_width[i] = 15.51
                    elif transitionLine[i] == 'M3N1':
                        PE_alt[i] = 2933.0
                        alt_width[i] = 26.16
                    elif transitionLine[i] == 'M3N4':
                        PE_alt[i] = 3618.8
                        alt_width[i] = 18.08
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 3664.4
                        alt_width[i] = 18.59
                    elif transitionLine[i] == 'M3O1':
                        PE_alt[i] = 4094.0
                        alt_width[i] = 35.32
                    elif transitionLine[i] == 'M3O4':
                        PE_alt[i] = 4324.0
                    elif transitionLine[i] == 'M3O5':
                        PE_alt[i] = 4332.0
                    elif transitionLine[i] == 'M3P1':
                        PE_alt[i] = 4383.0
                    elif transitionLine[i] == 'M3Q1':
                        PE_alt[i] = 4430.0
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 3850.3
                    PE_alt[i] = 3850.05
                    alt_width[i] = 3.67
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'M4N1':
                        PE_alt[i] = 2350.0
                        alt_width[i] = 17.93
                    elif transitionLine[i] == 'M4N2':
                        PE_alt[i] = 2522.6
                        alt_width[i] = 19.08
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 2764.0
                        alt_width[i] = 13.19
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 3435.3
                        alt_width[i] = 4.11
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 3566.0
                        alt_width[i] = 13.62
                    elif transitionLine[i] == 'M4O3':
                        PE_alt[i] = 3644.0
                        alt_width[i] = 11.23
                    elif transitionLine[i] == 'M4P2':
                        PE_alt[i] = 3821.0
                    elif transitionLine[i] == 'M4P3':
                        PE_alt[i] = 3832.0
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 3665.8
                    PE_alt[i] = 3665.6
                    alt_width[i] = 3.61
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'M5N2':
                        PE_alt[i] = 2551.0
                    elif transitionLine[i] == 'M5N3':
                        PE_alt[i] = 2579.0
                        alt_width[i] = 13.13
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 3250.9
                        alt_width[i] = 4.06
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 3261.0
                        alt_width[i] = 3.98
                    elif transitionLine[i] == 'M5O3':
                        PE_alt[i] = 3459.0
                        alt_width[i] = 11.18
                    elif transitionLine[i] == 'M5O6':
                        PE_alt[i] = 3570.0
                    elif transitionLine[i] == 'M5P3':
                        PE_alt[i] = 3648.0
                    elif transitionLine[i] == 'M5Q7':
                        PE_alt[i] = 3570.0
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 1500.7
                    PE_alt[i] = 1500.4
                    alt_width[i] = 14.26
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 1327.7
                    PE_alt[i] = 1327.7
                    alt_width[i] = 15.4
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 1086.8
                    PE_alt[i] = 1086.4
                    alt_width[i] = 9.52
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 815.9
                    PE_alt[i] = 816.0
                    alt_width[i] = 6.18
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 770.3
                    PE_alt[i] = 770.55
                    alt_width[i] = 6.69
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 415.0
                    PE_alt[i] = 414.65
                    alt_width[i] = 0.44
                    width_range[i] = 0.05 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 404.4
                    PE_alt[i] = 403.9
                    alt_width[i] = 0.36
                    width_range[i] = 0.08 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 339.8
                    PE_alt[i] = 339.8
                    alt_width[i] = 23.42
                    width_range[i] = 5.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 283.4
                    PE_alt[i] = 283.4
                    alt_width[i] = 9.96
                    width_range[i] = 1.5 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 206.1
                    PE_alt[i] = 206.15
                    alt_width[i] = 7.57
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'O4':
                    PE_lit[i] = 109.3
                    PE_alt[i] = 109.3
                    alt_width[i] = 5.0 #GUESS
                    width_range[i] = 0.75 #GUESS
                elif photoelectronLine[i] == 'O5':
                    PE_lit[i] = 101.3
                    PE_alt[i] = 101.25
                    alt_width[i] = 5.0 #GUESS
                    width_range[i] = 0.75 #GUESS
                elif photoelectronLine[i] == 'P1':
                    PE_lit[i] = 50.0
                    PE_alt[i] = 50.0
                elif photoelectronLine[i] == 'P2':
                    PE_lit[i] = 29.3
                    PE_alt[i] = 29.3
                elif photoelectronLine[i] == 'P3':
                    PE_lit[i] = 15.5
                    PE_alt[i] = 15.5
                else:
                    PE_lit[i] = 118668.6

            
            elif element[i]== 'Pu':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 121791.1
                    PE_alt[i] = 121804.55
                    alt_width[i] = 101.307
                    width_range[i] = 5.307 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 98682.4
                        alt_width[i] = 119.07
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 99529.6
                        alt_width[i] = 103.4
                        width_range[i] = 0.5
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 103745.0
                        alt_width[i] = 104.94
                        width_range[i] = 6.44
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 115858.7
                        alt_width[i] = 123.25
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 116261.2
                        alt_width[i] = 118.24
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 117252.8
                        alt_width[i] = 114.88
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 117845.4
                        alt_width[i] = 106.72
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 118039.9
                        alt_width[i] = 106.65
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 120232.8
                        alt_width[i] = 117.35
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 120407.0
                        alt_width[i] = 118.35
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 120670.0
                        alt_width[i] = 112.57
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 120956.0
                        alt_width[i] = 109.19
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 121000.0
                        alt_width[i] = 109.7
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 23097.2
                    PE_alt[i] = 23097.6
                    alt_width[i] = 15.717
                    width_range[i] = 2.217 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 17165.3
                        alt_width[i] = 36.48
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 17756.0
                        alt_width[i] = 31.48
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 18540.6
                        alt_width[i] = 28.11
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 19130.0
                        alt_width[i] = 19.95
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 19325.0
                        alt_width[i] = 19.88
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 21000.0
                        alt_width[i] = 30.58
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 21725.2
                        alt_width[i] = 31.59
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 21985.5
                        alt_width[i] = 25.81
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 21900.0
                        alt_width[i] = 22.43
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 22300.0
                        alt_width[i] = 22.93
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 22670.7
                        alt_width[i] = 16.79
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 22682.8
                        alt_width[i] = 16.59
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 22822.0
                        alt_width[i] = 26.72
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 22891.0
                        alt_width[i] = 26.9
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 22266.2
                    PE_alt[i] = 22266.6
                    alt_width[i] = 10.163
                    width_range[i] = 0.337 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 16333.0
                        alt_width[i] = 30.32
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 16720.0
                        alt_width[i] = 25.31
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 17705.0
                        alt_width[i] = 21.95
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 18293.0
                        alt_width[i] = 13.79
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 18488.3
                        alt_width[i] = 13.72
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 20705.0
                        alt_width[i] = 24.42
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 20891.0
                        alt_width[i] = 25.42
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 21146.0
                        alt_width[i] = 19.64
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 21417.5
                        alt_width[i] = 16.26
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 21550.0
                        alt_width[i] = 16.77
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 21824.4
                        alt_width[i] = 10.63
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 21840.5
                        alt_width[i] = 10.43
                    elif transitionLine[i] == 'L2O1':
                        PE_alt[i] = 21915.0
                        alt_width[i] = 35.78
                    elif transitionLine[i] == 'L2O2':
                        PE_alt[i] = 21992.1
                        alt_width[i] = 20.55
                    elif transitionLine[i] == 'L2O3':
                        PE_alt[i] = 22059.7
                        alt_width[i] = 20.74
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 22150.5
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 18056.8
                    PE_alt[i] = 18056.9
                    alt_width[i] = 8.23
                    width_range[i] = 0.41 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 12124.5
                        alt_width[i] = 28.79
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 12510.0
                        alt_width[i] = 23.79
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 13495.0
                        alt_width[i] = 20.43
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 14084.4
                        alt_width[i] = 12.27
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 14279.0
                        alt_width[i] = 12.2
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 16498.5
                        alt_width[i] = 22.89
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 16675.5
                        alt_width[i] = 23.91
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 16932.5
                        alt_width[i] = 18.13
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 17208.0
                        alt_width[i] = 14.74
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 17255.6
                        alt_width[i] = 15.25
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 17615.0
                        alt_width[i] = 9.11
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 17628.0
                        alt_width[i] = 8.9
                    elif transitionLine[i] == 'L3O1':
                        PE_alt[i] = 17706.5
                        alt_width[i] = 34.26
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 17950.7
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 17950.7
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 5932.9
                    PE_alt[i] = 5932.9
                    alt_width[i] = 21.165
                    width_range[i] = 0.835 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 5541.2
                    PE_alt[i] = 5541.2
                    alt_width[i] = 13.665
                    width_range[i] = 1.665 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 3970.1
                        alt_width[i] = 29.73
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 4556.6
                    PE_alt[i] = 4556.6
                    alt_width[i] = 13.98
                    width_range[i] = 2.02 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 3707.0
                        alt_width[i] = 18.23
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 3760.0
                        alt_width[i] = 18.74
                    elif transitionLine[i] == 'M3O1':
                        PE_alt[i] = 4212.9
                        alt_width[i] = 37.75
                    elif transitionLine[i] == 'M3O5':
                        PE_alt[i] = 4457.0
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 3972.6
                    PE_alt[i] = 3972.6
                    alt_width[i] = 7.98
                    width_range[i] = 3.98 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 2600.5
                        alt_width[i] = 19.24
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 2871.8
                        alt_width[i] = 13.46
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 3530.0
                        alt_width[i] = 4.45
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 3707.7
                        alt_width[i] = 14.37
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 3778.1
                    PE_alt[i] = 3778.1
                    alt_width[i] = 4.015
                    width_range[i] = 0.285 #GUESS
                    if transitionLine[i] == 'M5N6':
                        PE_alt[i] = 3332.3
                        alt_width[i] = 4.37
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 3348.5
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 1558.6
                    PE_alt[i] = 1558.95
                    alt_width[i] = 13.215
                    width_range[i] = 1.215 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 1372.1
                    PE_alt[i] = 1374.75
                    alt_width[i] = 11.72
                    width_range[i] = 3.72 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 1114.8
                    PE_alt[i] = 1117.85
                    alt_width[i] = 8.83
                    width_range[i] = 0.9 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 848.9
                    PE_alt[i] = 848.9
                    alt_width[i] = 5.635
                    width_range[i] = 0.635 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 801.4
                    PE_alt[i] = 801.45
                    alt_width[i] = 5.89
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 445.8
                    PE_alt[i] = 441.6
                    alt_width[i] = 0.52
                    width_range[i] = 0.12 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 432.4
                    PE_alt[i] = 428.8
                    alt_width[i] = 0.42
                    width_range[i] = 0.4 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 351.9
                    PE_alt[i] = 351.9
                    alt_width[i] = 25.79
                    width_range[i] = 6.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 274.1
                    PE_alt[i] = 278.3
                    alt_width[i] = 10.57
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 206.5
                    PE_alt[i] = 210.9
                    alt_width[i] = 10.75
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'O4':
                    PE_lit[i] = 116.0
                    PE_alt[i] = 116.0
                elif photoelectronLine[i] == 'O5':
                    PE_lit[i] = 105.4
                    PE_alt[i] = 105.3
                elif photoelectronLine[i] == 'P1':
                    PE_lit[i] = 48.6
                    PE_alt[i] = 48.6
                elif photoelectronLine[i] == 'P2':
                    PE_lit[i] = 30.6
                    PE_alt[i] = 30.6
                elif photoelectronLine[i] == 'P3':
                    PE_lit[i] = 18.4
                    PE_alt[i] = 18.4
                else:
                    PE_lit[i] = 121791.0


            elif element[i]== 'Am':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 124980.9
                    PE_alt[i] = 125003.95
                    alt_width[i] = 108.17
                    width_range[i] = 0.83 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 101173.0
                        alt_width[i] = 123.57
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 102044.0
                        alt_width[i] = 123.55
                        width_range[i] = 5.96
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 106480.0
                        alt_width[i] = 115.54
                        width_range[i] = 0.54
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 118849.4
                        alt_width[i] = 127.81
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 119254.0
                        alt_width[i] = 122.81
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 120310.0
                        alt_width[i] = 118.83
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 120850.0
                        alt_width[i] = 111.27
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 121100.0
                        alt_width[i] = 111.19
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 123361.6
                        alt_width[i] = 121.82
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 123548.0
                        alt_width[i] = 122.91
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 123817.0
                        alt_width[i] = 117.16
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 124125.0
                        alt_width[i] = 113.72
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 124175.0
                        alt_width[i] = 114.21
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 23805.1
                    PE_alt[i] = 23789.0
                    alt_width[i] = 14.765
                    width_range[i] = 1.465 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 17660.0
                        alt_width[i] = 36.7
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 18062.9
                        alt_width[i] = 31.69
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 19106.12
                        alt_width[i] = 27.72
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 19695.0
                        alt_width[i] = 20.16
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 19900.0
                        alt_width[i] = 20.08
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 22188.0
                        alt_width[i] = 30.70
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 22365.0
                        alt_width[i] = 31.8
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 22640.0
                        alt_width[i] = 26.05
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 22925.5
                        alt_width[i] = 22.61
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 22960.0
                        alt_width[i] = 23.1
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 23346.5
                        alt_width[i] = 16.94
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 23359.4
                        alt_width[i] = 16.73
                    elif transitionLine[i] == 'L1O4':
                        PE_alt[i] = 23657.1
                    elif transitionLine[i] == 'L1O5':
                        PE_alt[i] = 23669.6
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 22944.0
                    PE_alt[i] = 22946.7
                    alt_width[i] = 10.57
                    width_range[i] = 0.33 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 16821.0
                        alt_width[i] = 30.71
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 17206.5
                        alt_width[i] = 25.71
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 18250.0
                        alt_width[i] = 21.73
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 18852.0
                        alt_width[i] = 14.17
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 18852.1
                        alt_width[i] = 14.09
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 21331.5
                        alt_width[i] = 24.72
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 21510.5
                        alt_width[i] = 25.81
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 21786.0
                        alt_width[i] = 20.06
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 22065.3
                        alt_width[i] = 16.62
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 22117.9
                        alt_width[i] = 17.11
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 22488.0
                        alt_width[i] = 10.96
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 22500.9
                        alt_width[i] = 10.74
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 22828.2
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 18504.1
                    PE_alt[i] = 18505.15
                    alt_width[i] = 8.385
                    width_range[i] = 0.345 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 12374.8
                        alt_width[i] = 29.19
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 12766.0
                        alt_width[i] = 24.19
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 1309.2
                        alt_width[i] = 20.21
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 14412.1
                        alt_width[i] = 12.65
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 14617.3
                        alt_width[i] = 12.57
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 16887.3
                        alt_width[i] = 23.2
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 17070.0
                        alt_width[i] = 24.29
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 17346.0
                        alt_width[i] = 18.54
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 17625.9
                        alt_width[i] = 15.1
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 17676.66
                        alt_width[i] = 15.59
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 18048.4
                        alt_width[i] = 9.45
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 18061.3
                        alt_width[i] = 9.23
                    elif transitionLine[i] == 'L3O4':
                        PE_alt[i] = 18399.6
                    elif transitionLine[i] == 'L3O5':
                        PE_alt[i] = 18399.7
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 6132.6
                    PE_alt[i] = 6126.55
                    alt_width[i] = 20.47
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 5747.0
                    PE_alt[i] = 5728.6
                    alt_width[i] = 15.47
                    width_range[i] = 3.0 #GUESS
                    if transitionLine[i] == 'M2N1':
                        PE_alt[i] = 4090.6
                        alt_width[i] = 29.94
                    elif transitionLine[i] == 'M2N4':
                        PE_alt[i] = 4847.0
                        alt_width[i] = 21.84
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 4667.0
                    PE_alt[i] = 4686.5
                    alt_width[i] = 11.49
                    width_range[i] = 3.0 #GUESS
                    if transitionLine[i] == 'M3N4':
                        PE_alt[i] = 3788.3
                        alt_width[i] = 17.87
                    elif transitionLine[i] == 'M3N5':
                        PE_alt[i] = 3867.3
                        alt_width[i] = 18.36
                    elif transitionLine[i] == 'M3O1':
                        PE_alt[i] = 4332.1
                        alt_width[i] = 38.45
                    elif transitionLine[i] == 'M3O5':
                        PE_alt[i] = 4586.9
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 4092.1
                    PE_alt[i] = 4092.1
                    alt_width[i] = 3.93
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'M4N2':
                        PE_alt[i] = 2680.3
                        alt_width[i] = 19.5
                    elif transitionLine[i] == 'M4N3':
                        PE_alt[i] = 2956.6
                        alt_width[i] = 13.75
                    elif transitionLine[i] == 'M4N6':
                        PE_alt[i] = 3633.8
                        alt_width[i] = 4.65
                    elif transitionLine[i] == 'M4O2':
                        PE_alt[i] = 3812.6
                        alt_width[i] = 14.86
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 3886.9
                    PE_alt[i] = 3886.9
                    alt_width[i] = 3.85
                    width_range[i] = 0.5 #GUESS
                    if transitionLine[i] == 'M5N3':
                        PE_alt[i] = 2751.2
                        alt_width[i] = 13.67
                    elif transitionLine[i] == 'M5N6':
                        PE_alt[i] = 3437.9
                        alt_width[i] = 4.57
                    elif transitionLine[i] == 'M5N7':
                        PE_alt[i] = 3442.7
                        alt_width[i] = 4.35
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 1617.1
                    PE_alt[i] = 1618.15
                    alt_width[i] = 14.48
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 1435.1
                    PE_alt[i] = 1423.45
                    alt_width[i] = 15.57
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 1135.7
                    PE_alt[i] = 1151.85
                    alt_width[i] = 9.82
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'N4':
                    PE_lit[i] = 878.7
                    PE_alt[i] = 879.55
                    alt_width[i] = 6.38
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'N5':
                    PE_lit[i] = 827.6
                    PE_alt[i] = 828.8
                    alt_width[i] = 6.87
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'N6':
                    PE_lit[i] = 463.3
                    PE_alt[i] = 463.3
                    alt_width[i] = 0.72
                    width_range[i] = 0.05 #GUESS
                elif photoelectronLine[i] == 'N7':
                    PE_lit[i] = 449.0
                    PE_alt[i] = 449.0
                    alt_width[i] = 0.5
                    width_range[i] = 0.05 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 373.0
                    PE_alt[i] = 373.0
                    alt_width[i] = 26.96
                    width_range[i] = 8.0 #GUESS
                elif photoelectronLine[i] == 'O2':
                    PE_lit[i] = 303.0
                    PE_alt[i] = 303.0
                    alt_width[i] = 10.93
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'O3':
                    PE_lit[i] = 216.4
                    PE_alt[i] = 216.4
                    alt_width[i] = 12.09
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'O4':
                    PE_lit[i] = 115.8
                    PE_alt[i] = 116.9
                elif photoelectronLine[i] == 'O5':
                    PE_lit[i] = 103.3
                    PE_alt[i] = 105.6
                elif photoelectronLine[i] == 'P1':
                    PE_lit[i] = 50.4
                    PE_alt[i] = 50.4
                elif photoelectronLine[i] == 'P2':
                    PE_lit[i] = 31.1
                    PE_alt[i] = 31.1
                elif photoelectronLine[i] == 'P3':
                    PE_lit[i] = 18.1
                    PE_alt[i] = 18.1
                else:
                    PE_lit[i] = 124980.9

            elif element[i]== 'Cm':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 128220.0
                    PE_alt[i] = 128220.0
                    alt_width[i] = 111.8
                    width_range[i] = 20.0 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 103707.4
                        alt_width[i] = 128.19
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 104590.0
                        alt_width[i] = 122.33
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 109273.0
                        alt_width[i] = 120.74
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 121897.0
                        alt_width[i] = 132.27
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 122303.0
                        alt_width[i] = 127.28
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 123404.0
                        alt_width[i] = 123.3
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 124001.0
                        alt_width[i] = 115.75
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 124215.0
                        alt_width[i] = 115.67
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 126550.9
                        alt_width[i] = 126.28
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 126727.2
                        alt_width[i] = 127.37
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 1227030.0
                        alt_width[i] = 121.62
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 127314.2
                        alt_width[i] = 118.18
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 127367.9
                        alt_width[i] = 118.67
                    elif transitionLine[i] == 'KO1':
                        PE_alt[i] = 112804.0
                    elif transitionLine[i] == 'KP1':
                        PE_alt[i] = 112804.0
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 24460.0
                    PE_alt[i] = 24460.0
                    alt_width[i] = 16.39
                    width_range[i] = 5.0 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 18189.6
                        alt_width[i] = 36.87
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 18568.0
                        alt_width[i] = 31.87
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 19680.0
                        alt_width[i] = 27.89
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 20287.0
                        alt_width[i] = 20.34
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 20505.0
                        alt_width[i] = 20.25
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 22843.5
                        alt_width[i] = 30.87
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 23023.0
                        alt_width[i] = 31.96
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 23318.5
                        alt_width[i] = 26.21
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 23606.8
                        alt_width[i] = 22.76
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 23606.8
                        alt_width[i] = 23.26
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 24038.4
                        alt_width[i] = 17.11
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 24052.4
                        alt_width[i] = 16.89
                    elif transitionLine[i] == 'L1O2':
                        PE_alt[i] = 24219.0
                        alt_width[i] = 27.32
                    elif transitionLine[i] == 'L1O3':
                        PE_alt[i] = 24286.0
                        alt_width[i] = 28.48
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 23779.0
                    PE_alt[i] = 23779.0
                    alt_width[i] = 10.52
                    width_range[i] = 2.0 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 17331.0
                        alt_width[i] = 31.0
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 17711.3
                        alt_width[i] = 26.0
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 18812.5
                        alt_width[i] = 22.02
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 19426.0
                        alt_width[i] = 14.47
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 19641.2
                        alt_width[i] = 14.38
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 21975.0
                        alt_width[i] = 25.0
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 22154.3
                        alt_width[i] = 26.09
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 22444.6
                        alt_width[i] = 20.34
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 22730.0
                        alt_width[i] = 16.9
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 22786.1
                        alt_width[i] = 17.39
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 23163.9
                        alt_width[i] = 11.24
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 23177.9
                        alt_width[i] = 11.02
                    elif transitionLine[i] == 'L2O4':
                        PE_alt[i] = 23519.0
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 18930.0
                    PE_alt[i] = 18930.0
                    alt_width[i] = 8.94
                    width_range[i] = 1.5 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 12650.0
                        alt_width[i] = 29.42
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 13030.0
                        alt_width[i] = 24.41
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 14131.2
                        alt_width[i] = 20.44
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 14745.0
                        alt_width[i] = 12.88
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 14959.0
                        alt_width[i] = 12.8
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 17293.0
                        alt_width[i] = 23.41
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 17473.0
                        alt_width[i] = 24.51
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 17763.3
                        alt_width[i] = 18.76
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 18050.0
                        alt_width[i] = 15.31
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 18110.0
                        alt_width[i] = 15.81
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 18482.6
                        alt_width[i] = 9.66
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 18496.6
                        alt_width[i] = 9.42
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 6288.0
                    PE_alt[i] = 6288.0
                    alt_width[i] = 20.48
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 5895.0
                    PE_alt[i] = 5895.0
                    alt_width[i] = 15.48
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 4797.0
                    PE_alt[i] = 4797.0
                    alt_width[i] = 11.5
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 4227.0
                    PE_alt[i] = 4227.0
                    alt_width[i] = 3.94
                    width_range[i] = 0.5 #GUESS
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 3971.0
                    PE_alt[i] = 3971.0
                    alt_width[i] = 3.86
                    width_range[i] = 0.5 #GUESS
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 1643.0
                    PE_alt[i] = 1643.0
                    alt_width[i] = 14.48
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 1440.0
                    PE_alt[i] = 1440.0
                    alt_width[i] = 15.56
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 1154.0
                    PE_alt[i] = 1154.0
                    alt_width[i] = 9.82
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 385.0
                    PE_alt[i] = 385.0
                    alt_width[i] = 26.96
                    width_range[i] = 8.0 #GUESS
                else:
                    PE_lit[i] = 128220.0


            elif element[i]== 'Bk':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 131590.0
                    PE_alt[i] = 131590.0
                    alt_width[i] = 117.06
                    width_range[i] = 20.0 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 106305.0
                        alt_width[i] = 133.21
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 107190.0
                        alt_width[i] = 127.72
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 112120.0
                        alt_width[i] = 126.03
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 125005.5
                        alt_width[i] = 137.12
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 125420.0
                        alt_width[i] = 132.55
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 126580.0
                        alt_width[i] = 128.7
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 127220.0
                        alt_width[i] = 121.01
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 127453.0
                        alt_width[i] = 120.89
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 129810.4
                        alt_width[i] = 131.69
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 130032.0
                        alt_width[i] = 132.94
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 130325.0
                        alt_width[i] = 127.11
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 130601.5
                        alt_width[i] = 123.07
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 130658.4
                        alt_width[i] = 123.07
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 25275.0
                    PE_alt[i] = 25275.0
                    alt_width[i] = 16.51
                    width_range[i] = 3.0 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 18717.0
                        alt_width[i] = 36.93
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 19128.0
                        alt_width[i] = 32.36
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 20298.0
                        alt_width[i] = 28.51
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 20905.5
                        alt_width[i] = 20.82
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 21132.1
                        alt_width[i] = 20.70
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 23521.0
                        alt_width[i] = 31.5
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 23709.6
                        alt_width[i] = 32.75
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 24017.7
                        alt_width[i] = 26.92
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 24311.6
                        alt_width[i] = 23.23
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 24368.0
                        alt_width[i] = 22.88
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 24753.9
                        alt_width[i] = 17.56
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 24768.5
                        alt_width[i] = 17.22
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 24385.0
                    PE_alt[i] = 24385.0
                    alt_width[i] = 11.02
                    width_range[i] = 2.0 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 17827.0
                        alt_width[i] = 31.45
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 18128.0
                        alt_width[i] = 26.87
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 19400.0
                        alt_width[i] = 23.03
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 20015.2
                        alt_width[i] = 15.33
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 20241.9
                        alt_width[i] = 15.22
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 22630.0
                        alt_width[i] = 26.02
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 22819.3
                        alt_width[i] = 27.27
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 23127.4
                        alt_width[i] = 21.44
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 23421.3
                        alt_width[i] = 17.74
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 23477.7
                        alt_width[i] = 17.39
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 23863.7
                        alt_width[i] = 12.08
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 23878.2
                        alt_width[i] = 11.74
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 19452.0
                    PE_alt[i] = 19452.0
                    alt_width[i] = 9.33
                    width_range[i] = 1.5 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 12896.0
                        alt_width[i] = 29.75
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 13305.0
                        alt_width[i] = 25.18
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 14475.0
                        alt_width[i] = 21.34
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 15080.3
                        alt_width[i] = 13.64
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 15306.9
                        alt_width[i] = 13.52
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 17697.0
                        alt_width[i] = 24.32
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 17884.4
                        alt_width[i] = 25.57
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 18192.5
                        alt_width[i] = 19.74
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 18486.4
                        alt_width[i] = 16.04
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 18542.8
                        alt_width[i] = 15.7
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 18928.7
                        alt_width[i] = 10.38
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 18943.3
                        alt_width[i] = 10.04
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 6556.0
                    PE_alt[i] = 6556.0
                    alt_width[i] = 20.42
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 6147.0
                    PE_alt[i] = 6147.0
                    alt_width[i] = 15.85
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 4977.0
                    PE_alt[i] = 4977.0
                    alt_width[i] = 12.01
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 4366.0
                    PE_alt[i] = 4366.0
                    alt_width[i] = 4.31
                    width_range[i] = 0.5 #GUESS
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 4132.0
                    PE_alt[i] = 4132.0
                    alt_width[i] = 4.31
                    width_range[i] = 0.5 #GUESS
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 1755.0
                    PE_alt[i] = 1755.0
                    alt_width[i] = 15.22
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 1554.0
                    PE_alt[i] = 1554.0
                    alt_width[i] = 16.24
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 1235.0
                    PE_alt[i] = 1235.0
                    alt_width[i] = 10.41
                    width_range[i] = 1.0 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 398.0
                    PE_alt[i] = 398.0
                    alt_width[i] = 30.28
                    width_range[i] = 5.0 #GUESS
                else:
                    PE_lit[i] = 131590.0

            elif element[i]== 'Cf':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 135960.0
                    PE_alt[i] = 135960.0
                    alt_width[i] = 121.39
                    width_range[i] = 20.0 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 108947.0
                        alt_width[i] = 138.08
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 109837.3
                        alt_width[i] = 132.71
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 115030.0
                        alt_width[i] = 130.94
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 128184.1
                        alt_width[i] = 141.82
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 128599.0
                        alt_width[i] = 137.25
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 129816.0
                        alt_width[i] = 133.41
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 130475.0
                        alt_width[i] = 125.72
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 130720.0
                        alt_width[i] = 125.6
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 133140.1
                        alt_width[i] = 136.38
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 133375.0
                        alt_width[i] = 137.63
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 133694.0
                        alt_width[i] = 131.8
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 133961.0
                        alt_width[i] = 128.1
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 134020.4
                        alt_width[i] = 127.76
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 26110.0
                    PE_alt[i] = 26110.0
                    alt_width[i] = 16.69
                    width_range[i] = 3.0 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 19259.0
                        alt_width[i] = 37.12
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 19678.0
                        alt_width[i] = 32.55
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 20902.0
                        alt_width[i] = 28.7
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 21556.0
                        alt_width[i] = 21.02
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 21776.0
                        alt_width[i] = 20.89
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 24201.9
                        alt_width[i] = 31.68
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 24411.0
                        alt_width[i] = 32.93
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 24745.0
                        alt_width[i] = 27.1
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 25038.3
                        alt_width[i] = 23.41
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 25097.6
                        alt_width[i] = 23.06
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 25491.5
                        alt_width[i] = 17.74
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 25507.0
                        alt_width[i] = 17.35
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 25250.0
                    PE_alt[i] = 25250.0
                    alt_width[i] = 11.32
                    width_range[i] = 2.0 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 18366.0
                        alt_width[i] = 31.75
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 18772.0
                        alt_width[i] = 27.18
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 20001.0
                        alt_width[i] = 23.33
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 20656.0
                        alt_width[i] = 15.65
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 20876.0
                        alt_width[i] = 15.52
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 23345.0
                        alt_width[i] = 26.31
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 23485.0
                        alt_width[i] = 27.56
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 23822.0
                        alt_width[i] = 21.73
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 24132.0
                        alt_width[i] = 18.03
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 24191.4
                        alt_width[i] = 17.68
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 24585.2
                        alt_width[i] = 12.36
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 24600.7
                        alt_width[i] = 12.02
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 19930.0
                    PE_alt[i] = 19930.0
                    alt_width[i] = 9.55
                    width_range[i] = 1.5 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 13145.0
                        alt_width[i] = 29.99
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 13568.0
                        alt_width[i] = 25.42
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 14797.0
                        alt_width[i] = 21.57
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 15434.0
                        alt_width[i] = 13.89
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 15654.0
                        alt_width[i] = 13.77
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 18128.0
                        alt_width[i] = 24.55
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 18278.0
                        alt_width[i] = 25.8
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 18610.0
                        alt_width[i] = 19.97
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 18931.0
                        alt_width[i] = 16.27
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 18990.4
                        alt_width[i] = 15.92
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 19384.2
                        alt_width[i] = 10.6
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 19399.7
                        alt_width[i] = 10.26
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 6754.0
                    PE_alt[i] = 6754.0
                    alt_width[i] = 20.43
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 6359.0
                    PE_alt[i] = 6359.0
                    alt_width[i] = 15.86
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 5109.0
                    PE_alt[i] = 5109.0
                    alt_width[i] = 12.02
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 4497.0
                    PE_alt[i] = 4497.0
                    alt_width[i] = 4.33
                    width_range[i] = 0.5 #GUESS
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 4253.0
                    PE_alt[i] = 4253.0
                    alt_width[i] = 4.21
                    width_range[i] = 0.5 #GUESS
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 1799.0
                    PE_alt[i] = 1799.0
                    alt_width[i] = 15.0
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 1616.0
                    PE_alt[i] = 1616.0
                    alt_width[i] = 16.24
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 1279.0
                    PE_alt[i] = 1279.0
                    alt_width[i] = 10.41
                    width_range[i] = 8.0 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 419.0
                    PE_alt[i] = 419.0
                    alt_width[i] = 30.28
                    width_range[i] = 5.0 #GUESS
                else:
                    PE_lit[i] = 135960.0

            elif element[i]== 'Es':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 139490.0
                    PE_alt[i] = 139490.0
                    alt_width[i] = 126.36
                    width_range[i] = 20.0 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 111607.8
                        alt_width[i] = 143.21
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 112581.0
                        alt_width[i] = 137.97
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 118057.0
                        alt_width[i] = 136.21
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 131422.2
                        alt_width[i] = 146.89
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 131874.0
                        alt_width[i] = 142.44
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 133193.0
                        alt_width[i] = 138.52
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 133815.0
                        alt_width[i] = 130.84
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 134071.0
                        alt_width[i] = 130.69
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 136523.0
                        alt_width[i] = 141.66
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 136766.0
                        alt_width[i] = 142.79
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 137124.0
                        alt_width[i] = 136.97
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 137374.4
                        alt_width[i] = 133.19
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 137436.8
                        alt_width[i] = 132.86
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 26900.0
                    PE_alt[i] = 26900.0
                    alt_width[i] = 16.85
                    width_range[i] = 3.0 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 19814.4
                        alt_width[i] = 37.38
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 20233.8
                        alt_width[i] = 32.93
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 21532.3
                        alt_width[i] = 29.01
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 22175.9
                        alt_width[i] = 21.33
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 22424.7
                        alt_width[i] = 21.18
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 24915.2
                        alt_width[i] = 32.15
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 25113.6
                        alt_width[i] = 33.28
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 25460.5
                        alt_width[i] = 27.46
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 25766.6
                        alt_width[i] = 23.69
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 25829.0
                        alt_width[i] = 23.35
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 26230.8
                        alt_width[i] = 18.01
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 26247.3
                        alt_width[i] = 17.63
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 26020.0
                    PE_alt[i] = 26020.0
                    alt_width[i] = 11.61
                    width_range[i] = 2.0 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 18892.2
                        alt_width[i] = 32.14
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 19311.6
                        alt_width[i] = 27.69
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 20610.1
                        alt_width[i] = 23.78
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 21253.7
                        alt_width[i] = 16.1
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 21502.5
                        alt_width[i] = 15.94
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 23993.0
                        alt_width[i] = 26.91
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 24191.3
                        alt_width[i] = 28.04
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 24538.3
                        alt_width[i] = 22.22
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 24844.3
                        alt_width[i] = 18.45
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 24906.8
                        alt_width[i] = 18.11
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 25308.5
                        alt_width[i] = 12.77
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 25325.1
                        alt_width[i] = 12.39
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 20410.0
                    PE_alt[i] = 20410.0
                    alt_width[i] = 9.85
                    width_range[i] = 1.5 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 13411.7
                        alt_width[i] = 30.38
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 13831.1
                        alt_width[i] = 25.93
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 15129.6
                        alt_width[i] = 22.01
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 15773.2
                        alt_width[i] = 14.33
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 16022.0
                        alt_width[i] = 14.18
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 18512.5
                        alt_width[i] = 25.15
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 18710.8
                        alt_width[i] = 26.28
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 19057.8
                        alt_width[i] = 20.46
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 19363.8
                        alt_width[i] = 16.68
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 19426.3
                        alt_width[i] = 16.35
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 19828.1
                        alt_width[i] = 11.01
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 19844.6
                        alt_width[i] = 10.63
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 6977.0
                    PE_alt[i] = 6977.0
                    alt_width[i] = 20.53
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 6574.0
                    PE_alt[i] = 6574.0
                    alt_width[i] = 16.08
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 5252.0
                    PE_alt[i] = 5252.0
                    alt_width[i] = 12.16
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'M4':
                    PE_lit[i] = 4630.0
                    PE_alt[i] = 4630.0
                    alt_width[i] = 4.48
                    width_range[i] = 0.5 #GUESS
                elif photoelectronLine[i] == 'M5':
                    PE_lit[i] = 4374.0
                    PE_alt[i] = 4374.0
                    alt_width[i] = 4.33
                    width_range[i] = 0.5 #GUESS
                elif photoelectronLine[i] == 'N1':
                    PE_lit[i] = 1868.0
                    PE_alt[i] = 1868.0
                    alt_width[i] = 15.30
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'N2':
                    PE_lit[i] = 1680.0
                    PE_alt[i] = 1680.0
                    alt_width[i] = 16.46
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'N3':
                    PE_lit[i] = 1321.0
                    PE_alt[i] = 1321.0
                    alt_width[i] = 10.61
                    width_range[i] = 2.0 #GUESS
                elif photoelectronLine[i] == 'O1':
                    PE_lit[i] = 435.0
                    PE_alt[i] = 435.0
                    alt_width[i] = 31.25
                    width_range[i] = 5.0 #GUESS
                else:
                    PE_lit[i] = 139490.0

            elif element[i]== 'Fm':
                if photoelectronLine[i] == 'K':
                    PE_lit[i] = 143090.0
                    PE_alt[i] = 143090.0
                    alt_width[i] = 131.44
                    width_range[i] = 20.0 #GUESS
                    if transitionLine[i] == 'KL1':
                        PE_alt[i] = 114390.0
                        alt_width[i] = 148.45
                    elif transitionLine[i] == 'KL2':
                        PE_alt[i] = 115320.0
                        alt_width[i] = 143.35
                    elif transitionLine[i] == 'KL3':
                        PE_alt[i] = 121090.0
                        alt_width[i] = 141.59
                    elif transitionLine[i] == 'KM1':
                        PE_alt[i] = 134723.3
                        alt_width[i] = 152.08
                    elif transitionLine[i] == 'KM2':
                        PE_alt[i] = 135171.0
                        alt_width[i] = 147.64
                    elif transitionLine[i] == 'KM3':
                        PE_alt[i] = 136563.0
                        alt_width[i] = 143.74
                    elif transitionLine[i] == 'KM4':
                        PE_alt[i] = 137195.0
                        alt_width[i] = 136.07
                    elif transitionLine[i] == 'KM5':
                        PE_alt[i] = 137464.0
                        alt_width[i] = 135.89
                    elif transitionLine[i] == 'KN1':
                        PE_alt[i] = 139980.7
                        alt_width[i] = 146.88
                    elif transitionLine[i] == 'KN2':
                        PE_alt[i] = 140216.0
                        alt_width[i] = 148.22
                    elif transitionLine[i] == 'KN3':
                        PE_alt[i] = 140596.0
                        alt_width[i] = 142.29
                    elif transitionLine[i] == 'KN4':
                        PE_alt[i] = 140863.5
                        alt_width[i] = 138.34
                    elif transitionLine[i] == 'KN5':
                        PE_alt[i] = 140929.3
                        alt_width[i] = 138.02
                elif photoelectronLine[i] == 'L1':
                    PE_lit[i] = 27700.0
                    PE_alt[i] = 27700.0
                    alt_width[i] = 17.02
                    width_range[i] = 4.0 #GUESS
                    if transitionLine[i] == 'L1M1':
                        PE_alt[i] = 20373.0
                        alt_width[i] = 37.65
                    elif transitionLine[i] == 'L1M2':
                        PE_alt[i] = 20794.0
                        alt_width[i] = 33.23
                    elif transitionLine[i] == 'L1M3':
                        PE_alt[i] = 22165.0
                        alt_width[i] = 29.32
                    elif transitionLine[i] == 'L1M4':
                        PE_alt[i] = 22827.0
                        alt_width[i] = 21.65
                    elif transitionLine[i] == 'L1M5':
                        PE_alt[i] = 23089.0
                        alt_width[i] = 21.48
                    elif transitionLine[i] == 'L1N1':
                        PE_alt[i] = 25633.0
                        alt_width[i] = 32.46
                    elif transitionLine[i] == 'L1N2':
                        PE_alt[i] = 25830.0
                        alt_width[i] = 33.8
                    elif transitionLine[i] == 'L1N3':
                        PE_alt[i] = 26202.0
                        alt_width[i] = 27.87
                    elif transitionLine[i] == 'L1N4':
                        PE_alt[i] = 26520.5
                        alt_width[i] = 23.93
                    elif transitionLine[i] == 'L1N5':
                        PE_alt[i] = 26584.0
                        alt_width[i] = 23.6
                    elif transitionLine[i] == 'L1N6':
                        PE_alt[i] = 26996.0
                        alt_width[i] = 18.3
                    elif transitionLine[i] == 'L1N7':
                        PE_alt[i] = 27013.6
                        alt_width[i] = 17.77
                elif photoelectronLine[i] == 'L2':
                    PE_lit[i] = 26810.0
                    PE_alt[i] = 26810.0
                    alt_width[i] = 11.92
                    width_range[i] = 2.0 #GUESS
                    if transitionLine[i] == 'L2M1':
                        PE_alt[i] = 19444.0
                        alt_width[i] = 32.38
                    elif transitionLine[i] == 'L2M2':
                        PE_alt[i] = 19865.0
                        alt_width[i] = 28.13
                    elif transitionLine[i] == 'L2M3':
                        PE_alt[i] = 21236.0
                        alt_width[i] = 24.22
                    elif transitionLine[i] == 'L2M4':
                        PE_alt[i] = 21898.0
                        alt_width[i] = 16.55
                    elif transitionLine[i] == 'L2M5':
                        PE_alt[i] = 22160.0
                        alt_width[i] = 16.38
                    elif transitionLine[i] == 'L2N1':
                        PE_alt[i] = 24704.0
                        alt_width[i] = 27.36
                    elif transitionLine[i] == 'L2N2':
                        PE_alt[i] = 24901.0
                        alt_width[i] = 28.71
                    elif transitionLine[i] == 'L2N3':
                        PE_alt[i] = 25273.0
                        alt_width[i] = 22.77
                    elif transitionLine[i] == 'L2N4':
                        PE_alt[i] = 25585.0
                        alt_width[i] = 18.82
                    elif transitionLine[i] == 'L2N5':
                        PE_alt[i] = 25655.0
                        alt_width[i] = 18.51
                    elif transitionLine[i] == 'L2N6':
                        PE_alt[i] = 26058.1
                        alt_width[i] = 13.2
                    elif transitionLine[i] == 'L2N7':
                        PE_alt[i] = 26075.7
                        alt_width[i] = 12.67
                elif photoelectronLine[i] == 'L3':
                    PE_lit[i] = 20900.0
                    PE_alt[i] = 20900.0
                    alt_width[i] = 10.15
                    width_range[i] = 2.0 #GUESS
                    if transitionLine[i] == 'L3M1':
                        PE_alt[i] = 13668.0
                        alt_width[i] = 30.79
                    elif transitionLine[i] == 'L3M2':
                        PE_alt[i] = 14089.0
                        alt_width[i] = 26.36
                    elif transitionLine[i] == 'L3M3':
                        PE_alt[i] = 15460.0
                        alt_width[i] = 22.45
                    elif transitionLine[i] == 'L3M4':
                        PE_alt[i] = 16122.0
                        alt_width[i] = 14.78
                    elif transitionLine[i] == 'L3M5':
                        PE_alt[i] = 16384.0
                        alt_width[i] = 14.61
                    elif transitionLine[i] == 'L3N1':
                        PE_alt[i] = 18928.0
                        alt_width[i] = 25.6
                    elif transitionLine[i] == 'L3N2':
                        PE_alt[i] = 19125.0
                        alt_width[i] = 27.08
                    elif transitionLine[i] == 'L3N3':
                        PE_alt[i] = 19125.0
                        alt_width[i] = 21.0
                    elif transitionLine[i] == 'L3N4':
                        PE_alt[i] = 19809.0
                        alt_width[i] = 17.06
                    elif transitionLine[i] == 'L3N5':
                        PE_alt[i] = 19879.0
                        alt_width[i] = 16.74
                    elif transitionLine[i] == 'L3N6':
                        PE_alt[i] = 20284.4
                        alt_width[i] = 11.44
                    elif transitionLine[i] == 'L3N7':
                        PE_alt[i] = 20302.1
                        alt_width[i] = 10.91
                elif photoelectronLine[i] == 'M1':
                    PE_lit[i] = 7205.0
                    PE_alt[i] = 7205.0
                    alt_width[i] = 20.63
                    width_range[i] = 4.0 #GUESS
                elif photoelectronLine[i] == 'M2':
                    PE_lit[i] = 6793.0
                    PE_alt[i] = 6793.0
                    alt_width[i] = 16.21
                    width_range[i] = 3.0 #GUESS
                elif photoelectronLine[i] == 'M3':
                    PE_lit[i] = 5397.0
                    PE_alt[i] = 5397.0
                    alt_width[i] = 12.30
                    width_range[