<a id="mypy-boto3-workdocs"></a>

# mypy-boto3-workdocs

[![PyPI - mypy-boto3-workdocs](https://img.shields.io/pypi/v/mypy-boto3-workdocs.svg?color=blue)](https://pypi.org/project/mypy-boto3-workdocs)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-workdocs.svg?color=blue)](https://pypi.org/project/mypy-boto3-workdocs)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-workdocs?color=blue)](https://pypistats.org/packages/mypy-boto3-workdocs)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.WorkDocs 1.18.25](https://boto3.amazonaws.com/v1/documentation/api/1.18.25/reference/services/workdocs.html#WorkDocs)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-workdocs docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_workdocs/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-workdocs](#mypy-boto3-workdocs)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `WorkDocs` service.

```bash
python -m pip install boto3-stubs[workdocs]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[workdocs]` in your environment:
  `python -m pip install 'boto3-stubs[workdocs]'`

Both type checking and auto-complete should work for `WorkDocs` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[workdocs]` in your environment:
  `python -m pip install 'boto3-stubs[workdocs]'`

Both type checking and auto-complete should work for `WorkDocs` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[workdocs]` in your environment:
  `python -m pip install 'boto3-stubs[workdocs]'`
- Run `mypy` as usual

Type checking should work for `WorkDocs` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[workdocs]` in your environment:
  `python -m pip install 'boto3-stubs[workdocs]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `WorkDocs` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`WorkDocsClient` provides annotations for `boto3.client("workdocs")`.

```python
import boto3

from mypy_boto3_workdocs import WorkDocsClient

client: WorkDocsClient = boto3.client("workdocs")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: WorkDocsClient = session.client("workdocs")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_workdocs.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_workdocs import WorkDocsClient
from mypy_boto3_workdocs.paginator import (
    DescribeActivitiesPaginator,
    DescribeCommentsPaginator,
    DescribeDocumentVersionsPaginator,
    DescribeFolderContentsPaginator,
    DescribeGroupsPaginator,
    DescribeNotificationSubscriptionsPaginator,
    DescribeResourcePermissionsPaginator,
    DescribeRootFoldersPaginator,
    DescribeUsersPaginator,
)

client: WorkDocsClient = boto3.client("workdocs")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_activities_paginator: DescribeActivitiesPaginator = client.get_paginator("describe_activities")
describe_comments_paginator: DescribeCommentsPaginator = client.get_paginator("describe_comments")
describe_document_versions_paginator: DescribeDocumentVersionsPaginator = client.get_paginator("describe_document_versions")
describe_folder_contents_paginator: DescribeFolderContentsPaginator = client.get_paginator("describe_folder_contents")
describe_groups_paginator: DescribeGroupsPaginator = client.get_paginator("describe_groups")
describe_notification_subscriptions_paginator: DescribeNotificationSubscriptionsPaginator = client.get_paginator("describe_notification_subscriptions")
describe_resource_permissions_paginator: DescribeResourcePermissionsPaginator = client.get_paginator("describe_resource_permissions")
describe_root_folders_paginator: DescribeRootFoldersPaginator = client.get_paginator("describe_root_folders")
describe_users_paginator: DescribeUsersPaginator = client.get_paginator("describe_users")
```

<a id="literals"></a>

### Literals

`mypy_boto3_workdocs.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_workdocs.literals import (
    ActivityTypeType,
    BooleanEnumTypeType,
    CommentStatusTypeType,
    CommentVisibilityTypeType,
    DescribeActivitiesPaginatorName,
    DescribeCommentsPaginatorName,
    DescribeDocumentVersionsPaginatorName,
    DescribeFolderContentsPaginatorName,
    DescribeGroupsPaginatorName,
    DescribeNotificationSubscriptionsPaginatorName,
    DescribeResourcePermissionsPaginatorName,
    DescribeRootFoldersPaginatorName,
    DescribeUsersPaginatorName,
    DocumentSourceTypeType,
    DocumentStatusTypeType,
    DocumentThumbnailTypeType,
    DocumentVersionStatusType,
    FolderContentTypeType,
    LocaleTypeType,
    OrderTypeType,
    PrincipalTypeType,
    ResourceCollectionTypeType,
    ResourceSortTypeType,
    ResourceStateTypeType,
    ResourceTypeType,
    RolePermissionTypeType,
    RoleTypeType,
    ShareStatusTypeType,
    StorageTypeType,
    SubscriptionProtocolTypeType,
    SubscriptionTypeType,
    UserFilterTypeType,
    UserSortTypeType,
    UserStatusTypeType,
    UserTypeType,
)

def check_value(value: ActivityTypeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_workdocs.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_workdocs.type_defs import (
    AbortDocumentVersionUploadRequestRequestTypeDef,
    ActivateUserRequestRequestTypeDef,
    ActivateUserResponseTypeDef,
    ActivityTypeDef,
    AddResourcePermissionsRequestRequestTypeDef,
    AddResourcePermissionsResponseTypeDef,
    CommentMetadataTypeDef,
    CommentTypeDef,
    CreateCommentRequestRequestTypeDef,
    CreateCommentResponseTypeDef,
    CreateCustomMetadataRequestRequestTypeDef,
    CreateFolderRequestRequestTypeDef,
    CreateFolderResponseTypeDef,
    CreateLabelsRequestRequestTypeDef,
    CreateNotificationSubscriptionRequestRequestTypeDef,
    CreateNotificationSubscriptionResponseTypeDef,
    CreateUserRequestRequestTypeDef,
    CreateUserResponseTypeDef,
    DeactivateUserRequestRequestTypeDef,
    DeleteCommentRequestRequestTypeDef,
    DeleteCustomMetadataRequestRequestTypeDef,
    DeleteDocumentRequestRequestTypeDef,
    DeleteFolderContentsRequestRequestTypeDef,
    DeleteFolderRequestRequestTypeDef,
    DeleteLabelsRequestRequestTypeDef,
    DeleteNotificationSubscriptionRequestRequestTypeDef,
    DeleteUserRequestRequestTypeDef,
    DescribeActivitiesRequestRequestTypeDef,
    DescribeActivitiesResponseTypeDef,
    DescribeCommentsRequestRequestTypeDef,
    DescribeCommentsResponseTypeDef,
    DescribeDocumentVersionsRequestRequestTypeDef,
    DescribeDocumentVersionsResponseTypeDef,
    DescribeFolderContentsRequestRequestTypeDef,
    DescribeFolderContentsResponseTypeDef,
    DescribeGroupsRequestRequestTypeDef,
    DescribeGroupsResponseTypeDef,
    DescribeNotificationSubscriptionsRequestRequestTypeDef,
    DescribeNotificationSubscriptionsResponseTypeDef,
    DescribeResourcePermissionsRequestRequestTypeDef,
    DescribeResourcePermissionsResponseTypeDef,
    DescribeRootFoldersRequestRequestTypeDef,
    DescribeRootFoldersResponseTypeDef,
    DescribeUsersRequestRequestTypeDef,
    DescribeUsersResponseTypeDef,
    DocumentMetadataTypeDef,
    DocumentVersionMetadataTypeDef,
    FolderMetadataTypeDef,
    GetCurrentUserRequestRequestTypeDef,
    GetCurrentUserResponseTypeDef,
    GetDocumentPathRequestRequestTypeDef,
    GetDocumentPathResponseTypeDef,
    GetDocumentRequestRequestTypeDef,
    GetDocumentResponseTypeDef,
    GetDocumentVersionRequestRequestTypeDef,
    GetDocumentVersionResponseTypeDef,
    GetFolderPathRequestRequestTypeDef,
    GetFolderPathResponseTypeDef,
    GetFolderRequestRequestTypeDef,
    GetFolderResponseTypeDef,
    GetResourcesRequestRequestTypeDef,
    GetResourcesResponseTypeDef,
    GroupMetadataTypeDef,
    InitiateDocumentVersionUploadRequestRequestTypeDef,
    InitiateDocumentVersionUploadResponseTypeDef,
    NotificationOptionsTypeDef,
    PaginatorConfigTypeDef,
    ParticipantsTypeDef,
    PermissionInfoTypeDef,
    PrincipalTypeDef,
    RemoveAllResourcePermissionsRequestRequestTypeDef,
    RemoveResourcePermissionRequestRequestTypeDef,
    ResourceMetadataTypeDef,
    ResourcePathComponentTypeDef,
    ResourcePathTypeDef,
    ResponseMetadataTypeDef,
    SharePrincipalTypeDef,
    ShareResultTypeDef,
    StorageRuleTypeTypeDef,
    SubscriptionTypeDef,
    UpdateDocumentRequestRequestTypeDef,
    UpdateDocumentVersionRequestRequestTypeDef,
    UpdateFolderRequestRequestTypeDef,
    UpdateUserRequestRequestTypeDef,
    UpdateUserResponseTypeDef,
    UploadMetadataTypeDef,
    UserMetadataTypeDef,
    UserStorageMetadataTypeDef,
    UserTypeDef,
)

def get_structure() -> AbortDocumentVersionUploadRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-workdocs` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-workdocs docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_workdocs/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
