"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .creator import Creator, CreatorTypedDict
from .refundstatus import RefundStatus
from .refundtargettype import RefundTargetType
from datetime import datetime
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class RefundTypedDict(TypedDict):
    id: str
    r"""The unique identifier for the refund."""
    transaction_id: str
    r"""The ID of the transaction associated with this refund."""
    status: RefundStatus
    currency: str
    r"""The ISO 4217 currency code for this refund. Will always match that of the associated transaction."""
    amount: int
    r"""The amount of this refund, in the smallest currency unit (for example, cents or pence)."""
    target_type: RefundTargetType
    reconciliation_id: str
    r"""The base62 encoded refund ID. This represents a shorter version of this refund's `id` which is sent to payment services, anti-fraud services, and other connectors. You can use this ID to reconcile a payment service's refund against our system."""
    transaction_reconciliation_id: str
    r"""The base62 encoded transaction ID. This represents a shorter version of the related transaction's `id` which is sent to payment services, anti-fraud services, and other connectors. You can use this ID to reconcile a payment service's transaction against our system."""
    created_at: datetime
    r"""The date this refund was created at."""
    updated_at: datetime
    r"""The date this refund was last updated at."""
    type: Literal["refund"]
    r"""Always `refund`."""
    payment_service_refund_id: NotRequired[Nullable[str]]
    r"""The payment service's unique ID for the refund."""
    reason: NotRequired[Nullable[str]]
    r"""The reason for this refund. Could be a multiline string."""
    target_id: NotRequired[Nullable[str]]
    r"""The optional ID of the instrument that was refunded. This may be `null` if the instrument was not stored."""
    external_identifier: NotRequired[Nullable[str]]
    r"""An external identifier that can be used to match the refund against your own records."""
    transaction_external_identifier: NotRequired[Nullable[str]]
    r"""An external identifier that can be used to match the transaction against your own records."""
    creator: NotRequired[Nullable[CreatorTypedDict]]
    r"""The user that created this resource"""


class Refund(BaseModel):
    id: str
    r"""The unique identifier for the refund."""

    transaction_id: str
    r"""The ID of the transaction associated with this refund."""

    status: Annotated[RefundStatus, PlainValidator(validate_open_enum(False))]

    currency: str
    r"""The ISO 4217 currency code for this refund. Will always match that of the associated transaction."""

    amount: int
    r"""The amount of this refund, in the smallest currency unit (for example, cents or pence)."""

    target_type: Annotated[RefundTargetType, PlainValidator(validate_open_enum(False))]

    reconciliation_id: str
    r"""The base62 encoded refund ID. This represents a shorter version of this refund's `id` which is sent to payment services, anti-fraud services, and other connectors. You can use this ID to reconcile a payment service's refund against our system."""

    transaction_reconciliation_id: str
    r"""The base62 encoded transaction ID. This represents a shorter version of the related transaction's `id` which is sent to payment services, anti-fraud services, and other connectors. You can use this ID to reconcile a payment service's transaction against our system."""

    created_at: datetime
    r"""The date this refund was created at."""

    updated_at: datetime
    r"""The date this refund was last updated at."""

    TYPE: Annotated[
        Annotated[
            Optional[Literal["refund"]], AfterValidator(validate_const("refund"))
        ],
        pydantic.Field(alias="type"),
    ] = "refund"
    r"""Always `refund`."""

    payment_service_refund_id: OptionalNullable[str] = UNSET
    r"""The payment service's unique ID for the refund."""

    reason: OptionalNullable[str] = UNSET
    r"""The reason for this refund. Could be a multiline string."""

    target_id: OptionalNullable[str] = UNSET
    r"""The optional ID of the instrument that was refunded. This may be `null` if the instrument was not stored."""

    external_identifier: OptionalNullable[str] = UNSET
    r"""An external identifier that can be used to match the refund against your own records."""

    transaction_external_identifier: OptionalNullable[str] = UNSET
    r"""An external identifier that can be used to match the transaction against your own records."""

    creator: OptionalNullable[Creator] = UNSET
    r"""The user that created this resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "type",
            "payment_service_refund_id",
            "reason",
            "target_id",
            "external_identifier",
            "transaction_external_identifier",
            "creator",
        ]
        nullable_fields = [
            "payment_service_refund_id",
            "reason",
            "target_id",
            "external_identifier",
            "transaction_external_identifier",
            "creator",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
