"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .adyencardautorescuescenariosenum import AdyenCardAutoRescueScenariosEnum
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Dict
from typing_extensions import Annotated, NotRequired, TypedDict


class AdyenCardOptionsTypedDict(TypedDict):
    auto_rescue: NotRequired[Nullable[bool]]
    r"""Set to `true` to enable Auto Rescue for a transaction. Use the `maxDaysToRescue` to specify a rescue window."""
    max_days_to_rescue: NotRequired[Nullable[int]]
    r"""The rescue window for a transaction, in days, when `autoRescue` is set to `true`. You can specify a value between 1 and 48. For cards, the default is one calendar month. For SEPA, the default is 42 days."""
    additional_data: NotRequired[Nullable[Dict[str, str]]]
    r"""Passes additional data to the Adyen API when creating a transaction."""
    auto_rescue_scenario: NotRequired[Nullable[AdyenCardAutoRescueScenariosEnum]]
    r"""The rescue scenario to simulate for a transaction, when `autoRescue` is set to `true`."""
    window_origin: NotRequired[Nullable[str]]
    r"""The origin of the window where the payment is initiated, used for 3D Secure authentication."""


class AdyenCardOptions(BaseModel):
    auto_rescue: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="autoRescue")
    ] = UNSET
    r"""Set to `true` to enable Auto Rescue for a transaction. Use the `maxDaysToRescue` to specify a rescue window."""

    max_days_to_rescue: Annotated[
        OptionalNullable[int], pydantic.Field(alias="maxDaysToRescue")
    ] = UNSET
    r"""The rescue window for a transaction, in days, when `autoRescue` is set to `true`. You can specify a value between 1 and 48. For cards, the default is one calendar month. For SEPA, the default is 42 days."""

    additional_data: Annotated[
        OptionalNullable[Dict[str, str]], pydantic.Field(alias="additionalData")
    ] = UNSET
    r"""Passes additional data to the Adyen API when creating a transaction."""

    auto_rescue_scenario: Annotated[
        Annotated[
            OptionalNullable[AdyenCardAutoRescueScenariosEnum],
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="autoRescueScenario"),
    ] = UNSET
    r"""The rescue scenario to simulate for a transaction, when `autoRescue` is set to `true`."""

    window_origin: OptionalNullable[str] = UNSET
    r"""The origin of the window where the payment is initiated, used for 3D Secure authentication."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "autoRescue",
            "maxDaysToRescue",
            "additionalData",
            "autoRescueScenario",
            "window_origin",
        ]
        nullable_fields = [
            "autoRescue",
            "maxDaysToRescue",
            "additionalData",
            "autoRescueScenario",
            "window_origin",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
