"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class AddressTypedDict(TypedDict):
    city: NotRequired[Nullable[str]]
    r"""The city for the address."""
    country: NotRequired[Nullable[str]]
    r"""The country for the address in ISO 3166 format."""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code or zip code for the address."""
    state: NotRequired[Nullable[str]]
    r"""The state, county, or province for the address."""
    state_code: NotRequired[Nullable[str]]
    r"""The code of state, county, or province for the address in ISO 3166-2 format."""
    house_number_or_name: NotRequired[Nullable[str]]
    r"""The house number or name for the address. Not all payment services use this field but some do."""
    line1: NotRequired[Nullable[str]]
    r"""The first line of the address."""
    line2: NotRequired[Nullable[str]]
    r"""The second line of the address."""
    organization: NotRequired[Nullable[str]]
    r"""The optional name of the company or organisation to add to the address."""


class Address(BaseModel):
    city: OptionalNullable[str] = UNSET
    r"""The city for the address."""

    country: OptionalNullable[str] = UNSET
    r"""The country for the address in ISO 3166 format."""

    postal_code: OptionalNullable[str] = UNSET
    r"""The postal code or zip code for the address."""

    state: OptionalNullable[str] = UNSET
    r"""The state, county, or province for the address."""

    state_code: OptionalNullable[str] = UNSET
    r"""The code of state, county, or province for the address in ISO 3166-2 format."""

    house_number_or_name: OptionalNullable[str] = UNSET
    r"""The house number or name for the address. Not all payment services use this field but some do."""

    line1: OptionalNullable[str] = UNSET
    r"""The first line of the address."""

    line2: OptionalNullable[str] = UNSET
    r"""The second line of the address."""

    organization: OptionalNullable[str] = UNSET
    r"""The optional name of the company or organisation to add to the address."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "city",
            "country",
            "postal_code",
            "state",
            "state_code",
            "house_number_or_name",
            "line1",
            "line2",
            "organization",
        ]
        nullable_fields = [
            "city",
            "country",
            "postal_code",
            "state",
            "state_code",
            "house_number_or_name",
            "line1",
            "line2",
            "organization",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
