"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.errors import Gr4vyError
from gr4vy.models import errordetail as models_errordetail
from gr4vy.types import BaseModel
from gr4vy.utils import validate_const
import httpx
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Optional
from typing_extensions import Annotated


class Error500Data(BaseModel):
    TYPE: Annotated[
        Annotated[Optional[Literal["error"]], AfterValidator(validate_const("error"))],
        pydantic.Field(alias="type"),
    ] = "error"
    r"""Always `error`."""

    code: Optional[str] = "server_error"
    r"""Always `server_error`"""

    status: Optional[int] = 500
    r"""Always `500`."""

    message: Optional[str] = "Request could not be processed"
    r"""A human readable message that provides more context to the error."""

    details: Optional[List[models_errordetail.ErrorDetail]] = None
    r"""A list of details that further ellaborate on the error."""


class Error500(Gr4vyError):
    data: Error500Data

    def __init__(
        self,
        data: Error500Data,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        self.data = data
