# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class EntityChange(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        EntityChange - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'entity_id': 'str',
            'entity_name': 'str',
            'entity_type': 'str',
            'old_values': 'list[str]',
            'new_values': 'list[str]'
        }

        self.attribute_map = {
            'entity_id': 'entityId',
            'entity_name': 'entityName',
            'entity_type': 'entityType',
            'old_values': 'oldValues',
            'new_values': 'newValues'
        }

        self._entity_id = None
        self._entity_name = None
        self._entity_type = None
        self._old_values = None
        self._new_values = None

    @property
    def entity_id(self):
        """
        Gets the entity_id of this EntityChange.
        Id of the entity that was changed

        :return: The entity_id of this EntityChange.
        :rtype: str
        """
        return self._entity_id

    @entity_id.setter
    def entity_id(self, entity_id):
        """
        Sets the entity_id of this EntityChange.
        Id of the entity that was changed

        :param entity_id: The entity_id of this EntityChange.
        :type: str
        """
        

        self._entity_id = entity_id

    @property
    def entity_name(self):
        """
        Gets the entity_name of this EntityChange.
        Name of the entity that was changed

        :return: The entity_name of this EntityChange.
        :rtype: str
        """
        return self._entity_name

    @entity_name.setter
    def entity_name(self, entity_name):
        """
        Sets the entity_name of this EntityChange.
        Name of the entity that was changed

        :param entity_name: The entity_name of this EntityChange.
        :type: str
        """
        

        self._entity_name = entity_name

    @property
    def entity_type(self):
        """
        Gets the entity_type of this EntityChange.
        Type of the entity that was changed

        :return: The entity_type of this EntityChange.
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """
        Sets the entity_type of this EntityChange.
        Type of the entity that was changed

        :param entity_type: The entity_type of this EntityChange.
        :type: str
        """
        allowed_values = ["AccessToken", "Action", "ActionDraft", "ActionMap", "ActionTemplate", "ActivityCode", "AdherenceExplanation", "AgentRoutingInfo", "AnalyticsReportingSettings", "Annotation", "Appointment", "Assignment", "AttemptLimits", "AuthOrganization", "AuthUser", "Bulk", "BulkActions", "BusinessUnit", "Calibration", "CallableTimeSet", "CallAnalysisResponseSet", "Campaign", "CampaignRule", "CampaignSchedule", "ChangeRequest", "ClickstreamSettings", "ComposerPage", "ComposerScript", "ComposerPublishedScript", "ComposerTemplate", "Configuration", "ConfigurationVersion", "ContactList", "ContactListFilter", "ContactSchema", "ConversationAttributes", "ConversationAccount", "ConversationDefaultSupportedContent", "ConversationPhoneNumber", "ConversationRecipient", "ConversationThreadingWindow", "Credential", "DashboardSettings", "DefaultPanelSettings", "DependencyTrackingBuild", "Deployment", "DID", "DIDPool", "DigitalRuleSet", "DirectoryGroup", "DNCList", "Document", "DynamicGroup", "DynamicSchema", "Edge", "EdgeGroup", "EdgeLog", "EdgeLogZip", "EdgePcaps", "EdgePreferences", "EdgeTraceLevel", "EmailCampaignSchedule", "EmergencyGroup", "EnterpriseAgreement", "Evaluation", "EvaluationForm", "EventType", "Exports", "Extension", "ExtensionPool", "ExternalMetricsData", "ExternalMetricsDefinition", "ExternalOrganizationSchema", "Feedback", "Flow", "FlowMilestone", "FlowOutcome", "Forecast", "GdprRequest", "Group", "HistoricalData", "InboundDomain", "InboundRoute", "InsightSettings", "Integration", "IntentMiner", "IVR", "KnowledgeBase", "KnowledgeCategory", "KnowledgeDocument", "KnowledgeDocumentVariation", "KnowledgeLabel", "KnowledgeSearchFeedback", "KnowledgeTraining", "Line", "LineBase", "Location", "ManagementUnit", "MaxOrgRoutingUtilizationCapacity", "MediaDiagnosticsTraceFile", "MessagingCampaign", "MessagingCampaignSchedule", "Metric", "Module", "NumberOrder", "NumberPlan", "OAuthClient", "OAuthClientAuthorization", "Organization", "OrganizationAuthorizationTrust", "OrganizationAuthorizationUserTrust", "OrganizationFeature", "OrganizationIntegrationsAccess", "OrganizationLimits", "OrganizationSettings", "OrphanedRecording", "OutboundDomain", "OutboundRoute", "Outcome", "Pcaps", "Phone", "PhoneBase", "PlanningGroup", "Policy", "Predictor", "Product", "Profile", "ProfileMembers", "Program", "Prompt", "PromptResource", "Public", "Queue", "Recording", "RecordingAnnotation", "RecordingKey", "RecordingKeyConfig", "RecordingSettings", "Response", "ResponseAsset", "Role", "RoleSettings", "Row", "RoutingTranscriptionSettings", "RoutingUtilizationTag", "Rule", "RuleSet", "Schedule", "ScheduledExports", "ScheduleGroup", "Schema", "ScreenRecording", "Segment", "SentimentFeedback", "Sequence", "SequenceSchedule", "ServiceGoalTemplate", "SessionType", "ShiftTrade", "Site", "SkillsGroup", "SpeechTextAnalyticsSettings", "Status", "SupportedContent", "SupportFile", "Survey", "SurveyForm", "Tag", "Team", "TimeOffLimit", "TimeOffPlan", "TimeOffRequest", "Topic", "TopicMiner", "TranscriptionSettings", "Trigger", "Trunk", "TrunkBase", "User", "UserLanguage", "UserPresence", "UserSkill", "VoicemailPolicy", "VoicemailUserPolicy", "Webhook", "Workbin", "Workitem", "WorkPlan", "WorkPlanRotation", "Workspace", "Worktype", "WrapupCode", "WrapUpCodeMapping", "Participant"]
        if entity_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for entity_type -> " + entity_type)
            self._entity_type = "outdated_sdk_version"
        else:
            self._entity_type = entity_type

    @property
    def old_values(self):
        """
        Gets the old_values of this EntityChange.
        Previous values for the entity.

        :return: The old_values of this EntityChange.
        :rtype: list[str]
        """
        return self._old_values

    @old_values.setter
    def old_values(self, old_values):
        """
        Sets the old_values of this EntityChange.
        Previous values for the entity.

        :param old_values: The old_values of this EntityChange.
        :type: list[str]
        """
        

        self._old_values = old_values

    @property
    def new_values(self):
        """
        Gets the new_values of this EntityChange.
        New values for the entity.

        :return: The new_values of this EntityChange.
        :rtype: list[str]
        """
        return self._new_values

    @new_values.setter
    def new_values(self, new_values):
        """
        Sets the new_values of this EntityChange.
        New values for the entity.

        :param new_values: The new_values of this EntityChange.
        :type: list[str]
        """
        

        self._new_values = new_values

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

