# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'status': 'str',
            'download_start_time': 'datetime',
            'execute_start_time': 'datetime',
            'execute_stop_time': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'status': 'status',
            'download_start_time': 'downloadStartTime',
            'execute_start_time': 'executeStartTime',
            'execute_stop_time': 'executeStopTime'
        }

        self._id = None
        self._status = None
        self._download_start_time = None
        self._execute_start_time = None
        self._execute_stop_time = None

    @property
    def id(self):
        """
        Gets the id of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.


        :return: The id of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.


        :param id: The id of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.
        :type: str
        """
        

        self._id = id

    @property
    def status(self):
        """
        Gets the status of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.


        :return: The status of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.


        :param status: The status of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.
        :type: str
        """
        allowed_values = ["NONE", "INIT", "IN_PROGRESS", "EXPIRED", "EXCEPTION", "ABORTED", "FAILED", "SUCCEEDED", "DELETE"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def download_start_time(self):
        """
        Gets the download_start_time of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.


        :return: The download_start_time of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.
        :rtype: datetime
        """
        return self._download_start_time

    @download_start_time.setter
    def download_start_time(self, download_start_time):
        """
        Sets the download_start_time of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.


        :param download_start_time: The download_start_time of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.
        :type: datetime
        """
        

        self._download_start_time = download_start_time

    @property
    def execute_start_time(self):
        """
        Gets the execute_start_time of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.


        :return: The execute_start_time of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.
        :rtype: datetime
        """
        return self._execute_start_time

    @execute_start_time.setter
    def execute_start_time(self, execute_start_time):
        """
        Sets the execute_start_time of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.


        :param execute_start_time: The execute_start_time of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.
        :type: datetime
        """
        

        self._execute_start_time = execute_start_time

    @property
    def execute_stop_time(self):
        """
        Gets the execute_stop_time of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.


        :return: The execute_stop_time of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.
        :rtype: datetime
        """
        return self._execute_stop_time

    @execute_stop_time.setter
    def execute_stop_time(self, execute_stop_time):
        """
        Sets the execute_stop_time of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.


        :param execute_stop_time: The execute_stop_time of this EdgeSoftwareUpdateTopicDomainEdgeSoftwareUpdate.
        :type: datetime
        """
        

        self._execute_stop_time = execute_stop_time

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

