# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ConversationAppSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ConversationAppSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'show_agent_typing_indicator': 'bool',
            'show_user_typing_indicator': 'bool',
            'auto_start_type': 'str',
            'auto_start': 'AutoStart',
            'markdown': 'Markdown',
            'conversation_disconnect': 'ConversationDisconnectSettings',
            'humanize': 'Humanize'
        }

        self.attribute_map = {
            'show_agent_typing_indicator': 'showAgentTypingIndicator',
            'show_user_typing_indicator': 'showUserTypingIndicator',
            'auto_start_type': 'autoStartType',
            'auto_start': 'autoStart',
            'markdown': 'markdown',
            'conversation_disconnect': 'conversationDisconnect',
            'humanize': 'humanize'
        }

        self._show_agent_typing_indicator = None
        self._show_user_typing_indicator = None
        self._auto_start_type = None
        self._auto_start = None
        self._markdown = None
        self._conversation_disconnect = None
        self._humanize = None

    @property
    def show_agent_typing_indicator(self):
        """
        Gets the show_agent_typing_indicator of this ConversationAppSettings.
        The toggle to enable or disable typing indicator for messenger

        :return: The show_agent_typing_indicator of this ConversationAppSettings.
        :rtype: bool
        """
        return self._show_agent_typing_indicator

    @show_agent_typing_indicator.setter
    def show_agent_typing_indicator(self, show_agent_typing_indicator):
        """
        Sets the show_agent_typing_indicator of this ConversationAppSettings.
        The toggle to enable or disable typing indicator for messenger

        :param show_agent_typing_indicator: The show_agent_typing_indicator of this ConversationAppSettings.
        :type: bool
        """
        

        self._show_agent_typing_indicator = show_agent_typing_indicator

    @property
    def show_user_typing_indicator(self):
        """
        Gets the show_user_typing_indicator of this ConversationAppSettings.
        The toggle to enable or disable typing indicator for messenger

        :return: The show_user_typing_indicator of this ConversationAppSettings.
        :rtype: bool
        """
        return self._show_user_typing_indicator

    @show_user_typing_indicator.setter
    def show_user_typing_indicator(self, show_user_typing_indicator):
        """
        Sets the show_user_typing_indicator of this ConversationAppSettings.
        The toggle to enable or disable typing indicator for messenger

        :param show_user_typing_indicator: The show_user_typing_indicator of this ConversationAppSettings.
        :type: bool
        """
        

        self._show_user_typing_indicator = show_user_typing_indicator

    @property
    def auto_start_type(self):
        """
        Gets the auto_start_type of this ConversationAppSettings.
        Deprecated. The auto start type for the messenger conversation

        :return: The auto_start_type of this ConversationAppSettings.
        :rtype: str
        """
        return self._auto_start_type

    @auto_start_type.setter
    def auto_start_type(self, auto_start_type):
        """
        Sets the auto_start_type of this ConversationAppSettings.
        Deprecated. The auto start type for the messenger conversation

        :param auto_start_type: The auto_start_type of this ConversationAppSettings.
        :type: str
        """
        allowed_values = ["Standard", "Automatic"]
        if auto_start_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for auto_start_type -> " + auto_start_type)
            self._auto_start_type = "outdated_sdk_version"
        else:
            self._auto_start_type = auto_start_type

    @property
    def auto_start(self):
        """
        Gets the auto_start of this ConversationAppSettings.
        The auto start for the messenger conversation

        :return: The auto_start of this ConversationAppSettings.
        :rtype: AutoStart
        """
        return self._auto_start

    @auto_start.setter
    def auto_start(self, auto_start):
        """
        Sets the auto_start of this ConversationAppSettings.
        The auto start for the messenger conversation

        :param auto_start: The auto_start of this ConversationAppSettings.
        :type: AutoStart
        """
        

        self._auto_start = auto_start

    @property
    def markdown(self):
        """
        Gets the markdown of this ConversationAppSettings.
        The markdown for the messenger app

        :return: The markdown of this ConversationAppSettings.
        :rtype: Markdown
        """
        return self._markdown

    @markdown.setter
    def markdown(self, markdown):
        """
        Sets the markdown of this ConversationAppSettings.
        The markdown for the messenger app

        :param markdown: The markdown of this ConversationAppSettings.
        :type: Markdown
        """
        

        self._markdown = markdown

    @property
    def conversation_disconnect(self):
        """
        Gets the conversation_disconnect of this ConversationAppSettings.
        The conversation disconnect settings for the messenger app

        :return: The conversation_disconnect of this ConversationAppSettings.
        :rtype: ConversationDisconnectSettings
        """
        return self._conversation_disconnect

    @conversation_disconnect.setter
    def conversation_disconnect(self, conversation_disconnect):
        """
        Sets the conversation_disconnect of this ConversationAppSettings.
        The conversation disconnect settings for the messenger app

        :param conversation_disconnect: The conversation_disconnect of this ConversationAppSettings.
        :type: ConversationDisconnectSettings
        """
        

        self._conversation_disconnect = conversation_disconnect

    @property
    def humanize(self):
        """
        Gets the humanize of this ConversationAppSettings.
        The humanize conversations settings for the messenger app

        :return: The humanize of this ConversationAppSettings.
        :rtype: Humanize
        """
        return self._humanize

    @humanize.setter
    def humanize(self, humanize):
        """
        Sets the humanize of this ConversationAppSettings.
        The humanize conversations settings for the messenger app

        :param humanize: The humanize of this ConversationAppSettings.
        :type: Humanize
        """
        

        self._humanize = humanize

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

