# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ContactListFilterRange(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ContactListFilterRange - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'min': 'str',
            'max': 'str',
            'min_inclusive': 'bool',
            'max_inclusive': 'bool',
            'in_set': 'list[str]'
        }

        self.attribute_map = {
            'min': 'min',
            'max': 'max',
            'min_inclusive': 'minInclusive',
            'max_inclusive': 'maxInclusive',
            'in_set': 'inSet'
        }

        self._min = None
        self._max = None
        self._min_inclusive = None
        self._max_inclusive = None
        self._in_set = None

    @property
    def min(self):
        """
        Gets the min of this ContactListFilterRange.
        The minimum value of the range. Required for the operator BETWEEN.

        :return: The min of this ContactListFilterRange.
        :rtype: str
        """
        return self._min

    @min.setter
    def min(self, min):
        """
        Sets the min of this ContactListFilterRange.
        The minimum value of the range. Required for the operator BETWEEN.

        :param min: The min of this ContactListFilterRange.
        :type: str
        """
        

        self._min = min

    @property
    def max(self):
        """
        Gets the max of this ContactListFilterRange.
        The maximum value of the range. Required for the operator BETWEEN.

        :return: The max of this ContactListFilterRange.
        :rtype: str
        """
        return self._max

    @max.setter
    def max(self, max):
        """
        Sets the max of this ContactListFilterRange.
        The maximum value of the range. Required for the operator BETWEEN.

        :param max: The max of this ContactListFilterRange.
        :type: str
        """
        

        self._max = max

    @property
    def min_inclusive(self):
        """
        Gets the min_inclusive of this ContactListFilterRange.
        Whether or not to include the minimum in the range.

        :return: The min_inclusive of this ContactListFilterRange.
        :rtype: bool
        """
        return self._min_inclusive

    @min_inclusive.setter
    def min_inclusive(self, min_inclusive):
        """
        Sets the min_inclusive of this ContactListFilterRange.
        Whether or not to include the minimum in the range.

        :param min_inclusive: The min_inclusive of this ContactListFilterRange.
        :type: bool
        """
        

        self._min_inclusive = min_inclusive

    @property
    def max_inclusive(self):
        """
        Gets the max_inclusive of this ContactListFilterRange.
        Whether or not to include the maximum in the range.

        :return: The max_inclusive of this ContactListFilterRange.
        :rtype: bool
        """
        return self._max_inclusive

    @max_inclusive.setter
    def max_inclusive(self, max_inclusive):
        """
        Sets the max_inclusive of this ContactListFilterRange.
        Whether or not to include the maximum in the range.

        :param max_inclusive: The max_inclusive of this ContactListFilterRange.
        :type: bool
        """
        

        self._max_inclusive = max_inclusive

    @property
    def in_set(self):
        """
        Gets the in_set of this ContactListFilterRange.
        A set of values that the contact data should be in. Required for the IN operator.

        :return: The in_set of this ContactListFilterRange.
        :rtype: list[str]
        """
        return self._in_set

    @in_set.setter
    def in_set(self, in_set):
        """
        Sets the in_set of this ContactListFilterRange.
        A set of values that the contact data should be in. Required for the IN operator.

        :param in_set: The in_set of this ContactListFilterRange.
        :type: list[str]
        """
        

        self._in_set = in_set

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

