# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class AdherenceExplanationResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AdherenceExplanationResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'agent': 'UserReference',
            'management_unit': 'ManagementUnitReference',
            'business_unit': 'BusinessUnitReference',
            'type': 'str',
            'status': 'str',
            'start_date': 'datetime',
            'length_minutes': 'int',
            'notes': 'str',
            'reviewed_by': 'UserReference',
            'reviewed_date': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'agent': 'agent',
            'management_unit': 'managementUnit',
            'business_unit': 'businessUnit',
            'type': 'type',
            'status': 'status',
            'start_date': 'startDate',
            'length_minutes': 'lengthMinutes',
            'notes': 'notes',
            'reviewed_by': 'reviewedBy',
            'reviewed_date': 'reviewedDate',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._agent = None
        self._management_unit = None
        self._business_unit = None
        self._type = None
        self._status = None
        self._start_date = None
        self._length_minutes = None
        self._notes = None
        self._reviewed_by = None
        self._reviewed_date = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this AdherenceExplanationResponse.
        The globally unique identifier for the object.

        :return: The id of this AdherenceExplanationResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AdherenceExplanationResponse.
        The globally unique identifier for the object.

        :param id: The id of this AdherenceExplanationResponse.
        :type: str
        """
        

        self._id = id

    @property
    def agent(self):
        """
        Gets the agent of this AdherenceExplanationResponse.
        The agent to whom this adherence explanation applies

        :return: The agent of this AdherenceExplanationResponse.
        :rtype: UserReference
        """
        return self._agent

    @agent.setter
    def agent(self, agent):
        """
        Sets the agent of this AdherenceExplanationResponse.
        The agent to whom this adherence explanation applies

        :param agent: The agent of this AdherenceExplanationResponse.
        :type: UserReference
        """
        

        self._agent = agent

    @property
    def management_unit(self):
        """
        Gets the management_unit of this AdherenceExplanationResponse.
        The management unit to which the agent belonged at the time the adherence explanation was submitted

        :return: The management_unit of this AdherenceExplanationResponse.
        :rtype: ManagementUnitReference
        """
        return self._management_unit

    @management_unit.setter
    def management_unit(self, management_unit):
        """
        Sets the management_unit of this AdherenceExplanationResponse.
        The management unit to which the agent belonged at the time the adherence explanation was submitted

        :param management_unit: The management_unit of this AdherenceExplanationResponse.
        :type: ManagementUnitReference
        """
        

        self._management_unit = management_unit

    @property
    def business_unit(self):
        """
        Gets the business_unit of this AdherenceExplanationResponse.
        The business unit to which the agent belonged at the time the adherence explanation was submitted

        :return: The business_unit of this AdherenceExplanationResponse.
        :rtype: BusinessUnitReference
        """
        return self._business_unit

    @business_unit.setter
    def business_unit(self, business_unit):
        """
        Sets the business_unit of this AdherenceExplanationResponse.
        The business unit to which the agent belonged at the time the adherence explanation was submitted

        :param business_unit: The business_unit of this AdherenceExplanationResponse.
        :type: BusinessUnitReference
        """
        

        self._business_unit = business_unit

    @property
    def type(self):
        """
        Gets the type of this AdherenceExplanationResponse.
        The type of the adherence explanation

        :return: The type of this AdherenceExplanationResponse.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this AdherenceExplanationResponse.
        The type of the adherence explanation

        :param type: The type of this AdherenceExplanationResponse.
        :type: str
        """
        allowed_values = ["Late"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def status(self):
        """
        Gets the status of this AdherenceExplanationResponse.
        The status of the adherence explanation

        :return: The status of this AdherenceExplanationResponse.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this AdherenceExplanationResponse.
        The status of the adherence explanation

        :param status: The status of this AdherenceExplanationResponse.
        :type: str
        """
        allowed_values = ["Pending", "Approved", "Denied"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def start_date(self):
        """
        Gets the start_date of this AdherenceExplanationResponse.
        The start timestamp of the adherence explanation in ISO-8601 format

        :return: The start_date of this AdherenceExplanationResponse.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """
        Sets the start_date of this AdherenceExplanationResponse.
        The start timestamp of the adherence explanation in ISO-8601 format

        :param start_date: The start_date of this AdherenceExplanationResponse.
        :type: datetime
        """
        

        self._start_date = start_date

    @property
    def length_minutes(self):
        """
        Gets the length_minutes of this AdherenceExplanationResponse.
        The length of the adherence explanation in minutes

        :return: The length_minutes of this AdherenceExplanationResponse.
        :rtype: int
        """
        return self._length_minutes

    @length_minutes.setter
    def length_minutes(self, length_minutes):
        """
        Sets the length_minutes of this AdherenceExplanationResponse.
        The length of the adherence explanation in minutes

        :param length_minutes: The length_minutes of this AdherenceExplanationResponse.
        :type: int
        """
        

        self._length_minutes = length_minutes

    @property
    def notes(self):
        """
        Gets the notes of this AdherenceExplanationResponse.
        Notes about the adherence explanation

        :return: The notes of this AdherenceExplanationResponse.
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """
        Sets the notes of this AdherenceExplanationResponse.
        Notes about the adherence explanation

        :param notes: The notes of this AdherenceExplanationResponse.
        :type: str
        """
        

        self._notes = notes

    @property
    def reviewed_by(self):
        """
        Gets the reviewed_by of this AdherenceExplanationResponse.
        The user who reviewed the adherence explanation, if applicable

        :return: The reviewed_by of this AdherenceExplanationResponse.
        :rtype: UserReference
        """
        return self._reviewed_by

    @reviewed_by.setter
    def reviewed_by(self, reviewed_by):
        """
        Sets the reviewed_by of this AdherenceExplanationResponse.
        The user who reviewed the adherence explanation, if applicable

        :param reviewed_by: The reviewed_by of this AdherenceExplanationResponse.
        :type: UserReference
        """
        

        self._reviewed_by = reviewed_by

    @property
    def reviewed_date(self):
        """
        Gets the reviewed_date of this AdherenceExplanationResponse.
        The timestamp for when the adherence explanation was reviewed, if applicable. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The reviewed_date of this AdherenceExplanationResponse.
        :rtype: datetime
        """
        return self._reviewed_date

    @reviewed_date.setter
    def reviewed_date(self, reviewed_date):
        """
        Sets the reviewed_date of this AdherenceExplanationResponse.
        The timestamp for when the adherence explanation was reviewed, if applicable. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param reviewed_date: The reviewed_date of this AdherenceExplanationResponse.
        :type: datetime
        """
        

        self._reviewed_date = reviewed_date

    @property
    def self_uri(self):
        """
        Gets the self_uri of this AdherenceExplanationResponse.
        The URI for this object

        :return: The self_uri of this AdherenceExplanationResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this AdherenceExplanationResponse.
        The URI for this object

        :param self_uri: The self_uri of this AdherenceExplanationResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

