# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class AcceleratorInput(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AcceleratorInput - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'dry_run': 'bool',
            'accelerator_id': 'str',
            'parameters': 'list[AcceleratorParameter]'
        }

        self.attribute_map = {
            'dry_run': 'dryRun',
            'accelerator_id': 'acceleratorId',
            'parameters': 'parameters'
        }

        self._dry_run = None
        self._accelerator_id = None
        self._parameters = None

    @property
    def dry_run(self):
        """
        Gets the dry_run of this AcceleratorInput.
        Set this true to test the job without making any changes. Defaults to false.

        :return: The dry_run of this AcceleratorInput.
        :rtype: bool
        """
        return self._dry_run

    @dry_run.setter
    def dry_run(self, dry_run):
        """
        Sets the dry_run of this AcceleratorInput.
        Set this true to test the job without making any changes. Defaults to false.

        :param dry_run: The dry_run of this AcceleratorInput.
        :type: bool
        """
        

        self._dry_run = dry_run

    @property
    def accelerator_id(self):
        """
        Gets the accelerator_id of this AcceleratorInput.
        Accelerator ID

        :return: The accelerator_id of this AcceleratorInput.
        :rtype: str
        """
        return self._accelerator_id

    @accelerator_id.setter
    def accelerator_id(self, accelerator_id):
        """
        Sets the accelerator_id of this AcceleratorInput.
        Accelerator ID

        :param accelerator_id: The accelerator_id of this AcceleratorInput.
        :type: str
        """
        

        self._accelerator_id = accelerator_id

    @property
    def parameters(self):
        """
        Gets the parameters of this AcceleratorInput.
        Parameters required for this accelerator

        :return: The parameters of this AcceleratorInput.
        :rtype: list[AcceleratorParameter]
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """
        Sets the parameters of this AcceleratorInput.
        Parameters required for this accelerator

        :param parameters: The parameters of this AcceleratorInput.
        :type: list[AcceleratorParameter]
        """
        

        self._parameters = parameters

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

