"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnAgent = exports.toJson_CfnAgentPropsVpcConfiguration = exports.toJson_CfnAgentProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("@aws-cdk/core");
/**
 * Converts an object of type 'CfnAgentProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnAgentProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ClusterID': obj.clusterId,
        'KubeConfig': obj.kubeConfig,
        'RoleArn': obj.roleArn,
        'Namespace': obj.namespace,
        'Name': obj.name,
        'Values': obj.values,
        'ValueYaml': obj.valueYaml,
        'Version': obj.version,
        'ValueOverrideURL': obj.valueOverrideUrl,
        'TimeOut': obj.timeOut,
        'VPCConfiguration': toJson_CfnAgentPropsVpcConfiguration(obj.vpcConfiguration),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnAgentProps = toJson_CfnAgentProps;
/**
 * Converts an object of type 'CfnAgentPropsVpcConfiguration' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnAgentPropsVpcConfiguration(obj) {
    var _b, _c;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'SecurityGroupIds': (_b = obj.securityGroupIds) === null || _b === void 0 ? void 0 : _b.map(y => y),
        'SubnetIds': (_c = obj.subnetIds) === null || _c === void 0 ? void 0 : _c.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnAgentPropsVpcConfiguration = toJson_CfnAgentPropsVpcConfiguration;
/**
 * A CloudFormation `Sysdig::Helm::Agent`.
 *
 * @external
 * @cloudformationResource Sysdig::Helm::Agent
 * @link https://github.com/sysdiglabs/cloudformation-resource-providers.git
 */
class CfnAgent extends cdk.CfnResource {
    /**
     * Create a new `Sysdig::Helm::Agent`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAgent.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnAgentProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asString(this.getAtt('ID'));
    }
}
exports.CfnAgent = CfnAgent;
_a = JSII_RTTI_SYMBOL_1;
CfnAgent[_a] = { fqn: "@cdk-cloudformation/sysdig-helm-agent.CfnAgent", version: "1.8.0-alpha.4" };
/**
 * The CloudFormation resource type name for this resource class.
 *
 * @external
 */
CfnAgent.CFN_RESOURCE_TYPE_NAME = "Sysdig::Helm::Agent";
//# sourceMappingURL=data:application/json;base64,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