import * as cdk from '@aws-cdk/core';
/**
 * Sysdig Agent EKS cluster deployment.
 *
 * @schema CfnAgentProps
 */
export interface CfnAgentProps {
    /**
     * EKS cluster name.
     *
     * @schema CfnAgentProps#ClusterID
     */
    readonly clusterId?: string;
    /**
     * Secrets Manager ARN for kubeconfig file.
     *
     * @schema CfnAgentProps#KubeConfig
     */
    readonly kubeConfig?: string;
    /**
     * IAM to use with EKS cluster authentication, if not resource execution role will be used.
     *
     * @schema CfnAgentProps#RoleArn
     */
    readonly roleArn?: string;
    /**
     * Namespace to use with helm.
     *
     * Created if doesn't exist and default will be used if not provided
     *
     * @schema CfnAgentProps#Namespace
     */
    readonly namespace?: string;
    /**
     * Name for the helm release.
     *
     * @schema CfnAgentProps#Name
     */
    readonly name?: string;
    /**
     * Custom Values can optionally be specified.
     *
     * @schema CfnAgentProps#Values
     */
    readonly values?: any;
    /**
     * String representation of a values.yaml file.
     *
     * @schema CfnAgentProps#ValueYaml
     */
    readonly valueYaml?: string;
    /**
     * Version can be specified, if not latest will be used.
     *
     * @schema CfnAgentProps#Version
     */
    readonly version?: string;
    /**
     * Custom Value Yaml file can optionally be specified.
     *
     * @schema CfnAgentProps#ValueOverrideURL
     */
    readonly valueOverrideUrl?: string;
    /**
     * Timeout for resource provider.
     *
     * Default 60 mins
     *
     * @schema CfnAgentProps#TimeOut
     */
    readonly timeOut?: number;
    /**
     * For network connectivity to Cluster inside VPC.
     *
     * @schema CfnAgentProps#VPCConfiguration
     */
    readonly vpcConfiguration?: CfnAgentPropsVpcConfiguration;
}
/**
 * Converts an object of type 'CfnAgentProps' to JSON representation.
 */
export declare function toJson_CfnAgentProps(obj: CfnAgentProps | undefined): Record<string, any> | undefined;
/**
 * For network connectivity to Cluster inside VPC.
 *
 * @schema CfnAgentPropsVpcConfiguration
 */
export interface CfnAgentPropsVpcConfiguration {
    /**
     * Specify one or more security groups.
     *
     * @schema CfnAgentPropsVpcConfiguration#SecurityGroupIds
     */
    readonly securityGroupIds?: string[];
    /**
     * Specify one or more subnets.
     *
     * @schema CfnAgentPropsVpcConfiguration#SubnetIds
     */
    readonly subnetIds?: string[];
}
/**
 * Converts an object of type 'CfnAgentPropsVpcConfiguration' to JSON representation.
 */
export declare function toJson_CfnAgentPropsVpcConfiguration(obj: CfnAgentPropsVpcConfiguration | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Sysdig::Helm::Agent`.
 *
 * @external
 * @cloudformationResource Sysdig::Helm::Agent
 * @link https://github.com/sysdiglabs/cloudformation-resource-providers.git
 */
export declare class CfnAgent extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "Sysdig::Helm::Agent";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnAgentProps;
    /**
     * Attribute `Sysdig::Helm::Agent.ID`.
     *
     * @external
     * @link https://github.com/sysdiglabs/cloudformation-resource-providers.git
     */
    readonly attrId: string;
    /**
     * Create a new `Sysdig::Helm::Agent`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAgentProps);
}
