"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Apibara StarkNet Support"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import apibara.starknet.proto.types_pb2 as types_pb2
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _BlockStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _BlockStatusEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_BlockStatus.ValueType],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    BLOCK_STATUS_UNSPECIFIED: _BlockStatus.ValueType  # 0
    """Unknown block status."""
    BLOCK_STATUS_PENDING: _BlockStatus.ValueType  # 1
    """Block not accepted yet."""
    BLOCK_STATUS_ACCEPTED_ON_L2: _BlockStatus.ValueType  # 2
    """Block accepted on L2."""
    BLOCK_STATUS_ACCEPTED_ON_L1: _BlockStatus.ValueType  # 3
    """Block finalized on L1."""
    BLOCK_STATUS_REJECTED: _BlockStatus.ValueType  # 4
    """Block was rejected and is not part of the canonical chain anymore."""

class BlockStatus(_BlockStatus, metaclass=_BlockStatusEnumTypeWrapper):
    """Status of a block."""

BLOCK_STATUS_UNSPECIFIED: BlockStatus.ValueType  # 0
"""Unknown block status."""
BLOCK_STATUS_PENDING: BlockStatus.ValueType  # 1
"""Block not accepted yet."""
BLOCK_STATUS_ACCEPTED_ON_L2: BlockStatus.ValueType  # 2
"""Block accepted on L2."""
BLOCK_STATUS_ACCEPTED_ON_L1: BlockStatus.ValueType  # 3
"""Block finalized on L1."""
BLOCK_STATUS_REJECTED: BlockStatus.ValueType  # 4
"""Block was rejected and is not part of the canonical chain anymore."""
global___BlockStatus = BlockStatus

@typing_extensions.final
class Block(google.protobuf.message.Message):
    """A StarkNet block."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATUS_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    TRANSACTIONS_FIELD_NUMBER: builtins.int
    STATE_UPDATE_FIELD_NUMBER: builtins.int
    EVENTS_FIELD_NUMBER: builtins.int
    L2_TO_L1_MESSAGES_FIELD_NUMBER: builtins.int
    status: global___BlockStatus.ValueType
    """Block status."""
    @property
    def header(self) -> global___BlockHeader:
        """Block header."""
    @property
    def transactions(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___TransactionWithReceipt
    ]:
        """Transactions in the block."""
    @property
    def state_update(self) -> global___StateUpdate:
        """State update caused by the block."""
    @property
    def events(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___EventWithTransaction
    ]:
        """Events emitted in the block."""
    @property
    def l2_to_l1_messages(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___L2ToL1MessageWithTransaction
    ]:
        """Messages to L1 sent in the block."""
    def __init__(
        self,
        *,
        status: global___BlockStatus.ValueType = ...,
        header: global___BlockHeader | None = ...,
        transactions: collections.abc.Iterable[global___TransactionWithReceipt]
        | None = ...,
        state_update: global___StateUpdate | None = ...,
        events: collections.abc.Iterable[global___EventWithTransaction] | None = ...,
        l2_to_l1_messages: collections.abc.Iterable[
            global___L2ToL1MessageWithTransaction
        ]
        | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "header", b"header", "state_update", b"state_update"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "events",
            b"events",
            "header",
            b"header",
            "l2_to_l1_messages",
            b"l2_to_l1_messages",
            "state_update",
            b"state_update",
            "status",
            b"status",
            "transactions",
            b"transactions",
        ],
    ) -> None: ...

global___Block = Block

@typing_extensions.final
class BlockHeader(google.protobuf.message.Message):
    """Block header."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BLOCK_HASH_FIELD_NUMBER: builtins.int
    PARENT_BLOCK_HASH_FIELD_NUMBER: builtins.int
    BLOCK_NUMBER_FIELD_NUMBER: builtins.int
    SEQUENCER_ADDRESS_FIELD_NUMBER: builtins.int
    NEW_ROOT_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    @property
    def block_hash(self) -> types_pb2.FieldElement:
        """Hash of the block."""
    @property
    def parent_block_hash(self) -> types_pb2.FieldElement:
        """Hash of the block's parent."""
    block_number: builtins.int
    """Block height."""
    @property
    def sequencer_address(self) -> types_pb2.FieldElement:
        """Sequencer address."""
    @property
    def new_root(self) -> types_pb2.FieldElement:
        """New state root after the block."""
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when block  was produced."""
    def __init__(
        self,
        *,
        block_hash: types_pb2.FieldElement | None = ...,
        parent_block_hash: types_pb2.FieldElement | None = ...,
        block_number: builtins.int = ...,
        sequencer_address: types_pb2.FieldElement | None = ...,
        new_root: types_pb2.FieldElement | None = ...,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "block_hash",
            b"block_hash",
            "new_root",
            b"new_root",
            "parent_block_hash",
            b"parent_block_hash",
            "sequencer_address",
            b"sequencer_address",
            "timestamp",
            b"timestamp",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "block_hash",
            b"block_hash",
            "block_number",
            b"block_number",
            "new_root",
            b"new_root",
            "parent_block_hash",
            b"parent_block_hash",
            "sequencer_address",
            b"sequencer_address",
            "timestamp",
            b"timestamp",
        ],
    ) -> None: ...

global___BlockHeader = BlockHeader

@typing_extensions.final
class TransactionWithReceipt(google.protobuf.message.Message):
    """A transaction with its receipt."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRANSACTION_FIELD_NUMBER: builtins.int
    RECEIPT_FIELD_NUMBER: builtins.int
    @property
    def transaction(self) -> global___Transaction:
        """The transaction"""
    @property
    def receipt(self) -> global___TransactionReceipt:
        """The transaction receipt."""
    def __init__(
        self,
        *,
        transaction: global___Transaction | None = ...,
        receipt: global___TransactionReceipt | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "receipt", b"receipt", "transaction", b"transaction"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "receipt", b"receipt", "transaction", b"transaction"
        ],
    ) -> None: ...

global___TransactionWithReceipt = TransactionWithReceipt

@typing_extensions.final
class Transaction(google.protobuf.message.Message):
    """A transaction."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    META_FIELD_NUMBER: builtins.int
    INVOKE_V0_FIELD_NUMBER: builtins.int
    INVOKE_V1_FIELD_NUMBER: builtins.int
    DEPLOY_FIELD_NUMBER: builtins.int
    DECLARE_FIELD_NUMBER: builtins.int
    L1_HANDLER_FIELD_NUMBER: builtins.int
    DEPLOY_ACCOUNT_FIELD_NUMBER: builtins.int
    @property
    def meta(self) -> global___TransactionMeta:
        """Common transaction metadata."""
    @property
    def invoke_v0(self) -> global___InvokeTransactionV0:
        """Transaction invoking a smart contract, V0."""
    @property
    def invoke_v1(self) -> global___InvokeTransactionV1:
        """Transaction invoking a smart contract, V1."""
    @property
    def deploy(self) -> global___DeployTransaction:
        """Transaction deploying a new smart contract."""
    @property
    def declare(self) -> global___DeclareTransaction:
        """Transaction declaring a smart contract."""
    @property
    def l1_handler(self) -> global___L1HandlerTransaction:
        """Transaction handling a message from L1."""
    @property
    def deploy_account(self) -> global___DeployAccountTransaction:
        """Transaction deploying a new account."""
    def __init__(
        self,
        *,
        meta: global___TransactionMeta | None = ...,
        invoke_v0: global___InvokeTransactionV0 | None = ...,
        invoke_v1: global___InvokeTransactionV1 | None = ...,
        deploy: global___DeployTransaction | None = ...,
        declare: global___DeclareTransaction | None = ...,
        l1_handler: global___L1HandlerTransaction | None = ...,
        deploy_account: global___DeployAccountTransaction | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "declare",
            b"declare",
            "deploy",
            b"deploy",
            "deploy_account",
            b"deploy_account",
            "invoke_v0",
            b"invoke_v0",
            "invoke_v1",
            b"invoke_v1",
            "l1_handler",
            b"l1_handler",
            "meta",
            b"meta",
            "transaction",
            b"transaction",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "declare",
            b"declare",
            "deploy",
            b"deploy",
            "deploy_account",
            b"deploy_account",
            "invoke_v0",
            b"invoke_v0",
            "invoke_v1",
            b"invoke_v1",
            "l1_handler",
            b"l1_handler",
            "meta",
            b"meta",
            "transaction",
            b"transaction",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["transaction", b"transaction"]
    ) -> typing_extensions.Literal[
        "invoke_v0", "invoke_v1", "deploy", "declare", "l1_handler", "deploy_account"
    ] | None: ...

global___Transaction = Transaction

@typing_extensions.final
class TransactionMeta(google.protobuf.message.Message):
    """Common transaction metadata."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HASH_FIELD_NUMBER: builtins.int
    MAX_FEE_FIELD_NUMBER: builtins.int
    SIGNATURE_FIELD_NUMBER: builtins.int
    NONCE_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    @property
    def hash(self) -> types_pb2.FieldElement:
        """Transaction hash."""
    @property
    def max_fee(self) -> types_pb2.FieldElement:
        """Maximum fee to be paid."""
    @property
    def signature(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        types_pb2.FieldElement
    ]:
        """Signature by the user."""
    @property
    def nonce(self) -> types_pb2.FieldElement:
        """Nonce."""
    version: builtins.int
    """Version."""
    def __init__(
        self,
        *,
        hash: types_pb2.FieldElement | None = ...,
        max_fee: types_pb2.FieldElement | None = ...,
        signature: collections.abc.Iterable[types_pb2.FieldElement] | None = ...,
        nonce: types_pb2.FieldElement | None = ...,
        version: builtins.int = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "hash", b"hash", "max_fee", b"max_fee", "nonce", b"nonce"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "hash",
            b"hash",
            "max_fee",
            b"max_fee",
            "nonce",
            b"nonce",
            "signature",
            b"signature",
            "version",
            b"version",
        ],
    ) -> None: ...

global___TransactionMeta = TransactionMeta

@typing_extensions.final
class InvokeTransactionV0(google.protobuf.message.Message):
    """Transaction invoking a smart contract, V0."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTRACT_ADDRESS_FIELD_NUMBER: builtins.int
    ENTRY_POINT_SELECTOR_FIELD_NUMBER: builtins.int
    CALLDATA_FIELD_NUMBER: builtins.int
    @property
    def contract_address(self) -> types_pb2.FieldElement:
        """Target contract address."""
    @property
    def entry_point_selector(self) -> types_pb2.FieldElement:
        """Selector of the function being invoked."""
    @property
    def calldata(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        types_pb2.FieldElement
    ]:
        """Raw calldata."""
    def __init__(
        self,
        *,
        contract_address: types_pb2.FieldElement | None = ...,
        entry_point_selector: types_pb2.FieldElement | None = ...,
        calldata: collections.abc.Iterable[types_pb2.FieldElement] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "contract_address",
            b"contract_address",
            "entry_point_selector",
            b"entry_point_selector",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "calldata",
            b"calldata",
            "contract_address",
            b"contract_address",
            "entry_point_selector",
            b"entry_point_selector",
        ],
    ) -> None: ...

global___InvokeTransactionV0 = InvokeTransactionV0

@typing_extensions.final
class InvokeTransactionV1(google.protobuf.message.Message):
    """Transaction invoking a smart contract, V1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SENDER_ADDRESS_FIELD_NUMBER: builtins.int
    CALLDATA_FIELD_NUMBER: builtins.int
    @property
    def sender_address(self) -> types_pb2.FieldElement:
        """Address sending the transaction."""
    @property
    def calldata(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        types_pb2.FieldElement
    ]:
        """Raw calldata."""
    def __init__(
        self,
        *,
        sender_address: types_pb2.FieldElement | None = ...,
        calldata: collections.abc.Iterable[types_pb2.FieldElement] | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["sender_address", b"sender_address"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "calldata", b"calldata", "sender_address", b"sender_address"
        ],
    ) -> None: ...

global___InvokeTransactionV1 = InvokeTransactionV1

@typing_extensions.final
class DeployTransaction(google.protobuf.message.Message):
    """Transaction deploying a new smart contract."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONSTRUCTOR_CALLDATA_FIELD_NUMBER: builtins.int
    CONTRACT_ADDRESS_SALT_FIELD_NUMBER: builtins.int
    CLASS_HASH_FIELD_NUMBER: builtins.int
    @property
    def constructor_calldata(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        types_pb2.FieldElement
    ]:
        """Raw calldata passed to the constructor."""
    @property
    def contract_address_salt(self) -> types_pb2.FieldElement:
        """Salt used when computing the contract's address."""
    @property
    def class_hash(self) -> types_pb2.FieldElement:
        """Hash of the class being deployed."""
    def __init__(
        self,
        *,
        constructor_calldata: collections.abc.Iterable[types_pb2.FieldElement]
        | None = ...,
        contract_address_salt: types_pb2.FieldElement | None = ...,
        class_hash: types_pb2.FieldElement | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "class_hash",
            b"class_hash",
            "contract_address_salt",
            b"contract_address_salt",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "class_hash",
            b"class_hash",
            "constructor_calldata",
            b"constructor_calldata",
            "contract_address_salt",
            b"contract_address_salt",
        ],
    ) -> None: ...

global___DeployTransaction = DeployTransaction

@typing_extensions.final
class DeclareTransaction(google.protobuf.message.Message):
    """Transaction declaring a smart contract."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLASS_HASH_FIELD_NUMBER: builtins.int
    SENDER_ADDRESS_FIELD_NUMBER: builtins.int
    @property
    def class_hash(self) -> types_pb2.FieldElement:
        """Class hash."""
    @property
    def sender_address(self) -> types_pb2.FieldElement:
        """Address of the account declaring the class."""
    def __init__(
        self,
        *,
        class_hash: types_pb2.FieldElement | None = ...,
        sender_address: types_pb2.FieldElement | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "class_hash", b"class_hash", "sender_address", b"sender_address"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "class_hash", b"class_hash", "sender_address", b"sender_address"
        ],
    ) -> None: ...

global___DeclareTransaction = DeclareTransaction

@typing_extensions.final
class L1HandlerTransaction(google.protobuf.message.Message):
    """Transaction handling a message from L1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTRACT_ADDRESS_FIELD_NUMBER: builtins.int
    ENTRY_POINT_SELECTOR_FIELD_NUMBER: builtins.int
    CALLDATA_FIELD_NUMBER: builtins.int
    @property
    def contract_address(self) -> types_pb2.FieldElement:
        """Target contract address."""
    @property
    def entry_point_selector(self) -> types_pb2.FieldElement:
        """Selector of the function being invoked."""
    @property
    def calldata(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        types_pb2.FieldElement
    ]:
        """Raw calldata."""
    def __init__(
        self,
        *,
        contract_address: types_pb2.FieldElement | None = ...,
        entry_point_selector: types_pb2.FieldElement | None = ...,
        calldata: collections.abc.Iterable[types_pb2.FieldElement] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "contract_address",
            b"contract_address",
            "entry_point_selector",
            b"entry_point_selector",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "calldata",
            b"calldata",
            "contract_address",
            b"contract_address",
            "entry_point_selector",
            b"entry_point_selector",
        ],
    ) -> None: ...

global___L1HandlerTransaction = L1HandlerTransaction

@typing_extensions.final
class DeployAccountTransaction(google.protobuf.message.Message):
    """Transaction deploying a new account."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONSTRUCTOR_CALLDATA_FIELD_NUMBER: builtins.int
    CONTRACT_ADDRESS_SALT_FIELD_NUMBER: builtins.int
    CLASS_HASH_FIELD_NUMBER: builtins.int
    @property
    def constructor_calldata(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        types_pb2.FieldElement
    ]:
        """Raw calldata passed to the constructor."""
    @property
    def contract_address_salt(self) -> types_pb2.FieldElement:
        """Salt used when computing the contract's address."""
    @property
    def class_hash(self) -> types_pb2.FieldElement:
        """Hash of the class being deployed."""
    def __init__(
        self,
        *,
        constructor_calldata: collections.abc.Iterable[types_pb2.FieldElement]
        | None = ...,
        contract_address_salt: types_pb2.FieldElement | None = ...,
        class_hash: types_pb2.FieldElement | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "class_hash",
            b"class_hash",
            "contract_address_salt",
            b"contract_address_salt",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "class_hash",
            b"class_hash",
            "constructor_calldata",
            b"constructor_calldata",
            "contract_address_salt",
            b"contract_address_salt",
        ],
    ) -> None: ...

global___DeployAccountTransaction = DeployAccountTransaction

@typing_extensions.final
class TransactionReceipt(google.protobuf.message.Message):
    """Result of the execution of a transaction.

    This message only contains the receipt data, if you also need the
    transaction, request a `Transaction`.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRANSACTION_HASH_FIELD_NUMBER: builtins.int
    TRANSACTION_INDEX_FIELD_NUMBER: builtins.int
    ACTUAL_FEE_FIELD_NUMBER: builtins.int
    L2_TO_L1_MESSAGES_FIELD_NUMBER: builtins.int
    EVENTS_FIELD_NUMBER: builtins.int
    @property
    def transaction_hash(self) -> types_pb2.FieldElement:
        """Hash of the transaction."""
    transaction_index: builtins.int
    """Transaction's indexe in the list of transactions in a block."""
    @property
    def actual_fee(self) -> types_pb2.FieldElement:
        """Feed paid."""
    @property
    def l2_to_l1_messages(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___L2ToL1Message
    ]:
        """Messages sent to L1 in the transactions."""
    @property
    def events(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___Event
    ]:
        """Events emitted in the transaction."""
    def __init__(
        self,
        *,
        transaction_hash: types_pb2.FieldElement | None = ...,
        transaction_index: builtins.int = ...,
        actual_fee: types_pb2.FieldElement | None = ...,
        l2_to_l1_messages: collections.abc.Iterable[global___L2ToL1Message]
        | None = ...,
        events: collections.abc.Iterable[global___Event] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "actual_fee", b"actual_fee", "transaction_hash", b"transaction_hash"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "actual_fee",
            b"actual_fee",
            "events",
            b"events",
            "l2_to_l1_messages",
            b"l2_to_l1_messages",
            "transaction_hash",
            b"transaction_hash",
            "transaction_index",
            b"transaction_index",
        ],
    ) -> None: ...

global___TransactionReceipt = TransactionReceipt

@typing_extensions.final
class L2ToL1MessageWithTransaction(google.protobuf.message.Message):
    """Message sent from L2 to L1 together with its transaction and receipt."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRANSACTION_FIELD_NUMBER: builtins.int
    RECEIPT_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    @property
    def transaction(self) -> global___Transaction:
        """The transaction that sent this message."""
    @property
    def receipt(self) -> global___TransactionReceipt:
        """The transaction receipt."""
    @property
    def message(self) -> global___L2ToL1Message:
        """The message."""
    def __init__(
        self,
        *,
        transaction: global___Transaction | None = ...,
        receipt: global___TransactionReceipt | None = ...,
        message: global___L2ToL1Message | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "message", b"message", "receipt", b"receipt", "transaction", b"transaction"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "message", b"message", "receipt", b"receipt", "transaction", b"transaction"
        ],
    ) -> None: ...

global___L2ToL1MessageWithTransaction = L2ToL1MessageWithTransaction

@typing_extensions.final
class L2ToL1Message(google.protobuf.message.Message):
    """Message sent from L2 to L1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TO_ADDRESS_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    @property
    def to_address(self) -> types_pb2.FieldElement:
        """Destination address."""
    @property
    def payload(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        types_pb2.FieldElement
    ]:
        """Data contained in the message."""
    def __init__(
        self,
        *,
        to_address: types_pb2.FieldElement | None = ...,
        payload: collections.abc.Iterable[types_pb2.FieldElement] | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["to_address", b"to_address"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "payload", b"payload", "to_address", b"to_address"
        ],
    ) -> None: ...

global___L2ToL1Message = L2ToL1Message

@typing_extensions.final
class EventWithTransaction(google.protobuf.message.Message):
    """Event emitted by a transaction, together with its transaction and receipt."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRANSACTION_FIELD_NUMBER: builtins.int
    RECEIPT_FIELD_NUMBER: builtins.int
    EVENT_FIELD_NUMBER: builtins.int
    @property
    def transaction(self) -> global___Transaction:
        """The transaction emitting the event."""
    @property
    def receipt(self) -> global___TransactionReceipt:
        """The transaction receipt."""
    @property
    def event(self) -> global___Event:
        """The event."""
    def __init__(
        self,
        *,
        transaction: global___Transaction | None = ...,
        receipt: global___TransactionReceipt | None = ...,
        event: global___Event | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "event", b"event", "receipt", b"receipt", "transaction", b"transaction"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "event", b"event", "receipt", b"receipt", "transaction", b"transaction"
        ],
    ) -> None: ...

global___EventWithTransaction = EventWithTransaction

@typing_extensions.final
class Event(google.protobuf.message.Message):
    """Event emitted by a transaction."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FROM_ADDRESS_FIELD_NUMBER: builtins.int
    KEYS_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    @property
    def from_address(self) -> types_pb2.FieldElement:
        """Address of the smart contract emitting the event."""
    @property
    def keys(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        types_pb2.FieldElement
    ]:
        """Event key."""
    @property
    def data(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        types_pb2.FieldElement
    ]:
        """Event data."""
    def __init__(
        self,
        *,
        from_address: types_pb2.FieldElement | None = ...,
        keys: collections.abc.Iterable[types_pb2.FieldElement] | None = ...,
        data: collections.abc.Iterable[types_pb2.FieldElement] | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["from_address", b"from_address"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "data", b"data", "from_address", b"from_address", "keys", b"keys"
        ],
    ) -> None: ...

global___Event = Event

@typing_extensions.final
class StateUpdate(google.protobuf.message.Message):
    """State update."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NEW_ROOT_FIELD_NUMBER: builtins.int
    OLD_ROOT_FIELD_NUMBER: builtins.int
    STATE_DIFF_FIELD_NUMBER: builtins.int
    @property
    def new_root(self) -> types_pb2.FieldElement:
        """New state root."""
    @property
    def old_root(self) -> types_pb2.FieldElement:
        """Previous state root."""
    @property
    def state_diff(self) -> global___StateDiff:
        """State difference."""
    def __init__(
        self,
        *,
        new_root: types_pb2.FieldElement | None = ...,
        old_root: types_pb2.FieldElement | None = ...,
        state_diff: global___StateDiff | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "new_root",
            b"new_root",
            "old_root",
            b"old_root",
            "state_diff",
            b"state_diff",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "new_root",
            b"new_root",
            "old_root",
            b"old_root",
            "state_diff",
            b"state_diff",
        ],
    ) -> None: ...

global___StateUpdate = StateUpdate

@typing_extensions.final
class StateDiff(google.protobuf.message.Message):
    """Difference in state between blocks."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORAGE_DIFFS_FIELD_NUMBER: builtins.int
    DECLARED_CONTRACTS_FIELD_NUMBER: builtins.int
    DEPLOYED_CONTRACTS_FIELD_NUMBER: builtins.int
    NONCES_FIELD_NUMBER: builtins.int
    @property
    def storage_diffs(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___StorageDiff
    ]:
        """Storage differences."""
    @property
    def declared_contracts(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___DeclaredContract
    ]:
        """Contracts declared."""
    @property
    def deployed_contracts(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___DeployedContract
    ]:
        """Contracts deployed."""
    @property
    def nonces(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___NonceUpdate
    ]:
        """Nonces updated."""
    def __init__(
        self,
        *,
        storage_diffs: collections.abc.Iterable[global___StorageDiff] | None = ...,
        declared_contracts: collections.abc.Iterable[global___DeclaredContract]
        | None = ...,
        deployed_contracts: collections.abc.Iterable[global___DeployedContract]
        | None = ...,
        nonces: collections.abc.Iterable[global___NonceUpdate] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "declared_contracts",
            b"declared_contracts",
            "deployed_contracts",
            b"deployed_contracts",
            "nonces",
            b"nonces",
            "storage_diffs",
            b"storage_diffs",
        ],
    ) -> None: ...

global___StateDiff = StateDiff

@typing_extensions.final
class StorageDiff(google.protobuf.message.Message):
    """Difference in storage values for a contract."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTRACT_ADDRESS_FIELD_NUMBER: builtins.int
    STORAGE_ENTRIES_FIELD_NUMBER: builtins.int
    @property
    def contract_address(self) -> types_pb2.FieldElement:
        """The contract address."""
    @property
    def storage_entries(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___StorageEntry
    ]:
        """Entries that changed."""
    def __init__(
        self,
        *,
        contract_address: types_pb2.FieldElement | None = ...,
        storage_entries: collections.abc.Iterable[global___StorageEntry] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal["contract_address", b"contract_address"],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "contract_address",
            b"contract_address",
            "storage_entries",
            b"storage_entries",
        ],
    ) -> None: ...

global___StorageDiff = StorageDiff

@typing_extensions.final
class StorageEntry(google.protobuf.message.Message):
    """Storage entry."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    @property
    def key(self) -> types_pb2.FieldElement:
        """Storage location."""
    @property
    def value(self) -> types_pb2.FieldElement:
        """Storage value."""
    def __init__(
        self,
        *,
        key: types_pb2.FieldElement | None = ...,
        value: types_pb2.FieldElement | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
    ) -> None: ...

global___StorageEntry = StorageEntry

@typing_extensions.final
class DeclaredContract(google.protobuf.message.Message):
    """Contract declared."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLASS_HASH_FIELD_NUMBER: builtins.int
    @property
    def class_hash(self) -> types_pb2.FieldElement:
        """Class hash of the newly declared contract."""
    def __init__(
        self,
        *,
        class_hash: types_pb2.FieldElement | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["class_hash", b"class_hash"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["class_hash", b"class_hash"]
    ) -> None: ...

global___DeclaredContract = DeclaredContract

@typing_extensions.final
class DeployedContract(google.protobuf.message.Message):
    """Contract deployed."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTRACT_ADDRESS_FIELD_NUMBER: builtins.int
    CLASS_HASH_FIELD_NUMBER: builtins.int
    @property
    def contract_address(self) -> types_pb2.FieldElement:
        """Address of the newly deployed contract."""
    @property
    def class_hash(self) -> types_pb2.FieldElement:
        """Class hash of the deployed contract."""
    def __init__(
        self,
        *,
        contract_address: types_pb2.FieldElement | None = ...,
        class_hash: types_pb2.FieldElement | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "class_hash", b"class_hash", "contract_address", b"contract_address"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "class_hash", b"class_hash", "contract_address", b"contract_address"
        ],
    ) -> None: ...

global___DeployedContract = DeployedContract

@typing_extensions.final
class NonceUpdate(google.protobuf.message.Message):
    """Nonce update."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTRACT_ADDRESS_FIELD_NUMBER: builtins.int
    NONCE_FIELD_NUMBER: builtins.int
    @property
    def contract_address(self) -> types_pb2.FieldElement:
        """Contract address."""
    @property
    def nonce(self) -> types_pb2.FieldElement:
        """New nonce value."""
    def __init__(
        self,
        *,
        contract_address: types_pb2.FieldElement | None = ...,
        nonce: types_pb2.FieldElement | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "contract_address", b"contract_address", "nonce", b"nonce"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "contract_address", b"contract_address", "nonce", b"nonce"
        ],
    ) -> None: ...

global___NonceUpdate = NonceUpdate
