"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTimestampFieldName = exports.getUpdatedAtFieldName = exports.getCreatedAtFieldName = void 0;
const graphql_transformer_core_1 = require("graphql-transformer-core");
function getCreatedAtFieldName(directive) {
    return getTimestampFieldName(directive, 'createdAt', 'createdAt');
}
exports.getCreatedAtFieldName = getCreatedAtFieldName;
function getUpdatedAtFieldName(directive) {
    return getTimestampFieldName(directive, 'updatedAt', 'updatedAt');
}
exports.getUpdatedAtFieldName = getUpdatedAtFieldName;
function getTimestampFieldName(directive, fieldName, defaultFiledValue) {
    const directiveArguments = graphql_transformer_core_1.getDirectiveArguments(directive);
    const timestamp = directiveArguments.timestamps;
    if (timestamp === null)
        return null;
    if (timestamp && timestamp[fieldName] !== undefined) {
        return timestamp[fieldName];
    }
    return defaultFiledValue;
}
exports.getTimestampFieldName = getTimestampFieldName;
//# sourceMappingURL=ModelDirectiveArgs.js.map