"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const core_1 = require("@aws-cdk/core");
const datadog_dashboard_1 = require("./dashboards/datadog-dashboard");
const datadog_downtime_1 = require("./monitors/datadog-downtime");
const datadog_monitor_1 = require("./monitors/datadog-monitor");
const properties_1 = require("./monitors/properties");
const datadog_user_1 = require("./users/datadog-user");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'CdkDatadogResourcesTestStack');
const datadogCredentials = {
    apiKey: process.env.DATADOG_API_KEY,
    applicationKey: process.env.DATADOG_APP_KEY,
};
new datadog_monitor_1.DatadogMonitor(stack, 'TestMonitor', {
    datadogCredentials,
    query: 'avg(last_1h):sum:system.cpu.system{host:host0} > 100',
    type: properties_1.MonitorType.QUERY_ALERT,
    name: 'Test Monitor',
    options: {
        thresholds: {
            critical: 100,
            warning: 80,
            oK: 90,
        },
        notifyNoData: true,
        evaluationDelay: 60,
    },
});
new datadog_dashboard_1.DatadogDashboard(stack, 'TestDashboard', {
    datadogCredentials,
    dashboardDefinition: fs.readFileSync(`${__dirname}/../test/dashboards/dashboard-def.json`).toString(),
});
new datadog_downtime_1.DatadogDowntime(stack, 'TestDowntime', {
    datadogCredentials,
    message: 'Setting downtime on this monitor during regular maintenance',
    monitorId: 40427544,
    scope: ['*'],
    start: 1909141686,
    timezone: 'Asia/Tokyo',
});
new datadog_user_1.DatadogIAMUser(stack, 'TestUser', {
    datadogCredentials,
    accessRole: 'st',
    email: 'nomadblacky@gmail.com',
    handle: 'nomadblacky@gmail.com',
    name: 'NomadBlacky',
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2RrLWFwcC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9jZGstYXBwLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEseUJBQXlCO0FBQ3pCLHdDQUEyQztBQUUzQyxzRUFBa0U7QUFDbEUsa0VBQThEO0FBQzlELGdFQUE0RDtBQUM1RCxzREFBb0Q7QUFDcEQsdURBQXNEO0FBRXRELE1BQU0sR0FBRyxHQUFHLElBQUksVUFBRyxFQUFFLENBQUM7QUFDdEIsTUFBTSxLQUFLLEdBQUcsSUFBSSxZQUFLLENBQUMsR0FBRyxFQUFFLDhCQUE4QixDQUFDLENBQUM7QUFFN0QsTUFBTSxrQkFBa0IsR0FBdUI7SUFDN0MsTUFBTSxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsZUFBZ0I7SUFDcEMsY0FBYyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsZUFBZ0I7Q0FDN0MsQ0FBQztBQUVGLElBQUksZ0NBQWMsQ0FBQyxLQUFLLEVBQUUsYUFBYSxFQUFFO0lBQ3ZDLGtCQUFrQjtJQUNsQixLQUFLLEVBQUUsc0RBQXNEO0lBQzdELElBQUksRUFBRSx3QkFBVyxDQUFDLFdBQVc7SUFDN0IsSUFBSSxFQUFFLGNBQWM7SUFDcEIsT0FBTyxFQUFFO1FBQ1AsVUFBVSxFQUFFO1lBQ1YsUUFBUSxFQUFFLEdBQUc7WUFDYixPQUFPLEVBQUUsRUFBRTtZQUNYLEVBQUUsRUFBRSxFQUFFO1NBQ1A7UUFDRCxZQUFZLEVBQUUsSUFBSTtRQUNsQixlQUFlLEVBQUUsRUFBRTtLQUNwQjtDQUNGLENBQUMsQ0FBQztBQUVILElBQUksb0NBQWdCLENBQUMsS0FBSyxFQUFFLGVBQWUsRUFBRTtJQUMzQyxrQkFBa0I7SUFDbEIsbUJBQW1CLEVBQUUsRUFBRSxDQUFDLFlBQVksQ0FBQyxHQUFHLFNBQVMsd0NBQXdDLENBQUMsQ0FBQyxRQUFRLEVBQUU7Q0FDdEcsQ0FBQyxDQUFDO0FBRUgsSUFBSSxrQ0FBZSxDQUFDLEtBQUssRUFBRSxjQUFjLEVBQUU7SUFDekMsa0JBQWtCO0lBQ2xCLE9BQU8sRUFBRSw2REFBNkQ7SUFDdEUsU0FBUyxFQUFFLFFBQVE7SUFDbkIsS0FBSyxFQUFFLENBQUMsR0FBRyxDQUFDO0lBQ1osS0FBSyxFQUFFLFVBQVU7SUFDakIsUUFBUSxFQUFFLFlBQVk7Q0FDdkIsQ0FBQyxDQUFDO0FBRUgsSUFBSSw2QkFBYyxDQUFDLEtBQUssRUFBRSxVQUFVLEVBQUU7SUFDcEMsa0JBQWtCO0lBQ2xCLFVBQVUsRUFBRSxJQUFJO0lBQ2hCLEtBQUssRUFBRSx1QkFBdUI7SUFDOUIsTUFBTSxFQUFFLHVCQUF1QjtJQUMvQixJQUFJLEVBQUUsYUFBYTtDQUNwQixDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBmcyBmcm9tICdmcyc7XG5pbXBvcnQgeyBBcHAsIFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBEYXRhZG9nQ3JlZGVudGlhbHMgfSBmcm9tICcuL2NvbW1vbi9wcm9wZXJ0aWVzJztcbmltcG9ydCB7IERhdGFkb2dEYXNoYm9hcmQgfSBmcm9tICcuL2Rhc2hib2FyZHMvZGF0YWRvZy1kYXNoYm9hcmQnO1xuaW1wb3J0IHsgRGF0YWRvZ0Rvd250aW1lIH0gZnJvbSAnLi9tb25pdG9ycy9kYXRhZG9nLWRvd250aW1lJztcbmltcG9ydCB7IERhdGFkb2dNb25pdG9yIH0gZnJvbSAnLi9tb25pdG9ycy9kYXRhZG9nLW1vbml0b3InO1xuaW1wb3J0IHsgTW9uaXRvclR5cGUgfSBmcm9tICcuL21vbml0b3JzL3Byb3BlcnRpZXMnO1xuaW1wb3J0IHsgRGF0YWRvZ0lBTVVzZXIgfSBmcm9tICcuL3VzZXJzL2RhdGFkb2ctdXNlcic7XG5cbmNvbnN0IGFwcCA9IG5ldyBBcHAoKTtcbmNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKGFwcCwgJ0Nka0RhdGFkb2dSZXNvdXJjZXNUZXN0U3RhY2snKTtcblxuY29uc3QgZGF0YWRvZ0NyZWRlbnRpYWxzOiBEYXRhZG9nQ3JlZGVudGlhbHMgPSB7XG4gIGFwaUtleTogcHJvY2Vzcy5lbnYuREFUQURPR19BUElfS0VZISxcbiAgYXBwbGljYXRpb25LZXk6IHByb2Nlc3MuZW52LkRBVEFET0dfQVBQX0tFWSEsXG59O1xuXG5uZXcgRGF0YWRvZ01vbml0b3Ioc3RhY2ssICdUZXN0TW9uaXRvcicsIHtcbiAgZGF0YWRvZ0NyZWRlbnRpYWxzLFxuICBxdWVyeTogJ2F2ZyhsYXN0XzFoKTpzdW06c3lzdGVtLmNwdS5zeXN0ZW17aG9zdDpob3N0MH0gPiAxMDAnLFxuICB0eXBlOiBNb25pdG9yVHlwZS5RVUVSWV9BTEVSVCxcbiAgbmFtZTogJ1Rlc3QgTW9uaXRvcicsXG4gIG9wdGlvbnM6IHtcbiAgICB0aHJlc2hvbGRzOiB7XG4gICAgICBjcml0aWNhbDogMTAwLFxuICAgICAgd2FybmluZzogODAsXG4gICAgICBvSzogOTAsXG4gICAgfSxcbiAgICBub3RpZnlOb0RhdGE6IHRydWUsXG4gICAgZXZhbHVhdGlvbkRlbGF5OiA2MCxcbiAgfSxcbn0pO1xuXG5uZXcgRGF0YWRvZ0Rhc2hib2FyZChzdGFjaywgJ1Rlc3REYXNoYm9hcmQnLCB7XG4gIGRhdGFkb2dDcmVkZW50aWFscyxcbiAgZGFzaGJvYXJkRGVmaW5pdGlvbjogZnMucmVhZEZpbGVTeW5jKGAke19fZGlybmFtZX0vLi4vdGVzdC9kYXNoYm9hcmRzL2Rhc2hib2FyZC1kZWYuanNvbmApLnRvU3RyaW5nKCksXG59KTtcblxubmV3IERhdGFkb2dEb3dudGltZShzdGFjaywgJ1Rlc3REb3dudGltZScsIHtcbiAgZGF0YWRvZ0NyZWRlbnRpYWxzLFxuICBtZXNzYWdlOiAnU2V0dGluZyBkb3dudGltZSBvbiB0aGlzIG1vbml0b3IgZHVyaW5nIHJlZ3VsYXIgbWFpbnRlbmFuY2UnLFxuICBtb25pdG9ySWQ6IDQwNDI3NTQ0LFxuICBzY29wZTogWycqJ10sXG4gIHN0YXJ0OiAxOTA5MTQxNjg2LFxuICB0aW1lem9uZTogJ0FzaWEvVG9reW8nLFxufSk7XG5cbm5ldyBEYXRhZG9nSUFNVXNlcihzdGFjaywgJ1Rlc3RVc2VyJywge1xuICBkYXRhZG9nQ3JlZGVudGlhbHMsXG4gIGFjY2Vzc1JvbGU6ICdzdCcsXG4gIGVtYWlsOiAnbm9tYWRibGFja3lAZ21haWwuY29tJyxcbiAgaGFuZGxlOiAnbm9tYWRibGFja3lAZ21haWwuY29tJyxcbiAgbmFtZTogJ05vbWFkQmxhY2t5Jyxcbn0pO1xuIl19