"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomActionRegistration = void 0;
const codepipeline = require("@aws-cdk/aws-codepipeline");
const cdk = require("@aws-cdk/core");
/**
 * The resource representing registering a custom Action with CodePipeline.
 * For the Action to be usable, it has to be registered for every region and every account it's used in.
 * In addition to this class, you should most likely also provide your clients a class
 * representing your custom Action, extending the Action class,
 * and taking the `actionProperties` as properly typed, construction properties.
 */
class CustomActionRegistration extends cdk.Construct {
    constructor(parent, id, props) {
        super(parent, id);
        new codepipeline.CfnCustomActionType(this, 'Resource', {
            category: props.category,
            inputArtifactDetails: {
                minimumCount: props.artifactBounds.minInputs,
                maximumCount: props.artifactBounds.maxInputs,
            },
            outputArtifactDetails: {
                minimumCount: props.artifactBounds.minOutputs,
                maximumCount: props.artifactBounds.maxOutputs,
            },
            provider: props.provider,
            version: props.version || '1',
            settings: {
                entityUrlTemplate: props.entityUrl,
                executionUrlTemplate: props.executionUrl,
            },
            configurationProperties: props.actionProperties === undefined ? undefined : props.actionProperties.map((ap) => {
                return {
                    key: ap.key || false,
                    secret: ap.secret || false,
                    ...ap,
                };
            }),
        });
    }
}
exports.CustomActionRegistration = CustomActionRegistration;
//# sourceMappingURL=data:application/json;base64,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