"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = void 0;
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
/**
 * Low-level class for generic CodePipeline Actions.
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @experimental
 */
class Action {
    constructor(actionProperties) {
        this.variableReferenced = false;
        this.customerProvidedNamespace = actionProperties.variablesNamespace;
        this.namespaceOrToken = core_1.Lazy.stringValue({ produce: () => {
                // make sure the action was bound (= added to a pipeline)
                if (this.actualNamespace !== undefined) {
                    return this.customerProvidedNamespace !== undefined
                        // if a customer passed a namespace explicitly, always use that
                        ? this.customerProvidedNamespace
                        // otherwise, only return a namespace if any variable was referenced
                        : (this.variableReferenced ? this.actualNamespace : undefined);
                }
                else {
                    throw new Error(`Cannot reference variables of action '${this.actionProperties.actionName}', ` +
                        'as that action was never added to a pipeline');
                }
            } });
        this.actionProperties = {
            ...actionProperties,
            variablesNamespace: this.namespaceOrToken,
        };
    }
    bind(scope, stage, options) {
        this._pipeline = stage.pipeline;
        this._stage = stage;
        this._scope = scope;
        this.actualNamespace = this.customerProvidedNamespace === undefined
            // default a namespace name, based on the stage and action names
            ? `${stage.stageName}_${this.actionProperties.actionName}_NS`
            : this.customerProvidedNamespace;
        return this.bound(scope, stage, options);
    }
    onStateChange(name, target, options) {
        const rule = new events.Rule(this.scope, name, options);
        rule.addTarget(target);
        rule.addEventPattern({
            detailType: ['CodePipeline Action Execution State Change'],
            source: ['aws.codepipeline'],
            resources: [this.pipeline.pipelineArn],
            detail: {
                stage: [this.stage.stageName],
                action: [this.actionProperties.actionName],
            },
        });
        return rule;
    }
    variableExpression(variableName) {
        this.variableReferenced = true;
        return `#{${this.namespaceOrToken}.${variableName}}`;
    }
    get pipeline() {
        if (this._pipeline) {
            return this._pipeline;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    get stage() {
        if (this._stage) {
            return this._stage;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    /**
     * Retrieves the Construct scope of this Action.
     * Only available after the Action has been added to a Stage,
     * and that Stage to a Pipeline.
     */
    get scope() {
        if (this._scope) {
            return this._scope;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline first');
        }
    }
}
exports.Action = Action;
//# sourceMappingURL=data:application/json;base64,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