"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunDocumentStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * CommandStep implementation for aws:runDocument
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-rundocument
 */
class RunDocumentStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX];
        this.action = 'aws:runDocument';
        this.stepDocument = props.stepDocument;
        this.documentParameters = props.documentParameters;
    }
    listInputs() {
        const inputs = [
            this.stepDocument.location,
            this.documentParameters,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const inputs = { documentType: this.stepDocument.type };
        inputs.documentPath = this.stepDocument.location;
        if (this.documentParameters != undefined) {
            inputs.documentParameters = this.documentParameters;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.RunDocumentStep = RunDocumentStep;
_a = JSII_RTTI_SYMBOL_1;
RunDocumentStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.RunDocumentStep", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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