"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExecuteScriptStep = exports.ScriptLanguage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const automation_step_1 = require("../automation-step");
// eslint-disable-next-line
const path = require('path');
// eslint-disable-next-line
const os = require('os');
var ScriptLanguage;
(function (ScriptLanguage) {
    ScriptLanguage[ScriptLanguage["PYTHON"] = 0] = "PYTHON";
})(ScriptLanguage = exports.ScriptLanguage || (exports.ScriptLanguage = {}));
/**
 * AutomationStep implementation for aws:executeScript
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-executeScript.html
 */
class ExecuteScriptStep extends automation_step_1.AutomationStep {
    constructor(stage, id, props) {
        super(stage, id, props);
        this.action = 'aws:executeScript';
        this.language = props.language;
        if ((props.fullPathToCode == undefined) == (props.inlineCode == undefined)) {
            throw new Error('Exactly one of "fullPathToCode" or "inlineCode" should be defined');
        }
        this.fullPathToCode = props.fullPathToCode ?? this.toFile(props.inlineCode ?? '');
        this.handlerName = props.handlerName ?? 'script_handler';
        this.outputs = props.outputs ?? [];
        this.inputs = props.inputs ?? [];
        const nonPayloadOutputs = this.outputs.filter(out => !out.selector.startsWith('$.Payload'));
        if (nonPayloadOutputs.length != 0) {
            throw new Error('All script outputs must specify selector starting with "$.Payload", ' +
                `but these did not: ${JSON.stringify(nonPayloadOutputs)}`);
        }
    }
    static getLanguage(runtime) {
        const langugage = ExecuteScriptStep.RUNTIME_TO_LANGUAGE[runtime];
        if (langugage != undefined) {
            return langugage;
        }
        else {
            throw new Error(`Runtime ${runtime} not supported.`);
        }
    }
    toFile(data) {
        const tempDir = path.join(os.tmpdir(), 'tmp' + new Date().getSeconds() + Math.floor(Math.random() * 1000));
        fs.mkdirSync(tempDir);
        const tempFile = path.join(tempDir, 'execution' + this.getFileSuffix());
        fs.writeFileSync(tempFile, data);
        console.log(`Successfully wrote file to ${tempFile}`);
        return tempFile;
    }
    getFileSuffix() {
        switch (this.language) {
            case ScriptLanguage.PYTHON:
                return '.py';
            default:
                throw new Error(`Language ${this.language} not supported.`);
        }
    }
    listOutputs() {
        return this.outputs;
    }
    listInputs() {
        return this.inputs;
    }
    toSsmEntry() {
        const inputPayload = Object.fromEntries(this.listInputs().map(inp => [inp, `{{ ${inp} }}`]));
        return this.prepareSsmEntry({
            Runtime: this.runtime(),
            Handler: this.handlerName,
            Script: fs.readFileSync(this.fullPathToCode, 'utf8'),
            InputPayload: inputPayload,
        });
    }
    /**
       * @returns the SSM associated runtime argument for the language specified
       */
    runtime() {
        const runtimeEntry = Object.entries(ExecuteScriptStep.RUNTIME_TO_LANGUAGE)
            .filter(entry => entry[1] == this.language)[0];
        if (runtimeEntry) {
            return runtimeEntry[0];
        }
        else {
            throw new Error(`Language ${this.language} not supported.`);
        }
    }
}
exports.ExecuteScriptStep = ExecuteScriptStep;
_a = JSII_RTTI_SYMBOL_1;
ExecuteScriptStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.ExecuteScriptStep", version: "0.0.20" };
ExecuteScriptStep.RUNTIME_TO_LANGUAGE = {
    'python3.6': ScriptLanguage.PYTHON,
};
//# sourceMappingURL=data:application/json;base64,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