import { Construct } from 'constructs';
import { Output } from '../../domain/output';
import { AutomationStep, AutomationStepProps } from '../automation-step';
export declare enum ScriptLanguage {
    PYTHON = 0
}
/**
 * Properties for ExecuteScriptStep
 */
export interface ExecuteScriptStepProps extends AutomationStepProps {
    /**
       * (Required) Language used to execute the script.
       */
    readonly language: ScriptLanguage;
    /**
        * Full path to the code to execute. File is parsed to produce yaml/json.
        * Simulation will execute this file using the language specified.
        * Either this OR inclineCode must be provided.
        */
    readonly fullPathToCode?: string;
    /**
        * Inline code to be executed. String will be used to produce function in yaml/json.
        * Simulation will execute the function in this string using the language specified.
        * Either this OR fullPathToCode must be provided.
        */
    readonly inlineCode?: string;
    /**
        * (Optional) Function name in fullPathToCode file to use as entry point for script handler.
        * @default script_handler
        */
    readonly handlerName?: string;
    /**
        * (Optional) Outputs that the function is expected to return.
        * Be sure to prefix the selector for these outputs with "$.Payload." for executeScript step outputs.
        * @default []
        */
    readonly outputs?: Output[];
    /**
        * (Optional) Inputs that the function needs in order to execute.
        * @default []
        */
    readonly inputs: string[];
}
/**
 * AutomationStep implementation for aws:executeScript
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-executeScript.html
 */
export declare class ExecuteScriptStep extends AutomationStep {
    static getLanguage(runtime: string): ScriptLanguage;
    private static readonly RUNTIME_TO_LANGUAGE;
    readonly language: ScriptLanguage;
    readonly fullPathToCode: string;
    readonly handlerName: string;
    readonly outputs: Output[];
    readonly inputs: string[];
    readonly action: string;
    constructor(stage: Construct, id: string, props: ExecuteScriptStepProps);
    private toFile;
    private getFileSuffix;
    listOutputs(): Output[];
    listInputs(): string[];
    toSsmEntry(): {
        [name: string]: any;
    };
    /**
       * @returns the SSM associated runtime argument for the language specified
       */
    private runtime;
}
