"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutomationStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("..");
const data_type_1 = require("../domain/data-type");
const step_1 = require("./step");
const on_failure_1 = require("../interface/on-failure");
/**
 * Parent class for AutomationSteps. These steps are using in an AutomationDocument.
 * You can instantiate steps using the AutomationBuilder for convenience.
 * You can use these steps to simulate their execution (mimics the SSM run) AND to build their yaml/json declaration.
 * Control flow of the subsequent step is determined by the currently executing step.
 * The flow of the execution therefore follows a chain-of-responsibility pattern.
 * The inputs received into a step AND the outputs of previous steps are merged to form inputs of subsequent steps.
 */
class AutomationStep extends step_1.Step {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.maxAttempts = props.maxAttempts ?? AutomationStep.DEFAULT_MAX_ATTEMPTS;
        this.timeoutSeconds = props.timeoutSeconds ?? AutomationStep.DEFAULT_TIMEOUT;
        this.isEnd = props.isEnd ?? false;
        this.onFailure = props.onFailure ?? new on_failure_1.Abort();
        this.onCancel = props.onCancel ?? new on_failure_1.Abort();
    }
    addToDocument(doc) {
        doc.addStep(this);
    }
    prepareSsmEntry(inputs) {
        // Maps maintain insertion order
        const ssmDef = new Map();
        if (this.description) {
            ssmDef.set('description', this.description);
        }
        ssmDef.set('name', this.name);
        ssmDef.set('action', this.action);
        ssmDef.set('inputs', inputs);
        const formattedOutputs = this.listOutputs().map(output => this.formatOutput(output));
        if (this.listOutputs().length > 0) {
            ssmDef.set('outputs', formattedOutputs);
        }
        if (this.isEnd) {
            ssmDef.set('isEnd', true);
        }
        if (this.maxAttempts != AutomationStep.DEFAULT_MAX_ATTEMPTS) {
            ssmDef.set('maxAttempts', this.maxAttempts);
        }
        if (this.timeoutSeconds != AutomationStep.DEFAULT_TIMEOUT) {
            ssmDef.set('timeoutSeconds', this.timeoutSeconds);
        }
        if (!(this.onCancel instanceof on_failure_1.Abort)) {
            ssmDef.set('onCancel', this.onCancel.toSsmValue());
        }
        if (!(this.onFailure instanceof on_failure_1.Abort)) {
            ssmDef.set('onFailure', this.onFailure.toSsmValue());
        }
        const ssmDict = {};
        ssmDef.forEach((value, key) => {
            ssmDict[key] = value;
        });
        return ssmDict;
    }
    /**
       * Formats the provided output into an object that can be used to generate the SSM yaml/json representation.
       */
    formatOutput(output) {
        return {
            Name: output.name,
            Selector: output.selector,
            Type: new data_type_1.DataType(output.outputType).toSsmString(),
        };
    }
    variables() {
        return Object.assign({}, ...this.listOutputs()
            .map(out => ({ [out.name]: new __1.StringVariable(`${this.name}.${out.name}`) })));
    }
}
exports.AutomationStep = AutomationStep;
_a = JSII_RTTI_SYMBOL_1;
AutomationStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.AutomationStep", version: "0.0.20" };
AutomationStep.DEFAULT_TIMEOUT = 3600;
AutomationStep.DEFAULT_MAX_ATTEMPTS = 1;
//# sourceMappingURL=data:application/json;base64,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