"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.isMapList = exports.assertMapList = exports.MapListVariable = exports.HardCodedMapList = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const string_map_variable_1 = require("./string-map-variable");
const variable_1 = require("./variable");
/**
 * A hard-coded map list variable.
 * Used when not dependent on step inputs.
 */
class HardCodedMapList extends variable_1.HardCodedValueBase {
    static of(val) {
        return new HardCodedMapList(val);
    }
    resolveToMapList(inputs) {
        return this.resolve(inputs);
    }
    assertType(value) {
        assertMapList(value);
    }
}
exports.HardCodedMapList = HardCodedMapList;
_a = JSII_RTTI_SYMBOL_1;
HardCodedMapList[_a] = { fqn: "@cdklabs/cdk-ssm-documents.HardCodedMapList", version: "0.0.20" };
/**
 * A map list variable reference.
 * Used to resolve the value from step inputs.
 */
class MapListVariable extends variable_1.GenericVariable {
    static of(reference) {
        return new MapListVariable(reference);
    }
    resolveToMapList(inputs) {
        return this.resolve(inputs);
    }
    assertType(value) {
        assertMapList(value);
    }
}
exports.MapListVariable = MapListVariable;
_b = JSII_RTTI_SYMBOL_1;
MapListVariable[_b] = { fqn: "@cdklabs/cdk-ssm-documents.MapListVariable", version: "0.0.20" };
/**
 * Assert that the given value is a NullableMapList.
 * @param value value to assert
 */
function assertMapList(value) {
    if (!isMapList(value)) {
        throw new Error(`${value} is not a map list`);
    }
}
exports.assertMapList = assertMapList;
/**
 * Whether the given value is a NullableMapList.
 * @param value value to check
 * @returns true if the value is a NullableMapList, otherwise false
 */
function isMapList(value) {
    if (value === null) {
        return true;
    }
    return Array.isArray(value) && value.every(x => string_map_variable_1.isStringMap(x));
}
exports.isMapList = isMapList;
//# sourceMappingURL=data:application/json;base64,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