import { Construct } from 'constructs';
import { Chain } from '..';
import { IChainable, INextable } from '../types';
import { State } from './state';
/**
 * Properties for defining a custom state definition.
 */
export interface CustomStateProps {
    /**
     * Amazon States Language (JSON-based) definition of the state.
     *
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html
     */
    readonly stateJson: {
        [key: string]: any;
    };
}
/**
 * (experimental) State defined by supplying Amazon States Language (ASL) in the state machine.
 *
 * @experimental
 */
export declare class CustomState extends State implements IChainable, INextable {
    /**
     * (experimental) Continuable states of this Chainable.
     *
     * @experimental
     */
    readonly endStates: INextable[];
    /**
     * Amazon States Language (JSON-based) definition of the state
     */
    private readonly stateJson;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CustomStateProps);
    /**
     * (experimental) Continue normal execution with the given state.
     *
     * @experimental
     */
    next(next: IChainable): Chain;
    /**
     * (experimental) Returns the Amazon States Language object for this state.
     *
     * @experimental
     */
    toStateJson(): object;
}
