"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RustFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const lambda = require("aws-cdk-lib/aws-lambda");
const bundling_1 = require("./bundling");
const cargo_1 = require("./cargo");
var bundling_2 = require("./bundling");
Object.defineProperty(exports, "cargoLambdaVersion", { enumerable: true, get: function () { return bundling_2.cargoLambdaVersion; } });
/**
 * A Rust Lambda function
 */
class RustFunction extends lambda.Function {
    constructor(scope, packageName, props) {
        const manifestPath = cargo_1.getCargoManifestPath(props?.manifestPath ?? 'Cargo.toml');
        const runtime = lambda.Runtime.PROVIDED_AL2;
        const bundling = props?.bundling ?? {};
        super(scope, packageName, {
            ...props,
            runtime,
            code: bundling_1.Bundling.bundle({
                ...bundling,
                packageName,
                manifestPath,
                binaryName: props?.binaryName,
            }),
            handler: 'bootstrap',
        });
    }
}
exports.RustFunction = RustFunction;
_a = JSII_RTTI_SYMBOL_1;
RustFunction[_a] = { fqn: "cargo-lambda-cdk.RustFunction", version: "0.0.7" };
//# sourceMappingURL=data:application/json;base64,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