/// <reference types="node" />
import * as cdk from 'aws-cdk-lib';
import { Architecture, AssetCode } from 'aws-cdk-lib/aws-lambda';
import { BundlingOptions } from './types';
/**
 * Options for bundling
 */
export interface BundlingProps extends BundlingOptions {
    /**
     * Name of the Cargo package that you're trying to build.
     *
     * This option is used to locate the bootstrap file if you don't provide a binaryName option.
     */
    readonly packageName: string;
    /**
     * Path to a directory containing your Cargo.toml file, or to your Cargo.toml directly.
     *
     * This will accept either a directory path containing a `Cargo.toml` file
     * or a filepath to your `Cargo.toml` file (i.e. `path/to/Cargo.toml`).
     *
     * This will be used as the source of the volume mounted in the Docker
     * container and will be the directory where it will run `cargo lambda build` from.
     *
     */
    readonly manifestPath: string;
    /**
     * The system architecture of the lambda function
     */
    readonly architecture?: Architecture;
    /**
     * The name of the binary to build, in case that's different than the package's name.
     */
    readonly binaryName?: string;
    /**
     * Whether the code to compile is a Lambda Extension or not.
     */
    readonly lambdaExtension?: boolean;
}
interface CommandOptions {
    readonly inputDir: string;
    readonly outputDir: string;
    readonly packageName?: string;
    readonly binaryName?: string;
    readonly osPlatform: NodeJS.Platform;
    readonly architecture?: Architecture;
    readonly lambdaExtension?: boolean;
}
/**
 * Bundling
 */
export declare class Bundling implements cdk.BundlingOptions {
    readonly projectRoot: string;
    private readonly props;
    static bundle(options: BundlingProps): AssetCode;
    static clearRunsLocallyCache(): void;
    private static runsLocally?;
    readonly image: cdk.DockerImage;
    readonly command: string[];
    readonly environment?: {
        [key: string]: string;
    };
    readonly local?: cdk.ILocalBundling;
    constructor(projectRoot: string, props: BundlingProps);
    createBundlingCommand(props: CommandOptions): string;
}
export declare function cargoLambdaVersion(): boolean | undefined;
export {};
