import * as cdk from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as rds from '@aws-cdk/aws-rds';
export interface SqlServerSeederProps {
    readonly vpc: ec2.IVpc;
    readonly database: rds.DatabaseInstance;
    readonly port: number;
    readonly createScriptPath: string;
    readonly deleteScriptPath?: string;
    /**
     * The amount of memory, in MB, that is allocated to custom resource's Lambda function.
     * May require some tweaking for "hunger" SQL scripts.
     * @default 512
     */
    readonly memorySize?: number;
    /**
     * Flag that allows to ignore SQL errors.
     * May be helpful during troubleshooting.
     * @default false
     */
    readonly ignoreSqlErrors?: boolean;
}
export declare class SqlServerSeeder extends cdk.Construct {
    constructor(scope: cdk.Construct, id: string, props: SqlServerSeederProps);
    private prepareSqlScripts;
}
