/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replicationhttp.v0_6;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.common.RunnableTask;
import org.openstreetmap.osmosis.replication.common.ServerStateReader;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.ReplicationDataServerChannelPipelineFactory;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceClient;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceClientRestartManager;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceNumberClientChannelPipelineFactory;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceNumberClientListener;
import org.openstreetmap.osmosis.replicationhttp.v0_6.impl.SequenceServer;

public class ReplicationDataServer
implements RunnableTask {
    private int notificationPort;
    private File dataDirectory;
    private int port;

    public ReplicationDataServer(int notificationPort, File dataDirectory, int port) {
        this.notificationPort = notificationPort;
        this.dataDirectory = dataDirectory;
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    private long getCurrentSequenceNumber() {
        try {
            return new ServerStateReader().getServerState(this.dataDirectory.toURI().toURL()).getSequenceNumber();
        }
        catch (MalformedURLException e) {
            throw new OsmosisRuntimeException("Unable to get the current sequence number", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        final SequenceServer server = new SequenceServer(this.port, new ReplicationDataServerChannelPipelineFactory(this.dataDirectory));
        SequenceNumberClientListener numberListener = new SequenceNumberClientListener(){

            @Override
            public void notifySequenceNumber(long sequenceNumber) {
                server.update(sequenceNumber);
            }
        };
        SequenceClientRestartManager clientRestartManager = new SequenceClientRestartManager();
        SequenceNumberClientChannelPipelineFactory channelPipelineFactory = new SequenceNumberClientChannelPipelineFactory(clientRestartManager.getControl(), numberListener, "localhost");
        SequenceClient client = new SequenceClient(new InetSocketAddress(this.notificationPort), channelPipelineFactory);
        try {
            server.start(this.getCurrentSequenceNumber());
            this.port = server.getPort();
            clientRestartManager.manageClient(client);
        }
        finally {
            server.stop();
        }
    }
}

