/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.lifecycle.Closeable;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.CopyFileset;

public class TempCopyFileset
implements CopyFileset,
Closeable {
    private static final Logger LOG = Logger.getLogger(TempCopyFileset.class.getName());
    private ArrayList<File> tmpFiles = new ArrayList();
    private File userFile;
    private File nodeFile;
    private File wayFile;
    private File wayNodeFile;
    private File relationFile;
    private File relationMemberFile;
    private boolean initialized = false;

    private File createTempFile(String suffix) {
        try {
            File tmpFile = File.createTempFile("copy", suffix);
            this.tmpFiles.add(tmpFile);
            return tmpFile;
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to create COPY temp file.", (Throwable)e);
        }
    }

    private void initialize() {
        if (!this.initialized) {
            this.userFile = this.createTempFile("u");
            this.nodeFile = this.createTempFile("n");
            this.wayFile = this.createTempFile("w");
            this.wayNodeFile = this.createTempFile("wn");
            this.relationFile = this.createTempFile("r");
            this.relationMemberFile = this.createTempFile("rm");
            this.initialized = true;
        }
    }

    @Override
    public File getNodeFile() {
        this.initialize();
        return this.nodeFile;
    }

    @Override
    public File getRelationFile() {
        this.initialize();
        return this.relationFile;
    }

    @Override
    public File getRelationMemberFile() {
        this.initialize();
        return this.relationMemberFile;
    }

    @Override
    public File getUserFile() {
        this.initialize();
        return this.userFile;
    }

    @Override
    public File getWayFile() {
        this.initialize();
        return this.wayFile;
    }

    @Override
    public File getWayNodeFile() {
        this.initialize();
        return this.wayNodeFile;
    }

    public void close() {
        for (File tmpFile : this.tmpFiles) {
            if (tmpFile.delete()) continue;
            LOG.warning("Unable to delete file " + tmpFile);
        }
        this.tmpFiles.clear();
        this.initialized = false;
    }
}

