/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.pipeline.common;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.common.TaskRunner;

public abstract class ActiveTaskManager
extends TaskManager {
    private static final Logger LOG = Logger.getLogger(ActiveTaskManager.class.getName());
    private TaskRunner thread;

    protected ActiveTaskManager(String taskId, Map<String, String> pipeArgs) {
        super(taskId, pipeArgs);
    }

    protected abstract Runnable getTask();

    @Override
    public void execute() {
        LOG.fine("Launching task " + this.getTaskId() + " in a new thread.");
        if (this.thread != null) {
            throw new OsmosisRuntimeException("Task " + this.getTaskId() + " is already running.");
        }
        this.thread = new TaskRunner(this.getTask(), "Thread-" + this.getTaskId());
        this.thread.start();
    }

    @Override
    public boolean waitForCompletion() {
        LOG.fine("Waiting for task " + this.getTaskId() + " to complete.");
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                LOG.log(Level.WARNING, "The wait for task completion was interrupted.", e);
            }
            boolean successful = this.thread.isSuccessful();
            if (!successful) {
                LOG.log(Level.SEVERE, "Thread for task " + this.getTaskId() + " failed", this.thread.getException());
            }
            this.thread = null;
            return successful;
        }
        return true;
    }
}

