from __future__ import annotations
from kdsl.bases import OMIT, OmitEnum
from typing import Union, Mapping, Literal
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    import kdsl.apps.v1beta2


def optional_mlist_converter_DeploymentConditionItem(
    value: Union[
        Mapping[str, kdsl.apps.v1beta2.DeploymentConditionItemUnion], OmitEnum, None
    ]
) -> Union[Mapping[str, kdsl.apps.v1beta2.DeploymentConditionItem], OmitEnum, None]:
    if value is None:
        return None
    elif value is OMIT:
        return OMIT
    else:
        return {
            k: required_converter_DeploymentConditionItem(v) for k, v in value.items()
        }


def required_converter_DaemonSetSpec(
    value: kdsl.apps.v1beta2.DaemonSetSpecUnion,
) -> kdsl.apps.v1beta2.DaemonSetSpec:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.DaemonSetSpec(**value) if isinstance(value, dict) else value
    )


def required_converter_DeploymentStrategy(
    value: kdsl.apps.v1beta2.DeploymentStrategyUnion,
) -> kdsl.apps.v1beta2.DeploymentStrategy:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.DeploymentStrategy(**value)
        if isinstance(value, dict)
        else value
    )


def optional_converter_ReplicaSetConditionItem(
    value: Union[kdsl.apps.v1beta2.ReplicaSetConditionItemUnion, OmitEnum, None]
) -> Union[kdsl.apps.v1beta2.ReplicaSetConditionItem, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.ReplicaSetConditionItem(**value)
        if isinstance(value, dict)
        else value
    )


def required_converter_ReplicaSetStatus(
    value: kdsl.apps.v1beta2.ReplicaSetStatusUnion,
) -> kdsl.apps.v1beta2.ReplicaSetStatus:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.ReplicaSetStatus(**value)
        if isinstance(value, dict)
        else value
    )


def required_converter_DeploymentStatus(
    value: kdsl.apps.v1beta2.DeploymentStatusUnion,
) -> kdsl.apps.v1beta2.DeploymentStatus:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.DeploymentStatus(**value)
        if isinstance(value, dict)
        else value
    )


def required_converter_DaemonSetStatus(
    value: kdsl.apps.v1beta2.DaemonSetStatusUnion,
) -> kdsl.apps.v1beta2.DaemonSetStatus:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.DaemonSetStatus(**value) if isinstance(value, dict) else value
    )


def required_converter_StatefulSetSpec(
    value: kdsl.apps.v1beta2.StatefulSetSpecUnion,
) -> kdsl.apps.v1beta2.StatefulSetSpec:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.StatefulSetSpec(**value) if isinstance(value, dict) else value
    )


def required_converter_DeploymentSpec(
    value: kdsl.apps.v1beta2.DeploymentSpecUnion,
) -> kdsl.apps.v1beta2.DeploymentSpec:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.DeploymentSpec(**value) if isinstance(value, dict) else value
    )


def required_converter_DaemonSetUpdateStrategy(
    value: kdsl.apps.v1beta2.DaemonSetUpdateStrategyUnion,
) -> kdsl.apps.v1beta2.DaemonSetUpdateStrategy:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.DaemonSetUpdateStrategy(**value)
        if isinstance(value, dict)
        else value
    )


def optional_converter_StatefulSetUpdateStrategy(
    value: Union[kdsl.apps.v1beta2.StatefulSetUpdateStrategyUnion, OmitEnum, None]
) -> Union[kdsl.apps.v1beta2.StatefulSetUpdateStrategy, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.StatefulSetUpdateStrategy(**value)
        if isinstance(value, dict)
        else value
    )


def optional_mlist_converter_ReplicaSetConditionItem(
    value: Union[
        Mapping[str, kdsl.apps.v1beta2.ReplicaSetConditionItemUnion], OmitEnum, None
    ]
) -> Union[Mapping[str, kdsl.apps.v1beta2.ReplicaSetConditionItem], OmitEnum, None]:
    if value is None:
        return None
    elif value is OMIT:
        return OMIT
    else:
        return {
            k: required_converter_ReplicaSetConditionItem(v) for k, v in value.items()
        }


def optional_converter_RollingUpdateDeployment(
    value: Union[kdsl.apps.v1beta2.RollingUpdateDeploymentUnion, OmitEnum, None]
) -> Union[kdsl.apps.v1beta2.RollingUpdateDeployment, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.RollingUpdateDeployment(**value)
        if isinstance(value, dict)
        else value
    )


def required_converter_ReplicaSetSpec(
    value: kdsl.apps.v1beta2.ReplicaSetSpecUnion,
) -> kdsl.apps.v1beta2.ReplicaSetSpec:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.ReplicaSetSpec(**value) if isinstance(value, dict) else value
    )


def required_converter_DeploymentConditionItem(
    value: kdsl.apps.v1beta2.DeploymentConditionItemUnion,
) -> kdsl.apps.v1beta2.DeploymentConditionItem:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.DeploymentConditionItem(**value)
        if isinstance(value, dict)
        else value
    )


def required_converter_RollingUpdateDaemonSet(
    value: kdsl.apps.v1beta2.RollingUpdateDaemonSetUnion,
) -> kdsl.apps.v1beta2.RollingUpdateDaemonSet:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.RollingUpdateDaemonSet(**value)
        if isinstance(value, dict)
        else value
    )


def optional_converter_DaemonSetSpec(
    value: Union[kdsl.apps.v1beta2.DaemonSetSpecUnion, OmitEnum, None]
) -> Union[kdsl.apps.v1beta2.DaemonSetSpec, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.DaemonSetSpec(**value) if isinstance(value, dict) else value
    )


def optional_converter_DeploymentStrategy(
    value: Union[kdsl.apps.v1beta2.DeploymentStrategyUnion, OmitEnum, None]
) -> Union[kdsl.apps.v1beta2.DeploymentStrategy, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.DeploymentStrategy(**value)
        if isinstance(value, dict)
        else value
    )


def required_converter_DaemonSetConditionItem(
    value: kdsl.apps.v1beta2.DaemonSetConditionItemUnion,
) -> kdsl.apps.v1beta2.DaemonSetConditionItem:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.DaemonSetConditionItem(**value)
        if isinstance(value, dict)
        else value
    )


def optional_converter_DaemonSetStatus(
    value: Union[kdsl.apps.v1beta2.DaemonSetStatusUnion, OmitEnum, None]
) -> Union[kdsl.apps.v1beta2.DaemonSetStatus, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.DaemonSetStatus(**value) if isinstance(value, dict) else value
    )


def optional_converter_StatefulSetSpec(
    value: Union[kdsl.apps.v1beta2.StatefulSetSpecUnion, OmitEnum, None]
) -> Union[kdsl.apps.v1beta2.StatefulSetSpec, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.StatefulSetSpec(**value) if isinstance(value, dict) else value
    )


def optional_converter_DaemonSetUpdateStrategy(
    value: Union[kdsl.apps.v1beta2.DaemonSetUpdateStrategyUnion, OmitEnum, None]
) -> Union[kdsl.apps.v1beta2.DaemonSetUpdateStrategy, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.DaemonSetUpdateStrategy(**value)
        if isinstance(value, dict)
        else value
    )


def required_converter_StatefulSetStatus(
    value: kdsl.apps.v1beta2.StatefulSetStatusUnion,
) -> kdsl.apps.v1beta2.StatefulSetStatus:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.StatefulSetStatus(**value)
        if isinstance(value, dict)
        else value
    )


def required_converter_RollingUpdateStatefulSetStrategy(
    value: kdsl.apps.v1beta2.RollingUpdateStatefulSetStrategyUnion,
) -> kdsl.apps.v1beta2.RollingUpdateStatefulSetStrategy:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.RollingUpdateStatefulSetStrategy(**value)
        if isinstance(value, dict)
        else value
    )


def optional_converter_ReplicaSetStatus(
    value: Union[kdsl.apps.v1beta2.ReplicaSetStatusUnion, OmitEnum, None]
) -> Union[kdsl.apps.v1beta2.ReplicaSetStatus, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.ReplicaSetStatus(**value)
        if isinstance(value, dict)
        else value
    )


def optional_converter_DeploymentStatus(
    value: Union[kdsl.apps.v1beta2.DeploymentStatusUnion, OmitEnum, None]
) -> Union[kdsl.apps.v1beta2.DeploymentStatus, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.DeploymentStatus(**value)
        if isinstance(value, dict)
        else value
    )


def required_converter_StatefulSetConditionItem(
    value: kdsl.apps.v1beta2.StatefulSetConditionItemUnion,
) -> kdsl.apps.v1beta2.StatefulSetConditionItem:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.StatefulSetConditionItem(**value)
        if isinstance(value, dict)
        else value
    )


def optional_converter_DeploymentSpec(
    value: Union[kdsl.apps.v1beta2.DeploymentSpecUnion, OmitEnum, None]
) -> Union[kdsl.apps.v1beta2.DeploymentSpec, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.DeploymentSpec(**value) if isinstance(value, dict) else value
    )


def optional_mlist_converter_DaemonSetConditionItem(
    value: Union[
        Mapping[str, kdsl.apps.v1beta2.DaemonSetConditionItemUnion], OmitEnum, None
    ]
) -> Union[Mapping[str, kdsl.apps.v1beta2.DaemonSetConditionItem], OmitEnum, None]:
    if value is None:
        return None
    elif value is OMIT:
        return OMIT
    else:
        return {
            k: required_converter_DaemonSetConditionItem(v) for k, v in value.items()
        }


def optional_converter_DeploymentConditionItem(
    value: Union[kdsl.apps.v1beta2.DeploymentConditionItemUnion, OmitEnum, None]
) -> Union[kdsl.apps.v1beta2.DeploymentConditionItem, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.DeploymentConditionItem(**value)
        if isinstance(value, dict)
        else value
    )


def optional_converter_ReplicaSetSpec(
    value: Union[kdsl.apps.v1beta2.ReplicaSetSpecUnion, OmitEnum, None]
) -> Union[kdsl.apps.v1beta2.ReplicaSetSpec, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.ReplicaSetSpec(**value) if isinstance(value, dict) else value
    )


def optional_converter_RollingUpdateDaemonSet(
    value: Union[kdsl.apps.v1beta2.RollingUpdateDaemonSetUnion, OmitEnum, None]
) -> Union[kdsl.apps.v1beta2.RollingUpdateDaemonSet, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.RollingUpdateDaemonSet(**value)
        if isinstance(value, dict)
        else value
    )


def optional_converter_DaemonSetConditionItem(
    value: Union[kdsl.apps.v1beta2.DaemonSetConditionItemUnion, OmitEnum, None]
) -> Union[kdsl.apps.v1beta2.DaemonSetConditionItem, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.DaemonSetConditionItem(**value)
        if isinstance(value, dict)
        else value
    )


def required_converter_ReplicaSetConditionItem(
    value: kdsl.apps.v1beta2.ReplicaSetConditionItemUnion,
) -> kdsl.apps.v1beta2.ReplicaSetConditionItem:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.ReplicaSetConditionItem(**value)
        if isinstance(value, dict)
        else value
    )


def optional_converter_StatefulSetStatus(
    value: Union[kdsl.apps.v1beta2.StatefulSetStatusUnion, OmitEnum, None]
) -> Union[kdsl.apps.v1beta2.StatefulSetStatus, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.StatefulSetStatus(**value)
        if isinstance(value, dict)
        else value
    )


def optional_converter_RollingUpdateStatefulSetStrategy(
    value: Union[
        kdsl.apps.v1beta2.RollingUpdateStatefulSetStrategyUnion, OmitEnum, None
    ]
) -> Union[kdsl.apps.v1beta2.RollingUpdateStatefulSetStrategy, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.RollingUpdateStatefulSetStrategy(**value)
        if isinstance(value, dict)
        else value
    )


def optional_mlist_converter_StatefulSetConditionItem(
    value: Union[
        Mapping[str, kdsl.apps.v1beta2.StatefulSetConditionItemUnion], OmitEnum, None
    ]
) -> Union[Mapping[str, kdsl.apps.v1beta2.StatefulSetConditionItem], OmitEnum, None]:
    if value is None:
        return None
    elif value is OMIT:
        return OMIT
    else:
        return {
            k: required_converter_StatefulSetConditionItem(v) for k, v in value.items()
        }


def required_converter_StatefulSetUpdateStrategy(
    value: kdsl.apps.v1beta2.StatefulSetUpdateStrategyUnion,
) -> kdsl.apps.v1beta2.StatefulSetUpdateStrategy:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.StatefulSetUpdateStrategy(**value)
        if isinstance(value, dict)
        else value
    )


def optional_converter_StatefulSetConditionItem(
    value: Union[kdsl.apps.v1beta2.StatefulSetConditionItemUnion, OmitEnum, None]
) -> Union[kdsl.apps.v1beta2.StatefulSetConditionItem, OmitEnum, None]:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.StatefulSetConditionItem(**value)
        if isinstance(value, dict)
        else value
    )


def required_converter_RollingUpdateDeployment(
    value: kdsl.apps.v1beta2.RollingUpdateDeploymentUnion,
) -> kdsl.apps.v1beta2.RollingUpdateDeployment:
    import kdsl.apps.v1beta2

    return (
        kdsl.apps.v1beta2.RollingUpdateDeployment(**value)
        if isinstance(value, dict)
        else value
    )
