# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['classopt']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'classopt',
    'version': '0.1.4',
    'description': 'Arguments parser with class for Python, inspired by StructOpt',
    'long_description': '<h1 align="center">Welcome to ClassOpt 👋</h1>\n<p>\n  <img alt="Version" src="https://img.shields.io/badge/version-0.1.4-blue.svg?cacheSeconds=2592000" />\n  <a href="https://github.com/moisutsu/classopt/blob/main/LICENSE" target="_blank">\n    <img alt="License: MIT" src="https://img.shields.io/badge/License-MIT-yellow.svg" />\n  </a>\n  <a href="https://twitter.com/moisutsu" target="_blank">\n    <img alt="Twitter: moisutsu" src="https://img.shields.io/twitter/follow/moisutsu.svg?style=social" />\n  </a>\n</p>\n\n> Arguments parser with class for Python, inspired by [StructOpt](https://github.com/TeXitoi/structopt)\n\n## Install\n\n```sh\npip install classopt\n```\n\n## Usage\n\nImport `ClassOpt` and define the Opt class with decorator.\n\n```python\nfrom classopt import ClassOpt, config\n\n@ClassOpt\nclass Opt:\n    file: str\n    count: int = config(long=True)\n    numbers: list = config(long=True, short=True, nargs="+", type=int)\n    debug: bool = config(long=True, short=True, action="store_true")\n\nif __name__ == "__main__":\n    opt = Opt.from_args()\n    print(opt)\n    print(opt.file)\n```\n\nRun with command line arguments.\n\n```bash\n$ python example.py example.txt --count 5 -n 1 2 3 --debug\nOpt(file=\'example.txt\', count=5, numbers=[1, 2, 3], debug=True)\nexample.txt\n```\nYou can specify most of the arguments to [argparse.ArgumentParser.add_argument](https://docs.python.org/ja/3/library/argparse.html#argparse.ArgumentParser.add_argument) in `config` (except name_or_flags).\n\nYou can also use the long option by default.\n\n```python\nfrom classopt import ClassOpt, config\n\n@ClassOpt(default_long=True)\nclass Opt:\n    file: str = config(long=False)\n    count: int\n    numbers: list = config(nargs="+", type=int)\n    debug: bool = config(action="store_true")\n\nif __name__ == "__main__":\n    opt = Opt.from_args()\n    print(opt)\n```\n\n```bash\n$ python example.py example.py --count 5 --numbers 1 2 3 --debug\nOpt(file=\'example.py\', count=5, numbers=[1, 2, 3], debug=True)\n```\n\n## Run tests\n\n```sh\npoetry run pytest\n```\n\n## Author\n\n👤 **moisutsu**\n\n* Twitter: [@moisutsu](https://twitter.com/moisutsu)\n* Github: [@moisutsu](https://github.com/moisutsu)\n\n## Show your support\n\nGive a ⭐️ if this project helped you!\n\n## 📝 License\n\nCopyright © 2021 [moisutsu](https://github.com/moisutsu).<br />\nThis project is [MIT](https://github.com/moisutsu/classopt/blob/main/LICENSE) licensed.\n\n***\n_This README was generated with ❤️ by [readme-md-generator](https://github.com/kefranabg/readme-md-generator)_\n',
    'author': 'moisutsu',
    'author_email': 'moisutsu@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/moisutsu/classopt',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
