"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeletableBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const empty_bucket_1 = require("./empty-bucket");
class DeletableBucket extends aws_s3_1.Bucket {
    constructor(scope, id, props = {}) {
        const { forceDelete = false } = props;
        super(scope, id, {
            removalPolicy: forceDelete ? aws_cdk_lib_1.RemovalPolicy.DESTROY : undefined,
            ...props,
        });
        if (forceDelete) {
            new empty_bucket_1.EmptyBucket(this, 'EmptyBucket', {
                bucket: this,
            });
        }
    }
}
exports.DeletableBucket = DeletableBucket;
_a = JSII_RTTI_SYMBOL_1;
DeletableBucket[_a] = { fqn: "@cloudcomponents/cdk-deletable-bucket.DeletableBucket", version: "2.1.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVsZXRhYmxlLWJ1Y2tldC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9kZWxldGFibGUtYnVja2V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkNBQTRDO0FBQzVDLCtDQUF5RDtBQUd6RCxpREFBNkM7QUFPN0MsTUFBYSxlQUFnQixTQUFRLGVBQU07SUFDekMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUE4QixFQUFFO1FBQ3hFLE1BQU0sRUFBRSxXQUFXLEdBQUcsS0FBSyxFQUFFLEdBQUcsS0FBSyxDQUFDO1FBQ3RDLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsYUFBYSxFQUFFLFdBQVcsQ0FBQyxDQUFDLENBQUMsMkJBQWEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLFNBQVM7WUFDOUQsR0FBRyxLQUFLO1NBQ1QsQ0FBQyxDQUFDO1FBRUgsSUFBSSxXQUFXLEVBQUU7WUFDZixJQUFJLDBCQUFXLENBQUMsSUFBSSxFQUFFLGFBQWEsRUFBRTtnQkFDbkMsTUFBTSxFQUFFLElBQUk7YUFDYixDQUFDLENBQUM7U0FDSjtJQUNILENBQUM7O0FBYkgsMENBY0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBSZW1vdmFsUG9saWN5IH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQnVja2V0LCBCdWNrZXRQcm9wcyB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1zMyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuaW1wb3J0IHsgRW1wdHlCdWNrZXQgfSBmcm9tICcuL2VtcHR5LWJ1Y2tldCc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgRGVsZXRhYmxlQnVja2V0UHJvcHMgZXh0ZW5kcyBCdWNrZXRQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZm9yY2VEZWxldGU/OiBib29sZWFuO1xufVxuXG5leHBvcnQgY2xhc3MgRGVsZXRhYmxlQnVja2V0IGV4dGVuZHMgQnVja2V0IHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IERlbGV0YWJsZUJ1Y2tldFByb3BzID0ge30pIHtcbiAgICBjb25zdCB7IGZvcmNlRGVsZXRlID0gZmFsc2UgfSA9IHByb3BzO1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgcmVtb3ZhbFBvbGljeTogZm9yY2VEZWxldGUgPyBSZW1vdmFsUG9saWN5LkRFU1RST1kgOiB1bmRlZmluZWQsXG4gICAgICAuLi5wcm9wcyxcbiAgICB9KTtcblxuICAgIGlmIChmb3JjZURlbGV0ZSkge1xuICAgICAgbmV3IEVtcHR5QnVja2V0KHRoaXMsICdFbXB0eUJ1Y2tldCcsIHtcbiAgICAgICAgYnVja2V0OiB0aGlzLFxuICAgICAgfSk7XG4gICAgfVxuICB9XG59XG4iXX0=