from pydantic import Field

from paymentech.resources.base import PaymentechResource


class Order(PaymentechResource):
    order_id: str = Field(alias="OrderID", max_length=22)
    industry_type: str = Field(alias="IndustryType", default="EC", max_length=2)
    message_type: str = Field(alias="MessageType", default="AC", max_length=2)
    payment_action: str = Field(alias="PaymentActionInd", max_length=1)
    terminal_id: str = Field(alias="TerminalID", default="001", max_length=3)
    card_brand: str = Field(alias="CardBrand", max_length=2)
    account_number: str = Field(alias="AccountNum", max_length=19)
    expiration: str = Field(alias="Exp", max_length=6)
    currency_code: str = Field(alias="CurrencyCode", default="840", max_length=3)
    currency_exponent: str = Field(alias="CurrencyExponent", default="2", max_length=6)
    card_security_indicator: str = Field(alias="CardSecValInd", max_length=1)
    card_security_value: str = Field(alias="CardSecVal", max_length=4)
    bank_routing_number: str = Field(alias="BCRtNum", max_length=9)
    check_dda: str = Field(alias="CheckDDA", max_length=17)
    bank_account_type: str = Field(alias="BankAccountType", max_length=1)
    ecp_authorization_method: str = Field(alias="ECPAuthMethod", default="I", max_length=1)
    ecp_payment_delivery_method: str = Field(alias="BankPmtDelv", default="B", max_length=1)
    ecp_action_code: str = Field(alias="ECPActionCode", max_length=2)
    ecp_check_serial_number: str = Field(alias="ECPCheckSerialNumber", max_length=9)
    ecp_terminal_city: str = Field(alias="ECPTerminalCity", max_length=4)
    ecp_terminal_state: str = Field(alias="ECPTerminalState", max_length=2)
    ecp_image_reference: str = Field(alias="ECPImageReferenceNumber", max_length=32)
    customer_email: str = Field(alias="CustomerEmail", max_length=50)
    customer_email_type: str = Field(alias="EmailAddressSubtype", max_length=1)
    customer_browser_name: str = Field(alias="CustomerBrowserName", max_length=60)
    customer_ip_address: str = Field(alias="CustomerIpAddress", max_length=45)
    address1: str = Field(alias="AVSaddress1", max_length=30)
    address2: str = Field(alias="AVSaddress2", max_length=30)
    city: str = Field(alias="AVScity", max_length=20)
    state: str = Field(alias="AVSstate", max_length=2)
    zip: str = Field(alias="AVSzip", max_length=10)
    phone_number: str = Field(alias="AVSphoneNum", max_length=14)
    phone_number_type: str = Field(alias="AVSPhoneType", max_length=1)
    cardholder_name: str = Field(alias="AVSname")
    country_code: str = Field(alias="AVScountryCode", default="US", max_length=2)
    shipping_method: str = Field(alias="ShippingMethod", max_length=1)
    destination_zip: str = Field(alias="AVSDestzip", max_length=10)
    destination_address1: str = Field(alias="AVSDestzip", max_length=30)
    destination_address2: str = Field(alias="AVSDestaddress2", max_length=28)
    destination_city: str = Field(alias="AVSDestcity", max_length=20)
    destination_state: str = Field(alias="AVSDeststate", max_length=2)
    destination_phone_number: str = Field(alias="AVSDestphoneNum", max_length=14)
    destination_phone_type: str = Field(alias="AVSDestPhoneType", max_length=1)
    destination_name: str = Field(alias="AVSDestname", max_length=30)
    destination_country_code: str = Field(alias="AVSDestcountryCode", default="US", max_length=2)
    customer_profile_method: str = Field(alias="CustomerProfileFromOrderInd", max_length=5)
    customer_reference_number: str = Field(alias="CustomerRefNum", max_length=22)
    customer_automatic_number_identification: str = Field(alias="CustomerAni", max_length=10)
    customer_profile_order_override_method: str = Field(
        alias="CustomerProfileOrderOverrideInd", default="NO", max_length=2
    )
    customer_token_indicator: str = Field(alias="DPANInd", max_length=1)
    status: str = Field(alias="Status", max_length=2)
    authentication_eci_indicator: str = Field(alias="AuthenticationECIInd", max_length=2)
    cavv: str = Field(alias="CAVV", max_length=70)
    aav: str = Field(alias="AAV", max_length=32)
    xid: str = Field(alias="XID", max_length=40)
    aevv: str = Field(alias="AEVV", max_length=56)
    prior_authorization_identifier: str = Field(alias="PriorAuthID", max_length=6)
    amount: str = Field(alias="Amount", max_length=12)
    comments: str = Field(alias="Comments", max_length=256)
    shipping_reference: str = Field(alias="ShippingRef", max_length=40)
    tax_type: str = Field(alias="TaxInd", max_length=1)
    tax: str = Field(alias="Tax", max_length=12)
    amex_transaction_advice_addendum1: str = Field(alias="AMEXTranAdvAddn1", max_length=40)
    amex_transaction_advice_addendum2: str = Field(alias="AMEXTranAdvAddn2", max_length=40)
    amex_transaction_advice_addendum3: str = Field(alias="AMEXTranAdvAddn3", max_length=40)
    amex_transaction_advice_addendum4: str = Field(alias="AMEXTranAdvAddn4", max_length=40)
    soft_descriptor_merchant: str = Field(alias="SDMerchantName", max_length=25)
    soft_descriptor_product: str = Field(alias="SDProductDescription", max_length=18)
    soft_descriptor_city: str = Field(alias="SDMerchantCity", max_length=13)
    soft_descriptor_phone: str = Field(alias="SDMerchantPhone", max_length=13)
    soft_descriptor_url: str = Field(alias="SDMerchantURL", max_length=13)
    soft_descriptor_email: str = Field(alias="SDMerchantEmail", max_length=13)
    recurring_indicator: str = Field(alias="RecurringInd", max_length=2)
    euro_debit_country_code: str = Field(alias="EUDDCountryCode", max_length=2)
    euro_debit_bank_sort_code: str = Field(alias="EUDDBankSortCode", max_length=10)
    euro_debit_rib: str = Field(alias="EUDDRibCode", max_length=2)
    biller_reference: str = Field(alias="BillerReferenceNumber", max_length=25)
    managed_billing_type: str = Field(alias="MBType", max_length=1)
    managed_billing_order_id_generation_method: str = Field(alias="MBOrderIdGenerationMethod", max_length=2)
    managed_billing_start_date: str = Field(alias="MBRecurringStartDate", max_length=8)
    managed_billing_end_date: str = Field(alias="MBRecurringEndDate", max_length=8)
    managed_billing_no_end_date: str = Field(alias="MBRecurringNoEndDateFlag", max_length=1)
    managed_billing_max_billings: str = Field(alias="MBRecurringMaxBillings", max_length=6)
    managed_billing_frequency: str = Field(alias="MBRecurringFrequency", max_length=64)
    managed_billing_deferred_bill_date: str = Field(alias="MBDeferredBillDate", max_length=8)
    transaction_reference_number: str = Field(alias="TxRefNum", max_length=40)
    purchase_order_number: str = Field(alias="PCOrderNum", max_length=17)
    purchase_order_name: str = Field(alias="PCDestName", max_length=30)
    purchase_order_address1: str = Field(alias="PCDestAddress1", max_length=30)
    purchase_order_address2: str = Field(alias="PCDestAddress2", max_length=30)
    purchase_order_city: str = Field(alias="PCDestCity", max_length=20)
    purchase_order_state: str = Field(alias="PCDestState", max_length=2)
    purchase_order_zip: str = Field(alias="PCDestZip", max_length=10)
    partial_auth_indicator: str = Field(alias="PartialAuthInd", max_length=1)
    account_updater_eligibility: str = Field(alias="AccountUpdaterEligibility", default="Y", max_length=1)
    use_stored_aav_indicator: str = Field(alias="UseStoredAAVInd", max_length=1)
    # NOTE: Skipping all Level 3 transaction elements and a significant number of other elements for now

    class Config:
        wrapper = "NewOrder"

    def create(self):
        return self.transact()
