# generated by datamodel-codegen:
#   filename:  freeTextSearch-v128.json
#   timestamp: 2025-02-01T15:44:26+00:00
from enum import Enum

from pydantic import Field

from unique_stock_ticker.clients.six.schema import (
    BaseAPIModel,
    BaseResponsePayload,
    Language,
    MarketStatus,
    MarketType,
    MicType,
)


class MarketMatchingDescription(str, Enum):
    BC = "BC"
    MIC = "MIC"
    MARKET_LONG_NAME = "MARKET_LONG_NAME"
    MARKET_SHORT_NAME = "MARKET_SHORT_NAME"
    MARKET_SYMBOL = "MARKET_SYMBOL"
    OTHER = "OTHER"


class FreeTextMarketsSearchHighlightsItem(BaseAPIModel):
    matching_description: MarketMatchingDescription = Field(
        ...,
        description="A human-readable explanation detailing the alignment between the search term and the content of a particular result.",
    )


class FreeTextMarketsSearchHit(BaseAPIModel):
    market_long_name: str | None = Field(
        default=None, description="Market long name."
    )
    market_short_name: str | None = Field(
        default=None, description="Market short name."
    )
    language: Language | None = Field(
        default=None,
        description="Language of the market names according to ISO 639 alpha-2 code.",
    )
    bc: int = Field(
        ...,
        description="Bourse Code (BC) of the market.\nIt represents the SIX Financial Information identifier for exchanges, trading platforms, regulated or non-regulated markets and trade reporting facilities\nas sources of prices and related information.",
    )
    mic: str | None = Field(
        default=None,
        description="Market Identifier Code (MIC) of the market.\nIt is based on ISO 10383 alphanumeric-4 code and represents a universal method of identifying exchanges, trading platforms, regulated or non-regulated markets and trade reporting facilities\nas sources of prices and related information.",
    )
    mic_type: MicType | None = Field(
        default=None,
        description=" Type of Market Identifier Code (MIC) according ISO 10383.",
    )
    market_type: MarketType | None = Field(
        default=None,
        description="Market classification allocated by SIX Financial Information. Present on all markets in the SIX Financial Information database.",
    )
    market_status: MarketStatus | None = Field(
        default=None,
        description="Status Indicating whether a market is active or not.",
    )
    market_symbol: str | None = Field(
        default=None,
        description="SIX Financial Information alphabetical code composed of up to 4 letters identifying exchanges, trading platforms, regulated or non-regulated markets and trade reporting facilities as sources of prices and related information.",
    )
    market_country: str | None = Field(
        default=None,
        description="Country code delivered as ISO 3166 alpha-2 code.",
    )


class FreeTextMarketsSearchItem(BaseAPIModel):
    hit: FreeTextMarketsSearchHit | None = None
    normalized_score: float = Field(
        ...,
        description="A numerical value ranging from 0 to 1, representing the degree of correlation between the search term and a given result. A perfect match results in a score of 1, offering a standardized measure of relevance.",
    )
    highlights: list[FreeTextMarketsSearchHighlightsItem] = Field(
        ...,
        description="A list of descriptions outlining the reasons why a particular search term led to a corresponding match. These highlights provide insights into the contextual relevance of the result.",
    )


class FreeTextMarketsSearchMarkets(BaseAPIModel):
    markets: list[FreeTextMarketsSearchItem] = Field(
        ...,
        description="Search markets by free-text names and by identifiers.",
    )


class FreeTextMarketsSearch(BaseAPIModel):
    free_text_search: FreeTextMarketsSearchMarkets | None = None


class FreeTextMarketsSearchData(BaseAPIModel):
    search: FreeTextMarketsSearch | None = None


class FreeTextMarketsSearchResponsePayload(BaseResponsePayload):
    data: FreeTextMarketsSearchData | None = None
