# generated by datamodel-codegen:
#   filename:  endOfDayHistory-v128.json
#   timestamp: 2025-01-31T15:58:35+00:00
from datetime import date

from pydantic import Field

from unique_stock_ticker.clients.six.schema import (
    BaseAPIModel,
    BaseResponsePayload,
    ListingIdentifierScheme,
    ListingStatus,
    LookupStatus,
)


class EndOfDayHistoryItem(BaseAPIModel):
    session_date: date = Field(
        ...,
        description="Date for which the End-of-Day History prices are valid.",
    )
    open: float | None = Field(
        default=None,
        description="An Open Price is associated with the first transaction of the trade day. If not provided explicitly from a price information provider it is the first trade of the day immediately after the opening auction is completed. If there is no opening auction this will be the first trade of the day during the regular trading session. It is not necessarily a transacted price. The price can be adjusted according to corporate action events historically.",
    )
    high: float | None = Field(
        default=None,
        description="A High is the highest traded price for the security within the current trading session. If not delivered by the price information provider and there is no recorded trade price, it may be computed using the highest ask of the trading session. The price can be adjusted according to corporate action events historically.",
    )
    low: float | None = Field(
        default=None,
        description="A Low is the lowest traded price for the security within the current trading session. If not delivered by the price information provider and there is no recorded trade price, it may be computed using the lowest bid of the trading session. The price can be adjusted according to corporate action events historically.",
    )
    close: float | None = Field(
        default=None,
        description="The Close can either be derived from the final transaction conducted during the day or calculated by the provider. While it may not necessarily match the Last, it consistently reflects the official closing price, serving as a reliable measure of the day's concluding value. The price can be adjusted according to corporate action events historically.",
    )
    closing_bid: float | None = Field(
        default=None,
        description="The Closing Bid indicates the final/closing bid quote specifically identified as such by the provider (whether the exchange recognizes official closing values for quotes or not, i.e. some exchanges provide final quotes but do not official recognize them as official closing) or final quotes as determined by SIX based on the market practice. Generally, for contributors these will be the end of day quotes, while for exchanges it may be the quotes at the closing bell or at the end of the Trade at Last session.",
    )
    closing_ask: float | None = Field(
        default=None,
        description="The Closing Ask indicates the final/closing ask quote specifically identified as such by the provider (whether the exchange recognizes official closing values for quotes or not, i.e. some exchanges provide final quotes but do not official recognize them as official closing) or final quotes as determined by SIX based on the market practice. Generally, for contributors these will be the end of day quotes, while for exchanges it may be the quotes at the closing bell or at the end of the Trade at Last session.",
    )
    close_year: float | None = Field(
        default=None,
        description="The Close Year is the end of the year valuation price determined by SIX. Prices are selected by SIX at the last business day of the year. Subsequent updates valid for the preceding year and reported after 31 December are possible.",
    )
    number_of_trades: float | None = Field(
        default=None,
        description="The Number of Trades is the number of daily transactions during an exchange session. It indicates how many trades are made in a given instrument over a certain period of time. It helps to estimate the liquidity of the particular security and/or detect an unusual activity level on a listing. If no value is available for the current day, the value of the previous generation is delivered.",
    )
    volume: float | None = Field(
        default=None,
        description="Volume is the number of securities traded within the trading session.  It only shows the volume of securities which were traded on-exchange (both on and off-book). The volume can be adjusted according to corporate action events historically. The adjustment factor has to be applied in the opposite direction of the price. E.g. in case of a 2-for-1 split, prices for the securities are being multiplied by the factor 0.5. The volume would be divided by the same factor.",
    )
    volume_total: float | None = Field(
        default=None,
        description="Volume Total is the number of securities traded within the trading session. It shows the volume of securities which were traded on- and off-exchange (both on and off-book). The volume can be adjusted according to corporate action events historically. The adjustment factor has to be applied in the opposite direction of the price. E.g. in case of a 2-for-1 split, prices for the securities are being multiplied by the factor 0.5. The volume would be divided by the same factor.",
    )
    turnover: float | None = Field(
        default=None,
        description="Turnover is the total on-exchange amount traded in the security's currency. This is calculated using volume in units/nominal/contracts multiplied by the current price of each traded unit.",
    )
    turnover_total: float | None = Field(
        default=None,
        description="Turnover Total is the cumulative turnover on- and off-exchange. This is calculated using volume in units/nominal/contracts multiplied by the current price of each traded unit.",
    )
    market_capitalisation: float | None = Field(
        default=None,
        description="The Market Capitalisation refers to the total market value of a company's outstanding shares of stock.",
    )
    yield_to_maturity: float | None = Field(
        default=None,
        description="A Yield to Maturity is the internal rate of return (IRR, overall interest rate) earned by the investor who buys the bond today at the market price, assuming that the bond will be held until maturity, and that all coupon and principal payments will be made on schedule.",
    )
    dividend: float | None = Field(
        default=None,
        description="A Dividend is the distribution of corporate earnings to eligible shareholders. This field represents the latest dividend on ex date. The dividend can be adjusted according to corporate action events historically.",
    )
    dividend_yield: float | None = Field(
        default=None,
        description="A Dividend Yield is the annualized gross yield based on the market price of a share. The dividend amount paid is based on the actual historical regular dividend payments looking back 12 months (trailing dividend method).",
    )
    settlement_price: float | None = Field(
        default=None,
        description="The Settlement Price is the price at which all the open Exchange Traded Derivative contracts are settled in cash on the given day.\nTypically, the settlement price is set by determining the weighted average price over a certain period of trading, typically shortly before the close of the market for Options, Futures and Indices. The price can be adjusted according to corporate action events historically.",
    )
    open_interest: float | None = Field(
        default=None,
        description="The Open Interest is an amount of open Exchange Traded Derivative contracts that are not closed or delivered on a particular day. It indicates the activity of the derivative contracts. The adjustment factor has to be applied in the opposite direction of the price. The Open Interest is to be divided by the factor.",
    )
    vwap: float | None = Field(
        default=None,
        description="The Volume Weighted Average Price (VWAP) is a trading indicator, which averages the ratio between the traded prices and the cumulative traded volume throughout the day. If the market is not yet closed or/and the embargo time has not yet elapsed, the previous generation value is provided.",
    )
    price_earnings_ratio_reported: float | None = Field(
        default=None,
        description="The Price Earnings Ratio Reported is the relationship of the share price to the net profit of the company. It is calculated by dividing the market price of the shares by the reported earnings per share. If the market is not yet closed or/and the embargo time has not yet elapsed, the previous generation value is provided.",
    )
    price_earnings_ratio_estimated: float | None = Field(
        default=None,
        description="The Price Earnings Ratio Estimated is the relationship of the share price to the net profit of the company. It is calculated by dividing the market price of the shares by the estimated earnings per share. If the market is not yet closed or/and the embargo time has not yet elapsed, the previous generation value is provided.",
    )
    implied_volatility: float | None = Field(
        default=None,
        description="The Implied Volatility refers to the market's expectation of the future volatility of an underlying asset. It represents the level of uncertainty or anticipated price fluctuations that market participants believe the asset will experience over a specified period. Higher implied volatility suggests greater expected price swings, while lower implied volatility indicates a calmer or more stable market expectation.",
    )
    historical_volatility30_days: float | None = Field(
        default=None,
        description="The Historical 30 Days Volatility refers to the measure of the price volatility of an underlying asset over a specific historical period of 30 days. It calculates the standard deviation of the asset's prices during that period to gauge the level of volatility experienced by the asset. Historical 30 Days Volatility provides a snapshot price fluctuations, allowing investors to assess the short-term volatility characteristics of the asset and make informed decisions based on the observed historical volatility patterns.",
    )
    historical_volatility90_days: float | None = Field(
        default=None,
        description="The Historical 90 Days Volatility refers to the measure of the price volatility of an underlying asset over a specific historical period of 90 days. It calculates the standard deviation of the asset's prices during that period to gauge the level of volatility experienced by the asset. Historical 90 Days Volatility provides a snapshot price fluctuations, allowing investors to assess the short-term volatility characteristics of the asset and make informed decisions based on the observed historical volatility patterns.",
    )
    historical_volatility180_days: float | None = Field(
        default=None,
        description="The Historical 180 Days Volatility refers to the measure of the price volatility of an underlying asset over a specific historical period of 180 days. It calculates the standard deviation of the asset's prices during that period to gauge the level of volatility experienced by the asset. Historical 180 Days Volatility provides a snapshot price fluctuations, allowing investors to assess the short-term volatility characteristics of the asset and make informed decisions based on the observed historical volatility patterns.",
    )
    historical_volatility250_days: float | None = Field(
        default=None,
        description="The Historical 250 Days Volatility refers to the measure of the price volatility of an underlying asset over a specific historical period of 250 days. It calculates the standard deviation of the asset's prices during that period to gauge the level of volatility experienced by the asset. Historical 180 Days Volatility provides a snapshot price fluctuations, allowing investors to assess the short-term volatility characteristics of the asset and make informed decisions based on the observed historical volatility patterns.",
    )
    accrued_interest: float | None = Field(
        default=None,
        description="The Accrued interest refers to the interest that has accumulated on a fixed-income security but has not yet been paid to the investor.",
    )
    total_expense_ratio: float | None = Field(
        default=None,
        description="The Total Expense Ratio is a measure used in the financial industry to assess the total cost associated with managing and operating an investment fund, such as a mutual fund or exchange-traded fund (ETF). It represents the percentage of a fund's total assets that is used to cover the expenses incurred in managing the fund, including management fees, administrative costs, custody fees, legal and audit fees, and other operational expenses. The price can be adjusted according to corporate action events historically.",
    )
    auction_theoretical_matching_price: float | None = Field(
        default=None,
        description="The Auction Theoretical Matching Price, determined by the provider, is a price at which the maximum volume of orders can be executed at the time of an auction. The Theoretical Matching Price facilitates price discovery and transparency while helping resolve order imbalances. It shows at what price the trading would start if the order book was opened immediately.\nNote that in some markets this price could be called Indicative Match Price, Equilibrium Price, etc.",
    )
    duration: float | None = Field(
        default=None,
        description="The Duration represents the weighted average time (in years) it takes for an investor to receive the present value of the bond's cash flows, including coupon payments and the return of principal based on the time to maturity. Duration helps assess the price volatility and interest rate risk of fixed-income investments. Generally, higher-duration securities are more sensitive to interest rate changes, while lower-duration securities are less affected by interest rate movements.",
    )
    modified_duration: float | None = Field(
        default=None,
        description="The Modified Duration represents an adjusted version of the duration that takes into account the bond's yield-to-maturity. Modified duration quantifies the percentage change in the bond's price for a given change in yield based on the time to maturity. It helps investors assess the potential impact of interest rate fluctuations on bond prices and make informed decisions regarding fixed-income investments.",
    )
    convexity: float | None = Field(
        default=None,
        description="The Convexity quantifies how the bond's price  deviates from the linear approximation of duration based on the time to maturity. Positive convexity means that as interest rates decrease, the bond's price increases at an increasing rate, while negative convexity implies that as rates increase, the bond's price decreases at an increasing rate.",
    )
    time_to_maturity: float | None = Field(
        default=None,
        description="The Time To Maturity refers to the remaining length from present day until a financial instrument, such as a bond (in years) or a derivative (in days), reaches its maturity date.",
    )
    yield_to_call: float | None = Field(
        default=None,
        description="The Yield to Call is a financial metric that represents the total return an investor would receive if a callable bond is called or redeemed by the issuer before its scheduled maturity date. It is calculated by considering the bond's current market price, the call price, the remaining time to the call date, and the bond's coupon rate. Exclusively for bonds whose early redemption is expressly possible. Calculation only carried out if the invoice rate is greater than the redemption rate.",
    )
    mid: float | None = Field(
        default=None,
        description="The Mid is the arithmetical mean between the bid and ask price. If not provided by the price information provider, it is internally calcualted by SIX Financial Information. If no value is available for the current day, the value of the previous generation is delivered.",
    )
    annualised_dividend: float | None = Field(
        default=None,
        description="The Annualised Dividend is a calculated value that represents the total sum of distributions, including ordinary dividends and capital gains, made by an entity over the course of one year, retroactively from the ex-date 53 weeks back. It includes announced dividends by the management, providing insight into the entity's regular dividend distribution policy. However, special distributions and bonus dividends are excluded from this calculation.",
    )
    last: float | None = Field(
        default=None,
        description="The Last represents the latest price attained during the main trading session when a financial asset was last traded. The price also serves as a reliable indicator of the most recent price for various asset classes, such as Equities, Bonds, Indices, Funds, Currencies, Reference Prices, Derivatives, and more. The price can be adjusted according to corporate action events historically.\n<br>Deprecation reason: Use 'Close', removed since version '2024-08-01'",
    )


class EndOfDayHistoryLookup(BaseAPIModel):
    listing_short_name: str = Field(
        ..., description="Listing short name with up to 19 characters."
    )
    market_short_name: str = Field(
        ...,
        description="The market short name where the instrument is listed with up to 19 characters.",
    )
    listing_currency: str = Field(
        ...,
        description="The trading currency, as specified by SIX, typically follows the ISO 4217 alpha-3 code. This is shown in the main currency and not in fractional units. For cryptocurrencies, the Cryptocurrency Symbol in Instrument Symbology can be used for reference.",
    )
    listing_status: ListingStatus = Field(
        ...,
        description="This shows the instruments status on the market - it shows if it is listed, suspended, admited to trading, delisted, etc",
    )


class EndOfDayHistoryMarketData(BaseAPIModel):
    end_of_day_history: list[EndOfDayHistoryItem] = Field(
        ..., description="End Of Day History."
    )


class EndOfDayHistoryListingsItem(BaseAPIModel):
    requested_id: str = Field(
        ..., description="The requested entity id used in the request"
    )
    requested_scheme: ListingIdentifierScheme = Field(
        ..., description="The requested scheme used in the request"
    )
    lookup_status: LookupStatus = Field(
        ..., description="Status of the response"
    )
    lookup: EndOfDayHistoryLookup | None = None
    market_data: EndOfDayHistoryMarketData | None = None


class EndOfDayHistoryListingsData(BaseAPIModel):
    listings: list[EndOfDayHistoryListingsItem] | None = None


class EndOfDayHistoryResponsePayload(BaseResponsePayload):
    data: EndOfDayHistoryListingsData | None = None
