from enum import StrEnum


class InstrumentType(StrEnum):
    BOND = "BOND"
    EQUITY = "EQUITY"
    MTN = "MTN"
    INSURANCE_POLICY = "INSURANCE_POLICY"
    STRUCTURED_PRODUCT = "STRUCTURED_PRODUCT"
    TRUST_SHARE = "TRUST_SHARE"
    INTEREST_RATE = "INTEREST_RATE"
    RIGHT = "RIGHT"
    CURRENCY = "CURRENCY"
    TRUST_CERT_FOUNDATION = "TRUST_CERT_FOUNDATION"
    TRUST_CERT_SHARE = "TRUST_CERT_SHARE"
    SAVINGS_BOOK = "SAVINGS_BOOK"
    REPO = "REPO"
    FORWARD_TRANSACTION = "FORWARD_TRANSACTION"
    COMBINED_TRANSACTION = "COMBINED_TRANSACTION"
    FRN = "FRN"
    LEVERAGED_PRODUCT = "LEVERAGED_PRODUCT"
    REPO_BASKET = "REPO_BASKET"
    ETD = "ETD"
    FUTURE = "FUTURE"
    MONEY_MARKET_INSTRUMENT = "MONEY_MARKET_INSTRUMENT"
    COMMODITY = "COMMODITY"
    CONVERTIBLE_BOND = "CONVERTIBLE_BOND"
    INDEX = "INDEX"
    OPTION = "OPTION"
    TECHNICAL_CURRENCY = "TECHNICAL_CURRENCY"
    OTHER = "OTHER"


class InstrumentStatus(StrEnum):
    NOT_YET_ISSUED = "NOT_YET_ISSUED"
    INACTIVE = "INACTIVE"
    IN_LIQUIDATION_DISSOLUTION = "IN_LIQUIDATION_DISSOLUTION"
    ACTIVE = "ACTIVE"
    IN_DEFAULT = "IN_DEFAULT"
    OTHER = "OTHER"


class InstrumentUnitType(StrEnum):
    NOMINAL = "NOMINAL"
    PIECE_UNIT = "PIECE_UNIT"
    OTHER = "OTHER"


class CurrentCouponType(StrEnum):
    FIXED = "FIXED"
    VARIABLE = "VARIABLE"
    OPTIONAL_PAYMENT = "OPTIONAL_PAYMENT"
    OTHER = "OTHER"


class MaturityType(StrEnum):
    FIXED_EXPIRATION_OR_EARLIER = "FIXED_EXPIRATION_OR_EARLIER"
    NO_EXPIRATION_DATE = "NO_EXPIRATION_DATE"
    EXPIRATION_FIXED_IN_ADVANCE = "EXPIRATION_FIXED_IN_ADVANCE"
    OTHER = "OTHER"


class ContractType(StrEnum):
    ETD_ON_EQUITY = "ETD_ON_EQUITY"
    ETD_ON_INDEX = "ETD_ON_INDEX"
    ETD_ON_INTEREST = "ETD_ON_INTEREST"
    ETD_ON_CURRENCY = "ETD_ON_CURRENCY"
    ETD_ON_PRECIOUS_METAL = "ETD_ON_PRECIOUS_METAL"
    ETD_ON_FUTURE = "ETD_ON_FUTURE"
    ETD_ON_OPTION = "ETD_ON_OPTION"
    ETD_ON_BASKET = "ETD_ON_BASKET"
    ETD_ON_SWAP = "ETD_ON_SWAP"
    ETD_ON_COMMODITY = "ETD_ON_COMMODITY"
    ETD_ON_BOND = "ETD_ON_BOND"
    ETD_ON_FUND = "ETD_ON_FUND"
    ETD_ON_STRUCTURED_INSTRUMENT = "ETD_ON_STRUCTURED_INSTRUMENT"
    ETD_ON_STRATEGY = "ETD_ON_STRATEGY"
    ETD_ON_DIVIDEND = "ETD_ON_DIVIDEND"
    RELATIVE_PRICE_TRANSACTION_ON_ETD = "RELATIVE_PRICE_TRANSACTION_ON_ETD"
    ETD_ON_EQUITY_TOTAL_RETURN = "ETD_ON_EQUITY_TOTAL_RETURN"
    OTHER = "OTHER"


class OptionType(StrEnum):
    CALL = "CALL"
    PUT = "PUT"
    CONVERSION_RIGHT = "CONVERSION_RIGHT"
    MANDATORY_CONVERSION = "MANDATORY_CONVERSION"
    CONTINGENT_CONVERTIBLES_COCO = "CONTINGENT_CONVERTIBLES_COCO"
    OTHER = "OTHER"


class ExerciseType(StrEnum):
    AMERICAN = "AMERICAN"
    EUROPEAN = "EUROPEAN"
    BERMUDA = "BERMUDA"
    OTHER = "OTHER"


class ContractUnitType(StrEnum):
    NOMINAL = "NOMINAL"
    PIECE_UNIT = "PIECE_UNIT"
    CONTRACT = "CONTRACT"
    PHYSICAL_UNIT = "PHYSICAL_UNIT"
    INDEX_POINT = "INDEX_POINT"
    NOMINAL_CURRENCY_UNIT_PER_INDEX_POINT = (
        "NOMINAL_CURRENCY_UNIT_PER_INDEX_POINT"
    )
    RATIO = "RATIO"
    POUND_LB = "POUND_LB"
    METRIC_TONNE = "METRIC_TONNE"
    GRAM = "GRAM"
    KILOGRAM = "KILOGRAM"
    OUNCE = "OUNCE"
    BUSHEL = "BUSHEL"
    GALLON = "GALLON"
    GIGAWATT_HOURS_GWH = "GIGAWATT_HOURS_GWH"
    CUBIC_METERS_M3 = "CUBIC_METERS_M3"
    SACK = "SACK"
    BARREL = "BARREL"
    TAEL = "TAEL"
    TOLA = "TOLA"
    TROY_OUNCE = "TROY_OUNCE"
    MEGAWATT = "MEGAWATT"
    ARROBA = "ARROBA"
    HUNDREDWEIGHT_CWT = "HUNDREDWEIGHT_CWT"
    MMBTU = "MMBTU"
    BOARD_FOOT = "BOARD_FOOT"
    BAHT = "BAHT"
    KILOWATT_HOURS_KWH = "KILOWATT_HOURS_KWH"
    MEGAWATT_HOURS_MWH = "MEGAWATT_HOURS_MWH"
    OTHER = "OTHER"
