from enum import StrEnum


class EntityType(StrEnum):
    COMPANY = "COMPANY"
    STATE = "STATE"
    PUBLIC_CORPORATION = "PUBLIC_CORPORATION"
    INVESTMENT_FUND = "INVESTMENT_FUND"
    SPECIAL_PURPOSE = "SPECIAL_PURPOSE"
    GOVERNMENT = "GOVERNMENT"
    ASSOCIATION = "ASSOCIATION"
    FOUNDATION = "FOUNDATION"
    BRANCH = "BRANCH"
    OTHER = "OTHER"


class EntityStatus(StrEnum):
    IN_FOUNDATION = "IN_FOUNDATION"
    IN_BANKRUPTCY_PROCEEDINGS = "IN_BANKRUPTCY_PROCEEDINGS"
    UNDER_ADMINISTRATION = "UNDER_ADMINISTRATION"
    INACTIVE = "INACTIVE"
    ACTIVE = "ACTIVE"
    CHAPTER_7 = "CHAPTER_7"
    CHAPTER_11 = "CHAPTER_11"
    IN_LIQUIDATION = "IN_LIQUIDATION"
    IN_DEBT_RESTRUCTURING_LIQUIDATION = "IN_DEBT_RESTRUCTURING_LIQUIDATION"
    IN_CHAPTER_11_LIQUIDATION = "IN_CHAPTER_11_LIQUIDATION"
    OTHER = "OTHER"
