# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['gofilepy']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.0', 'rich>=9.0']

entry_points = \
{'console_scripts': ['gofile = gofilepy:gofile.main',
                     'gofilepy = gofilepy:gofile.main']}

setup_kwargs = {
    'name': 'gofilepy',
    'version': '0.2.2',
    'description': 'Upload files to Gofile.io',
    'long_description': '# gofile\n\n🚀 Python wrapper for gofile.io Upload API[^1].\n\n[![Build](https://github.com/Alyetama/gofile/actions/workflows/poetry-build.yml/badge.svg)](https://github.com/Alyetama/gofile/actions/workflows/poetry-build.yml) [![PyPI version](https://badge.fury.io/py/gofilepy.svg)](https://pypi.org/project/gofilepy/0.2.1) [![Supported Python versions](https://img.shields.io/badge/Python-%3E=3.6-blue.svg)](https://www.python.org/downloads/) [![PEP8](https://img.shields.io/badge/Code%20style-PEP%208-orange.svg)](https://www.python.org/dev/peps/pep-0008/) \n\n\n## Requirements\n- 🐍 [python>=3.6](https://www.python.org/downloads/)\n\n\n## ⬇️ Installation\n\n```sh\npip install gofilepy\n```\n\n\n## ⌨️ Usage\n\n```\n➜ gofile --help\n\nusage: gofile [-h] [-o] [-e] [-vv] [-v] path [path ...]\n\nExample: gofile <file/folder_path>\n\npositional arguments:\n  path             Path to the file(s) and/or folder(s)\n\noptional arguments:\n  -h, --help       show this help message and exit\n  -o, --open-urls  Open the URL(s) in the browser when the upload is complete\n                   (macOS-only)\n  -e, --export     Export upload response(s) to a JSON file\n  -vv, --verbose   Show more information\n  -v, --version    Show program\'s version number and exit\n```\n\n## 📕 Examples\n\n### Example 1: Uploading one file\n```sh\n➜ gofile foo.txt\n╭───────────────────────────────────────────╮\n│ File: foo.txt                             │\n│ Download page: https://gofile.io/d/PkdZP5 │\n╰───────────────────────────────────────────╯\nUploading progress: ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ 100% 0:00:00\n```\n\n### Example 2: Uploading multiple files/directories\n```bash\n➜ gofile foo.txt bar.txt foobar.txt foo/\n╭───────────────────────────────────────────╮\n│ File: foo.txt                             │\n│ Download page: https://gofile.io/d/rLwQVZ │\n╰───────────────────────────────────────────╯\n╭───────────────────────────────────────────╮\n│ File: bar.txt                             │\n│ Download page: https://gofile.io/d/DdS7mZ │\n╰───────────────────────────────────────────╯\n╭───────────────────────────────────────────╮\n│ File: foobar.txt                          │\n│ Download page: https://gofile.io/d/C1VicP │\n╰───────────────────────────────────────────╯\n╭───────────────────────────────────────────╮\n│ File: foo/foo_1.txt                       │\n│ Download page: https://gofile.io/d/CkYw18 │\n╰───────────────────────────────────────────╯\nUploading progress: ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ 100% 0:00:00\n```\n\n### Example 3: Verbose output\n```sh\n➜ gofile foo.txt -vv\n╭──────────────────────────────────────────────────────────────────────────────╮\n│ {                                                                            │\n│   "foo.txt": {                                                               │\n│     "timestamp": "30-05-2022 18:42:15",                                      │\n│     "response": {                                                            │\n│       "status": "ok",                                                        │\n│       "data": {                                                              │\n│         "guestToken": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",                    │\n│         "downloadPage": "https://gofile.io/d/sU4hV1",                        │\n│         "code": "sU4hV1",                                                    │\n│         "parentFolder": "7ad2d249-96a1-4675-b185-05665fbc9a46",              │\n│         "fileId": "0e93e093-d122-4e42-a1be-2e7d34d78ffb",                    │\n│         "fileName": "foo.txt",                                               │\n│         "md5": "d41d8cd98f00b204e9800998ecf8427e"                            │\n│       }                                                                      │\n│     }                                                                        │\n│   }                                                                          │\n│ }                                                                            │\n╰──────────────────────────────────────────────────────────────────────────────╯\nUploading progress: ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ 100% 0:00:00\n```\n\n### Example 4: Exporting the API response to a JSON file\n```sh\n➜ gofile foo.txt -e\n╭───────────────────────────────────────────╮\n│ File: foo.txt                             │\n│ Download page: https://gofile.io/d/8t79Lz │\n╰───────────────────────────────────────────╯\nUploading progress: ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ 100% 0:00:00\nExported data to: gofile_export_1653950555.json\n```\n\n<details>\n  <summary>Content of <code>gofile_export_1653950555.json</code></summary>\n  \n```json\n[\n    {\n        "foo.txt": {\n            "timestamp": "30-05-2022 18:42:35",\n            "response": {\n                "status": "ok",\n                "data": {\n                    "guestToken": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",\n                    "downloadPage": "https://gofile.io/d/8t79Lz",\n                    "code": "8t79Lz",\n                    "parentFolder": "05xd4cb-8965-417f-ae34-a116et99b798",\n                    "fileId": "d1fc3a97-8xe3-486a-bc0d-edb1rb103040",\n                    "fileName": "foo.txt",\n                    "md5": "d41d8cd99f00b204e9810998ecf8427e"\n                }\n            }\n        }\n    }\n]\n```\n</details>\n\n## Misc.\n\n### 🔑 Optional: Saving uploads to your Gofile account\n\nIf you want the files to be uploaded to a specific account, you can export your gofile token, which can be retrieved from the profile page, as an environment variable.\n\n```sh\nexport GOFILE_TOKEN=\'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\'\n```\n\n\n[^1]: **Disclaimer: This tool is not associated with Gofile, WOJTEK SAS ©, or the Gofile Team.**\n',
    'author': 'Mohammad Alyetama',
    'author_email': 'malyetama@pm.me',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
